//=============================================================================
// WeaponTripBomb.
//=============================================================================
class WeaponTripBomb extends TNMWeapon;

var localized String shortName;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
	}
}

function PostBeginPlay()
{
   Super.PostBeginPlay();
   bWeaponStay=False;
}

function Fire(float Value)
{
	// if facing a wall, affix the LAM to the wall
	if (Pawn(Owner) != None)
	{
		if (bNearWall)
		{
			Log("Got Here");
			bReadyToFire = False;
			GotoState('NormalFire');
			bPointing = True;
			PlayAnim('Place',, 0.0);
			return;
		}
	}

	return; // otherwise do nothing.
	Super.Fire(Value);
}

// Become a pickup
// Weapons that carry their ammo with them don't vanish when dropped
function BecomePickup()
{
	Super.BecomePickup();
   if (Level.NetMode != NM_Standalone)
      if (bTossedOut)
         Lifespan = 0.0;
}

// ----------------------------------------------------------------------
// TestMPBeltSpot()
// Returns true if the suggested belt location is ok for the object in mp.
// ----------------------------------------------------------------------

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   return (BeltSpot == 6);
}

//
// Belt and Inventory Icons
//
#exec texture IMPORT NAME=LargeIconTripBomb FILE=Textures\LargeIconTripBomb.pcx GROUP=Skins MIPS=off
#exec texture IMPORT NAME=BeltIconTripBomb FILE=Textures\BeltIconTripBomb.pcx GROUP=Skins MIPS=off

//
// Player View Mesh
//
#exec MESH IMPORT MESH=TripBomb ANIVFILE=MODELS\TripBomb_a.3d DATAFILE=MODELS\TripBomb_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=TripBomb X=6000 Y=0 Z=2000 YAW=64  //(x=+Left/-Right)

#exec mesh SEQUENCE MESH=TripBomb SEQ=All      STARTFRAME=0 NUMFRAMES=54
#exec mesh SEQUENCE MESH=TripBomb SEQ=Still		STARTFRAME=0	NUMFRAMES=1
#exec mesh SEQUENCE MESH=TripBomb SEQ=Select		STARTFRAME=1	NUMFRAMES=6	    RATE=10	GROUP=Select
#exec mesh SEQUENCE MESH=TripBomb SEQ=Attack		STARTFRAME=6	NUMFRAMES=8		RATE=12
#exec mesh SEQUENCE MESH=TripBomb SEQ=Attack2	STARTFRAME=6	NUMFRAMES=8	    	RATE=12
#exec mesh SEQUENCE MESH=TripBomb SEQ=Attack3	STARTFRAME=6	NUMFRAMES=8	     	RATE=12
#exec mesh SEQUENCE MESH=TripBomb SEQ=Down		STARTFRAME=13	NUMFRAMES=5		    RATE=6
#exec mesh SEQUENCE MESH=TripBomb SEQ=PlaceBegin	STARTFRAME=18	NUMFRAMES=5		RATE=8
#exec mesh SEQUENCE MESH=TripBomb SEQ=Place		STARTFRAME=22	NUMFRAMES=5	        RATE=14
#exec mesh SEQUENCE MESH=TripBomb SEQ=PlaceEnd	STARTFRAME=27	NUMFRAMES=6	    	RATE=8
#exec mesh SEQUENCE MESH=TripBomb SEQ=Idle1		STARTFRAME=31	NUMFRAMES=8	    	RATE=2
#exec mesh SEQUENCE MESH=TripBomb SEQ=Idle2		STARTFRAME=38	NUMFRAMES=8	    	RATE=2
#exec mesh SEQUENCE MESH=TripBomb SEQ=Idle3		STARTFRAME=46	NUMFRAMES=8	    	RATE=2

//#exec mesh NOTIFY MESH=TripBomb SEQ=Attack		TIME=0.7	FUNCTION=HandToHandAttack
//#exec mesh NOTIFY MESH=TripBomb SEQ=Attack2		TIME=0.7	FUNCTION=HandToHandAttack
//#exec mesh NOTIFY MESH=TripBomb SEQ=Attack3		TIME=0.7	FUNCTION=HandToHandAttack
#exec mesh NOTIFY MESH=TripBomb SEQ=Place		TIME=0.4	FUNCTION=PlaceGrenade

#exec texture IMPORT NAME=JTripBomb1 FILE=Textures\TripBombTex1.PCX GROUP=Skins // MAIN
#exec texture IMPORT NAME=JTripBomb2 FILE=Textures\TripBombTex2LaserOff.PCX GROUP=Skins // LASER

#exec MESHMAP NEW   MESHMAP=TripBomb MESH=TripBomb
#exec MESHMAP SCALE MESHMAP=TripBomb X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=TripBomb NUM=1 TEXTURE=JTripBomb1
#exec MESHMAP SETTEXTURE MESHMAP=TripBomb NUM=2 TEXTURE=JTripBomb2
#exec MESHMAP SETTEXTURE MESHMAP=TripBomb NUM=3 TEXTURE=Hands

//
// Pickup View
//
#exec mesh IMPORT MESH=tripbombpickup ANIVFILE=MODELS\tripbombpickup_a.3d DATAFILE=MODELS\tripbombpickup_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=tripbombpickup X=0 Y=0 Z=0 YAW=64

#exec MESH SEQUENCE MESH=tripbombpickup SEQ=All            STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=tripbombpickup SEQ=tripbombpickup STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=tripbombpickup MESH=tripbombpickup
#exec MESHMAP SCALE MESHMAP=tripbombpickup X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=tripbombpickup NUM=1 TEXTURE=JTripBomb1
#exec MESHMAP SETTEXTURE MESHMAP=tripbombpickup NUM=2 TEXTURE=JTripBomb2

//
// Third Person View
//
#exec mesh IMPORT MESH=tripbombThird ANIVFILE=MODELS\tripbombpickup_a.3d DATAFILE=MODELS\tripbombpickup_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=tripbombThird X=0 Y=0 Z=0

#exec mesh SEQUENCE MESH=tripbombThird SEQ=All            STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=tripbombThird SEQ=tripbombThird STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP new   MESHMAP=tripbombThird MESH=tripbombThird
#exec MESHMAP scale MESHMAP=tripbombThird X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=tripbombThird NUM=1 TEXTURE=JTripBomb1
#exec MESHMAP SETTEXTURE MESHMAP=tripbombThird NUM=2 TEXTURE=JTripBomb2

defaultproperties
{
     ShortName="Tranqmine"
     LowAmmoWaterMark=2
     GoverningSkill=Class'DeusEx.SkillDemolition'
     EnviroEffective=ENVEFF_All
     Concealability=CONC_All
     ShotTime=0.300000
     reloadTime=0.100000
     HitDamage=50
     maxRange=4800
     AccurateRange=2400
     BaseAccuracy=1.000000
     bHasMuzzleFlash=False
     bHandToHand=True
     bUseAsDrawnWeapon=False
     AITimeLimit=3.500000
     AIFireDelay=5.000000
     bNeedToSetMPPickupAmmo=False
     mpReloadTime=0.100000
     mpHitDamage=50
     mpBaseAccuracy=1.000000
     mpAccurateRange=2400
     mpMaxRange=2400
     AmmoName=Class'tnmitems.AmmoTripB'
     ReloadCount=1
     PickupAmmoCount=1
     FireOffset=(Y=10.000000,Z=20.000000)
     ProjectileClass=Class'tnmitems.TripProj'
     shakemag=50.000000
     SelectSound=Sound'DeusExSounds.Weapons.LAMSelect'
     InventoryGroup=48
     ItemName="Tranquilizer Mine"
     PlayerViewOffset=(X=24.000000,Y=-15.000000,Z=-17.000000)
     PlayerViewMesh=LodMesh'tnmitems.TripBomb'
     PlayerViewScale=0.700000
     PickupViewMesh=LodMesh'tnmitems.tripbombpickup'
     PickupViewScale=0.230000
     ThirdPersonMesh=LodMesh'tnmitems.tripbombThird'
     ThirdPersonScale=0.150000
     Icon=Texture'tnmitems.Skins.BeltIconTripBomb'
     largeIcon=Texture'tnmitems.Skins.LargeIconTripBomb'
     largeIconWidth=35
     largeIconHeight=45
     Description="These devices used to be in widespread usage around Forum City to deter people from entering restricted areas without killing them. When triggered, the mine will discharge a shaped pulse of energy that causes a neurological disruption in any biological creature unfortunate enough to be hit by it. In most cases, these disruptions will quickly subdue the target. Each mine is only charged with enough energy for a limited amount of pulses against detected targets - when the charge is spent, the device powers down and becomes harmless.|n|nUnfortunately, the battery has a tendency to explode in a lethal manner when the device is left too long without maintenance or damaged; most of them were recalled, though some still remain around the city."
     beltDescription="TRANQMINE"
     Mesh=LodMesh'tnmitems.tripbombpickup'
     DrawScale=0.230000
     CollisionRadius=3.800000
     CollisionHeight=3.500000
     Mass=5.000000
     Buoyancy=2.000000
}
