//=============================================================================
// WeaponUniqueAO.
//=============================================================================
class WeaponUniqueAO extends TNMUniqueWeapon;

simulated function renderoverlays(Canvas canvas)
{

      multiskins[6] = none;
      multiskins[5] = none;

   if(bHasScope)
      multiskins[4] = none;
   else
      multiskins[4] = texture'pinkmasktex';

   super.renderoverlays(canvas);
}


function CheckWeaponSkins()
{
	multiskins[6] = none;


	multiskins[5] = none;

	if(bHasScope)
		multiskins[4] = none;
	else
		multiskins[4] = texture'pinkmasktex';

}



simulated function PreBeginPlay()
{
	

	multiskins[6] = none;


	multiskins[5] = none;

	if(bHasScope)
		multiskins[4] = none;
	else
		multiskins[4] = texture'pinkmasktex';

	texture = none; //just in fucking case: looked like you had a lot of torchtex shit going on
	

	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
		ReloadCount = mpReloadCount;
	}
}

// Muzzle Flash Stuff
simulated function SwapMuzzleFlashTexture()
{
     if (!bHasMuzzleFlash)
     return;
       MultiSkins[3] = Texture'DeusExItems.Skins.FlatFXTex34';

     MuzzleFlashLight();
     SetTimer(0.1, False);
}

simulated function EraseMuzzleFlashTexture()
{
     MultiSkins[3] = None;
}

simulated function Timer()
{
     EraseMuzzleFlashTexture();
}

simulated function MuzzleFlashLight()
{
     local Vector offset, X, Y, Z;
     local Effects flash;

      if (!bHasMuzzleFlash)
          return;

     if ((flash != None) && !flash.bDeleteMe)
          flash.LifeSpan = flash.Default.LifeSpan;
     else
     {
          GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
          offset = Owner.Location;
          offset += X * Owner.CollisionRadius * 2;
          flash = spawn(class'Muzzleflash',,, offset);
          if (flash != None)
               flash.SetBase(Owner);
     }
}

//
// Icons
//
#exec texture IMPORT NAME=HDTPLargeIconPistol FILE=Textures\LargeIconPistol.pcx MIPS=off  //LargeIconRifle
#exec texture IMPORT NAME=HDTPBeltIconPistol  FILE=Textures\BeltIconPistol.pcx MIPS=off   //BeltIconRifle


//
// First Person
//
#exec mesh IMPORT MESH=HDTPWeaponPistol ANIVFILE=MODELS\HDTPWeaponPistol_a.3d DATAFILE=MODELS\HDTPWeaponPistol_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec mesh ORIGIN MESH=HDTPWeaponPistol X=8000 Y=-3000 Z=2000 YAW=128

#exec mesh SEQUENCE MESH=HDTPWeaponPistol SEQ=All		STARTFRAME=0	NUMFRAMES=69
#exec mesh SEQUENCE MESH=HDTPWeaponPistol SEQ=Still		STARTFRAME=0	NUMFRAMES=1
#exec mesh SEQUENCE MESH=HDTPWeaponPistol SEQ=Select		STARTFRAME=1	NUMFRAMES=8	RATE=24 GROUP=Select
#exec mesh SEQUENCE MESH=HDTPWeaponPistol SEQ=Shoot		STARTFRAME=8	NUMFRAMES=8	RATE=36
#exec mesh SEQUENCE MESH=HDTPWeaponPistol SEQ=ReloadBegin	STARTFRAME=15	NUMFRAMES=0	RATE=8
#exec mesh SEQUENCE MESH=HDTPWeaponPistol SEQ=Reload		STARTFRAME=15	NUMFRAMES=22	RATE=8
#exec mesh SEQUENCE MESH=HDTPWeaponPistol SEQ=ReloadEnd		STARTFRAME=37	NUMFRAMES=0	RATE=8
#exec mesh SEQUENCE MESH=HDTPWeaponPistol SEQ=Down		STARTFRAME=36	NUMFRAMES=3	RATE=24
#exec mesh SEQUENCE MESH=HDTPWeaponPistol SEQ=Idle1		STARTFRAME=39	NUMFRAMES=8	RATE=4
#exec mesh SEQUENCE MESH=HDTPWeaponPistol SEQ=Idle2		STARTFRAME=46	NUMFRAMES=12	RATE=4
#exec mesh SEQUENCE MESH=HDTPWeaponPistol SEQ=Idle3		STARTFRAME=57	NUMFRAMES=12	RATE=4

#exec mesh NOTIFY MESH=HDTPWeaponPistol SEQ=Shoot	TIME=0.02	FUNCTION=SwapMuzzleFlashTexture

#exec texture IMPORT NAME=HDTPGlockTex1 FILE=Textures\GlockTex1.PCX GROUP=Skins // MUZZLE.TU
#exec texture IMPORT NAME=HDTPGlockTex2 FILE=Textures\GlockTex2.PCX GROUP=Skins // SCOPE
#exec texture IMPORT NAME=HDTPGlockTex3 FILE=Textures\GlockTex3.PCX GROUP=Skins // TORCHLASER

#exec MESHMAP NEW   MESHMAP=HDTPWeaponPistol MESH=HDTPWeaponPistol
#exec MESHMAP scale MESHMAP=HDTPWeaponPistol X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=HDTPWeaponPistol NUM=1 TEXTURE=HDTPGlockTex1
#exec MESHMAP SETTEXTURE MESHMAP=HDTPWeaponPistol NUM=2 TEXTURE=WeaponHandsTex
#exec MESHMAP SETTEXTURE MESHMAP=HDTPWeaponPistol NUM=3 TEXTURE=BlackMaskTex        //Muzzle Flash
#exec MESHMAP SETTEXTURE MESHMAP=HDTPWeaponPistol NUM=4 TEXTURE=HDTPGlockTex2       //Scope
#exec MESHMAP SETTEXTURE MESHMAP=HDTPWeaponPistol NUM=5 TEXTURE=HDTPGlockTex3       //TorchLaser
#exec MESHMAP SETTEXTURE MESHMAP=HDTPWeaponPistol NUM=6 TEXTURE=HDTPGlockTex3       //Silencer
#exec MESHMAP SETTEXTURE MESHMAP=HDTPWeaponPistol NUM=7 TEXTURE=HDTPGlockTex3       //Clip

//
// 3rd Person
//
#exec mesh IMPORT MESH=HDTPGlock3rd ANIVFILE=MODELS\HDTPGlock3rd_a.3d DATAFILE=MODELS\HDTPGlock3rd_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec mesh ORIGIN MESH=HDTPGlock3rd X=500 Y=400 Z=0 PITCH=26

#exec mesh SEQUENCE MESH=HDTPGlock3rd SEQ=All      STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=HDTPGlock3rd SEQ=Still    STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=HDTPGlock3rd SEQ=Shoot    STARTFRAME=0 NUMFRAMES=1  RATE=17

#exec mesh NOTIFY MESH=HDTPGlock3rd SEQ=Shoot	TIME=0.02	FUNCTION=SwapMuzzleFlashTexture

#exec MESHMAP NEW   MESHMAP=HDTPGlock3rd MESH=HDTPGlock3rd
#exec MESHMAP SCALE MESHMAP=HDTPGlock3rd X=0.001171875 Y=0.001171875 Z=0.001171875

#exec MESHMAP SETTEXTURE MESHMAP=HDTPGlock3rd NUM=1 TEXTURE=HDTPGlockTex1
#exec MESHMAP SETTEXTURE MESHMAP=HDTPGlock3rd NUM=2 TEXTURE=none  //This is here just so the nums are correct, hacky I know.
#exec MESHMAP SETTEXTURE MESHMAP=HDTPGlock3rd NUM=3 TEXTURE=BlackMaskTex   //MuxxleFlash
#exec MESHMAP SETTEXTURE MESHMAP=HDTPGlock3rd NUM=4 TEXTURE=HDTPGlockTex2  //Scope
#exec MESHMAP SETTEXTURE MESHMAP=HDTPGlock3rd NUM=5 TEXTURE=HDTPGlockTex3  //Laser
#exec MESHMAP SETTEXTURE MESHMAP=HDTPGlock3rd NUM=6 TEXTURE=HDTPGlockTex3  //Silencer

//
// Pickup mesh
//
#exec mesh IMPORT MESH=HDTPGlockPickup ANIVFILE=MODELS\HDTPGlockPickup_a.3d DATAFILE=MODELS\HDTPGlockPickup_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=HDTPGlockPickup X=0 Y=0 Z=0 YAW=128

#exec MESH SEQUENCE MESH=HDTPGlockPickup SEQ=All         STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=HDTPGlockPickup SEQ=Still       STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=HDTPGlockPickup MESH=HDTPGlockPickup
#exec MESHMAP SCALE MESHMAP=HDTPGlockPickup X=0.001171875 Y=0.001171875 Z=0.001171875

#exec MESHMAP SETTEXTURE MESHMAP=HDTPGlockPickup NUM=1 TEXTURE=HDTPGlockTex1
#exec MESHMAP SETTEXTURE MESHMAP=HDTPGlockPickup NUM=2 TEXTURE=none
#exec MESHMAP SETTEXTURE MESHMAP=HDTPGlockPickUp NUM=3 TEXTURE=BlackMaskTex   //MuxxleFlash
#exec MESHMAP SETTEXTURE MESHMAP=HDTPGlockPickUp NUM=4 TEXTURE=HDTPGlockTex2  //Scope
#exec MESHMAP SETTEXTURE MESHMAP=HDTPGlockPickUp NUM=5 TEXTURE=HDTPGlockTex3  //Laser
#exec MESHMAP SETTEXTURE MESHMAP=HDTPGlockPickUp NUM=6 TEXTURE=HDTPGlockTex3  //Silencer


defaultproperties
{
     LowAmmoWaterMark=6
     GoverningSkill=Class'DeusEx.SkillWeaponPistol'
     EnviroEffective=ENVEFF_Air
     Concealability=CONC_Visual
     reloadTime=2.000000
     HitDamage=14
     maxRange=4800
     AccurateRange=2400
     BaseAccuracy=0.700000
     bCanHaveScope=True
     ScopeFOV=25
     bCanHaveLaser=True
     bCanHaveSilencer=True
     recoilStrength=0.300000
     mpReloadTime=2.000000
     mpHitDamage=20
     mpBaseAccuracy=0.200000
     mpAccurateRange=1200
     mpMaxRange=1200
     mpReloadCount=9
     bCanHaveModBaseAccuracy=True
     bCanHaveModReloadCount=True
     bCanHaveModAccurateRange=True
     bCanHaveModReloadTime=True
     bCanHaveModRecoilStrength=True
     AmmoName=Class'DeusEx.Ammo10mm'
     ReloadCount=6
     PickupAmmoCount=6
     bInstantHit=True
     FireOffset=(X=-22.000000,Y=10.000000,Z=14.000000)
     shakemag=50.000000
     FireSound=Sound'DeusExSounds.Weapons.PistolFire'
     firesilencedsound=Sound'TNMItems.Weapons.SniperFiresilenced'
     CockingSound=Sound'DeusExSounds.Weapons.PistolReload'
     SelectSound=Sound'DeusExSounds.Weapons.PistolSelect'
     InventoryGroup=40
     PickupMessage="You have"
     ItemName="Alpha's Service Pistol"
     ItemArticle="taken"
     PlayerViewOffset=(X=22.000000,Y=-10.000000,Z=-14.000000)
     PlayerViewMesh=LodMesh'HDTPWeaponPistol'
     PickupViewMesh=LodMesh'HDTPGlockPickup'
     PickupViewScale=1.0
     ThirdPersonMesh=LodMesh'HDTPGlock3rd'
     ThirdPersonScale=1.0
     Icon=Texture'HDTPBeltIconPistol'
     largeIcon=Texture'HDTPLargeIconPistol'
     largeIconWidth=46
     largeIconHeight=28
     Description="UNIQUE WEAPON:|nThe old service pistol used by Alpha Operator when he worked for PDXCIS. The pistol has been with him for many years, and he's had plenty of time to tweak the living daylights out of it. This pistol fires faster, more accurately and with less recoil than a standard 10mm. It has also been equipped with a laser. The most radical and unique upgrade, however, is the attachment of a custom-fitted silencer bearing the mark of Andreus and Raving's weapon shop. Unfortunately the silencer decreases the stopping power of the weapon, making it slightly less damaging."
     beltDescription="AO GUN"
     Mesh=LodMesh'HDTPGlockPickup'
     Texture=none
     bhasmuzzleflash=false
     DrawScale=1.0
     CollisionRadius=7.000000
     CollisionHeight=1.000000

     // Handle enhancements
     bHasSilencer=True
     bHasLaser=True
     ShotTime=0.300000 // Default 0.6
     HitDamage=10 // Default 14
     AccuracyMods=3
     RecoilMods=3
     ReloadMods=2
     bReloadAnimHack=True
     genericVersion=class'WeaponTNMPistol'
}
