//=============================================================================
// WeaponUniqueKylie.
//=============================================================================
class WeaponUniqueKylie extends TNMUniqueWeapon;

function DrawAdditionalScope(GC gc, int width, int height)
{
	// Draw the black borders
	gc.SetTileColorRGB(255, 0, 0);
	gc.SetStyle(DSTY_Normal);
	gc.DrawPattern(width/2 - 2, height/2 - 2, 2, 2, 0, 0, Texture'Solid');
}

simulated function PlaySelectiveFiring()
{
     LoopAnim( 'Shoot', 2.25, 0.1 );
}

simulated function PlayFiringSound()
{
	if ( ammoname == class'ammo20mm' )
		PlaySimSound( Sound'AssaultGunFire20mm', SLOT_None, TransientSoundVolume, 2048 );
	else
	{
		if (bHasSilencer)
			PlaySimSound( FireSilencedSound, SLOT_None, TransientSoundVolume, 2048 );
		else
			PlaySimSound( FireSound, SLOT_None, TransientSoundVolume, 2048 );
	}
}

defaultproperties
{
     ScopeType=EScopeType_Custom
     ScopeTexture01=texture'tnmHUDScopeRed01'
     ScopeTexture02=texture'tnmHUDScopeRed02'
     ScopeTexture03=texture'tnmHUDScopeRed03'
     ScopeTexture04=texture'tnmHUDScopeRed04'
     LowAmmoWaterMark=30
     GoverningSkill=Class'DeusEx.SkillWeaponRifle'
     EnviroEffective=ENVEFF_Air
     Concealability=CONC_Visual
     bAutomatic=True
     ShotTime=0.100000
     reloadTime=3.000000
     BaseAccuracy=0.700000
     bCanHaveScope=True
     ScopeFOV=25
     bCanHaveLaser=True
     bCanHaveSilencer=True
     AmmoNames(0)=Class'DeusEx.Ammo762mm'
     AmmoNames(1)=Class'TNMItems.AmmoSpiderCannister'
     ProjectileNames(1)=Class'TNMItems.spiderCannister20mm'
     recoilStrength=0.500000
     MinWeaponAcc=0.200000
     bCanHaveModBaseAccuracy=True
     bCanHaveModReloadCount=True
     bCanHaveModAccurateRange=True
     bCanHaveModReloadTime=True
     bCanHaveModRecoilStrength=True
     AmmoName=Class'DeusEx.Ammo762mm'
     ReloadCount=30
     PickupAmmoCount=30
     bInstantHit=True
     FireOffset=(X=-16.000000,Y=5.000000,Z=11.500000)
     shakemag=200.000000
     FireSound=Sound'tnmitems.Weapons.SMGFire'
     AltFireSound=Sound'DeusExSounds.Weapons.AssaultGunReloadEnd'
     CockingSound=Sound'DeusExSounds.Weapons.AssaultGunReload'
     SelectSound=Sound'DeusExSounds.Weapons.AssaultGunSelect'
     firesilencedsound=Sound'tnmitems.Weapons.SMGFiresilenced'
     InventoryGroup=41
     PickupMessage="You picked"
     ItemName="Kylie's Rifle"
     ItemArticle="up"
     PlayerViewOffset=(X=16.000000,Y=-5.000000,Z=-11.500000)
     PlayerViewMesh=LodMesh'DeusExItems.AssaultGun'
     PickupViewMesh=LodMesh'DeusExItems.AssaultGunPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.AssaultGun3rd'
     LandSound=Sound'DeusExSounds.Generic.DropMediumWeapon'
     Icon=Texture'DeusExUI.Icons.BeltIconAssaultGun'
     largeIcon=Texture'DeusExUI.Icons.LargeIconAssaultGun'
     largeIconWidth=94
     largeIconHeight=65
     invSlotsX=2
     invSlotsY=2
     Description="UNIQUE WEAPON:|nThis is Kylie Griffin's 7.62x51mm assault gun, which has been upgraded several times to deal more damage, be more accurate, and allow for faster reloading. The weapon has also been perfectly balanced and weighted to all but completely eliminate recoil, and the weapon has been equipped with a laser and a custom reflex scope. The most impressive upgrade, however, and the feature that turns this into a very unique weapon, is the prototype state-of-the-art spiderbot launcher which has replaced the standard-issue 20mm grenade launcher."
     beltDescription="KYLIE GUN"
     Mesh=LodMesh'DeusExItems.AssaultGunPickup'
     CollisionRadius=15.000000
     CollisionHeight=1.100000
     Mass=30.000000

     // Handle enhancements
     bHasLaser=True
     bHasScope=True
     HitDamage=5 // Default 3
     RecoilMods=5
     AccuracyMods=3
     ReloadMods=3
     genericVersion=class'WeaponTNMAssaultGun'
}
