class WeaponUniqueNVS extends TNMUniqueWeapon;

#exec texture IMPORT NAME=LargeIconScrewDriverNVS FILE=Textures\LargeIconScrewDriverNVS.pcx GROUP=Skins MIPS=off
#exec texture IMPORT NAME=BeltIconScrewDriverNVS FILE=Textures\BeltIconScrewDriverNVS.pcx GROUP=Skins MIPS=off

#exec mesh IMPORT MESH=WeaponUniqueNVS ANIVFILE=MODELS\WeaponScrewdriver_a.3d DATAFILE=MODELS\WeaponScrewdriver_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=WeaponUniqueNVS X=-16000 Y=4000 Z=0 //X - Toward Cam + Away Cam | Y - Right + Left | Z - Up  + Down

#exec mesh SEQUENCE MESH=WeaponUniqueNVS SEQ=All          STARTFRAME=0    NUMFRAMES=59
#exec mesh SEQUENCE MESH=WeaponUniqueNVS SEQ=Still		STARTFRAME=0	NUMFRAMES=1
#exec mesh SEQUENCE MESH=WeaponUniqueNVS SEQ=Select		STARTFRAME=1	NUMFRAMES=6		RATE=7	GROUP=Select
#exec mesh SEQUENCE MESH=WeaponUniqueNVS SEQ=Attack		STARTFRAME=6	NUMFRAMES=8		RATE=15
#exec mesh SEQUENCE MESH=WeaponUniqueNVS SEQ=Attack2	    STARTFRAME=13	NUMFRAMES=10	RATE=18
#exec mesh SEQUENCE MESH=WeaponUniqueNVS SEQ=Attack3	    STARTFRAME=22	NUMFRAMES=10	RATE=24
#exec mesh SEQUENCE MESH=WeaponUniqueNVS SEQ=Down		    STARTFRAME=31	NUMFRAMES=6		RATE=10
#exec mesh SEQUENCE MESH=WeaponUniqueNVS SEQ=Idle1		STARTFRAME=37	NUMFRAMES=8		RATE=6
#exec mesh SEQUENCE MESH=WeaponUniqueNVS SEQ=Idle2		STARTFRAME=44	NUMFRAMES=8		RATE=6
#exec mesh SEQUENCE MESH=WeaponUniqueNVS SEQ=Idle3		STARTFRAME=51	NUMFRAMES=8		RATE=6

#exec mesh NOTIFY MESH=WeaponUniqueNVS SEQ=Attack		    TIME=0.30	FUNCTION=HandToHandAttack
#exec mesh NOTIFY MESH=WeaponUniqueNVS SEQ=Attack2		TIME=0.30	FUNCTION=HandToHandAttack
#exec mesh NOTIFY MESH=WeaponUniqueNVS SEQ=Attack3		TIME=0.30	FUNCTION=HandToHandAttack

#exec texture IMPORT NAME=JWeaponUniqueNVS1 FILE=Textures\ScrewDriverNVSTex1.PCX GROUP=Skins // MATERIAL #12
#exec texture IMPORT NAME=JWeaponUniqueNVS2 FILE=Textures\WeaponHandsTex.PCX GROUP=Skins // MATERIAL #13

#exec MESHMAP new   MESHMAP=WeaponUniqueNVS MESH=WeaponUniqueNVS
#exec MESHMAP SCALE MESHMAP=WeaponUniqueNVS X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=WeaponUniqueNVS NUM=1 TEXTURE=JWeaponUniqueNVS1
#exec MESHMAP SETTEXTURE MESHMAP=WeaponUniqueNVS NUM=2 TEXTURE=JWeaponUniqueNVS2

//Pickup Mesh
#exec mesh IMPORT MESH=ScrewDriverPickupNVS ANIVFILE=MODELS\ScrewDriverPickup_a.3d DATAFILE=MODELS\ScrewDriverPickup_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=ScrewDriverPickupNVS X=0 Y=0 Z=0

#exec mesh SEQUENCE MESH=ScrewDriverPickupNVS SEQ=All               STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=ScrewDriverPickupNVS SEQ=\ScrewDriverPickupNVS.uc STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=ScrewDriverPickupNVS MESH=ScrewDriverPickupNVS
#exec MESHMAP SCALE MESHMAP=ScrewDriverPickupNVS X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=ScrewDriverPickupNVS NUM=1 TEXTURE=JWeaponUniqueNVS1

// 3rd Person Mesh
#exec mesh IMPORT MESH=ScrewDriver3rdNVS ANIVFILE=MODELS\ScrewDriver3rd_a.3d DATAFILE=MODELS\ScrewDriver3rd_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=ScrewDriver3rdNVS X=3000 Y=500 Z=4000

#exec MESH SEQUENCE MESH=ScrewDriver3rdNVS SEQ=All            STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=ScrewDriver3rdNVS SEQ=ScrewDriver3rdNVS STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=ScrewDriver3rdNVS MESH=ScrewDriver3rdNVS
#exec MESHMAP scale MESHMAP=ScrewDriver3rdNVS X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=ScrewDriver3rdNVS NUM=1 TEXTURE=JWeaponUniqueNVS1

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local thrownprojectile nade;
	local tripproj trip;

	nade=ThrownProjectile(other);
	if(nade!=None)
	{
		trip=TripProj(nade);
		if(trip!=None)
		{
			trip.Disarm();
			return;
		}
		if(!nade.bDisabled)
			nade.Frob(None,None);
		return;
	}

	super.ProcessTraceHit(Other,HitLocation,HitNormal,X,Y,Z);
}

defaultproperties
{
     bGetsBloody=True
     LowAmmoWaterMark=0
     GoverningSkill=Class'DeusEx.SkillWeaponLowTech'
     NoiseLevel=0.050000
     EnemyEffective=ENMEFF_Organic
     EnviroEffective=ENVEFF_All
     Concealability=CONC_Visual
     reloadTime=0.000000
     HitDamage=5
     maxRange=80
     AccurateRange=80
     BaseAccuracy=1.000000
     bHasMuzzleFlash=False
     bHandToHand=True
     bFallbackWeapon=True
     mpHitDamage=20
     mpBaseAccuracy=1.000000
     mpAccurateRange=96
     mpMaxRange=96
     AmmoName=Class'DeusEx.AmmoNone'
     ReloadCount=0
     bInstantHit=True
     FireOffset=(X=-5.000000,Y=8.000000,Z=14.000000)
     shakemag=20.000000
     FireSound=Sound'DeusExSounds.Weapons.CombatKnifeFire'
     SelectSound=Sound'DeusExSounds.Weapons.CombatKnifeSelect'
     hitfleshsound=Sound'DeusExSounds.Weapons.CombatKnifeHitFlesh'
     hitwoodsound=Sound'DeusExSounds.Weapons.CombatKnifeHitSoft'
     hitmetalsound=Sound'DeusExSounds.Weapons.CombatKnifeHitHard'
     hitothersound=Sound'DeusExSounds.Weapons.CombatKnifeHitHard'
     Misc1Sound=Sound'DeusExSounds.Weapons.CombatKnifeHitFlesh'
     Misc2Sound=Sound'DeusExSounds.Weapons.CombatKnifeHitHard'
     Misc3Sound=Sound'DeusExSounds.Weapons.CombatKnifeHitSoft'
     InventoryGroup=46
     ItemName="NVShacker's Screwdriver"
     PlayerViewOffset=(X=5.000000,Y=-8.000000,Z=-14.000000)
     PlayerViewMesh=LodMesh'tnmitems.WeaponUniqueNVS'
     PlayerViewScale=0.400000
     PickupViewMesh=LodMesh'tnmitems.ScrewDriverPickupNVS'
     PickupViewScale=0.500000
     ThirdPersonMesh=LodMesh'tnmitems.ScrewDriver3rdNVS'
     ThirdPersonScale=0.250000
     Icon=Texture'tnmitems.Skins.BeltIconScrewDriverNVS'
     largeIcon=Texture'tnmitems.Skins.LargeIconScrewDriverNVS'
     largeIconWidth=49
     largeIconHeight=45
     Description="UNIQUE WEAPON:|nNVShacker's screwdriver was designed to be carried with him at all times to work on various electronic devices, including those that ordinarily explode when poked and prodded. It was built with lightweight parts and a durable alloy to facilitate his tinkering though its construction does facilitate combat more than the average screwdriver -- which isn't saying much.|n|nThough most of the tinkering it's designed for is limited in practical value, it can safely disarm wall mounted mines, allowing them to be taken and reused."
     beltDescription="NVS SCRW"
     Mesh=LodMesh'tnmitems.ScrewDriverPickupNVS'
     CollisionRadius=12.650000
     CollisionHeight=0.800000
}
