//=============================================================================
// WeaponUniqueZP.
// Uses HDTP rifle model - most code credited to DDL
//=============================================================================
class WeaponUniqueZP extends TNMUniqueWeapon;

simulated function renderoverlays(Canvas canvas)
{
   if(bHasSilencer)
      multiskins[4] = none;
   else
      multiskins[4] = texture'pinkmasktex';
   if(bHasLaser)
      multiskins[3] = none;
   else
      multiskins[3] = texture'pinkmasktex';

   super.renderoverlays(canvas);
//wuh?

//in case you're wondering: this was because it doesn't have the same multiskins for 1st and 3rd, yo.
   if(bHasSilencer)
      multiskins[3] = none;
   else
      multiskins[3] = texture'pinkmasktex';
   if(bHasLaser)
      multiskins[4] = none;
   else
      multiskins[4] = texture'pinkmasktex';

}

function CheckWeaponSkins() //called on drop/pickup etc
{

	if(bHasSilencer)
		multiskins[3] = none;
	else
		multiskins[3] = texture'pinkmasktex';
	if(bHasLaser)
		multiskins[4] = none;
	else
		multiskins[4] = texture'pinkmasktex';

}


// Muzzle Flash Stuff
simulated function SwapMuzzleFlashTexture()
{
     if (!bHasMuzzleFlash)
     return;
       MultiSkins[7] = Texture'DeusExItems.Skins.FlatFXTex34';

     MuzzleFlashLight();
     SetTimer(0.1, False);
}

simulated function EraseMuzzleFlashTexture()
{
     MultiSkins[7] = None;
}

simulated function Timer()
{
     EraseMuzzleFlashTexture();
}

simulated function MuzzleFlashLight()
{
     local Vector offset, X, Y, Z;
     local Effects flash;

      if (!bHasMuzzleFlash)
          return;

     if ((flash != None) && !flash.bDeleteMe)
          flash.LifeSpan = flash.Default.LifeSpan;
     else
     {
          GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
          offset = Owner.Location;
          offset += X * Owner.CollisionRadius * 2;
          flash = spawn(class'Muzzleflash',,, offset);
          if (flash != None)
               flash.SetBase(Owner);
     }
}


simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
		ReloadCount = mpReloadCount;
      bHasMuzzleFlash = True;
      ReloadCount = 1;
      ReloadTime = ShotTime;
	}

   if(bHasSilencer)
      multiskins[3] = none;
   else
      multiskins[3] = texture'pinkmasktex';
   if(bHasLaser)
      multiskins[4] = none;
   else
      multiskins[4] = texture'pinkmasktex';
}


simulated function PlayFiringSound()
{
	if (bHasSilencer)
		PlaySimSound( FireSilencedSound, SLOT_None, TransientSoundVolume, 2048 );
	else
		PlaySimSound( FireSound, SLOT_None, TransientSoundVolume, 2048 );
}


// All import code for this weapon is in WeaponTNMRifle


defaultproperties
{
     LowAmmoWaterMark=6
     GoverningSkill=Class'DeusEx.SkillWeaponRifle'
     NoiseLevel=2.000000
     EnviroEffective=ENVEFF_Air
     ShotTime=1.500000
     reloadTime=2.000000
     HitDamage=25
     maxRange=48000
     AccurateRange=28800
     bCanHaveScope=True
     bHasScope=True
     bCanHaveSilencer=True
     bHasMuzzleFlash=False
     recoilStrength=0.400000
     bUseWhileCrouched=False
     mpReloadTime=2.000000
     mpHitDamage=25
     mpAccurateRange=28800
     mpMaxRange=28800
     mpReloadCount=6
     bCanHaveModBaseAccuracy=True
     bCanHaveModReloadCount=True
     bCanHaveModAccurateRange=True
     bCanHaveModReloadTime=True
     bCanHaveModRecoilStrength=True
     AmmoName=Class'DeusEx.Ammo3006'
     ReloadCount=6
     PickupAmmoCount=6
     bInstantHit=True
     FireOffset=(X=-20.000000,Y=2.000000,Z=30.000000)
     shakemag=50.000000
     FireSound=Sound'DeusExSounds.Weapons.RifleFire'
     firesilencedsound=Sound'TNMItems.Weapons.SniperFiresilenced'
     AltFireSound=Sound'DeusExSounds.Weapons.RifleReloadEnd'
     CockingSound=Sound'DeusExSounds.Weapons.RifleReload'
     SelectSound=Sound'DeusExSounds.Weapons.RifleSelect'
     InventoryGroup=42
     PickupMessage="You picked"
     ItemArticle="up"
     ItemName="ZeroPresence's Rifle"
     PlayerViewOffset=(X=20.000000,Y=-2.000000,Z=-30.000000)
     PlayerViewMesh=LodMesh'HDTPWeaponRifleZP'
     //PlayerViewScale=0.700000
     PickupViewMesh=LodMesh'HDTPSniperPickup'
     //PickupViewScale=1.150000
     ThirdPersonMesh=LodMesh'HDTPSniper3rd'
     //ThirdPersonScale=1.150000
     LandSound=Sound'DeusExSounds.Generic.DropMediumWeapon'
     Icon=Texture'HDTPBeltIconRifle'
     largeIcon=Texture'HDTPLargeIconRifle'
     largeIconWidth=159
     largeIconHeight=47
     invSlotsX=4
     Description="UNIQUE WEAPON:|nThe sniper rifle of the master assassin ZeroPresence has been heavily modified to allow for greater accuracy over long distances, it has been equipped with a silencer and a custom-made clip to hold more bullets, and some extra weight has been added to the hilt to stabilize the weapon and lessen the recoil. Finally, the internal loading mechanism has been improved to allow for quicker reloading. To decrease the weight of the weapon, Zero has sacrificed the laser mod capability of the weapon. Considering his near-perfect aim and his emphasis on stealth, however, this probably didn't bother him."
     beltDescription="ZP RIFLE"
     Mesh=LodMesh'HDTPSniperPickup'
     //DrawScale=1.1500000
     Texture=Texture'HDTPWeaponRifleShine'
     CollisionRadius=26.000000
     CollisionHeight=2.000000
     Mass=30.000000

     // Handle enhancements
     bHasSilencer=True
     bCanHaveLaser=False
     AccuracyMods=3
     ReloadMods=3
     RecoilMods=3
     ClipMods=2
     RangeMods=2
     GenericVersion=class'WeaponTNMRifle'
}
