//=============================================================================
// WeaponWrench.
//=============================================================================
class WeaponWrench extends TNMWeapon;

#exec texture IMPORT NAME=LargeIconTNMWrench FILE=Textures\LargeIconTNMWrench.pcx GROUP=Skins MIPS=off
#exec texture IMPORT NAME=BeltIconTNMWrench FILE=Textures\BeltIconTNMWrench.pcx GROUP=Skins MIPS=off

#exec mesh IMPORT MESH=WeaponWrench ANIVFILE=MODELS\WeaponWrench_a.3d DATAFILE=MODELS\WeaponWrench_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=WeaponWrench X=-16000 Y=2000 Z=0

#exec mesh SEQUENCE MESH=WeaponWrench SEQ=All       STARTFRAME=0    NUMFRAMES=58
#exec mesh SEQUENCE MESH=WeaponWrench SEQ=Still		STARTFRAME=0	NUMFRAMES=1
#exec mesh SEQUENCE MESH=WeaponWrench SEQ=Select	STARTFRAME=1	NUMFRAMES=6		RATE=7	GROUP=Select
#exec mesh SEQUENCE MESH=WeaponWrench SEQ=Attack	STARTFRAME=6	NUMFRAMES=8		RATE=16
#exec mesh SEQUENCE MESH=WeaponWrench SEQ=Attack2	STARTFRAME=13	NUMFRAMES=8	    RATE=22
#exec mesh SEQUENCE MESH=WeaponWrench SEQ=Attack3	STARTFRAME=20	NUMFRAMES=11	RATE=16
#exec mesh SEQUENCE MESH=WeaponWrench SEQ=Down		STARTFRAME=30	NUMFRAMES=6		RATE=10
#exec mesh SEQUENCE MESH=WeaponWrench SEQ=Idle1		STARTFRAME=36	NUMFRAMES=8		RATE=4
#exec mesh SEQUENCE MESH=WeaponWrench SEQ=Idle2		STARTFRAME=43	NUMFRAMES=8		RATE=4
#exec mesh SEQUENCE MESH=WeaponWrench SEQ=Idle3		STARTFRAME=50	NUMFRAMES=8		RATE=4

#exec mesh NOTIFY MESH=WeaponWrench SEQ=Attack		TIME=0.5	FUNCTION=HandToHandAttack
#exec mesh NOTIFY MESH=WeaponWrench SEQ=Attack2		TIME=0.5	FUNCTION=HandToHandAttack
#exec mesh NOTIFY MESH=WeaponWrench SEQ=Attack3		TIME=0.5	FUNCTION=HandToHandAttack

#exec texture IMPORT NAME=JWeaponWrench1 FILE=Textures\WrenchTex1.PCX GROUP=Skins // Wrench
#exec texture IMPORT NAME=JWeaponWrench2 FILE=Textures\WeaponHandsTex.PCX GROUP=Skins // HAND

#exec MESHMAP NEW   MESHMAP=WeaponWrench MESH=WeaponWrench
#exec MESHMAP scale MESHMAP=WeaponWrench X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=WeaponWrench NUM=1 TEXTURE=JWeaponWrench1
#exec MESHMAP SETTEXTURE MESHMAP=WeaponWrench NUM=2 TEXTURE=JWeaponWrench2

//Pickup Mesh
#exec mesh IMPORT MESH=WrenchPickup ANIVFILE=MODELS\WrenchPickup_a.3d DATAFILE=MODELS\WrenchPickup_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=WrenchPickup X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=WrenchPickup SEQ=All          STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=WrenchPickup SEQ=WrenchPickup STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=WrenchPickup MESH=WrenchPickup
#exec MESHMAP SCALE MESHMAP=WrenchPickup X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=WrenchPickup NUM=1 TEXTURE=JWeaponWrench1


//3rd Person Mesh
#exec mesh IMPORT MESH=Wrench3rd ANIVFILE=MODELS\Wrench3rd_a.3d DATAFILE=MODELS\Wrench3rd_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=Wrench3rd X=2500 Y=500 Z=0

#exec MESH SEQUENCE MESH=Wrench3rd SEQ=All       STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Wrench3rd SEQ=Wrench3rd STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP new   MESHMAP=Wrench3rd MESH=Wrench3rd
#exec MESHMAP SCALE MESHMAP=Wrench3rd X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=Wrench3rd NUM=1 TEXTURE=JWeaponWrench1

defaultproperties
{
     bGetsBloody=True
     LowAmmoWaterMark=0
     GoverningSkill=Class'DeusEx.SkillWeaponLowTech'
     NoiseLevel=0.050000
     EnemyEffective=ENMEFF_Organic
     EnviroEffective=ENVEFF_All
     Concealability=CONC_All
     bEmitWeaponDrawn=False
     reloadTime=0.000000
     HitDamage=6
     maxRange=80
     AccurateRange=80
     BaseAccuracy=1.000000
     bHasMuzzleFlash=False
     bHandToHand=True
     bFallbackWeapon=True
     mpHitDamage=20
     mpBaseAccuracy=1.000000
     mpAccurateRange=96
     mpMaxRange=96
     AmmoName=Class'DeusEx.AmmoNone'
     ReloadCount=0
     bInstantHit=True
     FireOffset=(X=-5.000000,Y=8.000000,Z=14.000000)
     shakemag=20.000000
     FireSound=Sound'DeusExSounds.Weapons.CrowbarFire'
     SelectSound=Sound'DeusExSounds.Weapons.CrowbarSelect'
     hitfleshsound=Sound'DeusExSounds.Weapons.CrowbarHitFlesh'
     hitwoodsound=Sound'DeusExSounds.Weapons.CrowbarHitSoft'
     hitmetalsound=Sound'DeusExSounds.Weapons.CrowbarHitHard'
     hitothersound=Sound'DeusExSounds.Weapons.CrowbarHitSoft'
     InventoryGroup=54
     ItemName="Wrench"
     PlayerViewOffset=(X=5.000000,Y=-8.000000,Z=-14.000000)
     PlayerViewMesh=LodMesh'tnmitems.WeaponWrench'
     PlayerViewScale=0.400000
     PickupViewMesh=LodMesh'tnmitems.WrenchPickup'
     PickupViewScale=0.500000
     ThirdPersonMesh=LodMesh'tnmitems.Wrench3rd'
     ThirdPersonScale=0.350000
     Icon=Texture'tnmitems.Skins.BeltIconTNMWrench'
     largeIcon=Texture'tnmitems.Skins.LargeIconTNMWrench'
     largeIconWidth=49
     largeIconHeight=45
     Description="It's Tightenin' Time!"
     beltDescription="WRENCH"
     Mesh=LodMesh'tnmitems.WrenchPickup'
     CollisionRadius=12.650000
     CollisionHeight=0.800000
}
