//=============================================================================
// nvspProcess: represents a process (or set of processes) that should be
// performed on relevant actors
//=============================================================================
class nvspProcess extends nvspObject
	abstract;

//=============================================================================
//variables

//execution information
var bool bAbstract; 		//only attempt to execute subprocesses
var bool bHasInit;		//call initdefaults

var NP_Behavior behavior;	//determines extent processed object should be modified

//meta information
var string ProcessName; 	//used when dumping process info
var string ProcessDescription;

//=============================================================================
//DO NOT STORE THE VARIABLES BELOW THIS IN THE DEFAULTPROPERTIES BLOCK

//list of subprocesses that will be checked by the process manager
//the most derived process that affects a given actor will be run
var class<nvspProcess> SubProcesses[48]; //ue1/2's lack of dynamic arrays sucks

//process manager reference, set automatically
var nvspProcessManager pm;

//=============================================================================
// utility functions

//copy propertytext for property from o1 to o2 if property is defined in o1
//note: can't differentiate between undefined properties and 0 length strings, probably not a problem anywhere
static final function CopyProperty(string property, object o1, object o2)
{
	if(o2.getpropertytext(property)=="")
		return;
	o1.setpropertytext(property,o2.getpropertytext(property));
}

//returns an actor for iterator calls and such
static final function actor GetActor()
{
	return class'nvspProcess'.Default.pm.a;
}
static final function actor GA(){return GetActor();} //laziness ftw

//add a new subprocess to the default properties, should be done on init
static final function AddSubProcess(class<nvspProcess> p)
{
	local int i;
	for(i=0;i<arraycount(default.subprocesses);i++)
		if(default.subprocesses[i]==none)
		{
			default.subprocesses[i]=p;
			return;
		}
}

//=============================================================================
// overridable functions

//determines whether or not to process a given actor
//should return true if this process should be run on other
static function bool Affects(Actor other);

//process actor for replacement/modification/whatever
static function Process(Actor other);

//init any defaultproperties not set in the actual defaultproperties block
//mainly for adding subprocesses, which shouldn't be inherited
static function InitDefaults();

defaultproperties
{
	bAbstract=True
	bHasInit=False
	ProcessName="Base Process"
	ProcessDescription="Abstract base process that does nothing, shouldn't be used directly."
	Behavior=NPB_None
}