class nvspProcessContainerModifier extends nvspProcessModifier;

static function bool Affects(Actor other)
{
	return other.IsA('Containers');
}

static function Process(Actor other)
{
	local containers c;

	c=containers(other);

	if(c.contents != none && class'nvspReplacementLists'.static.InvReplacement(c.contents.name)!=none)
		c.contents = class<inventory>(class'nvspReplacementLists'.static.InvReplacement(c.contents.name));
	if(c.content2 != none && class'nvspReplacementLists'.static.InvReplacement(c.content2.name)!=none)
		c.content2 = class<inventory>(class'nvspReplacementLists'.static.InvReplacement(c.content2.name));
	if(c.content3 != none && class'nvspReplacementLists'.static.InvReplacement(c.content3.name)!=none)
		c.content3 = class<inventory>(class'nvspReplacementLists'.static.InvReplacement(c.content3.name));
}

defaultproperties
{
	bAbstract=False
	bHasInit=False
	ProcessName="TNM Container Reference Scanner"
	ProcessDescription="Checks container contents for old DX things and replaces them."
}