//handles running relevant processes on actors in a specified order
class nvspProcessManager extends nvspObject;

var actor a; //actor ref for interacting with level
var class<nvspProcess> processes[32]; //processes to be run in order
var int processcount;
var NP_LogVerbosity verbosity;

//find relevant process if any
function class<nvspProcess> FindProcessMatch(class<nvspProcess> base, Actor other)
{
	local int i;
	local class<nvspProcess> sub;

	if(!base.default.bAbstract && !base.static.Affects(other))
		return None;

	for(i=0;i<arraycount(base.default.SubProcesses);i++)
	{
		sub=base.default.SubProcesses[i];

		if(sub==none)
			break;

		if(sub.static.Affects(other))
			return FindProcessMatch(sub, other);
	}

	if(base.default.bAbstract)
		return None;

	return base;
}

//init defaults in process and all subprocesses
function InitProcDefaults(class<nvspProcess> base)
{
	local int i;
	local class<nvspProcess> sub;

	for(i=0;i<arraycount(base.default.SubProcesses);i++)
		base.default.SubProcesses[i]=None; //make sure subprocesses don't get inherited

	if(base.default.bHasInit)
		base.static.InitDefaults();

	for(i=0;i<arraycount(base.default.SubProcesses);i++)
	{
		sub=base.default.SubProcesses[i];

		if(sub==none)
			break;

		InitProcDefaults(sub);
	}
}

//execute the most relevant derived form of proc on all actors
function RunProcess(class<nvspProcess> proc)
{
	local actor act;
	local class<nvspProcess> run;

	foreach a.allactors(class'actor',act)
	{
		run=FindProcessMatch(proc,act);
		if(run!=none)
			run.static.process(act);
	}
}

//execute all the processes in order on their relevant actors
function Run()
{
	local int i;
	for(i=0;i<processcount;i++)
		RunProcess(processes[i]);
}

//initializes everything
function Init()
{
	local int i;

	class'nvspProcess'.Default.pm=Self;

	for(i=0;i<processcount;i++)
		InitProcDefaults(processes[i]);
}

//add a new process, should be done before init
function AddProcess(class<nvspProcess> p)
{
	processes[processcount++]=p;
}

defaultproperties
{
	verbosity=NPLV_None
}