class nvspProcessPawnModifier extends nvspProcessModifier;

static function bool Affects(Actor other)
{
	return other.IsA('ScriptedPawn');
}

static function Process(Actor other)
{
	local scriptedpawn p;
	local class<inventory> replacement;
	local int i;

	p=scriptedpawn(other);

	for(i=0;i<8;i++)
	{
		if(p.initialinventory[i].inventory==none)
			continue;
		replacement=class<inventory>(class'nvspReplacementLists'.static.InvReplacement(p.initialinventory[i].inventory.name));
		if(replacement!=none)
			p.initialinventory[i].inventory=replacement;
	}
}

defaultproperties
{
	bAbstract=False
	bHasInit=False
	ProcessName="TNM Pawn Reference Scanner"
	ProcessDescription="Checks pawn inventories for old DX things and replaces them."
}