class nvspProcessPawnReplacement extends nvspProcessReplacement
	abstract;

static function bool Affects(Actor other)
{
	return other.IsA('ScriptedPawn');
}

static function CopyProperties(actor oa, actor na)
{
	local scriptedpawn n, o;
	local tnmcat kitty;
	local int i;

	super.CopyProperties(oa,na);

	o=scriptedpawn(oa);
	n=scriptedpawn(na);

	n.bHighlight=o.bHighlight;
	n.bImportant=o.bImportant;
	n.bInvincible=o.bInvincible;
	n.bInWorld=o.bInWorld;

	n.bReactFutz=o.bReactFutz;  // new
	n.bReactPresence=o.bReactPresence;         // React to the presence of an enemy (attacking)
	n.bReactLoudNoise=o.bReactLoudNoise;        // Seek the source of a loud noise (seeking)
	n.bReactAlarm=o.bReactAlarm;            // Seek the source of an alarm (seeking)
	n.bReactShot=o.bReactShot;             // React to a gunshot fired by an enemy (attacking)
	n.bReactCarcass=o.bReactCarcass;          // React to gore appropriately (seeking)
	n.bReactDistress=o.bReactDistress;         // React to distress appropriately (attacking)
	n.bReactProjectiles=o.bReactProjectiles;      // React to harmful projectiles appropriately

	n.bFearHacking=o.bFearHacking;           // Run away from a hacker
	n.bFearWeapon=o.bFearWeapon;            // Run away from a person holding a weapon
	n.bFearShot=o.bFearShot;              // Run away from a person who fires a shot
	n.bFearInjury=o.bFearInjury;            // Run away from a person who causes injury
	n.bFearIndirectInjury=o.bFearIndirectInjury;    // Run away from a person who causes indirect injury
	n.bFearCarcass=o.bFearCarcass;           // Run away from a carcass
	n.bFearDistress=o.bFearDistress;          // Run away from a person causing distress
	n.bFearAlarm=o.bFearAlarm;             // Run away from the source of an alarm
	n.bFearProjectiles=o.bFearProjectiles;       // Run away from a projectile

	n.bHateHacking=o.bHateHacking;  // new
	n.bHateWeapon=o.bHateWeapon;
	n.bHateShot=o.bHateShot;
	n.bHateInjury=o.bHateInjury;
	n.bHateIndirectInjury=o.bHateIndirectInjury;  // new
	n.bHateCarcass=o.bHateCarcass;  // new
	n.bHateDistress=o.bHateDistress;

	n.HomeExtent=o.HomeExtent;
	n.HomeTag=o.HomeTag;
	n.Orders=o.Orders;
	n.OrderTag=o.OrderTag;

	n.bPlayIdle=o.bPlayIdle;
	n.RandomWandering=o.RandomWandering;

	for(i=0;i<8;i++)
	{
		n.InitialAlliances[i]=o.InitialAlliances[i];
		n.InitialInventory[i]=o.InitialInventory[i];
	}

	kitty=tnmcat(na);
	if(kitty!=none) //you're a kitty!
	{
		switch(rand(4))
		{
		case 0:
			kitty.SkinColor=kitty.ESkinColor.SC_White;
			break;
		case 1:
			kitty.SkinColor=kitty.ESkinColor.SC_Brown;
			break;
		case 2:
			kitty.SkinColor=kitty.ESkinColor.SC_Orange;
			break;
		case 3:
			kitty.SkinColor=kitty.ESkinColor.SC_Black;
			break;
		}
	}
}

static function class<actor> ReplacementClass(actor other)
{
	return class'nvspReplacementLists'.static.PawnReplacement(other.class.name);
}

defaultproperties
{
	bAbstract=False
	bHasInit=False
	ProcessName="TNM Pawns Replacer"
	ProcessDescription="Replaces DX pawns with their TNM inventory equivalents."
}