class nvspProcessProjReplacement extends nvspProcessReplacement
	abstract;

static function bool Affects(Actor other)
{
	return other.IsA('ThrownProjectile');
}

static function CopyProperties(actor o, actor n)
{
	local thrownprojectile ot, nt;

	super.CopyProperties(o,n);
	ot=thrownprojectile(o);
	nt=thrownprojectile(n);

	nt.bArmed=ot.bArmed;
	nt.bDamaged=ot.bDamaged;
	nt.bDisabled=ot.bDisabled;
	nt.bProximityTriggered=ot.bProximityTriggered;
	nt.bHighlight=ot.bHighlight;
}

static function class<actor> ReplacementClass(actor other)
{
	return class'nvspReplacementLists'.static.ProjReplacement(other.class.name);
}

defaultproperties
{
	bAbstract=False
	bHasInit=False
	ProcessName="TNM Projectile Replacer"
	ProcessDescription="Replaces DX projectile actors with their TNM inventory equivalents."
}