//process all original dx assets with tnm counterparts and replace them
class nvspProcessReplacement extends nvspProcess
	abstract;

static function class<actor> ReplacementClass(actor other);

static function bool HasReplacement(actor other)
{
	return ReplacementClass(other)!=none;
}

static function CopyProperties(actor o, actor n)
{
	local int i;

	//-Object
	n.Group=o.Group;

	//-Advanced
	n.bForceStasis=o.bForceStasis;
//	n.bStatic=o.bStatic;
	CopyProperty("bStatic",n,o);

	//-Display
	n.bUnlit=o.bUnlit;
	if(o.DrawScale!=o.Default.DrawScale)
		n.DrawScale=o.DrawScale;
	n.DrawType=o.DrawType;
	n.Fatness=o.Fatness;
	//n.Mesh=o.Mesh;
	for(i=0;i<arraycount(n.multiskins);i++)
		if(o.MultiSkins[i]!=o.Default.MultiSkins[i])
			n.MultiSkins[i]=o.MultiSkins[i];
	if(o.Skin!=o.Default.Skin)
		n.Skin=o.Skin;
	if(o.Style!=o.Default.Style)
		n.Style=o.Style;
	if(o.Texture!=o.Default.Texture)
		n.Texture=o.Texture;

	//-Events
	n.Event=o.Event;

	//-Collision
	n.SetCollision(o.bCollideActors,o.bBlockActors,o.bBlockPlayers);
	if(o.CollisionRadius!=o.Default.CollisionRadius || o.CollisionHeight!=o.Default.CollisionHeight)
		n.SetCollisionSize(o.CollisionRadius,o.CollisionHeight);
	n.bCollideWorld=o.bCollideWorld;

	//-Movement
	if(o.Physics!=o.Default.Physics)
		n.SetPhysics(o.Physics);
	n.AttachTag=o.AttachTag;
	n.bFixedRotationDir=o.bFixedRotationDir;
	n.bRotateToDesired=o.bRotateToDesired;
	if(o.Buoyancy!=o.Default.Buoyancy)
		n.Buoyancy=o.Buoyancy;
	n.DesiredRotation=o.DesiredRotation;
	if(o.Mass!=o.Default.Mass)
		n.Mass=o.Mass;
	n.RotationRate=o.RotationRate;

	//-Lighting
	n.LightBrightness=o.LightBrightness;
	n.LightHue=o.LightHue;
	n.LightSaturation=o.LightSaturation;
	n.bCorona=o.bCorona;
	n.bSpecialLit=o.bSpecialLit;
	n.LightEffect=o.LightEffect;
	n.LightPeriod=o.LightPeriod;
	n.LightPhase=o.LightPhase;
	n.LightRadius=o.LightRadius;
	n.LightType=o.LightType;
	n.VolumeBrightness=o.VolumeBrightness;
	n.VolumeFog=o.VolumeFog;
	n.VolumeRadius=o.VolumeRadius;

	//-Filter
	n.bDifficulty0=o.bDifficulty0;
	n.bDifficulty1=o.bDifficulty1;
	n.bDifficulty2=o.bDifficulty2;
	n.bDifficulty3=o.bDifficulty3;

	//-Conversation
	//hack; these vars are in Actor for DX
	//but are in multiple classes for UEd2
	//so we use setpropertytext
	CopyProperty("bOwned",n,o);
	CopyProperty("FamiliarName",n,o);
	CopyProperty("UnfamiliarName",n,o);
	CopyProperty("BindName",n,o);
	CopyProperty("BarkBindName",n,o);
}

static function actor SpawnReplacement(actor other)
{
	local actor n;

	if(other.tag!=other.default.tag)
		n=ga().spawn(ReplacementClass(other),,other.tag,other.location,other.rotation);
	else
		n=ga().spawn(ReplacementClass(other),,,other.location,other.rotation);

	return n;
}

static function Process(Actor other)
{
	local actor replacement;

	if(!HasReplacement(other))
		return;

	replacement=SpawnReplacement(other);
	CopyProperties(other,replacement);
	other.destroy();
}

static function InitDefaults()
{
	AddSubProcess(class'nvspProcessInvReplacement');
	AddSubProcess(class'nvspProcessProjReplacement');
	AddSubProcess(class'nvspProcessPawnReplacement');
	AddSubProcess(class'nvspProcessDecoReplacement');
}

defaultproperties
{
	bAbstract=True
	bHasInit=True
	ProcessName="TNM Asset Replacer"
	ProcessDescription="Replaces a processed DeusEx actor with its TNM equivalent, if one is found. It permanently removes the replaced actor."
	Behavior=NPB_Destroy
}