//lists referenced by various classes
class nvspReplacementLists extends nvspObject;

static function class<actor> InvReplacement(name n)
{
	switch(n)
	{
	case 'WeaponLAW':
		return class'WeaponTNMLAW';
	case 'WeaponCombatKnife':
		return class'WeaponTNMCombatKnife';
	case 'WeaponAssaultGun':
		return class'WeaponTNMAssaultGun';
	case 'WeaponPlasmaRifle':
		return class'WeaponTNMPlasmaRifle';
	case 'WeaponSword':
		return class'WeaponTNMSword';
	case 'WeaponGEPGun':
		return class'WeaponTNMGEPGun';
	case 'WeaponCrowbar':
		return class'WeaponTNMCrowbar';
	case 'WeaponFlamethrower':
		return class'WeaponTNMFlamethrower';
	case 'WeaponAssaultShotgun':
		return class'WeaponTNMAssaultShotgun';
	case 'WeaponBaton':
		return class'WeaponTNMBaton';
	case 'WeaponEMPGrenade':
		return class'WeaponTNMEMPGrenade';
	case 'WeaponGasGrenade':
		return class'WeaponTNMGasGrenade';
	case 'WeaponHideAGun':
		return class'WeaponTNMHideAGun';
	case 'WeaponLAM':
		return class'WeaponTNMLAM';
	case 'WeaponMiniCrossbow':
		return class'WeaponTNMMiniCrossbow';
	case 'WeaponNanoSword':
		return class'WeaponTNMNanoSword';
	case 'WeaponNanoVirusGrenade':
		return class'WeaponTNMNanoVirusGrenade';
	case 'WeaponPepperGun':
		return class'WeaponTNMPepperGun';
	case 'WeaponPistol':
		return class'WeaponTNMPistol';
	case 'WeaponProd':
		return class'WeaponTNMProd';
	case 'WeaponRifle':
		return class'WeaponTNMRifle';
	case 'WeaponSawedOffShotgun':
		return class'WeaponTNMSawedOffShotgun';
	case 'WeaponShuriken':
		return class'WeaponTNMShuriken';
	case 'WeaponStealthPistol':
		return class'WeaponTNMStealthPistol';
	case 'VialCrack':
		return class'TNMVialCrack';
	}
	return None;
}

static function class<actor> ProjReplacement(name n)
{
	switch(n)
	{
	case 'LAM':
		return class'TNMLAM';
	case 'EMPGrenade':
		return class'TNMEMPGrenade';
	case 'GasGrenade':
		return class'TNMGasGrenade';
	case 'NanoVirusGrenade':
		return class'TNMNanoVirusGrenade';
	case 'Shuriken': //probably don't need this
		return class'TNMShuriken';
	}
	return None;
}

static function class<actor> PawnReplacement(name n)
{
	switch(n)
	{
	case 'Cat':
		return class'tnmCat';
	case 'SecurityBot4':
		return class'SecurityBot4Flamer';
	case 'MedicalBot':
		return class'TNM_Medbot';
	case 'Karkian':
		return class'TNMKarkian';
	case 'KarkianBaby':
		return class'TNMKarkianBaby';
	case 'Mutt':
		return class'TNMMutt';
	case 'Doberman':
		return class'TNMDoberman';
	case 'CleanerBot':
		return class'TNMCleanerBot';
	case 'Greasel':
		return class'TNMGreasel';
	case 'Rat':
		return class'TNMRat';
	case 'SecurityBot2':
		return class'TNMSecurityBot2';
	case 'SecurityBot3':
		return class'TNMSecurityBot3';
	case 'SpiderBotBig':
		return class'TNMSpiderBotBig';
	case 'SpiderBotMed':
		return class'TNMSpiderBotMed';
	case 'RepairBot':
		return class'TNM_RepairBot';
	}
	return None;
}

static function class<actor> DecoReplacement(name n)
{
	switch(n)
	{
	case 'Phone':
		return class'tnmPhone';
	case 'TAD':
		return class'tnmTAD';
	case 'ATM':
		return class'tnmATM';
	}
	return None;
}