﻿' This doesn't do CSG, so don't get too excited.

Imports UPLib

Public Class BSPBuilder
    Public Surfs As New List(Of BuilderSurf)
    Public Root As New BuilderNode

    Sub AddPolygon(verts As List(Of Vector), uvs As List(Of UV), texture As String)
        Dim surf As New BuilderSurf
        surf.Texture = texture
        surf.iSurf = Surfs.Count
        surf.Normal = Vector.Cross(verts(1) - verts(0), verts(2) - verts(0)).Normalized
        'TODO: Pick more representative verts.
        ConvertUV(uvs(0).U, uvs(0).V, uvs(1).U, uvs(1).V, uvs(2).U, uvs(2).V, _
                  verts(0), verts(1), verts(2),
                  surf.Origin, surf.TextureU, surf.TextureV)
        Surfs.Add(surf)

        Dim poly As New BuilderPoly
        poly.Surf = surf
        For Each vert In verts
            poly.Verts.Add(New BuilderVert(vert))
        Next
        poly.Node = Root
        Root.UnprocessedPolys.Add(poly)
    End Sub

    Sub Build()
        Root.Build()
        Root.CalcIndices(0)
    End Sub
End Class

Public Class BuilderSurf
    Public Texture As String
    Public Normal As Vector
    Public Origin As Vector
    Public TextureU As Vector
    Public TextureV As Vector
    Public iSurf As Integer
End Class

Public Class BuilderNode
    Public Plane As Plane
    Public UnprocessedPolys As New List(Of BuilderPoly)
    Public Front As BuilderNode
    Public Back As BuilderNode
    Public Coplanars As New List(Of BuilderPoly)

    Sub Build()
        Dim initialCount = UnprocessedPolys.Count
        ' Pick a splitter
        Dim iSplitter = UnprocessedPolys.Count / 2
        Dim splitter = UnprocessedPolys(iSplitter) 'TODO: Better choice (minimize cuts, balance tree, ...)
        Plane.X = splitter.Surf.Normal.X
        Plane.Y = splitter.Surf.Normal.Y
        Plane.Z = splitter.Surf.Normal.Z
        Plane.W = Plane.TestPoint(splitter.Verts(0).Position) 'TODO: Is this correct?
        Coplanars.Add(splitter)
        UnprocessedPolys.RemoveAt(iSplitter)

        ' Find coplanars
        Dim planeNormal As New Vector(Plane.X, Plane.Y, Plane.Z)
        For i = UnprocessedPolys.Count - 1 To 0 Step -1
            Dim poly = UnprocessedPolys(i)

            If (poly.Surf.Normal - planeNormal).Length < 0.001 AndAlso Math.Abs(Plane.TestPoint(poly.Verts(0).Position)) < 0.001 Then 'TODO: Value?
                Coplanars.Add(poly)
                UnprocessedPolys.RemoveAt(i)
            End If
        Next

        ' Find fronts and backs
        Dim fronts As New List(Of BuilderPoly)
        Dim backs As New List(Of BuilderPoly)
        For i = UnprocessedPolys.Count - 1 To 0 Step -1
            Dim poly = UnprocessedPolys(i)

            'num of verts that are...
            Dim numFC = 0 'front or coplanar
            Dim numBC = 0 'back or coplanar
            Dim numC = 0 'coplanar
            For j = 0 To poly.Verts.Count - 1
                Dim vert = poly.Verts(j)
                Dim test = Plane.TestPoint(vert.Position)
                If test > 0.001 Then
                    vert.Side = Side.Front
                    numFC += 1
                ElseIf test < -0.001 Then
                    vert.Side = Side.Back
                    numBC += 1
                Else
                    vert.Side = Side.Coplanar
                    numFC += 1
                    numBC += 1
                    numC += 1
                End If
                'TODO: Special case for polygons with some verts on plane and
                'the rest of verts on one side, so it doesn't cut off a tiny part of them.
                'e.g. if test>.001 ... elseif test<-.001 ... else ...
                poly.Verts(j) = vert
            Next
            Dim allCoplanar = (numC = poly.Verts.Count)

            If numBC = poly.Verts.Count And Not allCoplanar Then
                If numC > 0 Then
                    ' Pretend that all verts are back.
                    For j = 0 To poly.Verts.Count - 1
                        Dim vert = poly.Verts(j)
                        vert.Side = Side.Back
                        poly.Verts(j) = vert
                    Next
                End If
                backs.Add(poly)
                UnprocessedPolys.RemoveAt(i)
            ElseIf numFC = poly.Verts.Count And Not allCoplanar Then
                If numC > 0 Then
                    ' Pretend that all verts are front.
                    For j = 0 To poly.Verts.Count - 1
                        Dim vert = poly.Verts(j)
                        vert.Side = Side.Front
                        poly.Verts(j) = vert
                    Next
                End If
                fronts.Add(poly)
                UnprocessedPolys.RemoveAt(i)
            Else
                ' Split it. TODO: Move to SplitPolyWithPlane perhaps?

                ' TODO: Coplanar vert treatment

                'Fuck it, just make them front or back.
                For j = 0 To poly.Verts.Count - 1
                    Dim vert = poly.Verts(j)
                    vert.Side = If(Plane.TestPoint(vert.Position) > 0, Side.Front, Side.Back)
                    poly.Verts(j) = vert
                Next

                Dim partF As New BuilderPoly
                Dim partB As New BuilderPoly
                partF.Surf = poly.Surf
                partB.Surf = poly.Surf

                Dim iEdgeFB_F As Integer
                Dim iEdgeBF_B As Integer
                For j = 0 To poly.Verts.Count - 1
                    If poly.Verts(j).Side = Side.Front And poly.Verts((j + 1) Mod poly.Verts.Count).Side = Side.Back Then
                        iEdgeFB_F = j
                    End If
                    If poly.Verts(j).Side = Side.Back And poly.Verts((j + 1) Mod poly.Verts.Count).Side = Side.Front Then
                        iEdgeBF_B = j
                    End If
                Next
                Dim iEdgeFB_B = (iEdgeFB_F + 1) Mod poly.Verts.Count
                Dim iEdgeBF_F = (iEdgeBF_B + 1) Mod poly.Verts.Count

                Dim intersectionFracFB As Single
                Dim intersectionFracBF As Single
                Dim intersectionFB = LinePlaneIntersection(poly.Verts(iEdgeFB_F).Position, poly.Verts(iEdgeFB_B).Position, Plane, intersectionFracFB)
                Dim intersectionBF = LinePlaneIntersection(poly.Verts(iEdgeBF_B).Position, poly.Verts(iEdgeBF_F).Position, Plane, intersectionFracBF)

                partB.Verts.Add(New BuilderVert(intersectionFB))
                Dim iEdge = iEdgeFB_B
                Do
                    partB.Verts.Add(poly.Verts(iEdge))
                    iEdge = (iEdge + 1) Mod poly.Verts.Count
                Loop Until iEdge = iEdgeBF_F
                partB.Verts.Add(New BuilderVert(intersectionBF))

                partF.Verts.Add(New BuilderVert(intersectionBF))
                Dim iEdge2 = iEdgeBF_F
                Do
                    partF.Verts.Add(poly.Verts(iEdge2))
                    iEdge2 = (iEdge2 + 1) Mod poly.Verts.Count
                Loop Until iEdge2 = iEdgeFB_B
                partF.Verts.Add(New BuilderVert(intersectionFB))

                fronts.Add(partF)
                backs.Add(partB)

                UnprocessedPolys.RemoveAt(i) 'TODO: Do we even need to remove them?
            End If
        Next

        Assert(UnprocessedPolys.Count = 0)

        If fronts.Count > 0 Then
            Front = New BuilderNode
            Front.UnprocessedPolys = fronts
            For i = 0 To Front.UnprocessedPolys.Count - 1
                Front.UnprocessedPolys(i).Node = Front
            Next
            Front.Build()
        End If

        If backs.Count > 0 Then
            Back = New BuilderNode
            Back.UnprocessedPolys = backs
            For i = 0 To Back.UnprocessedPolys.Count - 1
                Back.UnprocessedPolys(i).Node = Back
            Next
            Back.Build()
        End If
    End Sub

    Private Shared Function _LinePlaneIntersection(linePt As Vector, lineDir As Vector, p As Plane) As Single
        Dim planeNormal = New Vector(p.X, p.Y, p.Z)
        Dim f = Vector.Dot(lineDir, planeNormal)
        If Math.Abs(f) < 0.001 Then
            Return Single.NaN 'Doesn't intersect
        Else
            Return Vector.Dot(p.W * planeNormal - linePt, planeNormal) / f
        End If
    End Function

    ''' <summary>
    ''' Test intersection between a line and a plane.
    ''' frac means fraction between linePt1..2 where intersection occured.
    ''' </summary>
    Private Shared Function LinePlaneIntersection(linePt1 As Vector, linePt2 As Vector, p As Plane, Optional ByRef frac As Single = 0) As Vector
        Dim lineDir = (linePt2 - linePt1).Normalized
        Dim distance = _LinePlaneIntersection(linePt1, lineDir, p)
        frac = distance / (linePt2 - linePt1).Length
        Return linePt1 + lineDir * distance 'Is this correct?
    End Function

    Sub CalcIndices(ByRef iCurrent As Integer)
        Assert(Coplanars(0).iNode = -1)
        Coplanars(0).iNode = iCurrent
        iCurrent += 1

        If Front IsNot Nothing Then Front.CalcIndices(iCurrent)
        If Back IsNot Nothing Then Back.CalcIndices(iCurrent)

        For i = 1 To Coplanars.Count - 1
            Assert(Coplanars(i).iNode = -1)
            Coplanars(i).iNode = iCurrent
            iCurrent += 1
        Next
    End Sub

    Sub ToList(dst As List(Of BuilderPoly))
        dst.Add(Coplanars(0))

        If Front IsNot Nothing Then Front.ToList(dst)
        If Back IsNot Nothing Then Back.ToList(dst)

        For i = 1 To Coplanars.Count - 1
            Coplanars(i).iCoplanar = i
            dst.Add(Coplanars(i))
        Next
    End Sub
End Class

Public Class BuilderPoly
    Public Node As BuilderNode
    Public Surf As BuilderSurf
    Public Verts As New List(Of BuilderVert)
    ''' <summary>Will be used in Unreal.</summary>
    Public iNode As Integer = -1
    Public iCoplanar As Integer
End Class

Public Structure BuilderVert
    Dim Position As Vector
    Dim Side As Side

    Sub New(position As Vector)
        Me.Position = position
    End Sub
End Structure

Public Structure UV
    Dim U, V As Single

    Sub New(u As Single, v As Single)
        Me.U = u
        Me.V = v
    End Sub

    Shared Operator +(lhs As UV, rhs As UV) As UV
        Return New UV(lhs.U + rhs.U, lhs.V + rhs.V)
    End Operator

    Shared Operator -(lhs As UV, rhs As UV) As UV
        Return New UV(lhs.U - rhs.U, lhs.V - rhs.V)
    End Operator

    Shared Operator *(lhs As UV, rhs As Single) As UV
        Return New UV(lhs.U * rhs, lhs.V * rhs)
    End Operator

    Shared Operator *(lhs As Single, rhs As UV) As UV
        Return New UV(lhs * rhs.U, lhs * rhs.V)
    End Operator

    Shared Operator /(lhs As UV, rhs As Single) As UV
        Return New UV(lhs.U / rhs, lhs.V / rhs)
    End Operator
End Structure

Public Enum Side
    Unset
    Front
    Back
    Coplanar
End Enum

' Line-plane intersection code -- useful for splitting polys for BSP.
'
'	Copyright 2010-2019 Kristian Duske
'	Copyright 2015-2019 Eric Wasylishen
'	Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
'	documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
'	rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit
'	persons to whom the Software is furnished to do so, subject to the following conditions:
'	The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
'	Software.
'	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
'	WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
'	COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
'	OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
'    /**
'     * Computes the point of intersection between the given ray and the given bounding box, and returns the distance
'     * on the given line from the line's anchor to that point.
'     *
'     * @tparam T the component type
'     * @tparam S the number of components
'     * @param l the line
'     * @param p the plane
'     * @return the distance to the intersection point, or NaN if the line does not intersect the plane
'     */
'    template <typename T, size_t S>
'    constexpr T intersect_line_plane(const line<T,S>& l, const plane<T,3>& p) {
'        const auto f = dot(l.direction, p.normal);
'        if (is_zero(f, constants<T>::almost_zero())) {
'            return nan<T>();
'        } else {
'            return dot(p.distance * p.normal - l.point, p.normal) / f;
'        }
'    }
