﻿Imports UPLib

Public Class OBJ
    Public Verts As New List(Of Vector)
    Public UVs As New List(Of UV)
    Public Polys As New List(Of OBJPolygon)

    Sub New(file As String)
        Dim groupName As String = ""
        Dim r As New IO.StreamReader(New IO.FileStream(file, IO.FileMode.Open, IO.FileAccess.Read))

        Do
            Dim line = r.ReadLine
            If line.StartsWith("v ") Then
                Dim vert As New Vector
                Dim separated = line.Split({" "c}, StringSplitOptions.RemoveEmptyEntries)

                vert.X = StrToNum(separated(1))
                vert.Y = StrToNum(separated(2))
                vert.Z = StrToNum(separated(3))
                Me.Verts.Add(vert)
            ElseIf line.StartsWith("vt ") Then
                Dim uv As New UV
                Dim sep = line.Split({" "c}, StringSplitOptions.RemoveEmptyEntries)
                uv.U = StrToNum(sep(1))
                uv.V = StrToNum(sep(2))
                Me.UVs.Add(uv)
            ElseIf line.StartsWith("f ") Then
                Dim poly As New OBJPolygon
                Dim sep = line.Split({" "c}, StringSplitOptions.RemoveEmptyEntries)
                For i = 1 To sep.GetUpperBound(0)
                    If sep(i) <> "" Then
                        Dim vert As OBJVertex
                        Dim sep2 = sep(i).Split("/"c)
                        'nums will start from 0
                        vert.iVert = sep2(0) - 1
                        If sep2(1) <> "" Then
                            vert.iUV = sep2(1) - 1
                        Else
                            vert.iUV = 0
                        End If
                        poly.Verts.Add(vert)
                    End If
                Next
                poly.Material = groupName
                Me.Polys.Add(poly)
            ElseIf line.StartsWith("usemtl ") Then
                groupName = line.Substring(7)
            End If
        Loop Until r.EndOfStream

        r.Close()
    End Sub

End Class

Public Class OBJPolygon
    Public Verts As New List(Of OBJVertex)
    Public Material As String
End Class

Public Structure OBJVertex
    ''' <summary>Warning: These start from 0.</summary>
    Dim iVert As Integer
    ''' <summary>Warning: These start from 0.</summary>
    Dim iUV As Integer
End Structure