﻿''' <summary>
''' For storing chunks of arbitary, binary data, possibly of unknown format.
''' </summary>
Public Class BinaryBuffer
    Public Data As IO.MemoryStream
    Public R As UnBinaryReader
    Public W As UnBinaryWriter
    Public IsFixedSize As Boolean

    Property Position As Integer
        Set(value As Integer)
            Data.Position = value
        End Set
        Get
            Return Data.Position
        End Get
    End Property

    ReadOnly Property Size As Integer
        Get
            Return Data.Length
        End Get
    End Property

    Sub New(length As Integer, Optional fixedSize As Boolean = False)
        IsFixedSize = fixedSize
        If IsFixedSize Then
            Dim newArray(length - 1) As Byte
            Data = New IO.MemoryStream(newArray)
        Else
            Data = New IO.MemoryStream(length)
        End If
        R = New UnBinaryReader(Data)
        W = New UnBinaryWriter(Data)
    End Sub

    Sub New(arr As Byte(), Optional fixedSize As Boolean = False)
        IsFixedSize = fixedSize
        If IsFixedSize Then
            Dim newArray As Byte() = arr.Clone
            Data = New IO.MemoryStream(newArray)
            W = New UnBinaryWriter(Data)
        Else
            Data = New IO.MemoryStream(arr.GetLength(0))
            W = New UnBinaryWriter(Data)
            W.Write(arr)
            Position = 0
        End If
        R = New UnBinaryReader(Data)

    End Sub

    Sub Clear()
        If IsFixedSize Then
            Position = 0
            Dim empty(Size - 1) As Byte
            W.Write(empty)
            Position = 0
        Else
            Dim pkg = R.Pkg
            Data = New IO.MemoryStream()
            W = New UnBinaryWriter(Data)
            W.Package = pkg
            R = New UnBinaryReader(Data)
            R.Pkg = pkg
        End If
    End Sub

    Function ToArray() As Byte()
        Position = 0
        Return R.ReadBytes(Data.Length)
    End Function
End Class
