﻿Public Class UnBinaryWriter
    Inherits IO.BinaryWriter

    Public Package As Package

    Sub New(input As IO.Stream)
        MyBase.New(input)
    End Sub

    Sub WriteByte(value As Byte)
        Write(value)
    End Sub

    Sub WriteCompact(value As Integer)
        Dim b As Byte
        If value < 0 Then
            b = (1 << 7)
            value = -value
        End If
        b = b Or (value And 63)
        If value > 63 Then b = b Or (1 << 6)
        WriteByte(b)
        If value > 63 Then
            b = ((value >> 6) And 127)
            If value > 8191 Then b = b Or (1 << 7)
            WriteByte(b)
            If value > 8191 Then
                b = ((value >> (6 + 7)) And 127)
                If value > 1048575 Then b = b Or (1 << 7)
                WriteByte(b)
                If value > 1048575 Then
                    b = ((value >> (6 + 7 + 7)) And 127)
                    If value > 134217727 Then b = b Or (1 << 7)
                    WriteByte(b)
                    If value > 134217727 Then
                        b = ((value >> (6 + 7 + 7 + 7)) And 31)
                        WriteByte(b)
                    End If
                End If
            End If
        End If
    End Sub

    Sub WriteSingle(value As Single)
        Write(value)
    End Sub

    Sub WriteVector(value As Vector)
        WriteSingle(value.X)
        WriteSingle(value.Y)
        WriteSingle(value.Z)
    End Sub

    Sub WriteInt32(value As Int32)
        Write(value)
    End Sub

    Sub WriteInt16(value As Int16)
        Write(value)
    End Sub

    Sub WriteUInt32(value As UInt32)
        Write(value)
    End Sub

    Sub WriteUInt16(value As UInt16)
        Write(value)
    End Sub

    Sub WriteZString(value As String)
        For i = 0 To value.Length - 1
            WriteByte(Char.ConvertToUtf32(value, i))
        Next
        WriteByte(0)
    End Sub

    Sub WriteFixedString(value As String, len As Integer)
        For i = 0 To Math.Min(value.Length - 1, len - 1)
            WriteByte(Char.ConvertToUtf32(value, i))
        Next
        If len > value.Length Then
            For i = 0 To len - value.Length - 1
                WriteByte(0)
            Next
        End If
    End Sub

    Sub WriteNonTerminatedString(value As String)
        For i = 0 To value.Length - 1
            WriteByte(Char.ConvertToUtf32(value, i))
        Next
    End Sub

    Sub WriteProperties(value As Properties)
        For i = 0 To value.Props.Count - 1
            Dim prop = value.Props(i)

            WriteCompact(prop.Name)

            Dim size = 0
            Select Case prop.Type
                Case EPropertyType.BooleanProperty
                    size = 0
                Case EPropertyType.ByteProperty
                    size = 1
                Case EPropertyType.IntegerProperty,
                     EPropertyType.FloatProperty
                    size = 4
                Case EPropertyType.NameProperty,
                     EPropertyType.ObjectProperty
                    size = LengthOfCompact(prop.IntValue)
                Case EPropertyType.StringProperty
                    size = prop.StringValue.Length
                Case EPropertyType.StrProperty
                    'not sure
                    size = LengthOfCompact(prop.StringValue.Length) + prop.StringValue.Length
                Case Else
                    size = prop.RawValue.GetLength(0)
            End Select

            Dim sizeCode As EPropertySize
            Select Case size
                Case 1 : sizeCode = EPropertySize.Size1
                Case 2 : sizeCode = EPropertySize.Size2
                Case 4 : sizeCode = EPropertySize.Size4
                Case 12 : sizeCode = EPropertySize.Size12
                Case 16 : sizeCode = EPropertySize.Size16
                Case Is <= 255
                    sizeCode = EPropertySize.CheckNextByte
                Case Is <= 65535
                    sizeCode = EPropertySize.CheckNextWord
                Case Else
                    sizeCode = EPropertySize.CheckNextInt
            End Select

            Dim arrayFlag As Boolean
            If prop.Type = EPropertyType.BooleanProperty Then
                arrayFlag = prop.IntValue
            Else
                arrayFlag = (prop.ArrayIndex > 0)
            End If

            WriteByte(prop.Type Or (sizeCode << 4) Or (If(arrayFlag, CByte(1), CByte(0)) << 7))

            If prop.Type = EPropertyType.StructProperty Then
                WriteCompact(prop.StructName)
            End If

            Select Case sizeCode
                Case EPropertySize.CheckNextByte
                    WriteByte(size)
                Case EPropertySize.CheckNextWord
                    WriteInt16(size)
                Case EPropertySize.CheckNextInt
                    WriteInt32(size)
            End Select

            If arrayFlag And prop.Type <> EPropertyType.BooleanProperty Then
                If prop.ArrayIndex <= 63 Then
                    WriteByte(prop.ArrayIndex)
                ElseIf prop.ArrayIndex <= 16383 Then
                    WriteInt16(SwapEndianness(CShort(prop.ArrayIndex)) Or 128)
                Else
                    WriteInt32(SwapEndianness(prop.ArrayIndex) Or 192)
                End If
            End If

            Select Case prop.Type
                Case EPropertyType.ByteProperty
                    WriteByte(prop.IntValue)
                Case EPropertyType.IntegerProperty
                    WriteInt32(prop.IntValue)
                Case EPropertyType.BooleanProperty
                Case EPropertyType.FloatProperty
                    WriteSingle(prop.FloatValue)
                Case EPropertyType.NameProperty,
                     EPropertyType.ObjectProperty
                    WriteCompact(prop.IntValue)
                Case EPropertyType.StrProperty
                    WriteCompact(prop.StringValue.Length)
                    WriteZString(prop.StringValue)
                Case EPropertyType.StringProperty
                    WriteZString(prop.StringValue)
                Case Else
                    Write(prop.RawValue)
            End Select

        Next
        WriteCompact(Package.AddName("None"))
    End Sub

End Class

