﻿Public Module Utils

    Function SwapEndianness(num As Integer) As Integer
        Dim newNum As Integer
        newNum = (num >> 24)
        newNum = newNum Or ((num And &HFF0000) >> 8)
        newNum = newNum Or ((num And &HFF00) << 8)
        newNum = newNum Or ((num And &HFF) << 24)
        Return newNum
    End Function

    Function SwapEndianness(num As Short) As Short
        Dim newNum As Short
        newNum = num >> 8
        newNum = newNum Or (num And &HFFS) << 8
        Return newNum
    End Function

    Sub Swap(Of T)(ByRef A As T, ByRef B As T)
        Dim temp = A
        A = B
        B = temp
    End Sub

    Function NumToStr(val As Single) As String
        'don't use period and "e" notation
        Return val.ToString("F6", Globalization.CultureInfo.InvariantCulture)
    End Function

    Function StrToNum(str As String) As Single
        Return Single.Parse(str, Globalization.CultureInfo.InvariantCulture)
    End Function

    Function IsNumWeird(num As Single) As Boolean
        Return Single.IsNaN(num) OrElse Single.IsInfinity(num) OrElse (Math.Abs(num) > 1000000)
    End Function

    Function IsAtLeastOneVectorWeird(vects As List(Of Vector)) As Boolean
        For i = 0 To vects.Count - 1
            If vects(i).IsWeird Then
                Return True
            End If
        Next

        Return False
    End Function

    Function StrEq(str1 As String, str2 As String) As Boolean
        Return String.Equals(str1, str2, StringComparison.OrdinalIgnoreCase)
    End Function

    Function NameEq(name1 As String, name2 As String) As Boolean
        If name1 = "" Then name1 = "None"
        If name2 = "" Then name2 = "None"

        Return StrEq(name1, name2)
    End Function

    Function BytesToHex(bytes As Byte()) As String
        Dim text As New System.Text.StringBuilder

        For i = 0 To bytes.GetUpperBound(0)
            If bytes(i) < 16 Then
                text.Append("0"c)
            End If

            text.Append(bytes(i).ToString("X"))
            If i < bytes.GetUpperBound(0) Then
                text.Append(" "c)
            End If
        Next

        Return text.ToString()
    End Function

    Function LengthOfCompact(num As Integer) As Integer
        num = Math.Abs(num)
        If num > 134217727 Then Return 5
        If num > 1048575 Then Return 4
        If num > 8191 Then Return 3
        If num > 63 Then Return 2
        Return 1
    End Function

    Function InMyDir(path As String) As String
        Return IO.Path.Combine(My.Application.Info.DirectoryPath, path)
    End Function

    Sub Assert(condition As Boolean, Optional message As String = "")
        If Not condition Then
            Dim msg = ""
            If message = "" Then
                msg = "Assertion failed!"
            Else
                msg = "Assertion failed: " & message
            End If
            Throw New Exception(msg)
        End If
    End Sub

    Function EnsureBool(num As Integer) As Boolean
        If num = 1 Then Return True
        If num = 0 Then Return False
        Throw New FormatException("Not a boolean")
    End Function

    Function IsOneOf(value As String, options As String()) As Boolean
        For i = 0 To options.Length - 1
            If StrEq(value, options(i)) Then
                Return True
            End If
        Next
        Return False
    End Function

    Sub ListSet(Of T)(list As List(Of T), index As Integer, item As T)
        If index < 0 Then
            Throw New IndexOutOfRangeException
        ElseIf index < list.Count Then
            list(index) = item
        ElseIf index >= list.Count Then
            Dim empty As T
            For i = 0 To index - list.Count - 1
                list.Add(empty)
            Next
            list.Add(item)
        End If
    End Sub

End Module
