﻿Public Structure Vector
    Dim X, Y, Z As Single

    Sub New(x_ As Single, y_ As Single, z_ As Single)
        X = x_
        Y = y_
        Z = z_
    End Sub

    Function ToPropertyString() As String
        Return "(X=" & NumToStr(X) & ",Y=" & NumToStr(Y) & ",Z=" & NumToStr(Z) & ")"
    End Function

    Function ToT3DString() As String
        Return NumToStr(X) & "," & NumToStr(Y) & "," & NumToStr(Z)
    End Function

    Function IsWeird() As Boolean
        Return IsNumWeird(X) Or IsNumWeird(Y) Or IsNumWeird(Z)
    End Function

    Shared Operator =(lhs As Vector, rhs As Vector) As Boolean
        Return (lhs.X = rhs.X) And (lhs.Y = rhs.Y) And (lhs.Z = rhs.Z)
    End Operator

    Shared Operator <>(lhs As Vector, rhs As Vector) As Boolean
        Return Not (lhs = rhs)
    End Operator

    Shared Operator +(lhs As Vector, rhs As Vector) As Vector
        Return New Vector(lhs.X + rhs.X, lhs.Y + rhs.Y, lhs.Z + rhs.Z)
    End Operator

    Shared Operator -(lhs As Vector, rhs As Vector) As Vector
        Return New Vector(lhs.X - rhs.X, lhs.Y - rhs.Y, lhs.Z - rhs.Z)
    End Operator

    Shared Operator *(lhs As Vector, rhs As Single) As Vector
        Return New Vector(lhs.X * rhs, lhs.Y * rhs, lhs.Z * rhs)
    End Operator

    Shared Operator *(lhs As Single, rhs As Vector) As Vector
        Return New Vector(lhs * rhs.X, lhs * rhs.Y, lhs * rhs.Z)
    End Operator

    Shared Operator /(lhs As Vector, rhs As Single) As Vector
        Return New Vector(lhs.X / rhs, lhs.Y / rhs, lhs.Z / rhs)
    End Operator

    Shared Function Cross(v1 As Vector, v2 As Vector) As Vector
        Return New Vector(v1.Y * v2.Z - v1.Z * v2.Y, v1.Z * v2.X - v1.X * v2.Z, v1.X * v2.Y - v1.Y * v2.X)
    End Function

    Shared Function Dot(v1 As Vector, v2 As Vector) As Single
        Return v1.X * v2.X + v1.Y * v2.Y + v1.Z * v2.Z
    End Function

    Function Normalized() As Vector
        Dim len = Math.Sqrt(X * X + Y * Y + Z * Z)
        'Assert(len > 0.001)
        Return New Vector(X / len, Y / len, Z / len)
    End Function

    ReadOnly Property Length As Single
        Get
            Return Math.Sqrt(X * X + Y * Y + Z * Z)
        End Get
    End Property
End Structure

