#include "extract_speech.h"
#include "misc.h"
#include "packdata.h"
#include "packfind.h"
#include "objtools.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int extract_speech(const export_entry *speechev, const char *con_prefix, const char *outfilename){
	static const char *const audio_package_midfix = "Audio";
	static const char *const audio_package_suffix = ".u";
	static const char *const conaudiolist_prefix = "ConAudioList_";
	
	const export_entry *conversation = getobjexprefprop(speechev, "conversation");
	if(!conversation) TODOEXIT("event has no conversation reference");

	const export_entry *conspeech = getobjexprefprop(speechev, "conSpeech");
	if(!conspeech) TODOEXIT("event has no speech reference");
	
	int sound_ok;
	unsigned long int soundid = getobjintprop(conspeech, "soundID", &sound_ok);
	if(!sound_ok) TODOEXIT("speech has no sound ID");
	
	const char *audiopackagename = getobjstrprop(conversation, "audioPackageName");
	if(!audiopackagename) TODOEXIT("conversation has no audio package name");
	
	char audiopackfile[512];
	char conaudiolistname[512];
	if(
		strlen(con_prefix) + strlen(audio_package_midfix) + strlen(audiopackagename) + strlen(audio_package_suffix) >= sizeof(audiopackfile) ||
		strlen(conaudiolist_prefix) + strlen(audiopackagename) >= sizeof(conaudiolistname)){
		
		TODOEXIT("audio package name too long");
	}
	
	strcpy(audiopackfile, con_prefix);
	strcat(audiopackfile, audio_package_midfix);
	strcat(audiopackfile, audiopackagename);
	strcat(audiopackfile, audio_package_suffix);
	
	strcpy(conaudiolistname, conaudiolist_prefix);
	strcat(conaudiolistname, audiopackagename);
	
	char curpackname[512];
	strcpy(curpackname, pd.packagename);
	
	if(!usepackage(audiopackfile)) TODOEXIT("audio package file couldn't be opened");
	
	const export_entry *audiolist = FINDEXP(EM_NAME_C(conaudiolistname));
	if(!audiolist) TODOEXIT("proper ConAudioList not found in export table");
	
	long int audioexpidx = getconaudiolistentry(audiolist, soundid) - 1;
	if(audioexpidx < 0) TODOEXIT("ConAudioList entry doesn't refer to an export entry");

	if(audioexpidx >= pd.expcount) TODOEXIT("ConAudioList entry out of export index bounds");
	
	sounddata sdata = getsounddata(&pd.exports[audioexpidx]);
	
	FILE *outfile = fopen(outfilename, "wb");
	if(!outfile){
		printf("Failed to open output file.\n");
		goto fail_rebind_and_end;
	}
	
	printf("Writing sound (format %s) data to file %s ...\n", sdata.format, outfilename);
	
	long int i;
	for(i = 0; i < sdata.size; i++) fputc(sdata.data[i], outfile);
	
	fclose(outfile);
	
	printf("Done.\n");
	
	if(!usepackage(curpackname)) TODOEXIT("text package file couldn't be opened");
	
	return 1;
	
	fail_rebind_and_end:
	if(!usepackage(curpackname)) TODOEXIT("text package file couldn't be opened");
	return 0;
}
