#ifndef UECONV_GUARD_MISC_H
#define UECONV_GUARD_MISC_H

#include <stdio.h>
#include <stdlib.h>

#define WORD_SIZE 2
#define DWORD_SIZE 4

#define ARRLEN(ARR) ((int)(sizeof(ARR)/sizeof(*(ARR))))

#define TODOFAILMSG(MSG) todofailmsg((MSG), __LINE__, __FILE__)
#define TODOEXIT(MSG) todoexit((MSG), __LINE__, __FILE__)

#define TEMPSPRINTF1024(FORMAT, ...) tempsprintf((char[1024]){0}, FORMAT, __VA_ARGS__)

typedef struct{
	char *buf;
	int len;
	int cap;
}stringbuffer;
	
char *strcasestr(const char *haystack, const char *needle);
int strcasecmp(const char *a, const char *b);
long int readfile_a(const char *filename, unsigned char **bufptr); // -1 when fopen fails
int startswith(const char *text, const char *prefix);
int startswithword(const char *text, const char *prefix, const char *delims);
const char *skipchars(const char *ptr, const char *chars);
const char *nextword(const char *ptr, const char *delims);
void outbytes(const unsigned char *ptr, int count);
const unsigned char *findchars(const unsigned char *haystack, int hslen, const unsigned char *needle);
const unsigned char *findcharsi(const unsigned char *haystack, int hslen, const unsigned char *needle);
int prompt_specify_str(char *dst, int dstsize, const char *promptname);
long int intbytes(const unsigned char *ptr, int count);
int complen(const unsigned char *ptr);
long int readcomp(const unsigned char *ptr);
long int min(long int a, long int b);
long int max(long int a, long int b);
long int divround(long int n, long int d);
void replace(stringbuffer *dst, const char *text, const char *const *from, const char *const *to, int *used, int num, int consume_escapes);
char *tempsprintf(char *dst, const char *format, ...);
void todofailmsg(const char *msg, int line, const char *file);
void todoexit(const char *msg, int line, const char *file);

int sbprintf(stringbuffer *dst, const char *format, ...);
void fgetl(stringbuffer *dst, FILE *in);

#endif
