#include "packdata.h"
#include "misc.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

packdata pd = {0};
int pd_usecache = 1;

static packdata *packagecache = NULL;
static int cachenum = 0;

int usepackage(const char *filename){
	printf("Loading package file %s ...\n", filename);
	
	int i;
	for(i = 0; i < cachenum; i++){
		if(!strcmp(packagecache[i].packagename, filename)) break;
	}
	if(i < cachenum){
		printf("Found in cache.\n");
		pd = packagecache[i];
	}
	else{
		unsigned char *newdata = NULL;
		long int newdatalen = 0;
		name_entry *newnames = NULL;
		long int newnamecount = 0;
		export_entry *newexports = NULL;
		long int newexpcount = 0;
		import_entry *newimports = NULL;
		long int newimpcount = 0;
		
		newdatalen = readfile_a(filename, &newdata);
		if(newdatalen < 0){
			printf("Couldn't open file.\n");
			return 0;
		}
		
		unsigned char *dtemp = realloc(newdata, newdatalen+1);
		if(!dtemp) TODOEXIT("memory allocation failure");
		newdata = dtemp;
		newdata[newdatalen] = 0;
		
		const unsigned char *header = newdata;
		
		/*
		printf("size %ld\n", datalen);
		
		printf(
			"header:\n"
			" signature: 0x%x\n"
			" packageversion: %d\n"
			" licensemode: 0x%x\n\n",
			(unsigned int)intbytes(header, DWORD_SIZE),
			(unsigned int)intbytes(header + 4, WORD_SIZE),
			(unsigned int)intbytes(header + 6, WORD_SIZE)
		);
		*/
		
		if(newdatalen < 32 + DWORD_SIZE) TODOEXIT("file too short to contain header");
		
		newnamecount = intbytes(header + 12, DWORD_SIZE);
		newexpcount = intbytes(header + 20, DWORD_SIZE);
		newimpcount = intbytes(header + 28, DWORD_SIZE);
		
		newnames = malloc(sizeof(name_entry) * newnamecount);
		if(!newnames) TODOEXIT("memory allocation failure");

		newexports = malloc(sizeof(export_entry) * newexpcount);
		if(!newexports) TODOEXIT("memory allocation failure");

		newimports = malloc(sizeof(import_entry) * newimpcount);
		if(!newimports) TODOEXIT("memory allocation failure");
		
		const unsigned char *nametable = newdata + intbytes(header + 16, DWORD_SIZE);
		const unsigned char *exptable = newdata + intbytes(header + 24, DWORD_SIZE);
		const unsigned char *imptable = newdata + intbytes(header + 32, DWORD_SIZE);
		
		if(nametable >= newdata + newdatalen) TODOEXIT("name table offset bigger than file size");
		
		if(exptable >= newdata + newdatalen) TODOEXIT("export table offset bigger than file size");
		
		if(imptable >= newdata + newdatalen) TODOEXIT("import table offset bigger than file size");
		
		const unsigned char *ptr;
		
		/*
		printf(
			"name table offset %ld, length %ld\n"
			"export table offset %ld, length %ld\n"
			"import table offset %ld, length %ld\n\n",
			nametable - data, namecount,
			exptable - data, expcount,
			imptable - data, impcount
		);
		*/
		
		// TODO name, class, package etc. referenssicheckit
		
		ptr = nametable;
		for(i = 0; i < newnamecount; i++){
			newnames[i].tableidx = i;
			newnames[i].str = ptr + 1;
			ptr += *ptr + 1;
			if(ptr + DWORD_SIZE > newdata + newdatalen) break;
			newnames[i].flags = intbytes(ptr, DWORD_SIZE);
			ptr += DWORD_SIZE;
		}
		if(i < newnamecount) TODOEXIT("name table doesn't end before file ends");
		
		ptr = exptable;
		for(i = 0; i < newexpcount; i++){
			newexports[i].tableidx = i;
			newexports[i].class = readcomp(ptr);
			ptr += complen(ptr);
			if(ptr > newdata + newdatalen) break;
			newexports[i].super = readcomp(ptr);
			ptr += complen(ptr);
			if(ptr + DWORD_SIZE > newdata + newdatalen) break;
			newexports[i].package = intbytes(ptr, DWORD_SIZE);
			ptr += DWORD_SIZE;
			newexports[i].objname = &newnames[readcomp(ptr)];
			ptr += complen(ptr);
			if(ptr + DWORD_SIZE > newdata + newdatalen) break;
			newexports[i].flags = intbytes(ptr, DWORD_SIZE);
			ptr += DWORD_SIZE;
			newexports[i].size = readcomp(ptr);
			ptr += complen(ptr);
			if(ptr > newdata + newdatalen) break;
			if(newexports[i].size > 0){
				newexports[i].offset = readcomp(ptr);
				ptr += complen(ptr);
				if(ptr > newdata + newdatalen) break;
			}
			else newexports[i].offset = -1;
		}
		if(i < newexpcount) TODOEXIT("export table doesn't end before file ends");

		ptr = imptable;
		for(i = 0; i < newimpcount; i++){
			newimports[i].tableidx = i;
			newimports[i].packagename = &newnames[readcomp(ptr)];
			ptr += complen(ptr);
			if(ptr > newdata + newdatalen) break;
			newimports[i].classname = &newnames[readcomp(ptr)];
			ptr += complen(ptr);
			if(ptr + DWORD_SIZE > newdata + newdatalen) break;
			newimports[i].package = intbytes(ptr, DWORD_SIZE);
			ptr += DWORD_SIZE;
			newimports[i].objname = &newnames[readcomp(ptr)];
			ptr += complen(ptr);
			if(ptr > newdata + newdatalen) break;
		}
		if(i < newimpcount) TODOEXIT("import table doesn't end before file ends");
		
		if(!pd_usecache) freepackages();
		
		packdata *newpackagecache = realloc(packagecache, (cachenum + 1) * sizeof(packdata));
		if(!newpackagecache) TODOEXIT("memory allocation failure");

		packagecache = newpackagecache;
		packagecache[cachenum].packagename = malloc(strlen(filename) + 1);
		if(!packagecache[cachenum].packagename) TODOEXIT("memory allocation failure");
		
		strcpy(packagecache[cachenum].packagename, filename);
		packagecache[cachenum].data = newdata;
		packagecache[cachenum].datalen = newdatalen;
		packagecache[cachenum].names = newnames;
		packagecache[cachenum].namecount = newnamecount;
		packagecache[cachenum].exports = newexports;
		packagecache[cachenum].expcount = newexpcount;
		packagecache[cachenum].imports = newimports;
		packagecache[cachenum].impcount = newimpcount;
		
		pd = packagecache[cachenum];
		
		cachenum++;
	}
	
	printf("Loaded.\n");
	
	return 1;
}

void freepackages(void){
	int i;
	for(i = 0; i < cachenum; i++){
		free(packagecache[i].packagename);
		free(packagecache[i].data);
		free(packagecache[i].names);
		free(packagecache[i].exports);
		free(packagecache[i].imports);
	}
	free(packagecache);
	packagecache = NULL;
	cachenum = 0;
	return;
}
