#include "packfind.h"
#include "misc.h"
#include "packdata.h"
#include "objtools.h"

#include <string.h>
#include <stdio.h>

int nm_str(const name_entry *name, const void *ref){
	return !strcasecmp(name->str, ref);
}

int nm_str_c(const name_entry *name, const void *ref){
	return !!strcasestr(name->str, ref);
}

int em_name(const export_entry *exp, const void *ref){
	return !strcasecmp(exp->objname->str, ref);
}

int em_name_c(const export_entry *exp, const void *ref){
	return !!strcasestr(exp->objname->str, ref);
}

int em_strprop(const export_entry *exp, const void *ref){
	const propstrref *pref = ref;
	
	const char *val = getobjstrprop(exp, pref->name);
	return (val && !strcasecmp(pref->val, val)) || (val == NULL && ref == NULL);
}

int em_strprop_c(const export_entry *exp, const void *ref){
	const propstrref *pref = ref;
	const char *val = getobjstrprop(exp, pref->name);
	return val && strcasestr(val, pref->val);
}

int em_data_c(const export_entry *exp, const void *ref){
	return !!findcharsi(pd.data + exp->offset, exp->size, ref);
}

int em_multi(const export_entry *exp, const void *ref){
	const export_requirement *rref = ref;
	long int i;
	for(i = 0; rref[i].matcher; i++){
		if(!rref[i].matcher(exp, rref[i].refdata)) return 0;
	}
	return 1;
}

int em_sub(const export_entry *exp, const void *ref){
	const export_submatch *sref = ref;
	
	const export_entry *sub = getobjexprefprop(exp, sref->name);
	return sub && sref->subreq->matcher(sub, sref->subreq->refdata);
}

int em_oneof(const export_entry *exp, const void *ref){
	const export_requirement *rref = ref;
	long int i;
	for(i = 0; rref[i].matcher; i++){
		if(rref[i].matcher(exp, rref[i].refdata)) return 1;
	}
	return 0;
}

int em_classim(const export_entry *exp, const void *ref){
	const import_requirement *iref = ref;
	return exp->class < 0 && iref->matcher(&pd.imports[-exp->class-1], iref->refdata);
}

int em_expref(const export_entry *exp, const void *ref){
	const propexpref *pref = ref;
	const export_entry *val = getobjexprefprop(exp, pref->name);
	return val == pref->val;
}

int em_iter(const export_entry *exp, const void *ref){
	const export_submatch *sref = ref;
	
	const export_entry *iter = exp;
	while(iter){
		if(sref->subreq->matcher(iter, sref->subreq->refdata)) return 1;
		iter = getobjexprefprop(iter, sref->name);
	}
	return 0;
}

int em_not(const export_entry *exp, const void *ref){
	const export_requirement *rref = ref;
	return !rref->matcher(exp, rref->refdata);
}

int em_id(const export_entry *exp, const void *ref){
	const export_requirement *rref = ref;
	return rref->matcher(exp, rref->refdata);
}

int im_name(const import_entry *imp, const void *ref){
	return !strcasecmp(imp->objname->str, ref);
}

int im_name_c(const import_entry *imp, const void *ref){
	return !!strcasestr(imp->objname->str, ref);
}

int im_oneof(const import_entry *imp, const void *ref){
	const import_requirement *iref = ref;
	long int i;
	for(i = 0; iref[i].matcher; i++){
		if(iref[i].matcher(imp, iref[i].refdata)) return 1;
	}
	return 0;
}

name_entry *findname(nmatch matcher, const void *ref){
	long int i;
	for(i = 0; i < pd.namecount; i++){
		if(matcher(&pd.names[i], ref)) return &pd.names[i];
	}
	return NULL;
}

export_entry *findexp(ematch matcher, const void *ref){
	long int i;
	for(i = 0; i < pd.expcount; i++){
		if(matcher(&pd.exports[i], ref)) return &pd.exports[i];
	}
	return NULL;
}

import_entry *findimp(imatch matcher, const void *ref){
	long int i;
	for(i = 0; i < pd.expcount; i++){
		if(matcher(&pd.imports[i], ref)) return &pd.imports[i];
	}
	return NULL;
}

long int countnames(nmatch matcher, const void *ref){
	long int i, res = 0;
	for(i = 0; i < pd.namecount; i++){
		if(matcher(&pd.names[i], ref)) res++;
	}
	return res;
}

long int countexps(ematch matcher, const void *ref){
	long int i, res = 0;
	for(i = 0; i < pd.expcount; i++){
		if(matcher(&pd.exports[i], ref)) res++;
	}
	return res;
}

long int countimps(imatch matcher, const void *ref){
	long int i, res = 0;
	for(i = 0; i < pd.impcount; i++){
		if(matcher(&pd.imports[i], ref)) res++;
	}
	return res;
}

int speecheventobjmatches(const export_entry *exp, const char *spoken_by, const char *spoken_at, const char *text){
	return EMATCH(exp,
		EM_MULTI(
			EM_STRPROP_C("speakerName", spoken_by),
			EM_STRPROP_C("speakingToName", spoken_at),
			EM_SUB("conSpeech",
				EM_STRPROP_C("speech", text))));
}
