#include "debug_tools.h"
#include "packdata.h"
#include "packfind.h"
#include "objtools.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void debug_file(const char *debugfilename){
	usepackage(debugfilename);
	
	int loop = 1;
	const char *delims = " ";
	while(loop){
		char line[128];
		printf("> ");
		fgets(line, sizeof(line), stdin);
		char *nlidx = strchr(line, '\n');
		if(!nlidx) printf("line too long (max %u)\n", (unsigned int)sizeof(line));
		else{
			*nlidx = '\0';
			const char *start = skipchars(line, delims);
			const char *params = nextword(line, delims);
			
			if(startswithword(start, "exit", delims)) loop = 0;
			else if(startswithword(start, "shown", delims)){
				long int idx = strtol(params, NULL, 0);
				printname(&pd.names[idx]);
			}
			else if(startswithword(start, "showe", delims)){
				long int idx = strtol(params, NULL, 0);
				printexport(&pd.exports[idx]);
			}
			else if(startswithword(start, "showeo", delims)){
				long int idx = strtol(params, NULL, 0);
				printobj(&pd.exports[idx]);
			}
			else if(startswithword(start, "showi", delims)){
				long int idx = strtol(params, NULL, 0);
				printimport(&pd.imports[idx]);
			}
			else if(startswithword(start, "findn", delims)){
				findnames(nm_str_c, params);
			}
			else if(startswithword(start, "finden", delims)){
				findexps(em_name_c, params);
			}
			else if(startswithword(start, "findeo", delims)){
				findexps(em_data_c, params);
			}
			else if(startswithword(start, "findin", delims)){
				findimps(im_name_c, params);
			}
			else if(startswithword(start, "outbytes", delims)){
				outbytes((const unsigned char*)strtol(params, NULL, 0), strtol(nextword(params, delims), NULL, 0));
			}
			else if(startswithword(start, "objprint", delims)){
				printobjprop((const unsigned char*)strtol(params, NULL, 0), strtol(nextword(params, delims), NULL, 0));
			}
			else if(startswithword(start, "listn", delims)){
				long int first = 0, last = pd.namecount - 1;
				if(*params){
					first = strtol(params, NULL, 0);
					last = strtol(nextword(params, delims), NULL, 0);
				}
				printf("names:\n");
				int i;
				for(i = first; i <= last; i++) printname(&pd.names[i]);
				printf("\n");
			}
			else if(startswithword(start, "liste", delims)){
				long int first = 0, last = pd.expcount - 1;
				if(*params){
					first = strtol(params, NULL, 0);
					last = strtol(nextword(params, delims), NULL, 0);
				}
				
				printf("exports:\n");
				int i;
				for(i = first; i <= last; i++) printexport(&pd.exports[i]);
				printf("\n");
			}
			else if(startswithword(start, "listi", delims)){
				long int first = 0, last = pd.impcount - 1;
				if(*params){
					first = strtol(params, NULL, 0);
					last = strtol(nextword(params, delims), NULL, 0);
				}
								
				printf("imports:\n");
				int i;
				for(i = first; i <= last; i++) printimport(&pd.imports[i]);
				printf("\n");
			}
			
			else if(*start) printf("no such command\n");
		}
	}
}

const char *impexps(long int idx){
	return idx > 0 ? "export" : idx < 0 ? "import" : "null";
}

long int impexpi(long int idx){
	return idx > 0 ? idx-1 : idx < 0 ? -idx-1 : 0;
}

void printname(const name_entry *ptr){
	printf(" name %ld: %s; %08lx\n", (long int)(ptr - pd.names), ptr->str, ptr->flags);
}

void printexport(const export_entry *ptr){
	long int c = ptr->class;
	long int s = ptr->super;
	long int p = ptr->package;
	printf(
		" export %ld:\n"
		"  class %ld 0x%lx (%s %ld 0x%lx)\n"
		"  super %ld 0x%lx (%s %ld 0x%lx)\n"
		"  package %ld 0x%lx (%s %ld 0x%lx)\n"
		"  objname %s\n"
		"  flags %08lx\n"
		"  size %ld 0x%lx\n"
		"  offset %ld 0x%lx\n",
		(long int)(ptr - pd.exports),
		c, c, impexps(c), impexpi(c), impexpi(c),
		s, s, impexps(s), impexpi(s), impexpi(s),
		p, p, impexps(p), impexpi(p), impexpi(p),
		ptr->objname->str,
		ptr->flags,
		ptr->size, ptr->size,
		ptr->offset, ptr->offset
	);
}

void printimport(const import_entry *ptr){
	printf(
		" import %ld:\n"
		"  packagename %s\n"
		"  classname %s\n"
		"  package %ld 0x%lx (%s %ld 0x%lx)\n"
		"  objname %s\n",
		(long int)(ptr - pd.imports),
		ptr->packagename->str, ptr->classname->str,
		ptr->package, ptr->package, impexps(ptr->package), impexpi(ptr->package), impexpi(ptr->package),
		ptr->objname->str
	);
}

void printobjprop(const unsigned char *origptr, long int size){
	outbytes(origptr, size);
	
	const unsigned char *ptr = origptr;
	
	long int nameidx = readcomp(ptr);
	while(strcasecmp(pd.names[nameidx].str, "None")){
		outbytes(ptr, size - (ptr - origptr));
		printf(" prop name %ld 0x%lx (%s)\n", nameidx, nameidx, pd.names[nameidx].str);
		ptr += complen(ptr);
		unsigned char infobyte = *ptr++;
		printf(" prop infobyte 0x%x\n", infobyte);
		
		int type = infobyte & 0xf;
		int sizeclass = (infobyte >> 4) & 0x7;
		int arrayboolflag = (infobyte >> 7) & 1;
		printf("  type %i 0x%x\n  arrayflag/boolean %i\n  sizeclass %i\n", type, type, arrayboolflag, sizeclass);
		long int size;
		printf("   size ");
		if(sizeclass < 5){
			size = (int[]){1, 2, 4, 12, 16}[sizeclass];
			printf("predef %li\n", size);
		}
		else if(sizeclass == 5){
			size = *ptr++;
			printf("byte %li 0x%lx\n", size, size);
		}
		else if(sizeclass == 6){
			size = intbytes(ptr, WORD_SIZE);
			ptr += WORD_SIZE;
			printf("word %li 0x%lx\n", size, size);
		}
		else{
			size = intbytes(ptr, DWORD_SIZE);
			ptr += DWORD_SIZE;
			printf("dword %li 0x%lx\n", size, size);
		}
		
		if(arrayboolflag && type != 0x03){
			if((*ptr)&0x80){
				printf("   arrayidx > 127\n");
				getchar();
			}
			else{
				printf("   arrayidx %d 0x%d\n", *ptr, *ptr);
				ptr++;
			}
		}
		
		printf("  type: ");
		if(type == 0x01){
			printf("byte\n");
			printf("  value %d\n", *ptr); 
		}
		else if(type == 0x02){
			printf("int\n");
			printf("  value %ld\n", intbytes(ptr, DWORD_SIZE));
		}
		else if(type == 0x03){
			printf("bool\n");
			printf("  value %d\n", arrayboolflag);
		}
		else if(type == 0x04){
			printf("float\n");
			long int bytes = intbytes(ptr, DWORD_SIZE);
			printf("  value %f\n", *(float*)&bytes);
		}
		else if(type == 0x05){
			printf("obj\n");
			long int objref = readcomp(ptr);
			printf("  ref %ld 0x%lx (%s %ld 0x%lx; objname %s)\n",
				objref, objref, impexps(objref), impexpi(objref), impexpi(objref),
				objref < 0 ? pd.imports[-objref-1].objname->str : objref > 0 ? pd.exports[objref-1].objname->str : "n/a"
			);
		}
		else if(type == 0x06){
			printf("name\n");
			printf("  value %ld 0x%lx (%s)\n", readcomp(ptr), readcomp(ptr), pd.names[readcomp(ptr)].str);
		}
		else if(type == 0x07){
			printf("string\n");
			printf("  ???\n");
			getchar();
		}
		else if(type == 0x08){
			printf("class\n");
			printf("  ---\n");
			getchar();
		}
		else if(type == 0x09){
			printf("array\n");
			printf("  ???\n");
			getchar();
		}
		else if(type == 0x0a){
			printf("struct\n");
			printf("  ---\n");
			getchar();
		}
		else if(type == 0x0b){
			printf("vector\n");
			printf("  ???\n");
			getchar();
		}
		else if(type == 0x0c){
			printf("rotator\n");
			printf("  ???\n");
			getchar();
		}
		else if(type == 0x0d){
			printf("str\n");
			long int length = readcomp(ptr);
			printf("  length %ld 0x%lx, value %s\n", length, length, ptr + complen(ptr));
		}
		else if(type == 0x0e){
			printf("map\n");
			printf("  ???\n");
			getchar();
		}
		else if(type == 0x0f){
			printf("fixedarray\n");
			printf("  ???\n");
			getchar();
		}
		
		ptr += size;
		nameidx = readcomp(ptr);
	}
	ptr += complen(ptr);
	
	if(ptr == origptr + size){
		printf("all consumed\n");
	}
	else outbytes(ptr, size - (ptr - origptr));
	printf("\n");
	return;
}

void printobj(const export_entry *ptr){
	printobjprop(pd.data + ptr->offset, ptr->size);
	printf("\n");
}

void findnames(nmatch matcher, const void *ref){
	long int i;
	for(i = 0; i < pd.namecount; i++){
		if(matcher(&pd.names[i], ref)){
			printname(&pd.names[i]);
			printf("(hit return to look for more, enter any other character to stop)\n");
			while(getchar() != '\n'){
				while(getchar() != '\n');
				return;
			}
		}
	}
	return;
}

void findexps(ematch matcher, const void *ref){
	long int i;
	for(i = 0; i < pd.expcount; i++){
		if(matcher(&pd.exports[i], ref)){
			printexport(&pd.exports[i]);
			printf("(hit return to look for more, enter any other character to stop)\n");
			while(getchar() != '\n'){
				while(getchar() != '\n');
				return;
			}
		}
	}
	return;
}

void findimps(imatch matcher, const void *ref){
	long int i;
	for(i = 0; i < pd.impcount; i++){
		if(matcher(&pd.imports[i], ref)){
			printimport(&pd.imports[i]);
			printf("(hit return to look for more, enter any other character to stop)\n");
			while(getchar() != '\n'){
				while(getchar() != '\n');
				return;
			}
		}
	}
	return;
}
