#include "objtools.h"
#include "misc.h"
#include "packdata.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

objprop getobjpropat(const unsigned char *ptr){
	objprop result;
	
	long int nameidx = readcomp(ptr);
	ptr += complen(ptr);
	result.name = pd.names[nameidx].str;
	
	if(!strcasecmp(result.name, "none")){
		result.type = PROPTYPE_NONE;
		return result;
	}
	
	unsigned char infobyte = *ptr++;
	int type = infobyte & 0xf;
	int sizeclass = (infobyte >> 4) & 0x7;
	int arrayboolflag = (infobyte >> 7) & 1;
	long int size;
	static const int sizes[] = {1, 2, 4, 12, 16};
	if(sizeclass < 5) size = sizes[sizeclass];
	else if(sizeclass == 5) size = *ptr++;
	else if(sizeclass == 6){
		size = intbytes(ptr, WORD_SIZE);
		ptr += WORD_SIZE;
	}
	else{
		size = intbytes(ptr, DWORD_SIZE);
		ptr += DWORD_SIZE;
	}
	
	if(arrayboolflag && type != 0x03){
		/*
		if((*ptr)&0x80){
			printf("   arrayidx > 127\n");
			getchar();
		}
		else ptr++;
		*/
		ptr++;
	}
	
	if(type == 0x01){
		result.type = PROPTYPE_INT;
		result.v.intvalue = *ptr;
	}
	else if(type == 0x02){
		result.type = PROPTYPE_INT;
		result.v.intvalue = intbytes(ptr, DWORD_SIZE);
	}
	else if(type == 0x03){
		result.type = PROPTYPE_INT;
		result.v.intvalue = arrayboolflag;
	}
	else if(type == 0x04){
		result.type = PROPTYPE_FLOAT;
		long int bytes = intbytes(ptr, DWORD_SIZE);
		result.v.floatvalue = *(float*)&bytes;
	}
	else if(type == 0x05){
		long int objref = readcomp(ptr);
		if(objref < 0){
			result.type = PROPTYPE_IMPREF;
			result.v.imprefvalue = &pd.imports[-objref - 1];
		}
		else if(objref > 0){
			result.type = PROPTYPE_EXPREF;
			result.v.exprefvalue = &pd.exports[objref - 1];
		}
		else result.type = PROPTYPE_NULLREF;
	}
	else if(type == 0x06){
		result.type = PROPTYPE_NAME;
		result.v.namevalue = pd.names[readcomp(ptr)].str;
	}
	else if(type == 0x07) result.type = PROPTYPE_INVALID;
	else if(type == 0x08) result.type = PROPTYPE_INVALID;
	else if(type == 0x09) result.type = PROPTYPE_INVALID;
	else if(type == 0x0a) result.type = PROPTYPE_INVALID;
	else if(type == 0x0b) result.type = PROPTYPE_INVALID;
	else if(type == 0x0c) result.type = PROPTYPE_INVALID;
	else if(type == 0x0d){
		result.type = PROPTYPE_STR;
		result.v.strvalue = ptr + complen(ptr);
	}
	else if(type == 0x0e) result.type = PROPTYPE_INVALID;
	else if(type == 0x0f) result.type = PROPTYPE_INVALID;
	
	result.nextprop = ptr + size;
	
	return result;
}

objprop getobjprop(const export_entry *obj, const char *name){
	if(!obj) return (objprop){NULL};
	
	const unsigned char *ptr = pd.data + obj->offset;
	
	objprop prop = getobjpropat(ptr);
	while(prop.type != PROPTYPE_NONE && strcasecmp(prop.name, name)) prop = getobjpropat(prop.nextprop);
	return prop;
}

const unsigned char *getobjdata(const export_entry *obj){
	if(!obj) return NULL;
	
	const unsigned char *ptr = pd.data + obj->offset;
	
	objprop dummyprop = getobjpropat(ptr);
	while(dummyprop.type != PROPTYPE_NONE){
		ptr = dummyprop.nextprop;
		dummyprop = getobjpropat(ptr);
	}
	return ptr + 1;
}

const char *getobjstrprop(const export_entry *obj, const char *name){
	if(!obj) return NULL;
	
	objprop prop = getobjprop(obj, name);
	if(prop.type == PROPTYPE_STR) return prop.v.strvalue;
	
	return NULL;
}

const export_entry *getobjexprefprop(const export_entry *obj, const char *name){
	if(!obj) return NULL;
	
	objprop prop = getobjprop(obj, name);
	if(prop.type == PROPTYPE_EXPREF) return prop.v.exprefvalue;
	
	return NULL;
}

long int getobjintprop(const export_entry *obj, const char *name, int *ok){
	if(!obj) return 0;
	
	if(ok) *ok = 0;
	objprop prop = getobjprop(obj, name);
	if(prop.type == PROPTYPE_INT){
		if(ok) *ok = 1;
		return prop.v.intvalue;
	}
	
	return 0;
}

const char *getobjnameprop(const export_entry *obj, const char *name){
	if(!obj) return NULL;
	
	objprop prop = getobjprop(obj, name);
	if(prop.type == PROPTYPE_NAME) return prop.v.namevalue;
	
	return NULL;
}

sounddata getsounddata(const export_entry *obj){
	if(!obj) return (sounddata){NULL, -1, NULL};
	
	const unsigned char *ptr = getobjdata(obj);
	
	sounddata result;
	
	result.format = pd.names[readcomp(ptr)].str;
	ptr += complen(ptr);
	
	ptr += DWORD_SIZE;
	
	result.size = readcomp(ptr);
	ptr += complen(ptr);
	
	result.data = ptr;
	
	return result;
}

long int getconaudiolistentry(const export_entry *obj, long int idx){
	if(!obj) return -1;
	
	long int i;
	const unsigned char *ptr = getobjdata(obj);
	
	long int count = readcomp(ptr);
	ptr += complen(ptr);
	
	for(i = 0; i < count; i++){
		if(i == idx) return readcomp(ptr);
		ptr += complen(ptr);
	}
	
	return count;
}
