#ifndef UECONV_GUARD_OBJTOOLS_H
#define UECONV_GUARD_OBJTOOLS_H

#include "packdata.h"

typedef enum{
	PROPTYPE_INT,
	PROPTYPE_FLOAT,
	PROPTYPE_STR,
	PROPTYPE_NAME,
	PROPTYPE_EXPREF,
	PROPTYPE_IMPREF,
	PROPTYPE_NULLREF,
	PROPTYPE_NONE,
	PROPTYPE_INVALID
}proptype;

typedef struct{
	const char *name;
	proptype type;
	union{
		long int intvalue;
		const char *namevalue;
		float floatvalue;
		const char *strvalue;
		const export_entry *exprefvalue;
		const import_entry *imprefvalue;
	} v;
	const unsigned char *nextprop;
}objprop;

objprop getobjpropat(const unsigned char *ptr);
objprop getobjprop(const export_entry *obj, const char *name);
const unsigned char *getobjdata(const export_entry *obj);

const char *getobjstrprop(const export_entry *obj, const char *name);
const export_entry *getobjexprefprop(const export_entry *obj, const char *name);
long int getobjintprop(const export_entry *obj, const char *name, int *ok);
const char *getobjnameprop(const export_entry *obj, const char *name);

typedef struct{
	const char *format;
	long int size;
	const char *data;
}sounddata;

sounddata getsounddata(const export_entry *obj);
long int getconaudiolistentry(const export_entry *obj, long int idx);

#endif
