#ifndef UECONV_GUARD_PACKDATA_H
#define UECONV_GUARD_PACKDATA_H

typedef struct{
	long int tableidx;
	const char *str;
	long int flags;
}name_entry;

typedef struct{
	long int tableidx;
	long int class;
	long int super;
	long int package;
	name_entry *objname;
	long int flags;
	long int size;
	long int offset;
}export_entry;

typedef struct{
	long int tableidx;
	name_entry *packagename;
	name_entry *classname;
	long int package;
	name_entry *objname;
}import_entry;

typedef struct{
	char *packagename;
	unsigned char *data;
	long int datalen;
	name_entry *names;
	long int namecount;
	export_entry *exports;
	long int expcount;
	import_entry *imports;
	long int impcount;
}packdata;

extern packdata pd;
extern int pd_usecache;

int usepackage(const char *filename); // 0 when fopen fails, 1 otherwise
void freepackages(void);

#endif
