#ifndef UECONV_GUARD_PACKFIND_H
#define UECONV_GUARD_PACKFIND_H

#include "misc.h"
#include "packdata.h"

typedef int nmatch(const name_entry*, const void*);
typedef int ematch(const export_entry*, const void*);
typedef int imatch(const import_entry*, const void*);

typedef struct{
	const char *name, *val;
}propstrref;

typedef struct{
	const char *name;
	const export_entry *val;
}propexpref;

typedef struct{
	ematch *matcher;
	const void *refdata;
}export_requirement;

typedef struct{
	const char *name;
	export_requirement *subreq;
}export_submatch;

typedef struct{
	imatch *matcher;
	const void *refdata;
}import_requirement;

nmatch
	nm_str,
	nm_str_c;

ematch
	em_name,
	em_name_c,
	em_strprop,
	em_strprop_c,
	em_data_c,
	em_multi,
	em_sub,
	em_oneof,
	em_classim,
	em_expref,
	em_iter,
	em_not,
	em_id;

#define EMATCH(EXP, REQ) em_id((EXP), &(export_requirement)REQ)

#define EM_NAME_C(NAME) {em_name, (NAME)}
#define EM_STRPROP_C(NAME, VAL) {em_strprop_c, &(propstrref){(NAME), (VAL)}}
#define EM_MULTI(...) {em_multi, (export_requirement[]){__VA_ARGS__, {0}}}
#define EM_SUB(NAME, SUBMATCH) {em_sub, &(export_submatch){(NAME), &(export_requirement)SUBMATCH}}
#define EM_CLASSIM(IREQ) {em_classim, &(import_requirement)IREQ}

imatch
	im_name,
	im_name_c,
	im_oneof;

#define IM_NAME_C(NAME) {im_name_c, (NAME)}

name_entry *findname(nmatch matcher, const void *ref);
export_entry *findexp(ematch matcher, const void *ref);
import_entry *findimp(imatch matcher, const void *ref);

#define FINDEXP(REQ) findexp(em_id, &(export_requirement)REQ)

long int countnames(nmatch matcher, const void *ref);
long int countexps(ematch matcher, const void *ref);
long int countimps(imatch matcher, const void *ref);

#define COUNTEXPS(REQ) countexps(em_id, &(export_requirement)REQ)

int speecheventobjmatches(const export_entry *exp, const char *spoken_by, const char *spoken_at, const char *text);

#endif
