#include "tmpfiles.h"

#include "misc.h"

const char *tmpfname_speech;
const char *tmpfname_dot;
const char *tmpfname_png;
const char *tmpfname_plain;

static const char **const ptrs[] = {&tmpfname_speech, &tmpfname_dot, &tmpfname_png, &tmpfname_plain};

void inittmpfiles(void){
	static char bufs[ARRLEN(ptrs)][L_tmpnam];
	
	int i;
	for(i = 0; i < ARRLEN(ptrs); i++){
		if(!tmpnam(bufs[i])) TODOEXIT("tmpnam failed");
		#if UECONV_TMPNAM_WINHAX
		*ptrs[i] = bufs[i] + (bufs[i][0] == '\\');
		#else
		*ptrs[i] = bufs[i];
		#endif
		
		FILE *f = fopen(*ptrs[i], "wb");
		if(!f){
			printf("FAILURE: Opening %s failed.\n", *ptrs[i]);
			TODOEXIT("tmpnam'd file couldn't be opened");
		}
		fclose(f);
	}
	
	return;
}

void removetmpfiles(void){
	int i;
	for(i = 0; i < ARRLEN(ptrs); i++){
		if(remove(*ptrs[i])){
			TODOFAILMSG("remove failed");
			return;
		}
	}
	return;
}
