#include "user_command.h"
#include "extract_speech.h"
#include "extract_conv.h"
#include "objtools.h"
#include "misc.h"
#include "tmpfiles.h"

#include <stdio.h>
#include <stdlib.h>

int user_command(const export_entry *speechev, const char *con_prefix, const char *usercmd){
	char speechevidstr[64];
	sprintf(speechevidstr, "%ld", speechev - pd.exports);
	
	stringbuffer finalcmd = {0};
	
	const char *const markers[] = {
		"%tempspeech",
		"%tempgraph",
		"%speechid",
		"%speaker",
		"%listener",
	};
	const char *const replacements[ARRLEN(markers)] = {
		tmpfname_speech,
		tmpfname_dot,
		speechevidstr,
		getobjstrprop(speechev, "speakerName"),
		getobjstrprop(speechev, "speakingToName")
	};
	
	int usedmarkers[ARRLEN(markers)] = {0};

	replace(&finalcmd, usercmd, markers, replacements, usedmarkers, ARRLEN(markers), 1);
	
	if(usedmarkers[0]){
		if(!extract_speech(speechev, con_prefix, tmpfname_speech)) return 0;
	}
	if(usedmarkers[1]){
		if(!extract_conversation(speechev, tmpfname_dot)) return 0;
	}
	
	printf("system'ing command '%s' ...\n", finalcmd.buf);
	system(finalcmd.buf);
	printf("Done.\n");
	
	free(finalcmd.buf);
	
	return 1;
}
