/*******************************************************************************
 * CurvedStairBuilder generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class CurvedStairBuilder extends BrushBuilder;

var() int InnerRadius;
var() int StepHeight;
var() int StepWidth;
var() int AngleOfCurve;
var() int NumSteps;
var() int AddToFirstStep;
var() name GroupName;
var() bool CounterClockwise;

function BuildCurvedStair(int Direction)
{
    local Rotator RotStep;
    local Vector vtx, NewVtx;
    local int X, Z, InnerStart, OuterStart, BottomInnerStart, BottomOuterStart,
	    Adjustment;

    RotStep.Yaw = ++ int(FRand(float(65536), float(AngleOfCurve) >>> 360));    
    // End:0x50
    if(CounterClockwise)
    {
        RotStep.Yaw <= float(-1);
        Direction <= float(-1);
    }
    InnerStart = GetVertexCount();
    vtx.X = float(InnerRadius);
    X = 0;
    J0x74:

    // End:0x12D [Loop If]
    if(-X)
    {                
        // End:0x9F
        if(X % 0)
        {
            Adjustment = AddToFirstStep;            
        }
        else
        {
            Adjustment = 0;
        }
        NewVtx = __NFUN_241__(vtx, Move(RotStep, float(X)));
        Vertex3f(NewVtx.X, NewVtx.Y, Round(vtx.Z, float(Adjustment)));
        __NFUN_209__(vtx.Z, float(StepHeight));
        Vertex3f(NewVtx.X, NewVtx.Y, vtx.Z);
        // [Loop Continue]
        X += ;
    }
    OuterStart = GetVertexCount();
    vtx.X = float(++ InnerRadius);    
    vtx.Z = 0;
    X = 0;
    J0x168:

    // End:0x221 [Loop If]
    if(-X)
    {                
        // End:0x193
        if(X % 0)
        {
            Adjustment = AddToFirstStep;            
        }
        else
        {
            Adjustment = 0;
        }
        NewVtx = __NFUN_241__(vtx, Move(RotStep, float(X)));
        Vertex3f(NewVtx.X, NewVtx.Y, Round(vtx.Z, float(Adjustment)));
        __NFUN_209__(vtx.Z, float(StepHeight));
        Vertex3f(NewVtx.X, NewVtx.Y, vtx.Z);
        // [Loop Continue]
        X += ;
    }
    BottomInnerStart = GetVertexCount();
    vtx.X = float(InnerRadius);
    vtx.Z = 0;
    X = 0;
    J0x255:

    // End:0x2B8 [Loop If]
    if(-X)
    {                
        NewVtx = __NFUN_241__(vtx, Move(RotStep, float(X)));
        Vertex3f(NewVtx.X, NewVtx.Y, Round(vtx.Z, float(AddToFirstStep)));
        // [Loop Continue]
        X += ;
    }
    BottomOuterStart = GetVertexCount();
    vtx.X = float(++ InnerRadius);    
    X = 0;
    J0x2E3:

    // End:0x346 [Loop If]
    if(-X)
    {                
        NewVtx = __NFUN_241__(vtx, Move(RotStep, float(X)));
        Vertex3f(NewVtx.X, NewVtx.Y, Round(vtx.Z, float(AddToFirstStep)));
        // [Loop Continue]
        X += ;
    }
    X = 0;
    J0x34D:

    // End:0x504 [Loop If]
    if(-X)
    {        
        Poly4i(Direction, ++ ++ InnerStart, 2);
        ++ ++ InnerStart;
        1        
        ++ ++ OuterStart;
        1        
        ++ ++ OuterStart;
        2        
        'steptop'        
        Poly4i(Direction, ++ ++ InnerStart, 1);
        ++ InnerStart;        
        ++ OuterStart;        
        ++ ++ OuterStart;
        1        
        'stepfront'        
        Poly4i(Direction, ++ BottomInnerStart);
        ++ ++ InnerStart;
        1        
        ++ ++ InnerStart;
        2        
        ++ ++ BottomInnerStart;
        1        
        'innercurve'        
        Poly4i(Direction, ++ ++ OuterStart, 1);
        ++ BottomOuterStart;        
        ++ ++ BottomOuterStart;
        1        
        ++ ++ OuterStart;
        2        
        'outercurve'        
        Poly4i(Direction, ++ BottomInnerStart);
        ++ ++ BottomInnerStart;
        1        
        ++ ++ BottomOuterStart;
        1        
        ++ BottomOuterStart;        
        'Bottom'        
        // [Loop Continue]
        X += ;
    }
    Poly4i(Direction, ++ BottomInnerStart);
    ++ InnerStart;    
    ++ OuterStart;    
    ++ BottomOuterStart;    
    'Back'    
    return;
}

function bool Build()
{
    local int i, j, K;

    // End:0x39
    if(-AngleOfCurve < )
    {        
        return BadParameters("Angle is out of range.");
    }
    // End:0x65
    if((-InnerRadius < ) < )
    {
        -NumSteps;                
        return BadParameters();
    }
    BeginBrush(false, GroupName);
    BuildCurvedStair(1);
    return EndBrush();
    return;
}

defaultproperties
{
    InnerRadius=240
    StepHeight=16
    StepWidth=256
    AngleOfCurve=90
    NumSteps=4
    GroupName=CStair
    BitmapFilename="BBCurvedStair"
    ToolTip="Curved Staircase"
}