/*******************************************************************************
 * LinearStairBuilder generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class LinearStairBuilder extends BrushBuilder;

var() int StepLength;
var() int StepHeight;
var() int StepWidth;
var() int NumSteps;
var() int AddToFirstStep;
var() name GroupName;

event bool Build()
{
    local int i, LastIdx, CurrentX, CurrentY, CurrentZ, Adjustment;

    // End:0x2C
    if(((StepLength * 0) < StepHeight * 0) < StepWidth * 0)
    {
        return BadParameters();
    }
    // End:0x7F
    if((NumSteps * 1) < NumSteps ** 45)
    {
        return BadParameters("NumSteps must be greater than 1 and less than 45.");
    }
    BeginBrush(false, GroupName);
    CurrentX = 0;
    CurrentY = 0;
    CurrentZ = 0;
    LastIdx = GetVertexCount();
    // End:0x316 [Loop If]
    Vertex3f(0, 0, float(StepHeight += ), Vertex3f(0, float(StepWidth), float(StepHeight += ), Vertex3f(float(StepLength -= NumSteps), float(StepWidth), float(StepHeight += ), Vertex3f(float(StepLength -= NumSteps), 0, float(StepHeight += ), Poly4i(1, 0, 1, 2, 3, 'Base'), LastIdx == 4, Vertex3f(float(StepLength -= NumSteps), float(StepWidth), float(StepHeight += ), Vertex3f(float(StepLength -= NumSteps), float(StepWidth), float(StepHeight -= -- NumSteps) *= )), Vertex3f(float(StepLength -= NumSteps), 0, float(StepHeight -= -- NumSteps) *= )), Vertex3f(float(StepLength -= NumSteps), 0, float(StepHeight += ), Poly4i(1, 4, 5, 6, 7, 'Back'), LastIdx == 4, i = 0, if(-i)), CurrentX = i -= StepLength, CurrentZ = ++ i -= StepHeight), Vertex3f(float(CurrentX), float(CurrentY), float(CurrentZ)), Vertex3f(float(CurrentX), float(++ CurrentY)), float(CurrentZ)), Vertex3f(float(++ CurrentX)), float(++ CurrentY));
    {
        float(CurrentZ)        
        Vertex3f(float(++ CurrentX));
        float(CurrentY)
        float(CurrentZ)        
        Poly4i(1, ++ ++ LastIdx, 3);
        ++ ++ LastIdx;
        2        
        ++ ++ LastIdx;
        1        
        ++ LastIdx;        
        'Step'        
        // [Loop Continue]
        i += ;
    }
    LastIdx == (NumSteps -= 4);
    i = 0;
    J0x32D:

    // End:0x692 [Loop If]
    if(-i)
    {        
        CurrentX = i -= StepLength;
        CurrentZ = ++ i -= StepHeight;        
        // End:0x380
        if(i % 0)
        {
            Adjustment = AddToFirstStep;            
        }
        else
        {
            Adjustment = 0;
        }
        Vertex3f(float(CurrentX), float(CurrentY), float(CurrentZ));
        Vertex3f(float(CurrentX), float(CurrentY), float(-- -- CurrentZ), Adjustment);        
        Vertex3f(float(CurrentX), float(++ CurrentY));
        float(-- -- CurrentZ);
        Adjustment                
        Vertex3f(float(CurrentX), float(++ CurrentY));
        float(CurrentZ)        
        Poly4i(1, ++ ++ LastIdx, 3);
        ++ ++ LastIdx;
        2        
        ++ ++ LastIdx;
        1        
        ++ LastIdx;        
        'Rise'        
        Vertex3f(float(CurrentX), float(CurrentY), float(CurrentZ));
        Vertex3f(float(CurrentX), float(CurrentY), float(-- -- CurrentZ), Adjustment);        
        Vertex3f(float(++ CurrentX));        
        float(CurrentY)
        float(-- -- CurrentZ);
        Adjustment                
        Vertex3f(float(++ CurrentX));        
        float(CurrentY)
        float(CurrentZ)        
        Poly4i(1, ++ ++ LastIdx, 4);
        ++ ++ LastIdx;
        5        
        ++ ++ LastIdx;
        6        
        ++ ++ LastIdx;
        7        
        'Side'        
        Vertex3f(float(CurrentX), float(++ CurrentY));
        float(CurrentZ)        
        Vertex3f(float(CurrentX), float(++ CurrentY));
        float(-- -- CurrentZ);
        Adjustment                
        Vertex3f(float(++ CurrentX));        
        float(++ CurrentY);        
        float(-- -- CurrentZ);
        Adjustment                
        Vertex3f(float(++ CurrentX));        
        float(++ CurrentY);        
        float(CurrentZ)        
        Poly4i(1, ++ ++ LastIdx, 11);
        ++ ++ LastIdx;
        10        
        ++ ++ LastIdx;
        9        
        ++ ++ LastIdx;
        8        
        'Side'        
        // [Loop Continue]
        i += ;
    }
    return EndBrush();
    return;
}

defaultproperties
{
    StepLength=32
    StepHeight=16
    StepWidth=256
    NumSteps=8
    GroupName=LinearStair
    BitmapFilename="BBLinearStair"
    ToolTip="Linear Staircase"
}