/*******************************************************************************
 * ActionPoint generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class ActionPoint extends InfoActor
    native
    collapsecategories
    exportstructs
    notplaceable;

enum ECoverType
{
    COVER_Generic,
    COVER_Car,
    COVER_CopCar,
    COVER_Taxi,
    COVER_Bus,
    COVER_Wall,
    COVER_Pillar,
    COVER_Crate,
    COVER_Fence,
    COVER_Sandbags,
    COVER_Truck,
    COVER_Barrier
};

struct SActionPointJumpInfo
{
    var() name JumpType;
    var() float CollisionHeight;
    var() float CollisionRadius;
    var() int Padding;
    var() float StartHeight;
    var() float EndHeight;
    var() SJumpPreset JumpPreset;
};

struct SActionPointNeighborInfo
{
    var float PathDistance;
    var float ViewDistance;
    var float DotToAP;
    var float DotToAPDir;
    var float ForwardDistance;
    var int MaxPathID;
    var ActionPoint ActionPoint;
    var array<SActionPointJumpInfo> JumpToInfo;
};

var() noexport array<export Action> Actions "A list of actions that can be performed at this point.";
var() noexport array<export Action> SecondaryActions "A list of secondary actions that can be performed at this point.";
var() noexport array< class<BaseAI> > RestrictedClasses "An optional restricted list of classes that may use this point.";
var() noexport array<name> RestrictedTags "An optional restricted list of tags that may use this point.";
var() noexport int MinUses "The minimum number of times this point can be used per users before they have a chance to leave";
var() noexport int MaxUses "The maximum number of times this point can be used per users occupancy. (<= 0 for unlimited.)";
var noexport float LockOutPeriod "Minimum time period between users.";
var() noexport name DestroyTag "Trigger this event to destroy this action point... forever.";
var() noexport bool bSafeReload "Can this AP be used as a safe reload point?";
var() noexport bool ShrunkActionPoint "This AP will be used by shrunk AI.";
var bool bCheckShrunk;
var noexport float ClearRadius "Consider the AP clear/empty when no one is within this distance of it";
var() name ActionPointGroup;
var() bool bCanVault;
var bool bCanTeleport;
var noexport bool bFlyer "If true, some flyers will use this point.";
var noexport bool bJumpPoint "An AP to be jumped too/from (actionpoint_pregnator";
var() noexport ActionPoint.ECoverType CoverType "Defines the type of cover to be used when other AI spot someone using this point.";
var(ActionPoint_Editor) noexport bool bDrawEditorSelected "If true we'll draw FOV lines when selected";
var Actor User;
var Actor NeighborUser;
var int NumUses;
var float LockOutGate;
var Action CurAction;
var int DeathCount;
var float DeathTime;
var bool bLocked;
var Rotator StartingRotation;
var float ActionGate;
var transient array<int> dnNavAreas;
var int dnNavIndex;
var int MinAngleToTarget;
var int MaxAngleToTarget;
var noexport float MaxJumpDistance "Maximum straight line distance to other jumpable APs";
var bool bDebugJump;
var array<SActionPointNeighborInfo> CloseActionPoints;
var array<SActionPointNeighborInfo> FlankActionPoints;
var array<SActionPointNeighborInfo> RetreatActionPoints;
var array<SActionPointNeighborInfo> AdvanceActionPoints;
var array<SActionPointNeighborInfo> LateralActionPoints;
var array<SActionPointNeighborInfo> UnknownActionPoints;
var array<SActionPointNeighborInfo> WalkToActionPoints;
var array<SActionPointNeighborInfo> FlyToActionPoints;
var array<SActionPointNeighborInfo> VaultToActionPoints;
var array<SActionPointNeighborInfo> TeleportActionPoints;
var array<SActionPointJumpInfo> DefaultJumpToInfo;

// Export UActionPoint::execNative_InitActionPoint(FFrame&, void* const)
native function Native_InitActionPoint();

// Export UActionPoint::execIsCompletelyCompromised(FFrame&, void* const)
native function bool IsCompletelyCompromised(Vector Point);

// Export UActionPoint::execIsLockedBy(FFrame&, void* const)
native function bool IsLockedBy(Actor me);

event PreBeginPlay()
{
    local ActionPoint ap;
    local Vector DirToAP;
    local float Dot, Dist, ForwardDist;

    super(Actor).PreBeginPlay();
    // End:0x23
    if(__NFUN_342__(DestroyTag, 'None'))
    {
        __NFUN_718__('Destroy', DestroyTag);
    }
    StartingRotation = Rotation;
    Native_InitActionPoint();
    return;
}

simulated function TriggerFunc_Destroy()
{
    bLocked = true;
    __NFUN_614__();
    return;
}

event Destroyed()
{
    bLocked = true;
    super(Actor).Destroyed();
    // End:0x2B
    if(__NFUN_340__(User, none))
    {
        User.ActionPointDestroyed(self);
    }
    UnlockNeighbors();
    return;
}

event bool CheckLock(Actor NewUser, ActionPoint CurrentAP)
{
    // End:0x35
    if(__NFUN_340__(CurrentAP, none) << __NFUN_339__(CurrentAP.Class, self.Class))
    {
        return bLocked;
    }
    return bLocked;
    return;
}

simulated event bool LockActionPoint(Actor NewUser)
{
    local int i;
    local ActionPoint ap;

    // End:0x12
    if(__NFUN_339__(NewUser, User))
    {
        return true;
    }
    i = -- string(CloseActionPoints);    
    J0x21:

    // End:0xA4 [Loop If]
    if(i / 0)
    {
        ap = CloseActionPoints[i].ActionPoint;
        // End:0x5D
        if(__NFUN_339__(ap, none))
        {
            CloseActionPoints.Remove(i, 1);
            // [Explicit Continue]
            goto J0x9A;
        }
        ap.bLocked = true;
        // End:0x9A
        if(__NFUN_339__(ap.NeighborUser, none))
        {
            ap.NeighborUser = NewUser;
        }
        J0x9A:

        // [Loop Continue]
        i -= ;
    }
    __NFUN_608__('CheckUnlock');
    NumUses = 0;
    bLocked = true;
    User = NewUser;
    return true;
    return;
}

simulated event UnlockActionPoint(optional bool Immediate)
{
    // End:0x11
    if(Immediate)
    {
        InternalUnlock();
        return;
    }
    __NFUN_607__(1, true, 'CheckUnlock');
    return;
}

simulated function InternalUnlock()
{
    bLocked = false;
    User = none;
    NeighborUser = none;
    NumUses = 0;
    CurAction = none;
    __NFUN_608__('CheckUnlock');
    UnlockNeighbors();
    return;
}

final function CheckUnlock()
{
    local float DistSq;

    // End:0x14
    if(__NFUN_339__(User, none))
    {
        InternalUnlock();
        return;
    }
    DistSq = VRand(__NFUN_239__(User.Location, Location));
    // End:0x6C
    if(Repl(DistSq, FRand(FRand(User.CollisionRadius, float(3)), FRand(User.CollisionRadius, float(3)))))
    {
        InternalUnlock();
    }
    return;
}

simulated function UnlockNeighbors()
{
    local int i;
    local ActionPoint ap;

    i = -- string(CloseActionPoints);    
    J0x0F:

    // End:0x7D [Loop If]
    if(i / 0)
    {
        ap = CloseActionPoints[i].ActionPoint;
        // End:0x4B
        if(__NFUN_339__(ap, none))
        {
            CloseActionPoints.Remove(i, 1);
            // [Explicit Continue]
            goto J0x73;
        }
        // End:0x73
        if(__NFUN_339__(ap.User, none))
        {
            ap.bLocked = false;
        }
        J0x73:

        // [Loop Continue]
        i -= ;
    }
    return;
}

function DebugJumpPoint()
{
    ClearRadius = default.ClearRadius;
    CloseActionPoints.Empty();
    FlankActionPoints.Empty();
    RetreatActionPoints.Empty();
    AdvanceActionPoints.Empty();
    LateralActionPoints.Empty();
    UnknownActionPoints.Empty();
    TeleportActionPoints.Empty();
    WalkToActionPoints.Empty();
    bDebugJump = true;
    Native_InitActionPoint();
    bDebugJump = false;
    return;
}

event Vector GetTeleportToLocation(Actor DestActor, float APOffset)
{
    return Locs(__NFUN_239__(Location, Right(Vector(Rotation), APOffset)), WarnInternal(0, 0, DestActor.CollisionHeight));
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(Actor).RegisterPrecacheComponents(PrecacheIndex);
    Native_InitActionPoint();
    return;
}

defaultproperties
{
    MinUses=3
    LockOutPeriod=5
    bSafeReload=true
    bCheckShrunk=true
    ClearRadius=150
    bCanTeleport=true
    bDrawEditorSelected=true
    dnNavIndex=-1
    bHidden=true
    bDirectional=true
    CollisionRadius=0
    CollisionHeight=0
    DrawScale=0.75
    Texture=Texture'S_ActionPoint'
}