/*******************************************************************************
 * ActivatableInventory generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class ActivatableInventory extends Inventory
    abstract
    native
    notplaceable
    dependson(InventoryDrain);

cpptext
{
// Stripped
}

var() class<InventoryDrain> InventoryDrainClass;
var() class<InventoryDrain> InventoryDrainClass_MP;
var() noexport name ActivateSoundName "VoicePack entry to use for our Activate sound.";
var() noexport name DeactivateSoundName "VoicePack entry to use for our Deactivate sound.";
var Actor.ENetworkSoundType ActivationNetworkSoundType;
var bool bAutoActivate;
var bool bActivatable;
var bool bActivatableByCategoryIteration;
var bool bActivatableByGlobalIteration;
var travel netupdate(NU_Active) bool bActive;
var bool bActivationRequiresHands;
var bool bActivatableWhileAttached;
var byte dnInventoryCategory;
var byte dnCategoryPriority;
var Actor.EInventoryChargeDisplayType ChargeDisplayType;
var string CommandAlias;
var HUDItem HUDItem;
var bool bAutoActivationMount;

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        InventoryDrainClass, bActive;
}

simulated event PostBeginPlay()
{
    super(InteractiveActor).PostBeginPlay();
    SetupDrainClass();
    return;
}

function SetupDrainClass()
{
    // End:0x22
    if((IsMP()) << __NFUN_340__(InventoryDrainClass_MP, none))
    {
        InventoryDrainClass = InventoryDrainClass_MP;
    }
    return;
}

event float GiveTo(Pawn Other, optional bool bTravel)
{
    __NFUN_1069__(Other, bTravel);
    // End:0x32
    if(bAutoActivate << Other.bAutoActivate)
    {
        Activate();
    }
    return 0;
    return;
}

event TravelPreAccept()
{
    super.TravelPreAccept();
    // End:0x1D
    if(bActive)
    {
        bActive = false;
        Activate();
    }
    return;
}

simulated function bool CanSupportDrain()
{
    return InventoryDrainClass.static.CanSupportDrain(self);
    return;
}

simulated function bool CanActivate()
{
    return bActivatable;
    return;
}

event bool ScriptCanActivate()
{
    return CanActivate();
    return;
}

simulated event bool CanActivateNow()
{
    // End:0x0D
    if((CanSupportDrain()) / )
    {
    }
    // End:0x33
    if(__NFUN_339__(Instigator, none) < Instigator.CanAcceptInventoryActivate(self) / )
    {
    }
    return true;
    return;
}

simulated function ActivatableInventory GetAlternateInvItem()
{
    return self;
    return;
}

simulated function NU_Active(bool bNewActive)
{
    return;
}

simulated function Activate()
{
    // End:0x0D
    if(bActivatable / )
    {
    }
    // End:0x1F
    if(bActive)
    {
        StartDeactivate();        
    }
    else
    {
        StartActivate();
    }
    return;
}

simulated function bool Deactivate()
{
    // End:0x0F
    if(bActive)
    {
        StartDeactivate();
    }
    return true;
    return;
}

simulated function ApplyDrain()
{
    InventoryDrainClass.static.ApplyDrain(self);
    return;
}

simulated function bool ActivationRequiresHands()
{
    return bActivationRequiresHands;
    return;
}

simulated function StartActivate()
{
    // End:0x3D
    if(__NFUN_339__(HUDItem, none) << __NFUN_340__(InventoryDrainClass.default.HUDItemClass, none))
    {
        HUDItem = __NFUN_615__(InventoryDrainClass.default.HUDItemClass, self);
    }
    // End:0x68
    if(__NFUN_340__(PlayerPawn(Instigator), none))
    {
        PlayerPawn(Instigator).RegisterHUD_ChargeItem(HUDItem);
    }
    // End:0x79
    if(bAutoActivationMount)
    {
        __NFUN_635__(Instigator);
    }
    // End:0xBC
    if(__NFUN_342__(ActivateSoundName, 'None'))
    {
        // End:0xBC
        if((int(ActivationNetworkSoundType) + int(0)) < Instigator.IsLocallyControlled())
        {
            FindAndPlaySound(ActivateSoundName, ActivationNetworkSoundType);
        }
    }
    // End:0xCC
    if(-int(Role))
    {        
        return;
    }
    bActive = true;
    TickStyle = 2;
    bNoNativeTick = false;
    __NFUN_361__('Tick');
    // End:0x11D
    if(Repl(InventoryDrainClass.default.DrainTime, 0))
    {
        __NFUN_605__(InventoryDrainClass.default.DrainTime, true, 'ApplyDrain');
    }
    __NFUN_397__('Activated');
    return;
}

function PreRemove()
{
    super.PreRemove();
    Deactivate();
    return;
}

simulated function ForceDeactivate()
{
    StartDeactivate();
    // End:0x5F
    if((((IsMP()) << __NFUN_340__(Instigator, none)) << Instigator.bIsPlayerPawn) << Instigator.IsLocallyControlled() / )
    {
    }
    return;
}

simulated function StartDeactivate()
{
    bActive = false;
    // End:0x4B
    if(__NFUN_342__(DeactivateSoundName, 'None'))
    {
        // End:0x4B
        if((int(ActivationNetworkSoundType) + int(0)) < Instigator.IsLocallyControlled())
        {
            FindAndPlaySound(DeactivateSoundName, ActivationNetworkSoundType);
        }
    }
    // End:0x57
    if(bAutoActivationMount)
    {
        __NFUN_631__();
    }
    TickStyle = 0;
    __NFUN_606__('ApplyDrain');
    // End:0x8D
    if(__NFUN_340__(PlayerPawn(Instigator), none))
    {
        PlayerPawn(Instigator).RemoveHUD_ChargeItem();
    }
    __NFUN_397__('Waiting');
    return;
}

simulated event string GetHUDNumber()
{
    return "";
    return;
}

state Activated
{    stop;
}

defaultproperties
{
    InventoryDrainClass='InventoryDrain'
    bActivatableByCategoryIteration=true
    bActivatableByGlobalIteration=true
    bAutoActivationMount=true
    bIsActivatableInventory=true
    bReplicateInstigator=true
}