/*******************************************************************************
 * Actor generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Actor extends Object
    abstract
    native
    nativereplication
    collapsecategories
    dependson(LevelInfo)
    dependson(Pawn)
    dependson(PlayerPawn)
    dependson(SoftParticleSystem)
    dependson(Variable)
    dependson(MeshInstance)
    dependson(dnFriendFX_Spawners)
    dependson(MaterialEx)
    dependson(InterpolationPoint)
    dependson(RenderActor)
    dependson(Decal)
    dependson(BeamSystem)
    dependson(PhysicsVolume)
    dependson(DamageType)
    dependson(GameReplicationInfo)
    dependson(GameInfo)
    dependson(Decoration);

const kNextFrame = 0.00001f;
const SHAKEFLAGS_Pitch = 1;
const SHAKEFLAGS_Yaw = 2;
const SHAKEFLAGS_Roll = 4;
const SHAKEFLAGS_Restart = 8;
const SHAKEFLAGS_Infinite = 16;
const SHAKEFLAGS_Lerp = 32;
const SHAKEFLAGS_Func_Positive = 64;
const SHAKEFLAGS_Func_Negative = 128;
const SHAKEFLAGS_Func_Max = 256;
const SHAKEFLAGS_ToggleSign = 512;
const SHAKEFLAGS_ToggleNegative = 1024;
const DOF_PRIORITY_Death = 2.0;
const DOF_PRIORITY_Zoom = 4.0;
const DOF_PRIORITY_DukeVision = 6.0;
const DOF_PRIORITY_PhysicsVolume = 8.0;
const DOF_PRIORITY_Zone = 16.0;
const DOF_PRIORITY_Level = 32.0;
const kControlRemapperKeyTypeCount = 12;
const kNumInteractKeyInfoPositions = 9;
const kNumReverbPresets = 10;

enum ETraceFireHitResponse
{
    THITRESPONSE_Abort,
    THITRESPONSE_Immediate,
    THITRESPONSE_Backtrace
};

enum EDrawType
{
    DT_None,
    DT_Sprite,
    DT_Mesh,
    DT_Brush,
    DT_RopeSprite_Deprecated,
    DT_VerticalSprite_Deprecated,
    DT_Terraform_Deprecated,
    DT_SpriteAnimOnce_Deprecated,
    DT_StaticMesh,
    DT_ParticleSystem,
    DT_BeamSystem,
    DT_GeoWater,
    DT_BreakableGlass,
    DT_AntiPortal,
    DT_AIBrush_Deprecated,
    DT_ParticleSphere_Deprecated,
    DT_MultiPrimitive
};

enum ENetRole
{
    ROLE_None,
    ROLE_DumbProxy,
    ROLE_SimulatedProxy,
    ROLE_AutonomousProxy,
    ROLE_Authority
};

enum EMusicTransition
{
    MTRAN_None,
    MTRAN_Instant,
    MTRAN_Segue,
    MTRAN_Fade,
    MTRAN_FastFade,
    MTRAN_SlowFade
};

enum ETravelType
{
    TRAVEL_Absolute,
    TRAVEL_Partial,
    TRAVEL_Relative,
    TRAVEL_Chunk
};

enum EAnimToggleState
{
    ATS_None,
    ATS_DumbMesh,
    ATS_AnimLight
};

enum EAIPortalFlags
{
    AIPFL_Door
};

enum EAIAttitude
{
    AIATT_InfiniteHate,
    AIATT_Despise,
    AIATT_Hate,
    AIATT_Dislike,
    AIATT_Neutral,
    AIATT_Like,
    AIATT_Love,
    AIATT_Idolize,
    AIATT_InfiniteLove
};

enum EPlayerCameraStyle
{
    PCS_Normal,
    PCS_HeatVision,
    PCS_NightVision
};

enum EVehiclePOV
{
    VPOV_FirstPerson,
    VPOV_FreeCamera
};

enum EWeaponState
{
    WS_Unknown,
    WS_Activating,
    WS_Deactivating,
    WS_Idle,
    WS_Fire,
    WS_Fire_Start,
    WS_Fire_Stop,
    WS_Reload,
    WS_Reload_Start,
    WS_Reload_Stop,
    WS_Melee
};

enum EWeaponChangeSpeed
{
    WEAPCHANGE_Normal,
    WEAPCHANGE_NoAnim
};

enum EControlRemapperKeyType
{
    CRK_TurnLeft,
    CRK_TurnRight,
    CRK_StrafeLeft,
    CRK_StrafeRight,
    CRK_Forward,
    CRK_Backward,
    CRK_Jump,
    CRK_Duck,
    CRK_Fire,
    CRK_Melee,
    CRK_Zoom,
    CRK_Use
};

enum EControlRemapperEventType
{
    CRE_Start,
    CRE_Continuous,
    CRE_Stop
};

enum EPostureStateEx
{
    PSEX_Unknown,
    PSEX_Standing,
    PSEX_StandingActive,
    PSEX_Crouching,
    PSEX_InAir,
    PSEX_InAirActive,
    PSEX_Swimming,
    PSEX_Ladder,
    PSEX_Jetpack,
    PSEX_Turret,
    PSEX_Mounted
};

enum EFrozenState
{
    FREX_Unfrozen,
    FREX_Freezing,
    FREX_Frozen,
    FREX_Unfreezing
};

enum EBloatState
{
    BLOAT_Unbloated,
    BLOAT_Bloating,
    BLOAT_Bloated,
    BLOAT_Unbloating
};

enum ESpecialDay
{
    SDAY_NewYearsDay,
    SDAY_GroundhogsDay,
    SDAY_ValentinesDay,
    SDAY_StPatricksDay,
    SDAY_AprilFools,
    SDAY_DaylightSavingsStart,
    SDAY_TaxDay,
    SDAY_MothersDay,
    SDAY_MemorialDay,
    SDAY_FathersDay,
    SDAY_LaborDay,
    SDAY_DaylightSavingsEnd,
    SDAY_Halloween,
    SDAY_Elections,
    SDAY_VeteransDay,
    SDAY_Thanksgiving,
    SDAY_ChristmasEve,
    SDAY_ChristmasDay,
    SDAY_NewYearsEve,
    SDAY_UserBirthday,
    SDAY_Boring,
    SDAY_Beltane,
    SDAY_FallEquinox,
    SDAY_Samhain,
    SDAY_WinterSolstice,
    SDAY_RoshHashanah,
    SDAY_YomKippur,
    SDAY_Chanukkah,
    SDAY_Passover,
    SDAY_GantanSai,
    SDAY_Lent,
    SDAY_AshWednesday,
    SDAY_GoodFriday,
    SDAY_Kwanzaa,
    SDAY_Ashura
};

enum ESpecialSeason
{
    SSEASON_EasterSeason,
    SSEASON_ThanksgivingSeason,
    SSEASON_ChristmasSeason
};

enum EDayOfWeek
{
    DAY_Sunday,
    DAY_Monday,
    DAY_Tuesday,
    DAY_Wednesday,
    DAY_Thursday,
    DAY_Friday,
    DAY_Saturday
};

enum EMonth
{
    MONTH_January,
    MONTH_February,
    MONTH_March,
    MONTH_April,
    MONTH_May,
    MONTH_June,
    MONTH_July,
    MONTH_August,
    MONTH_September,
    MONTH_October,
    MONTH_November,
    MONTH_December
};

enum EZoneFlotsamEffect
{
    FLOTSAM_None,
    FLOTSAM_WaterBubbles,
    FLOTSAM_WaterDirt,
    FLOTSAM_WindyDusty,
    FLOTSAM_Speckles,
    FLOTSAM_None_PhysicsVolumeOverride
};

enum EScaleModifier
{
    SCALE_Smooth,
    SCALE_Linear,
    SCALE_Pulse,
    SCALE_Damped
};

enum EScaleModifierCalcStyle
{
    CALC_Sum,
    CALC_Product,
    CALC_Max,
    CALC_Min,
    CALC_Average,
    CALC_Priority
};

enum ENetworkSoundType
{
    NS_Local,
    NS_Standard,
    NS_RemoteReplicate,
    NS_Replicate
};

enum EVertexFunction
{
    VF_None,
    VF_SinusoidalNormal
};

enum EIRateType
{
    IRATE_TimeToNextPoint,
    IRATE_UnitsPerSecond,
    IRATE_Deprecated1
};

enum EBehavior
{
    DB_Normal,
    DB_Permanant,
    DB_DestroyAfterArgumentSeconds,
    DB_DestroyNotVisibleForArgumentSeconds
};

enum EHUDAnchor
{
    ANCHOR_TopLeft,
    ANCHOR_TopMid,
    ANCHOR_TopRight,
    ANCHOR_LeftMid,
    ANCHOR_Center,
    ANCHOR_RightMid,
    ANCHOR_BottomLeft,
    ANCHOR_BottomMid,
    ANCHOR_BottomRight
};

enum EInteractKeyPosition
{
    IKP_Top,
    IKP_Bottom,
    IKP_Left,
    IKP_Right,
    IKP_LeftTop,
    IKP_LeftBottom,
    IKP_RightTop,
    IKP_RightBottom,
    IKP_BoostMeter
};

enum EReverbEnvironment
{
    ENVIRONMENT_None,
    ENVIRONMENT_GenericRoom_Small,
    ENVIRONMENT_GenericRoom_Medium,
    ENVIRONMENT_GenericRoom_Large,
    ENVIRONMENT_GenericRoom_XLarge,
    ENVIRONMENT_GenericRoom_XXLarge,
    ENVIRONMENT_Closet,
    ENVIRONMENT_Outdoors,
    ENVIRONMENT_Vent,
    ENVIRONMENT_Underwater
};

enum EPickupSource
{
    PICKUP_Unknown,
    PICKUP_Touch,
    PICKUP_Use,
    PICKUP_Purchase,
    PICKUP_Gameplay,
    PICKUP_TickTouch
};

enum EInventoryMultiplePickupBehavior
{
    PICKMULT_None,
    PICKMULT_Disallow,
    PICKMULT_CompositeChargeClamped,
    PICKMULT_Custom
};

enum EWeaponAnimNameType
{
    WANIMTYPE_LookPoses,
    WANIMTYPE_UpperBodyAnim
};

enum EInventoryChargeDisplayType
{
    INVCHARGEDISP_None,
    INVCHARGEDISP_Percent,
    INVCHARGEDISP_Quantity,
    INVCHARGEDISP_WeaponAmmo
};

struct SRelationship
{
    var() noexport class<Actor> m_aClass "The class we're setting up a relationship for.";
    var() noexport Actor.EAIAttitude m_eAttitude "Initial attitude towards this class.";
    var() noexport float m_fDamageThreshold "How much damage an actor of this class has to do to us to move us to the next lower attitude level.  This is in % of our max health, not actual health points.";
};

struct SSceneInfo
{
    var() Vector Shadows;
    var() Vector MidTones;
    var() Vector Highlights;
    var() float Desaturation;
    var() float BloomScale;
    var() float HDRMiddleGray;
    var() float HDRMinScale;
    var() float HDRMaxScale;
    var() float HDRClip;
    var() float AmbientOcclusionSpeed;
    var() float AmbientOcclusionStrength;
    var() float AmbientOcclusionRadius;
    var() float StarBloomScale;
    var() float StarAngle;
    var() float StarLength1;
    var() float StarLength2;
    var() noexport float StarBlur "Blurs when >= 1.0.  No blur when < 1.0";
    var() noexport int StarSamples "Valid input 1-4 samples";
    var() noexport float StarBloomMinIntensity "Minimum bloom intensity required to do star blooms";
    var() noexport float StarBloomFullIntensity "Bloom intensity where star blooms will be at full intensity";
    var() float PixelMotionBlurScale;
    var() float PixelMotionBlurFar;
    var() float PixelMotionBlurMaxVelocityNear;
    var() float PixelMotionBlurMaxVelocityFar;
};

struct SSceneInfoAssign
{
    var() noexport Object.EVectModifier ShadowsModifier "How to modify Shadows.";
    var() noexport Object.EVectModifier MidTonesModifier "How to modify MidTones.";
    var() noexport Object.EVectModifier HighlightsModifier "How to modify Highlights.";
    var() noexport Object.EFloatModifier DesaturationModifier "How to modify Desaturation.";
    var() noexport Object.EFloatModifier BloomScaleModifier "How to modify BloomScale.";
    var() noexport Object.EFloatModifier HDRMiddleGrayModifier "How to modify HDRMiddleGray.";
    var() noexport Object.EFloatModifier HDRMinScaleModifier "How to modify HDRMinScale.";
    var() noexport Object.EFloatModifier HDRMaxScaleModifier "How to modify HDRMaxScale.";
    var() noexport Object.EFloatModifier HDRClipModifier "How to modify HDRClip.";
    var() noexport Object.EFloatModifier AmbientOcclusionSpeedModifier "How to modify AmbientOcclusionSpeed.";
    var() noexport Object.EFloatModifier AmbientOcclusionStrengthModifier "How to modify AmbientOcclusionStrength.";
    var() noexport Object.EFloatModifier AmbientOcclusionRadiusModifier "How to modify AmbientOcclusionRadius.";
    var() noexport Object.EFloatModifier StarBloomScaleModifier "How to modify StarBloomScale.";
    var() noexport Object.EFloatModifier StarAngleModifier "How to modify StarAngle.";
    var() noexport Object.EFloatModifier StarLength1Modifier "How to modify StarLength1.";
    var() noexport Object.EFloatModifier StarLength2Modifier "How to modify StarLength2.";
    var() noexport Object.EFloatModifier StarBlurModifier "How to modify StarBlur.";
    var() noexport Object.EIntModifier StarSamplesModifier "How to modify StarSamples.";
    var() noexport Object.EFloatModifier StarBloomMinIntensityModifier "How to modify StarBloomMinIntensity.";
    var() noexport Object.EFloatModifier StarBloomFullIntensityModifier "How to modify StarBloomFullIntensity.";
    var() noexport Object.EFloatModifier PixelMotionBlurScaleModifier "How to modify PixelMotionBlurScale.";
    var() noexport Object.EFloatModifier PixelMotionBlurFarModifier "How to modify PixelMotionBlurFar.";
    var() noexport Object.EFloatModifier PixelMotionBlurMaxVelocityNearModifier "How to modify PixelMotionBlurMaxVelocityNear.";
    var() noexport Object.EFloatModifier PixelMotionBlurMaxVelocityFarModifier "How to modify PixelMotionBlurMaxVelocityFar.";
    var() noexport Vector Shadows "Shadows modification value.";
    var() noexport Vector MidTones "MidTones modification value.";
    var() noexport Vector Highlights "Highlights modification value.";
    var() noexport float Desaturation "Desaturation modification value.";
    var() noexport float BloomScale "BloomScale modification value.";
    var() noexport float HDRMiddleGray "HDRMiddleGray modification value.";
    var() noexport float HDRMinScale "HDRMinScale modification value.";
    var() noexport float HDRMaxScale "HDRMaxScale modification value.";
    var() noexport float HDRClip "HDRClip modification value.";
    var() noexport float AmbientOcclusionSpeed "AmbientOcclusionSpeed modification value.";
    var() noexport float AmbientOcclusionStrength "AmbientOcclusionStrength modification value.";
    var() noexport float AmbientOcclusionRadius "AmbientOcclusionRadius modification value.";
    var() noexport float StarBloomScale "StarBloomScale modification value.";
    var() noexport float StarAngle "StarAngle modification value.";
    var() noexport float StarLength1 "StarLength1 modification value.";
    var() noexport float StarLength2 "StarLength2 modification value.";
    var() noexport float StarBlur "StarBlur modification value.";
    var() noexport int StarSamples "StarSamples modification value.";
    var() noexport float StarBloomMinIntensity "StarBloomMinIntensity modification value.";
    var() noexport float StarBloomFullIntensity "StarBloomFullIntensity modification value.";
    var() noexport float PixelMotionBlurScale "PixelMotionBlurScale modification value.";
    var() noexport float PixelMotionBlurFar "PixelMotionBlurFar modification value.";
    var() noexport float PixelMotionBlurMaxVelocityNear "PixelMotionBlurMaxVelocityNear modification value.";
    var() noexport float PixelMotionBlurMaxVelocityFar "PixelMotionBlurMaxVelocityFar modification value.";
};

struct SBasedParticles
{
    var int BasedCount;
    var SoftParticleSystem BasedSystem;
};

struct SCallbackTimer
{
    var float Rate;
    var float Counter;
    var int Loops;
    var const name CallbackName;
    var const transient Function Pointer;
    var bool bIndependent;
    var const bool bDeleted;
    var const bool bEnforceLoop;
};

struct PointRegion
{
    var ZoneInfo Zone;
    var int iLeaf;
    var int iZone;
};

struct SRange
{
    var() float Min;
    var() float Max;
};

struct STimeRamp
{
    var() noexport float Time "Time to go from starting scale to ending scale.";
    var() float Min;
    var() float Max;
};

struct STimePath
{
    var() array<STimeRamp> Points;
};

struct SMountedActor
{
    var Actor MountedActor;
    var bool bHideable;
    var bool bTransferToCorpse;
};

struct SForwardTags
{
    var() noexport name Tag "The tag to use when forwarding extra triggers to ourself.";
};

struct SSpecialEvent
{
    var name aMapperName;
    var name TriggerTag;
};

struct SScaleModifier
{
    var() noexport Actor.EScaleModifier Style "How to ramp the modifier, either in a straight line or slowly ramp up and down smoothly.";
    var() noexport name Identifier "Unique ID for the modifier that allows you to link different effects together. Also required if you want to hand remove the modifier.";
    var() noexport float ScaleStart "Where we want the scaler to start out. If left as 0, and replacing an existing modifier with the same ID, will start where the existing modifier currently is.";
    var() noexport float ScaleTarget "Where we want the scaler to wind up when it is finished transitioning.";
    var() noexport float TimeRamp "Amount of time the modifier takes to transition from start to target.";
    var() noexport name FunctionComplete "Function to call on the actor when this modifier finishes a TimeRamp.";
    var() noexport Actor FunctionCompleteActor "If None, [FunctionComplete] will be called on the actor with the scale modifier. Otherwise, the function will be called on this actor.";
    var() noexport deprecated name EventComplete "Event to trigger when this modifier finishes a TimeRamp.";
    var float Scale;
    var float Timer;
    var float LastUpdateGTS;
    var float Velocity;
    var float Priority;
    var bool bActive;
};

struct SScaleModifierGroup
{
    var array<SScaleModifier> Modifiers;
    var name Identifier;
    var float DefaultModValue;
    var float LastValue;
    var bool NoUpdate;
};

struct SActorColorFadeInfo
{
    var() name ActorColorName;
    var() Color EndColor;
    var() Color StartColor;
    var() float TotalTime;
    var() float StartTime;
};

struct SGeneratorEvent
{
    var() noexport name Event "Event to call when the Percentage is reached.";
    var() noexport float Percent "Percentage of the property to reach before firing the event.";
};

struct SGeneratorEvents
{
    var() name DestroyedEvent;
    var() name ResumeEvent;
    var() array<SGeneratorEvent> ChargeEvents;
    var() array<SGeneratorEvent> DamageEvents;
};

struct SAIPathInfo
{
    var() bool bNeedsFlying;
    var() bool bPrecomputeAP;
    var() name PathID;
    var() float Radius;
    var() float Height;
    var() class<Actor> SourceClass;
};

struct SReverbPreset
{
    var() float DryLevel;
    var() float WetLevel;
    var() float Time;
    var() float PreDelay;
    var() float Damping;
};

struct SAllAnimInfo
{
    var name Sequence;
    var int Channel;
    var int RefId;
    var float Blend;
    var float Time;
    var Object.EAnimationBlendMode Op;
    var bool bIsGroup;
    var bool bEventEnabled;
};

struct SVPSoundThrottle
{
    var name GroupName;
    var name AffiliationName;
    var float AvailableTime;
};

var const transient int CollisionTag;
var const editconst transient nontrans pointer CachePrimitive;
var int TraceFalseMask;
var int TraceTrueMaskEarly;
var int TraceTrueMask;
var(movement) Vector Velocity;
var(movement) const noexport Object.EPhysics Physics "Actor's current physics mode";
var bool bAlwaysRejectTraceEarly;
var(Collision) noexport bool bTraceUsable "Traces from script can hit this actor.";
var(Collision) noexport bool bTraceShootable "If true, actor can be hit by tracefire shots, and projectiles.";
var(Collision) noexport bool bNeverMeshAccurate "Don't use per triangle traces, just use the collision cylinder.  Only valid for DT_Mesh/DT_StaticMesh.";
var(Collision) noexport bool bCollisionAssumeValid "If this is set, the actor will not go through the normal verification that a move was valid and also will not get touch/untouch/bump/etc. messages.";
var(Collision) noexport bool bUseCylinderCollision "If this is True, when actors do collision detection with this actor while trying to perform a move, they will collide with the collision cylinder instead of the mesh polies.  Applied to both Meshes and StaticMeshes.";
var(Collision) noexport bool bAITransparent "Is this actor transparent to AI?";
var bool bSpecialLook;
var bool bRequestMeshAccurateMoveActorTrace;
var bool bAcceptMeshAccurateMoveActorTrace;
var noexport bool bTraceAgainstMounts "If true, line checks performed by the Actor will allow mounted Actors to be traced against.";
var(Advanced) const noexport bool bStatic "Does not move or change over time.";
var(Collision) const noexport bool bBlockActors "Actor blocks non-player actors.";
var(Collision) const noexport bool bBlockPlayers "Actor blocks player actors.";
var(Collision) const noexport netupdate(NU_bBlockKarma) bool bBlockKarma "This actor should attempt to have some sort of Karma collision.";
var noexport bool bBlockAI "If TRUE, AI Actors will attempt to avoid this obstacle.";
var(Collision) noexport bool bBlockPath "If TRUE, AI Actors will attempt to avoid this obstacle.";
var(Collision) noexport bool bStaticAI "If TRUE, this actor will be considered bStatic for AI, so it will force the actor to be baked into the navigation bsp if bBlockAI is TRUE.";
var(Collision) noexport bool bBlockParticles "Blocks particles from passing through ourself.";
var(Collision) noexport bool bBlockBeams "If true, this actor will block BeamSystems that do line checks.";
var(Collision) noexport bool bBlockCamera "Actor blocks third-person camera view traces.";
var(Collision) const noexport bool bWorldGeometry "Collision and physics treats this actor as world geometry.";
var(Sound) noexport bool bOccludeSounds "Occlude sounds played by other actors (If this is false, it will never occlude... however if true, other things can prevent it from still not blocking).";
var(Advanced) const noexport travel netupdate(SetHidden) bool bHidden "Is hidden during gameplay.";
var noexport bool bIgnoreMaxRadius "If true, CheckViewingEnemy in PlayerPawn ignores the MaxRadius check";
var bool bCanBeThrown;
var const bool bIsLevelInfo;
var const bool bIsZoneInfo;
var const bool bIsPawn;
var const bool bIsInfo;
var const bool bIsBrush;
var const bool bIsRenderActor;
var const bool bIsInteractiveActor;
var const bool bIsPlayerPawn;
var const bool bIsMover;
var const bool bIsDecoration;
var const bool bIsdnDecoration;
var const bool bIsdnUsableSomething;
var const bool bIsInventory;
var const bool bIsActivatableInventory;
var const bool bIsBreakableGlass;
var const bool bIsKarmaActor;
var const bool bIsKarmaConstraint;
var const bool bIsSoftParticleSystem;
var const bool bIsInterpolationPoint;
var const bool bIsVolume;
var const bool bIsPhysicsVolume;
var const bool bIsVehicle;
var const bool bIsVehicleSensor;
var const bool bIsVehicleDeco;
var const bool bIsCorpse;
var const bool bIsAmmoCasing;
var const bool bIsProjectile;
var const bool bIsPipeBombOrTripMine;
var const bool bIsDestructibleArmor;
var const bool bIsLightEx;
var const bool bIsProjector;
var const bool bIsProjectilePool;
var const bool bIsDestroyedActorPool;
var const bool bIsPickup;
var const bool bIsAIActor;
var const bool bIsCTBBabe;
var const bool bIsHTTKMarker;
var const bool bIsAssaultTrooper;
var bool bGameRelevant;
var bool bHurtEntry;
var transient bool bSpawnInitialized;
var transient bool bMountUpdate;
var bool bHasEvalBonesHelper;
var bool bTeleporting;
var const bool bDeleteMe;
var const bool bDeleting;
var const bool bDestroyed;
var bool bSilentDestroy;
var(Advanced) const noexport bool bNoDelete "Cannot be deleted during play.";
var(Advanced) noexport bool bDebugEvents "Show all events this actor is generating.";
var(Advanced) noexport bool bUnlisted "Don't hit this actor when searching through iterators.";
var(Advanced) noexport bool bCanExistOutOfWorld "When true, this actor will not be destroyed in FellOutOfWorld.";
var(Advanced) noexport bool bNotForClient "When true, this actor will be not exist in the game, but will stil be present in the map.";
var const bool bNoDamageGlass;
var(Advanced) noexport bool bNoAutoCleanup "When true, this actor will be exclude from the auto-cleanup system.  This flag is effectively an override for Corpses and Corpse_Gibs.";
var bool bGibActor;
var(Advanced) const noexport bool bDestroyOnLevelTransition "When true, if we transition into this map from another, destroy this actor.";
var(Advanced) noexport bool bGoryActor "If true, this Actor is considered gory and will not exist in a gore-free build.";
var(Tick) noexport bool bNoNativeTick "If true, the bare minimum ticking will be performed (Example: State updates, Karma, Lifetime, Timers).";
var(Tick) noexport bool bDumbMesh "No animation or mesh processing is done.";
var(TickRules) noexport bool bTickOnlyRecent "Tick this object only if it has been rendered in SelfRecentTime.";
var(TickRules) noexport bool bTickOnlyZoneRecent "Tick this object only if the zone it's in has been rendered in ZoneRecentTime.";
var(TickRules) noexport bool bTickOnlyNearby "Tick this object only when within NearbyRadius units.";
var(TickRules) noexport bool bTickOnlyWhenOwnerShould "This this object only when it's Owner should tick.";
var const bool bTickedLastFrame;
var const bool bTickOnlyExternalPhysics;
var const bool bLateTicker;
var(Lighting) noexport bool bUseLightTag "If this is a normal actor: Only receive light from LightEx with a matching LightTag. If it is a LightEX, then only affect actors with a matching LightTag.";
var(Lighting) noexport bool bUseShadowTag "If this is a normal actor: Only cast shadow for a light with matching ShadowTag.  If it is a LightEx, then only actors with matching ShadowTag casts shadows.";
var(Lighting) noexport bool bNoAmbientLight "If true, this actor will not accept ambient light.";
var(Lighting) noexport bool bForceTwoSidedShadows "If true, this actor will cast twop sided shadows, regardless of the material.";
var(Lighting) noexport bool bForceDirectionalShadows "If true, this actor will ALWAYS be rendered into the directional shadow map, even if it would not contribute. Use ONLY if the object is not casting shadow correctly at certain angles or distances.";
var(movement) noexport bool bCanTeleport "This actor can be teleported.";
var(movement) noexport bool bMovable "Actor is capable of being moved.";
var(movement) noexport bool bBounce "Bounces when hits ground fast.";
var(movement) noexport bool bDisturbWaterSurface "Cause any GeoWater closeby to create a wake behind us as we move.";
var(movement) const noexport bool bFixedRotationDir "Has no impact in game anymore. Only exposed so you can turn it on and see something rotate in the editor. Needs: bStatic=false bNoNativeTick=false Physics=(anything but PHYS_None) and RotationRate!=(0,0,0) to work.";
var const bool bRotationRateChanging;
var const bool bDesiredLocating;
var const bool bDesiredRotatingPitch;
var const bool bDesiredRotatingYaw;
var const bool bDesiredRotatingRoll;
var bool bInterpolating;
var const bool bJustTeleported;
var const bool bForceEncroacher;
var bool bStopAmbientOnEndRotation;
var bool bStopAmbientOnEndLocation;
var bool bNotifyTargetOnRotationEnd;
var(Mounting) noexport bool IndependentRotation "Rotates independently from mount.";
var(Mounting) noexport bool IndependentLocation "Moves independently from mount.";
var(Mounting) noexport bool DestroyOnDismount "This actor gets destroyed when dismounted.";
var(Mounting) noexport bool bGenerateMountOffsets "If this is true, then when mounting at startup, generate the MountOrigin/MountAngles based on the current locations of this actor and the MountParent.";
var(Mounting) noexport bool bTakeMountParentAsOwner "If this is true, then when mounting at startup, take MountParent as our Owner.";
var(Mounting) noexport bool bNoFailMountedMovement "If this is true, MoveActor will set bNoFail to true when called from HandleMountCoords.";
var bool bUpdateMountParentRenderTime;
var bool bAcceptMinesInMultiplayer;
var bool bAcceptMinesAtAnyAngle;
var(Mounting) noexport bool bAcceptMines "If this is false, then tripmines can't attach to it.";
var bool bHasPostMountUpdate;
var(Interpolation) noexport bool bNoInterpolationRotPitch "Actor never interpolates the pitch axis.";
var(Interpolation) noexport bool bNoInterpolationRotYaw "Actor never interpolates the yaw axis.";
var(Interpolation) noexport bool bNoInterpolationRotRoll "Actor never interpolates the roll axis.";
var(Interpolation) noexport bool bNoInterpolationLocX "Actor never interpolates the pitch axis.";
var(Interpolation) noexport bool bNoInterpolationLocY "Actor never interpolates the yaw axis.";
var(Interpolation) noexport bool bNoInterpolationLocZ "Actor never interpolates the roll axis.";
var(Interpolation) noexport bool bNoFailInterpolation "When moving with interpolation, always succeed.";
var(Display) noexport bool bAlwaysVisible "Do not perform render bound culling or other checks - CURRENTLY BROKEN (do not use)";
var bool bPortalView;
var(Display) noexport bool bAcceptsProjectors "Accepts projectors.";
var(Display) noexport bool bAcceptsDecalProjectors "Accepts decal projectors (gunshots, etc).";
var(Display) noexport bool bCastStencilShadows "Casts stencil shadows";
var(Display) noexport bool bForceSmoothShadowUpdates "Forces directional shadows that this actors touches to be updated every frame.  Fixes flickering.";
var(Display) noexport bool bUnlit "Lights don't affect actor.";
var(Display) bool bIgnoreBList;
var(Display) noexport bool bDontReflect "Not reflected in mirrors.";
var(Display) noexport bool bLowerByCollision "If true, lower the mesh by the collision height during pre or post pivot (based on bLowerAsPrePivot flag).";
var(Display) noexport bool bLowerAsPrePivot "If true, apply bLowerByCollision during pre-pivot instead of post pivot.";
var(Display) noexport bool bDisableRenderBatching "Don't allow this actor to merge with other actors (currently only for staticmeshes).";
var(Display) noexport bool bDontHardwareOcclude "If true, Actor will not be affected by hardware occlusion.";
var(Display) noexport bool bNoTransparentFog "If this actor has transparency on it, those parts won't reveive fog.";
var bool bAnimLight;
var bool bAnimEarlyEnd;
var(Display) noexport bool bOneSidedMirror "MirrorRenderTarget is only active if camera is on positive side of MirrorNormal.";
var(Display) noexport bool bSortByCenter "Sort by center of render bounds when drawing transparent materials on this actor.";
var(Display) noexport bool bSortByLocation "Sort by the Location when drawing transparent materials on this actor.  Ignored if bSortByCenter is true.";
var(Display) noexport bool bDoOverlayEffect "If true, will use the overlay effect on OverlayMaterial.";
var(Display) noexport bool bOverlayEffectUsedAsHint "If true, this Actor uses bDoOverlayEffect for game hints and should be disabled if game hints are disabled.";
var(Display) noexport bool bOverlayBumpShader "Used as a bump shader overlay";
var(Display) noexport bool bNeedsScriptActorColor "If true, ScriptGetActorColor will be called each frame for this actor.";
var(Display) noexport bool bPerformDamageEffect "Damage Effects will show up on the actor.  Like blood spray and blood decals on pawns.";
var(Sound) noexport bool AmbientMusicEnableVis "When true, visualization calculations will be enabled for the AmbientMusic";
var(Sound) noexport bool AmbientMusicIgnoreTimeDilation "Should the music not slow down if the game speed changes";
var(Sound) noexport bool SoundScaled "If true, scale ambient sounds being played.";
var(Sound) noexport bool SoundNoOcclude "If true, don't occlude the ambient played through this actor.  This applies to ambient sound and music.";
var(Sound) noexport bool SoundNoDoppler "If true, don't doppler the ambient sound.";
var(Sound) noexport bool SoundIgnoreTimeDilation "If true, don't time dilate the ambient sound.";
var(Sound) noexport bool TransientSoundNoOcclude "If true, don't occlude any sounds played.";
var(Sound) noexport bool TransientSoundScaled "If true, scale sounds being played.";
var(Sound) noexport bool TransientSoundNoDoppler "If true, don't doppler any sounds played.";
var bool bDrawableViewMapper;
var const noexport bool bNetTemporary "Tear-off simulation in network play.";
var const noexport bool bNetOptional "Actor should only be replicated if bandwidth available.";
var noexport bool bAlwaysRelevant "Always relevant for network.";
var bool bReplicateWhenOwnerSeen;
var bool bReplicateTicking;
var bool bNoRoleSwap;
var(Network) bool bDebugReplication;
var const bool bNetInitialRotation;
var noexport bool bTravel "Actor is capable of travelling among servers.";
var noexport travel bool bWillTravel "The actor will travel to the next map in single player.  THIS SHOULD PROBABLY BE DEPRECATED.";
var noexport bool bNeverTravel "Teleporters will never try to travel this actor.";
var const bool bNetInitial;
var const bool bNetOwner;
var const bool bSimulatedPawn;
var const bool bDemoRecording;
var const bool bClientDemoRecording;
var const bool bClientDemoNetFunc;
var bool bForceCollisionRep;
var bool bForceTagEventRep;
var bool bDontSimulateMotion;
var bool bDontReplicateMesh;
var bool bReplicateInstigator;
var(Editor) const noexport bool bHiddenEd "Is hidden during editing.";
var(Editor) const noexport bool bDirectional "Actor shows direction arrow during editing.";
var(Editor) const noexport bool bEdShouldSnap "Snap to grid in editor.";
var(Editor) const noexport bool bNoDrawEditorLines "If true, connecting lines like interpolation paths won't be drawn.";
var const transient bool bSelected;
var const transient bool bEdSnap;
var const transient bool bTempEditor;
var const transient bool bHiddenTool;
var(Collision) noexport bool bStepUpAble "Whether a player colliding with this is able to step up on it (EX: Chairs with low seats shouldn't be able to be stepped up on).";
var(Collision) noexport bool bCollideWhenPlacing "This actor collides with the world when placing.";
var(Collision) const noexport bool bCollideActors "Actor collides with other actors.";
var(Collision) const noexport bool bCollideWorld "Actor collides with the world.";
var(Collision) noexport bool bAIMoveable "If TRUE, this actor can be moved by AI actors.";
var(Collision) noexport bool bAutoNavDoor "A NavVolume_Door will be constructed around this actor during NAV compilation";
var bool bCollideActorsStored;
var bool bCollideWorldStored;
var bool bBlockActorsStored;
var bool bBlockPlayersStored;
var bool bBlockKarmaStored;
var const transient bool bWasSNFiltered;
var(Collision) noexport bool bMoveWithSpecialCollisionTag "If this actor is a mover, it will only check for collisions with actors with a matching SpecialCollisionTag.";
var(Filter) noexport bool bSinglePlayer "Appear in single player.";
var(Filter) noexport bool bNet "Appear on servers.";
var(Filter) noexport bool bNetSpecial "Appear on clients.";
var bool bDontUseMeqonPhysics;
var const bool bUsePlayerCollisions;
var bool bIgnoreInstigatorCollision;
var(Advanced) noexport class<GameInfo> GametypeSpecific "Providing a gametype class will result in the object only being used with that gametype.  Preventing it from being loaded saving memory, time etc";
var const travel Actor Owner;
var const PointRegion Region;
var const LevelInfo Level;
var const int NumOwned;
var Actor Target;
var Pawn Instigator;
var const editconst transient nontrans pointer SPActorInfo;
var(Object) noexport editinline state name InitialState "Initial state of the object, uses default if none.";
var(Object) noexport name Group "Editor group this actor is a member of.";
var(Events) const noexport name Tag "Actor's tag name.";
var(Events) noexport deprecated name Event "The event this actor causes.";
var(Events) noexport array<SForwardTags> ForwardTags "Extra tags that can be used to forward Trigger events onto ourself." "Basically turns every actor into a possible Inpatcher." "NOTE: All this does is absorb triggers. When other actors look for something by tag," "they still only find the value in 'Tag'.";
var const array<SSpecialEvent> SpecialEvents;
var const transient array<Actor> ActorLinks;
var const int LatentInt;
var const float LatentFloat;
var const Actor Deleted;
var(Editor) const editconst noexport float PlacementZOffset "Amount that this actor gets it's Z position offset by when placed in the editor.";
var(Collision) noexport name SpecialCollisionTag "See [bMoveWithSpecialCollisionTag].";
var(Collision) const noexport float CollisionRadius "Radius of the collision cylinder.";
var(Collision) const noexport float CollisionHeight "Half the height of the collision cylinder.";
var(Collision) const noexport array< class<Actor> > TouchClasses "Classes of Actor that are valid for Touch with this Actor.  If array is empty, all Actors are valid.";
var Vector VisibleCollidingCenterOffset;
var const array<Actor> Touching;
var const int BasedActorCount;
var const array<SBasedParticles> BasedParticlesList;
var const editconst transient nontrans array<transient pointer> OctreeNodes;
var const transient Box OctreeBox;
var const transient Vector OctreeBoxCenter;
var const transient Vector OctreeBoxRadii;
var NavVolume_Door NavVolume;
var(TickRules) noexport float TickSelfRecentTime "How much time must pass before we no longer consider ourself recently rendered.";
var(TickRules) noexport float TickZoneRecentTime "How much time must pass before a zone is no longer considered recently rendered.";
var(TickRules) noexport float TickNearbyRadius "Distance from the player that this actor is considered 'nearby' for bTickOnlyNearby.";
var const int TickStamp;
var(movement) const noexport Rotator RotationRate "Change in rotation per second.";
var const Rotator RotationRateTarget;
var const float RotationRateTargetTimer;
var(movement) float DisturbWaterStrength;
var(movement) float DisturbWaterRadius;
var float AccelRate;
var(movement) const noexport float ForcePawnBaseHeight "The distance a pawn should trace down to find their base once they become based on *this*. (Setting it to 0.0 means 'restore default value'.)";
var(Interpolation) noexport deprecated name StartingInterpolationPoint "Upon startup, this actor will immediately attach itself to this interpolation point and follow the path.";
var float PhysAlpha;
var float PhysRate;
var int OldRoll;
var(Interpolation) noexport float RollLerpAlpha "Alpha for forceautoroll lerp calculation.  Value from 0.0 to 1.0.  Set this for the actor that will be traveling on the interpolation path.  SPECIAL CASE: Whatever is set on TriggerSpawnFlybyPlane_Fighter will be set on the planes it spawns.";
var const int DesiredLocationCurrent;
var array<SDesiredLocation> DesiredLocation;
var const int DesiredRotationPitchCurrent;
var const int DesiredRotationYawCurrent;
var const int DesiredRotationRollCurrent;
var array<SDesiredRotationAxis> DesiredRotationPitch;
var array<SDesiredRotationAxis> DesiredRotationYaw;
var array<SDesiredRotationAxis> DesiredRotationRoll;
var(movement) noexport float Mass "Approximate weight of the object in pounds.";
var(movement) const noexport netupdate(NU_Location) Vector Location "Actor's location -- use Move to set.";
var(movement) const noexport Rotator Rotation "Rotation.";
var(movement) noexport deprecated Volume VolumeProxy "This actor will proxy for a volume.";
var PhysicsVolume PhysicsVolume;
var Vector Acceleration;
var const Vector OldLocation;
var const Rotator OldRotation;
var const Vector ColLocation;
var const float NetworkTweenCompletion;
var const Vector NetworkLocationDelta;
var const float NetworkTweenRate;
var(Tick) noexport Object.ETickStyle TickStyle "Control over how this actor will determine whether it should tick or not. MAPPERS: Do not *ever* use TICK_Always. This will cause the item to tick when the game is paused, etc.";
var(Mounting) noexport Object.EMountType MountType "Method to use for mounting to our parent.";
var(Mounting) noexport Object.EPhysics DismountPhysics "Physics to set when this object detaches.";
var(Mounting) noexport deprecated name MountParentTag "Tag of the object to assign my MountParent to upon startup.";
var(Mounting) noexport edfindable nocompress Vector MountOrigin "Origin offset for attachment.";
var(Mounting) noexport edfindable nocompress Rotator MountAngles "Rotation angles for attachment.";
var(Mounting) noexport name MountMeshItem "Bone/Surface mount name to attach ourself to on our parent (Only valid on Meshes)";
var(Mounting) const noexport deprecated netupdate(NU_MountParent) Actor MountParent "If Non-None then mount to this actor. Checked before MountParentTag." "MountOffsets are not autogenerated." "Only use if you know what you are doing and why you are doing it." "Do NOT click the new button. This is for debugging purposes ONLY.";
var(Mounting) editconst noexport array<SMountedActor> MountedActorList "Entire list of the actors mounted to this actor unless told to reject being added. This is generated at gametime and only exposed so it can be looked at easily during runtime for debugging.";
var(Display) noexport Object.ERenderStyle Style "Rendering style of the actor.";
var(Display) noexport Actor.EDrawType DrawType "Display type of the actor.";
var(Display) noexport Actor.EAnimToggleState AnimToggleState "Toggles DumbMesh or AnimLight on if the actor cannot be seen.";
var(Display) const noexport int AlphaSortGroup "Manual sorting adjustment for transparent Actors.";
var(Display) const noexport Vector PrePivot "Offset from box center for drawing.";
var(Display) const noexport Vector PostPivot "Offset from box center for drawing.";
var(Display) const noexport netupdate(NU_DrawScale) float DrawScale "Draw scaling factor, 1.0=normal size.";
var(Display) const noexport edfindable nocompress netupdate(NU_DrawScale3D) Vector DrawScale3D "3D draw scaling factor.";
var(Display) noexport MaterialEx Sprite "Sprite texture if DrawType=DT_Sprite.";
var(Display) noexport MaterialEx OverlayMaterial "Material to draw an overlay effect with.";
var float OverlayEffectAlpha;
var float OverlayEffectAlphaTarget;
var float OverlayEffectTransitionStartTime;
var float OverlayEffectTransitionTotalTime;
var(Display) float OverlayScaleU;
var(Display) float OverlayScaleV;
var(Display) noexport MaterialEx Texture "Misc texture.";
var const export Model Brush;
var(Display) const noexport netupdate(NU_StaticMesh) StaticMesh StaticMesh "StaticMesh if DrawType=DT_StaticMesh.";
var transient StaticMesh RenderStaticMesh;
var(Display) const noexport netupdate(NU_Mesh) Mesh Mesh "Mesh if DrawType=DT_Mesh.";
var transient Mesh RenderMesh;
var const transient float LastRenderTime;
var(Display) const noexport netupdate(NU_Skins) array<MaterialEx> Skins "Array of materials. Each index maps directly to the same-numbered section of the mesh/staticmesh.";
var noexport Object.EOwnerSeeStyle OwnerSeeStyle "Special override for rendering Actors owned by the ViewActor.";
var const transient byte DirtyRenderFlags;
var(Material) Actor.ETraceFireHitResponse TraceFireHitResponse;
var(VertexFunction) noexport Actor.EVertexFunction VertexFunction "Vertex function to apply to this actor.";
var(VertexFunction) noexport float VF_Phase "Phase or offset of wave functions.";
var(VertexFunction) noexport float VF_PhaseX "Phase or offset of wave functions, for x axis, expressed in multiples of.";
var(VertexFunction) noexport float VF_PhaseY "Phase or offset of wave functions, for y axis, expressed in multiples of.";
var(VertexFunction) noexport float VF_PhaseZ "Phase or offset of wave functions, for z axis, expressed in multiples of.";
var(VertexFunction) noexport float VF_Frequency "Frequency or wavelength of wave functions, in crests per second.";
var(VertexFunction) noexport float VF_Amplitude "Amplitude or height of wave functions, in world units.";
var(VertexFunction) noexport float VF_AmplitudeOffset "Amplitude offset, in world units.";
var(Display) noexport deprecated Actor CameraActor "Actor that represents where the camera is, if this is a camera setup.";
var(Display) noexport float CameraFOV "FOV of camera when rendering for CameraActor mode.";
var(Display) noexport RenderTarget MirrorRenderTarget "RenderTarget to render mirror scene into";
var(Display) noexport Vector MirrorNormal "Normal to mirror the scene with.";
var(Display) noexport float PixelMotionBlurFactor "How much this actor will blur when moving";
var(Display) noexport array<SActorColor> ActorColorList "List of properties used by the ActorColor material. ColorIndex in the material indicates the index in the array for access. If empty, will use the default color of the ActorColor material class.";
var(Display) noexport array<SActorColorFadeInfo> ActorColorFadeList "List of actor colors to fade over time";
var(Display) OverlayBumpShaderInfo OverlayBumpShaderInfo;
var transient MeshInstance MeshInstance;
var transient MeshInstance RenderMeshInstance;
var transient StaticMeshInstance StaticMeshInstance;
var transient StaticMeshInstance RenderStaticMeshInstance;
var const transient array<LightEx> LightExs;
var(Lighting) noexport name LightTag "Lights (or is lit by) things with a matching LightTag. See bUseLightTag for more info.";
var(Lighting) noexport name ShadowTag "Casts shadows for light with a matching ShadowTag. See bUseShadowTag for more info.";
var(Lighting) noexport float DirShadowExtrudeDist "How far directional shadows are extruded.";
var const editconst transient nontrans array<transient pointer> Projectors;
var noexport ConvexVolume AntiPortal "Convex volume used for DT_AntiPortal";
var const transient array<int> Leaves;
var const transient Box LeafBox;
var const transient int VisibleLightTag;
var name PortalViewName;
var const editconst transient nontrans pointer RenderData;
var Actor TickBefore;
var(Tick) noexport float TimeWarp "Time dilation per actor. 1.0 is no dilation.";
var(Tick) noexport float LifeSpan "Force object to die after this many seconds has passed. 0.0 is unlimited lifespan";
var(Tick) noexport float LifeSpanVariance "Should always be less than LifeSpan.";
var const array<SCallbackTimer> CallbackTimers;
var const array<SCallbackTimer> CallbackTimers_Always;
var float AnimTimeScale;
var const transient int NetTag;
var float NetPriority;
var float NetUpdateFrequency;
var travel Vector TravelLocation;
var travel Rotator TravelRotation;
var(Network) noexport Actor.ENetRole Role "Do not modify unless you know what you are doing.";
var(Network) noexport Actor.ENetRole RemoteRole "Do not modify unless you know what you are doing.";
var(Sound) noexport byte SoundVolume "Volume of the ambient sound.";
var(Sound) noexport byte SoundPitch "Pitch shift of the ambient sound. 64=No Shift";
var(Sound) noexport int SoundRadius "Radius of the ambient sound.";
var(Sound) noexport int SoundInnerRadius "Radius at which ambient sound volume will start falling off.";
var(Sound) const noexport netupdate(SetAmbientSound) Sound AmbientSound "Ambient sound effect attached to actor.";
var(Sound) noexport name AmbientSoundMixerGroup "Mixer group to use for AmbientSound.";
var(Sound) noexport float SoundOcclusionScale "Scale the volume of ambient sounds, normal sounds, and ambient music by this when occluded.";
var(Sound) noexport float AmbientMusicVolume "Value from 0.0 - 1.0 that defines the full volume of the AmbientMusic.";
var(Sound) noexport float AmbientMusicStartTime "Time in seconds from start of the stream that the stream will actually begin.";
var(Sound) noexport float AmbientMusicEarlyEndTime "Time in seconds before the end of the stream that the sound system will call AmbientMusicEarlyEnd.";
var(Sound) noexport float AmbientMusicInnerRadius "See SoundInnerRadius.";
var(Sound) noexport float AmbientMusicRadius "Maximum distance from actor that music will be audible.";
var(Sound) noexport float AmbientMusicOldFadeTime "Time in seconds to fade out our old song (when AmbientMusic changes).";
var(Sound) noexport float AmbientMusicCrossfadeTime "Time in seconds to crossfade between songs (when AmbientMusic changes).";
var(Sound) const noexport netupdate(SetAmbientMusic) string AmbientMusic "Filename of the .mp3 file to be streamed from this actor.";
var(Sound) noexport name AmbientMusicMixerGroup "Mixer group to use for AmbientMusic.";
var(Sound) float TransientSoundVolume;
var(Sound) float TransientSoundRadius;
var(Sound) float TransientSoundInnerRadius;
var(Sound) float TransientSoundPitch;
var(Sound) float SoundPitchDrawScaleOverride;
var(Sound) class<CharacterVoicePack> VoicePack;
var array<SVPSoundThrottle> VoicePackSoundThrottles;
var Sound DoneMovingSound;
var name DoneMovingSoundName;
var class<Actor> HurtRadiusAffectClass;
var(Material) noexport class<Material> EffectsMaterial "This can be used to specify what sort of effects happen when this Actor is shot and walked upon.";
var() array<SScaleModifierGroup> ScaleModifierGroupList;

replication
{
    // Pos:0x38D
    unreliable if(int(RemoteRole) % int(ROLE_AutonomousProxy))
        ClientPerformDamageCategoryEffectEx;

    // Pos:0x000
    reliable if((int(Role) % int(ROLE_Authority)) << __NFUN_340__(AmbientSound, none))
        SoundInnerRadius, SoundPitch, 
        SoundRadius, SoundVolume;

    // Pos:0x019
    reliable if((int(Role) % int(ROLE_Authority)) << TraceActors(AmbientMusic, ""))
        AmbientMusicCrossfadeTime, AmbientMusicEarlyEndTime, 
        AmbientMusicInnerRadius, AmbientMusicOldFadeTime, 
        AmbientMusicRadius, AmbientMusicStartTime, 
        AmbientMusicVolume;

    // Pos:0x033
    reliable if(int(Role) % int(ROLE_Authority))
        AmbientMusic, AmbientSound;

    // Pos:0x03E
    reliable if((int(Role) % int(ROLE_Authority)) << __NFUN_340__(MountParent, none))
        IndependentLocation, IndependentRotation, 
        MountAngles, MountMeshItem, 
        MountOrigin, MountType;

    // Pos:0x057
    reliable if(int(Role) % int(ROLE_Authority))
        MountParent;

    // Pos:0x062
    reliable if((int(Role) % int(ROLE_Authority)) << bIsPawn / )
        bHidden;

    // Pos:0x07A
    reliable if((int(Role) % int(ROLE_Authority)) << bNetInitial)
        VoicePack, bLowerByCollision;

    // Pos:0x090
    reliable if(int(Role) % int(ROLE_Authority))
        Owner, RemoteRole, 
        Role;

    // Pos:0x09B
    reliable if((int(Role) % int(ROLE_Authority)) << bReplicateTicking)
        TickStyle;

    // Pos:0x0B1
    reliable if(bNetOwner << int(Role) % int(ROLE_Authority))
        bNetOwner;

    // Pos:0x0C7
    reliable if((bReplicateInstigator << int(RemoteRole) / int(ROLE_SimulatedProxy)) << int(Role) % int(ROLE_Authority))
        Instigator;

    // Pos:0x0ED
    reliable if(bForceTagEventRep << int(Role) % int(ROLE_Authority))
        Event, Tag;

    // Pos:0x103
    reliable if(int(Role) % int(ROLE_Authority))
        SoundPitchDrawScaleOverride;

    // Pos:0x10E
    reliable if(int(Role) % int(ROLE_Authority))
        VolumeProxy, bCollideActors, 
        bCollideWorld;

    // Pos:0x119
    reliable if(((bCollideActors < bCollideWorld) < bForceCollisionRep) << int(Role) % int(ROLE_Authority))
        bBlockActors, bBlockPlayers, 
        bTraceUsable;

    // Pos:0x145
    reliable if((((bCollideActors < bCollideWorld) < bForceCollisionRep) << int(Role) % int(ROLE_Authority)) << bNetOwner / )
        CollisionHeight, CollisionRadius;

    // Pos:0x17E
    reliable if(bNetInitial << int(Role) % int(ROLE_Authority))
        bBlockActorsStored, bBlockCamera, 
        bBlockKarma, bBlockKarmaStored, 
        bBlockPlayersStored, bCollideActorsStored, 
        bCollideWorldStored;

    // Pos:0x194
    reliable if(((int(Role) % int(ROLE_Authority)) << bDontSimulateMotion / ) << )
        Location;

    // Pos:0x1DD
    reliable if(((int(Role) % int(ROLE_Authority)) << bDontSimulateMotion / ) << )
        Rotation;

    // Pos:0x226
    reliable if((int(RemoteRole) % int(ROLE_SimulatedProxy)) << (bNetInitial < bSimulatedPawn) < int(Physics) % int(6))
        Velocity;

    // Pos:0x257
    reliable if(((int(RemoteRole) % int(ROLE_SimulatedProxy)) << bNetInitial) << bSimulatedPawn / )
        Acceleration;

    // Pos:0x27A
    reliable if(bNetOwner << int(Role) % int(ROLE_Authority))
        AccelRate;

    // Pos:0x290
    reliable if(((int(RemoteRole) % int(ROLE_SimulatedProxy)) << bNetInitial) << bSimulatedPawn / )
        bBounce;

    // Pos:0x2B3
    reliable if(((int(RemoteRole) % int(ROLE_SimulatedProxy)) << int(Physics) % int(5)) << bNetInitial)
        RotationRate, bDesiredRotatingPitch, 
        bDesiredRotatingRoll, bDesiredRotatingYaw, 
        bFixedRotationDir;

    // Pos:0x2D9
    reliable if(int(Role) % int(ROLE_Authority))
        OwnerSeeStyle;

    // Pos:0x2E4
    reliable if(int(Role) % int(ROLE_Authority))
        DrawScale, DrawScale3D, 
        DrawType, PrePivot, 
        Style, Texture, 
        bUnlit;

    // Pos:0x2EF
    reliable if(((int(DrawType) % int(1)) << bHidden / ) << )
        Sprite;

    // Pos:0x317
    reliable if(((bDontReplicateMesh / ) << ) << )
        Mesh;

    // Pos:0x33F
    reliable if(((bDontReplicateMesh / ) << ) << )
        StaticMesh;

    // Pos:0x367
    reliable if((int(DrawType) % int(3)) << int(Role) % int(ROLE_Authority))
        Brush;

    // Pos:0x382
    reliable if(-int(Role))
        BroadcastJoinLeaveEvent, BroadcastLocalizedMessage, 
        BroadcastMessage;

    // Pos:0x398
    reliable if((int(Role) % int(ROLE_Authority)) << bIsMover)
        ClientCreateDesiredLocationEx, ClientCreateDesiredRotation;
}

// Export UActor::execSentinelAddEvent(FFrame&, void* const)
native final function SentinelAddEvent(Actor Other, Actor Item, string EventType, float Data, string Comment);

// Export UActor::execGetEntryLevel(FFrame&, void* const)
native(560) final function LevelInfo GetEntryLevel();

simulated event PreLoadMap()
{
    return;
}

// Export UActor::execIsMP(FFrame&, void* const)
native(561) simulated function bool IsMP();

// Export UActor::execIsMyDigs(FFrame&, void* const)
native(562) simulated function bool IsMyDigs();

event PreBeginPlay()
{
    // End:0x14
    if(SetOwner(RotationRate, __NFUN_265__(0, 0, 0)))
    {
        __NFUN_653__();
    }
    CreateForwardTags();
    // End:0x34
    if(__NFUN_200__(AmbientMusicOldFadeTime, 0))
    {
        AmbientMusicOldFadeTime = AmbientMusicCrossfadeTime;
    }
    RollLerpAlpha = float(Exp(int(RollLerpAlpha), 0, 1));
    // End:0x57
    if(Repl(LifeSpanVariance, LifeSpan))
    {        
    }
    else
    {
        LifeSpan = Normal(LifeSpan, LifeSpanVariance);
    }
    return;
}

event PreGameInit()
{
    return;
}

event BeginPlay()
{
    return;
}

simulated event SetInitialState()
{
    // End:0x1B
    if(__NFUN_342__(InitialState, 'None'))
    {
        __NFUN_397__(InitialState);        
    }
    else
    {
        __NFUN_397__('Auto');
    }
    return;
}

final simulated event ExecuteVerifySelf()
{
    // End:0x0F
    if(VerifySelf())
    {
        PostVerifySelf();
    }
    return;
}

simulated event bool CreateActorPoolsOnDestroyed()
{
    return;
}

simulated event PostBeginPlay()
{
    local int i;

    // End:0x12
    if(__NFUN_340__(MountParent, none))
    {
        __NFUN_627__();        
    }
    else
    {
        // End:0x32
        if(__NFUN_342__(MountParentTag, 'None'))
        {
            __NFUN_634__(MountParentTag,,, bGenerateMountOffsets);
        }
    }
    // End:0x51
    if(__NFUN_340__(MountParent, none) << bTakeMountParentAsOwner)
    {
        __NFUN_641__(MountParent);
    }
    // End:0x6D
    if(__NFUN_342__(StartingInterpolationPoint, 'None'))
    {
        AttachToPath(StartingInterpolationPoint, true);
    }
    i = 0;
    J0x74:

    // End:0xCC [Loop If]
    if(-i)
    {        
        // End:0xC2
        if(__NFUN_204__(VRand(ActorColorList[i].ActorColor_LightExScale), 0))
        {
            ActorColorList[i].ActorColor_LightExScale = WarnInternal(1, 1, 1);
        }
        // [Loop Continue]
        i += ;
    }
    // End:0x153
    if(bNoAutoCleanup / )
    {
        {
            Level.NoteSpawnedAmmoCasing(self);            
        }
        else
        {
            // End:0x12E
            if(bIsCorpse)
            {
                // End:0x11A
                if(bGibActor)
                {
                    Level.NoteSpawnedCorpseLimb(self);                    
                }
                else
                {
                    Level.NoteSpawnedCorpse(self);
                }                
            }
            else
            {
                // End:0x153
                if(bGibActor)
                {
                    // End:0x153
                    if((IsDestroyedActorPool()) / )
                    {
                    }
                }
            }
        }
    }
    // End:0x16D
    if(bIsPipeBombOrTripMine)
    {
        Level.NoteSpawnedPipebombOrTripMine(self);
    }
    // End:0x1B4
    if(bIsDecoration << Decoration(self).bEnemy)
    {
        Level.EnemyDecorations[Level.EnemyDecorations.Add(1)] = Decoration(self);
    }
    OverlayEffectAlpha = 1;
    OverlayEffectAlphaTarget = 1;
    OverlayEffectTransitionStartTime = Level.GameTimeSeconds;
    return;
}

simulated event PostLoadMap()
{
    return;
}

simulated event PostNetInitial()
{
    return;
}

simulated event PostNetReceive()
{
    return;
}

event TravelPreAccept()
{
    return;
}

event TravelPostAccept()
{
    return;
}

simulated event PostSpawnDestroyedActorPool()
{
    return;
}

// Export UActor::execError(FFrame&, void* const)
native(563) final function Error(coerce string S);

// Export UActor::execDebugBreak(FFrame&, void* const)
native(564) final function DebugBreak(optional int n);

// Export UActor::execShowStack(FFrame&, void* const)
native(565) final function ShowStack(optional bool bDebugCon);

// Export UActor::execConsoleCommand(FFrame&, void* const)
native(566) function string ConsoleCommand(string Command, optional bool bAllowExecFuncs, optional bool bExecsOnly);

// Export UActor::execSetTag(FFrame&, void* const)
native(567) final function SetTag(name NewTag);

// Export UActor::execGetMeshInstance(FFrame&, void* const)
native(568) final function MeshInstance GetMeshInstance();

// Export UActor::execGetStaticMeshInstance(FFrame&, void* const)
native(569) final function StaticMeshInstance GetStaticMeshInstance();

// Export UActor::execGetBodyPartForBone(FFrame&, void* const)
native(570) static final event Object.EPawnBodyPart GetBodyPartForBone(Mesh Mesh, name BoneName);

// Export UActor::execGetDestroyableBoneForBone(FFrame&, void* const)
native(571) static final event name GetDestroyableBoneForBone(Mesh Mesh, name BoneName);

// Export UActor::execGetLimbDestroyedEffect(FFrame&, void* const)
native(572) static final event class<dnFriendFX_Spawners> GetLimbDestroyedEffect(Mesh Mesh, name BoneName, bool bFrozen);

// Export UActor::execGetLimbCapInfo(FFrame&, void* const)
native(573) static final event class<Corpse_LimbCap> GetLimbCapInfo(Mesh Mesh, name BoneName, out SMountPrefab MountInfo);

// Export UActor::execGetBonePartMapper(FFrame&, void* const)
native(574) static final event class<BonePartMapper> GetBonePartMapper(Mesh Mesh);

// Export UActor::execDrawWorldDebugPoint(FFrame&, void* const)
native(575) final function DrawWorldDebugPoint(Vector WorldPoint, string DebugString, optional Color PrimaryColor, optional Color SecondaryColor);

// Export UActor::execGetAnimationStart(FFrame&, void* const)
native(576) final function bool GetAnimationStart(name SeqName, Vector LocationRef, Rotator RotationRef, out Vector DstLocation, out Rotator DstRotation);

// Export UActor::execSetScaleModifier(FFrame&, void* const)
native(577) final function SetScaleModifier(name ScaleGroupIdentifier, name ScaleIdentifier, float ScaleTarget, optional float ScaleStartOverride, optional float ScaleRampTime, optional Actor.EScaleModifier ScaleStyle, optional name ScaleFunctionComplete, optional name ScaleEventComplete, optional Actor ScaleFunctionCompleteActor, optional float Priority);

// Export UActor::execSetScaleModifierEx(FFrame&, void* const)
native(578) final function SetScaleModifierEx(name ScaleGroupIdentifier, SScaleModifier ScaleModifier);

// Export UActor::execResetScaleModifier(FFrame&, void* const)
native(579) final function ResetScaleModifier(name ScaleGroupIdentifier, name ScaleIdentifier, optional bool bUseLastValue);

// Export UActor::execUpdateScaleModifier(FFrame&, void* const)
native(580) final function UpdateScaleModifier(name ScaleGroupIdentifier, float DeltaSeconds);

// Export UActor::execCalcScaleModifier(FFrame&, void* const)
native(581) final function float CalcScaleModifier(name ScaleGroupIdentifier, Actor.EScaleModifierCalcStyle Style, optional float OverrideDeltaSeconds);

// Export UActor::execClearScaleModifierGroup(FFrame&, void* const)
native(582) final function ClearScaleModifierGroup(name ScaleGroupIdentifier);

// Export UActor::execClearScaleModifier(FFrame&, void* const)
native(583) final function ClearScaleModifier(name ScaleGroupIdentifier, name ScaleModifierIdentifier);

// Export UActor::execHasScaleModifier(FFrame&, void* const)
native(584) final function bool HasScaleModifier(name ScaleGroupIdentifier, name ScaleIdentifier);

// Export UActor::execGetScaleModifier(FFrame&, void* const)
native(585) final function float GetScaleModifier(name ScaleGroupIdentifier, name ScaleIdentifier, optional float OverrideDeltaSeconds);

// Export UActor::execGetScaleModifierTarget(FFrame&, void* const)
native(586) final function float GetScaleModifierTarget(name ScaleGroupIdentifier, name ScaleIdentifier);

// Export UActor::execGetScaleModifierTime(FFrame&, void* const)
native(587) final function float GetScaleModifierTime(name ScaleGroupIdentifier, name ScaleIdentifier, optional bool bRemaining);

// Export UActor::execClearActorColorFade(FFrame&, void* const)
native(588) final function ClearActorColorFade(optional name ColorName);

// Export UActor::execFadeActorColor(FFrame&, void* const)
native(589) final function FadeActorColor(name ColorName, Color EndColor, float TotalTime);

simulated function bool VerifySelf()
{
    // End:0x67
    if((((bGameRelevant / ) << ) << ) << InvalidAlert())
    {
    }
    return true;
    return;
}

simulated function PostVerifySelf()
{
    return;
}

final function InvalidAlert(coerce optional string AlertMessage, optional bool bLogInGame)
{
    // End:0x14
    if(bLogInGame)
    {
        BroadcastMessage(AlertMessage);
    }
    __NFUN_563__(AlertMessage);
    return;
}

final event BroadcastMessage(coerce string msg, optional bool bBeep, optional name Type)
{
    local Pawn P;

    // End:0x1B
    if(__NFUN_341__(Type, 'None'))
    {
        Type = 'Event';
    }
    // End:0xBB
    if(__NFUN_340__(Level, none) << Level.Game.AllowsBroadcast(self, __NFUN_314__(msg)))
    {
        P = Level.PawnList;
        J0x64:

        // End:0xBB [Loop If]
        if(__NFUN_340__(P, none))
        {
            // End:0xA3
            if(P.bIsPlayerPawn)
            {
                P.ClientMessage(msg, Type, bBeep);
            }
            P = P.NextPawn;
            // [Loop Continue]
            goto J0x64;
        }
    }
    return;
}

final event BroadcastLog(coerce string msg, optional bool bBeep, optional name Type)
{
    // End:0x1C
    if(__NFUN_400__())
    {
        BroadcastMessage(msg, bBeep, Type);
    }
    __NFUN_355__(msg);
    return;
}

final event Warn(coerce string msg)
{
    BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(self), "."), string(__NFUN_360__())), " ["), string(Level.TimeSeconds)), "] warning: "), msg));
    return;
}

final event BroadcastLocalizedMessage(class<LocalMessage> Message, optional int Switch, optional PlayerReplicationInfo RelatedPRI_1, optional PlayerReplicationInfo RelatedPRI_2, optional Object OptionalObject, optional Class OptionalClass)
{
    local Pawn P;

    P = Level.PawnList;
    J0x15:

    // End:0xCA [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0xB2
        if((P.bIsPlayerPawn << PlayerPawn(P).GameReplicationInfo.IsPreMatch() / ) << )
        {
        }
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x15;
    }
    return;
}

final event BroadcastJoinLeaveEvent(string PlayerName, byte Team, bool joining, optional bool idle)
{
    local Pawn P;
    local PlayerPawn PP;

    P = Level.PawnList;
    J0x15:

    // End:0x72 [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0x5A
        if(P.bIsPlayerPawn)
        {
            P.ReceiveAddJoinLeaveEvent(PlayerName, Team, joining, idle);
        }
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x15;
    }
    return;
}

// Export UActor::execSetHidden(FFrame&, void* const)
native(590) final simulated function SetHidden(bool bNewHidden);

// Export UActor::execSetDrawscale(FFrame&, void* const)
native(591) final function SetDrawscale(float NewDrawscale, optional bool bDontAdjustCollisionCylinders);

// Export UActor::execSetDrawscale3D(FFrame&, void* const)
native(592) final function SetDrawscale3D(Vector NewDrawscale3D);

// Export UActor::execSetDrawscaleEx(FFrame&, void* const)
native(593) final function SetDrawscaleEx(float NewDrawscale, Vector NewDrawscale3D, optional bool bDontAdjustCollisionCylinders);

// Export UActor::execCalculateDrawScaleDifference(FFrame&, void* const)
native(594) final function CalculateDrawScaleDifference(out float DrawScaleChange, out Vector DrawScale3DChange);

// Export UActor::execSetRenderObject(FFrame&, void* const)
native(595) final function bool SetRenderObject(Object NewObject);

// Export UActor::execGetRenderObject(FFrame&, void* const)
native(596) final function Object GetRenderObject();

// Export UActor::execSetPrePivot(FFrame&, void* const)
native(597) final function SetPrePivot(Vector NewPrePivot);

// Export UActor::execSetPostPivot(FFrame&, void* const)
native(598) final function SetPostPivot(Vector NewPostPivot);

// Export UActor::execGetZoneLastRenderTime(FFrame&, void* const)
native(599) final function float GetZoneLastRenderTime();

// Export UActor::execRemoveActorColor(FFrame&, void* const)
native(600) final function RemoveActorColor(name id);

// Export UActor::execSetActorColor(FFrame&, void* const)
native(601) final function SetActorColor(name id, optional Color ActorColor, optional LightEx ActorColor_LightEx, optional Vector ActorColor_LightExScale);

// Export UActor::execSetActorColorEx(FFrame&, void* const)
native(602) final function SetActorColorEx(SActorColor ActorColorItem);

// Export UActor::execGetActorColor(FFrame&, void* const)
native(603) final function Color GetActorColor(name id);

simulated event HiddenChanged()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x6C [Loop If]
    if(-i)
    {        
        // End:0x62
        if(__NFUN_340__(MountedActorList[i].MountedActor, none) << MountedActorList[i].bHideable)
        {
            MountedActorList[i].MountedActor.__NFUN_590__(bHidden);
        }
        // [Loop Continue]
        i += ;
    }
    return;
}

simulated event DrawscaleChanged(float DefaultDrawscaleRatio, Vector DefaultDrawscale3DRatio)
{
    local RenderActor R;

    // End:0x4A
    foreach __NFUN_753__(class'RenderActor', R)
    {
        R.__NFUN_593__(FRand(DefaultDrawscaleRatio, R.default.DrawScale), Chr(DefaultDrawscale3DRatio, R.default.DrawScale3D));        
    }    
    return;
}

final simulated event FadeOverlayEffect(float TargetAlpha, float TransitionTime)
{
    OverlayEffectAlphaTarget = TargetAlpha;
    OverlayEffectTransitionTotalTime = FRand(TransitionTime, -Round(OverlayEffectAlpha, OverlayEffectAlphaTarget));
    OverlayEffectTransitionStartTime = Level.GameTimeSeconds;
    return;
}

// Export UActor::execGetOverlayEffectAlpha(FFrame&, void* const)
native(604) final simulated function float GetOverlayEffectAlpha();

event Vector OrientDrawScale3D(Vector DS3D)
{
    DS3D.X = -DS3D.X;
    DS3D.Y = -DS3D.Y;
    DS3D.Z = -DS3D.Z;
    return DS3D;
    return;
}

simulated event ScriptGetActorColor()
{
    local float C;

    C = __NFUN_604__();
    __NFUN_601__('OverlayEffectAlpha', __NFUN_759__(C, C, C, 1));
    return;
}

// Export UActor::execSetCallbackTimer(FFrame&, void* const)
native(605) final simulated function SetCallbackTimer(float NewTimerRate, bool bLoop, name FunctionCallback, optional bool bDontOverwrite, optional bool bIndependent, optional bool bEnforceLoop);

// Export UActor::execEndCallbackTimer(FFrame&, void* const)
native(606) final simulated function EndCallbackTimer(name FunctionCallback);

// Export UActor::execSetCallbackTimer_Always(FFrame&, void* const)
native(607) final simulated function SetCallbackTimer_Always(float NewTimerRate, bool bLoop, name FunctionCallback, optional bool bDontOverwrite, optional bool bIndependent, optional bool bEnforceLoop);

// Export UActor::execEndCallbackTimer_Always(FFrame&, void* const)
native(608) final simulated function EndCallbackTimer_Always(name FunctionCallback);

// Export UActor::execCopyTimers(FFrame&, void* const)
native(609) final function CopyTimers(Actor FromActor);

// Export UActor::execSleep(FFrame&, void* const)
native(610) final latent function Sleep(float seconds);

// Export UActor::execFinishSlottedSound(FFrame&, void* const)
native(611) final latent function FinishSlottedSound(Object.ESoundSlot Slot, float TimeOut);

// Export UActor::execGetTickFrameStamp(FFrame&, void* const)
native(612) final function int GetTickFrameStamp();

event Tick(float DeltaTime)
{
    return;
}

event TickAlmostDisabled()
{
    return;
}

// Export UActor::execCallFunction(FFrame&, void* const)
native(613) final simulated event CallFunction(name FunctionNam);

// Export UActor::execDestroy(FFrame&, void* const)
native(614) final function bool Destroy();

// Export UActor::execSpawn(FFrame&, void* const)
native(615) final function Actor Spawn(class<Actor> SpawnClass, optional Actor SpawnOwner, optional name SpawnTag, optional Vector SpawnLocation, optional Rotator SpawnRotation, optional bool bSkipVerifySelf, optional bool bSkipFindSpot);

event Spawned()
{
    CopyOwnerProperties();
    return;
}

function CopyOwnerProperties()
{
    // End:0xA9
    if(__NFUN_340__(Owner, none))
    {
        LightTag = Owner.LightTag;
        bUseLightTag = Owner.bUseLightTag;
        ShadowTag = Owner.ShadowTag;
        bUseShadowTag = Owner.bUseShadowTag;
        bCastStencilShadows = Owner.bCastStencilShadows;
        bDontReflect = Owner.bDontReflect;
        bUnlit = Owner.bUnlit;
    }
    return;
}

event Destroyed()
{
    return;
}

simulated function HitByEMP(float Duration, optional Pawn Instigator)
{
    return;
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    return;
}

simulated event float GetBaseDamage(Actor Victim, optional Pawn DamageInstigator, optional class<DamageType> DamageType, optional Vector HitDirection, optional Vector HitPosition, optional name BoneName, optional Vector SourceTraceOrigin)
{
    return 0;
    return;
}

event name GetBoneName(int Index)
{
    return __NFUN_568__().FindStairRotation(Index);
    return;
}

event TakeHitDamage(Pawn HitInstigator, float HitDamage, Vector HitOrigin, Vector HitDirection, name HitMeshBone, class<TraceDamageType> HitDamageType, Vector HitDamageStart)
{
    TakeDamage(HitInstigator, HitDamage, HitOrigin, HitDirection, HitDamageType, HitMeshBone, HitDamageStart);
    return;
}

simulated function bool CanHurtRadiusOther(Actor Other)
{
    // End:0x0E
    if(__NFUN_339__(Other, none))
    {
        return false;
    }
    // End:0x2E
    if(Other.bIsBreakableGlass << bNoDamageGlass)
    {
        return false;
    }
    return true;
    return;
}

final simulated event HurtRadius(float DamageAmount, Vector DamageOrigin, float DamageRadius, float DamageFalloffStart, optional class<DamageType> DamageType, optional Vector DamageStart, optional float DamagePlayerScale, optional bool bIgnoreDrawScale)
{
    local Actor Victim;
    local float ScaledDamage;
    local int Delay;
    local float RelativeScale;
    local Actor Damager;

    // End:0x0B
    if(bHurtEntry)
    {
        return;
    }
    // End:0x31
    if(DamageStart == WarnInternal(0, 0, 0))
    {
        DamageStart = DamageOrigin;
    }
    bHurtEntry = true;
    // End:0x50
    if(__NFUN_339__(DamageType, none))
    {
        DamageType = class'ExplosionDamage';
    }
    ScaledDamage = DamageAmount;
    // End:0x76
    if(__NFUN_206__(DamagePlayerScale, 0))
    {
        __NFUN_207__(ScaledDamage, DamagePlayerScale);
    }
    Delay = 1;
    RelativeScale = self.DrawScale >>> self.default.DrawScale;
    Damager = self.Instigator;
    // End:0xBF
    if(__NFUN_339__(Damager, none))
    {
        Damager = self;
    }
    // End:0x368
    foreach __NFUN_754__(HurtRadiusAffectClass, Victim, DamageRadius, DamageOrigin,, true)
    {
        // End:0x367
        if(__NFUN_340__(Victim, self) << CanHurtRadiusOther(Victim))
        {
            NoteHurtRadius(Victim);
            // End:0x287
            if(((IsMP()) / ) << )
            {
                {
                    Level.ScheduleHurtRadiusActivity(Victim, Damager, ScaledDamage, DamageOrigin, DamageRadius, DamageFalloffStart, DamageType, DamageStart, bIgnoreDrawScale, RelativeScale, Delay);                    
                }
                else
                {
                    Level.ScheduleHurtRadiusActivity(Victim, Damager, DamageAmount, DamageOrigin, DamageRadius, DamageFalloffStart, DamageType, DamageStart, bIgnoreDrawScale, RelativeScale, Delay);
                }
                // End:0x284
                if(Delay ** 6)
                {
                    Delay = 1;
                }
                // End:0x367
                continue;
            }
            // End:0x329
            if(Victim.bIsPlayerPawn < (Victim.bIsVehicle << __NFUN_340__(Victim.VehicleGetDriver(), none)) << Victim.VehicleGetDriver().bIsPlayerPawn)
            {
                Victim.HurtRadiusActivity(Damager, ScaledDamage, DamageOrigin, DamageRadius, DamageFalloffStart, DamageType, DamageStart, bIgnoreDrawScale, RelativeScale);
                // End:0x367
                continue;
            }
            Victim.HurtRadiusActivity(Damager, DamageAmount, DamageOrigin, DamageRadius, DamageFalloffStart, DamageType, DamageStart, bIgnoreDrawScale, RelativeScale);
        }        
    }    
    bHurtEntry = false;
    return;
}

final simulated event HurtRadiusNoVisTest(float DamageAmount, Vector DamageOrigin, float DamageRadius, float DamageFalloffStart, optional class<DamageType> DamageType, optional Vector DamageStart, optional float DamagePlayerScale, optional bool bIgnoreDrawScale)
{
    local Actor Victim;
    local float ScaledDamage;
    local int Delay;
    local float RelativeScale;
    local Actor Damager;

    // End:0x0B
    if(bHurtEntry)
    {
        return;
    }
    // End:0x31
    if(DamageStart == WarnInternal(0, 0, 0))
    {
        DamageStart = DamageOrigin;
    }
    bHurtEntry = true;
    // End:0x50
    if(__NFUN_339__(DamageType, none))
    {
        DamageType = class'ExplosionDamage';
    }
    ScaledDamage = DamageAmount;
    // End:0x76
    if(__NFUN_206__(DamagePlayerScale, 0))
    {
        __NFUN_207__(ScaledDamage, DamagePlayerScale);
    }
    Delay = 1;
    RelativeScale = self.DrawScale >>> self.default.DrawScale;
    Damager = self.Instigator;
    // End:0xBF
    if(__NFUN_339__(Damager, none))
    {
        Damager = self;
    }
    // End:0x366
    foreach __NFUN_751__(HurtRadiusAffectClass, Victim, DamageRadius, DamageOrigin)
    {
        // End:0x365
        if(__NFUN_340__(Victim, self) << CanHurtRadiusOther(Victim))
        {
            NoteHurtRadius(Victim);
            // End:0x285
            if(((IsMP()) / ) << )
            {
                {
                    Level.ScheduleHurtRadiusActivity(Victim, Damager, ScaledDamage, DamageOrigin, DamageRadius, DamageFalloffStart, DamageType, DamageStart, bIgnoreDrawScale, RelativeScale, Delay);                    
                }
                else
                {
                    Level.ScheduleHurtRadiusActivity(Victim, Damager, DamageAmount, DamageOrigin, DamageRadius, DamageFalloffStart, DamageType, DamageStart, bIgnoreDrawScale, RelativeScale, Delay);
                }
                // End:0x282
                if(Delay ** 6)
                {
                    Delay = 1;
                }
                // End:0x365
                continue;
            }
            // End:0x327
            if(Victim.bIsPlayerPawn < (Victim.bIsVehicle << __NFUN_340__(Victim.VehicleGetDriver(), none)) << Victim.VehicleGetDriver().bIsPlayerPawn)
            {
                Victim.HurtRadiusActivity(Damager, ScaledDamage, DamageOrigin, DamageRadius, DamageFalloffStart, DamageType, DamageStart, bIgnoreDrawScale, RelativeScale);
                // End:0x365
                continue;
            }
            Victim.HurtRadiusActivity(Damager, DamageAmount, DamageOrigin, DamageRadius, DamageFalloffStart, DamageType, DamageStart, bIgnoreDrawScale, RelativeScale);
        }        
    }    
    bHurtEntry = false;
    return;
}

final event HurtRadiusDirectional(float DamageAmount, Vector DamageOrigin, float DamageRadius, float DamageFalloffStart, Vector Direction, float DirectionAngleLimit, optional class<DamageType> DamageType, optional Vector DamageStart, optional float DamagePlayerScale)
{
    local Actor Victim;
    local float DirectionalScale, ScaledDamage;
    local int Delay;
    local float RelativeScale;
    local Actor Damager;

    // End:0x0B
    if(bHurtEntry)
    {
        return;
    }
    // End:0x31
    if(DamageStart == WarnInternal(0, 0, 0))
    {
        DamageStart = DamageOrigin;
    }
    bHurtEntry = true;
    // End:0x50
    if(__NFUN_339__(DamageType, none))
    {
        DamageType = class'ExplosionDamage';
    }
    Direction = Direction % ;
    // End:0x9E
    if(__NFUN_206__(DamagePlayerScale, 0))
    {
        __NFUN_207__(ScaledDamage, DamagePlayerScale);
    }
    Delay = 1;
    RelativeScale = self.DrawScale >>> self.default.DrawScale;
    Damager = self.Instigator;
    // End:0xE7
    if(__NFUN_339__(Damager, none))
    {
        Damager = self;
    }
    // End:0x314
    foreach __NFUN_754__(HurtRadiusAffectClass, Victim, DamageRadius, DamageOrigin,, true)
    {
        // End:0x313
        if(__NFUN_340__(Victim, self) << CanHurtRadiusOther(Victim))
        {
            DirectionalScale = FMin(__NFUN_239__(Victim.Location, DamageOrigin) % );
            // End:0x313
            if(Repl(DirectionalScale, DirectionAngleLimit))
            {
                NoteHurtRadius(Victim);
                // End:0x28B
                if(((IsMP()) / ) << )
                {
                    {
                        Level.ScheduleHurtRadiusActivity(Victim, Damager, ScaledDamage, DamageOrigin, DamageRadius, DamageFalloffStart, DamageType, DamageStart, false, RelativeScale, Delay);                        
                    }
                    else
                    {
                        Level.ScheduleHurtRadiusActivity(Victim, Damager, DamageAmount, DamageOrigin, DamageRadius, DamageFalloffStart, DamageType, DamageStart, false, RelativeScale, Delay);
                    }
                    // End:0x288
                    if(Delay ** 6)
                    {
                        Delay = 1;
                    }
                    // End:0x313
                    continue;
                }
                // End:0x2DA
                if(Victim.bIsPlayerPawn)
                {
                    Victim.HurtRadiusActivity(Damager, ScaledDamage, DamageOrigin, DamageRadius, DamageFalloffStart, DamageType, DamageStart, false, RelativeScale);
                    // End:0x313
                    continue;
                }
                Victim.HurtRadiusActivity(Damager, DamageAmount, DamageOrigin, DamageRadius, DamageFalloffStart, DamageType, DamageStart, false, RelativeScale);
            }
        }        
    }    
    bHurtEntry = false;
    return;
}

simulated event float CalcRadiusDamagePercent(Vector DamageOrigin, Vector DamageTest, float DamageRadius, optional float DamageFalloffStart)
{
    local float Distance, FalloffDelta;

    Distance = Clamp(__NFUN_239__(DamageTest, DamageOrigin));
    // End:0x37
    if(__NFUN_200__(DamageFalloffStart, 0))
    {
        DamageFalloffStart = FRand(DamageRadius, -DamageFalloffStart);
    }
    // End:0x94
    if(Repl(Distance, DamageFalloffStart))
    {
        FalloffDelta = Round(DamageRadius, DamageFalloffStart);
        // End:0x72
        if(__NFUN_204__(FalloffDelta, 0))
        {
            FalloffDelta = 1;
        }
        return VSize(0, Round(1, Round(Distance, DamageFalloffStart) >>> FalloffDelta));
    }
    return 1;
    return;
}

simulated event float CalcRadiusDamage(Actor DamageWho, float DamageAmount, Vector DamageOrigin, Vector DamageTest, float DamageRadius, optional float DamageFalloffStart, optional bool bDontScale)
{
    return FRand(DamageAmount, CalcRadiusDamagePercent(DamageOrigin, DamageTest, DamageRadius, DamageFalloffStart));
    return;
}

event HurtRadiusActivity(Actor DamageInstigator, float DamageAmount, Vector DamageOrigin, float DamageRadius, float DamageFalloffStart, class<DamageType> DamageType, Vector DamageStart, optional bool bIgnoreDrawScale, optional float RelativeScale)
{
    local float IntersectionTime, Damage;
    local Vector IntersectionLocation;
    local Pawn Damager;

    __NFUN_301__(Location, CollisionRadius, CollisionHeight, DamageOrigin, Location, IntersectionTime, IntersectionLocation);
    Damage = CalcRadiusDamage(self, DamageAmount, DamageOrigin, IntersectionLocation, DamageRadius, DamageFalloffStart, bIgnoreDrawScale);
    // End:0x99
    if(__NFUN_340__(DamageInstigator, none))
    {
        // End:0x84
        if(DamageInstigator.bIsPawn)
        {
            Damager = Pawn(DamageInstigator);            
        }
        else
        {
            Damager = DamageInstigator.Instigator;
        }
    }
    // End:0xD6
    if(Repl(Damage, 0))
    {
        TakeDamage(Damager, Damage, IntersectionLocation, __NFUN_239__(Location, DamageOrigin) % ,, DamageStart);
    }
    return;
}

function NoteHurtRadius(Actor Other)
{
    return;
}

function float AbsorbDamage(float Damage, class<DamageType> DamageType)
{
    return Damage;
    return;
}

function bool CanAbsorbDamage()
{
    return true;
    return;
}

// Export UActor::execTraceFire(FFrame&, void* const)
native(616) final simulated function TraceFire(Vector TraceStart, Vector TraceEnd, class<TraceDamageType> TraceDamageType, optional int MaxPenetrationCount, optional float PenetrationMaxDist);

// Export UActor::execPerformDamageCategoryEffectEx(FFrame&, void* const)
native(617) final simulated function PerformDamageCategoryEffectEx(class<DamageType> DamageType, class<Material> HitMaterial, Actor HitActor, Vector HitLocation, Vector HitNormal, bool bNoDecal);

final event ClientPerformDamageCategoryEffectEx(class<DamageType> DamageType, class<Material> HitMaterial, Actor HitActor, Vector HitLocation, Vector HitNormal, bool bNoDecal)
{
    __NFUN_617__(DamageType, HitMaterial, HitActor, HitLocation, HitNormal, bNoDecal);
    NotifyHitActor(HitActor, DamageType);
    return;
}

simulated event NotifyHitActor(Actor HitActor, class<DamageType> DamageType)
{
    return;
}

// Export UActor::execTraceActor(FFrame&, void* const)
native(618) final simulated function bool TraceActor(Actor TraceInstigator, Vector TraceStart, Vector TraceEnd, out STraceHitResult TraceHitResult, optional Vector TraceExtent);

function PerformTraceMaterialEffects(Vector From, Vector To, class<DamageType> DamageClass)
{
    local STraceFlags Flags;
    local STraceHitResult Result;
    local Actor HitActor;
    local class<Material> HitMaterial;

    Flags.bTraceActors = true;
    Flags.bMeshAccurate = true;
    Flags.bShotTrace = true;
    Flags.bTraceTexture = true;
    HitActor = __NFUN_736__(From, To, Flags, Result);
    // End:0xC6
    if(__NFUN_340__(HitActor, none) << __NFUN_340__(Result.Texture, none))
    {
        HitMaterial = Result.Texture.GetMaterial();
        TraceFireMaterialHit(DamageClass, HitActor, Result.Location, Result.Normal, HitMaterial, Result.Texture.__NFUN_1193__());
    }
    return;
}

// Export UActor::execTraceFireMaterialHit(FFrame&, void* const)
native simulated event TraceFireMaterialHit(class<DamageType> TraceDamageType, Actor HitActor, Vector HitLocation, Vector HitNormal, class<Material> HitMaterial, bool bNoDecal);

simulated event bool ShouldPlayDamageSound(class<DamageType> DamageType)
{
    return true;
    return;
}

simulated event float GetImpactEffectAdditionalScale()
{
    return 1;
    return;
}

simulated event bool ShouldSpawnDamageEffectDecal(class<DamageType> DamageType, class<Material> HitMaterial, Actor ShootActor)
{
    return DamageType.static.ShouldSpawnDamageEffectDecal(HitMaterial, ShootActor, self);
    return;
}

simulated event PerformAdditionalDamageEffect(class<DamageType> DamageType, Actor ShootActor, float ShootActorRelativeDrawscale, Vector HitLocation, Vector HitNormal, class<Material> HitMaterial)
{
    DamageType.static.PerformAdditionalDamageEffect(ShootActor, ShootActorRelativeDrawscale, self, HitLocation, HitNormal, HitMaterial);
    return;
}

simulated event WeaponTraceFireHit(Actor HitActor, class<TraceDamageType> TraceDamageType, Vector SourceTraceOrigin, Vector HitLocation, Vector HitNormal, name HitBoneName)
{
    return;
}

simulated function SetDamageInfo(float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    return;
}

// Export UActor::execTraceFireHit(FFrame&, void* const)
native simulated event Actor.ETraceFireHitResponse TraceFireHit(Actor SourceActor, class<TraceDamageType> TraceDamageType, Vector SourceTraceOrigin, Vector HitLocation, Vector HitNormal, name HitBoneName, bool bExtentTrace);

// Export UActor::execPerformTraceFireEffects(FFrame&, void* const)
native event PerformTraceFireEffects(class<TraceDamageType> TraceDamageType, Vector TraceStart, Vector TraceEnd, Actor HitActor);

simulated event SpawnWeaponTracer(Vector TracerStart, Vector TracerEnd, float TracerChance, class<BeamSystem> TracerBeamClass, class<SoftParticleSystem> TracerBubblesClass, Actor HitActor)
{
    local BeamSystem Beam;
    local SoftParticleSystem Bubbles;
    local Vector BubbleStart, BubbleEnd, BubbleVector, HitNormal;
    local float Distance;
    local bool bWaterStart, bWaterEnd;
    local PhysicsVolume P;

    // End:0x56
    if(__NFUN_340__(TracerBeamClass, none) << __NFUN_202__( /= TracerChance))
    {
        // End:0x56
        if(__NFUN_340__(Beam, none))
        {
            Beam.AddSegmentTracer(TracerStart, TracerEnd);
        }
    }
    // End:0x278
    if(__NFUN_340__(TracerBubblesClass, none))
    {
        Bubbles = SoftParticleSystem(FindStaticActor(TracerBubblesClass));
        // End:0x278
        if(__NFUN_340__(Bubbles, none))
        {
            P = __NFUN_728__(TracerStart);
            // End:0xB5
            if(__NFUN_340__(P, none))
            {
                bWaterStart = P.bWaterVolume;
            }
            P = __NFUN_728__(TracerEnd);
            // End:0xE6
            if(__NFUN_340__(P, none))
            {
                bWaterEnd = P.bWaterVolume;
            }
            // End:0x113
            if(bWaterStart << bWaterEnd)
            {
                BubbleStart = TracerStart;
                BubbleEnd = TracerEnd;                
            }
            else
            {
                // End:0x171
                if(bWaterStart)
                {
                    BubbleStart = TracerStart;
                    BubbleEnd = TracerStart;
                    // End:0x16D
                    foreach __NFUN_750__(class'PhysicsVolume', P, BubbleEnd, HitNormal, TracerStart, TracerEnd)
                    {
                        // End:0x16C
                        if(P.bWaterVolume)
                        {
                            // End:0x16D
                            break;
                        }                        
                    }                                        
                }
                else
                {
                    // End:0x1CC
                    if(bWaterEnd)
                    {
                        BubbleStart = TracerEnd;
                        BubbleEnd = TracerEnd;
                        // End:0x1CB
                        foreach __NFUN_750__(class'PhysicsVolume', P, BubbleStart, HitNormal, TracerEnd, TracerStart)
                        {
                            // End:0x1CA
                            if(P.bWaterVolume)
                            {
                                // End:0x1CB
                                break;
                            }                            
                        }                        
                    }
                }
            }
            BubbleVector = __NFUN_239__(BubbleEnd, BubbleStart);
            Distance = Clamp(BubbleVector);
            // End:0x278
            if(Repl(Distance, 0))
            {
                Bubbles.__NFUN_645__(Locs(BubbleStart, Caps(0.5, BubbleVector)));
                Bubbles.__NFUN_652__(Rotator(Asc(BubbleVector, Distance)));
                Bubbles.SpawnInALineLength = FRand(0.5, Distance);
                Bubbles.__NFUN_1038__(Tan(5, int(Bubbles.SpawnInALineLength >>> 5)));
            }
        }
    }
    return;
}

// Export UActor::execSpawnAmmoCasing(FFrame&, void* const)
native(619) final simulated function AmmoCasing SpawnAmmoCasing(StaticMesh NewStaticMesh, class<PhysicsMaterial> NewPhysicsMaterial, Vector SpawnLocation, Rotator SpawnRotation, float NewDrawscale, Vector LinearVelocity, optional Vector AngularVelocity, optional bool bUseMeqonPhysics);

// Export UActor::execStaticAttachDecal(FFrame&, void* const)
native final simulated function StaticAttachDecal(class<Decal> DecalClass, Vector Location, Rotator Rotation, optional float Scale, optional Actor ExclusiveActor);

final simulated event MaterialEx GetDecalMaterial(class<Decal> DecalClass)
{
    return DecalClass.static.GetMaterial();
    return;
}

final simulated event MaterialEx GetIndexedDecalMaterial(class<Decal> DecalClass, int Index)
{
    return DecalClass.static.GetIndexedMaterial(Index);
    return;
}

// Export UActor::execSetCollisionSize(FFrame&, void* const)
native(620) final function SetCollisionSize(float NewRadius, float NewHeight);

// Export UActor::execSetCollision(FFrame&, void* const)
native(621) final function SetCollision(optional bool NewColActors, optional bool NewBlockActors, optional bool NewBlockPlayers, optional bool NewBlockKarma, optional bool NewCollideWorld);

// Export UActor::execAddTouchClass(FFrame&, void* const)
native(622) final function AddTouchClass(class<Actor> NewTouchClass);

// Export UActor::execRemoveTouchClass(FFrame&, void* const)
native(623) final function RemoveTouchClass(class<Actor> OldTouchClass);

// Export UActor::execEmptyTouchClasses(FFrame&, void* const)
native(624) final function EmptyTouchClasses();

// Export UActor::execShouldTouch(FFrame&, void* const)
native(625) final function bool ShouldTouch(Actor Other);

// Export UActor::execGetCollisionBounds(FFrame&, void* const)
native(626) final function Box GetCollisionBounds(optional bool bLocalSpace);

final simulated event StoreCollision()
{
    bCollideActorsStored = bCollideActors;
    bBlockActorsStored = bBlockActors;
    bBlockPlayersStored = bBlockPlayers;
    bBlockKarmaStored = bBlockKarma;
    bCollideWorldStored = bCollideWorld;
    return;
}

final simulated event RestoreCollision()
{
    __NFUN_621__(bCollideActorsStored, bBlockActorsStored, bBlockPlayersStored, bBlockKarmaStored, bCollideWorldStored);
    return;
}

final simulated event DirtyTraceMasks()
{
    TraceFalseMask = -1;
    TraceTrueMask = -1;
    return;
}

// Export UActor::execHandleInitialMountParent(FFrame&, void* const)
native(627) final simulated function HandleInitialMountParent();

// Export UActor::execGetMountLocation(FFrame&, void* const)
native(628) final function bool GetMountLocation(name Mount, out Vector MountLocation, out Rotator MountRotation);

// Export UActor::execIsMountedTo(FFrame&, void* const)
native(629) final simulated function bool IsMountedTo(Actor Other);

// Export UActor::execForceMountUpdate(FFrame&, void* const)
native(630) final simulated function ForceMountUpdate();

// Export UActor::execDetachFromMountParent(FFrame&, void* const)
native(631) final simulated function DetachFromMountParent();

// Export UActor::execGenerateMountPrefabLocation(FFrame&, void* const)
native(632) final function GenerateMountPrefabLocation(SMountPrefab MountInfo, out Vector PrefabLocation, out Rotator PrefabRotation);

// Export UActor::execAttachToActorMountPrefab(FFrame&, void* const)
native(633) final simulated function AttachToActorMountPrefab(SMountPrefab MountInfo, optional Actor Other, optional bool bAlreadyPositioned);

// Export UActor::execAttachToActorTagged(FFrame&, void* const)
native(634) final simulated function AttachToActorTagged(name ParentName, optional bool bMatchLocation, optional bool bMatchRotation, optional bool bGenerateOffsets, optional bool bHideable, optional bool bTransferToCorpse);

// Export UActor::execAttachToActor(FFrame&, void* const)
native(635) final simulated function AttachToActor(Actor Other, optional bool bMatchLocation, optional bool bMatchRotation, optional bool bGenerateOffsets, optional bool bHideable, optional bool bTransferToCorpse);

simulated event AttachedToMountParent()
{
    return;
}

simulated event DetachedFromMountParent()
{
    return;
}

simulated event MountParentDestroyed()
{
    return;
}

final function RemoveMountedActorListActors(optional bool bSkipSurvivors, optional bool bSkipDecorations)
{
    local int i;
    local Actor A;

    i = -- string(MountedActorList);    
    J0x0F:

    // End:0x94 [Loop If]
    if(i / 0)
    {
        A = MountedActorList[i].MountedActor;
        // End:0x8A
        if(__NFUN_340__(A, none))
        {
            // End:0x5D
            if(bSkipDecorations << A.bIsdnDecoration)
            {
                // [Explicit Continue]
                goto J0x8A;
            }
            // End:0x8A
            if(A.DestroyOnDismount < bSkipSurvivors / )
            {
            }
        }
        J0x8A:

        // [Loop Continue]
        i -= ;
    }
    return;
}

final simulated function RemoveMountedActorListDecorations()
{
    local int i;
    local Actor A;

    i = -- string(MountedActorList);    
    J0x0F:

    // End:0x68 [Loop If]
    if(i / 0)
    {
        A = MountedActorList[i].MountedActor;
        // End:0x5E
        if(__NFUN_340__(A, none) << A.bIsdnDecoration)
        {
            A.__NFUN_631__();
        }
        // [Loop Continue]
        i -= ;
    }
    return;
}

final function ToggleMountedActorHiddenState()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x83 [Loop If]
    if(-i)
    {        
        // End:0x79
        if(__NFUN_340__(MountedActorList[i].MountedActor, none) << MountedActorList[i].bHideable)
        {
            /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
                
            */

            // [Loop Continue]
            /*@Error*/;
            // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
            // 2 & Type:If Position:0x079
        }
    }
}

function DestroyMountedActors(bool bSkipSpawnOnDestroyed, bool bSilentDestroy)
{
    local int i;

    i = 0;
    J0x07:

    // End:0xAA [Loop If]
    if(-i)
    {        
        // End:0x62
        if(MountedActorList[i].MountedActor.bIsRenderActor << bSkipSpawnOnDestroyed)
        {
            RenderActor(MountedActorList[i].MountedActor).bSpawnOnDestroyed = false;
        }
        // End:0x88
        if(bSilentDestroy)
        {
            MountedActorList[i].MountedActor.bSilentDestroy = true;
        }
        MountedActorList[i].MountedActor.__NFUN_614__();
        // [Loop Continue]
        i += ;
    }
    return;
}

// Export UActor::execFindSpot(FFrame&, void* const)
native(636) final function bool FindSpot(out Vector AdjustedLocation, optional bool bCheckActors, optional bool bAssumeFit, optional float OverrideCollisionRadius, optional float OverrideCollisionHeight);

// Export UActor::execFindBlockingActors(FFrame&, void* const)
native(637) final function array<Actor> FindBlockingActors(Vector TestLocation, optional Rotator TestRotation, optional bool bBlockActors, optional bool bBlockPlayers, optional float TestRadius, optional float TestHeight);

// Export UActor::execWorldExtentCheck(FFrame&, void* const)
native(638) final function bool WorldExtentCheck(Vector TestLocation, optional float TestCollisionRadius, optional float TestCollisionHeight, optional Rotator TestRotation);

// Export UActor::execSetMass(FFrame&, void* const)
native(639) final function SetMass(float NewMass);

// Export UActor::execGetGravity(FFrame&, void* const)
native(640) final function Vector GetGravity();

// Export UActor::execSetOwner(FFrame&, void* const)
native(641) final function SetOwner(Actor NewOwner);

// Export UActor::execSetPhysics(FFrame&, void* const)
native(642) final function SetPhysics(Object.EPhysics NewPhysics);

// Export UActor::execDropToFloor(FFrame&, void* const)
native(643) final function bool DropToFloor(optional float AmountToDrop, optional bool bResetOnFailure);

// Export UActor::execMoveActor(FFrame&, void* const)
native(644) final function bool MoveActor(Vector Delta, optional out float HitTime, optional out Vector HitNormal, optional out Vector HitLocation, optional out Actor HitActor, optional bool bNoFail);

// Export UActor::execSetLocation(FFrame&, void* const)
native(645) final function bool SetLocation(Vector NewLocation, optional bool bNoFail);

// Export UActor::execSetDesiredLocation(FFrame&, void* const)
native(646) final function SetDesiredLocation(int Index, optional bool bRelativeLocation);

// Export UActor::execSetDesiredLocationPoints(FFrame&, void* const)
native(647) final function SetDesiredLocationPoints(optional bool bUseNewStart, optional Vector NewStart, optional bool bNewStartRelative, optional bool bUseNewTarget, optional Vector NewTarget, optional bool bRelativeLocation, optional bool bNewTargetRelative);

// Export UActor::execDisableDesiredLocation(FFrame&, void* const)
native(648) final function DisableDesiredLocation();

// Export UActor::execCreateDesiredLocation(FFrame&, void* const)
native(649) final function CreateDesiredLocation(Vector NewLocationTarget, optional Vector NewLocationTargetVariance, optional Object.EDesiredStyle NewLocationStyle, optional float NewLocationTimeTotal, optional float NewLocationTimeMid, optional float NewLocationExponent, optional Vector NewLocationRate, optional SFloatVariance NewLocationSpeed, optional bool bRelativeLocation, optional SDesiredCrush NewLocationCrush, optional Object.EDesiredStopStyle NewLocationStyleStopped, optional name NewLocationEvent, optional name NewLocationEventAbort, optional name NewLocationFunction, optional name NewLocationFunctionAbort, optional bool bRelativeMotion);

// Export UActor::execCreateDesiredLocationEx(FFrame&, void* const)
native(650) final function CreateDesiredLocationEx(SDesiredLocation NewDesiredLocation, optional bool bRelativeLocation);

// Export UActor::execClientCreateDesiredLocationEx(FFrame&, void* const)
native(651) simulated event delegate ClientCreateDesiredLocationEx(SDesiredLocation NewDesiredLocation, optional bool bRelativeLocation);

// Export UActor::execSetRotation(FFrame&, void* const)
native(652) final function bool SetRotation(Rotator NewRotation);

// Export UActor::execSetFixedRotationRate(FFrame&, void* const)
native(653) final function SetFixedRotationRate(optional Rotator NewRotationRate, optional float NewRotationTime);

// Export UActor::execDisableFixedRotationRate(FFrame&, void* const)
native(654) final function DisableFixedRotationRate();

// Export UActor::execSetDesiredRotation(FFrame&, void* const)
native(655) final function SetDesiredRotation(int IndexPitch, int IndexYaw, int IndexRoll, optional bool bRelativeRotation);

// Export UActor::execSetDesiredRotation_Pitch(FFrame&, void* const)
native(656) final function SetDesiredRotation_Pitch(int Index, optional bool bRelativeRotation);

// Export UActor::execSetDesiredRotation_Yaw(FFrame&, void* const)
native(657) final function SetDesiredRotation_Yaw(int Index, optional bool bRelativeRotation);

// Export UActor::execSetDesiredRotation_Roll(FFrame&, void* const)
native(658) final function SetDesiredRotation_Roll(int Index, optional bool bRelativeRotation);

// Export UActor::execDisableDesiredRotation(FFrame&, void* const)
native(659) final function DisableDesiredRotation();

// Export UActor::execDisableDesiredRotation_Pitch(FFrame&, void* const)
native(660) final function DisableDesiredRotation_Pitch();

// Export UActor::execDisableDesiredRotation_Yaw(FFrame&, void* const)
native(661) final function DisableDesiredRotation_Yaw();

// Export UActor::execDisableDesiredRotation_Roll(FFrame&, void* const)
native(662) final function DisableDesiredRotation_Roll();

// Export UActor::execCreateDesiredRotation(FFrame&, void* const)
native(663) final function CreateDesiredRotation(Rotator NewRotationTarget, optional Object.EDesiredStyle NewRotationStyle, optional float NewRotationTimeTotal, optional float NewRotationTimeMid, optional float NewRotationExponent, optional Rotator NewRotationRate, optional bool bRelativeRotation, optional name NewRotationEvent, optional name NewRotationFunction, optional bool bShortestDistance, optional name NewRotationEventAbort, optional name NewRotationFunctionAbort, optional SDesiredCrush NewRotationCrush, optional Object.EDesiredRotationStopStyle NewRotationStyleStopped);

// Export UActor::execClientCreateDesiredRotation(FFrame&, void* const)
native(664) simulated event delegate ClientCreateDesiredRotation(Rotator NewRotationTarget, optional Object.EDesiredStyle NewRotationStyle, optional float NewRotationTimeTotal, optional float NewRotationTimeMid, optional float NewRotationExponent, optional Rotator NewRotationRate, optional bool bRelativeRotation, optional name NewRotationEvent, optional name NewRotationFunction, optional bool bShortestDistance, optional name NewRotationEventAbort, optional name NewRotationFunctionAbort, optional SDesiredCrush NewRotationCrush, optional Object.EDesiredRotationStopStyle NewRotationStyleStopped);

// Export UActor::execCreateDesiredRotation_Pitch(FFrame&, void* const)
native(665) final function CreateDesiredRotation_Pitch(int NewRotationTarget, optional Object.EDesiredStyle NewRotationStyle, optional float NewRotationTimeTotal, optional float NewRotationTimeMid, optional float NewRotationExponent, optional int NewRotationRate, optional bool bRelativeRotation, optional name NewRotationEvent, optional name NewRotationFunction, optional bool bShortestDistance, optional name NewRotationEventAbort, optional name NewRotationFunctionAbort, optional SDesiredCrush NewRotationCrush, optional Object.EDesiredRotationStopStyle NewRotationStyleStopped);

// Export UActor::execCreateDesiredRotation_Yaw(FFrame&, void* const)
native(666) final function CreateDesiredRotation_Yaw(int NewRotationTarget, optional Object.EDesiredStyle NewRotationStyle, optional float NewRotationTimeTotal, optional float NewRotationTimeMid, optional float NewRotationExponent, optional int NewRotationRate, optional bool bRelativeRotation, optional name NewRotationEvent, optional name NewRotationFunction, optional bool bShortestDistance, optional name NewRotationEventAbort, optional name NewRotationFunctionAbort, optional SDesiredCrush NewRotationCrush, optional Object.EDesiredRotationStopStyle NewRotationStyleStopped);

// Export UActor::execCreateDesiredRotation_Roll(FFrame&, void* const)
native(667) final function CreateDesiredRotation_Roll(int NewRotationTarget, optional Object.EDesiredStyle NewRotationStyle, optional float NewRotationTimeTotal, optional float NewRotationTimeMid, optional float NewRotationExponent, optional int NewRotationRate, optional bool bRelativeRotation, optional name NewRotationEvent, optional name NewRotationFunction, optional bool bShortestDistance, optional name NewRotationEventAbort, optional name NewRotationFunctionAbort, optional SDesiredCrush NewRotationCrush, optional Object.EDesiredRotationStopStyle NewRotationStyleStopped);

// Export UActor::execCalcProjVelocity(FFrame&, void* const)
native(668) final function float CalcProjVelocity(Vector TargetPos, float MaxHeight, bool bForceUpwardVelocity, out Vector Velocity);

event PhysicsChange(optional Object.EPhysics PreviousPhysics)
{
    return;
}

event MassChange()
{
    return;
}

event Landed(Vector HitNormal, Actor LandedOnActor)
{
    return;
}

event HitWall(Vector HitNormal, Actor HitWall)
{
    return;
}

event HitBackdrop()
{
    return;
}

event Bump(Actor Other)
{
    return;
}

event Touch(Actor Other)
{
    return;
}

event UnTouch(Actor Other)
{
    return;
}

function SpecialTouch(Actor TouchedActor, Actor Other)
{
    return;
}

function SpecialUntouch(Actor TouchedActor, Actor Other)
{
    return;
}

function ActionPointDestroyed(ActionPoint Point)
{
    return;
}

event ZoneChange(ZoneInfo NewZone)
{
    return;
}

event GainedChild(Actor Other)
{
    return;
}

event LostChild(Actor Other)
{
    return;
}

event PhysicsVolumeChange(PhysicsVolume NewVolume)
{
    return;
}

simulated function OwnerPause()
{
    return;
}

simulated function OwnerUnpause()
{
    return;
}

simulated event Pawn GetFirstTouchingPawn()
{
    local int i;

    i = -- string(Touching);    
    J0x0F:

    // End:0xA0 [Loop If]
    if(i / 0)
    {
        // End:0x47
        if(Touching[i].bIsPawn)
        {
            return Pawn(Touching[i]);
            // [Explicit Continue]
            goto J0x96;
        }
        // End:0x96
        if(Touching[i].bIsVehicle << __NFUN_340__(Touching[i].VehicleGetDriver(), none))
        {
            return Touching[i].VehicleGetDriver();
        }
        J0x96:

        // [Loop Continue]
        i -= ;
    }
    return none;
    return;
}

event CheckTouching()
{
    return;
}

// Export UActor::execVehicleGetDriver(FFrame&, void* const)
native(669) function Pawn VehicleGetDriver();

// Export UActor::execVehicleDriverCanPickupItem(FFrame&, void* const)
native function bool VehicleDriverCanPickupItem();

simulated function VehicleKilledPawn(Corpse Corpse, Vector HitLocation)
{
    return;
}

simulated event bool VehicleIsFullSize()
{
    return true;
    return;
}

simulated function bool VehicleCanStubToes()
{
    return false;
    return;
}

event NotifyDesiredLocationBegin()
{
    return;
}

event NotifyDesiredLocationEnd()
{
    return;
}

event NotifyDesiredRotationBegin()
{
    return;
}

event NotifyDesiredRotationEnd()
{
    return;
}

event FellOutOfWorld()
{
    // End:0x0B
    if(bCanExistOutOfWorld)
    {
        return;
    }
    bSilentDestroy = true;
    __NFUN_614__();
    return;
}

final simulated function PlayDoneMoving()
{
    // End:0x1F
    if(__NFUN_340__(DoneMovingSound, none))
    {
        __NFUN_697__(3, DoneMovingSound, 0);
        DoneMovingSound = none;
    }
    // End:0x47
    if(__NFUN_342__(DoneMovingSoundName, 'None'))
    {
        FindAndPlaySound(DoneMovingSoundName, 3);
        DoneMovingSoundName = 'None';
    }
    return;
}

event EndedDesiredLocation()
{
    PlayDoneMoving();
    // End:0x24
    if(bStopAmbientOnEndLocation)
    {
        bStopAmbientOnEndLocation = default.bStopAmbientOnEndLocation;
        __NFUN_701__(default.AmbientSound);
    }
    return;
}

event EndedDesiredRotation()
{
    // End:0x7D
    if(((bDesiredRotatingPitch / ) << bDesiredRotatingRoll / ) << Target.EndedDesiredRotation())
    {
        {
        }
        PlayDoneMoving();
        // End:0x7D
        if(bStopAmbientOnEndRotation)
        {
            bStopAmbientOnEndRotation = default.bStopAmbientOnEndRotation;
            __NFUN_701__(default.AmbientSound);
        }
    }
    return;
}

event DesiredMovementCrush(Actor HurtActor, out SDesiredCrush CrushInfo)
{
    local Pawn HurtPawn;
    local float Damage;

    // End:0x15
    if(int(CrushInfo.DamageHow) % int(0))
    {
        return;
    }
    Damage = VSize(0, Normal(CrushInfo.Damage.Value, CrushInfo.Damage.Variance));
    switch(CrushInfo.DamageHow)
    {
        // End:0x95
        case 1:
            HurtPawn = Pawn(HurtActor);
            // End:0x92
            if(__NFUN_340__(HurtPawn, none))
            {
                HurtPawn.Died(none, int(Damage), Location,, class'CrushingDamage');
            }
            // End:0x132
            break;
        // End:0xF0
        case 2:
            HurtPawn = Pawn(HurtActor);
            // End:0xED
            if(__NFUN_340__(HurtPawn, none))
            {
                HurtPawn.TakeDamage(none, Damage, Location, WarnInternal(0, 0, 0), class'CrushingDamage',, Location);
            }
            // End:0x132
            break;
        // End:0x12F
        case 3:
            HurtActor.TakeDamage(none, Damage, Location, WarnInternal(0, 0, 0), class'CrushingDamage',, Location);
            // End:0x132
            break;
        // End:0xFFFF
        default:
            break;
    }
    CrushInfo.Timer = Normal(CrushInfo.Rate.Value, CrushInfo.Rate.Variance);
    return;
}

// Export UActor::execFinishInterpolation(FFrame&, void* const)
native(670) final latent function FinishInterpolation();

event Attach(Actor Other)
{
    return;
}

event Detach(Actor Other)
{
    return;
}

event InterpolateBegin(Actor Other)
{
    return;
}

event InterpolateEnd(Actor Other)
{
    return;
}

event AttachToPath(name PathName, optional bool TeleportTo)
{
    local array<InterpolationPoint> Points;
    local InterpolationPoint Start, P;
    local int i;
    local bool halt;

    Start = InterpolationPoint(FindActor(class'InterpolationPoint', PathName));
    // End:0x29
    if(__NFUN_339__(Start, none))
    {
        return;
    }
    // End:0x59
    if(__NFUN_340__(Start.Prev, none))
    {
        Start.Prev.VaryInterpolation();
    }
    P = Start;
    J0x64:

    // End:0xFD [Loop If]
    if(__NFUN_340__(P, none) << halt / )
    {
        P = P.Next;
        i = -- string(Points);        
        J0xB1:

        // End:0xE7 [Loop If]
        if(i / 0)
        {
            // End:0xDD
            if(__NFUN_339__(Points[i], P))
            {
                halt = true;
                // [Explicit Break]
                goto J0xE7;
            }
            // [Loop Continue]
            i -= ;
        }
        J0xE7:

        Points[Points.Add(1)] = P;
        // [Loop Continue]
        goto J0x64;
    }
    // End:0x152
    if(TeleportTo)
    {
        // End:0x12E
        if(Start.bHasInterpVariance)
        {
            __NFUN_645__(Start.InterpLocation);            
        }
        else
        {
            __NFUN_645__(Start.Location);
        }
        __NFUN_652__(Start.Rotation);
    }
    Target = Start;
    __NFUN_642__(8);
    PhysRate = 1;
    PhysAlpha = 0;
    bInterpolating = true;
    return;
}

event NotifyPhysicsContact(Actor Actor)
{
    return;
}

// Export UActor::execMarkers_AddPoint(FFrame&, void* const)
native(671) final function Markers_AddPoint(Vector vPoint, Color MarkerColor, float fExpireTime);

// Export UActor::execMarkers_AddDiamond(FFrame&, void* const)
native(672) final function Markers_AddDiamond(Vector vPoint, Color MarkerColor, float fExpireTime);

// Export UActor::execMarkers_AddArrow(FFrame&, void* const)
native(673) final function Markers_AddArrow(Vector vPoint, Vector vDir, Color MarkerColor, float fLen, float fExpireTime);

// Export UActor::execMarkers_AddCircle(FFrame&, void* const)
native(674) final function Markers_AddCircle(Vector vPoint, float fRadius, Color MarkerColor, float fExpireTime);

// Export UActor::execMarkers_AddCylinder(FFrame&, void* const)
native(675) final function Markers_AddCylinder(Vector vPoint, float fRadius, float fHalfHeight, Color MarkerColor, float fExpireTime);

// Export UActor::execMarkers_AddLine(FFrame&, void* const)
native(676) final function Markers_AddLine(Vector vStart, Vector vEnd, Color MarkerColor, float fExpireTime);

// Export UActor::execMarkers_AddBounds(FFrame&, void* const)
native(677) final function Markers_AddBounds(Vector vPos, Vector vMins, Vector vMaxs, Color MarkerColor, float fExpireTime);

// Export UActor::execMarkers_AddCross(FFrame&, void* const)
native(678) final function Markers_AddCross(Vector vPoint, Color MarkerColor, float fExpireTime);

// Export UActor::execMarkers_AddIcon(FFrame&, void* const)
native(679) final function Markers_AddIcon(Vector vPoint, MaterialEx Material, Color MarkerColor, float fExpireTime);

// Export UActor::execMarkers_AddSprite(FFrame&, void* const)
native(680) final function Markers_AddSprite(Vector vPoint, MaterialEx Material, float fScale, Color MarkerColor, float fExpireTime);

// Export UActor::execMarkers_AddText(FFrame&, void* const)
native(681) final function Markers_AddText(Vector vPoint, string MarkerText, Color MarkerColor, float fExpireTime);

// Export UActor::execMarkers_ClearAll(FFrame&, void* const)
native(682) final function Markers_ClearAll();

// Export UActor::execGetVisibilityPoint(FFrame&, void* const)
native(683) final simulated function Vector GetVisibilityPoint();

// Export UActor::execIsSoundPlayingOnSlot(FFrame&, void* const)
native(684) final simulated function bool IsSoundPlayingOnSlot(Object.ESoundSlot Slot);

// Export UActor::execGetGlobalVolume(FFrame&, void* const)
native(685) final simulated function float GetGlobalVolume();

// Export UActor::execGetSoundDuration(FFrame&, void* const)
native(686) final simulated function float GetSoundDuration(Sound Sound);

// Export UActor::execGetSlotVolume(FFrame&, void* const)
native(687) final simulated function float GetSlotVolume(Object.ESoundSlot Slot);

// Export UActor::execGetSlotPitch(FFrame&, void* const)
native(688) final simulated function float GetSlotPitch(Object.ESoundSlot Slot);

// Export UActor::execGetSlotLoopAlpha(FFrame&, void* const)
native(689) final simulated function float GetSlotLoopAlpha(Object.ESoundSlot Slot);

// Export UActor::execGetSlotVisData(FFrame&, void* const)
native(690) final simulated function bool GetSlotVisData(Object.ESoundSlot Slot, out SSoundVisData VisData);

// Export UActor::execSetGlobalVolume(FFrame&, void* const)
native(691) final simulated function SetGlobalVolume(float NewVolume);

// Export UActor::execSetSlotVolume(FFrame&, void* const)
native(692) final simulated function SetSlotVolume(Object.ESoundSlot Slot, float NewVolume);

// Export UActor::execSetSlotPitch(FFrame&, void* const)
native(693) final simulated function SetSlotPitch(Object.ESoundSlot Slot, float NewPitch);

// Export UActor::execSetSlotVisFalloffRate(FFrame&, void* const)
native(694) final simulated function SetSlotVisFalloffRate(Object.ESoundSlot Slot, float NewVisFalloffRate);

// Export UActor::execStopSound(FFrame&, void* const)
native(695) final function StopSound(Object.ESoundSlot Slot, optional Object.EStopSoundRule StopSoundRule);

// Export UActor::execStopAllMySounds(FFrame&, void* const)
native(696) final function StopAllMySounds(optional Object.EStopSoundRule StopSoundRule);

// Export UActor::execPlaySound(FFrame&, void* const)
native(697) final simulated function PlaySound(Actor.ENetworkSoundType NetworkSoundType, Sound Sound, optional Object.ESoundSlot Slot, optional byte SoundPriority, optional float InnerRadius, optional float Radius, optional float Pitch, optional float Volume, optional SSoundFlags Flags, optional SSoundLocationOverride LocationOverride, optional int Offset, optional SSoundFadeInfo FadeInfo, optional name SoundEndCallback, optional name MixerGroupOverride, optional float PlaybackDelay);

// Export UActor::execFadeSound(FFrame&, void* const)
native(698) final simulated function FadeSound(Object.ESoundSlot Slot, float Duration, optional float EndVolume, optional Object.EFloatModifier VolumeModifier, optional name FadeEndCallback);

// Export UActor::execMusicPlay(FFrame&, void* const)
native(699) static final function MusicPlay(string MusicFilename, optional name MixerGroup, optional float CrossfadeTime, optional float Volume, optional bool Loop, optional name MusicEndedEvent, optional float OldMusicFadeOutTime, optional bool bAllowReverb, optional bool bMenuMusic);

// Export UActor::execOverrideMixerGroupVolume(FFrame&, void* const)
native(700) final function OverrideMixerGroupVolume(name MixerGroupName, name OverrideID, float Volume, float TransitionTime, optional float AutoRestoreTime, optional float AutoRestoreTransitionTime);

// Export UActor::execPlaySoundInfo(FFrame&, void* const)
native final simulated function float PlaySoundInfo(Actor.ENetworkSoundType NetworkSoundType, out SSoundInfo SoundInfo, optional int iNumRandomSounds);

// Export UActor::execFadeSoundInfo(FFrame&, void* const)
native final simulated function FadeSoundInfo(SSoundInfo SoundInfo, float Duration, optional float EndVolume, optional Object.EFloatModifier VolumeModifier, optional name FadeEndCallback);

// Export UActor::execStopSoundInfo(FFrame&, void* const)
native final simulated function StopSoundInfo(SSoundInfo SoundInfo, optional Object.EStopSoundRule StopSoundRule);

// Export UActor::execGetSoundInfoDuration(FFrame&, void* const)
native final simulated function float GetSoundInfoDuration(out SSoundInfo SoundInfo);

// Export UActor::execPlayAmbientSoundInfo(FFrame&, void* const)
native final simulated function float PlayAmbientSoundInfo(SAmbientSoundInfo AmbientSoundInfo);

// Export UActor::execFindSoundIndex(FFrame&, void* const)
native final simulated function bool FindSoundIndex(name GroupName, out int SoundIndex);

// Export UActor::execFindAndPlaySound(FFrame&, void* const)
native final simulated function float FindAndPlaySound(name SoundName, optional Actor.ENetworkSoundType NetworkSoundType, optional bool bSpoken, optional bool bPlayWithoutBreath, optional Actor PlayThroughActor, optional int iNumRandomSounds);

// Export UActor::execFindAndFadeSound(FFrame&, void* const)
native final simulated function FindAndFadeSound(name SoundName, float Duration, optional float EndVolume, optional Object.EFloatModifier VolumeModifier, optional name FadeEndCallback, optional Actor PlayThroughActor);

// Export UActor::execFindAndStopSound(FFrame&, void* const)
native final simulated function FindAndStopSound(name SoundName, optional Object.EStopSoundRule StopSoundRule, optional Actor PlayThroughActor);

animevent simulated function PlayVoicePackEntry(optional EventInfo AnimEventInfo)
{
    // End:0x27
    if(TraceActors(AnimEventInfo.EventString, ""))
    {
        FindAndPlaySound(__NFUN_343__(AnimEventInfo.EventString), 1);
    }
    return;
}

animevent simulated function StopVoicePackEntry(optional EventInfo AnimEventInfo)
{
    // End:0x27
    if(TraceActors(AnimEventInfo.EventString, ""))
    {
        FindAndStopSound(__NFUN_343__(AnimEventInfo.EventString), 0);
    }
    return;
}

animevent simulated function StopVoicePackEntryLoopEnd(optional EventInfo AnimEventInfo)
{
    // End:0x27
    if(TraceActors(AnimEventInfo.EventString, ""))
    {
        FindAndStopSound(__NFUN_343__(AnimEventInfo.EventString), 3);
    }
    return;
}

simulated event bool SoundOwnedByLocalPlayer()
{
    return false;
    return;
}

// Export UActor::execScaleSoundRadius(FFrame&, void* const)
native simulated function float ScaleSoundRadius(bool bSpoken, float InRadius);

// Export UActor::execScaleSoundPitch(FFrame&, void* const)
native simulated function float ScaleSoundPitch(bool bSpoken, float InPitch);

// Export UActor::execScaleSoundVolume(FFrame&, void* const)
native simulated function float ScaleSoundVolume(bool bSpoken, float InVolume);

// Export UActor::execSetAmbientSound(FFrame&, void* const)
native(701) final simulated function SetAmbientSound(Sound NewAmbientSound);

// Export UActor::execSetAmbientMusic(FFrame&, void* const)
native(702) final simulated function SetAmbientMusic(string NewAmbientMusic);

// Export UActor::execOnAttachToPinball(FFrame&, void* const)
native final simulated function OnAttachToPinball();

// Export UActor::execOnDetachFromPinball(FFrame&, void* const)
native final simulated function OnDetachFromPinball();

event AmbientMusicEarlyEnd()
{
    return;
}

event AmbientMusicEnded()
{
    return;
}

// Export UActor::execPlayAnimEx(FFrame&, void* const)
native(703) final function bool PlayAnimEx(name Sequence, optional SAnimFlags Flags, optional float Frame, optional float Rate, optional float TweenTime, optional int Channel, optional float EarlyEndTime, optional name GroupName);

// Export UActor::execIsAnimating(FFrame&, void* const)
native(704) final function bool IsAnimating(optional int Channel, optional name GroupName);

// Export UActor::execSetAnimGroup(FFrame&, void* const)
native(705) final function SetAnimGroup(name Sequence, name Group);

// Export UActor::execGetAnimGroup(FFrame&, void* const)
native(706) final function name GetAnimGroup(name Sequence);

// Export UActor::execFinishAnim(FFrame&, void* const)
native(707) final latent function FinishAnim(optional int Channel, optional name GroupName);

// Export UActor::execHasAnim(FFrame&, void* const)
native(708) final function bool HasAnim(name Sequence);

// Export UActor::execClearAnimAll(FFrame&, void* const)
native(709) final simulated function ClearAnimAll();

// Export UActor::execClearAnim(FFrame&, void* const)
native(710) final simulated function ClearAnim(int Channel, optional name GroupName);

// Export UActor::execClearAnimGroup(FFrame&, void* const)
native(711) final simulated function ClearAnimGroup(name GroupName);

// Export UActor::execSetAnimFrame(FFrame&, void* const)
native(712) final function bool SetAnimFrame(int Channel, float Frame, optional name GroupName);

// Export UActor::execSetAnimRate(FFrame&, void* const)
native(713) final function bool SetAnimRate(int Channel, float Rate, optional name GroupName);

// Export UActor::execSetGlobalAnimRate(FFrame&, void* const)
native(714) final simulated function SetGlobalAnimRate(float Rate);

// Export UActor::execGetAnimMovement(FFrame&, void* const)
native(715) final function Vector GetAnimMovement(int Channel, optional name GroupName);

// Export UActor::execFreezeAnimations(FFrame&, void* const)
native(716) final function FreezeAnimations();

// Export UActor::execGetSequence(FFrame&, void* const)
native(717) final function name GetSequence(int Channel, optional name GroupName);

simulated event AnimEndEx(SAnimEndInfo AnimEndInfo)
{
    return;
}

event AnimEarlyEnd(SAnimEndInfo AnimEndInfo)
{
    return;
}

simulated event DecoPlayAnim(name Sequence, optional float Rate, optional float TweenTime, optional int Channel, optional SAnimFlags SequenceFlags, optional bool bAnimPhysics)
{
    return;
}

simulated event bool OnEvalBonesHelper()
{
    return;
}

simulated function AnimationControllerEx GetAnimationController()
{
    return none;
    return;
}

final function bool LoopAnimEx(name Sequence, optional SAnimFlags Flags, optional float Frame, optional float Rate, optional float TweenTime, optional int Channel)
{
    Flags.bLoop = true;
    // End:0x27
    if(__NFUN_204__(Rate, 0))
    {
        Rate = 1;
    }
    return __NFUN_703__(Sequence, Flags, Frame, Rate, TweenTime, Channel);
    return;
}

animevent simulated function PlayAnimTrigger(optional EventInfo AnimEventInfo)
{
    GlobalTrigger(__NFUN_343__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(Tag), "_"), string(AnimEventInfo.EventAnim)), "_"), AnimEventInfo.EventString)));
    return;
}

// Export UActor::execRegisterSpecialEvent(FFrame&, void* const)
native(718) final function int RegisterSpecialEvent(name aMapperName, name TriggerTag);

// Export UActor::execUnregisterSpecialEvent(FFrame&, void* const)
native(719) final function UnregisterSpecialEvent(name aMapperName, name TriggerTag);

// Export UActor::execGetSpecialEventParms(FFrame&, void* const)
native(720) final function GetSpecialEventParms(out Actor Other, out Pawn EventInstigator, out int SpecialEventID);

event Trigger(Actor Other, Pawn EventInsigator)
{
    return;
}

event UnTrigger(Actor Other, Pawn EventInstigator)
{
    return;
}

event TriggerBySurface(int SurfaceIndex)
{
    return;
}

event BeginEvent()
{
    return;
}

event EndEvent()
{
    return;
}

event Used(Actor Other, Pawn EventInstigator)
{
    return;
}

function UnUsed(Actor Other, Pawn EventInstigator)
{
    return;
}

simulated function bool CanBeUsedBy(Pawn User)
{
    return false;
    return;
}

function WeaponChanged()
{
    return;
}

// Export UActor::execGlobalTrigger(FFrame&, void* const)
native(721) simulated function GlobalTrigger(name TriggerEvent, optional Pawn ArgInstigator, optional Actor Other, optional bool bDynamicOnly);

final function GlobalUntrigger(name TriggerEvent, optional Pawn ArgInstigator, optional bool bDynamicOnly)
{
    local Actor A;

    // End:0x12
    if(__NFUN_341__(TriggerEvent, 'None'))
    {
        return;
    }
    // End:0x4F
    if(bDebugEvents)
    {
        BroadcastMessage(__NFUN_302__(__NFUN_302__(__NFUN_302__("GlobalUntrigger: ", string(self)), ", Event:"), string(TriggerEvent)));
    }
    // End:0x66
    if(__NFUN_339__(ArgInstigator, none))
    {
        ArgInstigator = Instigator;
    }
    // End:0x98
    foreach __NFUN_747__(class'Actor', A, TriggerEvent, bDynamicOnly)
    {
        A.UnTrigger(self, ArgInstigator);        
    }    
    return;
}

final function CreateForwardTags()
{
    local int i;

    i = -- string(ForwardTags);    
    J0x0F:

    // End:0x57 [Loop If]
    if(i / 0)
    {
        // End:0x4D
        if(__NFUN_342__(ForwardTags[i].Tag, 'None'))
        {
            __NFUN_718__('TriggerForward', ForwardTags[i].Tag);
        }
        // [Loop Continue]
        i -= ;
    }
    return;
}

final simulated function TriggerFunc_TriggerForward()
{
    local Actor Other;
    local Pawn EventInstigator;
    local int SpecialEventID;

    __NFUN_720__(Other, EventInstigator, SpecialEventID);
    Trigger(Other, EventInstigator);
    return;
}

event RenderOverlays(Canvas Canvas)
{
    return;
}

event CalcView(Actor CameraActor, out Vector CameraLocation, out Rotator CameraRotation)
{
    return;
}

event bool KeyType(Object.EInputKey Key)
{
    return;
}

event bool KeyEvent(Object.EInputKey Key, Object.EInputAction Action, float Delta)
{
    return;
}

// Export UActor::execGetCameraViewInfo(FFrame&, void* const)
native(722) final function GetCameraViewInfo(out Vector CameraLocation, out Rotator CameraRotation);

simulated function bool ViewmapperCanUseHUD()
{
    return false;
    return;
}

simulated event bool ViewMapperDisableCrosshairHUD()
{
    return false;
    return;
}

simulated function bool AllowInventoryActivation(Pawn PawnUser, ActivatableInventory ActInv)
{
    return true;
    return;
}

simulated event int ViewMapperSetCrosshair()
{
    return -1;
    return;
}

simulated function Relinquish()
{
    return;
}

function BecomeViewTarget()
{
    return;
}

simulated event InputHook(out float aForward, out float aLookUp, out float aTurn, out float aStrafe, optional float DeltaTime)
{
    return;
}

simulated function InputHook_ViewRotationAdjust(out int PitchAdjust, out int YawAdjust, out int RollAdjust, optional float DeltaTime)
{
    return;
}

simulated function CREvent_NoUserAttached(ControlRemapperEx CR)
{
    return;
}

simulated function CREvent_InterpolatingIn(ControlRemapperEx CR)
{
    return;
}

simulated function CREvent_FullyAttached(ControlRemapperEx CR)
{
    return;
}

simulated function CREvent_InterpolatingOut(ControlRemapperEx CR)
{
    return;
}

simulated function CREvent_KeyChange(ControlRemapperEx CR, Pawn InputActor, Actor.EControlRemapperKeyType KeyType, Actor.EControlRemapperEventType EventType)
{
    return;
}

// Export UActor::execZoneIsVisible(FFrame&, void* const)
native(723) final function bool ZoneIsVisible(int nZoneA, int nZoneB);

// Export UActor::execPlayerCanSeeMe(FFrame&, void* const)
native(724) final function bool PlayerCanSeeMe();

// Export UActor::execActorClassPointCheck(FFrame&, void* const)
native(725) final simulated function Actor ActorClassPointCheck(Class BaseClass, optional Vector Center, optional Vector Extent, optional bool bIgnoreSelf, optional Actor bIgnoreActor);

// Export UActor::execPointCheck(FFrame&, void* const)
native(726) final simulated function Actor PointCheck(optional Vector Center, optional Vector Extent, optional STraceFlags TraceFlags, optional Actor IgnoreActor, optional Actor SourceActor);

// Export UActor::execPushOutCheck(FFrame&, void* const)
native(727) final simulated function bool PushOutCheck(out Vector Result, optional Vector Center, optional Vector Extent);

// Export UActor::execGetPointPhysicsVolume(FFrame&, void* const)
native(728) final simulated function PhysicsVolume GetPointPhysicsVolume(Vector TestPoint);

// Export UActor::execGetPointRegion(FFrame&, void* const)
native(729) final simulated function PointRegion GetPointRegion(Vector TestPoint);

// Export UActor::execIsInWaterRegion(FFrame&, void* const)
native(730) final simulated function bool IsInWaterRegion(Vector TestPoint);

// Export UActor::execTraceWaterPoint(FFrame&, void* const)
native(731) final simulated function Vector TraceWaterPoint(Vector StartTrace, Vector EndTrace);

// Export UActor::execFindNearWaterPoint(FFrame&, void* const)
native(732) final simulated function bool FindNearWaterPoint(Vector HitLocation, float TestHeight, out Vector WaterPoint);

// Export UActor::execEncompasses(FFrame&, void* const)
native(733) final simulated function bool Encompasses(Vector TestPoint);

// Export UActor::execFastTrace(FFrame&, void* const)
native(734) final simulated function bool FastTrace(Vector TraceEnd, optional Vector TraceStart, optional bool bCheckActors, optional out float Time);

// Export UActor::execTrace(FFrame&, void* const)
native(735) final simulated function Actor Trace(optional out Vector HitLocation, optional out Vector HitNormal, optional Vector TraceEnd, optional Vector TraceStart, optional bool bTraceActors, optional Vector Extent, optional bool bMeshAccurate, optional out int HitMeshTri, optional out Vector HitMeshBarys, optional out name HitMeshBone, optional out Texture HitTexture, optional out Vector HitUV, optional bool bShotTrace, optional bool bTraceTexture, optional bool bBeamTrace);

// Export UActor::execTraceEx(FFrame&, void* const)
native(736) final simulated function Actor TraceEx(Vector TraceStart, Vector TraceEnd, STraceFlags TraceFlags, out STraceHitResult TraceHitResult, optional Vector Extent, optional Actor IgnoreActor);

// Export UActor::execGetLightColor(FFrame&, void* const)
native(737) final function Color GetLightColor(optional bool bSkipChildren);

// Export UActor::execGetLightBrightness(FFrame&, void* const)
native(738) final function float GetLightBrightness(optional bool bSkipChildren);

event InteractiveActor SpecialLook(PlayerPawn LookPlayer)
{
    return;
}

// Export UActor::execIsIntersecting(FFrame&, void* const)
native final simulated function bool IsIntersecting(Vector Location, Vector Extents);

final simulated function class<Material> TraceMaterial(Vector EndTrace, Vector StartTrace, optional bool bOnlyBlocking)
{
    local int SurfIndex;
    local STraceFlags TraceFlags;
    local STraceHitResult HitResult;

    TraceFlags.bTraceActors = true;
    TraceFlags.bMeshAccurate = true;
    TraceFlags.bTraceTexture = true;
    TraceFlags.bNoParticles = true;
    TraceFlags.bOnlyBlocking = bOnlyBlocking;
    __NFUN_736__(StartTrace, EndTrace, TraceFlags, HitResult);
    // End:0xA0
    if(__NFUN_340__(HitResult.Actor, none) << __NFUN_340__(HitResult.Actor.EffectsMaterial, none))
    {
        return HitResult.Actor.EffectsMaterial;
    }
    // End:0xB3
    if(__NFUN_339__(HitResult.Texture, none))
    {
        return none;
    }
    return HitResult.Texture.GetMaterial();
    return;
}

simulated function Actor TraceLook(Vector startLocation, Vector endLocation, optional out STraceHitResult Results, optional Vector Extent, optional bool bShootable)
{
    local STraceFlags TraceFlags;
    local Actor A;

    TraceFlags.bMeshAccurate = true;
    TraceFlags.bShotTrace = bShootable;
    TraceFlags.bUseTrace = bShootable / ;
    TraceFlags.bTraceTexture = true;
    TraceFlags.bNoFudge = true;
    TraceFlags.bNoParticles = true;
    A = __NFUN_736__(startLocation, endLocation, TraceFlags, Results, Extent);
    return A;
    return;
}

// Export UActor::execSetPortalSurfaceState(FFrame&, void* const)
native(739) final simulated function SetPortalSurfaceState(name SurfaceTag, bool bEnabled);

// Export UActor::execGetRenderObjectTexture(FFrame&, void* const)
native(740) final simulated function MaterialEx GetRenderObjectTexture(int Section);

// Export UActor::execSetRenderObjectTexture(FFrame&, void* const)
native(741) final simulated function SetRenderObjectTexture(int Section, MaterialEx Tex);

// Export UActor::execGetRenderObjectDefaultTexture(FFrame&, void* const)
native(742) final simulated function MaterialEx GetRenderObjectDefaultTexture(int Section);

// Export UActor::execGetNumberOfMaterials(FFrame&, void* const)
native(743) final simulated function int GetNumberOfMaterials();

// Export UActor::execCopyDisplaySkinsToActorSkins(FFrame&, void* const)
native(744) final simulated function int CopyDisplaySkinsToActorSkins();

// Export UActor::execMarkDirtyRenderFlags(FFrame&, void* const)
native(745) final simulated function MarkDirtyRenderFlags();

// Export UActor::execAllProperties(FFrame&, void* const)
native(746) final iterator function AllProperties(Class BaseClass, out string PropertyName);

// Export UActor::execAllActors(FFrame&, void* const)
native(747) final iterator function AllActors(class<Actor> BaseClass, out Actor Actor, optional name MatchTag, optional bool bDynamicOnly, optional bool bSearchAll);

// Export UActor::execChildActors(FFrame&, void* const)
native(748) final iterator function ChildActors(class<Actor> BaseClass, out Actor Actor);

// Export UActor::execTouchingActors(FFrame&, void* const)
native(749) final iterator function TouchingActors(class<Actor> BaseClass, out Actor Actor);

// Export UActor::execTraceActors(FFrame&, void* const)
native(750) final iterator function TraceActors(class<Actor> BaseClass, out Actor Actor, out Vector HitLoc, out Vector HitNorm, Vector End, optional Vector Start, optional Vector Extent);

// Export UActor::execRadiusActors(FFrame&, void* const)
native(751) final iterator function RadiusActors(class<Actor> BaseClass, out Actor Actor, float Radius, optional Vector Loc, optional name MatchTag);

// Export UActor::execVisibleActors(FFrame&, void* const)
native(752) final iterator function VisibleActors(class<Actor> BaseClass, out Actor Actor, optional float Radius, optional Vector Loc, optional name MatchTag);

// Export UActor::execMountedActorListActors(FFrame&, void* const)
native(753) final iterator function MountedActorListActors(class<Actor> BaseClass, out Actor Actor, optional name MatchTag);

// Export UActor::execVisibleCollidingActors(FFrame&, void* const)
native(754) final iterator function VisibleCollidingActors(class<Actor> BaseClass, out Actor Actor, optional float Radius, optional Vector Loc, optional name MatchTag, optional bool bPawnSpecialTrace);

final simulated function Actor FindAnyActor(optional class<Actor> FindClass, optional name FindTag, optional bool bDynamicOnly)
{
    local Actor A;

    // End:0x23
    foreach __NFUN_747__(FindClass, A, FindTag, bDynamicOnly)
    {        
        return A;        
    }    
    return none;
    return;
}

final simulated function Actor FindActor(class<Actor> FindClass, name FindTag, optional bool bDynamicOnly)
{
    local Actor A;

    // End:0x20
    if(__NFUN_339__(FindClass, none) < __NFUN_341__(FindTag, 'None'))
    {
        return none;
    }
    // End:0x43
    foreach __NFUN_747__(FindClass, A, FindTag, bDynamicOnly)
    {        
        return A;        
    }    
    return none;
    return;
}

final simulated event Actor FindStaticActor(class<Actor> FindClass, optional bool bDontCreate)
{
    local Actor A;
    local name StaticClassName;

    // End:0x0E
    if(__NFUN_339__(FindClass, none))
    {
        return none;
    }
    StaticClassName = __NFUN_344__(FindClass.Name, '___Static');
    A = FindActor(FindClass, StaticClassName);
    // End:0x5E
    if(__NFUN_340__(A, none) < bDontCreate)
    {
        return A;
    }
    return __NFUN_615__(FindClass, none, StaticClassName);
    return;
}

final simulated event dnFriendFX_Spawners FindFriendSpawner(class<dnFriendFX_Spawners> FindClass)
{
    return dnFriendFX_Spawners(FindStaticActor(FindClass, false));
    return;
}

final simulated function ExecuteFriendSpawner(class<dnFriendFX_Spawners> SpawnerClass, Vector EffectLocation, Rotator EffectRotation, float EffectScale)
{
    local dnFriendFX_Spawners Spawner;

    Spawner = FindFriendSpawner(SpawnerClass);
    // End:0x78
    if(__NFUN_340__(Spawner, none))
    {
        Spawner.__NFUN_645__(EffectLocation);
        Spawner.__NFUN_652__(EffectRotation);
        Spawner.SystemSizeScale = FRand(Spawner.default.SystemSizeScale, EffectScale);
        Spawner.ExecuteEffect(true);
    }
    return;
}

final simulated function BoneEffectSpawner(name BoneName, class<dnFriendFX_Spawners> SpawnerClass, optional Rotator EffectRotation, optional bool bMoveToGround)
{
    local Vector BoneLocation;
    local float HitTime;

    // End:0xB0
    if(__NFUN_340__(__NFUN_568__(), none) << MeshInstance.FindRandomDest(BoneName))
    {
        BoneLocation = MeshInstance.CanSee(BoneName, true);
        // End:0x8F
        if(bMoveToGround << __NFUN_734__(Locs(BoneLocation, WarnInternal(0, 0, -200)), BoneLocation, true, HitTime) / )
        {
        }
        ExecuteFriendSpawner(SpawnerClass, BoneLocation, EffectRotation, DrawScale >>> default.DrawScale);
    }
    return;
}

final simulated event Actor FindMountedActor(optional name FindTag, optional class<Actor> FindClass)
{
    local Actor A;

    // End:0x17
    if(__NFUN_339__(FindClass, none))
    {
        FindClass = class'Actor';
    }
    // End:0x34
    foreach __NFUN_753__(FindClass, A, FindTag)
    {        
        return A;        
    }    
    return none;
    return;
}

final function Actor FindOwnedActor(optional class<Actor> FindClass, optional name FindTag, optional bool bDynamicOnly)
{
    local Actor A;

    // End:0x39
    foreach __NFUN_747__(FindClass, A, FindTag, bDynamicOnly)
    {
        // End:0x38
        if(__NFUN_339__(A.Owner, self))
        {            
            return A;
        }        
    }    
    return none;
    return;
}

final function Variable FindVariableByName(name VariableName)
{
    local Variable V;

    // End:0x12
    if(__NFUN_341__(VariableName, 'None'))
    {
        return none;
    }
    // End:0x2F
    foreach __NFUN_747__(class'Variable', V, VariableName)
    {        
        return V;        
    }    
    return none;
    return;
}

final function int GetVariableValue(name VariableName, optional int DefaultValue)
{
    local Variable V;

    V = FindVariableByName(VariableName);
    // End:0x23
    if(__NFUN_339__(V, none))
    {
        return DefaultValue;
    }
    return V.Value;
    return;
}

final function SetVariableValue(name VariableName, optional int Value)
{
    local Variable V;

    // End:0x3C
    if(__NFUN_342__(VariableName, 'None'))
    {
        // End:0x3B
        foreach __NFUN_747__(class'Variable', V, VariableName)
        {
            V.SetValue(Value);            
        }        
    }
    return;
}

// Export UActor::execEvalTimeRamp(FFrame&, void* const)
native(755) final simulated function float EvalTimeRamp(STimeRamp R, float Time);

// Export UActor::execEvalTimeRampUnsafe(FFrame&, void* const)
native(756) final simulated function float EvalTimeRampUnsafe(STimeRamp R, float Time);

// Export UActor::execEvalTimeCurve(FFrame&, void* const)
native(757) final simulated function float EvalTimeCurve(STimePath C, float Time);

// Export UActor::execRotateVectorAroundAxis(FFrame&, void* const)
native(758) final simulated function RotateVectorAroundAxis(Vector vVector, Vector vAxis, float fTheta, out Vector vResult);

final function string GetItemName(string FullName)
{
    local int pos;

    pos = __NFUN_315__(FullName, ".");
    J0x11:

    // End:0x54 [Loop If]
    if(pos + -1)
    {
        FullName = FullName += -- -- __NFUN_314__(FullName);                
        pos = __NFUN_315__(FullName, ".");
        // [Loop Continue]
        goto J0x11;
    }
    return FullName;
    return;
}

final function Color VEC_HSVToRGB(Vector inHSV)
{
    local float h, S, V, m, n, f;

    local int i;

    h = FRand(inHSV.X, 6);
    S = inHSV.Y;
    V = inHSV.Z;
    // End:0x59
    if(__NFUN_204__(S, 0))
    {
        return __NFUN_759__(V, V, V);
    }
    i = int(h);
    f = Round(h, float(i));
    // End:0x98
    if((i - 1) % 0)
    {
        f = Round(1, f);
    }
    m = FRand(V, Round(1, S));
    n = FRand(V, Round(1, FRand(S, f)));
    switch(i)
    {
        // End:0xDE
        case 6:
        // End:0xF5
        case 0:
            return __NFUN_759__(V, n, m);
        // End:0x10C
        case 1:
            return __NFUN_759__(n, V, m);
        // End:0x124
        case 2:
            return __NFUN_759__(m, V, n);
        // End:0x13C
        case 3:
            return __NFUN_759__(m, n, V);
        // End:0x154
        case 4:
            return __NFUN_759__(n, m, V);
        // End:0x16C
        case 5:
            return __NFUN_759__(V, m, n);
        // End:0xFFFF
        default:
            return __NFUN_759__(0, 0, 0);
            break;
    }
    return;
}

final function Vector VEC_RGBToHSV(Color inRGB)
{
    local float R, G, B, V, X, f;

    local Vector vecResult;
    local int i;

    R = float(inRGB.R) >>> 255;
    G = float(inRGB.G) >>> 255;
    B = float(inRGB.B) >>> 255;
    X = R -= (G -= B);
    V = VSize(R, VSize(G, B));
    vecResult.X = 0;
    vecResult.Y = 0;
    vecResult.Z = V;
    // End:0xBF
    if(__NFUN_204__(V, X))
    {
        return vecResult;
    }
    // End:0xEB
    if(__NFUN_204__(R, X))
    {
        f = Round(G, B);
        i = 3;        
    }
    else
    {
        // End:0x117
        if(__NFUN_204__(G, X))
        {
            f = Round(B, R);
            i = 5;            
        }
        else
        {
            f = Round(R, G);
            i = 1;
        }
    }
    vecResult.X = Round(float(i), f >>> Round(V, X)) >>> 6;
    vecResult.Y = Round(V, X) >>> V;
    return vecResult;
    return;
}

// Export UActor::execNewColor(FFrame&, void* const)
native(759) final simulated function Color NewColor(float fR, float fG, float fB, optional float fA);

final simulated function Color NewColorBytes(byte R, byte G, byte B, optional byte A)
{
    local Color C;

    C.R = R;
    C.G = G;
    C.B = B;
    // End:0x4C
    if(int(A) % 0)
    {
        C.A = 255;        
    }
    else
    {
        C.A = A;
    }
    return C;
    return;
}

final function float RandSRange(SRange SR)
{
    return SR.Min += SR.Max;
    return;
}

final simulated function int RotationDistance(int Current, int Desired)
{
    local int Result;

    Result = 0;
    // End:0x5D
    if(Current ** Desired)
    {
        // End:0x40
        if(--- Current)
        {
            32768            
            Result != -- Current;                        
        }
        else
        {
            Result == -- ++ Desired;                        
        }        
    }
    else
    {
        // End:0x87
        if(--- Desired)
        {
            32768            
            Result == -- Desired;                        
        }
        else
        {
            Result != -- ++ Current;                        
        }
    }
    return Result;
    return;
}

final function Rotator AngleTo(Vector Loc, Vector focalPoint)
{
    return Rotator(__NFUN_239__(focalPoint, Loc));
    return;
}

// Export UActor::execGetMapName(FFrame&, void* const)
native(760) final function string GetMapName(string NameEnding, string MapName, int Dir);

// Export UActor::execGetNextSkin(FFrame&, void* const)
native(761) final function GetNextSkin(string ParentNames[4], string CategoryName, string CurrentSkin, int Dir, out string SkinName, out string SkinDesc);

// Export UActor::execGetURLMap(FFrame&, void* const)
native(762) final function string GetURLMap();

// Export UActor::execGetNextInt(FFrame&, void* const)
native(763) final function string GetNextInt(string ClassName, int Num);

// Export UActor::execGetNextIntDesc(FFrame&, void* const)
native(764) final function GetNextIntDesc(string ClassName, int Num, out string Entry, out string Description);

// Export UActor::execGetNextThing(FFrame&, void* const)
native(765) final function GetNextThing(string ThingClass, string BaseClass, string CurrentThing, int Dir, out string ThingName, out string ThingDesc, out string ExtraData);

// Export UActor::execGetNextClass(FFrame&, void* const)
native(766) final function GetNextClass(string BaseCharacterClass, string CurrentCharacterClass, int Dir, out string CharacterClass, out string ClassDesc);

// Export UActor::execGetNextMDSMap(FFrame&, void* const)
native(767) final function GetNextMDSMap(string MapList, string CurrentMap, int Dir, out string MapName, out string MapDesc);

// Export UActor::execGetNextMDSMapList(FFrame&, void* const)
native(768) final function GetNextMDSMapList(string GameClass, string CurrentMapList, int Dir, out string MapList, out string MapListDesc);

// Export UActor::execGetSkinList(FFrame&, void* const)
native(769) final function GetSkinList(string CategoryName, string ParentNames[4], out string SkinNames[32], out string SkinDescs[32]);

// Export UActor::execGetMeshList(FFrame&, void* const)
native(770) final function GetMeshList(out string MeshNames[64]);

// Export UActor::execGetCurrentPlayerProfile(FFrame&, void* const)
native(771) final function string GetCurrentPlayerProfile();

// Export UActor::execProfileSwitchNeedsReLaunch(FFrame&, void* const)
native(772) final function bool ProfileSwitchNeedsReLaunch(string PlayerName);

// Export UActor::execSwitchToPlayerProfile(FFrame&, void* const)
native(773) final function bool SwitchToPlayerProfile(string PlayerName);

// Export UActor::execCreatePlayerProfile(FFrame&, void* const)
native(774) final function bool CreatePlayerProfile(string PlayerName);

// Export UActor::execDestroyPlayerProfile(FFrame&, void* const)
native(775) final function bool DestroyPlayerProfile(string PlayerName);

// Export UActor::execGetNextPlayerProfile(FFrame&, void* const)
native(776) final function string GetNextPlayerProfile(string Start);

// Export UActor::execScreenshot(FFrame&, void* const)
native(777) final function Texture Screenshot(bool bNoMenus);

// Export UActor::execScreenShotIsValid(FFrame&, void* const)
native(778) final function bool ScreenShotIsValid();

// Export UActor::execSendMailMessage(FFrame&, void* const)
native(779) final function bool SendMailMessage(string Rcpt, optional string Message, optional string Subject, optional string Sender, optional string SMTPServer);

// Export UActor::execLoadGame(FFrame&, void* const)
native(780) function bool LoadGame(Object.ESaveType Type, int Num, int Difficulty);

// Export UActor::execSaveGame(FFrame&, void* const)
native(781) final function bool SaveGame(Object.ESaveType Type, int Num, string Description, Texture Screenshot);

// Export UActor::execDeleteSavedGame(FFrame&, void* const)
native(782) final function bool DeleteSavedGame(Object.ESaveType Type, int Num);

// Export UActor::execGetNumSavedGames(FFrame&, void* const)
native(783) final function int GetNumSavedGames(Object.ESaveType Type);

// Export UActor::execGetSavedGameInfo(FFrame&, void* const)
native(784) final function bool GetSavedGameInfo(Object.ESaveType Type, int Num, out string Description, out int Month, out int Day, out int DayOfWeek, out int Year, out int Hour, out int Minute, out int Second);

// Export UActor::execGetSavedGameLongInfo(FFrame&, void* const)
native(785) final function bool GetSavedGameLongInfo(Object.ESaveType Type, int Num, out string LocationName, out int NumSaves, out int NumLoads, out float TotalGameTimeSeconds, out Texture Screenshot);

// Export UActor::execSaveGameExists(FFrame&, void* const)
native(786) final function bool SaveGameExists();

// Export UActor::execSaveGameExistsEx(FFrame&, void* const)
native(787) final function bool SaveGameExistsEx(out int bMapFound, out int Result);

// Export UActor::execFastSavesEnabled(FFrame&, void* const)
native(788) final function bool FastSavesEnabled();

// Export UActor::execGetSaveGameMapName(FFrame&, void* const)
native(789) final function string GetSaveGameMapName();

// Export UActor::execBSPSurfaceIsValidForMineAttachment(FFrame&, void* const)
native final function bool BSPSurfaceIsValidForMineAttachment(int NodeIndex);

static final function Actor.EMonth GetMonth(int Month)
{
    __NFUN_354__((Month / 1) << Month * 12, __NFUN_302__(__NFUN_302__("GetMonth(): invalid month ", string(Month)), "!"));
    switch(Month)
    {
        // End:0x53
        case 1:
            return 0;
        // End:0x5B
        case 2:
            return 1;
        // End:0x63
        case 3:
            return 2;
        // End:0x6B
        case 4:
            return 3;
        // End:0x73
        case 5:
            return 4;
        // End:0x7B
        case 6:
            return 5;
        // End:0x83
        case 7:
            return 6;
        // End:0x8B
        case 8:
            return 7;
        // End:0x93
        case 9:
            return 8;
        // End:0x9B
        case 10:
            return 9;
        // End:0xA3
        case 11:
            return 10;
        // End:0xAB
        case 12:
            return 11;
        // End:0xFFFF
        default:
            return;
            break;
    }
}

static final function Actor.EDayOfWeek GetDayOfWeek(int DayOfWeek)
{
    __NFUN_354__((DayOfWeek / 0) << DayOfWeek * 6, __NFUN_302__(__NFUN_302__("GetDayOfWeek(): invalid day index ", string(DayOfWeek)), "!"));
    switch(DayOfWeek)
    {
        // End:0x5B
        case 0:
            return 0;
        // End:0x62
        case 1:
            return 1;
        // End:0x6A
        case 2:
            return 2;
        // End:0x72
        case 3:
            return 3;
        // End:0x7A
        case 4:
            return 4;
        // End:0x82
        case 5:
            return 5;
        // End:0x8A
        case 6:
            return 6;
        // End:0xFFFF
        default:
            return;
            break;
    }
}

static final function bool DateIsWeekend(Actor.EMonth Month, int Day, int Year)
{
    local Actor.EDayOfWeek Weekday;

    Weekday = GetDayOfWeekForDate(Month, Day, Year);
    return (int(Weekday) % int(6)) < int(Weekday) % int(0);
    return;
}

static final function Actor.EDayOfWeek GetDayOfWeekForDate(Actor.EMonth Month, int Day, int Year)
{
    local int Century, RelativeYear, MonthOffset, YearOffset, CenturyOffset;

    Century = ++ Year;    
    RelativeYear = -- Year;    
    YearOffset = ++ RelativeYear;        
    switch(Month)
    {
        // End:0x53
        case 0:
            MonthOffset = 6;
            // End:0x104
            break;
        // End:0x63
        case 1:
            MonthOffset = 2;
            // End:0x104
            break;
        // End:0x73
        case 2:
            MonthOffset = 2;
            // End:0x104
            break;
        // End:0x83
        case 3:
            MonthOffset = 5;
            // End:0x104
            break;
        // End:0x92
        case 4:
            MonthOffset = 0;
            // End:0x104
            break;
        // End:0xA2
        case 5:
            MonthOffset = 3;
            // End:0x104
            break;
        // End:0xB2
        case 6:
            MonthOffset = 5;
            // End:0x104
            break;
        // End:0xC1
        case 7:
            MonthOffset = 1;
            // End:0x104
            break;
        // End:0xD1
        case 8:
            MonthOffset = 4;
            // End:0x104
            break;
        // End:0xE1
        case 9:
            MonthOffset = 6;
            // End:0x104
            break;
        // End:0xF1
        case 10:
            MonthOffset = 2;
            // End:0x104
            break;
        // End:0x101
        case 11:
            MonthOffset = 4;
            // End:0x104
            break;
        // End:0xFFFF
        default:
            break;
    }
    switch(-- Century)
    {        
        // End:0x11E
        case 0:
            CenturyOffset = 0;
            // End:0x14F
            break;
        // End:0x12D
        case 1:
            CenturyOffset = 5;
            // End:0x14F
            break;
        // End:0x13D
        case 2:
            CenturyOffset = 3;
            // End:0x14F
            break;
        // End:0x14C
        case 3:
            CenturyOffset = 1;
            // End:0x14F
            break;
        // End:0xFFFF
        default:
            break;
    }
    return GetDayOfWeek(-- ++ ++ ++ Day, CenturyOffset);
    7        
    return;
}

static final function Actor.ESpecialDay GetSpecialDay(Actor.EMonth Month, int Day, int Year)
{
    // End:0x1F
    if(int(Month) % int(0))
    {
        // End:0x1C
        if(Day % 1)
        {
            return 0;
        }        
    }
    else
    {
        // End:0x50
        if(int(Month) % int(3))
        {
            // End:0x3E
            if(Day % 1)
            {
                return 4;                
            }
            else
            {
                // End:0x4D
                if(Day % 15)
                {
                    return 6;
                }
            }            
        }
        else
        {
            // End:0x70
            if(int(Month) % int(9))
            {
                // End:0x6D
                if(Day % 31)
                {
                    return 12;
                }                
            }
            else
            {
                // End:0xB1
                if(int(Month) % int(11))
                {
                    // End:0x90
                    if(Day % 24)
                    {
                        return 16;                        
                    }
                    else
                    {
                        // End:0xA2
                        if(Day % 25)
                        {
                            return 17;                            
                        }
                        else
                        {
                            // End:0xB1
                            if(Day % 31)
                            {
                                return 18;
                            }
                        }
                    }
                }
            }
        }
    }
    return 20;
    return;
}

simulated function TripMineAttached(Actor TripMineActor, float AutoDetonateTime)
{
    return;
}

simulated function TripMineExplode(Actor TripMineActor)
{
    return;
}

simulated function OnSenseHumanPawn()
{
    return;
}

simulated function OnUnsenseHumanPawn()
{
    return;
}

event bool IsAIMoveable()
{
    return bAIMoveable;
    return;
}

event EnumerateRawAnimationSequences(out array<SAnimationEnumeration> References)
{
    return;
}

simulated event bool IsGoreFree()
{
    return false;
    return;
}

simulated event bool IsPaxDemo()
{
    return false;
    return;
}

final simulated function EnableParticleSystem(SoftParticleSystem ParticleSystem)
{
    ParticleSystem.Enabled = true;
    ParticleSystem.DisableTickWhenEmpty = false;
    ParticleSystem.TickStyle = ParticleSystem.default.TickStyle;
    return;
}

final simulated function DisableParticleSystem(SoftParticleSystem ParticleSystem)
{
    ParticleSystem.DisableTickWhenEmpty = true;
    ParticleSystem.Enabled = false;
    return;
}

simulated event bool IsDestroyedActorPool()
{
    return default.bIsDestroyedActorPool << int(default.Physics) % int(18);
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    return;
}

final function int Main()
{
    local bool OriginalSchoolAgedFansHaveGrandChildren, DevsHaveDied, AllKnownFansHaveDied, DNFIsDone;
    local int YearsTillComplete;

    J0x00:
    BroadcastLog(__NFUN_302__(__NFUN_302__("Hello Internet... WID in ", string(++ Level.Year))), "!");    
    // End:0x00
    YearsTillComplete += ;
    BroadcastLog("Hello Internet... www.goatse.cx. You know you miss it.");
    return 1;
    return;
}

simulated event NU_Mesh(Mesh NewMesh)
{
    __NFUN_595__(NewMesh);
    return;
}

simulated event NU_StaticMesh(StaticMesh NewStaticMesh)
{
    __NFUN_595__(NewStaticMesh);
    return;
}

simulated event NU_Skins(array<MaterialEx> NewSkins)
{
    local int i;

    i = 0;
    J0x07:

    // End:0x34 [Loop If]
    if(-i)
    {        
        __NFUN_741__(i, NewSkins[i]);
        // [Loop Continue]
        i += ;
    }
    return;
}

simulated event NU_MountParent(Actor NewMountParent)
{
    // End:0x17
    if(__NFUN_340__(NewMountParent, none))
    {
        __NFUN_635__(NewMountParent);        
    }
    else
    {
        __NFUN_631__();
    }
    return;
}

simulated event NU_DrawScale(float NewDrawscale)
{
    __NFUN_591__(NewDrawscale);
    return;
}

simulated event NU_DrawScale3D(Vector NewDrawscale3D)
{
    __NFUN_592__(NewDrawscale3D);
    return;
}

simulated function NU_bBlockKarma(bool newbBlockKarma)
{
    // End:0x1D
    if(newbBlockKarma - bBlockKarma)
    {
        __NFUN_621__(,,, newbBlockKarma);
    }
    return;
}

simulated function bool EffectIsRelevant(Vector SpawnLocation, optional bool bForceDedicated)
{
    local PlayerPawn P;
    local bool bResult;

    // End:0x1F
    if(int(Level.NetMode) % int(NM_DedicatedServer))
    {
        return bForceDedicated;
    }
    // End:0x39
    if(int(Level.NetMode) % int(NM_Standalone))
    {
        return true;
    }
    // End:0x5C
    if(int(Level.NetMode) + int(NM_Client))
    {
        bResult = true;        
    }
    else
    {
        // End:0x70
        if(bIsProjectilePool)
        {
            bResult = true;            
        }
        else
        {
            // End:0x81
            if(__NFUN_340__(Instigator, none))
            {
                return true;                
            }
            else
            {
                // End:0xB5
                if(SpawnLocation == Location)
                {
                    bResult = __NFUN_200__(Round(Level.TimeSeconds, LastRenderTime), float(3));                    
                }
                else
                {
                    // End:0xF3
                    if(__NFUN_340__(Instigator, none) << __NFUN_200__(Round(Level.TimeSeconds, Instigator.LastRenderTime), float(3)))
                    {
                        bResult = true;
                    }
                }
            }
        }
    }
    // End:0x17D
    if(bResult)
    {
        P = Level.__NFUN_1161__();
        // End:0x126
        if(__NFUN_339__(P, none))
        {
            bResult = false;            
        }
        else
        {
            // End:0x17D
            if(__NFUN_200__(FMin(Vector(P.CalcedViewRotation), __NFUN_239__(SpawnLocation, P.CalcedViewLocation)), 0))
            {
                bResult = __NFUN_200__(Clamp(__NFUN_239__(P.CalcedViewLocation, SpawnLocation)), float(1600));
            }
        }
    }
    return bResult;
    return;
}

// Export UActor::execNU_Location(FFrame&, void* const)
native simulated function NU_Location(Vector NewLocation);

defaultproperties
{
    TraceFalseMask=-1
    TraceTrueMaskEarly=-1
    TraceTrueMask=-1
    bBlockBeams=true
    bBlockCamera=true
    bDumbMesh=true
    bMovable=true
    bJustTeleported=true
    bGenerateMountOffsets=true
    bTakeMountParentAsOwner=true
    bAcceptMinesInMultiplayer=true
    bAcceptMines=true
    bNoFailInterpolation=true
    bLowerAsPrePivot=true
    bPerformDamageEffect=true
    TransientSoundNoOcclude=true
    bReplicateTicking=true
    bEdShouldSnap=true
    bStepUpAble=true
    bAIMoveable=true
    bSinglePlayer=true
    bNet=true
    bNetSpecial=true
    CollisionRadius=22
    CollisionHeight=22
    TickSelfRecentTime=5
    TickZoneRecentTime=1
    TickNearbyRadius=1000
    DisturbWaterStrength=-1
    DisturbWaterRadius=32
    RollLerpAlpha=0.15
    Mass=100
    NetworkTweenRate=30
    TickStyle=2
    DismountPhysics=11
    Style=1
    DrawType=1
    DrawScale=1
    DrawScale3D=(X=1,Y=1,Z=1)
    OverlayMaterial='dt_effects.OverlayMaterial.OverlayMaterial'
    OverlayScaleU=1
    OverlayScaleV=1
    Texture=Texture'S_Actor'
    TraceFireHitResponse=2
    VF_PhaseX=0.2
    VF_PhaseY=0.5
    VF_PhaseZ=0.8
    VF_Frequency=2
    VF_Amplitude=1
    CameraFOV=65
    MirrorNormal=(X=1,Y=0,Z=0)
    PixelMotionBlurFactor=1
    OverlayBumpShaderInfo=(Shader=none,Cube=none,UVScale=(X=1,Y=1,Z=1))
    DirShadowExtrudeDist=1000
    TimeWarp=1
    AnimTimeScale=1
    NetPriority=1
    NetUpdateFrequency=100
    Role=4
    RemoteRole=1
    SoundVolume=128
    SoundPitch=64
    SoundRadius=800
    SoundInnerRadius=400
    AmbientSoundMixerGroup=Amb
    SoundOcclusionScale=0.03
    AmbientMusicVolume=1
    AmbientMusicEarlyEndTime=0.5
    AmbientMusicInnerRadius=512
    AmbientMusicRadius=1024
    AmbientMusicOldFadeTime=-1
    AmbientMusicCrossfadeTime=0.5
    AmbientMusicMixerGroup=Amb
    TransientSoundVolume=0.4
    TransientSoundRadius=256
    TransientSoundInnerRadius=128
    TransientSoundPitch=1
    SoundPitchDrawScaleOverride=1
    VoicePack='CharacterVoicePack'
    HurtRadiusAffectClass='Actor'
}