/*******************************************************************************
 * AnimationControllerEx generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class AnimationControllerEx extends Object
    native;

const kAnimationControllerEx_InvalidLink = -1;
const kAnimationControllerEx_AnimationHashSize = 17;
const kAnimationControllerEx_AnimationPairHashSize = 7;
const kAnimationControllerEx_AnimationGridHashSize = 7;

enum EAnimControllerBlend
{
    ACBLEND_FadeOut,
    ACBLEND_FadeIn
};

struct SAnimationFadeBlend
{
    var() float BlendTotalTime;
    var() float StartingBlendAlpha;
    var() float EndingBlendAlpha;
};

struct SAnimationFadeBlendInternal
{
    var() float BlendTotalTime;
    var() float StartingBlendAlpha;
    var() float EndingBlendAlpha;
    var() int AnimIndex;
    var() int ChannelIndex;
    var() float BlendTimeElapsed;
    var() AnimationControllerEx.EAnimControllerBlend BlendType;
    var() AnimationControllerEx ServerLink;
};

struct SAnimationBlockBlend
{
    var() int ChannelBlockIndex;
    var() float StartAlpha;
    var() float EndAlpha;
    var() float CurrentBlendTime;
    var() float TotalBlendTime;
    var() name BlendEndCallback;
    var() bool bClearAnimsOnBlendFinish;
    var() Object.EAnimationControllerBlockBlend BlendType;
};

struct SAnimChannelLink
{
    var() name ChannelName;
    var() int ChannelLink;
    var() bool bLinkedToBlock;
};

struct SAnimControllerChannel
{
    var() name ChannelName;
    var() name ChannelGroupName;
    var() Object.EAnimationBlendMode ChannelBlendOp;
    var() float LastBlendAlpha;
    var() int LastAnimLink;
    var() AnimationControllerEx LastAnimControllerLink;
    var() int ParentBlockChannelLink;
    var() bool bActAsGroup;
    var() float GroupCrossfadeTime;
    var() int PrimaryChannelIndex;
    var() float FadeRates[24];
    var() int NumFadingOut;
    var() float LastCrossfadeRate;
    var() bool bMovementActive;
};

struct SAnimChannelBlock
{
    var() name ChannelBlockName;
    var() array<SAnimChannelLink> ChannelSubChannels;
    var() int ChannelLastUsedChannel;
    var() int ChannelLastPrimaryAnimIndex;
    var() AnimationControllerEx ChannelLastPrimaryControllerLink;
    var() float ChannelMasterAlpha;
    var float DefaultChannelMasterAlpha;
};

struct SAnimationInfo
{
    var() name AnimationName;
    var() SAnimChannelLink AnimationChannel;
    var() anim name AnimSequence;
    var() float AnimStartingFrame;
    var() float AnimRate;
    var() float AnimRateVariance;
    var() float AnimTween;
    var() float AnimDefaultBlendAlpha;
    var() float AnimEarlyEndTime;
    var() bool bLoopAnim;
    var() bool bInterrupt;
    var() bool bNoRemoveAnim;
    var() bool bBatchAnim;
    var() bool bAdjustStart;
    var() SAnimationFadeBlend AnimBlendInInfo;
    var() SAnimationFadeBlend AnimBlendOutInfo;
    var() name AnimStart_FunctionCallName;
    var() name AnimEnd_NextAnimStateName;
    var() name AnimEnd_FunctionCallName;
    var() name AnimEnd_Event;
    var() float GroupCrossfadeOverride;
    var() bool bForceCrossfade;
    var() bool bIs3DGrid;
    var() int AnimGridLink;
};

struct SAnimationBlock
{
    var() name AnimationBlockName;
    var() array<name> AnimationNames;
};

struct SAnimationBlendPair
{
    var() name AnimationBlendPairName;
    var() name AnimationNames[2];
    var() int AnimationIndices[2];
};

struct SAnimationGrid
{
    var() name AnimationGridName;
    var() SAnimChannelLink AnimationChannel;
    var() anim name AnimGridSequence;
    var() bool bIs3DGrid;
    var() int AnimationLink;
};

var() bool bDebugAnimationController;
var() const bool bEnableRecentAnimCache;
var() RenderActor RenderOwner;
var() AnimationControllerEx ControllerServer;
var() array<SAnimationFadeBlendInternal> ActiveBlends;
var() array<SAnimationBlockBlend> ChannelBlockActiveBlends;
var const transient int AnimationHash;
var const transient int AnimationPairHash;
var const transient int AnimationGridHash;
var() array<SAnimControllerChannel> AnimChannels;
var() array<SAnimChannelBlock> AnimChannelBlocks;
var() array<SAnimationInfo> Animations;
var() array<SAnimationBlock> AnimationBlocks;
var() array<SAnimationBlendPair> AnimationBlendPairs;
var() array<SAnimationGrid> AnimationGrids;
var array<int> _AnimIndexCache;
var array<int> _AnimChannelCache;
var array<int> _AnimRefIdCache;
var array<int> CrossfadeGroups;
var float AnimRateScale;
var int FrameCounter;

// Export UAnimationControllerEx::execInitAnimationControllerEx(FFrame&, void* const)
native(1291) simulated function InitAnimationControllerEx(RenderActor SourceActor, optional AnimationControllerEx Server);

// Export UAnimationControllerEx::execFlushHashes(FFrame&, void* const)
native(1292) simulated function FlushHashes();

// Export UAnimationControllerEx::execResetServer(FFrame&, void* const)
native(1293) simulated function ResetServer();

// Export UAnimationControllerEx::execSetAnimState(FFrame&, void* const)
native(1294) simulated function bool SetAnimState(name AnimationName, optional bool bForceReset, optional bool LogError);

// Export UAnimationControllerEx::execSetAnimPairState(FFrame&, void* const)
native(1295) simulated function bool SetAnimPairState(name AnimationPairName, float Alpha, optional bool bForceReset);

// Export UAnimationControllerEx::execSetAnimGridState(FFrame&, void* const)
native(1296) simulated function bool SetAnimGridState(name AnimationGridName, float X, optional float Y, optional bool bKeepChannelAlpha);

// Export UAnimationControllerEx::execSetChannelGridState(FFrame&, void* const)
native(1297) simulated function bool SetChannelGridState(name ChannelName, float X, optional float Y);

// Export UAnimationControllerEx::execSetChannelEventState(FFrame&, void* const)
native(1298) simulated function bool SetChannelEventState(name ChannelName, bool bEventsEnabled);

// Export UAnimationControllerEx::execEmptyAnimChannel(FFrame&, void* const)
native(1299) simulated function EmptyAnimChannel(name AnimationChannel);

// Export UAnimationControllerEx::execEmptyAnimChannels_AllButGroup(FFrame&, void* const)
native(1300) simulated function EmptyAnimChannels_AllButGroup(name AnimationChannelGroup);

// Export UAnimationControllerEx::execEmptyAnimChannels_OnlyGroup(FFrame&, void* const)
native(1301) simulated function EmptyAnimChannels_OnlyGroup(name AnimationChannelGroup);

// Export UAnimationControllerEx::execEmptyAnimChannels_ByBlock(FFrame&, void* const)
native(1302) simulated function EmptyAnimChannels_ByBlock(name AnimationChannelBlock);

// Export UAnimationControllerEx::execGetChannelBlockBlend(FFrame&, void* const)
native(1303) final simulated function float GetChannelBlockBlend(name ChannelBlockName);

// Export UAnimationControllerEx::execGetChannelBlockBlendTarget(FFrame&, void* const)
native(1304) final simulated function float GetChannelBlockBlendTarget(name ChannelBlockName);

// Export UAnimationControllerEx::execBlendChannelBlock(FFrame&, void* const)
native(1305) final simulated function bool BlendChannelBlock(name ChannelBlockName, float BlendTime, float StartAlpha, float EndAlpha, optional bool bClearAnimsOnBlendFinish, optional name BlendEndCallback, optional Object.EAnimationControllerBlockBlend BlendType);

// Export UAnimationControllerEx::execSetChannelBlockMasterAlpha(FFrame&, void* const)
native(1306) final simulated function bool SetChannelBlockMasterAlpha(name ChannelBlockName, float MasterAlpha);

// Export UAnimationControllerEx::execFindAnimIndexForName(FFrame&, void* const)
native(1307) final simulated function int FindAnimIndexForName(name AnimationName, optional int StartIndex);

// Export UAnimationControllerEx::execFindAnimGridIndexForName(FFrame&, void* const)
native(1308) final simulated function int FindAnimGridIndexForName(name AnimGridName);

// Export UAnimationControllerEx::execFindAnimPairIndexForName(FFrame&, void* const)
native(1309) final simulated function int FindAnimPairIndexForName(name AnimationPairName);

// Export UAnimationControllerEx::execFindAnimBlockIndexForName(FFrame&, void* const)
native(1310) final simulated function int FindAnimBlockIndexForName(name AnimationBlockName);

// Export UAnimationControllerEx::execFindAnimChannelIndexForName(FFrame&, void* const)
native(1311) final simulated function int FindAnimChannelIndexForName(name AnimationChannelName);

// Export UAnimationControllerEx::execFindAnimChannelBlockIndexForName(FFrame&, void* const)
native(1312) final simulated function int FindAnimChannelBlockIndexForName(name AnimationChannelBlockName);

// Export UAnimationControllerEx::execGetPrimaryChannelIndex(FFrame&, void* const)
native(1313) final simulated function int GetPrimaryChannelIndex(name ChannelBlockName);

// Export UAnimationControllerEx::execGetMeshSequenceName(FFrame&, void* const)
native(1314) final simulated function name GetMeshSequenceName(name AnimationName);

// Export UAnimationControllerEx::execGetAnimTimeByName(FFrame&, void* const)
native(1315) final simulated function float GetAnimTimeByName(name AnimationName);

// Export UAnimationControllerEx::execGetAnimTimeByIndex(FFrame&, void* const)
native(1316) final simulated function float GetAnimTimeByIndex(int AnimationIndex);

// Export UAnimationControllerEx::execAnimationFinished(FFrame&, void* const)
native(1317) final simulated function AnimationFinished(name AnimationSequence, int ChannelID, optional name GroupName);

// Export UAnimationControllerEx::execUpdateGlobalAnimRateScale(FFrame&, void* const)
native(1318) final simulated function UpdateGlobalAnimRateScale(float NewAnimRateScale);

// Export UAnimationControllerEx::execUpdateChannelBlendAlpha(FFrame&, void* const)
native(1319) final simulated function UpdateChannelBlendAlpha(name ChannelName, float NewBlendAlpha);

// Export UAnimationControllerEx::execUpdateChannelTime(FFrame&, void* const)
native(1320) final simulated function UpdateChannelTime(name ChannelName, float NewTime);

// Export UAnimationControllerEx::execGetNumberOfCachedAnimSequences(FFrame&, void* const)
native(1321) final simulated function int GetNumberOfCachedAnimSequences();

// Export UAnimationControllerEx::execGetCachedAnimSequence(FFrame&, void* const)
native(1322) final simulated function name GetCachedAnimSequence(int Index);

// Export UAnimationControllerEx::execGetCachedAnimChannel(FFrame&, void* const)
native(1323) final simulated function name GetCachedAnimChannel(int Index);

// Export UAnimationControllerEx::execGetCachedAnimSequences(FFrame&, void* const)
native(1324) final simulated function bool GetCachedAnimSequences(Pawn HappyFunActor);

// Export UAnimationControllerEx::execGetCachedAnimRefIds(FFrame&, void* const)
native(1325) simulated function bool GetCachedAnimRefIds(array<int> RefIds);

// Export UAnimationControllerEx::execGetCachedPrimaryRefId(FFrame&, void* const)
native(1326) simulated function bool GetCachedPrimaryRefId(name AnimationName, out int RefId);

static event EnumerateRawAnimationSequences(out array<SAnimationEnumeration> References, class<AnimationControllerEx> Controller, Mesh Mesh)
{
    local int i;

    // End:0x0E
    if(__NFUN_339__(Controller, none))
    {
        return;
    }
    i = 0;
    J0x15:

    // End:0x88 [Loop If]
    if(-i)
    {        
        // End:0x7E
        if(__NFUN_342__(Controller.default.Animations[i].AnimSequence, 'None'))
        {
            AddAnimationEnumeration(References, Controller.default.Animations[i].AnimSequence, Mesh);
        }
        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x8F:

    // End:0x102 [Loop If]
    if(-i)
    {        
        // End:0xF8
        if(__NFUN_342__(Controller.default.AnimationGrids[i].AnimationGridName, 'None'))
        {
            AddAnimationEnumeration(References, Controller.default.AnimationGrids[i].AnimationGridName, Mesh);
        }
        // [Loop Continue]
        i += ;
    }
    return;
}

defaultproperties
{
    AnimRateScale=1
}