/*******************************************************************************
 * BeamSystem generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class BeamSystem extends ParticleSystemBase
    native
    collapsecategories
    notplaceable
    hidecategories(Filter,HeatVision,Interactivity,Karma,KarmaObject,KarmaOverride,Lighting,Networking,ParticleSystemBase,ParticleTextureInfo,SoftParticleSystem,Sound,SpawnOnDestroyed);

enum EBeamType
{
    BST_Straight,
    BST_StraightContinuous,
    BST_RecursiveSubdivide,
    BST_SineWave,
    BST_DoubleSineWave,
    BST_Spline,
    BST_Grid,
    BST_Bezier,
    BST_Tracer
};

enum EBeamSystemTriggerType
{
    BSTT_None,
    BSTT_Enable,
    BSTT_Disable,
    BSTT_Toggle,
    BSTT_Reset
};

enum EBeamBrokenWhen
{
    BBW_Never,
    BBW_PlayerProximity,
    BBW_ClassProximity,
    BBW_Shot,
    BBW_PawnProximity
};

enum EBeamBrokenAction
{
    BBA_None,
    BBA_TriggerEvent,
    BBA_TriggerBeamBrokenEvent,
    BBA_TriggerBreaker,
    BBA_TriggerBeam,
    BBA_TriggerOwner,
    BBA_TriggerActor
};

enum EBeamPlayerCameraStyleMode
{
    BPCS_None,
    BPCS_Equal,
    BPCS_NotEqual
};

enum EBeamEdgeOrientation
{
    BEO_CrossProduct,
    BEO_ViewAngleUp,
    BEO_ViewAngleRight,
    BEO_ViewAngleMixed
};

struct SBeamSegment
{
    var() noexport float Lifetime "Used to determine how long the segment will be active. 0 == use DefaultLifetime.";
    var() noexport deprecated Actor Actor1 "Actor used to represent this segments start location. None will use BeamSystem when bNonActor1 == false.";
    var() noexport deprecated Actor Actor2 "Actor used to represent this segments end location. None will use BeamSystem when bNonActor2 == false. NOT used for BST_Spline mode.";
    var() noexport Vector Location1 "Used as the first endpoint when bNonActor1 == true";
    var() noexport Vector Location2 "Used as the second endpoint when bNonActor2 == true";
    var() noexport bool bNonActor1 "When true, Actor1 is ignored.";
    var() noexport bool bNonActor2 "When true, Actor2 is ignored.";
    var() noexport name Actor1Bone "When Actor1 is not None and is using a Mesh, this is the name of the bone to use for this segments start location.";
    var() noexport name Actor2Bone "When Actor2 is not None and is using a Mesh, this is the name of the bone to use for this segments end location.";
};

struct SInternalBeamSegment
{
    var Actor Actor1;
    var Actor Actor2;
    var name Actor1Bone;
    var name Actor2Bone;
    var Vector Location1;
    var Vector Location2;
    var Color Color;
    var float Lifetime;
    var float RemainingLifetime;
    var float CreatedTime;
    var int PrevSegment;
    var int NextSegment;
};

var() noexport bool Enabled "If false, BeamSystem is disabled.";
var() bool TraceEnabled;
var() noexport bool DisableTraceAfterTick "When true, BeamSystem tracing will be disabled at the end of the next tick.";
var() noexport bool bDrawPreviewInEditor "When true, draw preview line in editor. Bezier and Spline will give exact, others will just draw straigt lines between points.";
var() noexport int TesselationLevel "TesselationLevel used for BST_Spline, BST_RecursiveSubdivide, etc.";
var() noexport float BeamStartWidth "Start width for each segment.";
var() noexport float BeamEndWidth "End width for each segment.";
var() noexport float TimeScale "Scales time for animating values.";
var() noexport float DefaultLifetime "Segments will use this value if they have a value of 0.";
var() noexport float AlphaAnimStart "Alpha value of segment when Lifetime is the original value.";
var() noexport float AlphaAnimMid "If AlphaMidPercent > 0, alpha value of segment when Lifetime percent matches AlphaMidPercent.";
var() noexport float AlphaAnimEnd "Alpha value of segment when Lifetime reaches 0.";
var() noexport Color ColorAnimStart "Color of segment when Lifetime is the original value.";
var() noexport Color ColorAnimMid "If ColorMidPercent > 0, color of segment when Lifetime percent matches ColorMidPercent.";
var() noexport Color ColorAnimEnd "Color of segment when Lifetime reaches 0.";
var() noexport float AlphaMidPercent "Where during the lifetime the alpha should consider the middle. 0-1";
var() noexport float ColorMidPercent "Where during the lifetime the color should consider the middle. 0-1";
var() noexport bool bUseSineAnim "If true, Lifetime will oscillate, using a sine wave pattern.";
var() name SE_ResetEventSegments;
var() noexport name SE_ToggleTraceStatus "Trigger this event to toggle the status of TraceEnable.";
var() noexport float DynamicBeamPoints "If > 0, the beam points (non-actors) will be adjusted along the trace done in a *straight line* out from the BeamSystem itself (best when the beam system is Actor1 and Actor2 is null).";
var() noexport Color PreviewColor "Color of preview lines. Note bDrawPreviewInEditor must be true.";
var() noexport name SE_ToggleEnable "Trigger this event to toggle beam system enabled";
var() noexport name SE_ForceEnable "Trigger this event to force beam system to be enabled";
var() noexport name SE_ForceDisable "Trigger this event to force beam system to be disabled";
var() noexport float LimboZOffset "The Offset for checking against the MP Limbo Stat";
var(BeamAmplitude) noexport float MaxAmplitude "Max amount of displacement from the beam segment.";
var(BeamAmplitude) float AmplitudeLimit;
var(BeamAmplitude) float AmplitudeVelocity;
var(BeamFrequency) float MaxFrequency;
var(BeamFrequency) float FrequencyLimit;
var(BeamFrequency) float FrequencyVelocity;
var(BeamTracer) noexport float TracerSpeed "How fast the BST_Tracer will travel through the world.";
var(BeamTracer) noexport float TracerLength "How long the BST_Tracer segment is when fully extended.";
var(BeamTracer) noexport float TracerRejectScale "If the distance is less than this percentage of the Length, reject adding it. (EX: 128 length, .5 scale would reject any distance less than 64 units)";
var(BeamNoise) float Noise;
var(BeamNoise) float NoiseLimit;
var(BeamNoise) float NoiseVelocity;
var(BeamTexture) noexport MaterialEx BeamTexture "Material used for each beam segment.";
var(BeamTexture) noexport float BeamTextureScaleX "Texture coordinate sclaling on the U axis";
var(BeamTexture) noexport float BeamTextureScaleY "Texture coordinate sclaling on the V axis";
var(BeamTexture) noexport float BeamTexturePanX "Texture coordinate panning on the U axis";
var(BeamTexture) noexport float BeamTexturePanY "Texture coordinate panning on the V axis";
var(BeamTexture) noexport float BeamTextureXVelocity "Texture velocity on U axis.";
var(BeamTexture) noexport float BeamTextureYVelocity "Texture velocity on V axis.";
var(BeamTexture) noexport float BeamTextureRotate "Amount (in degrees) to rotate texture coords.";
var(BeamTexture) noexport float BeamTextureXSize "Override for texture size on U axis.";
var noexport bool bUseFakeLighting "If true and using a BumpShader, apply fake lighting to the beam.";
var noexport Color FakeLightColor "If bUseFakeLighting is true, this is the color to use.";
var noexport float FakeLightIntensity "If bUseFakeLighitng is true, this is the intensity to use.";
var bool bAllowLimboHit;
var() array<SBeamSegment> BeamSegments;
var array<SInternalBeamSegment> Segments;
var int FirstSegment;
var int LastSegment;
var int FirstFreeSegment;
var int ActiveSegmentCount;
var array<SInternalBeamSegment> RenderSegments;
var int FirstRenderSegment;
var int ActiveRenderSegmentCount;
var() BeamSystem.EBeamType BeamType;
var() bool DepthCued;
var(BeamBroken) bool BeamBrokenIgnoreWorld;
var(BeamBroken) noexport bool bBeamOnlyCheckDynamicShootable "Will the beam only consider itself broken it if passes through a shootable target.";
var(BeamBroken) noexport bool bBeamOnlyCheckPawns "Beam line check will only trace against Pawns if this is true.  Ignored if bBeamOnlyCheckDynamicShootable is false due to the trype of trace being done.";
var() bool bBeamTraceMeshAccurate;
var() BeamSystem.EBeamSystemTriggerType TriggerType;
var(BeamBroken) class<Actor> SpawnClassOnBeamCollision;
var(BeamBroken) noexport float SpawnClassMinInterval "Min interval between spawns of SpawnClassOnBeamCollision";
var float SpawnClassGate;
var(BeamBroken) BeamSystem.EBeamBrokenWhen BeamBrokenWhen;
var(BeamBroken) noexport bool bDebugBrokenCheck "Prints out what the beam system is currently hitting so you can find out why it might not be hitting what you want.";
var(BeamBroken) noexport array< class<Actor> > BeamBrokenWhenClass "Classes that will cause broken beam when BeamBrokenWhen == BBW_ClassProximity";
var(BeamBroken) BeamSystem.EBeamBrokenAction BeamBrokenAction;
var(BeamBroken) noexport deprecated Actor BeamTriggerActor "Actor to trigger directly when BBA_TriggerActor is set in BeamBrokenAction.";
var(BeamBroken) name BeamBrokenEvent;
var(BeamBroken) bool BeamBrokenRetriggerable;
var(BeamBroken) float BeamBrokenOtherDamage;
var(BeamBroken) class<DamageType> BeamBrokenOtherDamageType;
var(BeamBroken) noexport float BeamBrokenOtherDamageDelay "How much time must pass before we can damage something again.";
var float BeamBrokenOtherDamageTime;
var() BeamSystem.EBeamPlayerCameraStyleMode BeamPlayerCameraStyleMode;
var() Actor.EPlayerCameraStyle BeamPlayerCameraStyle;
var Box WorldBox;
var(BeamTexture) noexport BeamSystem.EBeamEdgeOrientation OrientationType "How to orient beam segments. BEO_CrossProduct changed orientation per-segment, while the others are per-system.  BEO_ViewAngle may look better for beams that change direction rapidly";

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        BeamBrokenIgnoreWorld, Enabled;
}

simulated function PreBeginPlay()
{
    __NFUN_718__('ResetEventSegments', SE_ResetEventSegments);
    __NFUN_718__('ToggleTraceEnable', SE_ToggleTraceStatus);
    __NFUN_718__('ToggleEnable', SE_ToggleEnable);
    __NFUN_718__('ForceEnable', SE_ForceEnable);
    __NFUN_718__('ForceDisable', SE_ForceDisable);
    super(RenderActor).PreBeginPlay();
    return;
}

simulated function PostBeginPlay()
{
    super(InteractiveActor).PostBeginPlay();
    // End:0x1B
    if(string(BeamSegments) % 0)
    {
        ResetEventSegments();        
    }
    else
    {
        ConstructPresetSegments();
    }
    BeamSegments.Empty();
    FinalizeSegments();
    WorldBox.Min = __NFUN_239__(Location, WarnInternal(5, 5, 5));
    WorldBox.Max = Locs(Location, WarnInternal(5, 5, 5));
    __NFUN_361__('Tick');
    // End:0xF3
    if((int(BeamType) + int(8)) << __NFUN_202__(DynamicBeamPoints, float(0)))
    {
        // End:0xF3
        if(((int(BeamBrokenWhen) % int(0)) < int(BeamBrokenAction) % int(0)) << __NFUN_339__(SpawnClassOnBeamCollision, none))
        {
            // End:0xF3
            if((__NFUN_204__(FrequencyVelocity, float(0)) << __NFUN_204__(AmplitudeVelocity, float(0))) << __NFUN_204__(NoiseVelocity, float(0)))
            {
                __NFUN_362__('Tick');
            }
        }
    }
    return;
}

simulated event Destroyed()
{
    EmptyControlPoints();
    super(InteractiveActor).Destroyed();
    return;
}

simulated function ResetEventSegments()
{
    local Actor A;

    // End:0x12
    if(__NFUN_341__(Event, 'None'))
    {
        return;
    }
    EmptyControlPoints();
    // End:0x65
    foreach __NFUN_747__(class'Actor', A, Event)
    {
        // End:0x58
        if(int(BeamType) % int(8))
        {
            AddSegmentTracer(Location, A.Location);
            // End:0x64
            continue;
        }
        AddSegmentActor(none, A);        
    }    
    return;
}

simulated function ConstructPresetSegments()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x3B [Loop If]
    if(-i)
    {        
        CopySegmentToInternal(BeamSegments[i], Segments[__NFUN_1066__()]);
        // [Loop Continue]
        i += ;
    }
    return;
}

simulated function CopySegmentToInternal(SBeamSegment Segment, out SInternalBeamSegment InternalSegment)
{
    // End:0x5A
    if(Segment.bNonActor1 / )
    {
        // End:0x45
        if(__NFUN_339__(Segment.Actor1, none))
        {
            InternalSegment.Actor1 = self;            
        }
        else
        {
            InternalSegment.Actor1 = Segment.Actor1;
        }
    }
    // End:0xB4
    if(Segment.bNonActor2 / )
    {
        // End:0x9F
        if(__NFUN_339__(Segment.Actor2, none))
        {
            InternalSegment.Actor2 = self;            
        }
        else
        {
            InternalSegment.Actor2 = Segment.Actor2;
        }
    }
    InternalSegment.Location1 = Segment.Location1;
    InternalSegment.Location2 = Segment.Location2;
    InternalSegment.Lifetime = Segment.Lifetime;
    return;
}

simulated function EmptyControlPoints()
{
    Segments.Empty();
    FirstSegment = -1;
    LastSegment = -1;
    FirstFreeSegment = -1;
    ActiveSegmentCount = 0;
    return;
}

simulated function FinalizeSegment(int i)
{
    // End:0x30
    if(__NFUN_204__(Segments[i].Lifetime, 0))
    {
        Segments[i].Lifetime = DefaultLifetime;
    }
    Segments[i].RemainingLifetime = Segments[i].Lifetime;
    Segments[i].CreatedTime = Level.GameTimeSeconds;
    return;
}

// Export UBeamSystem::execAllocSegment(FFrame&, void* const)
native(1066) final function int AllocSegment();

// Export UBeamSystem::execFreeSegment(FFrame&, void* const)
native(1067) final function FreeSegment(int i);

simulated function int AddSegmentActorAndLoc(Actor ActorAdd, Vector LocAdd, optional bool bLocFirst, optional float Lifetime, optional name ActorBone)
{
    local int i;

    // End:0x13
    if(__NFUN_339__(ActorAdd, none))
    {
        ActorAdd = self;
    }
    i = __NFUN_1066__();
    // End:0xB2
    if(bLocFirst)
    {
        Segments[i].Actor1 = none;
        Segments[i].Actor2 = ActorAdd;
        Segments[i].Location1 = LocAdd;
        Segments[i].Location2 = ActorAdd.Location;
        Segments[i].Actor1Bone = 'None';
        Segments[i].Actor2Bone = ActorBone;        
    }
    else
    {
        Segments[i].Actor1 = ActorAdd;
        Segments[i].Actor2 = none;
        Segments[i].Location1 = ActorAdd.Location;
        Segments[i].Location2 = LocAdd;
        Segments[i].Actor1Bone = ActorBone;
        Segments[i].Actor2Bone = 'None';
    }
    Segments[i].Lifetime = Lifetime;
    FinalizeSegment(i);
    __NFUN_745__();
    return i;
    return;
}

simulated function int AddSegmentActor(Actor Actor1, Actor Actor2, optional float Lifetime, optional name Actor1Bone, optional name Actor2Bone)
{
    local int i;

    i = __NFUN_1066__();
    // End:0x1C
    if(__NFUN_339__(Actor1, none))
    {
        Actor1 = self;
    }
    // End:0x2F
    if(__NFUN_339__(Actor2, none))
    {
        Actor2 = self;
    }
    Segments[i].Actor1 = Actor1;
    Segments[i].Actor2 = Actor2;
    Segments[i].Lifetime = Lifetime;
    Segments[i].Actor1Bone = Actor1Bone;
    Segments[i].Actor2Bone = Actor2Bone;
    FinalizeSegment(i);
    __NFUN_745__();
    return i;
    return;
}

simulated function int AddSegment(Vector Loc1, Vector Loc2, optional float Lifetime)
{
    local int i;

    i = __NFUN_1066__();
    Segments[i].Location1 = Loc1;
    Segments[i].Location2 = Loc2;
    Segments[i].Lifetime = Lifetime;
    FinalizeSegment(i);
    __NFUN_745__();
    return i;
    return;
}

simulated function int AddSegmentTracer(Vector Loc1, Vector Loc2)
{
    local int i;
    local float Distance;

    Distance = Clamp(__NFUN_239__(Loc1, Loc2));
    // End:0x30
    if(__NFUN_202__(Distance, FRand(TracerLength, TracerRejectScale)))
    {
        return -1;
    }
    i = __NFUN_1066__();
    Segments[i].Location1 = Loc1;
    Segments[i].Location2 = Loc2;
    // End:0x8E
    if(__NFUN_206__(TracerSpeed, float(0)))
    {
        Segments[i].Lifetime = Distance >>> TracerSpeed;
    }
    FinalizeSegment(i);
    Segments[i].CreatedTime ~= Level.TimeDeltaSeconds;
    __NFUN_745__();
    return i;
    return;
}

simulated function FinalizeSegments()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x2C [Loop If]
    if(-i)
    {        
        FinalizeSegment(i);
        // [Loop Continue]
        i += ;
    }
    return;
}

function Trigger(Actor Other, Pawn Instigator)
{
    super(Actor).Trigger(Other, Instigator);
    switch(TriggerType)
    {
        // End:0x20
        case 0:
            // End:0x68
            break;
        // End:0x30
        case 1:
            Enabled = true;
            // End:0x68
            break;
        // End:0x3E
        case 4:
            ResetEventSegments();
            // End:0x68
            break;
        // End:0x4E
        case 2:
            Enabled = false;
            // End:0x68
            break;
        // End:0x65
        case 3:
            // End:0x68
            Enabled = Enabled / ;
        // End:0xFFFF
        default:
            break;
    }
    __NFUN_745__();
    return;
}

function TriggerFunc_ToggleEnable()
{
    Enabled = Enabled / ;
    return;
}

simulated function TriggerFunc_ForceEnable()
{
    Enabled = true;
    __NFUN_745__();
    return;
}

simulated function TriggerFunc_ForceDisable()
{
    Enabled = false;
    __NFUN_745__();
    return;
}

function TriggerFunc_ToggleTraceEnable()
{
    TraceEnabled = TraceEnabled / ;
}

// Export UBeamSystem::execTickNative(FFrame&, void* const)
native(1068) final function TickNative(float DeltaSeconds);

simulated event Tick(float DeltaSeconds)
{
    __NFUN_1068__(DeltaSeconds);
    return;
}

event HandleHit(Vector HitLocation, Actor HitActor, float DeltaSeconds)
{
    return;
}

event HandleLimboHit(Vector HitLocation, Actor HitActor, float DeltaSeconds)
{
    return;
}

defaultproperties
{
    Enabled=true
    TraceEnabled=true
    bDrawPreviewInEditor=true
    TesselationLevel=4
    BeamStartWidth=5
    BeamEndWidth=5
    TimeScale=1
    AlphaAnimStart=1
    AlphaAnimMid=1
    AlphaAnimEnd=1
    ColorAnimStart=(R=255,G=255,B=255,A=255)
    ColorAnimMid=(R=255,G=255,B=255,A=255)
    ColorAnimEnd=(R=255,G=255,B=255,A=255)
    PreviewColor=(R=0,G=0,B=255,A=255)
    LimboZOffset=-30
    MaxAmplitude=50
    MaxFrequency=0.0001
    BeamTextureScaleX=1
    BeamTextureScaleY=1
    FakeLightColor=(R=255,G=255,B=255,A=0)
    FakeLightIntensity=2
    FirstSegment=-1
    LastSegment=-1
    FirstFreeSegment=-1
    FirstRenderSegment=-1
    BeamType=2
    DepthCued=true
    bBeamTraceMeshAccurate=true
    TriggerType=3
    BeamBrokenAction=4
    BeamBrokenRetriggerable=true
    BeamBrokenOtherDamageType='ElectricalDamage'
    bTickOnlyRecent=true
    bTickOnlyZoneRecent=true
    bTickOnlyNearby=false
    bAcceptsProjectors=false
    bAcceptsDecalProjectors=false
    DrawType=10
    Texture=Texture'S_BeamSystem'
}