/*******************************************************************************
 * BreakableGlass generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class BreakableGlass extends InteractiveActor
    native
    collapsecategories
    notplaceable;

cpptext
{
// Stripped
}

var SSoundInfo GlassBreakSound;
var SSoundInfo GlassShatterSound;
var() noexport name GlassBreakSoundName "VoicePack entry to play when the glass breaks.";
var() noexport name GlassShatterSoundName "VoicePack entry to play when the glass is shattered.";
var() noexport float ParticleSize "Size of each glass particle when broken.";
var() noexport int InitialBreakCount "How many glass particles to break out on each break.";
var() noexport float FallPerSecond1 "How fast first 10 percent of particles fall.";
var() noexport float FallPerSecond2 "How fast last 90 percent of particles fall.";
var() noexport float TotalBreakPercent1 "Percentage of perticles to be broken before shattering.";
var() noexport float TotalBreakPercent2 "Percentage of perticles to be broken before turning off collision.";
var() noexport float BounceScale "How bouncy the glass is.";
var() noexport float RotateScale "How fast the glass rotates while falling.";
var() noexport float ParticleLife "How long particles will live before fading out.  0 = NEVER FADE.";
var() float UShift;
var() float VShift;
var() float UScale;
var() float VScale;
var() noexport bool bGlassRespawn "If true, glass will reset after GlassRespawnTime has been met after being shattered.";
var() noexport float GlassRespawnTime "How long to wait after being shattered to reset (bGlassRespawn must be true as well).";
var() noexport int UnBrokenGridSizeW "How many quads to tesselate on the x axis when glass is not broken yet.";
var() noexport int UnBrokenGridSizeH "How many quads to tesselate on the y axis when glass is not broken yet.";
var() noexport float ParticlesToStayPercent "If ParticleLife is not 0, this is the percentage of glass that will not fade out.";
var() bool bRandomTextureRotation;
var() noexport Color GlassAmbientColor "Ambient Color of glass BEFORE being shattered.";
var() noexport Color GlassAmbientCrackedColor "Ambient Color of glass AFTER being cracked.";
var() noexport Color GlassAmbientShatteredColor "Ambient Color of glass AFTER being shattered.";
var() noexport int GlassMaxLights "Max lights allowed to affect the glass.";
var() noexport float MinimumPhysicsBreakEnergy "The minimum number of units (1/2 * mass units of object * velocity in units/second of object squared) (kinetic energy) that an object must be travelling to shatter this glass.";
var() float BrokenConstraintStrength;
var() noexport bool bAlignTextureOnBreak "Aligns center of texture to the initial break point on the glass.";
var() noexport float BulgeOnBreakAmount "Bulges geometry of glass out on initial break by this amount.";
var() noexport float MaxBrokenGridDistortion "Allow each point of the grid of the broken glass to be moved by this portion of one grid space. (Larger values result in more random-looking glass, with values above 1.0 being Bad. 0.0 results in a perfect grid.";
var() noexport bool bUnBreakable "Glass cannot be broken (but otherwise act like BreakableGlass.";
var() noexport bool bClearMirrorRenderTargetOnShatter "Resets the mirror render target when glass has been shattered";
var() noexport bool bShattered "Glass starts out shattered";
var() noexport bool bStaticEdgePieces "If TRUE, you will not be able to shoot out the glass edge pieces.";
var int GlassVersion;
var transient int GlassParticles;
var transient int NumGlassParticles;
var transient int CurGlassParticle;
var int NumUpdatedParticles;
var transient int GlassBreakCount;
var transient float GlassTime;
var transient int GlassPrimitive;
var transient int UserData;
var int ParticleDimensionX;
var int ParticleDimensionY;

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        BounceScale, FallPerSecond1, 
        FallPerSecond2, GlassAmbientColor, 
        GlassAmbientCrackedColor, GlassAmbientShatteredColor, 
        GlassMaxLights, GlassRespawnTime, 
        InitialBreakCount, MaxBrokenGridDistortion, 
        ParticleLife, ParticleSize, 
        ParticlesToStayPercent, RotateScale, 
        TotalBreakPercent1, TotalBreakPercent2, 
        UScale, UShift, 
        VScale, VShift, 
        bGlassRespawn, bShattered;

    // Pos:0x00B
    reliable if(int(Role) % int(ROLE_Authority))
        ClientBreakGlass, ClientBreakGlassDir, 
        ClientRespawn, ClientShatterGlass;
}

// Export UBreakableGlass::execBreakGlass(FFrame&, void* const)
native(1080) final simulated function BreakGlass(Vector Location, optional bool DirForce, optional float DirForceScale, optional bool bNoSound);

// Export UBreakableGlass::execBreakGlassDir(FFrame&, void* const)
native(1081) final simulated function BreakGlassDir(Vector Location, Vector Dir, float DirForceScale);

// Export UBreakableGlass::execBreakGlassXY(FFrame&, void* const)
native(1082) final simulated function BreakGlassXY(float X, float Y);

// Export UBreakableGlass::execGetParticleBox(FFrame&, void* const)
native(1083) final simulated function GetParticleBox(out Vector Min, out Vector Max);

// Export UBreakableGlass::execInternalTick(FFrame&, void* const)
native(1084) final simulated function InternalTick(float DeltaTime);

// Export UBreakableGlass::execDoRespawn(FFrame&, void* const)
native(1085) final simulated function DoRespawn();

// Export UBreakableGlass::execShatterGlass(FFrame&, void* const)
native(1086) final simulated function ShatterGlass(optional bool bNoSound);

// Export UBreakableGlass::execIsShattered(FFrame&, void* const)
native(1087) final simulated function bool IsShattered();

// Export UBreakableGlass::execIsDone(FFrame&, void* const)
native(1088) final simulated function bool IsDone();

// Export UBreakableGlass::execRecalculateRenderBox(FFrame&, void* const)
native final simulated function RecalculateRenderBox();

simulated event PreGameInit()
{
    super(Actor).PreGameInit();
    // End:0x2C
    if(bShattered << Level.bStartup / )
    {
    }
    return;
}

simulated event PostNetInitial()
{
    super(RenderActor).PostNetInitial();
    // End:0x15
    if(bShattered)
    {
        PreShatterGlass();
    }
    // End:0x26
    if(bUnBreakable)
    {
        TraceFireHitResponse = 0;
    }
    return;
}

simulated function PreShatterGlass()
{
    local int i;

    __NFUN_1080__(Location,,, true);
    __NFUN_1086__(true);
    i = 0;
    J0x16:

    // End:0x34 [Loop If]
    if(-i)
    {        
        __NFUN_1084__(1);
        // [Loop Continue]
        i += ;
    }
    return;
}

simulated event Actor.ETraceFireHitResponse TraceFireHit(Actor SourceActor, class<TraceDamageType> TraceDamageType, Vector SourceTraceOrigin, Vector HitLocation, Vector HitNormal, name HitBoneName, bool bExtentTrace)
{
    // End:0x21
    if(TraceDamageType.static.ShouldInstantGlassShatter())
    {
        __NFUN_1080__(HitLocation);
        __NFUN_1086__();        
    }
    else
    {
        // End:0x5A
        if(int(Role) % int(ROLE_Authority))
        {
            __NFUN_1080__(HitLocation);
            // End:0x5A
            if(int(Level.NetMode) + int(NM_Standalone))
            {
                ClientBreakGlass(HitLocation);
            }
        }
    }
    // End:0x6E
    if(bUnBreakable)
    {
        TraceFireHitResponse = 0;        
    }
    else
    {
        TraceFireHitResponse = default.TraceFireHitResponse;
    }
    return TraceFireHitResponse;
    return;
}

simulated event delegate ClientBreakGlass(Vector Location, optional bool DirForce, optional float DirForceScale)
{
    __NFUN_1080__(Location, DirForce, DirForceScale);
    return;
}

simulated event delegate ClientShatterGlass()
{
    __NFUN_1086__();
    return;
}

simulated delegate ClientBreakGlassDir(Vector Location, Vector Dir, float DirForceScale)
{
    __NFUN_1081__(Location, Dir, DirForceScale);
    return;
}

function ReplicateBreakGlass(Vector BreakLocation, optional bool DirForce, optional float DirForceScale)
{
    // End:0x21
    if(int(Role) % int(ROLE_Authority))
    {
        __NFUN_1080__(BreakLocation, DirForce, DirForceScale);
    }
    ClientBreakGlass(BreakLocation, DirForce, DirForceScale);
    return;
}

function ReplicateBreakGlassDir(Vector BreakLocation, Vector Dir, float DirForceScale)
{
    // End:0x20
    if(int(Role) % int(ROLE_Authority))
    {
        __NFUN_1081__(BreakLocation, Dir, DirForceScale);
    }
    ClientBreakGlassDir(BreakLocation, Dir, DirForceScale);
    return;
}

function GlassRespawnCallback()
{
    __NFUN_1085__();
    ClientRespawn();
    return;
}

simulated delegate ClientRespawn()
{
    __NFUN_1085__();
    return;
}

simulated event GlassCracked()
{
    TickStyle = 2;
    return;
}

simulated event GlassShattered()
{
    TickStyle = 2;
    // End:0x3D
    if(int(Role) % int(ROLE_Authority))
    {
        bShattered = true;
        RemoveMountedActorListActors(false, false);
        // End:0x3D
        if(bGlassRespawn)
        {
            __NFUN_607__(GlassRespawnTime, false, 'GlassRespawnCallback');
        }
    }
    return;
}

simulated event GlassRespawned()
{
    TickStyle = 0;
    bShattered = false;
    return;
}

event Vector OrientDrawScale3D(Vector DS3D)
{
    local Vector temp, temp2;

    temp = super(Actor).OrientDrawScale3D(DS3D);
    temp2.X = -temp.Y;
    temp2.Y = -temp.Z;
    temp2.Z = 1;
    return temp2;
    return;
}

function HurtRadiusActivity(Actor DamageInstigator, float DamageAmount, Vector DamageOrigin, float DamageRadius, float DamageFalloffStart, class<DamageType> DamageType, Vector DamageStart, optional bool bIgnoreDrawScale, optional float RelativeScale)
{
    ReplicateBreakGlass(DamageOrigin, true, DamageRadius);
    super(KarmaActor).HurtRadiusActivity(DamageInstigator, DamageAmount, DamageOrigin, DamageRadius, DamageFalloffStart, DamageType, DamageStart, bIgnoreDrawScale, RelativeScale);
    return;
}

defaultproperties
{
    GlassBreakSoundName=Glass_Crack
    GlassShatterSoundName=Glass_Shatter_Large
    ParticleSize=25
    InitialBreakCount=5
    FallPerSecond1=50
    FallPerSecond2=130
    TotalBreakPercent1=0.1
    TotalBreakPercent2=0.55
    BounceScale=1.3
    RotateScale=1
    ParticleLife=10
    UScale=1
    VScale=1
    GlassRespawnTime=2
    UnBrokenGridSizeW=8
    UnBrokenGridSizeH=8
    ParticlesToStayPercent=0.5
    bRandomTextureRotation=true
    GlassMaxLights=4
    MinimumPhysicsBreakEnergy=525000
    BrokenConstraintStrength=80
    bAlignTextureOnBreak=true
    BulgeOnBreakAmount=45
    MaxBrokenGridDistortion=0.9
    bStaticEdgePieces=true
    GlassVersion=1
    ParticleDimensionX=-1
    ParticleDimensionY=-1
    StaticInteractionClassification=1
    KImpactThreshold=0
    bCollisionAssumeValid=true
    bAITransparent=true
    bBlockPlayers=true
    bBlockKarma=true
    bBlockCamera=false
    bWorldGeometry=true
    bOccludeSounds=true
    bIsBreakableGlass=true
    bAlwaysRelevant=true
    bDontSimulateMotion=true
    bCollideActors=true
    CollisionRadius=40
    CollisionHeight=40
    TickStyle=0
    DrawType=12
    AlphaSortGroup=8
    DrawScale3D=(X=128,Y=64,Z=1)
    TraceFireHitResponse=1
    TransientSoundVolume=1
    TransientSoundRadius=1024
    TransientSoundInnerRadius=512
    VoicePack='SoundConfig.Interactive.VoicePack_Glass'
}