/*******************************************************************************
 * ChallengeInfo generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class ChallengeInfo extends Info
    abstract
    native
    config(ChallengeInfo)
    collapsecategories
    notplaceable
    hidecategories(movement,Collision,Lighting,LightColor);

cpptext
{
// Stripped
}

struct ChallengeInfoStruct
{
    var int ChallengeID;
    var string ChallObjClass;
    var transient ChallengeObject ChallObj;
    var array<int> ChallDependencies;
    var Object.EMPStatistics StatDependency;
    var string ExtraOptions;
    var string Name;
    var string Description;
    var string HelpText;
    var int EXPBonus;
    var name SearchTag;
    var string AttachMesh;
    var name AttachBone;
    var string image;
    var int LockedImageIdx;
    var Object.EChallengeCustomizeCategory Category;
    var int ShirtColorIdx;
    var int TitleIdx;
    var string AMName;
    var bool IsPurchased;
};

struct PreorderGroupStruct
{
    var Object.EPreorderGroup Group;
    var array<int> IDs;
    var bool bUnlockDBP;
};

struct TitleValues
{
    var int id;
    var string Tag;
};

struct LevelingStatXPValues
{
    var Object.EMPStatistics Stat;
    var int XPAmount;
    var string LocTag;
};

var config array<ChallengeInfoStruct> ChallengesArray;
var int NoDLCChallengeArraySize;
var int PlainShirtId;
var int NoHadId;
var int DefaultGlassesId;
var int WhiteColourId;
var int NoTitleID;
var int EndofDefaultUnlocks;
var bool bInit;
var config array<PreorderGroupStruct> PreorderGroups;
var config int DeveloperGroupIdx;
var config array<TitleValues> PlayerTitles;
var config array<LevelingStatXPValues> LevelingInfo;
var config array<int> XPToLevel;

// Export UChallengeInfo::execStaticInit(FFrame&, void* const)
native(1168) static final function StaticInit();

// Export UChallengeInfo::execGetChallengeIdxFromID(FFrame&, void* const)
native(1169) static final function int GetChallengeIdxFromID(int id);

static simulated function int GetTitleIdxFromID(int id)
{
    local int i;

    i = 0;
    J0x07:

    // End:0x55 [Loop If]
    if(-i)
    {        
        // End:0x4B
        if(class'ChallengeInfo'.default.PlayerTitles[i].id % id)
        {
            return i;
        }
        // [Loop Continue]
        i *= ;
    }
    return -1;
    return;
}

// Export UChallengeInfo::execIsEnterBonusCodeMenuItemEnabled(FFrame&, void* const)
native(1170) static final function bool IsEnterBonusCodeMenuItemEnabled();

// Export UChallengeInfo::execTryBonusCode(FFrame&, void* const)
native(1171) static final function bool TryBonusCode(string in_Code, out string out_Title, out string out_Description);

// Export UChallengeInfo::execUnlockPreorderGroupIncludesDBP(FFrame&, void* const)
native(1172) static final function bool UnlockPreorderGroupIncludesDBP(Object.EPreorderGroup in_POG);

// Export UChallengeInfo::execUnlockPreorderBonuses(FFrame&, void* const)
native(1173) static final function UnlockPreorderBonuses(Object.EPreorderGroup in_POG);

// Export UChallengeInfo::execUnlockPreorderGroup(FFrame&, void* const)
native(1174) static final function UnlockPreorderGroup(Object.EPreorderGroup in_POG);

static final event CodeUnlockedPreorderGroup(Object.EPreorderGroup in_POG, out string out_Title, out string out_Description)
{
    out_Title = "";
    out_Description = __NFUN_356__("PreorderUnlocks", __NFUN_302__(__NFUN_302__("ShirtName[", string(__NFUN_365__(Enum'EPreorderGroup', int(in_POG)))), "]"), "dnWindow");
    // End:0x71
    if(__NFUN_314__(out_Description) ** 0)
    {
        out_Description = __NFUN_302__(out_Description, " \\n");
    }
    out_Description = __NFUN_302__(out_Description, __NFUN_356__("PreorderUnlocks", "DeveloperShirtsList", "dnWindow"));
    // End:0x106
    if(__NFUN_1172__(in_POG))
    {
        out_Description = __NFUN_302__(__NFUN_302__(out_Description, " \\n"), __NFUN_356__("PreorderUnlocks", "DukesBigPackageList", "dnWindow"));
    }
    __NFUN_1173__(in_POG);
    return;
}

defaultproperties
{
    ChallengesArray(0)=(ChallengeID=0,ChallObjClass="dnGame.ChallengeObject_Unlocked",ChallDependencies=none,StatDependency=0,ExtraOptions="?Default=Show",Name="DukeShades",Description="DukeShadesDesc",HelpText="DukeShadesHelp",EXPBonus=0,SearchTag=fred,AttachMesh="sm_class_dukeitems.Glasses.Dukes_Glasses",AttachBone=mount_glasses,image="Changeroom.Menu.dukes_glasses_stock",LockedImageIdx=0,Category=3,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(1)=(ChallengeID=1,ChallObjClass="dnGame.ChallengeObject_Unlocked",ChallDependencies=none,StatDependency=0,ExtraOptions="?Default=Show",Name="PlainShirt",Description="PlainShirtDesc",HelpText="PlainShirtHelp",EXPBonus=0,SearchTag=fred,AttachMesh="",AttachBone=None,image="Changeroom.Menu.Duke_Shirt_Icon_01",LockedImageIdx=0,Category=4,ShirtColorIdx=1,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp.Duke_Shirt_D_01",IsPurchased=true)
    ChallengesArray(2)=(ChallengeID=2,ChallObjClass="dnGame.ChallengeObject_Unlocked",ChallDependencies=none,StatDependency=0,ExtraOptions="?Default=Show",Name="NoHat",Description="NoHatDesc",HelpText="NoHatHelp",EXPBonus=0,SearchTag=fred,AttachMesh="",AttachBone=None,image="Changeroom.Menu.dukes_hats_none",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(3)=(ChallengeID=262,ChallObjClass="dnGame.ChallengeObject_Unlocked",ChallDependencies=none,StatDependency=0,ExtraOptions="?Default=Show",Name="NoTitle",Description="NoTitleDesc",HelpText="NoTitleHelp",EXPBonus=0,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(4)=(ChallengeID=3,ChallObjClass="dnGame.ChallengeObject_Unlocked",ChallDependencies=none,StatDependency=0,ExtraOptions="?Default=Show",Name="White",Description="WhiteDesc",HelpText="",EXPBonus=0,SearchTag=None,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=6,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(5)=(ChallengeID=4,ChallObjClass="dnGame.ChallengeObject_Unlocked",ChallDependencies=none,StatDependency=0,ExtraOptions="",Name="Red",Description="RedDesc",HelpText="",EXPBonus=0,SearchTag=None,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=6,ShirtColorIdx=1,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(6)=(ChallengeID=5,ChallObjClass="dnGame.ChallengeObject_Unlocked",ChallDependencies=none,StatDependency=0,ExtraOptions="",Name="Pink",Description="PinkDesc",HelpText="",EXPBonus=0,SearchTag=None,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=6,ShirtColorIdx=2,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(7)=(ChallengeID=6,ChallObjClass="dnGame.ChallengeObject_Unlocked",ChallDependencies=none,StatDependency=0,ExtraOptions="",Name="Purple",Description="PurpleDesc",HelpText="",EXPBonus=0,SearchTag=None,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=6,ShirtColorIdx=3,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(8)=(ChallengeID=7,ChallObjClass="dnGame.ChallengeObject_Unlocked",ChallDependencies=none,StatDependency=0,ExtraOptions="",Name="Blue",Description="BlueDesc",HelpText="",EXPBonus=0,SearchTag=None,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=6,ShirtColorIdx=4,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(9)=(ChallengeID=8,ChallObjClass="dnGame.ChallengeObject_Unlocked",ChallDependencies=none,StatDependency=0,ExtraOptions="",Name="Turqoise",Description="TurqoiseDesc",HelpText="",EXPBonus=0,SearchTag=None,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=6,ShirtColorIdx=5,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(10)=(ChallengeID=9,ChallObjClass="dnGame.ChallengeObject_Unlocked",ChallDependencies=none,StatDependency=0,ExtraOptions="",Name="Green",Description="GreenDesc",HelpText="",EXPBonus=0,SearchTag=None,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=6,ShirtColorIdx=6,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(11)=(ChallengeID=10,ChallObjClass="dnGame.ChallengeObject_Unlocked",ChallDependencies=none,StatDependency=0,ExtraOptions="",Name="Yellow",Description="YellowDesc",HelpText="",EXPBonus=0,SearchTag=None,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=6,ShirtColorIdx=7,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(12)=(ChallengeID=11,ChallObjClass="dnGame.ChallengeObject_Unlocked",ChallDependencies=none,StatDependency=0,ExtraOptions="",Name="Orange",Description="OrangeDesc",HelpText="",EXPBonus=0,SearchTag=None,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=6,ShirtColorIdx=8,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(13)=(ChallengeID=12,ChallObjClass="dnGame.ChallengeObject_Unlocked",ChallDependencies=none,StatDependency=0,ExtraOptions="",Name="Grey",Description="GreyDesc",HelpText="",EXPBonus=0,SearchTag=None,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=6,ShirtColorIdx=9,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(14)=(ChallengeID=13,ChallObjClass="dnGame.ChallengeObject_Unlocked",ChallDependencies=none,StatDependency=0,ExtraOptions="",Name="Olive",Description="OliveDesc",HelpText="",EXPBonus=0,SearchTag=None,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=6,ShirtColorIdx=10,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(15)=(ChallengeID=14,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=36,ExtraOptions="?Threshold=10",Name="WatchYourStep",Description="WatchYourStepDesc",HelpText="WatchYourStepHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(16)=(ChallengeID=15,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=36,ExtraOptions="?Threshold=25",Name="WatchYourStepII",Description="WatchYourStepIIDesc",HelpText="WatchYourStepIIHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(17)=(ChallengeID=16,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=36,ExtraOptions="?Threshold=75",Name="WatchYourStepIII",Description="WatchYourStepIIIDesc",HelpText="WatchYourStepIIIHelp",EXPBonus=750,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_jester",AttachBone=mount_glasses,image="Changeroom.menu.dukes_hats_jester",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(18)=(ChallengeID=17,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=36,ExtraOptions="?Threshold=200",Name="WatchYourStepIV",Description="WatchYourStepIVDesc",HelpText="WatchYourStepIVHelp",EXPBonus=2000,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=1,AMName="",IsPurchased=true)
    ChallengesArray(19)=(ChallengeID=18,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=29,ExtraOptions="?Threshold=10",Name="SplatterKing",Description="SplatterKingDesc",HelpText="SplatterKingHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(20)=(ChallengeID=19,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=29,ExtraOptions="?Threshold=25",Name="SplatterKingII",Description="SplatterKingIIDesc",HelpText="SplatterKingIIHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=false)
    ChallengesArray(21)=(ChallengeID=20,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=29,ExtraOptions="?Threshold=75",Name="SplatterKingIII",Description="SplatterKingIIIDesc",HelpText="SplatterKingIIIHelp",EXPBonus=750,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_cap",AttachBone=mount_glasses,image="Changeroom.menu.dukes_hats_cap",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(22)=(ChallengeID=21,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=29,ExtraOptions="?Threshold=200",Name="SplatterKingIV",Description="SplatterKingIVDesc",HelpText="SplatterKingIVHelp",EXPBonus=2000,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=2,AMName="",IsPurchased=true)
    ChallengesArray(23)=(ChallengeID=22,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=5,ExtraOptions="?Threshold=10",Name="PunchyMcPuncher",Description="PunchyMcPuncherDesc",HelpText="PunchyMcPuncherHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(24)=(ChallengeID=23,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=5,ExtraOptions="?Threshold=25",Name="PunchyMcPuncherII",Description="PunchyMcPuncherIIDesc",HelpText="PunchyMcPuncherIIHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(25)=(ChallengeID=24,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=5,ExtraOptions="?Threshold=75",Name="PunchyMcPuncherIII",Description="PunchyMcPuncherIIIDesc",HelpText="PunchyMcPuncherIIIHelp",EXPBonus=750,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_hoplite",AttachBone=mount_glasses,image="Changeroom.menu.dukes_hats_hoplite",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(26)=(ChallengeID=25,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=5,ExtraOptions="?Threshold=200",Name="PunchyMcPuncherIV",Description="PunchyMcPuncherIVDesc",HelpText="PunchyMcPuncherIVHelp",EXPBonus=2000,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=3,AMName="",IsPurchased=true)
    ChallengesArray(27)=(ChallengeID=26,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=117,ExtraOptions="?Threshold=10",Name="RoidRage",Description="RoidRageDesc",HelpText="RoidRageHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(28)=(ChallengeID=27,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=117,ExtraOptions="?Threshold=25",Name="RoidRageII",Description="RoidRageIIDesc",HelpText="RoidRageIIHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(29)=(ChallengeID=28,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=117,ExtraOptions="?Threshold=75",Name="RoidRageIII",Description="RoidRageIIIDesc",HelpText="RoidRageIIIHelp",EXPBonus=750,SearchTag=fred,AttachMesh="",AttachBone=None,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_09",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_09",IsPurchased=true)
    ChallengesArray(30)=(ChallengeID=29,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=117,ExtraOptions="?Threshold=200",Name="RoidRageIV",Description="RoidRageIVDesc",HelpText="RoidRageIVHelp",EXPBonus=2000,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=4,AMName="",IsPurchased=true)
    ChallengesArray(31)=(ChallengeID=30,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=30,ExtraOptions="?Threshold=25",Name="SizeDoesn'tMatter",Description="SizeDoesn'tMatterDesc",HelpText="SizeDoesn'tMatterHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(32)=(ChallengeID=31,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=30,ExtraOptions="?Threshold=100",Name="SizeDoesn'tMatterII",Description="SizeDoesn'tMatterIIDesc",HelpText="SizeDoesn'tMatterIIHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(33)=(ChallengeID=32,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=30,ExtraOptions="?Threshold=250",Name="SizeDoesn'tMatterIII",Description="SizeDoesn'tMatterIIIDesc",HelpText="SizeDoesn'tMatterIIIHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_military",AttachBone=mount_glasses,image="Changeroom.menu.dukes_hats_military",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(34)=(ChallengeID=33,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=30,ExtraOptions="?Threshold=1000",Name="SizeDoesn'tMatterIV",Description="SizeDoesn'tMatterIVDesc",HelpText="SizeDoesn'tMatterIVHelp",EXPBonus=10000,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=5,AMName="",IsPurchased=true)
    ChallengesArray(35)=(ChallengeID=34,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=33,ExtraOptions="?Threshold=25",Name="BurgerFace",Description="BurgerFaceDesc",HelpText="BurgerFaceHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(36)=(ChallengeID=35,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=33,ExtraOptions="?Threshold=100",Name="BurgerFaceII",Description="BurgerFaceIIDesc",HelpText="BurgerFaceIIHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(37)=(ChallengeID=36,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=33,ExtraOptions="?Threshold=250",Name="BurgerFaceIII",Description="BurgerFaceIIIDesc",HelpText="BurgerFaceIIIHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_capbw",AttachBone=mount_glasses,image="Changeroom.menu.dukes_hats_capbw",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(38)=(ChallengeID=37,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=33,ExtraOptions="?Threshold=1000",Name="BurgerFaceIV",Description="BurgerFaceIVDesc",HelpText="BurgerFaceIVHelp",EXPBonus=10000,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=6,AMName="",IsPurchased=true)
    ChallengesArray(39)=(ChallengeID=38,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=27,ExtraOptions="?Threshold=25",Name="SwissCheese",Description="SwissCheeseDesc",HelpText="SwissCheeseHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(40)=(ChallengeID=39,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=27,ExtraOptions="?Threshold=100",Name="SwissCheeseII",Description="SwissCheeseIIDesc",HelpText="SwissCheeseIIHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(41)=(ChallengeID=40,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=27,ExtraOptions="?Threshold=250",Name="SwissCheeseIII",Description="SwissCheeseIIIDesc",HelpText="SwissCheeseIIIHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_cheese",AttachBone=mount_glasses,image="Changeroom.menu.dukes_hats_cheese",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(42)=(ChallengeID=41,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=27,ExtraOptions="?Threshold=1000",Name="SwissCheeseIV",Description="SwissCheeseIVDesc",HelpText="SwissCheeseIVHelp",EXPBonus=10000,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=7,AMName="",IsPurchased=true)
    ChallengesArray(43)=(ChallengeID=42,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=26,ExtraOptions="?Threshold=25",Name="Loser-SeekingMissiles",Description="Loser-SeekingMissilesDesc",HelpText="Loser-SeekingMissilesHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(44)=(ChallengeID=43,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=26,ExtraOptions="?Threshold=100",Name="Loser-SeekingMissilesII",Description="Loser-SeekingMissilesIIDesc",HelpText="Loser-SeekingMissilesIIHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(45)=(ChallengeID=44,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=26,ExtraOptions="?Threshold=250",Name="Loser-SeekingMissilesIII",Description="Loser-SeekingMissilesIIIDesc",HelpText="Loser-SeekingMissilesIIIHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_brainslug",AttachBone=mount_glasses,image="Changeroom.menu.dukes_hats_brainslug",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(46)=(ChallengeID=45,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=26,ExtraOptions="?Threshold=1000",Name="Loser-SeekingMissilesIV",Description="Loser-SeekingMissilesIVDesc",HelpText="Loser-SeekingMissilesIVHelp",EXPBonus=10000,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=9,AMName="",IsPurchased=true)
    ChallengesArray(47)=(ChallengeID=46,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=25,ExtraOptions="?Threshold=25",Name="MeatGrinder",Description="MeatGrinderDesc",HelpText="MeatGrinderHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(48)=(ChallengeID=47,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=25,ExtraOptions="?Threshold=100",Name="MeatGrinderII",Description="MeatGrinderIIDesc",HelpText="MeatGrinderIIHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(49)=(ChallengeID=48,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=25,ExtraOptions="?Threshold=250",Name="MeatGrinderIII",Description="MeatGrinderIIIDesc",HelpText="MeatGrinderIIIHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="",AttachBone=None,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_05",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_05",IsPurchased=true)
    ChallengesArray(50)=(ChallengeID=49,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=25,ExtraOptions="?Threshold=1000",Name="MeatGrinderIV",Description="MeatGrinderIVDesc",HelpText="MeatGrinderIVHelp",EXPBonus=10000,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=10,AMName="",IsPurchased=true)
    ChallengesArray(51)=(ChallengeID=50,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=24,ExtraOptions="?Threshold=25",Name="MediumRare",Description="MediumRareDesc",HelpText="MediumRareHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(52)=(ChallengeID=51,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=24,ExtraOptions="?Threshold=100",Name="MediumRareII",Description="MediumRareIIDesc",HelpText="MediumRareIIHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(53)=(ChallengeID=52,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=24,ExtraOptions="?Threshold=250",Name="MediumRareIII",Description="MediumRareIIIDesc",HelpText="MediumRareIIIHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="",AttachBone=None,image="Changeroom.Menu.Duke_Shirt_Icon_03",LockedImageIdx=0,Category=4,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp.Duke_Shirt_D_03",IsPurchased=true)
    ChallengesArray(54)=(ChallengeID=53,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=24,ExtraOptions="?Threshold=1000",Name="MediumRareIV",Description="MediumRareIVDesc",HelpText="MediumRareIVHelp",EXPBonus=10000,SearchTag=fred,AttachMesh="",AttachBone=None,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=11,AMName="",IsPurchased=true)
    ChallengesArray(55)=(ChallengeID=58,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=31,ExtraOptions="?Threshold=25",Name="RightintheEye",Description="RightintheEyeDesc",HelpText="RightintheEyeHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(56)=(ChallengeID=59,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=31,ExtraOptions="?Threshold=100",Name="RightintheEyeII",Description="RightintheEyeIIDesc",HelpText="RightintheEyeIIHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(57)=(ChallengeID=60,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=31,ExtraOptions="?Threshold=250",Name="RightintheEyeIII",Description="RightintheEyeIIIDesc",HelpText="RightintheEyeIIIHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_04",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_04",IsPurchased=true)
    ChallengesArray(58)=(ChallengeID=61,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=31,ExtraOptions="?Threshold=1000",Name="RightintheEyeIV",Description="RightintheEyeIVDesc",HelpText="RightintheEyeIVHelp",EXPBonus=10000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=13,AMName="",IsPurchased=true)
    ChallengesArray(59)=(ChallengeID=62,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=37,ExtraOptions="?Threshold=10",Name="IcetoSeeYou",Description="IcetoSeeYouDesc",HelpText="IcetoSeeYouHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(60)=(ChallengeID=63,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=37,ExtraOptions="?Threshold=25",Name="IcetoSeeYouII",Description="IcetoSeeYouIIDesc",HelpText="IcetoSeeYouIIHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(61)=(ChallengeID=64,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=37,ExtraOptions="?Threshold=75",Name="IcetoSeeYouIII",Description="IcetoSeeYouIIIDesc",HelpText="IcetoSeeYouIIIHelp",EXPBonus=750,SearchTag=fred,AttachMesh="sm_class_dukeitems.Glasses.Dukes_Glasses_Snow",AttachBone=mount_glasses,image="Changeroom.menu.Dukes_Glasses_Snow",LockedImageIdx=0,Category=3,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(62)=(ChallengeID=65,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=37,ExtraOptions="?Threshold=200",Name="IcetoSeeYouIV",Description="IcetoSeeYouIVDesc",HelpText="IcetoSeeYouIVHelp",EXPBonus=2000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=14,AMName="",IsPurchased=true)
    ChallengesArray(63)=(ChallengeID=66,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=79,ExtraOptions="?Threshold=10",Name="PeeWeeVermin",Description="PeeWeeVerminDesc",HelpText="PeeWeeVerminHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(64)=(ChallengeID=67,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=79,ExtraOptions="?Threshold=25",Name="PeeWeeVerminII",Description="PeeWeeVerminIIDesc",HelpText="PeeWeeVerminIIHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(65)=(ChallengeID=68,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=79,ExtraOptions="?Threshold=75",Name="PeeWeeVerminIII",Description="PeeWeeVerminIIIDesc",HelpText="PeeWeeVerminIIIHelp",EXPBonus=750,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_unclesam",AttachBone=mount_glasses,image="Changeroom.menu.dukes_hats_unclesam",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(66)=(ChallengeID=69,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=79,ExtraOptions="?Threshold=200",Name="PeeWeeVerminIV",Description="PeeWeeVerminIVDesc",HelpText="PeeWeeVerminIVHelp",EXPBonus=2000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=15,AMName="",IsPurchased=true)
    ChallengesArray(67)=(ChallengeID=70,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=162,ExtraOptions="?Threshold=10",Name="SmileYouSonofaBitch",Description="SmileYouSonofaBitchDesc",HelpText="SmileYouSonofaBitchHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(68)=(ChallengeID=71,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=162,ExtraOptions="?Threshold=25",Name="SmileYouSonofaBitchII",Description="SmileYouSonofaBitchIIDesc",HelpText="SmileYouSonofaBitchIIHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(69)=(ChallengeID=72,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=162,ExtraOptions="?Threshold=75",Name="SmileYouSonofaBitchIII",Description="SmileYouSonofaBitchIIIDesc",HelpText="SmileYouSonofaBitchIIIHelp",EXPBonus=750,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_21",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_21",IsPurchased=true)
    ChallengesArray(70)=(ChallengeID=73,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=162,ExtraOptions="?Threshold=200",Name="SmileYouSonofaBitchIV",Description="SmileYouSonofaBitchIVDesc",HelpText="SmileYouSonofaBitchIVHelp",EXPBonus=2000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=16,AMName="",IsPurchased=true)
    ChallengesArray(71)=(ChallengeID=74,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=123,ExtraOptions="?Threshold=10",Name="TinyButDeadlyI",Description="TinyButDeadlyIDesc",HelpText="TinyButDeadlyIHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(72)=(ChallengeID=75,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=123,ExtraOptions="?Threshold=25",Name="TinyButDeadlyII",Description="TinyButDeadlyIIDesc",HelpText="TinyButDeadlyIIHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(73)=(ChallengeID=76,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=123,ExtraOptions="?Threshold=75",Name="TinyButDeadlyIII",Description="TinyButDeadlyIIIDesc",HelpText="TinyButDeadlyIIIHelp",EXPBonus=750,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_02",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_02",IsPurchased=true)
    ChallengesArray(74)=(ChallengeID=77,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=123,ExtraOptions="?Threshold=200",Name="TinyButDeadlyIV",Description="TinyButDeadlyIVDesc",HelpText="TinyButDeadlyIVHelp",EXPBonus=2000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=17,AMName="",IsPurchased=true)
    ChallengesArray(75)=(ChallengeID=78,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=137,ExtraOptions="?Threshold=10",Name="FlakYou",Description="FlakYouDesc",HelpText="FlakYouHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(76)=(ChallengeID=79,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=137,ExtraOptions="?Threshold=25",Name="FlakYouII",Description="FlakYouIIDesc",HelpText="FlakYouIIHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(77)=(ChallengeID=80,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=137,ExtraOptions="?Threshold=75",Name="FlakYouIII",Description="FlakYouIIIDesc",HelpText="FlakYouIIIHelp",EXPBonus=750,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_24",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_24",IsPurchased=true)
    ChallengesArray(78)=(ChallengeID=81,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=137,ExtraOptions="?Threshold=200",Name="FlakYouIV",Description="FlakYouIVDesc",HelpText="FlakYouIVHelp",EXPBonus=2000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=18,AMName="",IsPurchased=true)
    ChallengesArray(79)=(ChallengeID=82,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=87,ExtraOptions="?Threshold=600",Name="MileHighClub",Description="MileHighClubDesc",HelpText="MileHighClubHelp",EXPBonus=500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(80)=(ChallengeID=83,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=87,ExtraOptions="?Threshold=1800",Name="MileHighClubII",Description="MileHighClubIIDesc",HelpText="MileHighClubIIHelp",EXPBonus=1500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(81)=(ChallengeID=84,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=87,ExtraOptions="?Threshold=3600",Name="MileHighClubIII",Description="MileHighClubIIIDesc",HelpText="MileHighClubIIIHelp",EXPBonus=3000,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_10",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_10",IsPurchased=true)
    ChallengesArray(82)=(ChallengeID=85,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=87,ExtraOptions="?Threshold=5400",Name="MileHighClubIV",Description="MileHighClubIVDesc",HelpText="MileHighClubIVHelp",EXPBonus=4500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=19,AMName="",IsPurchased=true)
    ChallengesArray(83)=(ChallengeID=86,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=40,ExtraOptions="?Threshold=250",Name="FreeFallin'",Description="FreeFallin'Desc",HelpText="FreeFallin'Help",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(84)=(ChallengeID=87,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=40,ExtraOptions="?Threshold=750",Name="FreeFallin'II",Description="FreeFallin'IIDesc",HelpText="FreeFallin'IIHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(85)=(ChallengeID=88,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=40,ExtraOptions="?Threshold=1500",Name="FreeFallin'III",Description="FreeFallin'IIIDesc",HelpText="FreeFallin'IIIHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_18",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_18",IsPurchased=true)
    ChallengesArray(86)=(ChallengeID=89,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=40,ExtraOptions="?Threshold=2500",Name="FreeFallin'IV",Description="FreeFallin'IVDesc",HelpText="FreeFallin'IVHelp",EXPBonus=10000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=20,AMName="",IsPurchased=true)
    ChallengesArray(87)=(ChallengeID=90,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=84,ExtraOptions="?Threshold=500?ValueDivisor=100",Name="Marathon",Description="MarathonDesc",HelpText="MarathonHelp",EXPBonus=125,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(88)=(ChallengeID=91,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=84,ExtraOptions="?Threshold=1000?ValueDivisor=100",Name="MarathonII",Description="MarathonIIDesc",HelpText="MarathonIIHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(89)=(ChallengeID=92,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=84,ExtraOptions="?Threshold=5000?ValueDivisor=100",Name="MarathonIII",Description="MarathonIIIDesc",HelpText="MarathonIIIHelp",EXPBonus=1250,SearchTag=fred,AttachMesh="sm_class_dukeitems.Glasses.Dukes_Glasses_Sports",AttachBone=mount_glasses,image="Changeroom.menu.dukes_glasses_sports",LockedImageIdx=0,Category=3,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(90)=(ChallengeID=93,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=84,ExtraOptions="?Threshold=15000?ValueDivisor=100",Name="MarathonIV",Description="MarathonIVDesc",HelpText="MarathonIVHelp",EXPBonus=3750,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=21,AMName="",IsPurchased=true)
    ChallengesArray(91)=(ChallengeID=94,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=18,ExtraOptions="?Threshold=10",Name="ThatWasn'tMe",Description="ThatWasn'tMeDesc",HelpText="ThatWasn'tMeHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(92)=(ChallengeID=95,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=18,ExtraOptions="?Threshold=25",Name="ThatWasn'tMeII",Description="ThatWasn'tMeIIDesc",HelpText="ThatWasn'tMeIIHelp",EXPBonus=625,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(93)=(ChallengeID=96,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=18,ExtraOptions="?Threshold=75",Name="ThatWasn'tMeIII",Description="ThatWasn'tMeIIIDesc",HelpText="ThatWasn'tMeIIIHelp",EXPBonus=1875,SearchTag=fred,AttachMesh="sm_class_dukeitems.Glasses.Dukes_Glasses_3D",AttachBone=mount_glasses,image="Changeroom.menu.dukes_glasses_3D",LockedImageIdx=0,Category=3,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(94)=(ChallengeID=97,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=18,ExtraOptions="?Threshold=200",Name="ThatWasn'tMeIV",Description="ThatWasn'tMeIVDesc",HelpText="ThatWasn'tMeIVHelp",EXPBonus=5000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=22,AMName="",IsPurchased=true)
    ChallengesArray(95)=(ChallengeID=98,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=42,ExtraOptions="?Threshold=10",Name="PrescriptionOnly",Description="PrescriptionOnlyDesc",HelpText="PrescriptionOnlyHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(96)=(ChallengeID=99,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=42,ExtraOptions="?Threshold=25",Name="PrescriptionOnlyII",Description="PrescriptionOnlyIIDesc",HelpText="PrescriptionOnlyIIHelp",EXPBonus=625,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(97)=(ChallengeID=100,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=42,ExtraOptions="?Threshold=75",Name="PrescriptionOnlyIII",Description="PrescriptionOnlyIIIDesc",HelpText="PrescriptionOnlyIIIHelp",EXPBonus=1875,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_14",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_14",IsPurchased=true)
    ChallengesArray(98)=(ChallengeID=101,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=42,ExtraOptions="?Threshold=200",Name="PrescriptionOnlyIV",Description="PrescriptionOnlyIVDesc",HelpText="PrescriptionOnlyIVHelp",EXPBonus=5000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=23,AMName="",IsPurchased=true)
    ChallengesArray(99)=(ChallengeID=102,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=41,ExtraOptions="?Threshold=10",Name="ReallyThirsty",Description="ReallyThirstyDesc",HelpText="ReallyThirstyHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(100)=(ChallengeID=103,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=41,ExtraOptions="?Threshold=25",Name="ReallyThirstyII",Description="ReallyThirstyIIDesc",HelpText="ReallyThirstyIIHelp",EXPBonus=625,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(101)=(ChallengeID=104,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=41,ExtraOptions="?Threshold=75",Name="ReallyThirstyIII",Description="ReallyThirstyIIIDesc",HelpText="ReallyThirstyIIIHelp",EXPBonus=1875,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_beer",AttachBone=mount_glasses,image="Changeroom.menu.dukes_hats_beer",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(102)=(ChallengeID=105,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=41,ExtraOptions="?Threshold=200",Name="ReallyThirstyIV",Description="ReallyThirstyIVDesc",HelpText="ReallyThirstyIVHelp",EXPBonus=5000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=24,AMName="",IsPurchased=true)
    ChallengesArray(103)=(ChallengeID=106,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=153,ExtraOptions="?Threshold=7200",Name="DukeMatchVeteran",Description="DukeMatchVeteranDesc",HelpText="DukeMatchVeteranHelp",EXPBonus=500,SearchTag=fred,AttachMesh="",AttachBone=,,image="Changeroom.Menu.Duke_Shirt_Icon_02",LockedImageIdx=0,Category=4,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp.Duke_Shirt_D_02",IsPurchased=true)
    ChallengesArray(104)=(ChallengeID=107,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=154,ExtraOptions="?Threshold=7200",Name="TeamDukeMatchVeteran",Description="TeamDukeMatchVeteranDesc",HelpText="TeamDukeMatchVeteranHelp",EXPBonus=500,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_06",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_06",IsPurchased=true)
    ChallengesArray(105)=(ChallengeID=108,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=156,ExtraOptions="?Threshold=7200",Name="CapturetheBabeVeteran",Description="CapturetheBabeVeteranDesc",HelpText="CapturetheBabeVeteranHelp",EXPBonus=500,SearchTag=fred,AttachMesh="sm_class_dukeitems.Glasses.Dukes_Glasses_Hearts",AttachBone=mount_glasses,image="Changeroom.menu.Dukes_Glasses_Hearts",LockedImageIdx=0,Category=3,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(106)=(ChallengeID=109,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=155,ExtraOptions="?Threshold=7200",Name="HailtotheKingVeteran",Description="HailtotheKingVeteranDesc",HelpText="HailtotheKingVeteranHelp",EXPBonus=500,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_pickelhaube",AttachBone=mount_glasses,image="Changeroom.menu.dukes_hats_pickelhaube",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(107)=(ChallengeID=111,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=166,ExtraOptions="?Threshold=1",Name="ShitTalker",Description="ShitTalkerDesc",HelpText="ShitTalkerHelp",EXPBonus=50,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(108)=(ChallengeID=113,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=167,ExtraOptions="?Threshold=1",Name="SuperNinja",Description="SuperNinjaDesc",HelpText="SuperNinjaHelp",EXPBonus=150,SearchTag=fred,AttachMesh="sm_class_dukeitems.Glasses.Dukes_Glasses_Fakenose",AttachBone=mount_glasses,image="Changeroom.menu.dukes_glasses_fakenose",LockedImageIdx=0,Category=3,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(109)=(ChallengeID=114,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=168,ExtraOptions="?Threshold=1",Name="ISeeYou",Description="ISeeYouDesc",HelpText="ISeeYouHelp",EXPBonus=150,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_samurai",AttachBone=mount_glasses,image="ChangeRoom.Menu.dukes_hats_samurai",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(110)=(ChallengeID=115,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=170,ExtraOptions="?Threshold=1",Name="DoubleYourFun",Description="DoubleYourFunDesc",HelpText="DoubleYourFunHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(111)=(ChallengeID=116,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=169,ExtraOptions="?Threshold=1",Name="NothingCanStopMe",Description="NothingCanStopMeDesc",HelpText="NothingCanStopMeHelp",EXPBonus=100,SearchTag=fred,AttachMesh="sm_class_dukeitems.Glasses.Dukes_Glasses_Wrap",AttachBone=mount_glasses,image="Changeroom.menu.Dukes_Glasses_wrap",LockedImageIdx=0,Category=3,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(112)=(ChallengeID=117,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=76,ExtraOptions="?Threshold=1",Name="JustChillin'",Description="JustChillin'Desc",HelpText="JustChillin'Help",EXPBonus=50,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(113)=(ChallengeID=118,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=78,ExtraOptions="?Threshold=1",Name="AllAboutPerspective",Description="AllAboutPerspectiveDesc",HelpText="AllAboutPerspectiveHelp",EXPBonus=50,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(114)=(ChallengeID=119,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=90,ExtraOptions="?Threshold=1",Name="SoHot",Description="SoHotDesc",HelpText="SoHotHelp",EXPBonus=100,SearchTag=fred,AttachMesh="sm_class_dukeitems.Glasses.Dukes_Glasses_Inuit",AttachBone=mount_glasses,image="Changeroom.menu.Dukes_Glasses_inuit",LockedImageIdx=0,Category=3,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(115)=(ChallengeID=120,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=89,ExtraOptions="?Threshold=1",Name="TheWaterWasCold",Description="TheWaterWasColdDesc",HelpText="TheWaterWasColdHelp",EXPBonus=100,SearchTag=fred,AttachMesh="sm_class_dukeitems.Glasses.Dukes_Glasses_Tea",AttachBone=mount_glasses,image="Changeroom.menu.Dukes_Glasses_Tea",LockedImageIdx=0,Category=3,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(116)=(ChallengeID=121,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=9,ExtraOptions="?Threshold=1",Name="Crusader",Description="CrusaderDesc",HelpText="CrusaderHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(117)=(ChallengeID=122,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=9,ExtraOptions="?Threshold=25",Name="CrusaderII",Description="CrusaderIIDesc",HelpText="CrusaderIIHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(118)=(ChallengeID=123,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=9,ExtraOptions="?Threshold=75",Name="CrusaderIII",Description="CrusaderIIIDesc",HelpText="CrusaderIIIHelp",EXPBonus=7500,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_23",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_23",IsPurchased=true)
    ChallengesArray(119)=(ChallengeID=124,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=9,ExtraOptions="?Threshold=200",Name="CrusaderIV",Description="CrusaderIVDesc",HelpText="CrusaderIVHelp",EXPBonus=20000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=25,AMName="",IsPurchased=true)
    ChallengesArray(120)=(ChallengeID=125,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=98,ExtraOptions="?Threshold=10",Name="AllAboutMe",Description="AllAboutMeDesc",HelpText="AllAboutMeHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(121)=(ChallengeID=126,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=98,ExtraOptions="?Threshold=50",Name="AllAboutMeII",Description="AllAboutMeIIDesc",HelpText="AllAboutMeIIHelp",EXPBonus=500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(122)=(ChallengeID=127,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=98,ExtraOptions="?Threshold=200",Name="AllAboutMeIII",Description="AllAboutMeIIIDesc",HelpText="AllAboutMeIIIHelp",EXPBonus=2000,SearchTag=fred,AttachMesh="",AttachBone=,,image="Changeroom.Menu.Duke_Shirt_Icon_06",LockedImageIdx=0,Category=4,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp.Duke_Shirt_D_06",IsPurchased=true)
    ChallengesArray(123)=(ChallengeID=128,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=98,ExtraOptions="?Threshold=500",Name="AllAboutMeIV",Description="AllAboutMeIVDesc",HelpText="AllAboutMeIVHelp",EXPBonus=5000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=26,AMName="",IsPurchased=true)
    ChallengesArray(124)=(ChallengeID=129,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=11,ExtraOptions="?Threshold=1",Name="MyBrother'sKeeper",Description="MyBrother'sKeeperDesc",HelpText="MyBrother'sKeeperHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(125)=(ChallengeID=130,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=11,ExtraOptions="?Threshold=25",Name="MyBrother'sKeeperII",Description="MyBrother'sKeeperIIDesc",HelpText="MyBrother'sKeeperIIHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(126)=(ChallengeID=131,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=11,ExtraOptions="?Threshold=75",Name="MyBrother'sKeeperIII",Description="MyBrother'sKeeperIIIDesc",HelpText="MyBrother'sKeeperIIIHelp",EXPBonus=7500,SearchTag=fred,AttachMesh="",AttachBone=,,image="Changeroom.Menu.Duke_Shirt_Icon_05",LockedImageIdx=0,Category=4,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp.Duke_Shirt_D_05",IsPurchased=true)
    ChallengesArray(127)=(ChallengeID=132,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=11,ExtraOptions="?Threshold=200",Name="MyBrother'sKeeperIV",Description="MyBrother'sKeeperIVDesc",HelpText="MyBrother'sKeeperIVHelp",EXPBonus=20000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=27,AMName="",IsPurchased=true)
    ChallengesArray(128)=(ChallengeID=133,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=102,ExtraOptions="?Threshold=10",Name="GetOffMyCoattails",Description="GetOffMyCoattailsDesc",HelpText="GetOffMyCoattailsHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(129)=(ChallengeID=134,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=102,ExtraOptions="?Threshold=50",Name="GetOffMyCoattailsII",Description="GetOffMyCoattailsIIDesc",HelpText="GetOffMyCoattailsIIHelp",EXPBonus=500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(130)=(ChallengeID=135,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=102,ExtraOptions="?Threshold=200",Name="GetOffMyCoattailsIII",Description="GetOffMyCoattailsIIIDesc",HelpText="GetOffMyCoattailsIIIHelp",EXPBonus=2000,SearchTag=fred,AttachMesh="",AttachBone=,,image="Changeroom.Menu.Duke_Shirt_Icon_07",LockedImageIdx=0,Category=4,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp.Duke_Shirt_D_07",IsPurchased=true)
    ChallengesArray(131)=(ChallengeID=136,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=102,ExtraOptions="?Threshold=500",Name="GetOffMyCoattailsIV",Description="GetOffMyCoattailsIVDesc",HelpText="GetOffMyCoattailsIVHelp",EXPBonus=5000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=28,AMName="",IsPurchased=true)
    ChallengesArray(132)=(ChallengeID=137,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=152,ExtraOptions="?Threshold=1",Name="FaceRolled",Description="FaceRolledDesc",HelpText="FaceRolledHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(133)=(ChallengeID=138,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=152,ExtraOptions="?Threshold=10",Name="FaceRolledII",Description="FaceRolledIIDesc",HelpText="FaceRolledIIHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(134)=(ChallengeID=139,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=152,ExtraOptions="?Threshold=50",Name="FaceRolledIII",Description="FaceRolledIIIDesc",HelpText="FaceRolledIIIHelp",EXPBonus=5000,SearchTag=fred,AttachMesh="sm_class_dukeitems.Glasses.Dukes_Glasses_Star",AttachBone=mount_glasses,image="Changeroom.menu.dukes_glasses_star",LockedImageIdx=0,Category=3,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(135)=(ChallengeID=140,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=152,ExtraOptions="?Threshold=100",Name="FaceRolledIV",Description="FaceRolledIVDesc",HelpText="FaceRolledIVHelp",EXPBonus=10000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=29,AMName="",IsPurchased=true)
    ChallengesArray(136)=(ChallengeID=141,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=237,ExtraOptions="?Threshold=10",Name="I'mGonnaLetYouFinish",Description="I'mGonnaLetYouFinishDesc",HelpText="I'mGonnaLetYouFinishHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(137)=(ChallengeID=142,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=237,ExtraOptions="?Threshold=50",Name="I'mGonnaLetYouFinishII",Description="I'mGonnaLetYouFinishIIDesc",HelpText="I'mGonnaLetYouFinishIIHelp",EXPBonus=500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(138)=(ChallengeID=143,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=237,ExtraOptions="?Threshold=125",Name="I'mGonnaLetYouFinishIII",Description="I'mGonnaLetYouFinishIIIDesc",HelpText="I'mGonnaLetYouFinishIIIHelp",EXPBonus=1250,SearchTag=fred,AttachMesh="sm_class_dukeitems.Glasses.Dukes_Glasses_Shutter",AttachBone=mount_glasses,image="ChangeRoom.Menu.dukes_glasses_shutter",LockedImageIdx=0,Category=3,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(139)=(ChallengeID=144,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=237,ExtraOptions="?Threshold=250",Name="I'mGonnaLetYouFinishIV",Description="I'mGonnaLetYouFinishIVDesc",HelpText="I'mGonnaLetYouFinishIVHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=30,AMName="",IsPurchased=true)
    ChallengesArray(140)=(ChallengeID=145,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=13,ExtraOptions="?Threshold=1",Name="LadiesMan",Description="LadiesManDesc",HelpText="LadiesManHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(141)=(ChallengeID=146,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=13,ExtraOptions="?Threshold=25",Name="LadiesManII",Description="LadiesManIIDesc",HelpText="LadiesManIIHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(142)=(ChallengeID=147,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=13,ExtraOptions="?Threshold=75",Name="LadiesManIII",Description="LadiesManIIIDesc",HelpText="LadiesManIIIHelp",EXPBonus=750,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_20",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_20",IsPurchased=true)
    ChallengesArray(143)=(ChallengeID=148,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=13,ExtraOptions="?Threshold=200",Name="LadiesManIV",Description="LadiesManIVDesc",HelpText="LadiesManIVHelp",EXPBonus=20000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=31,AMName="",IsPurchased=true)
    ChallengesArray(144)=(ChallengeID=149,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=126,ExtraOptions="?Threshold=1",Name="You'reMarried?",Description="You'reMarried?Desc",HelpText="You'reMarried?Help",EXPBonus=10,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(145)=(ChallengeID=150,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=126,ExtraOptions="?Threshold=10",Name="You'reMarried?II",Description="You'reMarried?IIDesc",HelpText="You'reMarried?IIHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(146)=(ChallengeID=151,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=126,ExtraOptions="?Threshold=50",Name="You'reMarried?III",Description="You'reMarried?IIIDesc",HelpText="You'reMarried?IIIHelp",EXPBonus=500,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_12",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_12",IsPurchased=true)
    ChallengesArray(147)=(ChallengeID=152,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=126,ExtraOptions="?Threshold=150",Name="You'reMarried?IV",Description="You'reMarried?IVDesc",HelpText="You'reMarried?IVHelp",EXPBonus=1500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=32,AMName="",IsPurchased=true)
    ChallengesArray(148)=(ChallengeID=153,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=15,ExtraOptions="?Threshold=1",Name="WomanizerI",Description="WomanizerIDesc",HelpText="WomanizerIHelp",EXPBonus=25,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(149)=(ChallengeID=154,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=15,ExtraOptions="?Threshold=20",Name="WomanizerII",Description="WomanizerIIDesc",HelpText="WomanizerIIHelp",EXPBonus=500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(150)=(ChallengeID=155,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=15,ExtraOptions="?Threshold=69",Name="WomanizerIII",Description="WomanizerIIIDesc",HelpText="WomanizerIIIHelp",EXPBonus=1725,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_16",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_16",IsPurchased=true)
    ChallengesArray(151)=(ChallengeID=156,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=15,ExtraOptions="?Threshold=150",Name="WomanizerIV",Description="WomanizerIVDesc",HelpText="WomanizerIVHelp",EXPBonus=3750,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=33,AMName="",IsPurchased=true)
    ChallengesArray(152)=(ChallengeID=157,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=128,ExtraOptions="?Threshold=1",Name="LadySavior",Description="LadySaviorDesc",HelpText="LadySaviorHelp",EXPBonus=50,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(153)=(ChallengeID=158,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=128,ExtraOptions="?Threshold=10",Name="LadySaviorII",Description="LadySaviorIIDesc",HelpText="LadySaviorIIHelp",EXPBonus=500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(154)=(ChallengeID=159,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=128,ExtraOptions="?Threshold=50",Name="LadySaviorIII",Description="LadySaviorIIIDesc",HelpText="LadySaviorIIIHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_13",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_13",IsPurchased=true)
    ChallengesArray(155)=(ChallengeID=160,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=128,ExtraOptions="?Threshold=150",Name="LadySaviorIV",Description="LadySaviorIVDesc",HelpText="LadySaviorIVHelp",EXPBonus=7500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=34,AMName="",IsPurchased=true)
    ChallengesArray(156)=(ChallengeID=161,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=17,ExtraOptions="?Threshold=1",Name="CockBlocker",Description="CockBlockerDesc",HelpText="CockBlockerHelp",EXPBonus=50,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(157)=(ChallengeID=162,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=17,ExtraOptions="?Threshold=10",Name="CockBlockerII",Description="CockBlockerIIDesc",HelpText="CockBlockerIIHelp",EXPBonus=500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(158)=(ChallengeID=163,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=17,ExtraOptions="?Threshold=50",Name="CockBlockerIII",Description="CockBlockerIIIDesc",HelpText="CockBlockerIIIHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.Dukes_Hats_Pimp",AttachBone=mount_glasses,image="Changeroom.menu.Dukes_Hats_Pimp",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(159)=(ChallengeID=164,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=17,ExtraOptions="?Threshold=150",Name="CockBlockerIV",Description="CockBlockerIVDesc",HelpText="CockBlockerIVHelp",EXPBonus=7500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=35,AMName="",IsPurchased=true)
    ChallengesArray(160)=(ChallengeID=165,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=109,ExtraOptions="?Threshold=1",Name="KingmakerI",Description="KingmakerIDesc",HelpText="KingmakerIHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(161)=(ChallengeID=166,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=109,ExtraOptions="?Threshold=25",Name="KingmakerII",Description="KingmakerIIDesc",HelpText="KingmakerIIHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(162)=(ChallengeID=167,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=109,ExtraOptions="?Threshold=75",Name="KingmakerIII",Description="KingmakerIIIDesc",HelpText="KingmakerIIIHelp",EXPBonus=7500,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_25",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_25",IsPurchased=true)
    ChallengesArray(163)=(ChallengeID=168,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=109,ExtraOptions="?Threshold=200",Name="KingmakerIV",Description="KingmakerIVDesc",HelpText="KingmakerIVHelp",EXPBonus=20000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=36,AMName="",IsPurchased=true)
    ChallengesArray(164)=(ChallengeID=169,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=147,ExtraOptions="?Threshold=50",Name="GrubbyMittsI",Description="GrubbyMittsIDesc",HelpText="GrubbyMittsIHelp",EXPBonus=200,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(165)=(ChallengeID=170,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=147,ExtraOptions="?Threshold=200",Name="GrubbyMittsII",Description="GrubbyMittsIIDesc",HelpText="GrubbyMittsIIHelp",EXPBonus=800,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(166)=(ChallengeID=171,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=147,ExtraOptions="?Threshold=500",Name="GrubbyMittsIII",Description="GrubbyMittsIIIDesc",HelpText="GrubbyMittsIIIHelp",EXPBonus=2000,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_26",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_26",IsPurchased=true)
    ChallengesArray(167)=(ChallengeID=172,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=147,ExtraOptions="?Threshold=1000",Name="GrubbyMittsIV",Description="GrubbyMittsIVDesc",HelpText="GrubbyMittsIVHelp",EXPBonus=4000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=37,AMName="",IsPurchased=true)
    ChallengesArray(168)=(ChallengeID=177,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=150,ExtraOptions="?Threshold=1",Name="OurHouseI",Description="OurHouseIDesc",HelpText="OurHouseIHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(169)=(ChallengeID=178,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=150,ExtraOptions="?Threshold=10",Name="OurHouseII",Description="OurHouseIIDesc",HelpText="OurHouseIIHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(170)=(ChallengeID=179,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=150,ExtraOptions="?Threshold=50",Name="OurHouseIII",Description="OurHouseIIIDesc",HelpText="OurHouseIIIHelp",EXPBonus=7500,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_27",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_27",IsPurchased=true)
    ChallengesArray(171)=(ChallengeID=180,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=150,ExtraOptions="?Threshold=150",Name="OurHouseIV",Description="OurHouseIVDesc",HelpText="OurHouseIVHelp",EXPBonus=20000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=39,AMName="",IsPurchased=true)
    ChallengesArray(172)=(ChallengeID=192,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=151,ExtraOptions="?Threshold=10",Name="HailMaryI",Description="HailMaryIDesc",HelpText="HailMaryIHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(173)=(ChallengeID=193,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=151,ExtraOptions="?Threshold=25",Name="HailMaryII",Description="HailMaryIIDesc",HelpText="HailMaryIIHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(174)=(ChallengeID=194,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=151,ExtraOptions="?Threshold=75",Name="HailMaryIII",Description="HailMaryIIIDesc",HelpText="HailMaryIIIHelp",EXPBonus=750,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_28",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_28",IsPurchased=true)
    ChallengesArray(175)=(ChallengeID=195,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=151,ExtraOptions="?Threshold=200",Name="HailMaryIV",Description="HailMaryIVDesc",HelpText="HailMaryIVHelp",EXPBonus=2000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=40,AMName="",IsPurchased=true)
    ChallengesArray(176)=(ChallengeID=196,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=104,ExtraOptions="?Threshold=5",Name="FollowMyLeadI",Description="FollowMyLeadIDesc",HelpText="FollowMyLeadIHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(177)=(ChallengeID=197,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=104,ExtraOptions="?Threshold=10",Name="FollowMyLeadII",Description="FollowMyLeadIIDesc",HelpText="FollowMyLeadIIHelp",EXPBonus=500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(178)=(ChallengeID=198,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=104,ExtraOptions="?Threshold=25",Name="FollowMyLeadIII",Description="FollowMyLeadIIIDesc",HelpText="FollowMyLeadIIIHelp",EXPBonus=1250,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_trafficcone",AttachBone=mount_glasses,image="Changeroom.menu.dukes_hats_trafficcone",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(179)=(ChallengeID=199,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=104,ExtraOptions="?Threshold=75",Name="FollowMyLeadIV",Description="FollowMyLeadIVDesc",HelpText="FollowMyLeadIVHelp",EXPBonus=3750,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=41,AMName="",IsPurchased=true)
    ChallengesArray(180)=(ChallengeID=200,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=149,ExtraOptions="?Threshold=5",Name="BattlefortheCircleI",Description="BattlefortheCircleIDesc",HelpText="BattlefortheCircleIHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(181)=(ChallengeID=201,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=149,ExtraOptions="?Threshold=10",Name="BattlefortheCircleII",Description="BattlefortheCircleIIDesc",HelpText="BattlefortheCircleIIHelp",EXPBonus=500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(182)=(ChallengeID=202,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=149,ExtraOptions="?Threshold=25",Name="BattlefortheCircleIII",Description="BattlefortheCircleIIIDesc",HelpText="BattlefortheCircleIIIHelp",EXPBonus=1250,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_crown",AttachBone=mount_glasses,image="Changeroom.Menu.dukes_hats_crown",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(183)=(ChallengeID=203,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=149,ExtraOptions="?Threshold=75",Name="BattlefortheCircleIV",Description="BattlefortheCircleIVDesc",HelpText="BattlefortheCircleIVHelp",EXPBonus=3750,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=42,AMName="",IsPurchased=true)
    ChallengesArray(184)=(ChallengeID=204,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=236,ExtraOptions="?Threshold=1?Match=True",Name="PropaneAccessories",Description="PropaneAccessoriesDesc",HelpText="PropaneAccessoriesHelp",EXPBonus=500,SearchTag=fred,AttachMesh="sm_class_dukeitems.Glasses.Dukes_Glasses_HornedM",AttachBone=mount_glasses,image="Changeroom.menu.Dukes_Glasses_HornedM",LockedImageIdx=0,Category=3,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(185)=(ChallengeID=205,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=100,ExtraOptions="?Threshold=1",Name="ScrapingBottom",Description="ScrapingBottomDesc",HelpText="ScrapingBottomHelp",EXPBonus=10,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(186)=(ChallengeID=206,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=106,ExtraOptions="?Threshold=1",Name="ITriedMyBest",Description="ITriedMyBestDesc",HelpText="ITriedMyBestHelp",EXPBonus=125,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(187)=(ChallengeID=207,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=107,ExtraOptions="?Threshold=1",Name="I'mHerefortheFood",Description="I'mHerefortheFoodDesc",HelpText="I'mHerefortheFoodHelp",EXPBonus=10,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(188)=(ChallengeID=208,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=145,ExtraOptions="?Threshold=1",Name="WeTried",Description="WeTriedDesc",HelpText="WeTriedHelp",EXPBonus=125,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(189)=(ChallengeID=209,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=146,ExtraOptions="?Threshold=1",Name="MyTeamSucked",Description="MyTeamSuckedDesc",HelpText="MyTeamSuckedHelp",EXPBonus=10,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(190)=(ChallengeID=210,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=125,ExtraOptions="?Threshold=1",Name="MajorShrinkage",Description="MajorShrinkageDesc",HelpText="MajorShrinkageHelp",EXPBonus=10,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(191)=(ChallengeID=211,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=174,ExtraOptions="?Threshold=1",Name="SpringLoaded",Description="SpringLoadedDesc",HelpText="SpringLoadedHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=43,AMName="",IsPurchased=true)
    ChallengesArray(192)=(ChallengeID=212,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=119,ExtraOptions="?Threshold=20?Match=true",Name="Ralph",Description="RalphDesc",HelpText="RalphHelp",EXPBonus=2000,SearchTag=fred,AttachMesh="sm_class_dukeitems.Glasses.Dukes_Glasses_video",AttachBone=mount_glasses,image="Changeroom.menu.dukes_glasses_video",LockedImageIdx=0,Category=3,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(193)=(ChallengeID=213,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=175,ExtraOptions="?Threshold=1",Name="DirtyRats",Description="DirtyRatsDesc",HelpText="DirtyRatsHelp",EXPBonus=500,SearchTag=fred,AttachMesh="sm_class_dukeitems.Glasses.Dukes_Glasses_bug",AttachBone=mount_glasses,image="Changeroom.menu.dukes_glasses_bug",LockedImageIdx=0,Category=3,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(194)=(ChallengeID=214,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=176,ExtraOptions="?Threshold=1",Name="LeapFrog",Description="LeapFrogDesc",HelpText="LeapFrogHelp",EXPBonus=500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=44,AMName="",IsPurchased=true)
    ChallengesArray(195)=(ChallengeID=215,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=177,ExtraOptions="?Threshold=1",Name="Limbo",Description="LimboDesc",HelpText="LimboHelp",EXPBonus=500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=45,AMName="",IsPurchased=true)
    ChallengesArray(196)=(ChallengeID=216,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=124,ExtraOptions="?Threshold=1",Name="SheWasFrigid",Description="SheWasFrigidDesc",HelpText="SheWasFrigidHelp",EXPBonus=10,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_19",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_19",IsPurchased=true)
    ChallengesArray(197)=(ChallengeID=217,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=132,ExtraOptions="?Threshold=10",Name="ExplosiveGasI",Description="ExplosiveGasIDesc",HelpText="ExplosiveGasIHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(198)=(ChallengeID=218,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=132,ExtraOptions="?Threshold=25",Name="ExplosiveGasII",Description="ExplosiveGasIIDesc",HelpText="ExplosiveGasIIHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(199)=(ChallengeID=219,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=132,ExtraOptions="?Threshold=75",Name="ExplosiveGasIII",Description="ExplosiveGasIIIDesc",HelpText="ExplosiveGasIIIHelp",EXPBonus=750,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_17",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_17",IsPurchased=true)
    ChallengesArray(200)=(ChallengeID=220,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=132,ExtraOptions="?Threshold=200",Name="ExplosiveGasIV",Description="ExplosiveGasIVDesc",HelpText="ExplosiveGasIVHelp",EXPBonus=2000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=47,AMName="",IsPurchased=true)
    ChallengesArray(201)=(ChallengeID=221,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=134,ExtraOptions="?Threshold=10",Name="TopGunI",Description="TopGunIDesc",HelpText="TopGunIHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(202)=(ChallengeID=222,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=134,ExtraOptions="?Threshold=25",Name="TopGunII",Description="TopGunIIDesc",HelpText="TopGunIIHelp",EXPBonus=625,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(203)=(ChallengeID=223,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=134,ExtraOptions="?Threshold=75",Name="TopGunIII",Description="TopGunIIIDesc",HelpText="TopGunIIIHelp",EXPBonus=1875,SearchTag=fred,AttachMesh="sm_class_dukeitems.Glasses.Dukes_Glasses_aviators",AttachBone=mount_glasses,image="Changeroom.menu.dukes_glasses_aviators",LockedImageIdx=0,Category=3,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(204)=(ChallengeID=224,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=134,ExtraOptions="?Threshold=200",Name="TopGunIV",Description="TopGunIVDesc",HelpText="TopGunIVHelp",EXPBonus=5000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=48,AMName="",IsPurchased=true)
    ChallengesArray(205)=(ChallengeID=225,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=178,ExtraOptions="?Threshold=50",Name="BouncingBettyI",Description="BouncingBettyIDesc",HelpText="BouncingBettyIHelp",EXPBonus=500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(206)=(ChallengeID=226,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=178,ExtraOptions="?Threshold=150",Name="BouncingBettyII",Description="BouncingBettyIIDesc",HelpText="BouncingBettyIIHelp",EXPBonus=1500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(207)=(ChallengeID=227,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=178,ExtraOptions="?Threshold=500",Name="BouncingBettyIII",Description="BouncingBettyIIIDesc",HelpText="BouncingBettyIIIHelp",EXPBonus=5000,SearchTag=fred,AttachMesh="sm_class_dukeitems.Glasses.Dukes_Glasses_hornedf",AttachBone=mount_glasses,image="Changeroom.menu.dukes_glasses_hornedf",LockedImageIdx=0,Category=3,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(208)=(ChallengeID=228,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=178,ExtraOptions="?Threshold=1000",Name="BouncingBettyIV",Description="BouncingBettyIVDesc",HelpText="BouncingBettyIVHelp",EXPBonus=10000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=49,AMName="",IsPurchased=true)
    ChallengesArray(209)=(ChallengeID=229,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=165,ExtraOptions="?Threshold=1",Name="HotPocketsI",Description="HotPocketsIDesc",HelpText="HotPocketsIHelp",EXPBonus=500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(210)=(ChallengeID=230,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=165,ExtraOptions="?Threshold=5",Name="HotPocketsII",Description="HotPocketsIIDesc",HelpText="HotPocketsIIHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(211)=(ChallengeID=231,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=165,ExtraOptions="?Threshold=10",Name="HotPocketsIII",Description="HotPocketsIIIDesc",HelpText="HotPocketsIIIHelp",EXPBonus=5000,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_15",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_15",IsPurchased=true)
    ChallengesArray(212)=(ChallengeID=232,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=165,ExtraOptions="?Threshold=50",Name="HotPocketsIV",Description="HotPocketsIVDesc",HelpText="HotPocketsIVHelp",EXPBonus=25000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=50,AMName="",IsPurchased=true)
    ChallengesArray(213)=(ChallengeID=233,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=163,ExtraOptions="?Threshold=5",Name="SqueakyCleanI",Description="SqueakyCleanIDesc",HelpText="SqueakyCleanIHelp",EXPBonus=500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(214)=(ChallengeID=234,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=163,ExtraOptions="?Threshold=10",Name="SqueakyCleanII",Description="SqueakyCleanIIDesc",HelpText="SqueakyCleanIIHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(215)=(ChallengeID=235,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=163,ExtraOptions="?Threshold=50",Name="SqueakyCleanIII",Description="SqueakyCleanIIIDesc",HelpText="SqueakyCleanIIIHelp",EXPBonus=5000,SearchTag=fred,AttachMesh="sm_class_dukeitems.Glasses.Dukes_Glasses_scuba",AttachBone=mount_glasses,image="Changeroom.menu.dukes_glasses_scuba",LockedImageIdx=0,Category=3,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(216)=(ChallengeID=236,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=163,ExtraOptions="?Threshold=150",Name="SqueakyCleanIV",Description="SqueakyCleanIVDesc",HelpText="SqueakyCleanIVHelp",EXPBonus=15000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=51,AMName="",IsPurchased=true)
    ChallengesArray(217)=(ChallengeID=237,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=97,ExtraOptions="?Threshold=1",Name="WatchWhereYou'reGoing",Description="WatchWhereYou'reGoingDesc",HelpText="WatchWhereYou'reGoingHelp",EXPBonus=10,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(218)=(ChallengeID=238,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=94,ExtraOptions="?Threshold=1",Name="AcmeInc.",Description="AcmeInc.Desc",HelpText="AcmeInc.Help",EXPBonus=10,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(219)=(ChallengeID=239,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=95,ExtraOptions="?Threshold=1",Name="O.M.G.",Description="O.M.G.Desc",HelpText="O.M.G.Help",EXPBonus=10,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(220)=(ChallengeID=240,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=96,ExtraOptions="?Threshold=1",Name="I'llNeverLearn",Description="I'llNeverLearnDesc",HelpText="I'llNeverLearnHelp",EXPBonus=10,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(221)=(ChallengeID=241,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=181,ExtraOptions="?Threshold=1",Name="StupidSeekingMissiles",Description="StupidSeekingMissilesDesc",HelpText="StupidSeekingMissilesHelp",EXPBonus=10,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(222)=(ChallengeID=242,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=93,ExtraOptions="?Threshold=1",Name="NeverTakenAlive",Description="NeverTakenAliveDesc",HelpText="NeverTakenAliveHelp",EXPBonus=10,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(223)=(ChallengeID=243,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=182,ExtraOptions="?Threshold=1",Name="Don'tTouch",Description="Don'tTouchDesc",HelpText="Don'tTouchHelp",EXPBonus=10,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(224)=(ChallengeID=244,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=183,ExtraOptions="?Threshold=1",Name="NoHeadRoom",Description="NoHeadRoomDesc",HelpText="NoHeadRoomHelp",EXPBonus=10,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(225)=(ChallengeID=245,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=186,ExtraOptions="?Threshold=1",Name="Where'sMyParachute?",Description="Where'sMyParachute?Desc",HelpText="Where'sMyParachute?Help",EXPBonus=10,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(226)=(ChallengeID=246,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=184,ExtraOptions="?Threshold=1",Name="Shocking,Huh?",Description="Shocking,Huh?Desc",HelpText="Shocking,Huh?Help",EXPBonus=10,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(227)=(ChallengeID=247,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=185,ExtraOptions="?Threshold=1",Name="ForgottoFlip",Description="ForgottoFlipDesc",HelpText="ForgottoFlipHelp",EXPBonus=10,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(228)=(ChallengeID=359,ChallObjClass="dnGame.ChallengeObject_Nested",ChallDependencies=(237,238,239,240,241,242,243,244,245,246,247),StatDependency=0,ExtraOptions="",Name="MyEmoLife",Description="MyEmoLifeDesc",HelpText="MyEmoLifeHelp",EXPBonus=20,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_bonsai",AttachBone=mount_glasses,image="ChangeRoom.Menu.dukes_hats_bonsai",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(229)=(ChallengeID=248,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=118,ExtraOptions="?Threshold=10",Name="KangarooJack",Description="KangarooJackDesc",HelpText="KangarooJackHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_propellerhat",AttachBone=mount_glasses,image="Changeroom.menu.dukes_hats_propellerhat",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(230)=(ChallengeID=249,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=38,ExtraOptions="?Threshold=10",Name="PigeonPrecision",Description="PigeonPrecisionDesc",HelpText="PigeonPrecisionHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_headdress",AttachBone=mount_glasses,image="ChangeRoom.Menu.dukes_hats_hddress",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(231)=(ChallengeID=250,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=32,ExtraOptions="?Threshold=25",Name="BoomGoestheWeasel",Description="BoomGoestheWeaselDesc",HelpText="BoomGoestheWeaselHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(232)=(ChallengeID=251,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=32,ExtraOptions="?Threshold=100",Name="BoomGoestheWeaselII",Description="BoomGoestheWeaselIIDesc",HelpText="BoomGoestheWeaselIIHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(233)=(ChallengeID=252,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=32,ExtraOptions="?Threshold=250",Name="BoomGoestheWeaselIII",Description="BoomGoestheWeaselIIIDesc",HelpText="BoomGoestheWeaselIIIHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_07",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_07",IsPurchased=true)
    ChallengesArray(234)=(ChallengeID=253,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=32,ExtraOptions="?Threshold=1000",Name="BoomGoestheWeaselIV",Description="BoomGoestheWeaselIVDesc",HelpText="BoomGoestheWeaselIVHelp",EXPBonus=10000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=8,AMName="",IsPurchased=true)
    ChallengesArray(235)=(ChallengeID=254,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=81,ExtraOptions="?Threshold=5",Name="Lemmings...AllofThem",Description="Lemmings...AllofThemDesc",HelpText="Lemmings...AllofThemHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(236)=(ChallengeID=255,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=81,ExtraOptions="?Threshold=10",Name="Lemmings...AllofThemII",Description="Lemmings...AllofThemIIDesc",HelpText="Lemmings...AllofThemIIHelp",EXPBonus=500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(237)=(ChallengeID=256,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=81,ExtraOptions="?Threshold=50",Name="Lemmings...AllofThemIII",Description="Lemmings...AllofThemIIIDesc",HelpText="Lemmings...AllofThemIIIHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_03",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_03",IsPurchased=true)
    ChallengesArray(238)=(ChallengeID=257,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=81,ExtraOptions="?Threshold=150",Name="Lemmings...AllofThemIV",Description="Lemmings...AllofThemIVDesc",HelpText="Lemmings...AllofThemIVHelp",EXPBonus=7500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=62,AMName="",IsPurchased=true)
    ChallengesArray(239)=(ChallengeID=258,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=80,ExtraOptions="?Threshold=5",Name="CuriosityKilledtheCats",Description="CuriosityKilledtheCatsDesc",HelpText="CuriosityKilledtheCatsHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(240)=(ChallengeID=259,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=80,ExtraOptions="?Threshold=10",Name="CuriosityKilledtheCatsII",Description="CuriosityKilledtheCatsIIDesc",HelpText="CuriosityKilledtheCatsIIHelp",EXPBonus=500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(241)=(ChallengeID=260,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=80,ExtraOptions="?Threshold=50",Name="CuriosityKilledtheCatsIII",Description="CuriosityKilledtheCatsIIIDesc",HelpText="CuriosityKilledtheCatsIIIHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_08",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_08",IsPurchased=true)
    ChallengesArray(242)=(ChallengeID=261,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=80,ExtraOptions="?Threshold=150",Name="CuriosityKilledtheCatsIV",Description="CuriosityKilledtheCatsIVDesc",HelpText="CuriosityKilledtheCatsIVHelp",EXPBonus=7500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=65,AMName="",IsPurchased=true)
    ChallengesArray(243)=(ChallengeID=607,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=187,ExtraOptions="?Threshold=1",Name="FireandIce",Description="FireandIceDesc",HelpText="FireandIceHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=52,AMName="",IsPurchased=true)
    ChallengesArray(244)=(ChallengeID=263,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=188,ExtraOptions="?Threshold=1",Name="M?nage?Death",Description="M?nage?DeathDesc",HelpText="M?nage?DeathHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=53,AMName="",IsPurchased=true)
    ChallengesArray(245)=(ChallengeID=264,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=189,ExtraOptions="?Threshold=1",Name="Pull!",Description="Pull!Desc",HelpText="Pull!Help",EXPBonus=1000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=54,AMName="",IsPurchased=true)
    ChallengesArray(246)=(ChallengeID=265,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=190,ExtraOptions="?Threshold=1",Name="DrinkingMakesYouTougher",Description="DrinkingMakesYouTougherDesc",HelpText="DrinkingMakesYouTougherHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(247)=(ChallengeID=266,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=191,ExtraOptions="?Threshold=1",Name="FreezingRain",Description="FreezingRainDesc",HelpText="FreezingRainHelp",EXPBonus=150,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(248)=(ChallengeID=267,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=192,ExtraOptions="?Threshold=1",Name="FallingDownShrunk",Description="FallingDownShrunkDesc",HelpText="FallingDownShrunkHelp",EXPBonus=150,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(249)=(ChallengeID=268,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=193,ExtraOptions="?Threshold=1",Name="MidairCollision",Description="MidairCollisionDesc",HelpText="MidairCollisionHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="sm_class_dukeitems.Glasses.Dukes_Glasses_Hypno",AttachBone=mount_glasses,image="Changeroom.menu.Dukes_Glasses_Hypno",LockedImageIdx=0,Category=3,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(250)=(ChallengeID=269,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=194,ExtraOptions="?Threshold=1",Name="PerfectAim",Description="PerfectAimDesc",HelpText="PerfectAimHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="",AttachBone=,,image="Changeroom.Menu.Duke_Shirt_Icon_04",LockedImageIdx=0,Category=4,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp.Duke_Shirt_D_04",IsPurchased=true)
    ChallengesArray(251)=(ChallengeID=270,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=195,ExtraOptions="?Threshold=10?Match=True",Name="TheSheriff",Description="TheSheriffDesc",HelpText="TheSheriffHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=55,AMName="",IsPurchased=true)
    ChallengesArray(252)=(ChallengeID=271,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=196,ExtraOptions="?Threshold=1",Name="YourShirt'sDaBomb",Description="YourShirt'sDaBombDesc",HelpText="YourShirt'sDaBombHelp",EXPBonus=500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(253)=(ChallengeID=272,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=197,ExtraOptions="?Threshold=1",Name="MADF",Description="MADFDesc",HelpText="MADFHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=56,AMName="",IsPurchased=true)
    ChallengesArray(254)=(ChallengeID=273,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=198,ExtraOptions="?Threshold=30?Match=True",Name="OldSchool",Description="OldSchoolDesc",HelpText="OldSchoolHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=57,AMName="",IsPurchased=true)
    ChallengesArray(255)=(ChallengeID=274,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=205,ExtraOptions="?Threshold=1?Match=True",Name="SpecialSauce",Description="SpecialSauceDesc",HelpText="SpecialSauceHelp",EXPBonus=500,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_11",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_11",IsPurchased=true)
    ChallengesArray(256)=(ChallengeID=275,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=179,ExtraOptions="?Threshold=1",Name="OneManArmyI",Description="OneManArmyIDesc",HelpText="OneManArmyIHelp",EXPBonus=500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(257)=(ChallengeID=276,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=179,ExtraOptions="?Threshold=5",Name="OneManArmyII",Description="OneManArmyIIDesc",HelpText="OneManArmyIIHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(258)=(ChallengeID=277,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=179,ExtraOptions="?Threshold=10",Name="OneManArmyIII",Description="OneManArmyIIIDesc",HelpText="OneManArmyIIIHelp",EXPBonus=5000,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_conehead",AttachBone=mount_glasses,image="Changeroom.Menu.dukes_hats_conehead",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(259)=(ChallengeID=278,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=179,ExtraOptions="?Threshold=50",Name="OneManArmyIV",Description="OneManArmyIVDesc",HelpText="OneManArmyIVHelp",EXPBonus=25000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=58,AMName="",IsPurchased=true)
    ChallengesArray(260)=(ChallengeID=279,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=180,ExtraOptions="?Threshold=5",Name="ScalpCollectorI",Description="ScalpCollectorIDesc",HelpText="ScalpCollectorIHelp",EXPBonus=500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(261)=(ChallengeID=280,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=180,ExtraOptions="?Threshold=10",Name="ScalpCollectorII",Description="ScalpCollectorIIDesc",HelpText="ScalpCollectorIIHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(262)=(ChallengeID=281,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=180,ExtraOptions="?Threshold=50",Name="ScalpCollectorIII",Description="ScalpCollectorIIIDesc",HelpText="ScalpCollectorIIIHelp",EXPBonus=5000,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_29",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_29",IsPurchased=true)
    ChallengesArray(263)=(ChallengeID=282,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=180,ExtraOptions="?Threshold=150",Name="ScalpCollectorIV",Description="ScalpCollectorIVDesc",HelpText="ScalpCollectorIVHelp",EXPBonus=15000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=59,AMName="",IsPurchased=true)
    ChallengesArray(264)=(ChallengeID=283,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=212,ExtraOptions="?Threshold=1",Name="PaybackI",Description="PaybackIDesc",HelpText="PaybackIHelp",EXPBonus=25,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(265)=(ChallengeID=284,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=212,ExtraOptions="?Threshold=10",Name="PaybackII",Description="PaybackIIDesc",HelpText="PaybackIIHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(266)=(ChallengeID=285,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=212,ExtraOptions="?Threshold=50",Name="PaybackIII",Description="PaybackIIIDesc",HelpText="PaybackIIIHelp",EXPBonus=1250,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_arrow",AttachBone=mount_glasses,image="ChangeRoom.Menu.dukes_hats_arrow",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(267)=(ChallengeID=286,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=212,ExtraOptions="?Threshold=150",Name="PaybackIV",Description="PaybackIVDesc",HelpText="PaybackIVHelp",EXPBonus=3750,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=60,AMName="",IsPurchased=true)
    ChallengesArray(268)=(ChallengeID=287,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=160,ExtraOptions="?Threshold=1",Name="ThatLastStepI",Description="ThatLastStepIDesc",HelpText="ThatLastStepIHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(269)=(ChallengeID=288,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=160,ExtraOptions="?Threshold=10",Name="ThatLastStepII",Description="ThatLastStepIIDesc",HelpText="ThatLastStepIIHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(270)=(ChallengeID=289,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=160,ExtraOptions="?Threshold=50",Name="ThatLastStepIII",Description="ThatLastStepIIIDesc",HelpText="ThatLastStepIIIHelp",EXPBonus=5000,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_30",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_30",IsPurchased=true)
    ChallengesArray(271)=(ChallengeID=290,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=160,ExtraOptions="?Threshold=150",Name="ThatLastStepIV",Description="ThatLastStepIVDesc",HelpText="ThatLastStepIVHelp",EXPBonus=15000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=61,AMName="",IsPurchased=true)
    ChallengesArray(272)=(ChallengeID=291,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=161,ExtraOptions="?Threshold=1",Name="That'sChunkyI",Description="That'sChunkyIDesc",HelpText="That'sChunkyIHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(273)=(ChallengeID=292,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=161,ExtraOptions="?Threshold=10",Name="That'sChunkyII",Description="That'sChunkyIIDesc",HelpText="That'sChunkyIIHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(274)=(ChallengeID=293,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=161,ExtraOptions="?Threshold=50",Name="That'sChunkyIII",Description="That'sChunkyIIIDesc",HelpText="That'sChunkyIIIHelp",EXPBonus=5000,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_31",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_31",IsPurchased=true)
    ChallengesArray(275)=(ChallengeID=294,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=161,ExtraOptions="?Threshold=150",Name="That'sChunkyIV",Description="That'sChunkyIVDesc",HelpText="That'sChunkyIVHelp",EXPBonus=15000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=64,AMName="",IsPurchased=true)
    ChallengesArray(276)=(ChallengeID=295,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=157,ExtraOptions="?Threshold=1",Name="ElToroI",Description="ElToroIDesc",HelpText="ElToroIHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(277)=(ChallengeID=296,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=157,ExtraOptions="?Threshold=5",Name="ElToroII",Description="ElToroIIDesc",HelpText="ElToroIIHelp",EXPBonus=1250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(278)=(ChallengeID=297,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=157,ExtraOptions="?Threshold=10",Name="ElToroIII",Description="ElToroIIIDesc",HelpText="ElToroIIIHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_32",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_32",IsPurchased=true)
    ChallengesArray(279)=(ChallengeID=298,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=157,ExtraOptions="?Threshold=50",Name="ElToroIV",Description="ElToroIVDesc",HelpText="ElToroIVHelp",EXPBonus=12500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=66,AMName="",IsPurchased=true)
    ChallengesArray(280)=(ChallengeID=299,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=158,ExtraOptions="?Threshold=1",Name="K.O.KingI",Description="K.O.KingIDesc",HelpText="K.O.KingIHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(281)=(ChallengeID=300,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=158,ExtraOptions="?Threshold=5",Name="K.O.KingII",Description="K.O.KingIIDesc",HelpText="K.O.KingIIHelp",EXPBonus=1250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(282)=(ChallengeID=301,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=158,ExtraOptions="?Threshold=10",Name="K.O.KingIII",Description="K.O.KingIIIDesc",HelpText="K.O.KingIIIHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_33",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_33",IsPurchased=true)
    ChallengesArray(283)=(ChallengeID=302,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=158,ExtraOptions="?Threshold=50",Name="K.O.KingIV",Description="K.O.KingIVDesc",HelpText="K.O.KingIVHelp",EXPBonus=12500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=67,AMName="",IsPurchased=true)
    ChallengesArray(284)=(ChallengeID=303,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=159,ExtraOptions="?Threshold=1",Name="BlastRadiusI",Description="BlastRadiusIDesc",HelpText="BlastRadiusIHelp",EXPBonus=500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(285)=(ChallengeID=304,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=159,ExtraOptions="?Threshold=5",Name="BlastRadiusII",Description="BlastRadiusIIDesc",HelpText="BlastRadiusIIHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(286)=(ChallengeID=305,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=159,ExtraOptions="?Threshold=10",Name="BlastRadiusIII",Description="BlastRadiusIIIDesc",HelpText="BlastRadiusIIIHelp",EXPBonus=5000,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_chicken",AttachBone=mount_glasses,image="ChangeRoom.Menu.dukes_hats_chicken",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(287)=(ChallengeID=306,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=159,ExtraOptions="?Threshold=50",Name="BlastRadiusIV",Description="BlastRadiusIVDesc",HelpText="BlastRadiusIVHelp",EXPBonus=25000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=68,AMName="",IsPurchased=true)
    ChallengesArray(288)=(ChallengeID=307,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=204,ExtraOptions="?Threshold=1",Name="RunningMan",Description="RunningManDesc",HelpText="RunningManHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=69,AMName="",IsPurchased=true)
    ChallengesArray(289)=(ChallengeID=308,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=199,ExtraOptions="?Threshold=1",Name="RemoteBomber",Description="RemoteBomberDesc",HelpText="RemoteBomberHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=70,AMName="",IsPurchased=true)
    ChallengesArray(290)=(ChallengeID=309,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=171,ExtraOptions="?Threshold=1",Name="BarFight",Description="BarFightDesc",HelpText="BarFightHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=71,AMName="",IsPurchased=true)
    ChallengesArray(291)=(ChallengeID=310,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=172,ExtraOptions="?Threshold=1",Name="Inhuman",Description="InhumanDesc",HelpText="InhumanHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=72,AMName="",IsPurchased=true)
    ChallengesArray(292)=(ChallengeID=311,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=173,ExtraOptions="?Threshold=1",Name="We'reGoingStreaking!I",Description="We'reGoingStreaking!IDesc",HelpText="We'reGoingStreaking!IHelp",EXPBonus=250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(293)=(ChallengeID=312,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=173,ExtraOptions="?Threshold=5",Name="We'reGoingStreaking!II",Description="We'reGoingStreaking!IIDesc",HelpText="We'reGoingStreaking!IIHelp",EXPBonus=1250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(294)=(ChallengeID=313,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=173,ExtraOptions="?Threshold=10",Name="We'reGoingStreaking!III",Description="We'reGoingStreaking!IIIDesc",HelpText="We'reGoingStreaking!IIIHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_34",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_34",IsPurchased=true)
    ChallengesArray(295)=(ChallengeID=314,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=173,ExtraOptions="?Threshold=25",Name="We'reGoingStreaking!IV",Description="We'reGoingStreaking!IVDesc",HelpText="We'reGoingStreaking!IVHelp",EXPBonus=6250,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=73,AMName="",IsPurchased=true)
    ChallengesArray(296)=(ChallengeID=315,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=120,ExtraOptions="?Threshold=1",Name="UntouchableI",Description="UntouchableIDesc",HelpText="UntouchableIHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="sm_class_dukeitems.Glasses.Dukes_Glasses_Hannibal",AttachBone=mount_glasses,image="ChangeRoom.Menu.dukes_glasses_hannibal",LockedImageIdx=0,Category=3,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(297)=(ChallengeID=316,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=120,ExtraOptions="?Threshold=5",Name="UntouchableII",Description="UntouchableIIDesc",HelpText="UntouchableIIHelp",EXPBonus=5000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(298)=(ChallengeID=317,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=120,ExtraOptions="?Threshold=20",Name="UntouchableIII",Description="UntouchableIIIDesc",HelpText="UntouchableIIIHelp",EXPBonus=20000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(299)=(ChallengeID=318,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=120,ExtraOptions="?Threshold=50",Name="UntouchableIV",Description="UntouchableIVDesc",HelpText="UntouchableIVHelp",EXPBonus=50000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=74,AMName="",IsPurchased=true)
    ChallengesArray(300)=(ChallengeID=319,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=203,ExtraOptions="?Threshold=1",Name="GoingonSafari",Description="GoingonSafariDesc",HelpText="GoingonSafariHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_grandpuba",AttachBone=mount_glasses,image="ChangeRoom.Menu.dukes_hats_grandpuba",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(301)=(ChallengeID=320,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=164,ExtraOptions="?Threshold=5",Name="Nuke'EmI",Description="Nuke'EmIDesc",HelpText="Nuke'EmIHelp",EXPBonus=500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(302)=(ChallengeID=321,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=164,ExtraOptions="?Threshold=10",Name="Nuke'EmII",Description="Nuke'EmIIDesc",HelpText="Nuke'EmIIHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(303)=(ChallengeID=322,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=164,ExtraOptions="?Threshold=50",Name="Nuke'EmIII",Description="Nuke'EmIIIDesc",HelpText="Nuke'EmIIIHelp",EXPBonus=5000,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_chef",AttachBone=mount_glasses,image="ChangeRoom.Menu.dukes_hats_chef",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(304)=(ChallengeID=323,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=164,ExtraOptions="?Threshold=150",Name="Nuke'EmIV",Description="Nuke'EmIVDesc",HelpText="Nuke'EmIVHelp",EXPBonus=15000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=75,AMName="",IsPurchased=true)
    ChallengesArray(305)=(ChallengeID=324,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=200,ExtraOptions="?Threshold=1",Name="Overkill",Description="OverkillDesc",HelpText="OverkillHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="",AttachBone=,,image="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_22",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_logo_d_22",IsPurchased=true)
    ChallengesArray(306)=(ChallengeID=325,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=206,ExtraOptions="?Threshold=1",Name="BreakingtheMold",Description="BreakingtheMoldDesc",HelpText="BreakingtheMoldHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="sm_class_dukeitems.Glasses.Dukes_Glasses_Goggles",AttachBone=mount_glasses,image="Changeroom.menu.Dukes_Glasses_Goggles",LockedImageIdx=0,Category=3,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(307)=(ChallengeID=326,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=207,ExtraOptions="?Threshold=1",Name="DanceParty",Description="DancePartyDesc",HelpText="DancePartyHelp",EXPBonus=5000,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_headphones",AttachBone=mount_glasses,image="ChangeRoom.Menu.dukes_hats_headphones",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(308)=(ChallengeID=327,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=208,ExtraOptions="?Threshold=1?Match=True",Name="HotPotato",Description="HotPotatoDesc",HelpText="HotPotatoHelp",EXPBonus=5000,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_football",AttachBone=mount_glasses,image="ChangeRoom.Menu.dukes_hats_football",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(309)=(ChallengeID=328,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=211,ExtraOptions="?Threshold=1",Name="OgreRush",Description="OgreRushDesc",HelpText="OgreRushHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_viking",AttachBone=mount_glasses,image="ChangeRoom.Menu.dukes_hats_viking",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(310)=(ChallengeID=329,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=201,ExtraOptions="?Threshold=1",Name="Joust",Description="JoustDesc",HelpText="JoustHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="sm_class_dukeitems.Glasses.dukes_glasses_beaked",AttachBone=mount_glasses,image="ChangeRoom.Menu.dukes_glasses_beaked",LockedImageIdx=0,Category=3,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(311)=(ChallengeID=330,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=210,ExtraOptions="?Threshold=1",Name="OneShotOneKill",Description="OneShotOneKillDesc",HelpText="OneShotOneKillHelp",EXPBonus=5000,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_alien",AttachBone=mount_glasses,image="ChangeRoom.Menu.dukes_hats_alien",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(312)=(ChallengeID=331,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=202,ExtraOptions="?Threshold=1",Name="FromBeyondtheGrave",Description="FromBeyondtheGraveDesc",HelpText="FromBeyondtheGraveHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_pumpkin",AttachBone=mount_glasses,image="ChangeRoom.Menu.dukes_hats_pumpkin",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(313)=(ChallengeID=332,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=209,ExtraOptions="?Threshold=1",Name="GiantKiller",Description="GiantKillerDesc",HelpText="GiantKillerHelp",EXPBonus=2500,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_fez",AttachBone=mount_glasses,image="ChangeRoom.Menu.dukes_hats_fez",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(314)=(ChallengeID=333,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=235,ExtraOptions="?Threshold=5",Name="StuckOnYouI",Description="StuckOnYouIDesc",HelpText="StuckOnYouIHelp",EXPBonus=500,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(315)=(ChallengeID=334,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=235,ExtraOptions="?Threshold=10",Name="StuckOnYouII",Description="StuckOnYouIIDesc",HelpText="StuckOnYouIIHelp",EXPBonus=1000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(316)=(ChallengeID=335,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=235,ExtraOptions="?Threshold=50",Name="StuckOnYouIII",Description="StuckOnYouIIIDesc",HelpText="StuckOnYouIIIHelp",EXPBonus=5000,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_miner",AttachBone=mount_glasses,image="ChangeRoom.Menu.dukes_hats_miner",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(317)=(ChallengeID=336,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=235,ExtraOptions="?Threshold=150",Name="StuckOnYouIV",Description="StuckOnYouIVDesc",HelpText="StuckOnYouIVHelp",EXPBonus=15000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=63,AMName="",IsPurchased=true)
    ChallengesArray(318)=(ChallengeID=348,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=213,ExtraOptions="?Threshold=1",Name="SecretArea:MorningWood",Description="SecretArea:MorningWoodDesc",HelpText="SecretArea:MorningWoodHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(319)=(ChallengeID=349,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=214,ExtraOptions="?Threshold=1",Name="SecretArea:HooverDamned",Description="SecretArea:HooverDamnedDesc",HelpText="SecretArea:HooverDamnedHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(320)=(ChallengeID=350,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=215,ExtraOptions="?Threshold=1",Name="SecretArea:DukeBurger",Description="SecretArea:DukeBurgerDesc",HelpText="SecretArea:DukeBurgerHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(321)=(ChallengeID=351,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=216,ExtraOptions="?Threshold=1",Name="SecretArea:VegasRuins",Description="SecretArea:VegasRuinsDesc",HelpText="SecretArea:VegasRuinsHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(322)=(ChallengeID=352,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=217,ExtraOptions="?Threshold=1",Name="SecretArea:Hive",Description="SecretArea:HiveDesc",HelpText="SecretArea:HiveHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(323)=(ChallengeID=353,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=218,ExtraOptions="?Threshold=1",Name="SecretArea:Industrial",Description="SecretArea:IndustrialDesc",HelpText="SecretArea:IndustrialHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(324)=(ChallengeID=354,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=219,ExtraOptions="?Threshold=1",Name="SecretArea:Casino",Description="SecretArea:CasinoDesc",HelpText="SecretArea:CasinoHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(325)=(ChallengeID=355,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=220,ExtraOptions="?Threshold=1",Name="SecretArea:Construction",Description="SecretArea:ConstructionDesc",HelpText="SecretArea:ConstructionHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(326)=(ChallengeID=356,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=222,ExtraOptions="?Threshold=1",Name="SecretArea:HighwayNoon",Description="SecretArea:HighwayNoonDesc",HelpText="SecretArea:HighwayNoonHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(327)=(ChallengeID=357,ChallObjClass="dnGame.ChallengeObject_Stat",ChallDependencies=none,StatDependency=223,ExtraOptions="?Threshold=1",Name="SecretArea:Hollywood",Description="SecretArea:HollywoodDesc",HelpText="SecretArea:HollywoodHelp",EXPBonus=100,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=0,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(328)=(ChallengeID=358,ChallObjClass="dnGame.ChallengeObject_Nested",ChallDependencies=(348,349,350,351,352,353,354,355,356,357),StatDependency=0,ExtraOptions="",Name="SecretSnoop",Description="SecretSnoopDesc",HelpText="SecretSnoopHelp",EXPBonus=1500,SearchTag=fred,AttachMesh="sm_class_dukeitems.Hats.dukes_hats_pith",AttachBone=mount_glasses,image="ChangeRoom.Menu.dukes_hats_pith",LockedImageIdx=0,Category=2,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(329)=(ChallengeID=360,ChallObjClass="dnGame.ChallengeObject_Nested",ChallDependencies=(14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,111,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,177,178,179,180,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,256,257,258,259,260,261,263,264,265,266,267,268,269,270,271,272,273,274,275,276,277,278,279,280,281,282,283,284,285,286,287,288,289,290,291,292,293,294,295,296,297,298,299,300,301,302,303,304,305,306,307,308,309,310,311,312,313,314,315,316,317,318,319,320,321,322,323,324,325,326,327,328,329,330,331,332,333,334,335,336,348,349,350,351,352,353,354,355,356,357,358,359,607),StatDependency=0,ExtraOptions="",Name="Perfectionist",Description="PerfectionistDesc",HelpText="PerfectionistHelp",EXPBonus=100000,SearchTag=fred,AttachMesh="",AttachBone=,,image="",LockedImageIdx=0,Category=7,ShirtColorIdx=0,TitleIdx=76,AMName="",IsPurchased=true)
    ChallengesArray(330)=(ChallengeID=500,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=42",Name="Airhockey",Description="AirhockeyDesc",HelpText="AirhockeyHelp",EXPBonus=0,SearchTag=u-airhockey,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Games_AirHockey",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(331)=(ChallengeID=501,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=41",Name="AlienAbortion",Description="AlienAbortionDesc",HelpText="AlienAbortionHelp",EXPBonus=0,SearchTag=u-alienabortion,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Games_AlienAbortion",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(332)=(ChallengeID=502,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=39",Name="ArcadeHoops",Description="ArcadeHoopsDesc",HelpText="ArcadeHoopsHelp",EXPBonus=0,SearchTag=u-arcadehoops,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Games_ArcadeHoops",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(333)=(ChallengeID=503,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=37",Name="Pinball",Description="PinballDesc",HelpText="PinballHelp",EXPBonus=0,SearchTag=u-pinball,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Games_Pinball",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(334)=(ChallengeID=504,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=36",Name="PoolTable",Description="PoolTableDesc",HelpText="PoolTableHelp",EXPBonus=0,SearchTag=u-pooltable,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Games_PoolTable",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(335)=(ChallengeID=505,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=38",Name="SlotMachine",Description="SlotMachineDesc",HelpText="SlotMachineHelp",EXPBonus=0,SearchTag=u-slotmachine,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Games_SlotMachine",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(336)=(ChallengeID=506,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=35",Name="VideoPoker",Description="VideoPokerDesc",HelpText="VideoPokerHelp",EXPBonus=0,SearchTag=u-videopoker,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Games_VideoPoker",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(337)=(ChallengeID=507,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=33",Name="BasketballHoopBalls",Description="BasketballHoopBallsDesc",HelpText="BasketballHoopBallsHelp",EXPBonus=0,SearchTag=u-basketball,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Gym_BasketballHoop",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(338)=(ChallengeID=508,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=16",Name="PunchingBag",Description="PunchingBagDesc",HelpText="PunchingBagHelp",EXPBonus=0,SearchTag=u-punchingbag,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Gym_PunchingBag",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(339)=(ChallengeID=509,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=34",Name="SpeedBag",Description="SpeedBagDesc",HelpText="SpeedBagHelp",EXPBonus=0,SearchTag=u-speedbag,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Gym_SpeedBag",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(340)=(ChallengeID=510,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=21",Name="Weightbench",Description="WeightbenchDesc",HelpText="WeightbenchHelp",EXPBonus=0,SearchTag=u-weightbench,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Gym_WeightBench",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(341)=(ChallengeID=511,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=18",Name="Freeweights",Description="FreeweightsDesc",HelpText="FreeweightsHelp",EXPBonus=0,SearchTag=u-freeweights,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Gym_FreeWeights",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(342)=(ChallengeID=512,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=19",Name="Cigar",Description="CigarDesc",HelpText="CigarHelp",EXPBonus=0,SearchTag=u-cigar,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Misc_Cigar",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(343)=(ChallengeID=513,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=11",Name="CigaretteMachine",Description="CigaretteMachineDesc",HelpText="CigaretteMachineHelp",EXPBonus=0,SearchTag=u-cigarettemachine,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Misc_CigaretteMachine",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(344)=(ChallengeID=514,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=6",Name="Donuts",Description="DonutsDesc",HelpText="DonutsHelp",EXPBonus=0,SearchTag=u-donuts,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Misc_Donuts",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(345)=(ChallengeID=515,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=26",Name="NeonSigns",Description="NeonSignsDesc",HelpText="NeonSignsHelp",EXPBonus=0,SearchTag=u-neonsigns,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Misc_NeonSigns",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(346)=(ChallengeID=516,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=17",Name="Snack Machine",Description="Snack MachineDesc",HelpText="Snack MachineHelp",EXPBonus=0,SearchTag=u-snackmachine,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Misc_SnackMachine",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(347)=(ChallengeID=517,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=21",Name="Steroids",Description="SteroidsDesc",HelpText="SteroidsHelp",EXPBonus=0,SearchTag=u-steroids,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Misc_Steroids",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(348)=(ChallengeID=518,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=31",Name="Throne",Description="ThroneDesc",HelpText="ThroneHelp",EXPBonus=0,SearchTag=u-throne,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Misc_Throne",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(349)=(ChallengeID=519,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=13",Name="AstronautDuke",Description="AstronautDukeDesc",HelpText="AstronautDukeHelp",EXPBonus=0,SearchTag=u-astronautduke,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Pictures_AstronautDuke",LockedImageIdx=2,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(350)=(ChallengeID=520,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=9",Name="AwardsDuke",Description="AwardsDukeDesc",HelpText="AwardsDukeHelp",EXPBonus=0,SearchTag=u-awardsduke,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Pictures_AwardsDuke",LockedImageIdx=2,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(351)=(ChallengeID=521,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=2",Name="BoxingDuke",Description="BoxingDukeDesc",HelpText="BoxingDukeHelp",EXPBonus=0,SearchTag=u-boxingduke,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Pictures_BoxingDuke",LockedImageIdx=2,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(352)=(ChallengeID=522,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=5",Name="CigarDuke",Description="CigarDukeDesc",HelpText="CigarDukeHelp",EXPBonus=0,SearchTag=u-cigarduke,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Pictures_CigarDuke",LockedImageIdx=2,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(353)=(ChallengeID=523,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=3",Name="DukePortrait",Description="DukePortraitDesc",HelpText="DukePortraitHelp",EXPBonus=0,SearchTag=u-dukeportrait,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Pictures_DukePortrait",LockedImageIdx=2,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(354)=(ChallengeID=524,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=14",Name="FootballDuke",Description="FootballDukeDesc",HelpText="FootballDukeHelp",EXPBonus=0,SearchTag=u-footballduke,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Pictures_FootballDuke",LockedImageIdx=2,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(355)=(ChallengeID=525,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=5",Name="MountainClimbingDuke",Description="MountainClimbingDukeDesc",HelpText="MountainClimbingDukeHelp",EXPBonus=0,SearchTag=u-mountainduke,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Pictures_MountainClimbingDuke",LockedImageIdx=2,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(356)=(ChallengeID=526,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=15",Name="PokerDuke",Description="PokerDukeDesc",HelpText="PokerDukeHelp",EXPBonus=0,SearchTag=u-pokerduke,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Pictures_PokerDuke",LockedImageIdx=2,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(357)=(ChallengeID=527,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=4",Name="SharkDuke",Description="SharkDukeDesc",HelpText="SharkDukeHelp",EXPBonus=0,SearchTag=u-sharkduke,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Pictures_SharkDuke",LockedImageIdx=2,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(358)=(ChallengeID=528,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=23",Name="SoldierDuke",Description="SoldierDukeDesc",HelpText="SoldierDukeHelp",EXPBonus=0,SearchTag=u-soldierduke,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Pictures_SoldierDuke",LockedImageIdx=2,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(359)=(ChallengeID=529,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=10",Name="BabeStatue1",Description="BabeStatue1Desc",HelpText="BabeStatue1Help",EXPBonus=0,SearchTag=u-babestatue1,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Statues_Babe1",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(360)=(ChallengeID=530,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=20",Name="BabeStatue2",Description="BabeStatue2Desc",HelpText="BabeStatue2Help",EXPBonus=0,SearchTag=u-babestatue2,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Statues_Babe2",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(361)=(ChallengeID=531,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=30",Name="BabeStatue3",Description="BabeStatue3Desc",HelpText="BabeStatue3Help",EXPBonus=0,SearchTag=u-babestatue3,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Statues_Babe3",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(362)=(ChallengeID=532,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=40",Name="BabeStatue4",Description="BabeStatue4Desc",HelpText="BabeStatue4Help",EXPBonus=0,SearchTag=u-babestatue4,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Statues_Babe4",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(363)=(ChallengeID=533,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=7",Name="DukeCardboardCutout",Description="DukeCardboardCutoutDesc",HelpText="DukeCardboardCutoutHelp",EXPBonus=0,SearchTag=u-dukecutout,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Statues_DukeCardboard",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(364)=(ChallengeID=534,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=8",Name="DukeGlobe",Description="DukeGlobeDesc",HelpText="DukeGlobeHelp",EXPBonus=0,SearchTag=u-dukeglobe,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Statues_DukeGlobe",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(365)=(ChallengeID=535,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=28",Name="Octabrain",Description="OctabrainDesc",HelpText="OctabrainHelp",EXPBonus=0,SearchTag=u-octabrain,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Statues_Octabrain",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(366)=(ChallengeID=536,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=29",Name="Pigcop",Description="PigcopDesc",HelpText="PigcopHelp",EXPBonus=0,SearchTag=u-pigcop,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Statues_PigCop",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(367)=(ChallengeID=537,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=25",Name="RemoteControlAnimatedDuke",Description="RemoteControlAnimatedDukeDesc",HelpText="RemoteControlAnimatedDukeHelp",EXPBonus=0,SearchTag=u-rcduke,AttachMesh="",AttachBone=None,image="dt_MyDigs.Menu.Statues_RemoteDuke",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(368)=(ChallengeID=538,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=6",Name="Plaque_Enforcer",Description="Plaque_EnforcerDesc",HelpText="Plaque_EnforcerHelp",EXPBonus=0,SearchTag=u-plaqueEnforcer,AttachMesh="",AttachBone=,,image="dt_MyDigs.Menu.Trophy_Enforcer",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(369)=(ChallengeID=539,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=10",Name="Plaque_Battlelord",Description="Plaque_BattlelordDesc",HelpText="Plaque_BattlelordHelp",EXPBonus=0,SearchTag=u-plaqueBattlelord,AttachMesh="",AttachBone=,,image="dt_MyDigs.Menu.Trophy_Battlelord",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(370)=(ChallengeID=540,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=12",Name="Retro_Paintings",Description="Retro_PaintingsDesc",HelpText="Retro_PaintingsHelp",EXPBonus=0,SearchTag=u-paintingsRetro,AttachMesh="",AttachBone=,,image="dt_MyDigs.Menu.Pictures_Retro",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(371)=(ChallengeID=541,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=16",Name="Toy_Duke",Description="Toy_DukeDesc",HelpText="Toy_DukeHelp",EXPBonus=0,SearchTag=u-toyDuke,AttachMesh="",AttachBone=,,image="dt_MyDigs.Menu.Toy_Duke",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(372)=(ChallengeID=542,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=20",Name="Plaque_CycloidEmperor",Description="Plaque_CycloidEmperorDesc",HelpText="Plaque_CycloidEmperorHelp",EXPBonus=0,SearchTag=u-plaqueCycloidEmperor,AttachMesh="",AttachBone=,,image="dt_MyDigs.Menu.Trophy_CycloidEmperor",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(373)=(ChallengeID=543,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=22",Name="Toy_Accessories",Description="Toy_AccessoriesDesc",HelpText="Toy_AccessoriesHelp",EXPBonus=0,SearchTag=u-toyAccessories,AttachMesh="",AttachBone=,,image="dt_MyDigs.Menu.Toy_Accesories",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(374)=(ChallengeID=544,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=22",Name="Classic_Paintings",Description="Classic_PaintingsDesc",HelpText="Classic_PaintingsHelp",EXPBonus=0,SearchTag=u-paintingsClassic,AttachMesh="",AttachBone=,,image="dt_MyDigs.Menu.Pictures_Classical",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(375)=(ChallengeID=545,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=23",Name="Plaque_PigCopHelmet",Description="Plaque_PigCopHelmetDesc",HelpText="Plaque_PigCopHelmetHelp",EXPBonus=0,SearchTag=u-plaquePigCopHelmet,AttachMesh="",AttachBone=,,image="dt_MyDigs.Menu.Trophy_PigCopHelm",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(376)=(ChallengeID=546,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=24",Name="Modern_Paintings",Description="Modern_PaintingsDesc",HelpText="Modern_PaintingsHelp",EXPBonus=0,SearchTag=u-paintingsModern,AttachMesh="",AttachBone=,,image="dt_MyDigs.Menu.Pictures_Modern",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(377)=(ChallengeID=547,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=25",Name="Toy_Playsets",Description="Toy_PlaysetsDesc",HelpText="Toy_PlaysetsHelp",EXPBonus=0,SearchTag=u-toyPlaysets,AttachMesh="",AttachBone=,,image="dt_MyDigs.Menu.Toy_Playset",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(378)=(ChallengeID=548,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=27",Name="Cycloid_Eye_Statue",Description="Cycloid_Eye_StatueDesc",HelpText="Cycloid_Eye_StatueHelp",EXPBonus=0,SearchTag=u-statueCycloidEye,AttachMesh="",AttachBone=,,image="dt_MyDigs.Menu.Statue_CycloidEye",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(379)=(ChallengeID=549,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=28",Name="Plaque_Octabrain_small",Description="Plaque_Octabrain_smallDesc",HelpText="Plaque_Octabrain_smallHelp",EXPBonus=0,SearchTag=u-plaqueOctabrainSmall,AttachMesh="",AttachBone=,,image="dt_MyDigs.Menu.Trophy_OctabrainSmall",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(380)=(ChallengeID=550,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=29",Name="Plaque_Pigcop",Description="Plaque_PigcopDesc",HelpText="Plaque_PigcopHelp",EXPBonus=0,SearchTag=u-plaquePigCop,AttachMesh="",AttachBone=,,image="dt_MyDigs.Menu.Trophy_Pigcop",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(381)=(ChallengeID=551,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=29",Name="Toy_Pigcop",Description="Toy_PigcopDesc",HelpText="Toy_PigcopHelp",EXPBonus=0,SearchTag=u-toyPigCop,AttachMesh="",AttachBone=,,image="dt_MyDigs.Menu.Toy_Pigcop",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(382)=(ChallengeID=552,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=30",Name="Plaque_Octababy",Description="Plaque_OctababyDesc",HelpText="Plaque_OctababyHelp",EXPBonus=0,SearchTag=u-plaqueOctababy,AttachMesh="",AttachBone=,,image="dt_MyDigs.Menu.Trophy_Octababy",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(383)=(ChallengeID=553,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=32",Name="Plaque_EnergyLeech",Description="Plaque_EnergyLeechDesc",HelpText="Plaque_EnergyLeechHelp",EXPBonus=0,SearchTag=u-plaqueEnergyLeech,AttachMesh="",AttachBone=,,image="dt_MyDigs.Menu.Trophy_EnergyLeech",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(384)=(ChallengeID=554,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=35",Name="Devastator_Statue",Description="Devastator_StatueDesc",HelpText="Devastator_StatueHelp",EXPBonus=0,SearchTag=u-statueDevastator,AttachMesh="",AttachBone=,,image="dt_MyDigs.Menu.Statue_Devistator",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(385)=(ChallengeID=555,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=39",Name="Plaque_Octabrain_large",Description="Plaque_Octabrain_largeDesc",HelpText="Plaque_Octabrain_largeHelp",EXPBonus=0,SearchTag=u-plaqueOctabrainLarge,AttachMesh="",AttachBone=,,image="dt_MyDigs.Menu.Trophy_OctabrainLarge",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(386)=(ChallengeID=556,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=40",Name="PigRug",Description="PigRugDesc",HelpText="PigRugHelp",EXPBonus=0,SearchTag=u-pigRug,AttachMesh="",AttachBone=,,image="dt_MyDigs.Menu.Statue_PigRug",LockedImageIdx=3,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(387)=(ChallengeID=557,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=40",Name="Toy_Babes",Description="Toy_BabesDesc",HelpText="Toy_BabesHelp",EXPBonus=0,SearchTag=u-toyBabes,AttachMesh="",AttachBone=,,image="dt_MyDigs.Menu.Toy_Babes",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(388)=(ChallengeID=558,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=41",Name="Plaque_BugBall",Description="Plaque_BugBallDesc",HelpText="Plaque_BugBallHelp",EXPBonus=0,SearchTag=u-plaqueBugBall,AttachMesh="",AttachBone=,,image="dt_MyDigs.Menu.Trophy_BugBall",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(389)=(ChallengeID=559,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=42",Name="Plaque_AlienQueen",Description="Plaque_AlienQueenDesc",HelpText="Plaque_AlienQueenHelp",EXPBonus=0,SearchTag=u-plaqueAlienQueen,AttachMesh="",AttachBone=,,image="dt_MyDigs.Menu.Trophy_AlienQueen",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(390)=(ChallengeID=600,ChallObjClass="dnGame.ChallengeObject_Unlocked",ChallDependencies=none,StatDependency=239,ExtraOptions="?Default=Show",Name="Maid",Description="MaidDesc",HelpText="MaidHelp",EXPBonus=0,SearchTag=prestige1,AttachMesh="",AttachBone=None,image="Menu.MP.babeUnlock_kittyPousoix",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(391)=(ChallengeID=601,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=10",Name="AsianBabe",Description="AsianBabeDesc",HelpText="AsianBabeHelp",EXPBonus=0,SearchTag=prestige2,AttachMesh="",AttachBone=None,image="Menu.MP.BabeUnlock_MisoHoney",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(392)=(ChallengeID=602,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=20",Name="FoxyBabe",Description="FoxyBabeDesc",HelpText="FoxyBabeHelp",EXPBonus=0,SearchTag=prestige3,AttachMesh="",AttachBone=None,image="Menu.MP.BabeUnlock_FunkyCleopatra",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(393)=(ChallengeID=603,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=30",Name="SoldierBabe",Description="SoldierBabeDesc",HelpText="SoldierBabeHelp",EXPBonus=0,SearchTag=prestige4,AttachMesh="",AttachBone=None,image="Menu.MP.BabeUnlock_sgtPepa",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(394)=(ChallengeID=604,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=40",Name="SportyBabe",Description="SportyBabeDesc",HelpText="SportyBabeHelp",EXPBonus=0,SearchTag=prestige5,AttachMesh="",AttachBone=None,image="Menu.MP.BabeUnlock_sporty",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(395)=(ChallengeID=605,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=41",Name="SchoolBabe",Description="SchoolBabeDesc",HelpText="SchoolBabeHelp",EXPBonus=0,SearchTag=prestige6,AttachMesh="",AttachBone=None,image="Menu.MP.BabeUnlock_Chastity",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(396)=(ChallengeID=606,ChallObjClass="dnGame.ChallengeObject_Level",ChallDependencies=none,StatDependency=239,ExtraOptions="?Threshold=42",Name="TwinBabes",Description="TwinBabesDesc",HelpText="TwinBabesHelp",EXPBonus=0,SearchTag=prestige7,AttachMesh="",AttachBone=None,image="Menu.MP.BabeUnlock_twins",LockedImageIdx=0,Category=1,ShirtColorIdx=0,TitleIdx=0,AMName="",IsPurchased=true)
    ChallengesArray(397)=(ChallengeID=-15,ChallObjClass="dnGame.ChallengeObject_Unlocked",ChallDependencies=none,StatDependency=0,ExtraOptions="?Default=Hide",Name="POG_Gamestop_USA",Description="",HelpText="",EXPBonus=0,SearchTag=fred,AttachMesh="",AttachBone=None,image="mt_skinsMaleBod.duke_mp_logos.duke_promo_d_GameStop_USA",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_promo_d_GameStop_USA",IsPurchased=false)
    ChallengesArray(398)=(ChallengeID=-16,ChallObjClass="dnGame.ChallengeObject_Unlocked",ChallDependencies=none,StatDependency=0,ExtraOptions="?Default=Hide",Name="POG_Stripper_Asia",Description="",HelpText="",EXPBonus=0,SearchTag=fred,AttachMesh="",AttachBone=None,image="mt_skinsMaleBod.duke_mp_logos.duke_promo_d_Stripper_Asia",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_promo_d_Stripper_Asia",IsPurchased=false)
    ChallengesArray(399)=(ChallengeID=-5,ChallObjClass="dnGame.ChallengeObject_Unlocked",ChallDependencies=none,StatDependency=0,ExtraOptions="?Default=Hide",Name="POG_GearBox",Description="POGearBoxDesc",HelpText="POGearBoxHelp",EXPBonus=0,SearchTag=fred,AttachMesh="",AttachBone=None,image="mt_skinsMaleBod.duke_mp_logos.duke_promo_d_Gearbox",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_promo_d_Gearbox",IsPurchased=false)
    ChallengesArray(400)=(ChallengeID=-6,ChallObjClass="dnGame.ChallengeObject_Unlocked",ChallDependencies=none,StatDependency=0,ExtraOptions="?Default=Hide",Name="POG_Triptych",Description="POTriptychDesc",HelpText="POTriptychHelp",EXPBonus=0,SearchTag=fred,AttachMesh="",AttachBone=None,image="mt_skinsMaleBod.duke_mp_logos.duke_promo_d_Triptyeh",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_promo_d_Triptyeh",IsPurchased=false)
    ChallengesArray(401)=(ChallengeID=-7,ChallObjClass="dnGame.ChallengeObject_Unlocked",ChallDependencies=none,StatDependency=0,ExtraOptions="?Default=Hide",Name="POG_Piranha",Description="POPiranhaDesc",HelpText="POPiranhaHelp",EXPBonus=0,SearchTag=fred,AttachMesh="",AttachBone=None,image="mt_skinsMaleBod.duke_mp_logos.duke_promo_d_Piranha",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_promo_d_Piranha",IsPurchased=false)
    ChallengesArray(402)=(ChallengeID=-8,ChallObjClass="dnGame.ChallengeObject_Unlocked",ChallDependencies=none,StatDependency=0,ExtraOptions="?Default=Hide",Name="POG_3DRealms",Description="PO3DRealmsDesc",HelpText="PO3DRealmsHelp",EXPBonus=0,SearchTag=fred,AttachMesh="",AttachBone=None,image="mt_skinsMaleBod.duke_mp_logos.duke_promo_d_3DRealms",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_promo_d_3DRealms",IsPurchased=false)
    ChallengesArray(403)=(ChallengeID=-9,ChallObjClass="dnGame.ChallengeObject_Unlocked",ChallDependencies=none,StatDependency=0,ExtraOptions="?Default=Hide",Name="POG_2KGames",Description="PO2KGamesDesc",HelpText="PO2KGamesHelp",EXPBonus=0,SearchTag=fred,AttachMesh="",AttachBone=None,image="mt_skinsMaleBod.duke_mp_logos.duke_promo_d_2KGames",LockedImageIdx=0,Category=5,ShirtColorIdx=0,TitleIdx=0,AMName="mt_skinsMaleBod.duke_mp_logos.duke_promo_d_2KGames",IsPurchased=false)
    PlainShirtId=1
    NoHadId=2
    WhiteColourId=3
    NoTitleID=262
    EndofDefaultUnlocks=14
    PreorderGroups(0)=(Group=1,IDs=(-5,-6,-7,-8,-9),bUnlockDBP=false)
    PreorderGroups(1)=(Group=2,IDs=(-15),bUnlockDBP=true)
    PreorderGroups(2)=(Group=3,IDs=(-16),bUnlockDBP=true)
    PlayerTitles(0)=(id=0,Tag="Tag0")
    PlayerTitles(1)=(id=1,Tag="Tag1")
    PlayerTitles(2)=(id=2,Tag="Tag2")
    PlayerTitles(3)=(id=3,Tag="Tag3")
    PlayerTitles(4)=(id=4,Tag="Tag4")
    PlayerTitles(5)=(id=5,Tag="Tag5")
    PlayerTitles(6)=(id=6,Tag="Tag6")
    PlayerTitles(7)=(id=7,Tag="Tag7")
    PlayerTitles(8)=(id=8,Tag="Tag8")
    PlayerTitles(9)=(id=9,Tag="Tag9")
    PlayerTitles(10)=(id=10,Tag="Tag10")
    PlayerTitles(11)=(id=11,Tag="Tag11")
    PlayerTitles(12)=(id=12,Tag="Tag12")
    PlayerTitles(13)=(id=13,Tag="Tag13")
    PlayerTitles(14)=(id=14,Tag="Tag14")
    PlayerTitles(15)=(id=15,Tag="Tag15")
    PlayerTitles(16)=(id=16,Tag="Tag16")
    PlayerTitles(17)=(id=17,Tag="Tag17")
    PlayerTitles(18)=(id=18,Tag="Tag18")
    PlayerTitles(19)=(id=19,Tag="Tag19")
    PlayerTitles(20)=(id=20,Tag="Tag20")
    PlayerTitles(21)=(id=21,Tag="Tag21")
    PlayerTitles(22)=(id=22,Tag="Tag22")
    PlayerTitles(23)=(id=23,Tag="Tag23")
    PlayerTitles(24)=(id=24,Tag="Tag24")
    PlayerTitles(25)=(id=25,Tag="Tag25")
    PlayerTitles(26)=(id=26,Tag="Tag26")
    PlayerTitles(27)=(id=27,Tag="Tag27")
    PlayerTitles(28)=(id=28,Tag="Tag28")
    PlayerTitles(29)=(id=29,Tag="Tag29")
    PlayerTitles(30)=(id=30,Tag="Tag30")
    PlayerTitles(31)=(id=31,Tag="Tag31")
    PlayerTitles(32)=(id=32,Tag="Tag32")
    PlayerTitles(33)=(id=33,Tag="Tag33")
    PlayerTitles(34)=(id=34,Tag="Tag34")
    PlayerTitles(35)=(id=35,Tag="Tag35")
    PlayerTitles(36)=(id=36,Tag="Tag36")
    PlayerTitles(37)=(id=37,Tag="Tag37")
    PlayerTitles(38)=(id=38,Tag="Tag38")
    PlayerTitles(39)=(id=39,Tag="Tag39")
    PlayerTitles(40)=(id=40,Tag="Tag40")
    PlayerTitles(41)=(id=41,Tag="Tag41")
    PlayerTitles(42)=(id=42,Tag="Tag42")
    PlayerTitles(43)=(id=43,Tag="Tag43")
    PlayerTitles(44)=(id=44,Tag="Tag44")
    PlayerTitles(45)=(id=45,Tag="Tag45")
    PlayerTitles(46)=(id=46,Tag="Tag46")
    PlayerTitles(47)=(id=47,Tag="Tag47")
    PlayerTitles(48)=(id=48,Tag="Tag48")
    PlayerTitles(49)=(id=49,Tag="Tag49")
    PlayerTitles(50)=(id=50,Tag="Tag50")
    PlayerTitles(51)=(id=51,Tag="Tag51")
    PlayerTitles(52)=(id=52,Tag="Tag52")
    PlayerTitles(53)=(id=53,Tag="Tag53")
    PlayerTitles(54)=(id=54,Tag="Tag54")
    PlayerTitles(55)=(id=55,Tag="Tag55")
    PlayerTitles(56)=(id=56,Tag="Tag56")
    PlayerTitles(57)=(id=57,Tag="Tag57")
    PlayerTitles(58)=(id=58,Tag="Tag58")
    PlayerTitles(59)=(id=59,Tag="Tag59")
    PlayerTitles(60)=(id=60,Tag="Tag60")
    PlayerTitles(61)=(id=61,Tag="Tag61")
    PlayerTitles(62)=(id=62,Tag="Tag62")
    PlayerTitles(63)=(id=63,Tag="Tag63")
    PlayerTitles(64)=(id=64,Tag="Tag64")
    PlayerTitles(65)=(id=65,Tag="Tag65")
    PlayerTitles(66)=(id=66,Tag="Tag66")
    PlayerTitles(67)=(id=67,Tag="Tag67")
    PlayerTitles(68)=(id=68,Tag="Tag68")
    PlayerTitles(69)=(id=69,Tag="Tag69")
    PlayerTitles(70)=(id=70,Tag="Tag70")
    PlayerTitles(71)=(id=71,Tag="Tag71")
    PlayerTitles(72)=(id=72,Tag="Tag72")
    PlayerTitles(73)=(id=73,Tag="Tag73")
    PlayerTitles(74)=(id=74,Tag="Tag74")
    PlayerTitles(75)=(id=75,Tag="Tag75")
    PlayerTitles(76)=(id=76,Tag="Tag76")
    LevelingInfo(0)=(Stat=1,XPAmount=0,LocTag="ExpGain_S_CHALLENGE")
    LevelingInfo(1)=(Stat=2,XPAmount=20,LocTag="ExpGain_S_KILLS")
    LevelingInfo(2)=(Stat=4,XPAmount=-10,LocTag="ExpGain_S_SUICIDE")
    LevelingInfo(3)=(Stat=238,XPAmount=-10,LocTag="ExpGain_S_TEAMCHANGESUICIDE")
    LevelingInfo(4)=(Stat=15,XPAmount=25,LocTag="ExpGain_S_CTBCAPTURES")
    LevelingInfo(5)=(Stat=43,XPAmount=25,LocTag="ExpGain_S_PISSESTAKEN")
    LevelingInfo(6)=(Stat=17,XPAmount=10,LocTag="ExpGain_S_CTBKILLSOFBABECARRIER")
    LevelingInfo(7)=(Stat=128,XPAmount=10,LocTag="ExpGain_S_BABERETURNS")
    LevelingInfo(8)=(Stat=7,XPAmount=20,LocTag="ExpGain_S_MULTIKILL")
    LevelingInfo(9)=(Stat=38,XPAmount=15,LocTag="ExpGain_S_AERIALKILLS")
    LevelingInfo(10)=(Stat=131,XPAmount=5,LocTag="ExpGain_S_KILLASSIST")
    LevelingInfo(11)=(Stat=51,XPAmount=10,LocTag="ExpGain_S_SHOTPISTOL")
    LevelingInfo(12)=(Stat=9,XPAmount=50,LocTag="ExpGain_MATCHWON")
    LevelingInfo(13)=(Stat=11,XPAmount=50,LocTag="ExpGain_MATCHWON")
    LevelingInfo(14)=(Stat=13,XPAmount=50,LocTag="ExpGain_MATCHWON")
    LevelingInfo(15)=(Stat=109,XPAmount=50,LocTag="ExpGain_MATCHWON")
    XPToLevel(0)=0
    XPToLevel(1)=0
    XPToLevel(2)=1500
    XPToLevel(3)=2500
    XPToLevel(4)=3700
    XPToLevel(5)=5100
    XPToLevel(6)=6700
    XPToLevel(7)=8500
    XPToLevel(8)=10500
    XPToLevel(9)=12700
    XPToLevel(10)=15100
    XPToLevel(11)=17900
    XPToLevel(12)=21100
    XPToLevel(13)=24700
    XPToLevel(14)=28700
    XPToLevel(15)=33100
    XPToLevel(16)=37900
    XPToLevel(17)=43100
    XPToLevel(18)=48900
    XPToLevel(19)=55100
    XPToLevel(20)=62900
    XPToLevel(21)=71500
    XPToLevel(22)=80900
    XPToLevel(23)=91100
    XPToLevel(24)=102100
    XPToLevel(25)=113900
    XPToLevel(26)=126500
    XPToLevel(27)=140300
    XPToLevel(28)=155500
    XPToLevel(29)=172100
    XPToLevel(30)=190100
    XPToLevel(31)=211600
    XPToLevel(32)=235400
    XPToLevel(33)=260400
    XPToLevel(34)=287600
    XPToLevel(35)=317200
    XPToLevel(36)=349400
    XPToLevel(37)=382800
    XPToLevel(38)=418800
    XPToLevel(39)=457600
    XPToLevel(40)=499100
    XPToLevel(41)=627100
    XPToLevel(42)=827100
}