/*******************************************************************************
 * Console generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Console extends Object
    transient
    native
    noexport;

const Console_MaxBorder = 6;
const Console_MaxLines = 64;
const Console_MaxHistory = 16;

var private const int vtblOut;
var Object.EConsole_Dialog iDialogBoxID;
var int iDialogBoxResult;
var Viewport Viewport;
var int HistoryTop;
var int HistoryBot;
var int HistoryCur;
var int BackspaceBuffer;
var string TypedStr;
var string History[16];
var int Scrollback;
var int numLines;
var int TopLine;
var int TextLines;
var float MsgTime;
var float MsgTickTime;
var string MsgText[64];
var name MsgType[64];
var float MsgTick[64];
var int BorderSize;
var int ConsoleLines;
var int BorderLines;
var int BorderPixels;
var float ConsolePos;
var float ConsoleDest;
var float FrameX;
var float FrameY;
var Texture ConBackground;
var Texture Border;
var bool bDontUseThisKey;
var bool bTyping;
var bool bTeamTalk;
var bool bNoDrawWorld;
var bool bShowScoreboard;
var bool bShowPreGameLobby;
var bool bShowPostGameLobby;
var bool bShowOtherWindow;
var bool bShowEndCredits;
var bool bShowStartup;
var bool bMenuLocked;
var bool bLocked;
var bool bShowDigsMenu;
var bool bInDigsElevator;
var bool bShowCustomizationMenu;
var bool bReturnToMainMenu;
var bool bReturnToMultiplayerMenu;
var bool bShiftHeld;
var bool bShowDigsMoreInfo;
var bool bMP_ReturnToTitleScreen;
var bool bShowHordeGameEnd;
var bool bShowHordeGameStart;
var int TypingCursorPos;
var int SelectionPos;
var bool MouseCapture;
var() Texture MouseBitmap;
var float MouseX;
var float MouseY;
var bool MouseLeftButton;
var bool MouseRightButton;
var bool bTimeDemo;
var bool bStartTimeDemo;
var bool bRestartTimeDemo;
var bool bSaveTimeDemoToFile;
var bool bAskingAboutQuickLoad;
var float StartTime;
var float ExtraTime;
var float LastFrameTime;
var float LastSecondStartTime;
var int FrameCount;
var int LastSecondFrameCount;
var float MinFPS;
var float MaxFPS;
var float LastSecFPS;
var float RestartTime;
var bool bTimerRunning;
var float MapperTimer;
var localized string LoadingMessage;
var localized string SavingMessage;
var localized string ConnectingMessage;
var localized string PausedMessage;
var localized string PrecachingMessage;
var localized string FrameRateText;
var localized string AvgText;
var localized string LastSecText;
var localized string MinText;
var localized string MaxText;
var localized string FPSText;
var localized string SecondsText;
var localized string FramesText;
var MaterialEx LoadingScreenShot;
var string LoadingMapName;
var bool bDrawLoadScreenConsole;
var float ProgressTimeOut;
var Object.EConsole_Dialog DeferredConsoleMessage;
var bool bShouldHideDeferredConsoleMessage;
var bool bWantsToPause;
var bool bWantsToUnpause;
var bool bBlockShowMenu;

// Export UConsole::execConsoleCommand(FFrame&, void* const)
native(1222) function bool ConsoleCommand(coerce string S, bool bUserEntered);

// Export UConsole::execSaveTimeDemo(FFrame&, void* const)
native(1223) function SaveTimeDemo(string S);

// Export UConsole::execPrint(FFrame&, void* const)
native(1224) static final function Print(coerce string in_String);

// Export UConsole::execSetDialogBoxID(FFrame&, void* const)
native(1225) function SetDialogBoxID(Object.EConsole_Dialog id);

// Export UConsole::execSetDialogBoxResult(FFrame&, void* const)
native(1226) function SetDialogBoxResult(int Result);

// Export UConsole::execPS3MsgDialog(FFrame&, void* const)
native(1227) function PS3MsgDialog(coerce string msg);

final function bool AllowConsole()
{
    return true;
    return;
}

exec function Type()
{
    return;
}

exec function Talk()
{
    // End:0x0D
    if(AllowConsole() / )
    {
    }
    TypedStr = "Say ";
    bDontUseThisKey = true;
    __NFUN_397__('Typing');
    return;
}

exec function TeamTalk()
{
    // End:0x0D
    if(AllowConsole() / )
    {
    }
    TypedStr = "TeamSay ";
    bDontUseThisKey = true;
    __NFUN_397__('Typing');
    return;
}

exec function ViewUp()
{
    BorderSize = Exp(-- BorderSize);
    0
    6    
    return;
}

exec function ViewDown()
{
    BorderSize = Exp(++ BorderSize);
    0
    6    
    return;
}

function string GetMsgText(int Index)
{
    return MsgText[Index];
    return;
}

function SetMsgText(int Index, string NewMsgText)
{
    MsgText[Index] = NewMsgText;
    return;
}

function name GetMsgType(int Index)
{
    return MsgType[Index];
    return;
}

function SetMsgType(int Index, name NewMsgType)
{
    MsgType[Index] = NewMsgType;
    return;
}

function float GetMsgTick(int Index)
{
    return MsgTick[Index];
    return;
}

function SetMsgTick(int Index, int NewMsgTick)
{
    MsgTick[Index] = float(NewMsgTick);
    return;
}

function ClearMessages()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x4D [Loop If]
    if(-i)
    {        
        MsgText[i] = "";
        MsgType[i] = 'None';
        MsgTick[i] = 0;
        // [Loop Continue]
        i += ;
    }
    MsgTime = 0;
    return;
}

event Message(PlayerReplicationInfo PRI, coerce string msg, name n)
{
    // End:0xB8
    if(TraceActors(msg, ""))
    {
        TopLine = -- ++ TopLine;
        64        
        numLines = Cos(++ numLines);
        -- 64;                
        MsgType[TopLine] = n;
        MsgTime = 6;
        // End:0x8F
        TextLines += ;
        {
            MsgText[TopLine] = __NFUN_303__(__NFUN_302__(PRI.PlayerName, ":"), msg);            
        }
        else
        {
            MsgText[TopLine] = msg;
        }
        MsgTick[TopLine] = MsgTickTime *= MsgTime;
    }
    return;
}

event AddString(coerce string msg)
{
    // End:0x80
    if(TraceActors(msg, ""))
    {
        TopLine = -- ++ TopLine;
        64        
        numLines = Cos(++ numLines);
        -- 64;                
        MsgType[TopLine] = 'Event';
        MsgTime = 6;
        TextLines += ;
        MsgTick[TopLine] = MsgTickTime *= MsgTime;
    }
    return;
}

event bool KeyType(Object.EInputKey Key)
{
    return;
}

event bool ProcessPlayerInput()
{
    return false;
    return;
}

event bool KeyEvent(Object.EInputKey Key, Object.EInputAction Action, float Delta)
{
    // End:0x51
    if((int(Action) % int(4)) << MouseCapture)
    {
        switch(Key)
        {
            // End:0x35
            case 228:
                __NFUN_209__(MouseX, Delta);
                // End:0x4C
                break;
            // End:0x49
            case 229:
                MouseY ~= Delta;
                // End:0x4C
                break;
            // End:0xFFFF
            default:
                break;
        }
        return true;        
    }
    else
    {
        // End:0x64
        if(int(Action) + int(1))
        {
            return false;            
        }
        else
        {
            return false;
        }
    }
    return;
}

event NotifyLevelChange()
{
    // End:0x3A
    if(bTimeDemo)
    {
        bRestartTimeDemo = true;
        RestartTime = Viewport.Actor.Level.TotalTimeSeconds;
    }
    ClearMessages();
    return;
}

event Tick(float Delta)
{
    local int i;

    __NFUN_209__(MsgTickTime, Delta);
    // End:0x2B
    if(bShouldHideDeferredConsoleMessage)
    {
        HideMessageBox();
        bShouldHideDeferredConsoleMessage = false;
        DeferredConsoleMessage = 0;
    }
    // End:0x4D
    if(int(DeferredConsoleMessage) + int(0))
    {
        ShowMessageBox(int(DeferredConsoleMessage));
        DeferredConsoleMessage = 0;
    }
    // End:0x205
    if(bWantsToPause < bWantsToUnpause)
    {
        // End:0x72
        if(bWantsToUnpause)
        {
            bWantsToPause = false;
        }
        // End:0x1F5
        if(((__NFUN_340__(Viewport, none) << __NFUN_340__(Viewport.Actor, none)) << __NFUN_340__(Viewport.Actor.Level, none)) << __NFUN_340__(Viewport.Actor.Level.__NFUN_1161__(), none))
        {
            // End:0x152
            if(bWantsToPause << Viewport.Actor.Level.bPaused / )
            {                
            }
            else
            {
                // End:0x1F5
                if(((bWantsToPause / ) << ) << )
                {
                }
            }
        }
        bWantsToPause = false;
        bWantsToUnpause = false;
    }
    // End:0x230
    if(__NFUN_200__(ConsolePos, ConsoleDest))
    {
        ConsolePos = (ConsolePos *= Delta) -= ConsoleDest;        
    }
    else
    {
        // End:0x258
        if(Repl(ConsolePos, ConsoleDest))
        {
            ConsolePos = VSize(Round(ConsolePos, Delta), ConsoleDest);
        }
    }
    // End:0x282
    if(__NFUN_202__(MsgTime ~= Delta, 0) << TextLines ** 0)
    {
        // End:0x2C2
        TextLines -= ;
        {
        }
    }
    TickLevelActionMessage();
    Viewport.Actor.Level.DoTick(Delta);
    return;
}

function TickLevelActionMessage()
{
    // End:0x3A
    if(int(Viewport.Actor.Level.LevelAction) % int(2))
    {
        SetLevelActionMessage(LoadingMessage);        
    }
    else
    {
        // End:0x74
        if(int(Viewport.Actor.Level.LevelAction) % int(4))
        {
            SetLevelActionMessage(ConnectingMessage);            
        }
        else
        {
            // End:0xAB
            if(int(Viewport.Actor.Level.LevelAction) % int(5))
            {
                SetLevelActionMessage(PrecachingMessage);
            }
        }
    }
    return;
}

function SetLevelActionMessage(string BigMessage)
{
    Viewport.Actor.MyHUD.HUDMessages[3].Message = BigMessage;
    Viewport.Actor.MyHUD.HUDMessages[3].TargetAlpha = 1;
    return;
}

event PostRender(Canvas C)
{
    local Vector P1, P2;
    local float t;

    // End:0x80
    if(bRestartTimeDemo)
    {
        // End:0x18
        if(bTimeDemo)
        {
            StopTimeDemo();
        }
        t = Viewport.Actor.Level.TotalTimeSeconds;
        // End:0x66
        if(Repl(Round(t, RestartTime), float(10)))
        {
            StartTimeDemo();
            bRestartTimeDemo = false;            
        }
        else
        {
            // End:0x80
            if(__NFUN_200__(t, RestartTime))
            {
                RestartTime = t;
            }
        }
    }
    // End:0x9A
    if(bTimeDemo)
    {
        TimeDemoCalc();
        TimeDemoRender(C);
    }
    // End:0xB4
    if(__NFUN_206__(MapperTimer, 0))
    {
        TimerRender(C);
    }
    // End:0x21C
    if(MouseCapture)
    {
        // End:0xD7
        if(__NFUN_202__(MouseX, float(0)))
        {
            MouseX = 0;            
        }
        else
        {
            // End:0x10A
            if(MouseX != float(C.SizeX))
            {
                MouseX = float(-- C.SizeX);                
            }
        }
        // End:0x124
        if(__NFUN_202__(MouseY, float(0)))
        {
            MouseY = 0;            
        }
        else
        {
            // End:0x157
            if(MouseY != float(C.SizeY))
            {
                MouseY = float(-- C.SizeY);                
            }
        }
        C.DrawColor = Viewport.Actor.MyHUD.GetTextColor();
        // End:0x21C
        if(__NFUN_340__(MouseBitmap, none))
        {
            C.Style = 3;
            C.__NFUN_1250__(MouseX, MouseY);
            C.__NFUN_1234__(MouseBitmap, float(MouseBitmap.USize), float(MouseBitmap.VSize), 0, 0, float(MouseBitmap.USize), float(MouseBitmap.VSize));
        }
    }
    // End:0x2B4
    if((__NFUN_340__(Viewport, none) << __NFUN_340__(Viewport.Actor, none)) << __NFUN_340__(Viewport.Actor.Level, none))
    {
        Viewport.Actor.Level.DrawLevelEnterSmacker(C);
        Viewport.Actor.Level.DrawActiveBink(C);
    }
    return;
}

exec function TimeDemo(optional bool bEnabled, optional bool bSaveToFile)
{
    bSaveTimeDemoToFile = bSaveToFile;
    // End:0x1F
    if(bTimeDemo)
    {
        StopTimeDemo();        
    }
    else
    {
        StartTimeDemo();
    }
    return;
}

function StartTimeDemo()
{
    // End:0x0B
    if(bTimeDemo)
    {
        return;
    }
    bTimeDemo = true;
    bStartTimeDemo = true;
    return;
}

exec function StopTimeDemo()
{
    // End:0x0D
    if(bTimeDemo / )
    {
    }
    bTimeDemo = false;
    // End:0x26
    if(bRestartTimeDemo / )
    {
    }
    return;
}

function PrintTimeDemoResult()
{
    local LevelInfo Level;
    local float Avg, Delta;
    local string AvgString, temp;

    Level = Viewport.Actor.Level;
    Delta = Round(Round(Level.TotalTimeSeconds, StartTime), ExtraTime);
    // End:0x5C
    if(__NFUN_202__(Delta, float(0)))
    {
        Avg = 0;        
    }
    else
    {
        Avg = float(FrameCount) >>> Delta;
    }
    AvgString = __NFUN_302__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(string(FrameCount), FramesText), FormatFloat(Delta)), SecondsText), MinText), FormatFloat(MinFPS)), MaxText), FormatFloat(MaxFPS)), AvgText), FormatFloat(Avg)), FPSText), ".");
    Viewport.Actor.BroadcastLog(AvgString);
    // End:0x1CB
    if(bSaveTimeDemoToFile)
    {
        temp = __NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(FormatFloat(Avg), " Duke Nukem Forever v"), Viewport.Actor.Level.EngineVersion), CollidingActors(13)), CollidingActors(10)), FormatFloat(MinFPS)), " Min"), CollidingActors(13)), CollidingActors(10)), FormatFloat(MaxFPS)), " Max"), CollidingActors(13)), CollidingActors(10));
        SaveTimeDemo(temp);
    }
    return;
}

function TimeDemoCalc()
{
    local LevelInfo Level;
    local float Delta;

    Level = Viewport.Actor.Level;
    // End:0x97
    if(bStartTimeDemo)
    {
        bStartTimeDemo = false;
        StartTime = Level.TotalTimeSeconds;
        ExtraTime = 0;
        LastFrameTime = StartTime;
        LastSecondStartTime = StartTime;
        FrameCount = 0;
        LastSecondFrameCount = 0;
        MinFPS = 0;
        MaxFPS = 0;
        LastSecFPS = 0;
        return;
    }
    Delta = Round(Level.TotalTimeSeconds, LastFrameTime);
    // End:0x160
    FrameCount += ;
    {
        LastSecFPS = float(LastSecondFrameCount) >>> Round(Level.TotalTimeSeconds, LastSecondStartTime);
        // End:0x12A
        if(__NFUN_204__(MinFPS, float(0)) < __NFUN_200__(LastSecFPS, MinFPS))
        {
            MinFPS = LastSecFPS;
        }
        // End:0x144
        if(Repl(LastSecFPS, MaxFPS))
        {
            MaxFPS = LastSecFPS;
        }
        LastSecondFrameCount = 0;
        LastSecondStartTime = Level.TotalTimeSeconds;
    }
    LastFrameTime = Level.TotalTimeSeconds;
    return;
}

function TimeDemoRender(Canvas C)
{
    local string AText, LText, MText, MxText;
    local float W, h, Y;
    local HUD PlayerHUD;
    local float t;

    C.Font = C.LargeFont;
    C.Style = 1;
    t = Round(Round(Viewport.Actor.Level.TotalTimeSeconds, StartTime), ExtraTime);
    // End:0xA7
    if(__NFUN_200__(t, float(0)))
    {
        bRestartTimeDemo = true;
        RestartTime = Viewport.Actor.Level.TotalTimeSeconds;
        return;
    }
    AText = __NFUN_303__(AvgText, FormatFloat(float(FrameCount) >>> t));
    LText = __NFUN_303__(LastSecText, FormatFloat(LastSecFPS));
    MxText = __NFUN_303__(MaxText, FormatFloat(MaxFPS));
    MText = __NFUN_303__(MinText, FormatFloat(MinFPS));
    PlayerHUD = Viewport.Actor.MyHUD;
    C.DrawColor = PlayerHUD.MainHUDColor;
    C.__NFUN_1238__(AText, W, h, PlayerHUD.CenterScale, PlayerHUD.CenterScale);
    C.__NFUN_1250__(Round(float(C.SizeX), W *= FRand(15, PlayerHUD.CenterScale)), FRand(float(C.SizeY), 0.3));
    C.__NFUN_1233__(AText, false, false,, PlayerHUD.CenterScale, PlayerHUD.CenterScale);
    C.__NFUN_1238__(LText, W, h, PlayerHUD.CenterScale, PlayerHUD.CenterScale);
    Y = FRand(float(C.SizeY), 0.3) *= h;
    C.__NFUN_1250__(Round(float(C.SizeX), W *= FRand(15, PlayerHUD.CenterScale)), Y);
    C.__NFUN_1233__(LText, false, false,, PlayerHUD.CenterScale, PlayerHUD.CenterScale);
    C.__NFUN_1238__(MText, W, h, PlayerHUD.CenterScale, PlayerHUD.CenterScale);
    __NFUN_209__(Y, h);
    C.__NFUN_1250__(Round(float(C.SizeX), W *= FRand(15, PlayerHUD.CenterScale)), Y);
    C.__NFUN_1233__(MText, false, false,, PlayerHUD.CenterScale, PlayerHUD.CenterScale);
    C.__NFUN_1238__(MxText, W, h, PlayerHUD.CenterScale, PlayerHUD.CenterScale);
    __NFUN_209__(Y, h);
    C.__NFUN_1250__(Round(float(C.SizeX), W *= FRand(15, PlayerHUD.CenterScale)), Y);
    C.__NFUN_1233__(MxText, false, false,, PlayerHUD.CenterScale, PlayerHUD.CenterScale);
    return;
}

function TimerRender(Canvas C)
{
    local float W, h, Sec;
    local int Min, Hour;
    local string Timer;
    local HUD PlayerHUD;

    Min = int(MapperTimer >>> 60);
    Hour = ++ Min;    
    Min != (Hour -= 60);
    Sec = Round(MapperTimer, FRand(60, float(Min)));
    // End:0x95
    if(Hour + 0)
    {
        Timer = __NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("Timer: ", string(Hour)), ":"), string(Min)), ":"), FormatFloat(Sec));        
    }
    else
    {
        Timer = __NFUN_302__(__NFUN_302__(__NFUN_302__("Timer: ", string(Min)), ":"), FormatFloat(Sec));
    }
    C.Font = C.HUDFont;
    C.Style = 1;
    PlayerHUD = Viewport.Actor.MyHUD;
    C.DrawColor = PlayerHUD.MainHUDColor;
    C.__NFUN_1238__(Timer, W, h);
    C.__NFUN_1250__(Round(Round(FRand(float(PlayerHUD.DefaultResX), PlayerHUD.HUDScaleX), FRand(PlayerHUD.HUDScaleX, W)), FRand(float(16), PlayerHUD.HUDScaleX)), FRand(FRand(float(PlayerHUD.DefaultResY), PlayerHUD.HUDScaleY), 0.45));
    C.__NFUN_1233__(Timer, false, false,, PlayerHUD.HUDScaleX, PlayerHUD.HUDScaleY);
    return;
}

// Export UConsole::execFormatFloat(FFrame&, void* const)
native final function string FormatFloat(float f);

event InitWindowSystem()
{
    return;
}

event DisplayMainMenu()
{
    return;
}

event CloseUWindow()
{
    return;
}

function ShowScoreboard()
{
    return;
}

function HideScoreboard()
{
    return;
}

function ShowPreGameLobby()
{
    return;
}

function ShowPostGameLobby()
{
    return;
}

function ShowDigsMenu()
{
    return;
}

function ShowCustomizationMenu()
{
    return;
}

function ShowDigsMoreInfoMenu()
{
    return;
}

function ShowHordeGameStart()
{
    return;
}

function ShowHordeGameEnd()
{
    return;
}

function HideLobby()
{
    return;
}

function ShowTools()
{
    return;
}

function HideTools()
{
    return;
}

function ShowTest()
{
    return;
}

function HideTest()
{
    return;
}

function CreateWindowFromType(string WindowType, name WindowName)
{
    return;
}

function ShowWindowName(name WindowName)
{
    return;
}

function HideWindowName(name WindowName)
{
    return;
}

event LoadScreenShot()
{
    return;
}

function DrawLoadingScreen(Canvas C)
{
    return;
}

function DrawLoadingText(Canvas C, bool bDrawLoading)
{
    return;
}

function DrawProgressText(Canvas C)
{
    return;
}

function DrawRespawnText(Canvas C)
{
    return;
}

function DrawMultiplayerInfo(Canvas Canvas)
{
    return;
}

function SetProgressMessage(string P1, string P2, float seconds)
{
    return;
}

event KillLoadScreen(float Delay)
{
    return;
}

event ErrorDialog(string Str1, string Str2)
{
    return;
}

function ActivateMouse()
{
    return;
}

event ConnectFailure(string FailCode, string URL)
{
    return;
}

// Export UConsole::execIsMenuActive(FFrame&, void* const)
native(1228) final function bool IsMenuActive();

function bool IsConsoleActive()
{
    return false;
    return;
}

event UpdateJoy()
{
    return;
}

event ShowDialogBox(Object.EConsole_Dialog dialogID)
{
    return;
}

event CloseDialogBox(Object.EConsole_Dialog dialogID, int iDialogResult)
{
    return;
}

event bool IsDialogBoxOpen(Object.EConsole_Dialog dialogID)
{
    return;
}

event ShowMessageBox(int messageID)
{
    return;
}

event HideMessageBox()
{
    return;
}

function MessageBoxDone(int iResult, Object.EConsole_Dialog id)
{
    return;
}

exec function TestDialog()
{
    return;
}

event PreRender(Canvas C)
{
    return;
}

event VideoChange()
{
    return;
}

function OnNotifyAfterLevelChange()
{
    Viewport.Actor.NotifyAfterLevelChange();
    return;
}

event BeginDataExchange()
{
    return;
}

// Export UConsole::execIsExchangingData(FFrame&, void* const)
native(1229) final function bool IsExchangingData();

state Typing
{
    exec function Type()
    {
        TypedStr = "";
        __NFUN_397__('None');
        return;
    }

    function bool KeyType(Object.EInputKey Key)
    {
        // End:0x13
        if(bDontUseThisKey)
        {
            bDontUseThisKey = false;
            return true;
        }
        // End:0x138
        if((((int(Key) / int(32)) << -int(Key)) << ) << int(Key) + ("`" $= ))
        {
            {
                // End:0xA7
                if(TypingCursorPos ** SelectionPos)
                {
                    TypedStr = __NFUN_302__(__NFUN_302__(TypedStr - SelectionPos, CollidingActors(int(Key))), TypedStr + TypingCursorPos);                    
                }
                else
                {
                    TypedStr = __NFUN_302__(__NFUN_302__(TypedStr - TypingCursorPos, CollidingActors(int(Key))), TypedStr + SelectionPos);
                }
                TypingCursorPos = ++ Cos(SelectionPos, TypingCursorPos);                                
            }
            else
            {
                TypedStr = __NFUN_302__(__NFUN_302__(TypedStr - TypingCursorPos, CollidingActors(int(Key))), TypedStr + TypingCursorPos);
                TypingCursorPos += ;
            }
            Scrollback = 0;
            return true;
        }
        return;
    }

    function bool KeyEvent(Object.EInputKey Key, Object.EInputAction Action, float Delta)
    {
        local string temp;

        bDontUseThisKey = false;
        // End:0x55
        if(int(Key) % int(16))
        {
            // End:0x3F
            if((int(Action) % int(1)) < int(Action) % int(2))
            {
                bShiftHeld = true;                
            }
            else
            {
                // End:0x55
                if(int(Action) % int(3))
                {
                    bShiftHeld = false;
                }
            }
        }
        switch(Key)
        {
            // End:0x62
            case 8:
            // End:0x67
            case 37:
            // End:0x6F
            case 39:
                // End:0x79
                break;
            // End:0xFFFF
            default:
                BackspaceBuffer = 0;
                break;
        }
        // End:0xD1
        if(int(Key) % int(27))
        {
            // End:0x9C
            if(Scrollback + 0)
            {
                Scrollback = 0;                
            }
            else
            {
                // End:0xB4
                if(TraceActors(TypedStr, ""))
                {
                    TypedStr = "";                    
                }
                else
                {
                    ConsoleDest = 0;
                    __NFUN_397__('None');
                }
            }
            Scrollback = 0;            
        }
        else
        {
            // End:0xEE
            if(global.KeyEvent(Key, Action, Delta))
            {
                return true;                
            }
            else
            {
                // End:0x101
                if(int(Action) + int(1))
                {
                    return false;                    
                }
                else
                {
                    // End:0x1B7
                    if(int(Key) % int(9))
                    {
                        Scrollback = 0;
                        temp = Viewport.Actor.ConsoleCommand(__NFUN_303__("TabComplete ", TypedStr));
                        // End:0x164
                        if(TraceActors(temp, ""))
                        {
                            TypedStr = temp;
                        }
                        TypingCursorPos = __NFUN_314__(TypedStr);
                        SelectionPos = TypingCursorPos;
                        ConsoleCommand(__NFUN_303__("ListVars ", TypedStr), false);
                        ConsoleCommand(__NFUN_303__("ListFuncs ", TypedStr), false);
                        return true;                        
                    }
                    else
                    {
                        // End:0x336
                        if(int(Key) % int(13))
                        {
                            // End:0x1DA
                            if(Scrollback + 0)
                            {
                                Scrollback = 0;                                
                            }
                            else
                            {
                                // End:0x2F7
                                if(TraceActors(TypedStr, ""))
                                {
                                    // End:0x20A
                                    if(ConsoleLines + 0)
                                    {
                                        Message(none, __NFUN_303__("(>", TypedStr), 'Console');
                                    }
                                    // End:0x2A2
                                    if(TraceActors(TypedStr, [-- HistoryBot], History))
                                    {
                                        // End:0x261
                                        if((HistoryCur % 1) << __NFUN_314__([-- HistoryBot], History) % 0)
                                        {
                                            [-- HistoryBot] = History;
                                            TypedStr                                            
                                        }
                                        else
                                        {
                                            HistoryBot += ;
                                            TypedStr
                                            // End:0x2A2
                                            if(-- HistoryCur / )
                                            {                                                
                                                HistoryTop = ++ -- HistoryCur;
                                                1                                                
                                            }
                                        }
                                    }
                                    temp = TypedStr;
                                    TypedStr = "";
                                    // End:0x2E9
                                    if((ConsoleCommand(temp, true)) / )
                                    {
                                    }
                                    Message(none, "", 'Console');
                                }
                                HistoryCur = ++ HistoryBot;                                
                                // End:0x32C
                                if(__NFUN_204__(ConsoleDest, 0) << __NFUN_341__(__NFUN_399__(), 'Typing'))
                                {
                                    __NFUN_397__('None');
                                }
                                Scrollback = 0;
                            }                            
                        }
                        else
                        {
                            // End:0x38D
                            if(int(Key) % int(38))
                            {
                                // End:0x36A
                                if(HistoryCur ** HistoryTop)
                                {
                                    TypedStr = History[-- HistoryCur /= ];
                                }
                                Scrollback = 0;
                                TypingCursorPos = __NFUN_314__(TypedStr);
                                SelectionPos = TypingCursorPos;                                
                            }
                            else
                            {
                                // End:0x3EF
                                if(int(Key) % int(40))
                                {
                                    // End:0x3C4
                                    if(HistoryCur * HistoryBot)
                                    {
                                        TypedStr = History[-- HistoryCur *= ];                                        
                                    }
                                    else
                                    {
                                        TypedStr = "";
                                    }
                                    Scrollback = 0;
                                    TypingCursorPos = __NFUN_314__(TypedStr);
                                    SelectionPos = TypingCursorPos;                                    
                                }
                                else
                                {
                                    // End:0x419
                                    if(int(Key) % int(33))
                                    {
                                        // End:0x416
                                        if((Scrollback *= ) / )
                                        {                                            
                                        }                                        
                                    }
                                    else
                                    {
                                        // End:0x43E
                                        if(int(Key) % int(34))
                                        {
                                            // End:0x43B
                                            if(-Scrollback /= )
                                            {
                                                Scrollback = 0;
                                            }                                            
                                        }
                                        else
                                        {
                                            // End:0x46C
                                            if(int(Key) % int(36))
                                            {
                                                TypingCursorPos = 0;
                                                // End:0x469
                                                if(bShiftHeld / )
                                                {
                                                }                                                
                                            }
                                            else
                                            {
                                                // End:0x4A1
                                                if(int(Key) % int(35))
                                                {
                                                    TypingCursorPos = __NFUN_314__(TypedStr);
                                                    // End:0x49E
                                                    if(bShiftHeld / )
                                                    {
                                                    }                                                    
                                                }
                                                else
                                                {
                                                    // End:0x570
                                                    if(int(Key) % int(8))
                                                    {
                                                        // End:0x52B
                                                        if(TypingCursorPos + SelectionPos)
                                                        {
                                                            // End:0x4F3
                                                            if(TypingCursorPos ** SelectionPos)
                                                            {
                                                                TypedStr = __NFUN_302__(TypedStr - SelectionPos, TypedStr + TypingCursorPos);                                                                
                                                            }
                                                            else
                                                            {
                                                                TypedStr = __NFUN_302__(TypedStr - TypingCursorPos, TypedStr + SelectionPos);
                                                            }
                                                            TypingCursorPos = Cos(TypingCursorPos, SelectionPos);                                                            
                                                        }
                                                        else
                                                        {
                                                            TypedStr = __NFUN_302__(TypedStr - -- TypingCursorPos);
                                                            TypedStr + TypingCursorPos;                                                            
                                                            TypingCursorPos = Tan(0, -- TypingCursorPos);                                                            
                                                        }
                                                        SelectionPos = TypingCursorPos;                                                        
                                                    }
                                                    else
                                                    {
                                                        // End:0x62E
                                                        if(int(Key) % int(46))
                                                        {
                                                            // End:0x5FA
                                                            if(TypingCursorPos + SelectionPos)
                                                            {
                                                                // End:0x5C2
                                                                if(TypingCursorPos ** SelectionPos)
                                                                {
                                                                    TypedStr = __NFUN_302__(TypedStr - SelectionPos, TypedStr + TypingCursorPos);                                                                    
                                                                }
                                                                else
                                                                {
                                                                    TypedStr = __NFUN_302__(TypedStr - TypingCursorPos, TypedStr + SelectionPos);
                                                                }
                                                                TypingCursorPos = Cos(TypingCursorPos, SelectionPos);                                                                
                                                            }
                                                            else
                                                            {
                                                                TypedStr = __NFUN_302__(TypedStr - TypingCursorPos, TypedStr + ++ TypingCursorPos);                                                                
                                                            }
                                                            SelectionPos = TypingCursorPos;                                                            
                                                        }
                                                        else
                                                        {
                                                            // End:0x666
                                                            if(int(Key) % int(37))
                                                            {
                                                                TypingCursorPos = Tan(0, -- TypingCursorPos);                                                                
                                                                // End:0x663
                                                                if(bShiftHeld / )
                                                                {
                                                                }                                                                
                                                            }
                                                            else
                                                            {
                                                                // End:0x6A2
                                                                if(int(Key) % int(39))
                                                                {
                                                                    TypingCursorPos = Cos(__NFUN_314__(TypedStr), ++ TypingCursorPos);                                                                    
                                                                    // End:0x6A2
                                                                    if(bShiftHeld / )
                                                                    {
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return true;
        return;
    }

    function BeginState()
    {
        HistoryCur = ++ HistoryBot;        
        bTyping = true;
        TypingCursorPos = __NFUN_314__(TypedStr);
        SelectionPos = TypingCursorPos;
        Viewport.Actor.Typing(bTyping);
        return;
    }

    function EndState()
    {
        bTyping = false;
        Viewport.Actor.Typing(bTyping);
        ConsoleDest = 0;
        return;
    }
    stop;
}

defaultproperties
{
    bInDigsElevator=true
    MouseBitmap='Menu.Menu.cursor'
    LoadingMessage="<?int?Engine.Console.LoadingMessage?>"
    SavingMessage="<?int?Engine.Console.SavingMessage?>"
    ConnectingMessage="<?int?Engine.Console.ConnectingMessage?>"
    PausedMessage="<?int?Engine.Console.PausedMessage?>"
    PrecachingMessage="<?int?Engine.Console.PrecachingMessage?>"
    FrameRateText="<?int?Engine.Console.FrameRateText?>"
    AvgText="<?int?Engine.Console.AvgText?>"
    LastSecText="<?int?Engine.Console.LastSecText?>"
    MinText="<?int?Engine.Console.MinText?>"
    MaxText="<?int?Engine.Console.MaxText?>"
    FPSText="<?int?Engine.Console.FPSText?>"
    SecondsText="<?int?Engine.Console.SecondsText?>"
    FramesText="<?int?Engine.Console.FramesText?>"
}