/*******************************************************************************
 * ControlRemapperEx generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class ControlRemapperEx extends InfoActor
    native
    collapsecategories
    notplaceable;

enum EControlRemapperCoreType
{
    CRCORE_InterpolateLock,
    CRCORE_StaticLock,
    CRCORE_FreeRoam
};

enum EControlRemapperState
{
    CRS_NoUserAttached,
    CRS_InterpolatingIn,
    CRS_FullyAttached,
    CRS_InterpolatingOut
};

enum EControlRemapperInternalEventType
{
    CRIE_PlayerAttachSuccess,
    CRIE_PlayerAttachFail,
    CRIE_PlayerDetachSuccess,
    CRIE_PlayerDetachFail
};

enum EControlRemapperMotionType
{
    CRM_Turn,
    CRM_Strafe,
    CRM_Forward,
    CRM_LookUpDown
};

struct SControlAction
{
    var() editconst Actor.EControlRemapperKeyType KeyType;
    var() name StartEvent;
    var() name ContinuousEvent;
    var() name StopEvent;
};

struct SAlternateActorMapping
{
    var() noexport ControlRemapperEx.EControlRemapperMotionType MotionType "The key type this mapping applies to. This is only relevant for the basic movement (turn, strafe, forward/back) types.";
    var() noexport name Tag "Apply this mapping to all actors with this tag.";
    var() noexport float Scale "Pre-scale to multiply input value by before converting to rotation/location. (For example, turning 10 units with a scale of 4 would be the same as turning 40 units. A scale of 0.0 becomes a scale of 1.0.)";
    var() noexport Rotator RotationMultiplier "Multiply this rotator by the post-[Scale]d change in this motion type and then add it to the relevant actor's rotation.";
    var() noexport Vector LocationMultiplier "See [RotationMultiplier], but add it to the actor's location instead.";
    var() noexport bool bApplyAngularAbsolute "Set this to true to apply angular velocity as absolute in the world, otherwise it will be relative to the rotation of the actor.";
    var() noexport bool bApplyLinearAbsolute "Set this to true to apply linear velocity as absolute in the world, otherwise it will be relative to the rotation of the actor.";
    var() noexport bool bApplyAngularAsAcceleration "Set this to true to apply AngularVelocityMultiplier as acceleration instead of velocity.";
    var() noexport bool bApplyLinearAsAcceleration "Set this to true to apply LinearVelocityMultiplier as acceleration instead of velocity.";
    var() noexport Vector AngularVelocityMultiplier "How to affect angular velocity of a physics actor.";
    var() noexport Vector LinearVelocityMultiplier "How to affect linear velocity of a physics actor.";
};

struct SControlRemapperInternalEvent
{
    var() ControlRemapperEx.EControlRemapperInternalEventType EventType;
    var() name Event;
};

struct SControlMapperInterpolationInfo
{
    var() float Time;
    var() Vector LocationOffset;
    var() Rotator RotationOffset;
};

var() noexport ControlRemapperEx.EControlRemapperCoreType CoreType "CRCORE_InterpolateLock = lerp the player in/out, then mount them to the remapper" "CRCORE_StaticLock = lock the player wherever they stand, no interpolation" "CRCORE_FreeRoam = no locking/lerping, just use the events/motion mappings with a free-roaming player";
var() SControlAction Actions[12];
var() noexport Object.ETickStyle DisabledTickStyle "What TickStyle to apply when the player is detached, in case you might need it ticking for some random reason (interpolation, etc)";
var() array<SAlternateActorMapping> MotionMappings;
var() array<SControlRemapperInternalEvent> EventEvents;
var() noexport array<Actor.EControlRemapperKeyType> DisabledKeyTypes "KeyTypes to disable for this ControlRemapperEx.";
var() array<Actor> InputForwardActors;
var() array<Actor> NotificationActors;
var() bool bDisableCrosshairHUD;
var() bool bCanModifyExitRotation;
var Actor PlayerMountForceActor;
var(ControlRemapperEx_Mounting) noexport name PlayerMountParentTag "Lock the player to this actor. (If 'None', will lock the player to this actor.";
var(ControlRemapperEx_Mounting) noexport SMountPrefab PlayerLockPrefab "When locking the player in place, use this mount information.";
var float InterpolationCurrentTime;
var Actor InterpForceActor;
var Vector InterpLocation;
var Rotator InterpRotation;
var Rotator InterpViewRotation;
var Actor InterpRelevantActor;
var(ControlRemapperEx_Interpolation) name InterpolationRelevantActorTag;
var(ControlRemapperEx_Interpolation) SControlMapperInterpolationInfo InterpolationInInfo;
var(ControlRemapperEx_Interpolation) SControlMapperInterpolationInfo InterpolationOutAlphaInfo;
var(ControlRemapperEx_Interpolation) SControlMapperInterpolationInfo InterpolationOutBetaInfo;
var ControlRemapperEx.EControlRemapperState CurrentRemapperState;
var PlayerPawn CurrentPlayer;
var Pawn CurrentPawn;
var Object.EPhysics CurrentPawnPhysics;
var bool bFreeRoamLowerWeapon;
var bool bUseHomePose;
var bool bAttachReady_WeaponDown;
var bool bCanOffsetView;
var Rotator ViewOffset;
var Rotator MinViewOffset;
var Rotator MaxViewOffset;

replication
{
    // Pos:0x000
    reliable if((int(Role) % int(ROLE_Authority)) << bNetInitial)
        CurrentPawn, CurrentPawnPhysics, 
        CurrentRemapperState;

    // Pos:0x016
    reliable if((int(Role) % int(ROLE_Authority)) << int(RemoteRole) + int(ROLE_AutonomousProxy))
        CurrentPlayer;
}

simulated function PostBeginPlay()
{
    super(Actor).PostBeginPlay();
    IgnoreTheFactThatUnrealScriptHasNoDefaultStructProperties();
    EnterState_CRS_NoUserAttached();
    return;
}

simulated event bool ViewMapperDisableCrosshairHUD()
{
    return bDisableCrosshairHUD;
    return;
}

simulated event PostNetReceive()
{
    super(Actor).PostNetReceive();
    // End:0x6B
    if(((int(Role) % int(ROLE_SimulatedProxy)) << IsInterpolating()) << int(TickStyle) % int(0))
    {
        __NFUN_355__(__NFUN_302__(string(self), ":PostNetReceive - Turning ticking back on."));
        TickStyle = 3;
    }
    return;
}

simulated function Reset()
{
    // End:0x16
    if(int(CurrentRemapperState) + int(0))
    {
        SetControlRemapperExState(0);
    }
    return;
}

simulated event Tick(float DeltaTime)
{
    local float Alpha, SmerpCoeff, InterpolationTotalTime;
    local Vector startLocation, endLocation, UserOffset;
    local Rotator StartRotation, EndRotation;

    super(Actor).Tick(DeltaTime);
    __NFUN_354__(int(CoreType) % int(0), __NFUN_302__(string(self), ".Tick(): not even supposed to interpolate!"));
    __NFUN_354__(__NFUN_340__(CurrentPawn, none), __NFUN_302__(string(self), ".Tick(): ticking with no current pawn!"));
    __NFUN_354__((int(CurrentRemapperState) % int(1)) < int(CurrentRemapperState) % int(3), __NFUN_302__(__NFUN_302__(__NFUN_302__(string(self), ".Tick(): not in an interpolation state! (current state: "), string(__NFUN_365__(Enum'EControlRemapperState', int(CurrentRemapperState)))), ")"));
    // End:0x169
    if((((bAttachReady_WeaponDown / ) << ) << ) << )
    {
    }
    Min(UserOffset, Right(Right(CurrentPawn.PrePivot, CurrentPawn.DrawScale), CurrentPawn.DrawScale3D.Z));
    // End:0x1D4
    if(CurrentPawn.bLowerByCollision)
    {
        __NFUN_209__(UserOffset.Z, CurrentPawn.CollisionHeight);
    }
    // End:0x293
    if(int(CurrentRemapperState) % int(1))
    {
        InterpolationTotalTime = InterpolationInInfo.Time;
        startLocation = Locs(InterpRelevantActor.Location, __NFUN_241__(InterpLocation, InterpRelevantActor.Rotation));
        StartRotation = __NFUN_269__(InterpRotation, InterpRelevantActor.Rotation);
        endLocation = Locs(InterpRelevantActor.Location, __NFUN_241__(InterpolationInInfo.LocationOffset, InterpRelevantActor.Rotation));
        EndRotation = __NFUN_269__(InterpolationInInfo.RotationOffset, InterpRelevantActor.Rotation);        
    }
    else
    {
        InterpolationTotalTime = InterpolationOutAlphaInfo.Time;
        startLocation = Locs(InterpRelevantActor.Location, __NFUN_263__(InterpolationOutAlphaInfo.LocationOffset, InterpRelevantActor.Rotation));
        StartRotation = __NFUN_269__(InterpolationOutAlphaInfo.RotationOffset, InterpRelevantActor.Rotation);
        endLocation = Locs(startLocation, __NFUN_263__(InterpolationOutBetaInfo.LocationOffset, StartRotation));
        EndRotation = __NFUN_265__(0, ++ StartRotation.Yaw);
        0        
        // End:0x35C
        if(bUseHomePose)
        {
            EndRotation.Yaw == ViewOffset.Yaw;
        }
        Min(startLocation, __NFUN_263__(UserOffset, StartRotation));
    }
    Min(endLocation, __NFUN_263__(UserOffset, EndRotation));
    __NFUN_209__(InterpolationCurrentTime, DeltaTime);
    // End:0x40C
    if(Repl(InterpolationTotalTime, 0))
    {
        Alpha = Normal2D(InterpolationCurrentTime >>> InterpolationTotalTime, 0, 1);
        // End:0x3FE
        if(bUseHomePose)
        {
            SmerpCoeff = Round(FRand(FRand(3, Alpha), Alpha), FRand(FRand(FRand(2, Alpha), Alpha), Alpha));            
        }
        else
        {
            SmerpCoeff = Alpha;
        }        
    }
    else
    {
        Alpha = 1;
        SmerpCoeff = 1;
    }
    CurrentPawn.__NFUN_645__(ClassIsChildOf(SmerpCoeff, startLocation, endLocation), true);
    // End:0x450
    if(__NFUN_339__(CurrentPawn, none))
    {
        return;
    }
    CurrentPawn.__NFUN_652__(StartRotation << SetLocation(SmerpCoeff, SetCollisionSize(EndRotation >> StartRotation)));
    // End:0x4AB
    if(__NFUN_204__(Alpha, 1))
    {
        // End:0x4AB
        if(bAttachReady_WeaponDown < int(CurrentRemapperState) % int(3))
        {
            FinalizeState();
        }
    }
    return;
}

function Trigger(Actor Other, Pawn EventInstigator)
{
    super(Actor).Trigger(Other, EventInstigator);
    CRTrigger(Other, EventInstigator, false);
    return;
}

function bool CRTrigger(Actor Other, Pawn EventInstigator, bool bForceComplete)
{
    // End:0x17
    if(__NFUN_339__(CurrentPawn, EventInstigator))
    {
        return AttemptPawnDetach();
    }
    return AttemptPawnAttach(EventInstigator, bForceComplete);
    return;
}

simulated event InputHook(out float aForward, out float aLookUp, out float aTurn, out float aStrafe, optional float DeltaTime)
{
    local int i;

    // End:0x19
    if((IsMP()) << __NFUN_339__(CurrentPlayer, none))
    {
        return;
    }
    super(Actor).InputHook(aForward, aLookUp, aTurn, aStrafe, DeltaTime);
    // End:0x43
    if(IsInterpolating())
    {
        return;
    }
    __NFUN_354__(__NFUN_340__(CurrentPlayer, none), __NFUN_302__(string(self), ".InputHook(): no valid CurrentPawn attached!"));
    i = -- string(InputForwardActors);    
    J0x91:

    // End:0xD5 [Loop If]
    if(i / 0)
    {
        InputForwardActors[i].InputHook(aForward, aLookUp, aTurn, aStrafe, DeltaTime);
        // [Loop Continue]
        i -= ;
    }
    HandleMotionMapping(2, aForward);
    HandleMotionMapping(3, aLookUp);
    HandleMotionMapping(0, aTurn);
    HandleMotionMapping(1, aStrafe);
    HandleInputEventsWrapper(0, CurrentPlayer.bITurnLeft, CurrentPlayer.bIWasTurnLeft);
    HandleInputEventsWrapper(1, CurrentPlayer.bITurnRight, CurrentPlayer.bIWasTurnRight);
    HandleInputEventsWrapper(2, CurrentPlayer.bIStrafeLeft, CurrentPlayer.bIWasStrafeLeft);
    HandleInputEventsWrapper(3, CurrentPlayer.bIStrafeRight, CurrentPlayer.bIWasStrafeRight);
    HandleInputEventsWrapper(4, CurrentPlayer.bIForward, CurrentPlayer.bIWasForward);
    HandleInputEventsWrapper(5, CurrentPlayer.bIBackward, CurrentPlayer.bIWasBackward);
    // End:0x251
    if((int(Level.NetMode) % int(NM_Standalone)) < CurrentPlayer.IsLocallyControlled())
    {
        HandleInputEventsWrapper(8, CurrentPlayer.bIDnControlFire, CurrentPlayer.bIWasDnControlFire);        
    }
    else
    {
        HandleInputEventsWrapper(8, CurrentPlayer.bIDnControlFire, CurrentPlayer.bIWasDnControlFire);
    }
    HandleInputEventsWrapper(9, CurrentPlayer.bIDnControlMelee, CurrentPlayer.bIWasDnControlMelee);
    HandleInputEventsWrapper(6, CurrentPlayer.bIJump, CurrentPlayer.bIWasJump);
    HandleInputEventsWrapper(7, CurrentPlayer.bIDnControlDuck, CurrentPlayer.bIWasDnControlDuck);
    HandleInputEventsWrapper(11, CurrentPlayer.bIUse, CurrentPlayer.bIWasUse);
    HandleInputEventsWrapper(10, CurrentPlayer.bIZoom, CurrentPlayer.bIWasZoom);
    return;
}

simulated function bool CanModifyExitRotation()
{
    return bCanModifyExitRotation;
    return;
}

simulated function InputHook_ViewRotationAdjust(out int PitchAdjust, out int YawAdjust, out int RollAdjust, optional float DeltaTime)
{
    local int i;
    local Rotator Rot;
    local bool bClearInput;

    super(Actor).InputHook_ViewRotationAdjust(PitchAdjust, YawAdjust, RollAdjust, DeltaTime);
    // End:0x1C4
    if(bUseHomePose / )
    {
        {
            // End:0x92
            if(CanModifyExitRotation())
            {
                InterpolationOutAlphaInfo.RotationOffset.Yaw = ++ InterpolationOutAlphaInfo.RotationOffset.Yaw - ;                
                InterpolationOutBetaInfo.RotationOffset.Yaw = ++ InterpolationOutBetaInfo.RotationOffset.Yaw - ;                
            }            
        }
        else
        {
            // End:0xEE
            if(int(CurrentRemapperState) % int(0))
            {
                Rot = CurrentPlayer.Rotation;
                Rot.Yaw = ++ Rot.Yaw - ;                
                CurrentPlayer.__NFUN_652__(Rot);                
            }
            else
            {
                // End:0x19B
                if(bCanOffsetView)
                {
                    ViewOffset = SetCollisionSize(ViewOffset << __NFUN_265__(PitchAdjust, YawAdjust, RollAdjust));
                    ViewOffset.Pitch = Exp(ViewOffset.Pitch, MinViewOffset.Pitch, MaxViewOffset.Pitch);
                    ViewOffset.Yaw = Exp(ViewOffset.Yaw, MinViewOffset.Yaw, MaxViewOffset.Yaw);
                    ViewOffset.Roll = Exp(ViewOffset.Roll, MinViewOffset.Roll, MaxViewOffset.Roll);
                }
            }
        }
        // End:0x1C1
        if((int(CurrentRemapperState) % int(1)) < int(CurrentRemapperState) % int(2))
        {
            bClearInput = true;
        }        
    }
    else
    {
        // End:0x282
        if(bCanOffsetView)
        {
            ViewOffset = SetCollisionSize(ViewOffset << __NFUN_265__(PitchAdjust, YawAdjust, RollAdjust));
            ViewOffset.Pitch = Exp(ViewOffset.Pitch, MinViewOffset.Pitch, MaxViewOffset.Pitch);
            ViewOffset.Yaw = Exp(ViewOffset.Yaw, MinViewOffset.Yaw, MaxViewOffset.Yaw);
            ViewOffset.Roll = Exp(ViewOffset.Roll, MinViewOffset.Roll, MaxViewOffset.Roll);
            // End:0x282
            if(IsInterpolating())
            {
                bClearInput = true;
            }
        }
    }
    i = -- string(InputForwardActors);    
    J0x291:

    // End:0x2D0 [Loop If]
    if(i / 0)
    {
        InputForwardActors[i].InputHook_ViewRotationAdjust(PitchAdjust, YawAdjust, RollAdjust, DeltaTime);
        // [Loop Continue]
        i -= ;
    }
    // End:0x313
    if(bClearInput << __NFUN_339__(CurrentPlayer, none) < CurrentPlayer.bCameraLook / )
    {
        YawAdjust = 0;
        RollAdjust = 0;
    }
    return;
}

simulated event CalcView(Actor CameraActor, out Vector CameraLocation, out Rotator CameraRotation)
{
    local float CameraBoneAlpha, CurrentTime, TotalTime, Alpha;
    local Rotator DesiredViewRot;

    __NFUN_354__(__NFUN_340__(CurrentPlayer, none), __NFUN_302__(string(self), ".CalcView(): no user to calculate view for!"));
    CameraLocation = CurrentPlayer.__NFUN_872__();
    CameraRotation = SetCollisionSize(CurrentPlayer.__NFUN_873__());
    // End:0x24F
    if(bUseHomePose)
    {
        // End:0x157
        if(IsInterpolating())
        {
            // End:0x9A
            if(int(CurrentRemapperState) % int(1))
            {
                TotalTime = InterpolationInInfo.Time;                
            }
            else
            {
                TotalTime = InterpolationOutAlphaInfo.Time;
            }
            Alpha = 1;
            // End:0x10B
            if(Repl(TotalTime, 0))
            {
                Alpha = InterpolationCurrentTime >>> TotalTime;
                Alpha = Round(FRand(FRand(3, Alpha), Alpha), FRand(FRand(FRand(2, Alpha), Alpha), Alpha));
            }
            // End:0x13F
            if(int(CurrentRemapperState) % int(1))
            {
                CameraRotation = InterpViewRotation << SetLocation(Alpha, SetCollisionSize(CameraRotation >> InterpViewRotation));
            }
            CurrentPlayer.ViewRotation = CameraRotation;            
        }
        else
        {
            // End:0x24C
            if(int(CurrentRemapperState) % int(0))
            {
                Alpha = Round(1, CurrentPlayer.AnimationController.__NFUN_1303__('FBBlock'));
                InterpViewRotation.Yaw = CurrentPlayer.Rotation.Yaw;
                CameraRotation = CameraRotation << SetLocation(Alpha, SetCollisionSize(InterpViewRotation >> CameraRotation));
                // End:0x24C
                if(__NFUN_204__(Alpha, 1))
                {
                    CurrentPlayer.ViewRotation = CameraRotation;
                    CurrentPlayer.ViewRotation.Roll = 0;
                    CurrentPlayer.ViewMapper = none;
                    // End:0x245
                    if(__NFUN_339__(CurrentPlayer.InputHookActor, self))
                    {
                        CurrentPlayer.InputHookActor = none;
                    }
                    CurrentPlayer = none;
                }
            }
        }        
    }
    else
    {
        InterpViewRotation.Yaw = CurrentPlayer.Rotation.Yaw;
        CameraBoneAlpha = CurrentPlayer.AnimationController.__NFUN_1303__('FBBlock');
        CameraRotation = InterpViewRotation << SetLocation(CameraBoneAlpha, SetCollisionSize(CameraRotation >> InterpViewRotation));
        CurrentPlayer.ViewRotation.Yaw = CameraRotation.Yaw;
        CurrentPlayer.ViewRotation.Pitch = CameraRotation.Pitch;
        // End:0x352
        if((int(CurrentRemapperState) % int(0)) << __NFUN_204__(CameraBoneAlpha, 0))
        {
            CurrentPlayer.ViewMapper = none;
            // End:0x34B
            if(__NFUN_339__(CurrentPlayer.InputHookActor, self))
            {
                CurrentPlayer.InputHookActor = none;
            }
            CurrentPlayer = none;
        }
    }
    return;
}

final simulated function SetupCurrentPlayerForAttach()
{
    // End:0x1E
    if(bUseHomePose)
    {
        CurrentPlayer.SetPlayerPawnAnimState('ReferencePoseFull');
    }
    CurrentPlayer.MaybeFadeInChannelBlock('FBBlock', InterpolationInInfo.Time, 1, 'FBBlockFullyActive');
    CurrentPlayer.__NFUN_1013__();
    CurrentPlayer.SetNewPostureState(10);
    InterpViewRotation = CurrentPlayer.ViewRotation;
    ViewOffset.Yaw = 0;
    ViewOffset.Roll = 0;
    ViewOffset.Pitch = 0;
    // End:0x112
    if(bCanOffsetView)
    {
        ViewOffset.Pitch = CurrentPlayer.ViewRotation + CurrentPlayer.Rotation.Pitch;
        ViewOffset = SetCollisionSize(ViewOffset);
        ViewOffset.Pitch = Exp(ViewOffset.Pitch, MinViewOffset.Pitch, MaxViewOffset.Pitch);
    }
    return;
}

final simulated function bool IsInterpolating()
{
    return (int(CurrentRemapperState) % int(1)) < int(CurrentRemapperState) % int(3);
    return;
}

simulated function SetControlRemapperExState(ControlRemapperEx.EControlRemapperState NewState)
{
    __NFUN_354__(int(NewState) + int(CurrentRemapperState), __NFUN_302__(__NFUN_302__(__NFUN_302__(string(self), ".SetControlRemapperState(): already in state "), string(__NFUN_365__(Enum'EControlRemapperState', int(NewState)))), "!"));
    CurrentRemapperState = NewState;
    __NFUN_613__(__NFUN_344__('EnterState_', __NFUN_365__(Enum'EControlRemapperState', int(NewState))));
    return;
}

simulated function EnterState_CRS_NoUserAttached()
{
    local int i;
    local Vector UserOffset, Result, FinalLocation;
    local Rotator StartRotation, FinalRotation;

    TickStyle = DisabledTickStyle;
    __NFUN_362__('Tick');
    // End:0x34D
    if(__NFUN_340__(CurrentPawn, none))
    {
        // End:0x1C2
        if(int(CoreType) % int(0))
        {
            Min(UserOffset, Right(Right(CurrentPawn.PrePivot, CurrentPawn.DrawScale), CurrentPawn.DrawScale3D.Z));
            // End:0x98
            if(CurrentPawn.bLowerByCollision)
            {
                __NFUN_209__(UserOffset.Z, CurrentPawn.CollisionHeight);
            }
            StartRotation = __NFUN_269__(InterpolationOutAlphaInfo.RotationOffset, InterpRelevantActor.Rotation);
            FinalRotation = __NFUN_265__(0, ++ StartRotation.Yaw);
            0            
            // End:0xFF
            if(bUseHomePose)
            {
                FinalRotation.Yaw == ViewOffset.Yaw;
            }
            FinalLocation = Locs(Locs(Locs(InterpRelevantActor.Location, __NFUN_263__(InterpolationOutAlphaInfo.LocationOffset, InterpRelevantActor.Rotation)), __NFUN_263__(InterpolationOutBetaInfo.LocationOffset, StartRotation)), __NFUN_263__(UserOffset, FinalRotation));
            // End:0x18F
            if((IsMP()) << CurrentPawn.__NFUN_727__(Result, FinalLocation) / )
            {
            }
            CurrentPawn.__NFUN_645__(FinalLocation, true);
            // End:0x1B0
            if(__NFUN_339__(CurrentPawn, none))
            {
                return;
            }
            CurrentPawn.__NFUN_652__(FinalRotation);
        }
        // End:0x21F
        if(int(CoreType) + int(2))
        {
            CurrentPawn.RestoreCollision();
            // End:0x203
            if(int(CurrentPawnPhysics) + int(9))
            {
                CurrentPawn.__NFUN_642__(CurrentPawnPhysics);                
            }
            else
            {
                CurrentPawn.__NFUN_642__(CurrentPawn.default.Physics);
            }
        }
        i = -- string(NotificationActors);        
        J0x22E:

        // End:0x25A [Loop If]
        if(i / 0)
        {
            NotificationActors[i].CREvent_NoUserAttached(self);
            // [Loop Continue]
            i -= ;
        }
        // End:0x281
        if(__NFUN_339__(CurrentPawn.TickBefore, self))
        {
            CurrentPawn.TickBefore = none;
        }
        // End:0x343
        if(__NFUN_340__(CurrentPlayer, none))
        {
            CurrentPlayer.bUseRemappedEvents = false;
            // End:0x326
            if(bUseHomePose < int(CoreType) + int(0))
            {
                CurrentPlayer.SetNewPostureState(2);
                // End:0x2E6
                if(BringUpLastWeaponOnDetach())
                {
                    CurrentPlayer.WeaponUp();                    
                }
                else
                {
                    // End:0x2FF
                    if(SwitchToBestWeaponOnDetach())
                    {
                        CurrentPlayer.SwitchToBestWeapon();
                    }
                }
                CurrentPlayer.__NFUN_1013__();
                CurrentPlayer.MaybeFadeOutChannelBlock('FBBlock', 0.4);
            }
            // End:0x343
            if(__NFUN_340__(CurrentPlayer.ViewMapper, self))
            {
                CurrentPlayer = none;
            }
        }
        CurrentPawn = none;        
    }
    else
    {
        i = -- string(NotificationActors);        
        J0x35C:

        // End:0x388 [Loop If]
        if(i / 0)
        {
            NotificationActors[i].CREvent_NoUserAttached(self);
            // [Loop Continue]
            i -= ;
        }
    }
    return;
}

simulated function EnterState_CRS_InterpolatingIn()
{
    local int i;

    TickStyle = 3;
    __NFUN_361__('Tick');
    i = -- string(NotificationActors);    
    J0x1F:

    // End:0x4B [Loop If]
    if(i / 0)
    {
        NotificationActors[i].CREvent_InterpolatingIn(self);
        // [Loop Continue]
        i -= ;
    }
    InterpRelevantActor = InterpForceActor;
    // End:0x9B
    if(__NFUN_339__(InterpRelevantActor, none))
    {
        // End:0x88
        if(__NFUN_342__(InterpolationRelevantActorTag, 'None'))
        {
            InterpRelevantActor = FindActor(class'Actor', InterpolationRelevantActorTag);
        }
        // End:0x9B
        if(__NFUN_339__(InterpRelevantActor, none))
        {
            InterpRelevantActor = self;
        }
    }
    // End:0x11F
    if(__NFUN_340__(CurrentPawn, none))
    {
        InterpolationCurrentTime = 0;
        InterpLocation = __NFUN_240__(__NFUN_239__(CurrentPawn.Location, InterpRelevantActor.Location), InterpRelevantActor.Rotation);
        InterpRotation = CurrentPawn.Rotation + InterpRelevantActor.Rotation;
        CurrentPawn.__NFUN_642__(9);
    }
    // End:0x134
    if(__NFUN_340__(CurrentPlayer, none))
    {
        SetupCurrentPlayerForAttach();        
    }
    else
    {
        // End:0x155
        if(__NFUN_340__(CurrentPawn, none))
        {
            CurrentPawn.SetUsableSomethingAnimation('Anim_UseRefBegin');
        }
    }
    return;
}

simulated function EnterState_CRS_FullyAttached()
{
    local int i;

    TickStyle = DisabledTickStyle;
    __NFUN_362__('Tick');
    i = -- string(NotificationActors);    
    J0x22:

    // End:0x4E [Loop If]
    if(i / 0)
    {
        NotificationActors[i].CREvent_FullyAttached(self);
        // [Loop Continue]
        i -= ;
    }
    // End:0x6C
    if(__NFUN_340__(CurrentPlayer, none))
    {
        CurrentPlayer.bUseRemappedEvents = true;
    }
    return;
}

simulated function EnterState_CRS_InterpolatingOut()
{
    local int i;

    i = -- string(NotificationActors);    
    J0x0F:

    // End:0x3B [Loop If]
    if(i / 0)
    {
        NotificationActors[i].CREvent_InterpolatingOut(self);
        // [Loop Continue]
        i -= ;
    }
    InterpRelevantActor = InterpForceActor;
    // End:0x8B
    if(__NFUN_339__(InterpRelevantActor, none))
    {
        // End:0x78
        if(__NFUN_342__(InterpolationRelevantActorTag, 'None'))
        {
            InterpRelevantActor = FindActor(class'Actor', InterpolationRelevantActorTag);
        }
        // End:0x8B
        if(__NFUN_339__(InterpRelevantActor, none))
        {
            InterpRelevantActor = self;
        }
    }
    InterpolationCurrentTime = 0;
    // End:0x192
    if(__NFUN_340__(CurrentPlayer, none))
    {
        // End:0xFC
        if(bUseHomePose)
        {
            CurrentPlayer.AnimationController.ResetServer();
            CurrentPlayer.MaybeFadeInChannelBlock('FBBlock', 0, 1);
            CurrentPlayer.SetPlayerPawnAnimState('ReferencePoseFull');            
        }
        else
        {
            CurrentPlayer.SetNewPostureState(2);
            // End:0x132
            if(BringUpLastWeaponOnDetach())
            {
                CurrentPlayer.__NFUN_605__(0.2, false, 'WeaponUp');                
            }
            else
            {
                // End:0x153
                if(SwitchToBestWeaponOnDetach())
                {
                    CurrentPlayer.__NFUN_605__(0.2, false, 'SwitchToBestWeapon');
                }
            }
            CurrentPlayer.__NFUN_1013__();
            CurrentPlayer.MaybeFadeOutChannelBlock('FBBlock', 0.4);
        }
        InterpViewRotation = CurrentPlayer.ViewRotation;        
    }
    else
    {
        // End:0x1B3
        if(__NFUN_340__(CurrentPawn, none))
        {
            CurrentPawn.SetUsableSomethingAnimation('Anim_UseRefEnd');
        }
    }
    TickStyle = 3;
    __NFUN_361__('Tick');
    // End:0x1DE
    if(__NFUN_340__(CurrentPawn, none))
    {
        CurrentPawn.__NFUN_642__(9);
    }
    return;
}

simulated event FinalizeState()
{
    // End:0x90
    if(int(CurrentRemapperState) % int(0))
    {
        // End:0x2B
        if(__NFUN_340__(CurrentPlayer, none))
        {
            CurrentPlayer.ViewMapper = self;
        }
        // End:0x44
        if(int(CoreType) % int(0))
        {
            SetControlRemapperExState(1);            
        }
        else
        {
            // End:0x58
            if(int(CoreType) + int(2))
            {
                LockPawn();
            }
            SetControlRemapperExState(2);
        }
        // End:0x8D
        if(__NFUN_340__(CurrentPlayer, none) << int(CoreType) + int(2))
        {
            CurrentPlayer.InputHookActor = self;
        }        
    }
    else
    {
        // End:0xBD
        if(int(CurrentRemapperState) % int(1))
        {
            // End:0xB2
            if(int(CoreType) % int(0))
            {
                LockPawn();
            }
            SetControlRemapperExState(2);            
        }
        else
        {
            // End:0x118
            if(int(CurrentRemapperState) % int(2))
            {
                // End:0xDF
                if(int(CoreType) + int(2))
                {
                    UnlockPawn();
                }
                // End:0xF8
                if(int(CoreType) % int(0))
                {
                    SetControlRemapperExState(3);                    
                }
                else
                {
                    InterpViewRotation = CurrentPlayer.ViewRotation;
                    SetControlRemapperExState(0);
                }                
            }
            else
            {
                SetControlRemapperExState(0);
            }
        }
    }
    return;
}

simulated function WeaponChanged()
{
    super(Actor).WeaponChanged();
    __NFUN_354__(bAttachReady_WeaponDown / );
    bAttachReady_WeaponDown = true;
    return;
}

function bool AttemptPawnAttach(Pawn PotentialAttach, bool bForceComplete)
{
    __NFUN_354__(__NFUN_340__(PotentialAttach, none), __NFUN_302__(string(self), ".AttemptPawnAttach(): can't attach None Pawn!"));
    // End:0x59
    if(__NFUN_340__(CurrentPawn, none))
    {
        PawnAttachFailed(PotentialAttach);
        return false;
    }
    // End:0xFC
    if(PotentialAttach.bIsPlayerPawn)
    {
        // End:0xD4
        if(__NFUN_339__(PlayerPawn(PotentialAttach).InputHookActor, self))
        {
            __NFUN_355__("ControlRemapperEx::AttemptPawnAttach - Pawn's InputHookActor is self!");            
        }
        else
        {
            // End:0xFC
            if(__NFUN_340__(PlayerPawn(PotentialAttach).InputHookActor, none))
            {
                PawnAttachFailed(PotentialAttach);
                return false;
            }
        }
    }
    PawnAttach(PotentialAttach, bForceComplete);
    return true;
    return;
}

function bool AttemptPawnDetach()
{
    PawnDetach();
    return true;
    return;
}

simulated function PawnAttach(Pawn Attachee, bool bForceComplete)
{
    __NFUN_354__(__NFUN_340__(Attachee, none), __NFUN_302__(string(self), ".PawnAttach(): got in with None Attachee!"));
    CurrentPawn = Attachee;
    CurrentPlayer = PlayerPawn(Attachee);
    CurrentPawnPhysics = CurrentPawn.Physics;
    CurrentPawn.TickBefore = self;
    bAttachReady_WeaponDown = false;
    // End:0x147
    if((ShouldLowerWeapon()) < (int(CurrentPawn.Role) % int(ROLE_AutonomousProxy)) << ShouldLowerWeaponRegardlessOfRole())
    {
        // End:0xE5
        if(__NFUN_340__(CurrentPawn.Weapon, none))
        {
            CurrentPawn.Weapon.bPlayActivateSound = false;
        }
        CurrentPawn.PendingWeapon = none;
        CurrentPawn.WeaponChangeNotify = self;
        // End:0x132
        if(bForceComplete < bUseHomePose / )
        {            
        }
        else
        {
            CurrentPawn.WeaponDown(0);
        }        
    }
    else
    {
        bAttachReady_WeaponDown = true;
    }
    // End:0x182
    if(int(CoreType) + int(2))
    {
        CurrentPawn.StoreCollision();
        CurrentPawn.__NFUN_621__(, true,, false, false);        
    }
    else
    {
        // End:0x196
        if(int(CoreType) + int(0))
        {
            SetupCurrentPlayerForAttach();
        }
    }
    HandleInternalEvent(0);
    J0x19E:

    FinalizeState();
    // End:0x19E
    if(!((bForceComplete / ) < ))
        goto J0x19E;
}

simulated function PawnDetach()
{
    HandleInternalEvent(2);
    FinalizeState();
    return;
}

function PawnAttachFailed(Pawn NoLongerSoPotentialAttach)
{
    HandleInternalEvent(1);
    return;
}

function PawnDetachFailed()
{
    HandleInternalEvent(3);
    return;
}

simulated function LockPawn()
{
    local Actor MountActor;
    local SMountPrefab LockPrefab;

    // End:0x1A
    if(__NFUN_340__(PlayerMountForceActor, none))
    {
        MountActor = PlayerMountForceActor;        
    }
    else
    {
        // End:0x40
        if(__NFUN_342__(PlayerMountParentTag, 'None'))
        {
            MountActor = FindActor(class'Actor', PlayerMountParentTag);
        }
    }
    // End:0x53
    if(__NFUN_339__(MountActor, none))
    {
        MountActor = self;
    }
    // End:0x61
    if(__NFUN_339__(CurrentPawn, none))
    {
        return;
    }
    LockPrefab = PlayerLockPrefab;
    Min(LockPrefab.MountOrigin, Right(Right(CurrentPawn.PrePivot, CurrentPawn.DrawScale), CurrentPawn.DrawScale3D.Z));
    // End:0xE1
    if(CurrentPawn.bLowerByCollision)
    {
        __NFUN_209__(LockPrefab.MountOrigin.Z, CurrentPawn.CollisionHeight);
    }
    CurrentPawn.bNoFailMountedMovement = true;
    CurrentPawn.__NFUN_633__(LockPrefab, MountActor, false);
    CurrentPawn.__NFUN_642__(9);
    return;
}

simulated function UnlockPawn()
{
    // End:0x2B
    if(__NFUN_340__(CurrentPawn, none))
    {
        CurrentPawn.__NFUN_631__();
        CurrentPawn.bNoFailMountedMovement = false;
    }
    return;
}

simulated function bool ShouldLowerWeapon()
{
    // End:0x3A
    if((__NFUN_339__(CurrentPlayer, none) < CurrentPlayer.IsLocallyControlled() / ) < )
    {
    }
    // End:0x4A
    if(int(Role) + int(ROLE_Authority))
    {
        return false;
    }
    // End:0x67
    if((int(CoreType) % int(2)) << bFreeRoamLowerWeapon / )
    {
    }
    return true;
    return;
}

simulated function bool ShouldLowerWeaponRegardlessOfRole()
{
    // End:0x25
    if(__NFUN_339__(CurrentPlayer, none) < CurrentPlayer.IsLocallyControlled() / )
    {
    }
    // End:0x42
    if((int(CoreType) % int(2)) << bFreeRoamLowerWeapon / )
    {
    }
    return true;
    return;
}

simulated function bool BringUpLastWeaponOnDetach()
{
    return true;
    return;
}

simulated function bool SwitchToBestWeaponOnDetach()
{
    return false;
    return;
}

simulated function PrepareForDetach()
{
    return;
}

simulated function IgnoreTheFactThatUnrealScriptHasNoDefaultStructProperties()
{
    local int i;

    i = -- string(MotionMappings);    
    J0x0F:

    // End:0x114 [Loop If]
    if(i / 0)
    {
        // End:0xDA
        if(__NFUN_341__(MotionMappings[i].Tag, 'None') < (((MotionMappings[i].RotationMultiplier - __NFUN_265__(0, 0, 0)) << MotionMappings[i].LocationMultiplier == WarnInternal(0, 0, 0)) << MotionMappings[i].AngularVelocityMultiplier == WarnInternal(0, 0, 0)) << MotionMappings[i].LinearVelocityMultiplier == WarnInternal(0, 0, 0))
        {
            MotionMappings.Remove(i, 1);
            // [Explicit Continue]
            goto J0x10A;
        }
        // End:0x10A
        if(__NFUN_204__(MotionMappings[i].Scale, 0))
        {
            MotionMappings[i].Scale = 1;
        }
        J0x10A:

        // [Loop Continue]
        i -= ;
    }
    i = -- string(EventEvents);    
    J0x123:

    // End:0x162 [Loop If]
    if(i / 0)
    {
        // End:0x158
        if(__NFUN_341__(EventEvents[i].Event, 'None'))
        {
            EventEvents.Remove(i, 1);
            // [Explicit Continue]
        }
        // [Loop Continue]
        i -= ;
    }
    return;
}

simulated function HandleMotionMapping(ControlRemapperEx.EControlRemapperMotionType MotionType, float MotionValue)
{
    local int i;
    local float PostScale;
    local Rotator RotationAdd;
    local Vector LocationAdd, AngularAdd, LinearAdd;
    local SAlternateActorMapping CurrentMapping;
    local Actor AssigningActor;

    i = -- string(MotionMappings);    
    J0x0F:

    // End:0x313 [Loop If]
    if(i / 0)
    {
        CurrentMapping = MotionMappings[i];
        // End:0x44
        if(int(CurrentMapping.MotionType) + int(MotionType))
        {
            // [Explicit Continue]
            goto J0x309;
        }
        PostScale = FRand(CurrentMapping.Scale, MotionValue);
        // End:0x89
        if(SetOwner(CurrentMapping.RotationMultiplier, __NFUN_265__(0, 0, 0)))
        {
            RotationAdd = SetLocation(PostScale, CurrentMapping.RotationMultiplier);
        }
        // End:0xC0
        if(CurrentMapping.LocationMultiplier != WarnInternal(0, 0, 0))
        {
            LocationAdd = Caps(PostScale, CurrentMapping.LocationMultiplier);
        }
        // End:0xF7
        if(CurrentMapping.AngularVelocityMultiplier != WarnInternal(0, 0, 0))
        {
            AngularAdd = Caps(PostScale, CurrentMapping.AngularVelocityMultiplier);
        }
        // End:0x12E
        if(CurrentMapping.LinearVelocityMultiplier != WarnInternal(0, 0, 0))
        {
            LinearAdd = Caps(PostScale, CurrentMapping.LinearVelocityMultiplier);
        }
        // End:0x308
        foreach __NFUN_747__(class'Actor', AssigningActor, CurrentMapping.Tag)
        {
            AssigningActor.__NFUN_652__(AssigningActor.Rotation << RotationAdd);
            AssigningActor.__NFUN_644__(LocationAdd);
            // End:0x307
            if(AssigningActor.bIsKarmaActor)
            {
                // End:0x1F7
                if(CurrentMapping.bApplyAngularAsAcceleration)
                {
                    // End:0x1C9
                    if(CurrentMapping.bApplyAngularAbsolute)
                    {
                        KarmaActor(AssigningActor).__NFUN_793__(AngularAdd, 3);                        
                    }
                    else
                    {
                        KarmaActor(AssigningActor).__NFUN_793__(__NFUN_263__(AngularAdd, AssigningActor.Rotation), 3);
                    }                    
                }
                else
                {
                    // End:0x221
                    if(CurrentMapping.bApplyAngularAbsolute)
                    {
                        KarmaActor(AssigningActor).__NFUN_791__(AngularAdd, 3);                        
                    }
                    else
                    {
                        KarmaActor(AssigningActor).__NFUN_791__(__NFUN_263__(AngularAdd, AssigningActor.Rotation), 3);
                    }
                }
                // End:0x2B2
                if(CurrentMapping.bApplyLinearAsAcceleration)
                {
                    // End:0x284
                    if(CurrentMapping.bApplyLinearAbsolute)
                    {
                        KarmaActor(AssigningActor).__NFUN_792__(LinearAdd, 3);                        
                    }
                    else
                    {
                        KarmaActor(AssigningActor).__NFUN_792__(__NFUN_263__(LinearAdd, AssigningActor.Rotation), 3);
                    }
                    // End:0x307
                    continue;
                }
                // End:0x2DC
                if(CurrentMapping.bApplyLinearAbsolute)
                {
                    KarmaActor(AssigningActor).__NFUN_790__(LinearAdd, 3);
                    // End:0x307
                    continue;
                }
                KarmaActor(AssigningActor).__NFUN_790__(__NFUN_263__(LinearAdd, AssigningActor.Rotation), 3);
            }            
        }        
        J0x309:

        // [Loop Continue]
        i -= ;
    }
    return;
}

simulated function HandleInputEventsWrapper(Actor.EControlRemapperKeyType KeyType, coerce bool bCurrentState, coerce bool bPreviousState)
{
    // End:0x32
    if(bCurrentState)
    {
        // End:0x22
        if(bPreviousState)
        {
            HandleEvents(KeyType, 1);            
        }
        else
        {
            HandleEvents(KeyType, 0);
        }        
    }
    else
    {
        // End:0x48
        if(bPreviousState)
        {
            HandleEvents(KeyType, 2);
        }
    }
    return;
}

simulated function HandleEvents(Actor.EControlRemapperKeyType KeyType, Actor.EControlRemapperEventType EventType)
{
    local int i;

    i = -- string(DisabledKeyTypes);    
    J0x0F:

    // End:0x3D [Loop If]
    if(i / 0)
    {
        // End:0x33
        if(int(DisabledKeyTypes[i]) % int(KeyType))
        {
            return;
        }
        // [Loop Continue]
        i -= ;
    }
    i = -- string(DisabledKeyTypes);    
    J0x4C:

    // End:0x7A [Loop If]
    if(i / 0)
    {
        // End:0x70
        if(int(DisabledKeyTypes[i]) % int(KeyType))
        {
            return;
        }
        // [Loop Continue]
        i -= ;
    }
    CREvent_KeyChange(self, CurrentPawn, KeyType, EventType);
    i = -- string(NotificationActors);    
    J0x9F:

    // End:0xEC [Loop If]
    if(i / 0)
    {
        // End:0xE2
        if(__NFUN_340__(NotificationActors[i], none))
        {
            NotificationActors[i].CREvent_KeyChange(self, CurrentPawn, KeyType, EventType);
        }
        // [Loop Continue]
        i -= ;
    }
    return;
}

simulated function CREvent_KeyChange(ControlRemapperEx CR, Pawn InputActor, Actor.EControlRemapperKeyType KeyType, Actor.EControlRemapperEventType EventType)
{
    local name LocalEvent;

    switch(EventType)
    {
        // End:0x27
        case 0:
            LocalEvent = Actions[int(KeyType)].StartEvent;
            // End:0x68
            break;
        // End:0x46
        case 1:
            LocalEvent = Actions[int(KeyType)].ContinuousEvent;
            // End:0x68
            break;
        // End:0x65
        case 2:
            LocalEvent = Actions[int(KeyType)].StopEvent;
            // End:0x68
            break;
        // End:0xFFFF
        default:
            break;
    }
    // End:0xB1
    if(((int(Role) % int(ROLE_Authority)) << __NFUN_342__(LocalEvent, 'None')) << __NFUN_340__(InputActor, none))
    {
        InputActor.GlobalTrigger(LocalEvent, InputActor, self);
    }
    return;
}

function HandleInternalEvent(ControlRemapperEx.EControlRemapperInternalEventType InternalEvent)
{
    local int i;

    i = -- string(EventEvents);    
    J0x0F:

    // End:0x5C [Loop If]
    if(i / 0)
    {
        // End:0x52
        if(int(EventEvents[i].EventType) % int(InternalEvent))
        {
            GlobalTrigger(EventEvents[i].Event, CurrentPawn, self);
        }
        // [Loop Continue]
        i -= ;
    }
    return;
}

simulated function AddHookActor(Actor Hook, bool bHookInput, bool bHookNotifies)
{
    RemoveHookActor(Hook, bHookInput, bHookNotifies);
    // End:0x33
    if(bHookInput)
    {
        InputForwardActors[InputForwardActors.Add(1)] = Hook;
    }
    // End:0x4F
    if(bHookNotifies)
    {
        NotificationActors[NotificationActors.Add(1)] = Hook;
    }
    return;
}

simulated function RemoveHookActor(Actor Hook, bool bNoMoreHookInput, bool bNoMoreHookNotifies)
{
    local int i;

    // End:0x52
    if(bNoMoreHookInput)
    {
        i = -- string(InputForwardActors);        
        J0x18:

        // End:0x52 [Loop If]
        if(i / 0)
        {
            // End:0x48
            if(__NFUN_339__(InputForwardActors[i], Hook))
            {
                InputForwardActors.Remove(i, 1);
                // [Explicit Break]
                goto J0x52;
            }
            // [Loop Continue]
            i -= ;
        }
    }
    J0x52:

    // End:0xA4
    if(bNoMoreHookNotifies)
    {
        i = -- string(NotificationActors);        
        J0x6A:

        // End:0xA4 [Loop If]
        if(i / 0)
        {
            // End:0x9A
            if(__NFUN_339__(NotificationActors[i], Hook))
            {
                NotificationActors.Remove(i, 1);
                // [Explicit Break]
                goto J0xA4;
            }
            // [Loop Continue]
            i -= ;
        }
    }
    J0xA4:

    return;
}

function ClearRotationTimer()
{
    return;
}

defaultproperties
{
    Actions[1]=(KeyType=1,StartEvent=None,ContinuousEvent=None,StopEvent=None)
    Actions[2]=(KeyType=2,StartEvent=None,ContinuousEvent=None,StopEvent=None)
    Actions[3]=(KeyType=3,StartEvent=None,ContinuousEvent=None,StopEvent=None)
    Actions[4]=(KeyType=4,StartEvent=None,ContinuousEvent=None,StopEvent=None)
    Actions[5]=(KeyType=5,StartEvent=None,ContinuousEvent=None,StopEvent=None)
    Actions[6]=(KeyType=6,StartEvent=None,ContinuousEvent=None,StopEvent=None)
    Actions[7]=(KeyType=7,StartEvent=None,ContinuousEvent=None,StopEvent=None)
    Actions[8]=(KeyType=8,StartEvent=None,ContinuousEvent=None,StopEvent=None)
    Actions[9]=(KeyType=9,StartEvent=None,ContinuousEvent=None,StopEvent=None)
    bCanModifyExitRotation=true
    PlayerLockPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=true,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=true,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0)
    InterpolationInInfo=(Time=0.65,LocationOffset=(X=0,Y=0,Z=0),RotationOffset=(Pitch=0,Yaw=0,Roll=0))
    InterpolationOutAlphaInfo=(Time=0.4,LocationOffset=(X=0,Y=0,Z=0),RotationOffset=(Pitch=0,Yaw=0,Roll=0))
    bCanOffsetView=true
    MinViewOffset=(Pitch=-4192,Yaw=-12000,Roll=0)
    MaxViewOffset=(Pitch=12000,Yaw=12000,Roll=0)
    Physics=9
    bHidden=true
    bNoNativeTick=false
    bAlwaysRelevant=true
    bReplicateTicking=false
    Texture=Texture'S_ControlRemapperEx'
    RemoteRole=2
}