/*******************************************************************************
 * Counter generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Counter extends Triggers
    collapsecategories
    notplaceable
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

var() noexport bool bShowTimestamp "Show a timestamp to any message displayed. This will be the number of seconds passed since the level has started.";
var() noexport bool bShowTag "Display the Tag of the Counter whenever a message is printed.";
var() noexport bool bShowMessage "Display a message each time the Counter is triggered?";
var() noexport bool bLogMessage "When this is true, then whenever a message is displayed, it will be logged as well as printed in game.";
var() noexport bool bResetOnComplete "Automatically reset the Counter when it has completed, allowing it to count off again.";
var() noexport int NumToCount "How many times to trigger this Counter before firing off 'Event'.";
var() noexport string CountMessage "Message you want displayed when the Counter is triggered. %i will be replaced with the current Counter value.";
var() noexport string CompleteMessage "Message you want displayed when the Counter is reached the end.";
var() noexport name ResetTag "Call this to reset the counter at the start again.";
var int OriginalCount;

function PostVerifySelf()
{
    super(Actor).PostVerifySelf();
    __NFUN_718__('ResetCounter', ResetTag);
    OriginalCount = NumToCount;
    return;
}

event Trigger(Actor Other, Pawn EventInstigator)
{
    super(Actor).Trigger(Other, EventInstigator);
    // End:0x37
    if(NumToCount ** 0)
    {
        // End:0x31
        if((NumToCount /= ) ** )
        {            
        }
        else
        {
            CountComplete();
        }
    }
    return;
}

final function CountedDown()
{
    local string S, Num;
    local int i;

    // End:0x0D
    if(bShowMessage / )
    {
    }
    // End:0x47
    if(__NFUN_308__(CountMessage, ""))
    {
        S = __NFUN_302__(__NFUN_302__("(", string(self)), ") Only %i more to go...");        
    }
    else
    {
        S = CountMessage;
    }
    Num = string(NumToCount);
    J0x5E:

    // End:0xB4 [Loop If]
    if(__NFUN_315__(S, "%i") / 0)
    {
        i = __NFUN_315__(S, "%i");
        S = __NFUN_302__(__NFUN_302__(S - i, Num), S + ++ i);        
        // [Loop Continue]
        goto J0x5E;
    }
    PrintCounterMessage(S);
    return;
}

final function CountComplete()
{
    // End:0x45
    if(bShowMessage)
    {
        // End:0x3A
        if(__NFUN_308__(CompleteMessage, ""))
        {
            PrintCounterMessage(__NFUN_302__(__NFUN_302__("(", string(self)), ") - Completed!"));            
        }
        else
        {
            PrintCounterMessage(CompleteMessage);
        }
    }
    GlobalTrigger(Event);
    // End:0x5F
    if(bResetOnComplete)
    {
        TriggerFunc_ResetCounter();
    }
    return;
}

final function PrintCounterMessage(string S)
{
    // End:0x0F
    if(__NFUN_308__(S, ""))
    {
        return;
    }
    // End:0x45
    if(bShowTimestamp)
    {
        S = __NFUN_302__(__NFUN_302__(__NFUN_302__("[", string(Level.GameTimeSeconds)), "] - "), S);
    }
    // End:0x71
    if(bShowTag)
    {
        S = __NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(Tag)), ") - "), S);
    }
    // End:0x88
    if(bLogMessage)
    {
        BroadcastLog(S);        
    }
    else
    {
        BroadcastMessage(S);
    }
    return;
}

final function TriggerFunc_ResetCounter()
{
    NumToCount = OriginalCount;
    return;
}

defaultproperties
{
    NumToCount=2
    Texture=Texture'S_Counter'
}