/*******************************************************************************
 * InteractiveActor generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class InteractiveActor extends RenderActor
    abstract
    native
    nativereplication
    collapsecategories
    notplaceable
    dependson(PrecacheIndex)
    dependson(LevelInfo)
    dependson(SoftParticleSystem)
    dependson(BeamSystem)
    dependson(PhysicsAction_ConstVel)
    dependson(PhysicsAction_ConstAccel)
    dependson(MeshInstance)
    dependson(GameReplicationInfo)
    dependson(PhysicsVolume)
    dependson(GearboxEngineGlobals);

const CarriedActor_MaxNoPenaltyMass = 100.0;
const CarriedActor_PenaltyScaleMass = 100.0;

enum EFlushStyle
{
    FLUSH_None,
    FLUSH_Down,
    FLUSH_Shrink,
    FLUSH_Clog
};

enum EShrunkUseStyle
{
    SHRUNKUSE_Never,
    SHRUNKUSE_Always,
    SHRUNKUSE_SameSize,
    SHRUNKUSE_OnlyShrunk
};

struct SGrabInfo
{
    var() noexport bool bCanDuckWhileHeld "Whether the pawn holding us can duck while carrying us.";
    var() noexport name MountItemOverride "Special case override of the MountMeshItem we want to be mounted to, instead of the one the Pawn picking us up specifies. If the bone doesn't exist, falls back to the Pawn specified one.";
    var() noexport Vector MountOrigin "Positional offset from MountMeshItem for mounting this Actor.";
    var() noexport Rotator MountAngles "Rotational offset from MountMeshItem for mounting this Actor.";
    var() noexport name GrabAnimName "Animation to play on this InteractiveActor when it is grabbed. Type LeaveAsIs_ if you wish the InteractiveActor to simply be left in whatever position it was found in.";
    var() noexport name CarrierAnimName "Animation to play on the pawn that is carrying us.";
    var() noexport name CarrierMountPose "Animation to play on the pawn to position the carried item mount.";
    var() noexport name GrabSoundName "VoicePack entry to play when this Actor is grabbed.";
    var() noexport name ThrowSoundName "VoicePack entry to play when this Actor is thrown.";
    var SSoundInfo GrabSoundInfo;
    var SSoundInfo ThrowSoundInfo;
};

struct SMicrowaveInfo
{
    var() noexport float TimeToMicrowave "How long it takes for this item to get microwaved. Set to > 0 to enable micrwavability.";
    var InteractiveActor MicrowaveActor;
    var float LastMicrowaveTime;
};

struct SExitWoundInfo
{
    var() noexport class<DamageType> DamageType "Which damagetype should cause this sort of exit wound? (If None, will accept all damagetypes.)";
    var() noexport float MinimumDamage "We must take at least this much damage before we consider spawning our effects for an exit wound.";
    var() noexport float RandomChance "If non-zero, this is the change (0.0 - 1.0) that if our other criteria are met, we'll spawn this decal.";
    var() noexport class<Decal> ExitWoundDecalClass "Spawn this type decal type (facing the direction the damage would exit the actor from) when damage of the correct type is taken.";
};

var(Challenges) noexport name ChallengeTag "A challenge tag name.";
var(Challenges) const noexport bool ShowWhenChallengeLocked "When true the item will be shown when the challenge is locked and hidden when it is unlocked";
var(Challenges) name ShowComponentEvent;
var(Challenges) name HideComponentEvent;
var(Challenges) noexport float ProximityDistance "Used to teleport player away when object is unhidden within this radius distance";
var(Challenges) noexport float GlowDistance "The distance at which the object will start glowing";
var(Challenges) noexport bool bChallengeGlow "If the object should glow in MyDigs";
var(Challenges) noexport name ChallengeTurnOnGlowTag "Tag for event to turn on glow";
var(Challenges) noexport name ChallengeTurnOffGlowTag "Tag for event to turn off glow";
var(InteractHUDInfo) noexport bool bLookWhenHidden "If true, the HUD can see this actor even when it's hidden.";
var(InteractHUDInfo) noexport bool bDrawHUDInfo "If true, then when a player is looking at the object, it will display the information bar on the HUD.";
var(InteractHUDInfo) noexport bool bDrawUsePhrase "Whether to display the Use Phrase or not.";
var(InteractHUDInfo) noexport bool bNoUseKeyInfo "If true, then it will only display the Use Phrase, not the 'Press 'E' to ' type of information";
var(InteractHUDInfo) noexport bool bForceUsePhrase "If true, this will force it to always use the use phrase, instead of autogenerating the 'use' and 'grab' properties.";
var(InteractHUDInfo) noexport bool bUnUseOnLookChange "Cause an UnUse to fire off when this actor is looked away from in the HUD.";
var(InteractUsing) noexport bool bUsable "When this is true, then when a PlayerPawn presses 'use' on the actor it will execute the Used code.";
var(InteractUsing) noexport bool bUnUsable "When this is true, then when the PlayerPawn lets go of the 'use' key, it will perform the UnUsed code.";
var(InteractUsing) noexport bool bUseTriggered "Triggered by player use.";
var(InteractUsing) noexport bool bGrabUsable "Actor is capable of being used while it is being held.";
var(InteractUsing) noexport bool bGrabUnusable "Actor is capable of being un-used while it is being held.";
var(InteractUsing) noexport bool bCheckUseAngle "Set this to true to force checking UseAngleThreshold. This is an optimization to prevent some math from being calculated on things that don't need to check angles.";
var(InteractUsing) noexport bool bMimicOwner "When this is true, pass all interaction checks to the owner of this actor.  If owner is None or not an InteractiveActor, this flag is ignored.";
var(InteractUsing) noexport bool bPassUseToOwner "When this is true, pass Used to the owner of this actor.  If owner is None or not an InteractiveActor, this flag is ignored.";
var(InteractGrabbing) noexport bool bGrabbable "This object is able to be grabbed and carried.";
var bool SavedbGrabbable;
var bool BeingThrown;
var bool WasThrownByPlayer;
var bool ReservedForPickup;
var bool UnderTelekineticControl;
var bool BeingTelekineticThrown;
var(InteractTeleKinesis) const noexport bool bTelekineticable "This object is able to be moved by Telekinetic creatures.";
var(InteractTeleKinesis) noexport bool bTelekineticableSingleOnly "This cant be TKd if we are already TKing something else";
var(InteractMisc) noexport bool bShowUpOnRadar "If true, then if a radar is looking for an actor of this class, it will show up on it.";
var(InteractEMP) noexport bool bShielded "Should this actor spawn a shield whenever it takes damage? (This will probably be silly for killable actors.";
var bool bEMPulsed;
var bool bMultiEMPulse;
var bool bAbsorbDamage;
var bool bIgnoreTestCanSeeMe;
var(Advanced) const noexport bool bCanShowSelf "If true, will exist in the AIInterests list for use as a look target.";
var(InteractUsing) noexport InteractiveActor.EShrunkUseStyle ShrunkUseStyle "How pawns can interact with this actor when they are shrunken.";
var(InteractGrabbing) noexport InteractiveActor.EShrunkUseStyle ShrunkGrabStyle "Controls when pawns can grab this actor.  Same as ShrunkUseStyle, but for grabbing.";
var(InteractGrabbing) noexport Object.EPhysics ThrowPhysics "Physics to assign when the actor is thrown.";
var Object.EPhysics PostTKPhysics;
var(InteractHUDInfo) noexport localized string UsePhrase "Phrase placed in the hud when you are looking at an object. Indicates the action taken when it's used.";
var(InteractHUDInfo) noexport localized string GrabUsePhrase "Phrase placed in the hud when you are holding an object and it can be grab used.";
var(InteractHUDInfo) noexport localized string GrabUseCombinePhrase "Phrase placed in the hud when you are holding an object, but looking at this object, and they can be combined together.";
var(InteractHUDInfo) string IconGrab;
var(InteractHUDInfo) string IconUse;
var(InteractUsing) noexport array<Actor.EPostureStateEx> UsePostureSuccess "Player must be in one of these posture states to succeed a use call.";
var(InteractUsing) noexport array<Actor.EPostureStateEx> UsePostureFailure "Player can not be in any of these posture states to succeed a use call.";
var(InteractUsing) noexport array<Object.EPhysics> UsePhysicsSuccess "Player must be in one of these physics modes to succeed a use call.";
var(InteractUsing) noexport array<Object.EPhysics> UsePhysicsFailure "Player can not be in any of these physics states to succeed a use call.";
var(InteractUsing) noexport float UseAngleThreshold "Player must be within this angle to use the specified item. This is only for PlayerPawns, AI can use it from any angle.";
var float EndViewingAngleMinDiff;
var Pawn CarriedBy;
var(InteractGrabbing) noexport SGrabInfo GrabInfo "Information for how this actor carried when it gets grabbed.";
var(InteractGrabbing) noexport float ThrowForce "Force with which to throw the actor if non-zero";
var(InteractGrabbing) noexport name ThrowBone "Apply the force to throw the object at this bone.";
var(InteractGrabbing) noexport Rotator ThrowBaseRotation "Base rotation when thrown.";
var(InteractGrabbing) noexport Rotator ThrowBaseRotationVariance "Amount to vary the base rotation when thrown by.";
var(InteractGrabbing) noexport Rotator ThrowDropBaseRotation "Base rotation when dropped.";
var(InteractGrabbing) noexport float ThrowForceScale "Scale normal throwing velocity by this amount.";
var(InteractGrabbing) noexport float ThrowForceScaleAI "Scale normal throwing velocity by this amount.";
var(InteractTeleKinesis) noexport string TelekinesisChargeClassName "Class to use for the Telekinesis effects.";
var(InteractTeleKinesis) noexport string TelekinesisBeamSystemClassName "Class to use for the Telekinesis Beam system";
var(InteractTeleKinesis) noexport Vector TelekinesisAngularVel "Angular Velocity when being controlled by Telekinesis.";
var(InteractTeleKinesis) noexport float TelekinesisThrowVel "Velocity we get thrown at when TK'd";
var SoftParticleSystem TelekinesisCharge;
var BeamSystem TelekinesisBeamSystem;
var(InteractMisc) noexport SMicrowaveInfo MicrowaveInfo "Information relating to microwaving this object.";
var(InteractMisc) array<SExitWoundInfo> ExitWoundInfo;
var InteractiveActor VendOwner;
var VendItemInfo VendInfo;
var(InteractEMP) noexport class<RenderActor> ShieldClass "What type of class should the shield be if [bShielded] is set?";
var(InteractEMP) float ShieldLifetime;
var(InteractEMP) float ShieldScaleFactor;
var(InteractEMP) MaterialEx ShieldTex;
var(InteractEMP) noexport name ForceEMPTag "Trigger this tag to force this InteractiveActor to start acting like it was hit by an EMP blast.";
var(InteractEMP) noexport name ForceUnEMPTag "Trigger this tag to force this InteractiveActor to stop acting like it was hit by an EMP blast.";
var(InteractEMP) noexport float ForcedEMPDisableTime "Same as EMPDisableTime, but used for Forced EMP when non-zero.";
var(InteractEMP) noexport float EMPDisableTime "Less than 0.0 means none, 0.0 means forever, and greater than 0.0 is the disable time.";
var RenderActor ShieldActor;
var float LastEMPTime;
var float DamageAbsorbAmount;
var float DamageAbsorbPct;
var float AvoidRange;
var(Startup) noexport anim name StartAnimSequence "Animation to start this Actor with";
var(Startup) noexport float StartAnimFrame "Frame to start actor in";

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        CarriedBy, bEMPulsed;

    // Pos:0x00B
    reliable if(int(Role) % int(ROLE_Authority))
        bGrabUsable;

    // Pos:0x016
    reliable if((int(Role) % int(ROLE_Authority)) << bNetInitial)
        bGrabbable;

    // Pos:0x02C
    reliable if(int(Role) % int(ROLE_Authority))
        ClientGrabbed, ClientUnGrabbed;
}

simulated event PostBeginPlay()
{
    local Inventory Inv;

    super.PostBeginPlay();
    // End:0x1D
    if(bBlockKarma)
    {
        __NFUN_803__(StartAnimSequence, StartAnimFrame, true);
    }
    // End:0x5E
    if(bShowUpOnRadar)
    {
        // End:0x5D
        foreach __NFUN_747__(class'Inventory', Inv)
        {
            // End:0x5C
            if(Inv.__NFUN_358__('Upgrade_Radar'))
            {
                Inv.SpawnNotify(self);
            }            
        }        
    }
    // End:0x77
    if(int(ThrowPhysics) % int(11))
    {
        ThrowPhysics = Physics;
    }
    // End:0x90
    if(ShouldMimicOwner())
    {
        MimicOwner(InteractiveActor(Owner));
    }
    // End:0xF4
    if((bPassUseToOwner << __NFUN_340__(Owner, none)) << Owner.bIsInteractiveActor)
    {
        bUsable = InteractiveActor(Owner).bUsable;
        bUnUsable = InteractiveActor(Owner).bUnUsable;
    }
    __NFUN_718__('ForceEMP', ForceEMPTag);
    __NFUN_718__('ForceUnEMP', ForceUnEMPTag);
    __NFUN_718__('ChallengeGlowOn', ChallengeTurnOnGlowTag);
    __NFUN_718__('ChallengeGlowOff', ChallengeTurnOffGlowTag);
    // End:0x161
    if(bTelekineticable << bIsProjectile / )
    {
    }
    return;
}

// Export UInteractiveActor::execSetTelekineticable(FFrame&, void* const)
native simulated function SetTelekineticable(bool bCanTK);

function ShowComponents()
{
    GlobalTrigger(ShowComponentEvent, none);
    return;
}

function HideComponents()
{
    GlobalTrigger(HideComponentEvent, none);
    return;
}

event bool CarrierFireUp()
{
    return;
}

simulated event bool CarrierFireDown()
{
    CarriedBy.DropCarriedActor();
    return true;
    return;
}

event bool CarrierMeleeUp()
{
    return;
}

simulated event bool CarrierMeleeDown()
{
    return true;
    return;
}

function float AbsorbDamage(float Damage, class<DamageType> DamageType)
{
    local float damageAbsorbed;

    // End:0x11
    if(bAbsorbDamage / )
    {
    }
    damageAbsorbed = FRand(DamageAbsorbPct, Damage) -= DamageAbsorbAmount;
    DamageAbsorbAmount ~= damageAbsorbed;
    // End:0x4A
    if(__NFUN_202__(DamageAbsorbAmount, float(0)))
    {
        bAbsorbDamage = false;
    }
    return VSize(0, Round(Damage, damageAbsorbed));
    return;
}

function bool CanAbsorbDamage()
{
    return bAbsorbDamage;
    return;
}

function bool ShouldDoExitWound(Pawn DamageInstigator)
{
    local GearboxEngineGlobals Globals;

    // End:0x23
    if(__NFUN_340__(PhysicsVolume, none) << PhysicsVolume.bWaterVolume)
    {
        return false;
    }
    Globals = __NFUN_404__();
    // End:0x61
    if((__NFUN_340__(Globals, none) << string(ExitWoundInfo) ** 0) << Globals.CanDoExitWoundNow(self))
    {
        return true;        
    }
    else
    {
        return false;
    }
    return;
}

// Export UInteractiveActor::execDoExitWound(FFrame&, void* const)
native(857) final function DoExitWound(Pawn DamageInstigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType);

event TakeHitDamage(Pawn HitInstigator, float HitDamage, Vector HitOrigin, Vector HitDirection, name HitMeshBone, class<TraceDamageType> HitDamageType, Vector HitDamageStart)
{
    super(Actor).TakeHitDamage(HitInstigator, HitDamage, HitOrigin, HitDirection, HitMeshBone, HitDamageType, HitDamageStart);
    // End:0x53
    if(ShouldDoExitWound(HitInstigator))
    {
        __NFUN_857__(HitInstigator, HitDamage, HitOrigin, HitDirection, HitDamageType);
    }
    return;
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    // End:0x18
    if((MPRoundNotInProgress()) << bIsPlayerPawn / )
    {
    }
    super.TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    // End:0x5E
    if(bShielded)
    {
        CreateShield();
        __NFUN_605__(ShieldLifetime, false, 'HideShield');
    }
    return;
}

simulated function bool MPRoundNotInProgress()
{
    local Pawn P;

    // End:0x6D
    if(IsMP())
    {
        P = Level.PawnList;
        J0x1E:

        // End:0x6D [Loop If]
        if(__NFUN_340__(P, none))
        {
            // End:0x55
            if(P.bIsPlayerPawn)
            {
                return PlayerPawn(P).IsRoundInProgress() / ;
            }
            // [Loop Continue]
            goto J0x1E;
        }
    }
    return false;
    return;
}

event FellOutOfWorld()
{
    // End:0x0E
    if(__NFUN_340__(CarriedBy, none))
    {
        return;
    }
    super(Actor).FellOutOfWorld();
    return;
}

simulated function Destroyed()
{
    local Inventory Inv;

    super.Destroyed();
    // End:0x47
    if(bShowUpOnRadar)
    {
        // End:0x46
        foreach __NFUN_747__(class'Inventory', Inv)
        {
            // End:0x45
            if(Inv.__NFUN_358__('Upgrade_Radar'))
            {
                Inv.DestroyedNotify(self);
            }            
        }        
    }
    // End:0x67
    if(__NFUN_340__(CarriedBy, none))
    {
        CarriedBy.DropCarriedActor(, true,, true);
    }
    StopTelekinesis();
    GlobalTrigger(Event);
    return;
}

simulated function InteractiveEvent(name Ev)
{
    return;
}

simulated event bool ShouldDrawHUDInfoUsePhrase(Pawn TestPawn)
{
    // End:0x24
    if(ShouldMimicOwner())
    {
        return InteractiveActor(Owner).ShouldDrawHUDInfoUsePhrase(TestPawn);
    }
    // End:0x68
    if(((IsMP()) << TestPawn.bIsPlayerPawn) << PlayerPawn(TestPawn).GameReplicationInfo.bWaitingForPlayers)
    {
        return false;
    }
    return bDrawUsePhrase << (bUsable << CanBeUsedBy(TestPawn)) < bGrabbable << TestPawn.CanGrabActor(self);
    return;
}

function bool ShouldDrawHUDInfoHealth()
{
    return bNoDamage / ;
}

simulated function bool CanBeUsedBy(Pawn User)
{
    // End:0x2D
    if(bPassUseToOwner << __NFUN_340__(Owner, none))
    {
        return Owner.CanBeUsedBy(User);
    }
    // End:0x48
    if((bUsable / ) < )
    {
    }
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    /*@Error*/;
}

// Export UInteractiveActor::execCanBeGrabbedBy(FFrame&, void* const)
native simulated event bool CanBeGrabbedBy(Pawn User);

simulated function bool CanBeGrabUsedBy(Pawn User)
{
    return bGrabUsable;
    return;
}

final simulated function bool CheckUserPostureStateEx(Pawn User)
{
    local int i;

    // End:0x17
    if(User.__NFUN_358__('BaseAI'))
    {
        return true;
    }
    // End:0x6B
    if(string(UsePostureSuccess) ** 0)
    {
        i = -- string(UsePostureSuccess);        
        J0x32:

        // End:0x6B [Loop If]
        if(i / 0)
        {
            // End:0x61
            if(int(User.PostureStateEx) % int(UsePostureSuccess[i]))
            {
                // [Explicit Break]
                goto J0x6B;
            }
            // [Loop Continue]
            i -= ;
        }
    }
    J0x6B:

    // End:0x78
    if(-i)
    {        
        return false;
    }
    i = -- string(UsePostureFailure);    
    J0x87:

    // End:0xBF [Loop If]
    if(i / 0)
    {
        // End:0xB5
        if(int(User.PostureStateEx) % int(UsePostureFailure[i]))
        {
            return false;
        }
        // [Loop Continue]
        i -= ;
    }
    return true;
    return;
}

final simulated function bool CheckUserPhysics(Pawn User)
{
    local int i;

    // End:0x54
    if(string(UsePhysicsSuccess) ** 0)
    {
        i = -- string(UsePhysicsSuccess);        
        J0x1B:

        // End:0x54 [Loop If]
        if(i / 0)
        {
            // End:0x4A
            if(int(User.Physics) % int(UsePhysicsSuccess[i]))
            {
                // [Explicit Break]
                goto J0x54;
            }
            // [Loop Continue]
            i -= ;
        }
    }
    J0x54:

    // End:0x61
    if(-i)
    {        
        return false;
    }
    i = -- string(UsePhysicsFailure);    
    J0x70:

    // End:0xA8 [Loop If]
    if(i / 0)
    {
        // End:0x9E
        if(int(User.Physics) % int(UsePhysicsFailure[i]))
        {
            return false;
        }
        // [Loop Continue]
        i -= ;
    }
    return true;
    return;
}

final simulated function bool CheckUserUseAngle(Pawn User)
{
    local float Dot;
    local Vector Delta;

    // End:0x17
    if(User.bIsPlayerPawn / )
    {
    }
    // End:0x24
    if(bCheckUseAngle / )
    {
    }
    Delta = __NFUN_239__(User.Location, Location) % ;
    // End:0x66
    if(__NFUN_200__(Dot, UseAngleThreshold))
    {
        return false;
    }
    return true;
    return;
}

// Export UInteractiveActor::execCheckUserShrunkUse(FFrame&, void* const)
native final simulated function bool CheckUserShrunkUse(Pawn User, InteractiveActor.EShrunkUseStyle TestShrunkUseStyle);

final simulated function bool CheckUserSwitchingWeapons(Pawn User)
{
    // End:0x5E
    if(__NFUN_340__(User.Weapon, none))
    {
        // End:0x5E
        if((int(User.Weapon.WeaponState) % int(2)) < int(User.Weapon.WeaponState) % int(1))
        {
            return true;
        }
    }
    return false;
    return;
}

simulated event string GetUsePhrase()
{
    // End:0x1F
    if(ShouldMimicOwner())
    {
        return InteractiveActor(Owner).GetUsePhrase();
    }
    return UsePhrase;
    return;
}

simulated event string GetGrabUsePhrase()
{
    // End:0x1F
    if(ShouldMimicOwner())
    {
        return InteractiveActor(Owner).GetGrabUsePhrase();
    }
    // End:0x35
    if(TraceActors(GrabUsePhrase, ""))
    {
        return GrabUsePhrase;        
    }
    else
    {
        return "";
    }
    return;
}

simulated event bool CanGrabUseCombine(InteractiveActor Combinee)
{
    // End:0x24
    if(ShouldMimicOwner())
    {
        return InteractiveActor(Owner).CanGrabUseCombine(Combinee);
    }
    return false;
    return;
}

simulated event string GetGrabUseCombinePhrase(InteractiveActor Combinee, string SpecialKey)
{
    // End:0x29
    if(ShouldMimicOwner())
    {
        return InteractiveActor(Owner).GetGrabUseCombinePhrase(Combinee, SpecialKey);
    }
    // End:0x3F
    if(TraceActors(GrabUseCombinePhrase, ""))
    {
        return GrabUseCombinePhrase;        
    }
    else
    {
        return "";
    }
    return;
}

// Export UInteractiveActor::execGetTargetedPoint(FFrame&, void* const)
native(858) final function int GetTargetedPoint(Vector fromPt, Vector lookingDir, array<Vector> Points);

function int GetUserLookAtPoint(Pawn User, array<Vector> Points)
{
    local Vector Origin, lookAt;

    Origin = User.__NFUN_872__();
    lookAt = Vector(User.ViewRotation);
    return __NFUN_858__(Origin, lookAt, Points);
    return;
}

function int GetUserFacingPoint(Pawn User, array<Vector> Points)
{
    local Vector Origin, lookAt;

    Origin = User.Location;
    lookAt = Vector(User.Rotation);
    return __NFUN_858__(Origin, lookAt, Points);
    return;
}

event Used(Actor Other, Pawn EventInstigator)
{
    super(Actor).Used(Other, EventInstigator);
    // End:0x5E
    if((bPassUseToOwner << __NFUN_340__(Owner, none)) << Owner.CanBeUsedBy(EventInstigator))
    {
        Owner.Used(Other, EventInstigator);        
    }
    else
    {
        // End:0x77
        if(bUseTriggered)
        {
            Trigger(Other, EventInstigator);
        }
    }
    return;
}

simulated function AnimCallback_UserPressed()
{
    return;
}

simulated function AnimCallback_UserReleased()
{
    return;
}

simulated function AnimCallback_UserAttached()
{
    return;
}

simulated function AnimCallback_UserDetached()
{
    return;
}

simulated function AnimCallback_UserAnimEnd()
{
    return;
}

simulated function HandleDecoAnimEvent(EventInfo EventParms)
{
    return;
}

simulated function Grabbed(Pawn Grabber)
{
    local KarmaActor KA;

    // End:0x0E
    if(__NFUN_339__(Grabber, none))
    {
        return;
    }
    // End:0x1F
    if(bChallengeGlow)
    {
        bDoOverlayEffect = false;
    }
    WasGrabbed();
    // End:0x8C
    if((bPassUseToOwner << __NFUN_340__(Owner, none)) << Owner.bIsInteractiveActor)
    {
        Grabber.CarriedActor = InteractiveActor(Owner);
        Grabber.CarriedActor.Grabbed(Grabber);
        return;
    }
    // End:0xB5
    if(__NFUN_340__(VendOwner, none))
    {
        VendOwner.NotifyPickup(self, Grabber);
        VendOwner = none;
    }
    __NFUN_631__();
    CarriedBy = Grabber;
    __NFUN_641__(CarriedBy);
    RemoteRole = ROLE_SimulatedProxy;
    bNeverTravel = false;
    __NFUN_642__(0);
    StoreCollision();
    MountToCarrier();
    // End:0x100
    if(IsMP())
    {
        ClientGrabbed(Grabber);
    }
    return;
}

function WasGrabbed()
{
    return;
}

simulated delegate ClientGrabbed(Pawn Grabber)
{
    StoreCollision();
    __NFUN_621__(, false, false, false, false);
    __NFUN_642__(0);
    return;
}

final simulated function MountToCarrier()
{
    // End:0x0E
    if(__NFUN_339__(CarriedBy, none))
    {
        return;
    }
    __NFUN_621__(, false, false, false, false);
    // End:0x6C
    if(__NFUN_342__(GrabInfo.GrabAnimName, 'LeaveAsIs_'))
    {
        __NFUN_568__();
        // End:0x47
        if(__NFUN_340__(MeshInstance, none))
        {
            MeshInstance.PlayerCanSeeMe();
        }
        // End:0x6C
        if(__NFUN_342__(GrabInfo.GrabAnimName, 'None'))
        {
            DecoPlayAnim(GrabInfo.GrabAnimName);
        }
    }
    // End:0xD0
    if((__NFUN_342__(GrabInfo.MountItemOverride, 'None') << __NFUN_340__(CarriedBy.__NFUN_568__(), none)) << CarriedBy.MeshInstance.FindRandomDest(GrabInfo.MountItemOverride))
    {
        MountMeshItem = GrabInfo.MountItemOverride;        
    }
    else
    {
        MountMeshItem = CarriedBy.CarriedActorMountMeshItem;
    }
    MountType = 2;
    MountOrigin = GrabInfo.MountOrigin;
    MountAngles = GrabInfo.MountAngles;
    __NFUN_635__(CarriedBy);
    return;
}

simulated function GrabComplete()
{
    CarriedBy.SetAnimControllerState(GrabInfo.CarrierAnimName);
    return;
}

simulated function bool CanBeThrown()
{
    return bCanBeThrown;
    return;
}

simulated function SetCylinderState(int stateIndex)
{
    return;
}

simulated function UnGrabbed(Pawn Grabber, bool Thrown)
{
    // End:0x11
    if(bChallengeGlow)
    {
        bDoOverlayEffect = true;
    }
    __NFUN_631__();
    CarriedBy = none;
    Instigator = Grabber;
    RemoteRole = default.RemoteRole;
    __NFUN_641__(none);
    RestoreCollision();
    __NFUN_642__(ThrowPhysics);
    bGrabbable = true;
    // End:0x6F
    if(Thrown)
    {
        __NFUN_812__(0);
        __NFUN_607__(1.5, false, 'ResetDynamicInteractionClassification');
        WasThrownByPlayer = true;
    }
    return;
}

simulated delegate ClientUnGrabbed(Pawn Grabber, bool Thrown, Vector Loc, Rotator Rot, float Force, Rotator DropDirection, float HeldTime, Vector AngularVelocity)
{
    // End:0x28
    if(Grabber.IsLocallyControlled() << int(Physics) % int(ThrowPhysics))
    {
        return;
    }
    __NFUN_631__();
    __NFUN_645__(Loc);
    __NFUN_652__(Rot);
    RestoreCollision();
    // End:0x5A
    if(int(Physics) + int(ThrowPhysics))
    {
        __NFUN_642__(ThrowPhysics);
    }
    bGrabbable = true;
    // End:0x7E
    if(Thrown)
    {
        __NFUN_812__(0);
        __NFUN_607__(1.5, false, 'ResetDynamicInteractionClassification');
    }
    // End:0x9C
    if(Thrown / )
    {        
    }
    else
    {
        Grabber.ApplyCarriedActorForce_Throwing(Force, DropDirection, HeldTime, AngularVelocity);
    }
    return;
}

final simulated function ResetDynamicInteractionClassification()
{
    // End:0x24
    if((int(DynamicInteractionClassification) + int(default.DynamicInteractionClassification)) << ShouldResetDynamicInteractionClassification())
    {
        __NFUN_812__(default.DynamicInteractionClassification);
    }
    WasThrownByPlayer = false;
    bGrabbable = default.bGrabbable;
    return;
}

simulated function bool ShouldResetDynamicInteractionClassification()
{
    return true;
    return;
}

function Vector GetImpulseLocation_Throwing()
{
    local Vector ImpulseLocation;

    return ImpulseLocation;
    return;
}

simulated function Rotator GetBaseRotation_Throwing(Pawn Thrower, Rotator TestThrowRotation)
{
    return TestThrowRotation << GetStateName(ThrowBaseRotation, ThrowBaseRotationVariance, false);
    return;
}

simulated function Rotator GetBaseRotation_Dropping(Pawn Thrower, Rotator TestDropRotation)
{
    return __NFUN_265__(0, TestDropRotation.Yaw, 0);
    return;
}

function float GetImpulseStrength_Throwing(Pawn Thrower, float BaseStrength, float HeldTime)
{
    local float ThrowStrength, HelperForce;

    HelperForce = 0;
    // End:0x2D
    if(__NFUN_340__(Thrower, none))
    {
        HelperForce = Thrower.CalculateCarriedActorThrowForce();
    }
    ThrowStrength = FRand(ThrowForceScale, Normal2D(BaseStrength, 0, -BaseStrength) *= HelperForce);
    return 50000;
    return;
}

simulated function Vector GetThrowVelocity(Pawn Thrower, Vector ThrowDirection, float HeldTime)
{
    return Locs(Thrower.Velocity, Right(Right(ThrowDirection, 1500), ThrowForceScale));
    return;
}

simulated function Rotator AdjustDropDirection_Throwing(Pawn Thrower, Rotator DropDirection)
{
    return DropDirection;
    return;
}

simulated function Vector AdjustAngularVelocity_Throwing(Pawn Thrower, Vector CurrentAngularVelocity)
{
    return CurrentAngularVelocity;
    return;
}

static function bool CanBeVended(Pawn PotentialBuyer)
{
    return default.bGrabbable;
    return;
}

function GrabUsed(Pawn Grabber)
{
    return;
}

function GrabUnUsed(Pawn Grabber)
{
    return;
}

function float GetPlayerMotionScale(PlayerPawn P)
{
    // End:0x19
    if(P.bOnSteroids)
    {
        return 1;
    }
    return Round(1, Normal2D(Round(Mass, 100) >>> 100, 0, 1));
    return;
}

function StartTelekinesis(Pawn TKOwner)
{
    local PhysicsAction_ConstAccel MyPA;

    // End:0x0B
    if(UnderTelekineticControl)
    {
        return;
    }
    UnderTelekineticControl = true;
    BeingTelekineticThrown = false;
    Instigator = TKOwner;
    PostTKPhysics = Physics;
    Velocity = WarnInternal(0, 0, 0);
    Acceleration = Velocity;
    // End:0x69
    if(int(Physics) + int(18))
    {
        __NFUN_642__(2);        
    }
    else
    {
        __NFUN_817__();
        MyPA = PhysicsAction_ConstAccel(__NFUN_824__(class'PhysicsAction_ConstAccel', true));
        MyPA.Setup(true, true, WarnInternal(0, 0, 0), TelekinesisAngularVel);
    }
    __NFUN_608__('ResetDynamicInteractionClassification');
    __NFUN_822__(TKOwner);
    LifeSpan = 0;
    bGrabbable = false;
    CreateTelekinesisFX();
    Instigator.NotifyTeleKinesisStarted(self);
    return;
}

function TelekineticThrow(Vector Vel, bool bConstrain)
{
    local PhysicsAction_ConstVel MyPA;

    // End:0x0D
    if(UnderTelekineticControl / )
    {
    }
    LifeSpan = default.LifeSpan;
    Velocity = WarnInternal(0, 0, 0);
    Acceleration = Velocity;
    __NFUN_825__(class'PhysicsAction_ConstAccel');
    __NFUN_642__(PostTKPhysics);
    // End:0xBB
    if(int(Physics) % int(18))
    {
        __NFUN_817__();
        // End:0xAA
        if(bConstrain)
        {
            BeingTelekineticThrown = true;
            KImpactThreshold = 0;
            MyPA = PhysicsAction_ConstVel(__NFUN_824__(class'PhysicsAction_ConstVel', true));
            MyPA.Setup(true, true, Vel, TelekinesisAngularVel);            
        }
        else
        {
            __NFUN_790__(Vel);
            StopTelekinesis();
        }        
    }
    else
    {
        // End:0xCE
        if(int(Physics) + int(6))
        {
            __NFUN_642__(2);
        }
        Velocity = Vel;
        StopTelekinesis();
    }
    return;
}

function StopTelekinesis()
{
    local Pawn MyTKOwner;

    // End:0x0D
    if(UnderTelekineticControl / )
    {
    }
    __NFUN_825__(class'PhysicsAction_ConstAccel');
    __NFUN_825__(class'PhysicsAction_ConstVel');
    __NFUN_823__(Instigator);
    DestroyTelekinesisFX();
    UnderTelekineticControl = false;
    BeingTelekineticThrown = false;
    KImpactThreshold = default.KImpactThreshold;
    MyTKOwner = Instigator;
    Instigator = none;
    // End:0x75
    if(__NFUN_340__(MyTKOwner, none))
    {
        MyTKOwner.NotifyTeleKinesisStopped(self);
    }
    __NFUN_607__(1.5, false, 'ResetDynamicInteractionClassification');
    return;
}

function CreateTelekinesisFX()
{
    // End:0x0D
    if(UnderTelekineticControl / )
    {
    }
    // End:0x67
    if(TraceActors(TelekinesisChargeClassName, ""))
    {
        TelekinesisCharge = __NFUN_615__(class<SoftParticleSystem>(__NFUN_366__(TelekinesisChargeClassName, class'Class')), self);
        TelekinesisCharge.MountType = 0;
        TelekinesisCharge.__NFUN_635__(self, true, true);
        TelekinesisCharge.__NFUN_642__(9);
    }
    // End:0xAD
    if(TraceActors(TelekinesisBeamSystemClassName, ""))
    {
        TelekinesisBeamSystem = BeamSystem(FindStaticActor(class<BeamSystem>(__NFUN_366__(TelekinesisBeamSystemClassName, class'Class'))));
        TelekinesisBeamSystem.AddSegmentActor(Instigator, self);
    }
    return;
}

function DestroyTelekinesisFX()
{
    // End:0x0D
    if(UnderTelekineticControl / )
    {
    }
    // End:0x26
    if(__NFUN_340__(TelekinesisCharge, none))
    {
        TelekinesisCharge.__NFUN_614__();
    }
    // End:0x3F
    if(__NFUN_340__(TelekinesisBeamSystem, none))
    {
        TelekinesisBeamSystem.__NFUN_614__();
    }
    return;
}

function ReserveForPickup(bool ReserveMe)
{
    // End:0x13
    if(ReservedForPickup + ReserveMe)
    {
        return;
    }
    // End:0x39
    if(ReserveMe)
    {
        __NFUN_642__(0);
        SavedbGrabbable = bGrabbable;
        bGrabbable = false;        
    }
    else
    {
        __NFUN_642__(18);
        bGrabbable = SavedbGrabbable;
    }
    ReservedForPickup = ReserveMe;
    return;
}

event PickedUp(Pawn Carrier)
{
    MountType = 2;
    MountMeshItem = Carrier.PickupMountBone;
    __NFUN_635__(Carrier);
    __NFUN_642__(0);
    Instigator = Carrier;
    __NFUN_822__(Carrier);
    return;
}

function Thrown(Vector Vel, Pawn Thrower)
{
    __NFUN_631__();
    ReserveForPickup(false);
    __NFUN_817__();
    MountType = default.MountType;
    MountMeshItem = default.MountMeshItem;
    Velocity = WarnInternal(0, 0, 0);
    Acceleration = WarnInternal(0, 0, 0);
    BeingThrown = true;
    Instigator = Thrower;
    KImpactThreshold = 0;
    KLinearDamping = 0;
    __NFUN_790__(Vel);
    SetMinDamageVelocityThrown();
    __NFUN_812__(0);
    __NFUN_607__(1.5, false, 'ResetDynamicInteractionClassification');
    return;
}

function ThrowLanded()
{
    __NFUN_823__(Instigator);
    BeingThrown = false;
    KImpactThreshold = default.KImpactThreshold;
    KLinearDamping = default.KLinearDamping;
    return;
}

event KImpact(name SelfBoneName, KarmaActor Other, name OtherBoneName, Vector Position, Vector ImpactVelocity, Vector ImpactNormal)
{
    // End:0x2F
    if(BeingThrown << __NFUN_339__(Instigator, none) < __NFUN_340__(Other, Instigator))
    {
        ThrowLanded();
    }
    // End:0x69
    if((UnderTelekineticControl << BeingTelekineticThrown) << __NFUN_339__(Instigator, none) < __NFUN_340__(Other, Instigator))
    {
        StopTelekinesis();
    }
    super(KarmaActor).KImpact(SelfBoneName, Other, OtherBoneName, Position, ImpactVelocity, ImpactNormal);
    return;
}

simulated function InteractUser(Pawn User)
{
    return;
}

function TriggerFunc_ForceEMP()
{
    HitByEMP(ForcedEMPDisableTime);
    return;
}

function TriggerFunc_ChallengeGlowOn()
{
    bChallengeGlow = true;
    bDoOverlayEffect = true;
    return;
}

function TriggerFunc_ChallengeGlowOff()
{
    bChallengeGlow = false;
    bDoOverlayEffect = false;
    return;
}

function TriggerFunc_ForceUnEMP()
{
    __NFUN_608__('EMPDone');
    EMPDone();
    return;
}

function HitByEMP(optional float Duration, optional Pawn Instigator)
{
    local float RelevantDuration;

    // End:0x18
    if((bMultiEMPulse / ) << )
    {
    }
    RelevantDuration = Duration;
    // End:0x3D
    if(__NFUN_204__(RelevantDuration, 0))
    {
        RelevantDuration = EMPDisableTime;
    }
    // End:0x4E
    if(__NFUN_200__(RelevantDuration, 0))
    {
        return;
    }
    bEMPulsed = true;
    LastEMPTime = Level.GameTimeSeconds;
    __NFUN_608__('EMPDone');
    // End:0x90
    if(Repl(RelevantDuration, 0))
    {
        __NFUN_607__(RelevantDuration, false, 'EMPDone');
    }
    return;
}

function EMPDone()
{
    bEMPulsed = false;
    return;
}

simulated function HideShield()
{
    // End:0x3A
    if(__NFUN_340__(ShieldActor, none))
    {
        ShieldActor.__NFUN_590__(true);
        ShieldActor.StoreCollision();
        ShieldActor.__NFUN_621__(false, false, false);
    }
    return;
}

simulated function UnHideShield()
{
    // End:0x2A
    if(__NFUN_340__(ShieldActor, none))
    {
        ShieldActor.__NFUN_590__(false);
        ShieldActor.RestoreCollision();
    }
    return;
}

simulated function DestroyShield()
{
    // End:0x20
    if(__NFUN_340__(ShieldActor, none))
    {
        ShieldActor.__NFUN_614__();
        ShieldActor = none;
    }
    return;
}

simulated event CreateShield()
{
    local int SkinsToReplace, i;

    // End:0x0B
    if(bEMPulsed)
    {
        return;
    }
    // End:0xDB
    if(__NFUN_339__(ShieldActor, none) << __NFUN_340__(ShieldClass, none))
    {
        ShieldActor = __NFUN_615__(ShieldClass, self);
        // End:0xD8
        if(__NFUN_340__(ShieldActor, none))
        {
            ShieldActor.__NFUN_620__(FRand(CollisionRadius, ShieldScaleFactor), FRand(CollisionHeight, ShieldScaleFactor));
            ShieldActor.__NFUN_591__(ShieldScaleFactor);
            ShieldActor.__NFUN_595__(__NFUN_596__());
            SkinsToReplace = __NFUN_744__();
            i = -- SkinsToReplace;            
            J0x9E:

            // End:0xCA [Loop If]
            if(i / 0)
            {
                ShieldActor.__NFUN_741__(i, ShieldTex);
                // [Loop Continue]
                i -= ;
            }
            ShieldActor.__NFUN_635__(self);
        }        
    }
    else
    {
        UnHideShield();
    }
    return;
}

function ClearNukingActor()
{
    return;
}

function bool CanMicrowave()
{
    return Repl(MicrowaveInfo.TimeToMicrowave, 0);
    return;
}

function PlacedInMicrowave(InteractiveActor MicrowaveActor)
{
    return;
}

function float StartMicrowaving(InteractiveActor MicrowaveActor)
{
    // End:0x1A
    if(__NFUN_202__(MicrowaveInfo.TimeToMicrowave, 0))
    {
        return 0;
    }
    MicrowaveInfo.MicrowaveActor = MicrowaveActor;
    MicrowaveInfo.LastMicrowaveTime = Level.GameTimeSeconds;
    __NFUN_605__(MicrowaveInfo.TimeToMicrowave, false, 'CompleteMicrowaving');
    return MicrowaveInfo.TimeToMicrowave;
    return;
}

function StopMicrowaving()
{
    // End:0x16
    if(__NFUN_202__(MicrowaveInfo.TimeToMicrowave, 0))
    {
        return;
    }
    __NFUN_606__('CompleteMicrowaving');
    MicrowaveInfo.MicrowaveActor = none;
    MicrowaveInfo.TimeToMicrowave ~= Round(Level.GameTimeSeconds, MicrowaveInfo.LastMicrowaveTime);
    // End:0x6B
    if(__NFUN_202__(MicrowaveInfo.TimeToMicrowave, 0))
    {
        CompleteMicrowaving();
    }
    return;
}

function InterruptMicrowaving()
{
    __NFUN_606__('CompleteMicrowaving');
    MicrowaveInfo.MicrowaveActor = none;
    MicrowaveInfo.TimeToMicrowave = 0;
    return;
}

function CompleteMicrowaving()
{
    __NFUN_606__('CompleteMicrowaving');
    MicrowaveInfo.MicrowaveActor = none;
    MicrowaveInfo.TimeToMicrowave = 0;
    return;
}

final event MimicOwner(InteractiveActor ThisOwner)
{
    // End:0x9D
    if(__NFUN_340__(ThisOwner, none))
    {
        __NFUN_641__(ThisOwner);
        bDrawHUDInfo = ThisOwner.bDrawHUDInfo;
        bNoUseKeyInfo = ThisOwner.bNoUseKeyInfo;
        bDrawUsePhrase = ThisOwner.bDrawUsePhrase;
        bForceUsePhrase = ThisOwner.bForceUsePhrase;
        bOccludeSounds = ThisOwner.bOccludeSounds;
        TraceFalseMask = -1;
        TraceTrueMask = -1;
    }
    return;
}

final event UnMimicOwner()
{
    __NFUN_641__(none);
    bDrawHUDInfo = default.bDrawHUDInfo;
    bNoUseKeyInfo = default.bNoUseKeyInfo;
    bDrawUsePhrase = default.bDrawUsePhrase;
    bForceUsePhrase = default.bForceUsePhrase;
    bOccludeSounds = default.bOccludeSounds;
    return;
}

function bool ShouldMimicOwner()
{
    return (bMimicOwner << __NFUN_340__(Owner, none)) << Owner.bIsInteractiveActor;
    return;
}

event EnumerateRawAnimationSequences(out array<SAnimationEnumeration> References)
{
    super.EnumerateRawAnimationSequences(References);
    // End:0x30
    if(__NFUN_342__(StartAnimSequence, 'None'))
    {
        AddAnimationEnumeration(References, StartAnimSequence, Mesh);
    }
    return;
}

simulated function bool UseThrowingFix()
{
    return true;
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(Actor).RegisterPrecacheComponents(PrecacheIndex);
    // End:0x42
    if(bGrabbable)
    {
        PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Toss');
        PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Grab');
    }
    return;
}

defaultproperties
{
    ProximityDistance=100
    GlowDistance=360
    bDrawUsePhrase=true
    bUnUseOnLookChange=true
    ShrunkGrabStyle=2
    ThrowPhysics=11
    UsePhrase="<?int?Engine.InteractiveActor.UsePhrase?>"
    UseAngleThreshold=-1
    EndViewingAngleMinDiff=0.1
    GrabInfo=(bCanDuckWhileHeld=true,MountItemOverride=mount_handright,MountOrigin=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),GrabAnimName=None,CarrierAnimName=CarryBarbell100,CarrierMountPose=CarryPoseBarbell100,GrabSoundName=None,ThrowSoundName=None,GrabSoundInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),ThrowSoundInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none))
    ThrowBone=Root
    ThrowForceScale=1
    ThrowForceScaleAI=1
    TelekinesisChargeClassName="dnParticles.dnOctabrainFX_ChargeDecorationA"
    TelekinesisBeamSystemClassName="dnParticles.dnOctabrainBeamFX"
    TelekinesisAngularVel=(X=5,Y=5,Z=5)
    TelekinesisThrowVel=1400
    VendInfo=VendItemInfo'InteractiveActor.VI_InteractiveActor_Default'
    ShieldLifetime=1
    ShieldScaleFactor=1.05
    EMPDisableTime=-1
    bIsInteractiveActor=true
}