/*******************************************************************************
 * KeyframeDispatch generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class KeyframeDispatch extends InfoActor
    collapsecategories
    notplaceable
    hidecategories(Collision,Filter,Interactivity,Karma,Lighting,Tick,TickRules,Sound,HeatVision,Material);

var(KeyframeOLD) noexport bool bUseOldKeyframe "If this is true, then the dispatcher will use the old style settings.";
var(KeyframeOLD) noexport bool GlideByTime "OBSOLETE: Stop using this asstasticness!";
var(KeyframeOLD) noexport Rotator RotateTo "OBSOLETE: Stop using this asstasticness!";
var(KeyframeOLD) noexport Vector MoveTo "OBSOLETE: Stop using this asstasticness!";
var(KeyframeOLD) noexport float seconds "OBSOLETE: Stop using this asstasticness!";
var(KeyframeSound) noexport Sound StartSound "Sound to play when movement starts.";
var(KeyframeSound) noexport Sound StopSound "Sound to play when movement stops.";
var(KeyframeSound) noexport Sound MoveAmbientSound "Ambient sound to play while moving.";
var(KeyframeSoundEx) noexport name StartSoundName "VoicePack entry to play when movement starts.  Uses VoicePack of the object that is moving.";
var(KeyframeSoundEx) noexport name StopSoundName "VoicePack entry to play when movement stops.  Uses VoicePack of the object that is moving.";
var(KeyframeSoundEx) noexport name MoveAmbientSoundName "VoicePack entry to play as ambient while moving..  Uses VoicePack of the object that is moving.";
var(KeyframeLocation) noexport bool bUseTargetLocation "Set this to true if you want to use the Location Keyframe information.";
var(KeyframeLocation) noexport SDesiredLocation TargetLocation "Information used to specify how to move to the TargetLocation.";
var(KeyframeLocationRules) noexport bool UseMyPositionMounted "When true, the UseMyPosition flag will cause the KeyframeDispatch to use the MountOrigin of itself instead of the Location if it has a MountParent.";
var(KeyframeLocationRules) noexport bool UseMyPosition "If this is true, then use the location of this dispatcher as the target location.";
var(KeyframeLocationRules) noexport bool RelativeMotion "Make all motion relative to the current location of the target actor.";
var(KeyframeLocationRules) noexport bool MotionRelativeToRotation "Do all motion with regards to the direction the actor is facing.";
var(KeyframeLocationRules) noexport Vector MinimumMotion "Clamp the motion to above this. When the target actor is mounted, this clamps the MountOrigin instead of literal location.";
var(KeyframeLocationRules) noexport Vector MaximumMotion "Clamp the motion to below this. When the target actor is mounted, this clamps the MountOrigin instead of literal location.";
var(KeyframeLocationRules) noexport deprecated Actor MinimumMotionActor "Use this actor's location to determine the value for MinimumMotion. When the target actor is mounted, it uses the distance between them instead of the location of the actor.";
var(KeyframeLocationRules) noexport deprecated Actor MaximumMotionActor "Use this actor's location to determine the value for MaximumMotion. When the target actor is mounted, it uses the distance between them instead of the location of the actor.";
var(KeyframeRotation) noexport bool bUseTargetRotation "Set this to true if you want to use the Rotation Keyframe information.";
var(KeyframeRotation) noexport SDesiredRotationAll TargetRotation "Information used to specify how to rotate to the TargetRotation.";
var(KeyframeRotationEx) noexport bool bUseTargetRotationPitch "Set this to true if you want to use the Axis specific Pitch TargetRotation.";
var(KeyframeRotationEx) noexport bool bUseTargetRotationYaw "Set this to true if you want to use the Axis specific Pitch TargetRotation.";
var(KeyframeRotationEx) noexport bool bUseTargetRotationRoll "Set this to true if you want to use the Axis specific Pitch TargetRotation.";
var(KeyframeRotationEx) noexport SDesiredRotationAxis TargetRotationPitch "Information used to specifiy how to rate to the TargetRotation on the Pitch axis.";
var(KeyframeRotationEx) noexport SDesiredRotationAxis TargetRotationYaw "Information used to specifiy how to rate to the TargetRotation on the Pitch axis.";
var(KeyframeRotationEx) noexport SDesiredRotationAxis TargetRotationRoll "Information used to specifiy how to rate to the TargetRotation on the Pitch axis.";
var(KeyframeRotationRules) noexport bool UseMyRotationMounted "When true, the UseMyRotation flag will cause the KeyframeDispatch to use the MountAngles of itself instead of the Rotation if it has a MountParent.";
var(KeyframeRotationRules) noexport bool UseMyRotation "If this is true, then use the rotation of this dispatcher as the target rotation.";
var(KeyframeRotationRules) noexport bool RelativeRotation "Make all rotation relative to the current rotation of the target actor.";
var(KeyframeRotationRules) noexport bool ShortestDistance "Move the shortest distance to the target.";
var(KeyframeRotationRules) noexport Rotator MinimumRotation "Clamp the rotation to above this. When the target actor is mounted, this clamps the MountAngle instead of literal rotation.";
var(KeyframeRotationRules) noexport Rotator MaximumRotation "Clamp the rotation to below this. When the target actor is mounted, this clamps the MountAngle instead of literal rotation.";
var(KeyframeRotationRules) noexport deprecated Actor MinimumRotationActor "Use this actor's rotation to determine the value for MinimumRotation. This always uses the literal value of the actor's rotation, whether the target actor is mounted or not.";
var(KeyframeRotationRules) noexport deprecated Actor MaximumRotationActor "Use this actor's rotation to determine the value for MaximumRotation. This always uses the literal value of the actor's rotation, whether the target actor is mounted or not.";
var(KeyframeRotationRate) noexport bool bSetRotationRate "Set this to true if you want to set the RotationRate on the target actor.";
var(KeyframeRotationRate) noexport Rotator NewRotationRate "The new value that will be set in FixedRotationRate.";
var(KeyframeRotationRate) noexport float NewRotationRateTimer "How long it takes to switch from the current RotationRate of the actor to the newly specified one.";

event Trigger(Actor Other, Pawn EventInstigator)
{
    super(Actor).Trigger(Other, EventInstigator);
    StartKeyframe();
    return;
}

final function StartKeyframe()
{
    // End:0xCD
    if(__NFUN_342__(Event, 'None'))
    {
        // End:0xC9
        foreach __NFUN_747__(class'Actor', Target, Event)
        {
            SetKeyframeSounds(Target);
            // End:0x50
            if(bSetRotationRate)
            {
                Target.__NFUN_653__(NewRotationRate, NewRotationRateTimer);
            }
            // End:0x64
            if(bUseOldKeyframe)
            {
                SetActorKeyframeOLD(Target);
            }
            // End:0x78
            if(bUseTargetLocation)
            {
                SetActorKeyframe_Location(Target);
            }
            // End:0x8C
            if(bUseTargetRotation)
            {
                SetActorKeyframe_Rotation(Target);
            }
            // End:0xA0
            if(bUseTargetRotationYaw)
            {
                SetActorKeyframe_Rotation_Yaw(Target);
            }
            // End:0xB4
            if(bUseTargetRotationPitch)
            {
                SetActorKeyframe_Rotation_Pitch(Target);
            }
            // End:0xC8
            if(bUseTargetRotationRoll)
            {
                SetActorKeyframe_Rotation_Roll(Target);
            }            
        }                
    }
    else
    {
        BroadcastLog(__NFUN_302__(__NFUN_302__("Warning: ", string(self)), " doesn't have anything to dispatch a Keyframe to (Event is empty)."));
    }
    return;
}

final function SetActorKeyframeOLD(Actor Target)
{
    // End:0x55
    if(GlideByTime)
    {
        Target.__NFUN_649__(GetKeyframeLocation(Target, MoveTo),, 1, seconds);
        Target.__NFUN_663__(GetKeyframeRotation(Target, RotateTo), 1, seconds);        
    }
    else
    {
        Target.__NFUN_649__(GetKeyframeLocation(Target, MoveTo),, 0, seconds);
        Target.__NFUN_663__(GetKeyframeRotation(Target, RotateTo), 0, seconds);
    }
    return;
}

final function SetActorKeyframe_Location(Actor Target)
{
    local SDesiredLocation ScratchDL;

    ScratchDL = TargetLocation;
    ScratchDL.Target = GetKeyframeLocation(Target, TargetLocation.Target, TargetLocation.TargetVariance);
    ScratchDL.TargetVariance = WarnInternal(0, 0, 0);
    Target.__NFUN_650__(ScratchDL);
    return;
}

final function SetActorKeyframe_Rotation(Actor Target)
{
    Target.__NFUN_663__(GetKeyframeRotation(Target, TargetRotation.Target), TargetRotation.Style, TargetRotation.TimeTotal, TargetRotation.TimeMid, TargetRotation.Exponent, TargetRotation.Rate,, TargetRotation.Event, TargetRotation.FunctionComplete, ShortestDistance, TargetRotation.EventAbort, TargetRotation.FunctionAbort, TargetRotation.CrushDamage, TargetRotation.StyleStopped);
    return;
}

final function SetActorKeyframe_Rotation_Yaw(Actor Target)
{
    Target.__NFUN_666__(GetKeyframeRotation(Target, __NFUN_265__(0, TargetRotationYaw.Target, 0)).Yaw, TargetRotationYaw.Style, TargetRotationYaw.TimeTotal, TargetRotationYaw.TimeMid, TargetRotationYaw.Exponent, TargetRotationYaw.Rate,, TargetRotationYaw.Event, TargetRotationYaw.FunctionComplete, ShortestDistance, TargetRotationYaw.EventAbort, TargetRotationYaw.FunctionAbort, TargetRotationYaw.CrushDamage, TargetRotationYaw.StyleStopped);
    return;
}

final function SetActorKeyframe_Rotation_Pitch(Actor Target)
{
    Target.__NFUN_665__(GetKeyframeRotation(Target, __NFUN_265__(TargetRotationPitch.Target, 0, 0)).Pitch, TargetRotationPitch.Style, TargetRotationPitch.TimeTotal, TargetRotationPitch.TimeMid, TargetRotationPitch.Exponent, TargetRotationPitch.Rate,, TargetRotationPitch.Event, TargetRotationPitch.FunctionComplete, ShortestDistance, TargetRotationPitch.EventAbort, TargetRotationPitch.FunctionAbort, TargetRotationPitch.CrushDamage, TargetRotationPitch.StyleStopped);
    return;
}

final function SetActorKeyframe_Rotation_Roll(Actor Target)
{
    Target.__NFUN_667__(GetKeyframeRotation(Target, __NFUN_265__(0, 0, TargetRotationRoll.Target)).Roll, TargetRotationRoll.Style, TargetRotationRoll.TimeTotal, TargetRotationRoll.TimeMid, TargetRotationRoll.Exponent, TargetRotationRoll.Rate,, TargetRotationRoll.Event, TargetRotationRoll.FunctionComplete, ShortestDistance, TargetRotationRoll.EventAbort, TargetRotationRoll.FunctionAbort, TargetRotationRoll.CrushDamage, TargetRotationRoll.StyleStopped);
    return;
}

final function SetKeyframeSounds(Actor Target)
{
    local bool bNewAmbient;

    // End:0x22
    if(__NFUN_340__(StartSound, none))
    {
        Target.__NFUN_697__(3, StartSound, 0);
    }
    // End:0x49
    if(__NFUN_342__(StartSoundName, 'None'))
    {
        Target.FindAndPlaySound(StartSoundName, 3);
    }
    // End:0x6A
    if(__NFUN_340__(StopSound, none))
    {
        Target.DoneMovingSound = StopSound;
    }
    // End:0x8F
    if(__NFUN_342__(StopSoundName, 'None'))
    {
        Target.DoneMovingSoundName = StopSoundName;
    }
    // End:0xB5
    if(__NFUN_340__(MoveAmbientSound, none))
    {
        bNewAmbient = true;
        Target.__NFUN_701__(MoveAmbientSound);
    }
    // End:0xE2
    if(__NFUN_342__(MoveAmbientSoundName, 'None'))
    {
        bNewAmbient = true;
        Target.FindAndPlaySound(MoveAmbientSoundName);
    }
    // End:0x158
    if(bNewAmbient)
    {
        // End:0x132
        if((((bUseOldKeyframe < bUseTargetRotation) < bUseTargetRotationYaw) < bUseTargetRotationPitch) < bUseTargetRotationRoll)
        {
            Target.bStopAmbientOnEndRotation = true;
        }
        // End:0x158
        if(bUseOldKeyframe < bUseTargetLocation)
        {
            Target.bStopAmbientOnEndLocation = true;
        }
    }
    return;
}

final function Rotator GetKeyframeRotation(Actor Target, Rotator KeyframeRotation)
{
    local Rotator Result;

    // End:0x3C
    if(UseMyRotation)
    {
        // End:0x2E
        if(UseMyRotationMounted << __NFUN_340__(MountParent, none))
        {
            Result = MountAngles;            
        }
        else
        {
            Result = Rotation;
        }        
    }
    else
    {
        Result = KeyframeRotation;
    }
    // End:0xAE
    if(RelativeRotation)
    {
        // End:0x97
        if(__NFUN_340__(Target.MountParent, none) << Target.IndependentRotation / )
        {            
        }
        else
        {
            Trace(Result, Target.Rotation);
        }
    }
    return ClipRotation(Target, Result);
    return;
}

final function Vector GetKeyframeLocation(Actor Target, Vector KeyframeLocation, optional Vector KeyframeLocationVariance)
{
    local Vector Result;

    // End:0x3C
    if(UseMyPosition)
    {
        // End:0x2E
        if(UseMyPositionMounted << __NFUN_340__(MountParent, none))
        {
            Result = MountOrigin;            
        }
        else
        {
            Result = Location;
        }        
    }
    else
    {
        Result = KeyframeLocation;
    }
    Result = Sleep(Result, KeyframeLocationVariance);
    // End:0x7B
    if(MotionRelativeToRotation)
    {
        Result = __NFUN_241__(Result, GetStartRotation(Target));
    }
    // End:0x96
    if(RelativeMotion)
    {
        Min(Result, GetStartLocation(Target));
    }
    return ClipMotion(Target, Result);
    return;
}

final function Vector GetStartLocation(Actor Target)
{
    // End:0x40
    if(__NFUN_340__(Target.MountParent, none) << Target.IndependentLocation / )
    {        
    }
    else
    {
        return Target.Location;
    }
    return;
}

final function Rotator GetStartRotation(Actor Target)
{
    // End:0x40
    if(__NFUN_340__(Target.MountParent, none) << Target.IndependentRotation / )
    {        
    }
    else
    {
        return Target.Rotation;
    }
    return;
}

final function float ClipAxisValue(float Value, float Min, float Max)
{
    // End:0x20
    if(__NFUN_204__(Min, float(0)) << __NFUN_204__(Max, float(0)))
    {
        return Value;
    }
    // End:0x8B
    if(Repl(Min, Max))
    {
        // End:0x82
        if(__NFUN_202__(Value, Min) << Value != Max)
        {
            // End:0x79
            if(__NFUN_200__(-Round(Value, Min), -Round(Value, Max)))
            {
                return Min;                
            }
            else
            {
                return Max;
            }            
        }
        else
        {
            return Value;
        }        
    }
    else
    {
        return Normal2D(Value, Min, Max);
    }
    return;
}

final function int ConstrainToQuatRange(int Value)
{
    // End:0x27
    if(Value ** 32768)
    {
        Value = -- Value - 65535;                
    }
    else
    {
        // End:0x4D
        if(-Value)
        {            
            Value = ++ Value - 65535;            
        }
    }
    return Value;
    return;
}

final function int ClipQuatAxisValue(int Value, int Min, int Max)
{
    Min = ConstrainToQuatRange(Min);
    Max = ConstrainToQuatRange(Max);
    return int(ClipAxisValue(float(Value), float(Min), float(Max)));
    return;
}

final function Rotator ClipRotation(Actor Target, Rotator R)
{
    local Rotator Min, Max, Result;

    // End:0x24
    if(__NFUN_340__(MinimumRotationActor, none))
    {
        Min = MinimumRotationActor.Rotation;        
    }
    else
    {
        Min = MinimumRotation;
    }
    // End:0x53
    if(__NFUN_340__(MaximumRotationActor, none))
    {
        Max = MaximumRotationActor.Rotation;        
    }
    else
    {
        Max = MaximumRotation;
    }
    Result.Pitch = int(ClipAxisValue(float(R.Pitch), float(Min.Pitch), float(Max.Pitch)));
    Result.Yaw = int(ClipAxisValue(float(R.Yaw), float(Min.Yaw), float(Max.Yaw)));
    Result.Roll = int(ClipAxisValue(float(R.Roll), float(Min.Roll), float(Max.Roll)));
    return Result;
    return;
}

final function Vector ClipMotion(Actor Target, Vector Motion)
{
    local Vector Min, Max, Result;

    // End:0x56
    if(__NFUN_340__(MinimumMotionActor, none))
    {
        Min = MinimumMotionActor.Location;
        // End:0x53
        if(__NFUN_340__(Target.MountParent, none))
        {
            Min = __NFUN_239__(Min, Target.Location);
        }        
    }
    else
    {
        Min = MinimumMotion;
    }
    // End:0xB7
    if(__NFUN_340__(MaximumMotionActor, none))
    {
        Max = MaximumMotionActor.Location;
        // End:0xB4
        if(__NFUN_340__(Target.MountParent, none))
        {
            Max = __NFUN_239__(Max, Target.Location);
        }        
    }
    else
    {
        Max = MaximumMotion;
    }
    Result.X = ClipAxisValue(Motion.X, Min.X, Max.X);
    Result.Y = ClipAxisValue(Motion.Y, Min.Y, Max.Y);
    Result.Z = ClipAxisValue(Motion.Z, Min.Z, Max.Z);
    return Result;
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local Actor Actor;

    PrecacheIndex.__NFUN_1274__(StartSound);
    PrecacheIndex.__NFUN_1274__(StopSound);
    PrecacheIndex.__NFUN_1274__(MoveAmbientSound);
    // End:0x64
    foreach __NFUN_747__(class'Actor', Actor)
    {
        // End:0x63
        if(__NFUN_341__(Actor.Tag, Event))
        {
            // End:0x64
            break;
        }        
    }    
    // End:0xD4
    if(__NFUN_340__(Actor, none))
    {
        PrecacheIndex.__NFUN_1277__(Actor.VoicePack, StartSoundName);
        PrecacheIndex.__NFUN_1277__(Actor.VoicePack, StopSoundName);
        PrecacheIndex.__NFUN_1277__(Actor.VoicePack, MoveAmbientSoundName);
    }
    return;
}

defaultproperties
{
    bHidden=true
    bDirectional=true
    Texture=Texture'S_KeyframeDispatch'
    RemoteRole=0
}