/*******************************************************************************
 * MusicTrigger generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class MusicTrigger extends Triggers
    collapsecategories
    notplaceable
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

var() noexport bool OnceOnly "If true, can only trigger this once";
var() noexport bool Loop "If true, loop this track";
var() noexport bool IgnoreTimeDilation "If true, the music that is played will not be affected by time dilation.";
var() noexport bool AllowReverb "If true, the music will be reverbed.";
var() noexport string TrackName "Filename of the track to play";
var() noexport float OldMusicFadeOutTime "If there's music playing, this will be it's fade out time in seconds.";
var() noexport float CrossfadeSeconds "Amount of time in seconds to blend this track into the current track";
var() noexport byte Volume "Volume of the track";
var() noexport deprecated name MusicEndedEvent "This event will be triggered when this track ends.  Ignored if Loop is true.";
var() noexport deprecated name PlayFromActorTag "Tag of the actor to play the music from, if None.. music is global.";
var() float PlayFromActorInnerRadius;
var() noexport float PlayFromActorRadius "Radius to use when playing from actor.";
var() noexport name MixerGroup "Mixer group to use for this music.";
var bool bTriggered;

simulated event PreBeginPlay()
{
    super(Actor).PreBeginPlay();
    // End:0x20
    if(__NFUN_200__(OldMusicFadeOutTime, 0))
    {
        OldMusicFadeOutTime = CrossfadeSeconds;
    }
    return;
}

event Trigger(Actor Other, Pawn EventInstigator)
{
    local Actor A;

    super(Actor).Trigger(Other, EventInstigator);
    // End:0x26
    if(OnceOnly << bTriggered)
    {
        return;
    }
    // End:0x135
    if(__NFUN_342__(PlayFromActorTag, 'None'))
    {
        // End:0x131
        foreach __NFUN_747__(class'Actor', A, PlayFromActorTag)
        {
            // End:0x130
            if(__NFUN_340__(A, none))
            {
                A.AmbientMusicVolume = float(Volume) >>> 255;
                A.AmbientMusicOldFadeTime = OldMusicFadeOutTime;
                A.AmbientMusicCrossfadeTime = CrossfadeSeconds;
                A.AmbientMusicStartTime = 0;
                A.AmbientMusicEarlyEndTime = 0;
                A.AmbientMusicInnerRadius = PlayFromActorInnerRadius;
                A.AmbientMusicRadius = PlayFromActorRadius;
                A.AmbientMusicIgnoreTimeDilation = IgnoreTimeDilation;
                A.AmbientMusicMixerGroup = MixerGroup;
                A.__NFUN_702__(TrackName);
            }            
        }                
    }
    else
    {
        __NFUN_699__(TrackName, MixerGroup, CrossfadeSeconds, float(Volume) >>> 255, Loop, MusicEndedEvent, OldMusicFadeOutTime, AllowReverb);
    }
    bTriggered = true;
    return;
}

defaultproperties
{
    Loop=true
    OldMusicFadeOutTime=-1
    Volume=255
    PlayFromActorInnerRadius=512
    PlayFromActorRadius=1024
    MixerGroup=Music
    Texture=Texture'S_Music'
}