/*******************************************************************************
 * OnlineAgent generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class OnlineAgent extends OnlineSubsystem
    transient
    native
    config
    dependson(MPMapInfo);

enum EOnlinePermission
{
    OP_Granted,
    OP_Restricted,
    OP_Offline,
    OP_Error
};

struct LeaderBoardData
{
    var int Rank;
    var string PlayerName;
    var int Kills;
    var int Deaths;
    var int Exp;
    var int Wins;
    var int Losses;
    var int TimePlayedInSeconds;
    var int UidLeftmostDWord;
    var int UidRightmostDWord;
};

var array<OnlineAgentListener> OnlineAgentListeners;
var PlayListEntry CurrentPlaylist;
var int CurrentPlaylistMapIndex;
var int CurrentMapId;
var int CurrentGameModeId;
var int CurrentMutatorId;
var string CurrentMapName;
var string CurrentGameModeName;
var string CurrentMutatorName;
var string CustomMatchString;
var config string AdditionalClientTravelOptions;
var config string AdditionalServerTravelOptions;
var array<LeaderBoardData> LeaderboardEntries;
var LeaderBoardData CurrentPlayerLeaderboardData;
var array<SAgentPlayer> LobbyPlayers;
var bool bWaitingForResponse;
var int Quitter;
var int EORCountTime;

// Export UOnlineAgent::execRegisterListener(FFrame&, void* const)
native(419) function RegisterListener(OnlineAgentListener in_Listener);

// Export UOnlineAgent::execUnregisterListener(FFrame&, void* const)
native(420) function UnregisterListener(OnlineAgentListener in_Listener);

event Init()
{
    RegisterListener(new (self) class'OnlineAgent_DebugListener');
    RegisterListener(new (self) class'SteamDedicatedListener');
    RegisterListener(new (self) class'OnlineAgentQualityControl');
    return;
}

function NotifyGameEnded()
{
    // End:0x0D
    if((IsInGame()) / )
    {
    }
    // End:0x40
    CurrentPlaylistMapIndex += ;
    {
        CurrentPlaylistMapIndex = 0;
    }
    EndRound();
    // End:0x61
    if(CurrentPlaylistMapIndex / string(CurrentPlaylist.Entry))
    {
        EndGame();
    }
    return;
}

function NotifyGameStarted()
{
    StartRound();
    return;
}

function GetLobbyPlayers(out array<SAgentPlayer> out_players)
{
    out_players = LobbyPlayers;
    return;
}

// Export UOnlineAgent::execQuickMatch(FFrame&, void* const)
native(421) function QuickMatch(SAgentSearchGameOptions in_Options);

// Export UOnlineAgent::execCreateGame(FFrame&, void* const)
native(422) function CreateGame(SAgentCreateGameOptions in_Options);

// Export UOnlineAgent::execSearchGames(FFrame&, void* const)
native(423) function SearchGames(SAgentSearchGameOptions in_Options);

// Export UOnlineAgent::execGetSearchGameCount(FFrame&, void* const)
native(424) function int GetSearchGameCount();

// Export UOnlineAgent::execGetSearchGame(FFrame&, void* const)
native(425) function bool GetSearchGame(out SAgentSearchGameResult out_Game, int in_Index);

// Export UOnlineAgent::execOnPostLogin(FFrame&, void* const)
native(426) function OnPostLogin(PlayerPawn NewPlayer);

// Export UOnlineAgent::execOnPostBeginPlay(FFrame&, void* const)
native(427) function OnPostBeginPlay(PlayerPawn NewPlayer);

// Export UOnlineAgent::execJoinGame(FFrame&, void* const)
native(428) function JoinGame(int in_Index);

// Export UOnlineAgent::execLeaveGame(FFrame&, void* const)
native(429) function LeaveGame();

// Export UOnlineAgent::execStartGame(FFrame&, void* const)
native(430) function StartGame();

// Export UOnlineAgent::execStartRound(FFrame&, void* const)
native(431) function StartRound();

// Export UOnlineAgent::execEndGame(FFrame&, void* const)
native(432) function EndGame();

// Export UOnlineAgent::execEndRound(FFrame&, void* const)
native(433) function EndRound();

// Export UOnlineAgent::execReadyUp(FFrame&, void* const)
native(434) function ReadyUp(bool in_Ready);

// Export UOnlineAgent::execSaveLevel(FFrame&, void* const)
native(435) function SaveLevel(int in_level);

// Export UOnlineAgent::execGetLevel(FFrame&, void* const)
native(436) function GetLevel(int in_PlayerRef, out int out_level);

// Export UOnlineAgent::execKickPlayer(FFrame&, void* const)
native(437) function KickPlayer(int in_PlayerRef, bool bBan);

// Export UOnlineAgent::execRequestChangeTeam(FFrame&, void* const)
native(438) function RequestChangeTeam();

// Export UOnlineAgent::execMutePlayer(FFrame&, void* const)
native(439) function MutePlayer(int in_PlayerRef, bool in_Mute);

// Export UOnlineAgent::execIsPlayerMuted(FFrame&, void* const)
native(440) function bool IsPlayerMuted(int in_PlayerRef);

// Export UOnlineAgent::execGetPlayerVoIPState(FFrame&, void* const)
native(441) function Object.EVoIP_State GetPlayerVoIPState(int in_PlayerRef);

// Export UOnlineAgent::execGetAgentPlayerAccountId(FFrame&, void* const)
native(442) function GetAgentPlayerAccountId(out SAgentAccountId out_AccountId, int in_PlayerRef);

// Export UOnlineAgent::execGetAgentPlayers(FFrame&, void* const)
native(443) function GetAgentPlayers(out array<SAgentPlayer> out_players);

// Export UOnlineAgent::execGetLocalAgentPlayer(FFrame&, void* const)
native(444) function GetLocalAgentPlayer(out SAgentPlayer out_Player);

// Export UOnlineAgent::execGetHostPingFor(FFrame&, void* const)
native(445) function int GetHostPingFor(int in_PlayerRef);

// Export UOnlineAgent::execGetGameMaxPlayers(FFrame&, void* const)
native(446) function int GetGameMaxPlayers();

// Export UOnlineAgent::execShowSystemInviteUI(FFrame&, void* const)
native(447) function ShowSystemInviteUI();

// Export UOnlineAgent::execIsInParty(FFrame&, void* const)
native(448) function bool IsInParty();

// Export UOnlineAgent::execDisconnectUnreal(FFrame&, void* const)
native(449) function DisconnectUnreal();

// Export UOnlineAgent::execLoadNextMap(FFrame&, void* const)
native(450) function LoadNextMap();

// Export UOnlineAgent::execIsInGame(FFrame&, void* const)
native(451) function bool IsInGame();

// Export UOnlineAgent::execIsHost(FFrame&, void* const)
native(452) function bool IsHost();

// Export UOnlineAgent::execSendChatMessage(FFrame&, void* const)
native(453) function bool SendChatMessage(string MsgStr);

// Export UOnlineAgent::execPlaylistHasNextMap(FFrame&, void* const)
native(454) function bool PlaylistHasNextMap();

// Export UOnlineAgent::execGetTravelURL(FFrame&, void* const)
native(455) event string GetTravelURL(optional string in_NextMapName, optional string in_NextGameModeName);

// Export UOnlineAgent::execShouldShowCountdownTimer(FFrame&, void* const)
native(456) function bool ShouldShowCountdownTimer();

// Export UOnlineAgent::execGetCountdownTime(FFrame&, void* const)
native(457) function float GetCountdownTime();

// Export UOnlineAgent::execShowGamerCard(FFrame&, void* const)
native(458) function ShowGamerCard(int in_PlayerRef);

// Export UOnlineAgent::execShowGamercardByName(FFrame&, void* const)
native(459) function ShowGamercardByName(string in_PlayerName);

// Export UOnlineAgent::execShowGamercardFromUid(FFrame&, void* const)
native(460) function ShowGamercardFromUid(int in_LeftmostDWord, int in_RightmostDWord);

// Export UOnlineAgent::execShowGamercardFromAccountID(FFrame&, void* const)
native(461) function ShowGamercardFromAccountID(SAgentAccountId accountID);

// Export UOnlineAgent::execTranslateShutdownReason(FFrame&, void* const)
native(462) function Object.EConsole_Dialog TranslateShutdownReason(int in_ShutdownReason);

// Export UOnlineAgent::execTranslateJoinFailReason(FFrame&, void* const)
native(463) function Object.EConsole_Dialog TranslateJoinFailReason(int in_JoinFaileReason);

// Export UOnlineAgent::execShowVirtualKeyboard(FFrame&, void* const)
native(464) function bool ShowVirtualKeyboard(bool in_bUseSerialKeyEntryAlphabet, string in_DefaultText, string in_TitleText, string in_DescriptionText, int in_MaxLength);

// Export UOnlineAgent::execGetPlayerProfileTexture(FFrame&, void* const)
native(465) function bool GetPlayerProfileTexture(out Texture profiletex);

// Export UOnlineAgent::execShowStore(FFrame&, void* const)
native(466) function ShowStore();

// Export UOnlineAgent::execGetDefaultPlayerName(FFrame&, void* const)
native(467) function string GetDefaultPlayerName();

// Export UOnlineAgent::execHasInvite(FFrame&, void* const)
native(468) function bool HasInvite();

// Export UOnlineAgent::execCheckInvites(FFrame&, void* const)
native(469) function CheckInvites();

// Export UOnlineAgent::execJoinLobby(FFrame&, void* const)
native(470) function JoinLobby();

// Export UOnlineAgent::execIsLoggedIn(FFrame&, void* const)
native(471) function bool IsLoggedIn();

// Export UOnlineAgent::execLogin(FFrame&, void* const)
native(472) function Login();

// Export UOnlineAgent::execIsSignedIn(FFrame&, void* const)
native(473) function bool IsSignedIn();

// Export UOnlineAgent::execHasOnlinePermission(FFrame&, void* const)
native(474) function bool HasOnlinePermission();

// Export UOnlineAgent::execGetOnlinePermission(FFrame&, void* const)
native(475) function OnlineAgent.EOnlinePermission GetOnlinePermission();

// Export UOnlineAgent::execGetChatPermission(FFrame&, void* const)
native(476) function OnlineAgent.EOnlinePermission GetChatPermission();

// Export UOnlineAgent::execIsInMainMenu(FFrame&, void* const)
native(477) function bool IsInMainMenu();

// Export UOnlineAgent::execShowPartyUI(FFrame&, void* const)
native(478) function ShowPartyUI();

// Export UOnlineAgent::execRefreshLeaderboard(FFrame&, void* const)
native(479) function RefreshLeaderboard(Object.ELeadboardSortType SortType, int in_Stats_View);

// Export UOnlineAgent::execSubmitScoreToLeaderboard(FFrame&, void* const)
native(480) function SubmitScoreToLeaderboard(int Score, int Kills, int Death, int Wins, int Losses, int TimePlayed, bool IsEndOfMatch);

// Export UOnlineAgent::execGetLocalizedGameTypeForId(FFrame&, void* const)
native(481) function string GetLocalizedGameTypeForId(int in_id);

// Export UOnlineAgent::execAddVoIPPlayer(FFrame&, void* const)
native(482) function AddVoIPPlayer(int in_RoomMemberId, int in_Team);

// Export UOnlineAgent::execSetTeamGame(FFrame&, void* const)
native(483) function SetTeamGame(bool in_TeamGame);

// Export UOnlineAgent::execIsVoipTeamOnly(FFrame&, void* const)
native(484) function bool IsVoipTeamOnly();

// Export UOnlineAgent::execSetReliableVoIP(FFrame&, void* const)
native(485) function SetReliableVoIP(bool in_Reliable);

// Export UOnlineAgent::execStartVoIPRecording(FFrame&, void* const)
native(486) function StartVoIPRecording();

// Export UOnlineAgent::execStopVoIPRecording(FFrame&, void* const)
native(487) function StopVoIPRecording();

// Export UOnlineAgent::execIsWaitingForResponse(FFrame&, void* const)
native(488) function bool IsWaitingForResponse();

// Export UOnlineAgent::execStartWaitingForResponse(FFrame&, void* const)
native(489) function StartWaitingForResponse();

// Export UOnlineAgent::execProcessDedicatedServerTravel(FFrame&, void* const)
native(490) event ProcessDedicatedServerTravel(string URL);

// Export UOnlineAgent::execCancel(FFrame&, void* const)
native(491) function Cancel();

// Export UOnlineAgent::execStopAsyncLeaderboardOperations(FFrame&, void* const)
native(492) function StopAsyncLeaderboardOperations();

// Export UOnlineAgent::execBreakpoint(FFrame&, void* const)
native(493) function Breakpoint();

// Export UOnlineAgent::execIsActive(FFrame&, void* const)
native(494) function bool IsActive();

// Export UOnlineAgent::execIsPrivateMatch(FFrame&, void* const)
native(495) function bool IsPrivateMatch();

// Export UOnlineAgent::execIsDLCCorrupt(FFrame&, void* const)
native(496) function bool IsDLCCorrupt();

// Export UOnlineAgent::execGetCorruptDLCNames(FFrame&, void* const)
native(497) function GetCorruptDLCNames(out array<string> DLCPackageNames);

// Export UOnlineAgent::execHasInstalledNewDlc(FFrame&, void* const)
native(498) function bool HasInstalledNewDlc(int DlcNotifiedMask);

// Export UOnlineAgent::execGetNewDlcNames(FFrame&, void* const)
native(499) function GetNewDlcNames(int DlcNotifiedMask, out array<string> DLCPackageNames);

// Export UOnlineAgent::execGetInstalledDlcMask(FFrame&, void* const)
native(500) function int GetInstalledDlcMask();

// Export UOnlineAgent::execCheckForNewDLC(FFrame&, void* const)
native(501) function bool CheckForNewDLC();

// Export UOnlineAgent::execIsDLCInstalled(FFrame&, void* const)
native(502) function bool IsDLCInstalled(name DLCPackage);

exec function AgentCreateGame(optional int in_PlaylistId, optional bool in_bIsPrivate)
{
    local int i;
    local SAgentCreateGameOptions l_GameOptions;

    i = 0;
    J0x07:

    // End:0x6F [Loop If]
    if(-i)
    {        
        // End:0x65
        if(class'MPMapInfo'.default.Playlist[i].id % in_PlaylistId)
        {
            l_GameOptions.Playlist = class'MPMapInfo'.default.Playlist[i];
        }
        // [Loop Continue]
        i += ;
    }
    l_GameOptions.IsPrivate = in_bIsPrivate;
    CreateGame(l_GameOptions);
    return;
}

simulated event ShutdownErrorMessage(int Reason)
{
    return;
}

exec function AgentQuickMatch(optional int in_Playlist)
{
    local SAgentSearchGameOptions l_Options;

    l_Options.Map = -1;
    l_Options.Mutator = -1;
    l_Options.GameType = -1;
    l_Options.PlayerCount = -1;
    l_Options.Playlist = in_Playlist;
    QuickMatch(l_Options);
    return;
}

exec function AgentJoinGame(int in_Index)
{
    JoinGame(in_Index);
    return;
}

exec function AgentLeaveGame()
{
    LeaveGame();
    return;
}

exec function AgentStartGame()
{
    StartGame();
    return;
}

exec function AgentReadyUp(bool in_Ready)
{
    ReadyUp(in_Ready);
    return;
}

exec function AgentChangeTeam()
{
    RequestChangeTeam();
    return;
}

exec function AgentMutePlayer(int in_PlayerRef, optional bool in_Mute)
{
    MutePlayer(in_PlayerRef, in_Mute);
    return;
}

exec function AgentRefreshLeaderboard(optional Object.ELeadboardSortType SortType)
{
    __NFUN_355__("Refreshing Leaderboard Data");
    RefreshLeaderboard(SortType, 2);
    return;
}

exec function AgentReliableVoIP(bool in_Reliable)
{
    SetReliableVoIP(in_Reliable);
    __NFUN_355__(__NFUN_303__("AgentReliableVoIP uses reliable packet: ", string(in_Reliable)));
    return;
}

defaultproperties
{
    CustomMatchString="Custom_Match"
}