/*******************************************************************************
 * OnlineServerFactory generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class OnlineServerFactory extends Object
    native;

enum EAgentSearchConstraint
{
    ASC_None,
    ASC_Friends,
    ASC_Dedicated
};

enum EAgentBrowserSort
{
    ABS_Name,
    ABS_Ping,
    ABS_Map,
    ABS_GameMode,
    ABS_Players
};

enum EAgentBrowserStatus
{
    AgentBrowserStatus_Idle,
    AgentBrowserStatus_Querying
};

struct SAgentServerInfo
{
    var int id;
    var string GameMode;
    var string Name;
    var string Map;
    var int MaxPlayers;
    var int PlayerCount;
    var int Ping;
    var bool Dedicated;
    var bool Favorite;
    var bool Hidden;
};

struct OnlineServerBrowserInt64
{
    var int Top;
    var int Bottom;
};

var OnlineServerFactory.EAgentSearchConstraint SearchConstraint;
var OnlineServerFactory.EAgentBrowserSort SortState;
var OnlineServerFactory.EAgentBrowserStatus Status;
var array<SAgentServerInfo> Servers;
var OnlineServerFactory Factory;
var bool Dirty;
var int MaxFavourites;
var array<OnlineServerBrowserInt64> Favourites;

// Export UOnlineServerFactory::execStartQuery(FFrame&, void* const)
native(512) function StartQuery(int in_modeFilter, int in_mapFilter);

// Export UOnlineServerFactory::execInterruptQuery(FFrame&, void* const)
native(513) function InterruptQuery();

// Export UOnlineServerFactory::execIsWaitingForResponse(FFrame&, void* const)
native(514) function bool IsWaitingForResponse();

// Export UOnlineServerFactory::execHasNoErrors(FFrame&, void* const)
native(515) function bool HasNoErrors();

// Export UOnlineServerFactory::execLockMutex(FFrame&, void* const)
native(516) function LockMutex();

// Export UOnlineServerFactory::execUnlockMutex(FFrame&, void* const)
native(517) function UnlockMutex();

// Export UOnlineServerFactory::execSortServers(FFrame&, void* const)
native(518) function SortServers();

// Export UOnlineServerFactory::execConnectTo(FFrame&, void* const)
native(519) function ConnectTo(int id);

// Export UOnlineServerFactory::execSetServerFavorite(FFrame&, void* const)
native(520) function SetServerFavorite(int id, bool fav);

// Export UOnlineServerFactory::execSaveFavourites(FFrame&, void* const)
native(521) function SaveFavourites();

// Export UOnlineServerFactory::execLoadFavourites(FFrame&, void* const)
native(522) function LoadFavourites();

function Created()
{
    Dirty = false;
    return;
}

function Exit()
{
    __NFUN_355__("OnlineServerFactory: Interrupting Query and Clearing Servers");
    InterruptQuery();
    LockMutex();
    Servers.Empty();
    UnlockMutex();
    return;
}

function Start(int modeFilter, int mapFilter)
{
    __NFUN_355__(__NFUN_302__(__NFUN_302__("OnlineServerFactory: Starting Query (", string(__NFUN_365__(Enum'EAgentSearchConstraint', int(SearchConstraint)))), ")"));
    StartQuery(modeFilter, mapFilter);
    return;
}

function Restart()
{
    __NFUN_355__("OnlineServerFactory: Restarting");
    Exit();
    Start(-1, -1);
    return;
}

function Resort()
{
    __NFUN_355__(__NFUN_302__(__NFUN_302__("OnlineServerFactory: Sorting Servers(", string(__NFUN_365__(Enum'EAgentBrowserSort', int(SortState)))), ")"));
    SortServers();
    return;
}

defaultproperties
{
    MaxFavourites=20
}