/*******************************************************************************
 * PlayerPawn generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class PlayerPawn extends Pawn
    native
    nativereplication
    config(User)
    collapsecategories
    notplaceable
    dependson(LevelInfo)
    dependson(Player)
    dependson(Console)
    dependson(SavedMove)
    dependson(GameReplicationInfo)
    dependson(HUD)
    dependson(Weapon)
    dependson(GameInfo)
    dependson(PlayerReplicationInfo)
    dependson(PlayerStart)
    dependson(AnimationControllerEx)
    dependson(ControlRemapperEx)
    dependson(ActivatableInventory)
    dependson(Inventory)
    dependson(Canvas)
    dependson(AIFaction)
    dependson(Corpse)
    dependson(PhysicsVolume)
    dependson(ZoneInfo)
    dependson(Decoration)
    dependson(MeshInstance)
    dependson(PrecacheIndex)
    dependson(DamageType)
    dependson(InteractiveActor)
    dependson(LocalMessage)
    dependson(Texture)
    dependson(HUDEffects)
    dependson(Mutator)
    dependson(Engine)
    dependson(OnlineAgent);

const PlayerPawn_LookUseBuffer = 6.5f;
const PlayerPawn_MaxShrunkenCarryMass = 10.0f;
const PlayerPawn_DamageIndicator_FullDamage = 20.0f;
const kNumSensitityLevels = 10;
const kMoveAlphaCutoff = 0.1f;
const kMoveAlphaLerpFactor = 0.3f;
const kMoveBlendCutoff = 0.0001f;

enum ELowerBodyOverrideState
{
    LBO_Standard,
    LBO_Turning,
    LBO_Landing,
    LBO_Melee
};

enum EForwardMovementState
{
    MSF_Unknown,
    MSF_None,
    MSF_ForwardSlow,
    MSF_BackwardSlow,
    MSF_ForwardFast,
    MSF_BackwardFast
};

enum EStrafeMovementState
{
    MSS_Unknown,
    MSS_None,
    MSS_StrafeLeftSlow,
    MSS_StrafeRightSlow,
    MSS_StrafeLeftFast,
    MSS_StrafeRightFast
};

enum EVerticalMovementState
{
    MSV_Unknown,
    MSV_None,
    MSV_RiseSlow,
    MSV_RiseFast,
    MSV_FallSlow,
    MSV_FallFast
};

enum ECameraBobState
{
    CAMBOB_None,
    CAMBOB_Walking,
    CAMBOB_CrouchWalking,
    CAMBOB_Swimming,
    CAMBOB_Sprinting
};

enum ERoundState
{
    RS_Waiting,
    RS_Countdown,
    RS_InProgress,
    RS_EndOfRound,
    RS_Unknown
};

struct SPlayerPawnAnimationControllerExCacheEntry
{
    var() AnimationControllerEx Controller;
    var() Actor.EPostureStateEx PostureState;
};

struct SSoundListener
{
    var noexport Actor Listener "An actor we can hear from";
    var noexport Coords ToListenerLocal "To local transformation for this listner, in D3D coordinate system.";
};

struct SAnalogAxisInfo
{
    var() const noexport float Speed "Base turn speed for axis.";
    var() const noexport float AccelSpeed "Accelerated turn speed for axis.";
    var() const noexport float AccelThreshold "Minimum required stick input for acceleration.";
    var() const noexport float AccelTime "Time it takes to accelerate toward AccelSpeed after AccelWarmup";
    var() const noexport float AccelWarmup "Time after exceeding AccelThreshold before acceleration begins.";
};

struct SHoloDukeEffectActor
{
    var RenderActor Actor;
    var array<MaterialEx> Materials;
    var bool bNoTransparentFog;
};

struct SCompressedServerMove
{
    var float Timestamp;
    var Vector ClientEndLocation;
    var byte ClientViewPitch;
    var byte ClientViewPitchLow;
    var byte ClientViewYaw;
    var byte ClientViewYawLow;
    var byte ButtonInputByte1;
    var byte ButtonInputByte2;
    var byte AnalogInputByte;
};

struct SClientAdjustment
{
    var bool bAckGoodMove;
    var float Timestamp;
    var edfindable nocompress Vector NewLocation;
    var Actor.EPostureStateEx NewPosture;
};

struct SWatchInfo
{
    var Actor Actor;
    var string Property;
};

struct SCheckpointTravelActorData
{
    var travel bool bDestroyed;
    var travel Vector Location;
    var travel Rotator Rotation;
};

var float OrthoZoom;
var const Player Player;
var string StoredURL;
var Actor.ETravelType StoredTravelType;
var Mesh QueuedMesh;
var bool StoredbItems;
var transient bool bLevelTransition;
var bool bJumpInProgress;
var bool bIsJumpPadLaunching;
var bool bIsInAirFromJumpPad;
var bool bIsSubmerged;
var bool bForceCrouch;
var bool bInMapView;
var bool bPlayerViewLock;
var bool bAutoAdjustDOF;
var bool bDebugAutoDOF;
var bool bUsingZoneDOF;
var bool LastFog;
var bool bCenterView;
var bool bCameraLook;
var bool bDrawStandardOverlays;
var bool bNoSpam;
var bool bTakingCubeShot;
var bool bReadyLoadGame;
var bool bUseHelpPanel;
var bool bPlayerPausedGame;
var const bool bBadConnectionAlert;
var bool ShowLogo;
var bool bIsTyping;
var() bool bHitRumble;
var float LastPostNetReceiveShrinkScale;
var transient bool bMessageBeep;
var globalconfig transient bool bDoAimAssist;
var globalconfig transient bool bShowGameHints;
var globalconfig transient bool bShowSubtitles;
var globalconfig transient bool bShowBossMeter;
var bool bFilmGrainEnabled;
var bool bDeafened;
var float bUnDeafenSpeed;
var bool bFallingSound;
var bool bSnapToLevel;
var Actor.EPostureStateEx PreviousPostureStateEx;
var PlayerPawn.ELowerBodyOverrideState LowerBodyOverrideState;
var PlayerPawn.EForwardMovementState ForwardMovementState;
var PlayerPawn.EForwardMovementState PreviousForwardMovementState;
var PlayerPawn.EStrafeMovementState StrafeMovementState;
var PlayerPawn.EStrafeMovementState PreviousStrafeMovementState;
var PlayerPawn.EVerticalMovementState VerticalMovementState;
var PlayerPawn.EVerticalMovementState PreviousVerticalMovementState;
var float ForwardMovementStateSlowThreshold;
var float ForwardMovementStateFastThreshold;
var float StrafeMovementStateSlowThreshold;
var float StrafeMovementStateFastThreshold;
var float VerticalMovementStateSlowThreshold;
var float VerticalMovementStateFastThreshold;
var float TargetMoveAlphaX;
var Vector LastMoveRelDir;
var float MoveAlpha;
var float MoveAlphaX;
var float MoveAlphaY;
var float MoveAlphaZ;
var float MoveAnimTimer;
var transient name LastIdleAnim;
var transient name LastAnimX;
var transient name LastAnimZ;
var float WeaponBlendInTime;
var float WeaponBlendOutTime;
var Rotator AimOffset;
var Rotator MinAimOffset[11];
var Rotator MaxAimOffset[11];
var float AirControlEx;
var float AccelRateEx;
var float LadderControlXYEx;
var float LadderControlZEx;
var float StoredAirControlEx;
var float LastFallingDamageTime;
var float MinFallingDamageRepeatTime;
var float LightFallingDamageVelocity;
var float MediumFallingDamageVelocity;
var float FatalFallingDamageVelocity;
var float LightFallingDamage;
var float MediumFallingDamage;
var float HeavyFallingDamage;
var float DeferredFallingDamage;
var class<DamageType> DeferredFallingDamageType;
var class<DamageType> FatalFallingDamageType;
var SRumbleInfo LandRumble;
var class<HUDEffects> WaterSplatterClass;
var int AnimationControllerCacheIndex;
var array<SPlayerPawnAnimationControllerExCacheEntry> AnimationControllerCache;
var transient name LastUpperBodyState;
var transient Actor.EPostureStateEx LastUpperBodyPostureState;
var Vector CalcedViewLocation;
var Rotator CalcedViewRotation;
var MenuCamera CurrentMenuCamera;
var float MapFloatHeight;
var Vector ViewLockLocation;
var Actor ViewLockActor;
var Vector ViewLockLocationOffset;
var Actor.EPlayerCameraStyle CameraStyle;
var float BlurAmount;
var float BlurBrightnessScale;
var float BloomBrightnessScale;
var float MotionBlurIntensity;
var float MotionBlurAmount;
var float DOF_BlurAmount;
var float DOF_FocalDist;
var float DOF_FocalRangeMin;
var float DOF_FocalRangeMax;
var float DOF_WeapDist;
var float DOF_WeapDistDelta;
var Actor DOF_CameraActor;
var float AutoDOF_FadeTime;
var float AutoDOF_PawnFadeTime;
var float AutoDOF_LastPawnTraceTime;
var float MaxPixelMotionBlurVel;
var float BSPPixelMotionBlurFactor;
var float WaterBlurFactor;
var float FloatingPushUpIntensity;
var Color HeatVisionBackground;
var Actor ViewTarget;
var array<SSoundListener> ListenTargets;
var float ShakeFadeRate;
var Vector CompOldShakes;
var array<SActiveViewShake> ActiveShakes;
var Rotator CurrentShake;
var array<SRumbleInfo> ActiveRumbles;
var PlayerPawn.ECameraBobState CameraBobState;
var() noexport array<SViewShakeInfo> WalkingCameraBob "Shake methods to use for camera bob when walking";
var() noexport array<SViewShakeInfo> CrouchingCameraBob "Shake methods to use for camera bob when crouch walking";
var() noexport array<SViewShakeInfo> SprintingCameraBob "Shake methods to use for camera bob when sprinting";
var() noexport float BobPCT "PCT to bob. 0.0 = no bob. 1.0 = full bob";
var() noexport float DamageViewKickSoft "Max angle to use for damage view kicks when damage is less than DamageViewKickHard";
var() noexport float DamageViewKickHard "Max angle to use for damage view kicks when damage is more than DamageViewKickHard";
var() noexport float DamageViewKickHardThreshold "Minimum damage required in oneframe to use DamageViewKickHard.";
var() noexport SViewShakeInfo MeleeContactShake "Shake to use when the player hits something with a melee attack.";
var() noexport SViewShakeInfo ExecutionContactShake "Shake to use when the player does an execution.";
var() noexport SRumbleInfo MeleeContactRumble "Rumble to use when the player hits something with a melee attack.";
var() noexport SRumbleInfo ExecutionContactRumble "Rumble to use when the player does an execution.";
var() noexport SRumbleInfo LightContactRumbleInfo "Rumble to use for LightContactRumble animevent.";
var() noexport SRumbleInfo MediumContactRumbleInfo "Rumble to use for MediumContactRumble animevent.";
var() noexport SRumbleInfo HeavyContactRumbleInfo "Rumble to use for HeavyContactRumble animevent.";
var() noexport SRumbleInfo EgoCapIncreaseRumbleInfo "Rumble to play along with the ego cap increase sound.";
var Color HeatFogColor;
var Color NightFogColor;
var SDistanceFogOverride ZoneFogOverride;
var SDistanceFogOverride VolumeFogOverride;
var float LastFogCheckTime;
var float LastFogStart;
var float LastFogEnd;
var Color LastFogColor;
var float LastFogOpacity;
var float CurrentFOV;
var config float DefaultFOV;
var float DefaultFOVShrunk;
var const int ShowFlags;
var int RendMap;
var const int Misc1;
var const int Misc2;
var Actor ViewMapper;
var Actor OverlayActor;
var Object.ESaveType LoadGameType;
var int LoadGameNum;
var Object.ESpecialKeys HelpKey[10];
var Object.ESpecialKeys HelpKeyAlt[10];
var string HelpText[10];
var HUD MyHUD;
var class<HUD> HUDType;
var int MultiKillLevel;
var float LastKillTime;
var string ProgressMessage[8];
var Color ProgressColor[8];
var float ProgressTimeOut;
var int AccuracyHits;
var int AccuracyHitsMax;
var int AccuracyShots;
var string MatchMessage[8];
var Color MatchColor[8];
var float MatchTimeOut;
var int StartMatchTime;
var float RespawnCountdown;
var localized string QuickSaveString;
var localized string NoPauseMessage;
var localized string ViewingFrom;
var localized string OwnCamera;
var localized string FailedView;
var localized string JoinSpectatorText;
var localized string LeaveSpectatorText;
var float LastPlaySound;
var(Sounds) noexport SSoundInfo TinnitusLoopSoundInfo "Sound to play after getting hit with an explosion";
var(Sounds) noexport SSoundInfo TinnitusEndSoundInfo "Sound to play for fading out from explosion hit";
var float NextMirrorEgoTime;
var input float aBaseX;
var input float aBaseY;
var input float aMouseX;
var input float aMouseY;
var input float aForward;
var input float aTurn;
var input float aStrafe;
var input float aUp;
var input float aLookUp;
var input float aLeftTrigger;
var input float aRightTrigger;
var(Analog) noexport SAnalogAxisInfo LookUpAnalogInfo[10] "Various levels of sensitivity for analog vertical aiming.";
var(Analog) noexport SAnalogAxisInfo TurnAnalogInfo[10] "Various levels of sensitivity for analog horizonal aiming.";
var float LookUpAnalogAccelWarmup;
var float TurnAnalogAccelWarmup;
var Actor AimAssistEnemy;
var float AimAssistTimer;
var Vector AimAssistPoint;
var Rotator AimAssistAdjust;
var globalconfig transient float MouseSensitivity;
var globalconfig transient float MouseAccelDampening;
var transient float MouseSmoothThreshold;
var globalconfig transient int LookSensitivityH;
var globalconfig transient int LookSensitivityV;
var globalconfig transient int PrefabConfigIndex;
var int RumbleLeftSpeed;
var int RumbleRightSpeed;
var transient bool bMaxMouseSmoothing;
var globalconfig transient bool bInvertMouse;
var globalconfig transient bool bInvertXboxAim;
var globalconfig transient bool bVibration;
var globalconfig transient bool bToggleCrouch;
var globalconfig transient bool bToggleZoom;
var globalconfig transient bool bSwapJoysticks;
var globalconfig transient int OMPL;
var globalconfig transient bool bAlwaysTalk;
var bool bDontAllowToggleZoom;
var bool bDrawDebugEnemyBounds;
var bool bInfiniteAmmo;
var travel bool TeleportTravel;
var bool bInventorySent;
var bool bCheckInventoryReceived;
var bool bTouchingWeaponDelayedUse;
var travel name TravelVehicleTag;
var travel Vector TravelVehicleVelocity;
var transient float MyAutoAim;
var transient name WeaponPriority[20];
var transient int UserCrosshairIndex;
var travel Rotator TravelViewRotation;
var Actor TouchingWeaponPickup;
var InteractiveActor NotifyUnUsed;
var InteractiveActor NotifyGrabUnUsed;
var float ThrowTime;
var private travel int BladderLevel;
var Texture EgoDepletedHUDEffectMaterial;
var float EgoDepletedHUDEffectAmp;
var float EgoDepletedHUDEffectFreq;
var float EgoDepletedHUDEffectOffset;
var Actor DirectLookHitActor;
var InteractiveActor LookHitActor;
var Pawn LookHitPawn;
var Actor LookActor;
var float LookHitDistance;
var float RestartTime;
var float VolumeSoundsTimer;
var(Drunk) noexport float MaxDrunkLevel "Maximum level of drunk.";
var(Drunk) noexport float DrunkRampUpTime "Total time it takes for drunk effects to ramp to full (blur, ringing, deafness)";
var(Drunk) noexport float DrunkTime "Total time for being drunk.";
var(Drunk) noexport float DrunkRecoveryTime "Time it takes to sober up.";
var(Drunk) noexport float DrunkBlurAmount "Maximum blur percent for drunk.";
var(Drunk) noexport float DrunkZoomDuration "Time for each zoom when drunk.";
var(Drunk) noexport float DrunkZoomPct "Percentage to zoom in/out per DrunkLevel.";
var(Drunk) noexport SSoundInfo DrunkRingingSound "Sound to play when drunk.";
var(Drunk) noexport float DrunkRingingSoundVolume "Base volume of drunk ringing sound.";
var(Drunk) noexport float DrunkDeafFactorBase "Base deafness level, lower is deafer.";
var(Drunk) noexport float DrunkDeafFactorDelta "For each drunk level, make the player this much more deaf.";
var(Drunk) float DrunkHiccupTime;
var(Drunk) float DrunkHiccupTimeVar;
var(Drunk) noexport float DrunkDamageAbsorbPct "Percentage of damage absorbed when drunk.";
var(Steroids) noexport float SteroidDamageAbsorbPct "Percentage of damage absorbed when on steroids.";
var travel float SteroidsDuration;
var travel float SteroidsStartTime;
var travel float DrunkStartTime;
var travel float DrunkEndTime;
var travel float DrunkLevel;
var Actor CigarAttachment;
var transient float DebugSlomo;
var netupdate(NU_HoloDukeActive) bool bHoloDukeActive;
var MaterialEx HoloDukeEffectMaterial;
var array<SHoloDukeEffectActor> HoloDukeEffectActors;
var Weapon DetonatorRef;
var transient input byte inputWalk;
var transient input byte inputEnableMouseLook;
var transient input byte inputViewSnapLevel;
var transient input byte inputStrafe;
var transient input byte inputFreeLook;
var transient bool bIForward;
var transient bool bIBackward;
var transient bool bIStrafeLeft;
var transient bool bIStrafeRight;
var transient bool bITurnLeft;
var transient bool bITurnRight;
var transient bool bIFire;
var transient bool bIFireServer;
var transient bool bIMelee;
var transient bool bIJump;
var transient bool bIDuck;
var transient bool bIUse;
var transient bool bIZoom;
var transient bool bISprint;
var bool bCrouchOn;
var bool bOptimizedFireTrace;
var bool bIsFiringBulletThisFrame;
var bool bIsSprinting;
var bool bIWasForward;
var bool bIWasBackward;
var bool bIWasStrafeLeft;
var bool bIWasStrafeRight;
var bool bIWasTurnLeft;
var bool bIWasTurnRight;
var bool bIWasJump;
var bool bIWasDuck;
var bool bIWasFire;
var bool bIWasFireServer;
var bool bIWasMelee;
var bool bIWasUse;
var bool bIWasZoom;
var transient bool bIDnControlFire;
var bool bIWasDnControlFire;
var transient bool bIDnControlMelee;
var bool bIWasDnControlMelee;
var transient bool bIDnControlDuck;
var bool bIWasDnControlDuck;
var float IdleTime;
var float IdleWarningTime;
var Rotator IdleOldViewRotation;
var int IdleViewRotationChangeCount;
var bool bIPhysWasJump;
var float GridYCached2;
var bool bIJumpPressed;
var bool bReceivedServerPositionUpdate;
var bool bReplayingSavedMoves;
var bool bAdmin;
var bool bReadyToPlay;
var bool bLeftSpectator;
var bool bUseRemappedEvents;
var bool bWatchEnabled;
var bool bCheatsEnabled;
var(MovementEx) bool bCanSprint;
var bool bWasSprinting;
var bool bSprintRecover;
var bool bSprintBreathing;
var bool bSprintFatigue;
var bool bChaseCam;
var bool bCanPlantBomb;
var bool bVoted;
var Rotator LastMoveViewRotation;
var byte AnalogInputByte;
var byte ButtonInputByte1;
var byte ButtonInputByte2;
var bool bCollectingCompressedServerMoveData;
var array<SCompressedServerMove> SavedCompressedServerMoveData;
var SClientAdjustment ServerPendingAdjustment;
var float ClientTimeDifference;
var const class<SavedMove> SavedMoveClass;
var SavedMove SavedMovesHead;
var SavedMove SavedMovesTail;
var SavedMove FreeMoves;
var SavedMove LastGoodMove;
var float CurrentTimeStamp;
var float ServerLastUpdateTime;
var float ServerTimeStamp;
var float TimeMargin;
var float ClientUpdateTime;
var Vector WeaponStartTraceLocation;
var Vector WeaponStartTraceDirection;
var int WeaponSeed;
var int DemoViewPitch;
var int DemoViewYaw;
var Vector LastDeathLoc;
var Rotator LastDeathRot;
var float PainDebounceTime;
var float PainDelay;
var() noexport SScreenFlash HealthRecoveryScreenFlash "Screen flash to display during health recovery.";
var Object.EPlayerViewRotationMode ViewRotationMode;
var Rotator DesiredViewRotation;
var Rotator StartViewRotation;
var float RotateViewLength;
var float RotateViewStartTime;
var int MinViewPitch;
var int MaxViewPitch;
var Vector LastGhostLocation;
var travel bool bHasCheatedThisLevel;
var bool bDontResetCheatTracking;
var GameReplicationInfo GameReplicationInfo;
var byte LoginTeam;
var Actor InputHookActor;
var Actor KeyEventHookActor;
var Actor CurrentInputDecoration;
var array<SWatchInfo> WatchInfo;
var Actor MyDebugView;
var int MaxVoteCount;
var int VoteCount;
var float CrouchSpeedScaleEx;
var netupdate(NU_TargetWalkSpeedEx) float TargetWalkSpeedEx;
var netupdate(NU_TargetSprintSpeedEx) float TargetSprintSpeedEx;
var netupdate(NU_TargetJumpSpeedEx) float TargetJumpSpeedEx;
var netupdate(NU_TargetSwimSpeedEx) float TargetSwimSpeedEx;
var netupdate(NU_TargetLadderJumpSpeedEx) float TargetLadderJumpSpeedEx;
var(MovementEx) float WalkSpeedEx;
var(MovementEx) float SprintSpeedEx;
var(MovementEx) float JumpSpeedEx;
var(MovementEx) float ShrunkenJumpSpeedEx;
var(MovementEx) float SwimSpeedEx;
var(MovementEx) float LadderJumpSpeedEx;
var float TargetWaterExitJumpSpeedEx;
var(MovementEx) float WaterExitJumpSpeedEx;
var(MovementEx) float SprintTotalTime;
var float SprintTimer;
var float SprintRecoverTime;
var float SprintFOVScale;
var float SprintDownTime;
var Actor.EVehiclePOV VehiclePOV;
var(Shrinking) noexport float SizeChangeFOVScale "FOV scalar to apply during the size change.";
var(Shrinking) noexport float SizeChangeFOVApplyTime "Time it takes to transition into the scaled FOV.";
var(Shrinking) noexport float SizeChangeFOVRemoveTime "Time it takes to transition back to the unscaled FOV.";
var(Shrinking) noexport float SizeChangeMotionBlur "MotionBlur factor to apply during a size change.";
var(Shrinking) noexport float SizeChangeMotionBlurTime "Time it takes for the motion blur to dissipate.";
var travel float SavedGameTimeSeconds;
var float LoadGameTimeSeconds;
var transient travel array<SCheckpointTravelActorData> CheckpointTravelActors;
var PlayerStart LoginPlayerStart;
var SSoundInfo LoadScreenAmbience;
var SSoundInfo NavigateSoundInfo;
var bool bLockPlayerWFP;

replication
{
    // Pos:0x000
    unreliable if(-int(Role))
        RealCompressedServerMove;

    // Pos:0x021
    unreliable if(int(Role) % int(ROLE_Authority))
        ClientAckGoodMove, ClientAdjustPosition;

    // Pos:0x0E9
    unreliable if(-int(Role))
        Fly, Ghost, 
        Walk;

    // Pos:0x00B
    reliable if(-int(Role))
        ReliableRealCompressedServerMove;

    // Pos:0x016
    reliable if(-int(Role))
        SetNetSpeed;

    // Pos:0x02C
    reliable if((bNetOwner / ) << )
        ButtonInputByte1, ButtonInputByte2, 
        WeaponSeed;

    // Pos:0x044
    reliable if(int(Role) % int(ROLE_Authority))
        CrouchSpeedScaleEx, TargetJumpSpeedEx, 
        TargetLadderJumpSpeedEx, TargetSprintSpeedEx, 
        TargetSwimSpeedEx, TargetWalkSpeedEx, 
        TouchingWeaponPickup;

    // Pos:0x04F
    reliable if(int(Role) % int(ROLE_Authority))
        rClientDebugDrawCross, rClientDebugDrawCylinder;

    // Pos:0x05A
    reliable if(int(Role) % int(ROLE_Authority))
        rClientDebugDrawLine;

    // Pos:0x065
    reliable if(-int(Role))
        rServerDebugDrawLine;

    // Pos:0x070
    reliable if(int(Role) % int(ROLE_Authority))
        rClientHearActorSound, rClientHearSound, 
        rClientShortHearActorSound, rClientShortHearSound, 
        rClientVeryShortHearActorSound, rClientVeryShortHearSound;

    // Pos:0x07B
    reliable if(int(Role) % int(ROLE_Authority))
        rClientFindAndPlaySound;

    // Pos:0x086
    reliable if(int(Role) % int(ROLE_Authority))
        PlayDrunkRingingSound;

    // Pos:0x091
    reliable if(int(Role) % int(ROLE_Authority))
        AddPickupEvent, StartedSprinting, 
        StoppedSprinting;

    // Pos:0x09C
    reliable if(int(Role) % int(ROLE_Authority))
        bHoloDukeActive, bISprint, 
        bIsSprinting;

    // Pos:0x0A7
    reliable if(bNetOwner << int(Role) % int(ROLE_Authority))
        AccuracyHits, AccuracyShots, 
        GameReplicationInfo, HUDType, 
        ViewTarget, bCanPlantBomb, 
        bCheatsEnabled;

    // Pos:0x0BD
    reliable if(bDemoRecording << int(Role) % int(ROLE_Authority))
        DemoViewPitch, DemoViewYaw;

    // Pos:0x0D3
    reliable if(-int(Role))
        bReadyToPlay;

    // Pos:0x0DE
    reliable if(-int(Role))
        Admin, AdminLogin, 
        AdminLogout, BehindView, 
        ChangeName, ChangeTeam, 
        God, Kick, 
        KickBan, KillAll, 
        LeaveSpectator, Mutate, 
        Pain, PlayersOnly, 
        RestartLevel, Say, 
        ServerAddBots, ServerCallVote, 
        ServerChangeMesh, ServerChangeSkin, 
        ServerCrouchDown, ServerInventoryActivate, 
        ServerInventoryDeactivate, ServerJoinSpectator, 
        ServerRestartGame, ServerRestartPlayer, 
        ServerSetSloMo, ServerSprintDown, 
        ServerSprintUp, ServerSummon, 
        ServerTaunt, ServerUseDown, 
        ServerUseUp, Suicide, 
        Summon, SwapWeapons, 
        SwitchCoopLevel, SwitchLevel, 
        TeamSay, Tell, 
        Typing, ViewClass, 
        ViewNextPlayer, ViewPlayer, 
        ViewSelf, VoteNo, 
        VoteYes;

    // Pos:0x0F4
    reliable if((int(Role) % int(ROLE_Authority)) << bDemoRecording / )
        ClientTravel, InstigateClientTravel;

    // Pos:0x10C
    reliable if(int(Role) % int(ROLE_Authority))
        ClearMatchMessages, ClearProgressMessages, 
        ClientBecomeDead, ClientChangeTeam, 
        ClientEndSteroids, ClientHideLobby, 
        ClientInventoryDeactivate, ClientRemoveViewMapper, 
        ClientReplicateSkins, ClientShowPostGameLobby, 
        ClientShowPreGameLobby, ClientStartSteroids, 
        ClientUseReload, SetMatchColor, 
        SetMatchMessage, SetMatchStartTime, 
        SetMatchTime, SetProgressColor, 
        SetProgressMessage, SetProgressMessageNoLoc, 
        SetProgressMessageSplitByNum, SetProgressMessageSplitByStr, 
        SetProgressTime, StopAllShakes, 
        StopShake;

    // Pos:0x117
    reliable if(/* An exception occurred while decompiling condition (System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.get_NextToken()
   at UELib.Core.UStruct.UByteCodeDecompiler.Token.DecompileNext()
   at UELib.Core.UStruct.UByteCodeDecompiler.FunctionToken.DecompileOperator(String operatorName)
   at UELib.Core.UStruct.UByteCodeDecompiler.NativeFunctionToken.Decompile()
   at UELib.Core.UClass.FormatReplication()) */)
        ClientVoiceMessage;
}

// Export UPlayerPawn::execXBoxIsSignedIn(FFrame&, void* const)
native(970) final function bool XBoxIsSignedIn(bool bShowSignInDialog);

// Export UPlayerPawn::execXBoxHasStorageDevice(FFrame&, void* const)
native(971) final function bool XBoxHasStorageDevice(bool bShowDevicePicker);

// Export UPlayerPawn::execXBoxIsPlayingWithoutSave(FFrame&, void* const)
native(972) final function bool XBoxIsPlayingWithoutSave();

// Export UPlayerPawn::execXBoxDidUserChange(FFrame&, void* const)
native(973) final function bool XBoxDidUserChange();

// Export UPlayerPawn::execXBoxSaveProfile(FFrame&, void* const)
native(974) function XBoxSaveProfile();

// Export UPlayerPawn::execXBoxIsSystemUIShowing(FFrame&, void* const)
native(975) final function bool XBoxIsSystemUIShowing();

// Export UPlayerPawn::execXBoxAwardAchievement(FFrame&, void* const)
native(976) final function XBoxAwardAchievement(int iAchievementID);

// Export UPlayerPawn::execSetTitleScreen(FFrame&, void* const)
native(977) final function SetTitleScreen(bool bInTitleScreen);

// Export UPlayerPawn::execReadyToPlay(FFrame&, void* const)
native(978) final function bool ReadyToPlay();

// Export UPlayerPawn::execContinueCampaignInProgress(FFrame&, void* const)
native(979) final function bool ContinueCampaignInProgress(bool bStatus);

// Export UPlayerPawn::execGetWalkSpeed(FFrame&, void* const)
native(980) simulated function float GetWalkSpeed();

// Export UPlayerPawn::execCanSprint(FFrame&, void* const)
native(981) simulated function bool CanSprint();

// Export UPlayerPawn::execWantsToSprint(FFrame&, void* const)
native(982) simulated function bool WantsToSprint();

// Export UPlayerPawn::execIsSprinting(FFrame&, void* const)
native(983) simulated function bool IsSprinting();

// Export UPlayerPawn::execGetSprintSpeedThreshold(FFrame&, void* const)
native(984) simulated function float GetSprintSpeedThreshold();

// Export UPlayerPawn::execCanControlMovement(FFrame&, void* const)
native(985) simulated function bool CanControlMovement();

// Export UPlayerPawn::execSetNetSpeed(FFrame&, void* const)
native event SetNetSpeed(int Rate);

// Export UPlayerPawn::execIsPreRound(FFrame&, void* const)
native function bool IsPreRound();

// Export UPlayerPawn::execIsCountdown(FFrame&, void* const)
native function bool IsCountdown();

// Export UPlayerPawn::execIsRoundInProgress(FFrame&, void* const)
native function bool IsRoundInProgress();

// Export UPlayerPawn::execIsEndOfRound(FFrame&, void* const)
native function bool IsEndOfRound();

// Export UPlayerPawn::execGetRoundState(FFrame&, void* const)
native simulated function PlayerPawn.ERoundState GetRoundState();

function DoMessage(string str)
{
    // End:0x28
    if(int(Role) % int(ROLE_Authority))
    {
        ClientMessage(__NFUN_303__("Server:", str));        
    }
    else
    {
        ClientMessage(__NFUN_303__("Client:", str));
    }
    return;
}

simulated event UpdateShrinkScale(float ShrinkSizeScale)
{
    WalkSpeedEx = FRand(ShrinkSizeScale, TargetWalkSpeedEx);
    SprintSpeedEx = FRand(ShrinkSizeScale, TargetSprintSpeedEx);
    SwimSpeedEx = FRand(ShrinkSizeScale, TargetSwimSpeedEx);
    LadderJumpSpeedEx = FRand(ShrinkSizeScale, TargetLadderJumpSpeedEx);
    WaterExitJumpSpeedEx = FRand(ShrinkSizeScale, TargetWaterExitJumpSpeedEx);
    JumpSpeedEx = VSizeSq(GetShrunkPercentage(), TargetJumpSpeedEx, ShrunkenJumpSpeedEx);
    GravityScale = FRand(ShrinkSizeScale, default.GravityScale);
    super.UpdateShrinkScale(ShrinkSizeScale);
    return;
}

simulated event PreBeginPlay()
{
    bIsPlayer = true;
    DebugSlomo = 1;
    ServerLastUpdateTime = 0;
    __NFUN_691__(0);
    super.PreBeginPlay();
    return;
}

simulated event PostBeginPlay()
{
    local OnlineAgent agent;
    local int FOVvalue;

    TargetWalkSpeedEx = WalkSpeedEx;
    TargetSprintSpeedEx = SprintSpeedEx;
    TargetJumpSpeedEx = JumpSpeedEx;
    TargetSwimSpeedEx = SwimSpeedEx;
    TargetLadderJumpSpeedEx = LadderJumpSpeedEx;
    TargetWaterExitJumpSpeedEx = WaterExitJumpSpeedEx;
    super.PostBeginPlay();
    // End:0xA5
    if(int(Level.NetMode) + int(NM_Client))
    {
        HUDType = Level.Game.HUDType;
        MyAutoAim = VSize(MyAutoAim, Level.Game.AutoAim);
    }
    bIsPlayer = true;
    LastGhostLocation = Location;
    // End:0x10E
    if((IsMP()) / )
    {
        {
            SpawnHUD();
        }
        // End:0x10E
        if(__NFUN_340__(MyHUD, none))
        {
            MyHUD.EnterLevelFade();
            // End:0x10E
            if(__NFUN_340__(HeadVolume, none))
            {
                HeadVolume.AddHudEffect(self);
            }
        }
    }
    // End:0x17D
    if(Level.bHasDOF)
    {
        __NFUN_578__('DOFBlurAmount', Level.DOFBlurAmount);
        __NFUN_578__('DOFFocalDistance', Level.DOFFocalDist);
        __NFUN_578__('DOFFocalRangeMin', Level.DOFFocalRangeMin);
        __NFUN_578__('DOFFocalRangeMax', Level.DOFFocalRangeMax);
    }
    LookSensitivityH = Exp(LookSensitivityH, 0, -- 10);    
    LookSensitivityV = Exp(LookSensitivityV, 0, -- 10);    
    MouseSensitivity = Normal2D(MouseSensitivity, 1, 10);
    MouseAccelDampening = Normal2D(MouseAccelDampening, 1, 10);
    agent = OnlineAgent(class'Engine'.static.__NFUN_503__());
    agent.OnPostBeginPlay(self);
    // End:0x282
    if(__NFUN_375__("Engine.PlayerPawn", "DefaultFOV", FOVvalue, "User.ini") / )
    {
        {
        }
        FOVvalue = Exp(FOVvalue, 55, 120);
    }
    DefaultFOV = float(FOVvalue);
    DefaultFOVShrunk = float(-- FOVvalue);    
    return;
}

function InitPlayerReplicationInfo()
{
    super.InitPlayerReplicationInfo();
    PlayerReplicationInfo.bTeamGame = Level.GRI.bTeamGame;
    PlayerReplicationInfo.bAdmin = bAdmin;
    return;
}

simulated event Destroyed()
{
    local SavedMove NextSavedMove;

    super.Destroyed();
    // End:0x34
    if(__NFUN_340__(ViewMapper, none) << int(Role) % int(ROLE_Authority))
    {
        ViewMapper.Used(self, self);
    }
    StopChatting();
    // End:0x5A
    if(__NFUN_340__(MyHUD, none))
    {
        MyHUD.__NFUN_614__();
        MyHUD = none;
    }
    J0x5A:

    // End:0x96 [Loop If]
    if(__NFUN_340__(FreeMoves, none))
    {
        NextSavedMove = FreeMoves.NextMove;
        FreeMoves.__NFUN_614__();
        FreeMoves = NextSavedMove;
        // [Loop Continue]
        goto J0x5A;
    }
    CleanOutSavedMoves();
    ForceStopAllRumble();
    return;
}

simulated exec function ShowScoreboard()
{
    return;
}

simulated exec function HideScoreboard()
{
    // End:0x30
    if(__NFUN_340__(Player.Console, none))
    {
        Player.Console.HideScoreboard();
    }
    return;
}

function ClientShowPreGameLobby()
{
    // End:0x30
    if(__NFUN_340__(Player.Console, none))
    {
        Player.Console.ShowPreGameLobby();
    }
    return;
}

function ClientShowPostGameLobby()
{
    JoinPostGameLobby();
    return;
}

simulated function JoinPostGameLobby()
{
    // End:0x1C
    if(__NFUN_339__(GameReplicationInfo, none))
    {
        __NFUN_607__(1E-05, false, 'JoinPostGameLobby');
        return;
    }
    // End:0x4C
    if(__NFUN_340__(Player.Console, none))
    {
        Player.Console.ShowPostGameLobby();
    }
    return;
}

function ClientHideLobby()
{
    // End:0x30
    if(__NFUN_340__(Player.Console, none))
    {
        Player.Console.HideLobby();
    }
    return;
}

simulated function NU_TargetWalkSpeedEx(float UnUsed)
{
    SetShrinkScale();
    return;
}

simulated function NU_TargetSprintSpeedEx(float UnUsed)
{
    SetShrinkScale();
    return;
}

simulated function NU_TargetJumpSpeedEx(float UnUsed)
{
    SetShrinkScale();
    return;
}

simulated function NU_TargetSwimSpeedEx(float UnUsed)
{
    SetShrinkScale();
    return;
}

simulated function NU_TargetLadderJumpSpeedEx(float UnUsed)
{
    SetShrinkScale();
    return;
}

exec function Mutate(string MutateString)
{
    // End:0x1A
    if(int(Level.NetMode) % int(NM_Client))
    {
        return;
    }
    Level.Game.BaseMutator.Mutate(MutateString, self);
    return;
}

// Export UPlayerPawn::execNativeTick(FFrame&, void* const)
native(986) function NativeTick(float DeltaTime);

cached simulated event Tick(float DeltaTime)
{
    super(Actor).Tick(DeltaTime);
    NativeTick(DeltaTime);
    return;
}

function ClearFallingSound()
{
    bFallingSound = false;
    return;
}

// Export UPlayerPawn::execNativeUpdateLookHitActor(FFrame&, void* const)
native function Actor NativeUpdateLookHitActor(optional Actor NonTraceBaseActor);

event Actor UpdateLookHitActor(optional Actor NonTraceBaseActor)
{
    return NativeUpdateLookHitActor(NonTraceBaseActor);
    return;
}

final simulated event UpdateGameSpeed()
{
    // End:0x8B
    if(int(Level.NetMode) % int(NM_Standalone))
    {
        // End:0x4F
        if(IsDead())
        {
            Level.Game.SetGameSpeed(FRand(DebugSlomo, __NFUN_581__('TimeDilation', 3)));            
        }
        else
        {
            Level.Game.SetGameSpeed(FRand(FRand(Level.GameSpeedModifier, DebugSlomo), __NFUN_581__('TimeDilation', 3)));
        }
    }
    return;
}

animevent simulated function KillPause(optional EventInfo AnimEventInfo)
{
    return;
}

event IdleWarning()
{
    return;
}

final simulated function KillUnPause()
{
    __NFUN_577__('TimeDilation', 'KillPause', 1,, 0.05);
    return;
}

simulated function HeadEnteredWater(optional Actor Instigator)
{
    // End:0x17
    if(IsLocallyControlled())
    {
        __NFUN_605__(0.5, false, 'PlayUnderwaterAmbient');
    }
    super.HeadEnteredWater(Instigator);
    StartWaterBlur(true);
    return;
}

simulated function HeadExitedWater()
{
    // End:0x1F
    if(IsLocallyControlled())
    {
        __NFUN_698__(14, 0.25, 0, 1, 'StopWaterAmbience');
    }
    __NFUN_607__(0.1, false, 'SplatterWater');
    super.HeadExitedWater();
    EndWaterBlur();
    return;
}

simulated function SplatterWater()
{
    local HUDEffects ScreenSplatter;

    // End:0x0E
    if(__NFUN_339__(WaterSplatterClass, none))
    {
        return;
    }
    ScreenSplatter = HUDEffects(FindStaticActor(WaterSplatterClass));
    // End:0x61
    if(__NFUN_340__(ScreenSplatter, none))
    {
        ScreenSplatter.__NFUN_645__(Locs(Location, Caps(1, Vector(Rotation))));
        ScreenSplatter.StartEffect();
    }
    return;
}

final function EndWaterBlur()
{
    __NFUN_577__('Blur', 'Water', 0, 0, 3);
    return;
}

final function EndWaterBlurFast()
{
    __NFUN_577__('Blur', 'Water', 0, 0, 0.25);
    return;
}

final function StartWaterBlur(optional bool override)
{
    // End:0x48
    if(override < __NFUN_340__(HeadVolume, none) << HeadVolume.bWaterVolume)
    {
        __NFUN_577__('Blur', 'Water', WaterBlurFactor, 0, 0.25);
    }
    return;
}

simulated function PlayUnderwaterAmbient()
{
    // End:0x30
    if(__NFUN_340__(HeadVolume, none))
    {
        HeadVolume.FindAndPlaySound(HeadVolume.VolumeSubmergedAmbienceName, 0,,, self);
    }
    return;
}

simulated function StopWaterAmbience()
{
    __NFUN_606__('PlayUnderwaterAmbient');
    __NFUN_695__(14);
    return;
}

exec function StackTrace()
{
    __NFUN_374__();
    return;
}

exec function MarkLog()
{
    __NFUN_355__(__NFUN_302__("---------- Log Marked at ", string(Level.TimeSeconds)));
    return;
}

// Export UPlayerPawn::execNative_ShowNavPoints(FFrame&, void* const)
native(987) final function Native_ShowNavPoints();

exec function ShowNavPoints()
{
    __NFUN_987__();
    return;
}

// Export UPlayerPawn::execNative_GetNumDisplayModes(FFrame&, void* const)
native(988) final function int Native_GetNumDisplayModes(int DisplayAspect);

// Export UPlayerPawn::execNative_GetDisplayMode(FFrame&, void* const)
native(989) final function bool Native_GetDisplayMode(int DisplayAspect, int Index, out int Width, out int Height, out int Refresh);

event PrepareForFastSave()
{
    local int i;

    string(CheckpointTravelActors) = string(Level.CheckpointTravelActors);
    i = -- string(CheckpointTravelActors);    
    J0x26:

    // End:0xE1 [Loop If]
    if(i / 0)
    {
        // End:0xC4
        if(__NFUN_403__(Level.CheckpointTravelActors[i]) / )
        {
            CheckpointTravelActors[i].Location = Level.CheckpointTravelActors[i].Location;
            CheckpointTravelActors[i].Rotation = Level.CheckpointTravelActors[i].Rotation;
            // [Explicit Continue]
            goto J0xD7;
        }
        CheckpointTravelActors[i].bDestroyed = true;
        J0xD7:

        // [Loop Continue]
        i -= ;
    }
    return;
}

function NotifyAfterLevelChange()
{
    // End:0x48
    if(((((CanUse4Weapons()) / ) << ) << ) << )
    {
    }
    return;
}

function NotifyExitMap()
{
    super.NotifyExitMap();
    CheckpointTravelActors.Empty();
    return;
}

function NotifyCheckpoint(TriggerCheckpoint checkpoint)
{
    super.NotifyCheckpoint(checkpoint);
    SavedGameTimeSeconds = Level.GameTimeSeconds;
    TravelVehicleTag = 'None';
    return;
}

event PreClientTravel()
{
    // End:0x0F
    if(bAttachedToUsableSomething)
    {
        ForceDetachCompleteFromUsableSomething();
    }
    // End:0x3D
    if((IsMP()) / )
    {
        {            
        }
        else
        {
            bDontResetCheatTracking = false;
        }
    }
    SavedGameTimeSeconds = Level.GameTimeSeconds;
    return;
}

event InstigateClientTravel(string URL, Actor.ETravelType TravelType, bool bItems)
{
    StoredURL = URL;
    StoredTravelType = TravelType;
    StoredbItems = bItems;
    // End:0x5A
    if((__NFUN_339__(Level, __NFUN_560__()) < __NFUN_991__()) < __NFUN_204__(Level.ExitLevelFadeTime, float(0)))
    {
        ExecuteClientTravel();        
    }
    else
    {
        MyHUD.ExitLevelFade();
    }
    return;
}

// Export UPlayerPawn::execShouldSaveCheckpoint(FFrame&, void* const)
native function bool ShouldSaveCheckpoint(string MapName);

final function ExecuteClientTravel()
{
    local string MapName;

    // End:0x2B
    if(Weapon.bNonWeapon)
    {
        Weapon.bDeactivationAllowed = true;
        BringUpLastWeapon();
    }
    SoberUp();
    MapName = StoredURL - __NFUN_315__(StoredURL, "#");
    // End:0x68
    if(ShouldSaveCheckpoint(MapName))
    {
        __NFUN_781__(4, -1, MapName, none);
    }
    ClientTravel(StoredURL, StoredTravelType, StoredbItems);
    StoredURL = "";
    return;
}

// Export UPlayerPawn::execClientTravel(FFrame&, void* const)
native event ClientTravel(string URL, Actor.ETravelType TravelType, bool bItems);

// Export UPlayerPawn::execUpdateURL(FFrame&, void* const)
native(990) final function UpdateURL(string NewOption, string NewValue, bool bSaveDefault);

// Export UPlayerPawn::execGetDefaultURL(FFrame&, void* const)
native final function string GetDefaultURL(string Option);

// Export UPlayerPawn::execHasClientTravel(FFrame&, void* const)
native final function bool HasClientTravel();

exec function RestartLevel()
{
    // End:0x8B
    if(bAdmin < (int(Level.NetMode) % int(NM_Standalone)) << PlayerReplicationInfo.IsSpectating() / )
    {
        InstigateClientTravel(__NFUN_302__("?restart?Difficulty=", string(Level.Game.Difficulty)), 2, false);
    }
    return;
}

exec function LocalTravel(string URL)
{
    // End:0x31
    if(bAdmin < int(Level.NetMode) % int(NM_Standalone))
    {
        InstigateClientTravel(URL, 2, true);
    }
    return;
}

event PrepareForExportTravel()
{
    bWeaponsActive = default.bWeaponsActive;
    ScaleModifierGroupList = default.ScaleModifierGroupList;
    return;
}

event TravelPreAccept()
{
    LoadGameTimeSeconds = Level.GameTimeSeconds;
    super(Actor).TravelPreAccept();
    return;
}

event TravelPostAccept()
{
    local int i, j;
    local Decoration id;
    local float GTSAdjust, SteroidsTimeRemaining, DrunkTimeRemaining;
    local Actor.EPostureStateEx NewPostureState;
    local Object.EPhysics StoredPhysics;

    super(Actor).TravelPostAccept();
    LastQuickAction = 'None';
    GTSAdjust = Round(Level.GameTimeSeconds, SavedGameTimeSeconds);
    // End:0x68
    if(bAttachedToUsableSomething / )
    {
        {
            ViewMapper = none;
        }
        // End:0x68
        if(__NFUN_340__(ControlRemapperEx(InputHookActor), none))
        {
            InputHookActor = none;
        }
    }
    // End:0xBF
    if(bOnSteroids)
    {
        SteroidsTimeRemaining = Round(SteroidsDuration, Round(Level.GameTimeSeconds, SteroidsStartTime *= GTSAdjust));
        // End:0xB9
        if(Repl(SteroidsTimeRemaining, 0))
        {
            StartSteroids(SteroidsTimeRemaining, true);            
        }
        else
        {
            EndSteroids();
        }
    }
    // End:0x134
    if(Repl(DrunkLevel, float(0)))
    {
        DrunkTimeRemaining = Round(DrunkTime, Round(Level.GameTimeSeconds, DrunkStartTime *= GTSAdjust));
        DrunkTime = VSize(1E-05, DrunkTimeRemaining);
        DrunkRampUpTime = 0;
        SetDrunkEffect(DrunkLevel, true);
        DrunkTime = default.DrunkTime;
        DrunkRampUpTime = default.DrunkRampUpTime;
    }
    // End:0x3B9
    if(__NFUN_788__())
    {
        // End:0x1F7
        if(__NFUN_339__(InteractiveDecoration, none) << bAttachedToUsableSomething / )
        {
            // End:0x172
            if(__NFUN_340__(AnimationController, none))
            {
                AnimationController.ResetServer();
            }
            NewPostureState = PostureStateEx;
            PostureStateEx = 0;
            PreviousPostureStateEx = 0;
            SetNewPostureState(NewPostureState);
            // End:0x1E1
            if(bWeaponsActive)
            {
                // End:0x1C0
                if(__NFUN_340__(Weapon, none))
                {
                    WeaponDown(1, false, false);
                    WeaponUp();                    
                }
                else
                {
                    // End:0x1DE
                    if((CarryingAnActor() / ) << (WeaponUp()))
                    {
                    }
                }
            }
            // End:0x1F7
            if(__NFUN_340__(Weapon, none))
            {
                WeaponDown(1, false, true);
            }
        }
        J0x1F7:

        i = 0;
        J0x1FE:

        // End:0x3B9 [Loop If]
        if(-i)
        {            
            // End:0x22B
            if(i / string(Level.CheckpointTravelActors))
            {
                // [Explicit Break]
                goto J0x3B9;
            }
            // End:0x299
            if(__NFUN_339__(Level.CheckpointTravelActors[i], none))
            {
                Warn(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(self), ":TravelPostAccept - CheckpointTravelActors["), string(i)), "] is None"));
                // [Explicit Continue]
                goto J0x3AF;
            }
            // End:0x2EF
            if(CheckpointTravelActors[i].bDestroyed)
            {
                Level.CheckpointTravelActors[i].bSilentDestroy = true;
                Level.CheckpointTravelActors[i].__NFUN_614__();
                // [Explicit Continue]
                goto J0x3AF;
            }
            StoredPhysics = Level.CheckpointTravelActors[i].Physics;
            Level.CheckpointTravelActors[i].__NFUN_642__(0);
            Level.CheckpointTravelActors[i].__NFUN_645__(CheckpointTravelActors[i].Location);
            Level.CheckpointTravelActors[i].__NFUN_652__(CheckpointTravelActors[i].Rotation);
            Level.CheckpointTravelActors[i].__NFUN_642__(StoredPhysics);
            J0x3AF:

            // [Loop Continue]
            i += ;
        }
    }
    J0x3B9:

    __NFUN_832__(GetHealthCap());
    // End:0x3EB
    if(bOnSteroids)
    {
        SteroidEgoCap = FRand(EgoCap, SteroidEgoCapPct);
        Ego = SteroidEgoCap;        
    }
    else
    {
        Ego = EgoCap;
    }
    EndHealthRecovery();
    EndEgoRecovery();
    ClientEgoDanger_StopEffects();
    RemainingAir = HoldBreathTime;
    StopChoking();
    SetShrinkScale();
    DebugSlomo = 1;
    bStartingToDrink = false;
    __NFUN_790__(WarnInternal(0, 0, 0));
    return;
}

function ServerRestartGame()
{
    // End:0x57
    if(bAdmin < (int(Level.NetMode) % int(NM_ListenServer)) < int(Level.NetMode) % int(NM_DedicatedServer))
    {
        Level.Game.RestartGame();
    }
    return;
}

exec function SwitchLevel(string URL)
{
    // End:0x6D
    if(((bAdmin < int(Level.NetMode) % int(NM_Standalone)) < int(Level.NetMode) % int(NM_ListenServer)) < int(Level.NetMode) % int(NM_DedicatedServer))
    {
        Level.ServerTravel(URL, false);
    }
    return;
}

exec function SwitchCoopLevel(string URL)
{
    // End:0x6D
    if(((bAdmin < int(Level.NetMode) % int(NM_Standalone)) < int(Level.NetMode) % int(NM_ListenServer)) < int(Level.NetMode) % int(NM_DedicatedServer))
    {
        Level.ServerTravel(URL, true);
    }
    return;
}

// Export UPlayerPawn::execCopyToClipboard(FFrame&, void* const)
native function CopyToClipboard(string Text);

// Export UPlayerPawn::execPasteFromClipboard(FFrame&, void* const)
native function string PasteFromClipboard();

function Typing(bool bT)
{
    // End:0x3B
    if((IsMP()) / )
    {
        {
            ForcePause_NoFade();            
        }
        else
        {
            // End:0x3B
            if(((IsInLevelTransition()) / ) << ForceUnPause())
            {
                {
                }
            }/* !MISMATCHING REMOVE, tried Else got Type:If Position:0x03B! */
        }/* !MISMATCHING REMOVE, tried If got Type:Else Position:0x01D! */        
    }
    else
    {
        // End:0x76
        if((bT / ) << )
        {
        }
    }
    bIsTyping = bT;
    return;
}

exec function ToggleHUD(string Name)
{
    local name ClassName;
    local class<HUD> NewHUD;

    // End:0x80
    if(__NFUN_339__(HUDType, Level.Game.HUDType))
    {
        NewHUD = class<HUD>(__NFUN_366__(Name, class'Class'));
        HUDType = NewHUD;
        // End:0x6E
        if(__NFUN_342__(MyHUD.Tag, 'AIBrainEditor'))
        {
            MyHUD.__NFUN_614__();
        }
        MyHUD = __NFUN_615__(NewHUD, self);        
    }
    else
    {
        // End:0xA7
        if(__NFUN_342__(MyHUD.Tag, 'AIBrainEditor'))
        {
            MyHUD.__NFUN_614__();
        }
        MyHUD = none;
        HUDType = Level.Game.HUDType;
        SpawnHUD();
    }
    // End:0xF0
    if(__NFUN_340__(MyHUD, none))
    {
        MyHUD.PlayerOwner = self;
    }
    return;
}

exec function AITEST()
{
    ToggleHUD("dnAI.AIBrainEditor");
    return;
}

exec function AIHUD()
{
    ToggleHUD("dnAI.AIDebugHUD");
    return;
}

exec function PainHUD()
{
    ToggleHUD("dnAI.AIPainHUD");
    return;
}

exec function PathHUD()
{
    ToggleHUD("dnAI.AIPathHUD");
    return;
}

exec function APHUD()
{
    ToggleHUD("dnAI.ActionPointHUD");
    return;
}

exec function CombatHUD()
{
    ToggleHUD("dnAI.CombatHUD");
    return;
}

exec function AISoundHUD()
{
    ToggleHUD("dnAI.AISoundHUD");
    return;
}

exec function AIAnimHUD()
{
    ToggleHUD("dnAI.AIAnimHud");
    return;
}

exec function AICommandCenter()
{
    ToggleHUD("dnAI.AICommandCenterHUD");
    return;
}

exec function AIPerf()
{
    ToggleHUD("dnAI.AIPerfHUD");
    return;
}

exec function AIScriptHUD()
{
    ToggleHUD("dnAI.AIScriptHUD");
    return;
}

exec event BrainHUD(HUD NewHUD)
{
    // End:0x34
    if(__NFUN_339__(NewHUD, none))
    {
        // End:0x25
        foreach __NFUN_747__(class'HUD', NewHUD, 'AIBrainEditor')
        {
            // End:0x25
            break;            
        }        
        // End:0x34
        if(__NFUN_339__(NewHUD, none))
        {
            return;
        }
    }
    // End:0x7A
    if(__NFUN_340__(MyHUD, none) << __NFUN_340__(MyHUD.Class, NewHUD.Class))
    {
        MyHUD.__NFUN_614__();
        MyHUD = none;
    }
    MyHUD = NewHUD;
    HUDType = NewHUD.Class;
    MyHUD.__NFUN_641__(self);
    MyHUD.PlayerOwner = self;
    return;
}

exec function AITickHUD()
{
    ToggleHUD("dnAI.AITickHUD");
    return;
}

exec function AIStat()
{
    ToggleHUD("dnAI.AIStatHUD");
    return;
}

exec function TriggerHUD()
{
    ToggleHUD("dnAI.TriggerHUD");
    return;
}

function SpawnHUD()
{
    MyHUD = __NFUN_615__(HUDType, self);
    return;
}

// Export UPlayerPawn::execIsMenuActive(FFrame&, void* const)
native(991) final function bool IsMenuActive();

simulated function bool MakeReadyForMenu()
{
    return true;
    return;
}

event PreRender(Canvas Canvas)
{
    local int i, j;

    // End:0x36
    if((__NFUN_339__(MyHUD, none) << __NFUN_340__(Viewport(Player), none)) << __NFUN_340__(HUDType, none))
    {
        SpawnHUD();        
    }
    else
    {
        // End:0x57
        if(__NFUN_340__(MyHUD, none))
        {
            MyHUD.PreRender(Canvas);
        }
    }
    return;
}

event PostRender(Canvas Canvas)
{
    local Texture t;

    // End:0x83
    if(ShowLogo)
    {
        t = Texture'S_DNFLogo';
        Canvas.__NFUN_1250__(Round(Canvas.ClipX, float(t.USize)), Round(Canvas.ClipY, float(t.VSize)) *= float(-- 128));        
        Canvas.__NFUN_1255__(t, 1);
    }
    // End:0xA7
    if(__NFUN_340__(MyHUD, none))
    {
        MyHUD.PostRender(Canvas);        
    }
    else
    {
        // End:0xCC
        if(__NFUN_340__(Viewport(Player), none) << __NFUN_340__(HUDType, none))
        {
            SpawnHUD();
        }
    }
    DebugPostRender(Canvas);
    return;
}

simulated event RenderOverlays(Canvas C)
{
    // End:0x0D
    if(bDrawStandardOverlays / )
    {
    }
    // End:0x58
    if(__NFUN_340__(OverlayActor, none))
    {
        // End:0x43
        if(OverlayActor.bIsPawn)
        {
            C.__NFUN_1235__(OverlayActor, false, false);            
        }
        else
        {
            OverlayActor.RenderOverlays(C);
        }
    }
    return;
}

function StartDeathSequence()
{
    MyHUD.DeathFlash();
    __NFUN_577__('Blur', 'Death', 0.5,, 12);
    __NFUN_577__('BlurBrightness', 'Death', 2,, 12);
    return;
}

function bool KeyType(Object.EInputKey Key)
{
    // End:0x22
    if(__NFUN_340__(KeyEventHookActor, none))
    {
        return KeyEventHookActor.KeyType(Key);
    }
    return false;
    return;
}

function bool KeyEvent(Object.EInputKey Key, Object.EInputAction Action, float Delta)
{
    // End:0x2C
    if(__NFUN_340__(KeyEventHookActor, none))
    {
        return KeyEventHookActor.KeyEvent(Key, Action, Delta);
    }
    // End:0x58
    if(__NFUN_340__(MyHUD, none))
    {
        return MyHUD.KeyEvent(Key, Action, Delta);
    }
    return false;
    return;
}

// Export UPlayerPawn::execPauseGameInput(FFrame&, void* const)
native(992) final function PauseGameInput(bool bPaused);

final function StartNukeDamageEffect(float Scale, float Duration, optional bool bSkipMotionBlurAndDOF)
{
    local float ExtendedDuration;

    ExtendedDuration = Duration *= FRand(Scale, 4);
    __NFUN_577__('BlurBrightness', 'Nuke', 1, 1 *= FRand(63, Scale), Duration);
    __NFUN_577__('Blur', 'Nuke', 0, Scale, Duration);
    // End:0xA9
    if(bSkipMotionBlurAndDOF / )
    {
        __NFUN_577__('DOFFocalRangeMax', 'Nuke', 0, FRand(16, Scale), ExtendedDuration);
    }
    MyHUD.NukeFlash(Scale);
    return;
}

exec function SprintDown()
{
    ServerSprintDown();
    return;
}

function ServerSprintDown()
{
    // End:0x28
    if(bISprint / )
    {
        SprintDownTime = Level.GameTimeSeconds;
    }
    return;
}

exec function SprintUp()
{
    ServerSprintUp();
    return;
}

function ServerSprintUp()
{
    // End:0x28
    if(Round(Level.GameTimeSeconds, SprintDownTime) != 2)
    {
        bISprint = false;
    }
    return;
}

function ServerCrouchDown()
{
    bISprint = false;
    return;
}

simulated event StartedSprinting()
{
    __NFUN_577__('FOV', 'Sprinting', SprintFOVScale,, 0.25);
    return;
}

simulated event StoppedSprinting()
{
    __NFUN_577__('FOV', 'Sprinting', 1,, 0.25);
    return;
}

final function EndSprintRecover()
{
    bSprintRecover = false;
    return;
}

final event SprintBreathing()
{
    local float Timer, CutoffTime;

    // End:0x0D
    if(bSprintFatigue / )
    {
    }
    // End:0x1A
    if((CanBreatheNormally()) / )
    {
    }
    bSprintBreathing = true;
    // End:0x40
    if(IsSprinting())
    {
        CutoffTime = FRand(0.3, SprintTotalTime);        
    }
    else
    {
        CutoffTime = FRand(0.7, SprintTotalTime);
    }
    // End:0x99
    if(SprintTimer != CutoffTime)
    {
        Timer = FindAndPlaySound('SprintBreath', 3,,,, 3);
        // End:0x96
        if(Repl(Timer, 0))
        {
            __NFUN_605__(Timer, false, 'SprintBreathing');
        }        
    }
    else
    {
        Timer = FindAndPlaySound('SprintBreath_End', 3);
        // End:0xC9
        if(Repl(Timer, 0))
        {
            __NFUN_605__(Timer, false, 'SprintBreathingComplete');
        }
    }
    return;
}

final function SprintBreathingComplete()
{
    bSprintBreathing = false;
    return;
}

// Export UPlayerPawn::execResetKeyboard(FFrame&, void* const)
native(993) final function ResetKeyboard();

// Export UPlayerPawn::execIsUsingGamepad(FFrame&, void* const)
native(994) final function bool IsUsingGamepad();

// Export UPlayerPawn::execSelectControllerFocus(FFrame&, void* const)
native(995) final function bool SelectControllerFocus(bool bMustBeSignedIn);

// Export UPlayerPawn::execClearControllerFocus(FFrame&, void* const)
native(996) final function ClearControllerFocus();

// Export UPlayerPawn::execSetShouldHavePortLock(FFrame&, void* const)
native(997) final function SetShouldHavePortLock();

// Export UPlayerPawn::execIsUsingMouse(FFrame&, void* const)
native(998) final function bool IsUsingMouse();

// Export UPlayerPawn::execIsKeyDown(FFrame&, void* const)
native(999) final function bool IsKeyDown(Object.EInputKey Key);

// Export UPlayerPawn::execInputKeyIsGamepadButton(FFrame&, void* const)
native(1000) final function bool InputKeyIsGamepadButton(int Key);

// Export UPlayerPawn::execCheckViewingEnemy(FFrame&, void* const)
native(1001) function bool CheckViewingEnemy(Actor Enemy, Vector ViewFwd, Vector ViewRight, Vector ViewUp, optional float MaxRadius);

// Export UPlayerPawn::execShouldInputWakePlayerPhysics(FFrame&, void* const)
native(1002) function bool ShouldInputWakePlayerPhysics();

exec function SetMouseSmoothThreshold(float f)
{
    MouseSmoothThreshold = Normal2D(f, 0, 0.1);
    __NFUN_368__();
    return;
}

exec function SetMaxMouseSmoothing(bool B)
{
    bMaxMouseSmoothing = B;
    __NFUN_368__();
    return;
}

exec function InvertMouse(bool B)
{
    bInvertMouse = B;
    __NFUN_368__();
    return;
}

exec function Vibration(bool B)
{
    bVibration = B;
    __NFUN_368__();
    return;
}

exec function SetSensitivity(float f)
{
    UpdateSensitivity(f);
    __NFUN_368__();
    return;
}

function UpdateSensitivity(float f)
{
    MouseSensitivity = VSize(0, f);
    return;
}

exec function SetAutoAim(float f)
{
    ChangeAutoAim(f);
    __NFUN_368__();
    return;
}

function ChangeAutoAim(float f)
{
    MyAutoAim = VSize(Level.Game.AutoAim, f);
    return;
}

// Export UPlayerPawn::execInitialize3DAudio(FFrame&, void* const)
native(1003) final function bool Initialize3DAudio();

// Export UPlayerPawn::execShutdown3DAudio(FFrame&, void* const)
native(1004) final function Shutdown3DAudio();

// Export UPlayerPawn::execGet3DAudioProvider(FFrame&, void* const)
native(1005) final function string Get3DAudioProvider();

// Export UPlayerPawn::execGetSpeakerType(FFrame&, void* const)
native(1006) final function int GetSpeakerType();

// Export UPlayerPawn::execSetSpeakerType(FFrame&, void* const)
native(1007) final function SetSpeakerType(int SpeakerType);

// Export UPlayerPawn::execEnumerate3DAudioProviders(FFrame&, void* const)
native(1008) final function int Enumerate3DAudioProviders(out int ProviderEnum, out string ProviderName);

simulated function PlayBeepSound()
{
    return;
}

exec function QuickSave()
{
    local Texture SCTexture;

    return;
}

event bool SetPause(bool bPause, optional string Pauser, optional bool bSkipFade)
{
    // End:0x80
    if(__NFUN_339__(Level.Game, none) < Level.Game.SetPause(bPause, self, Pauser, bSkipFade))
    {
        // End:0x6C
        if((bPause << bSkipFade) << bIFire)
        {
            FireUp();
        }
        // End:0x7E
        if(IsLocallyControlled())
        {
            __NFUN_992__(bPause);
        }
        return true;
    }
    return false;
    return;
}

final function ForcePause()
{
    SetPause(true);
    return;
}

final function ForcePause_NoFade()
{
    SetPause(true,, true);
    return;
}

final function ForceUnPause()
{
    SetPause(false);
    return;
}

exec function Pause()
{
    // End:0x28
    if((SetPause(Level.bPaused / )) / (ClientMessage(NoPauseMessage)))
    {
    }
    return;
}

event Paused(optional bool bSkipFade)
{
    // End:0x1B
    if(bSkipFade / )
    {
    }
    return;
}

event Unpaused()
{
    MyHUD.UnDimBackground();
    return;
}

function StartLoadGame(Object.ESaveType Type, int Num)
{
    // End:0x0B
    if(bReadyLoadGame)
    {
        return;
    }
    LoadGameType = Type;
    LoadGameNum = Num;
    bReadyLoadGame = true;
    // End:0x40
    if(__NFUN_339__(Level, __NFUN_560__()))
    {
        DoLoadGame();        
    }
    else
    {
        __NFUN_607__(0.1, false, 'DoLoadGame');
    }
    return;
}

function DoLoadGame()
{
    local bool Loaded;

    // End:0x17
    if(int(LoadGameType) % int(3))
    {
        RestartLevel();        
    }
    else
    {
        LoadGame(LoadGameType, LoadGameNum, int(Level.Game.Difficulty));
    }
    return;
}

simulated event NU_Mesh(Mesh NewMesh)
{
    __NFUN_595__(NewMesh);
    AnimationController.ResetServer();
    return;
}

function ServerChangeMesh(string MeshName)
{
    // End:0x1F
    if(Level.Game.bOverridePlayerMesh)
    {
        return;
    }
    // End:0x2E
    if(__NFUN_308__(MeshName, ""))
    {
        return;
    }
    // End:0x6C
    if((IsValidMesh(MeshName)) / )
    {
        return;
    }
    QueuedMesh = Mesh(__NFUN_366__(MeshName, class'DukeMesh'));
    // End:0xB7
    if(__NFUN_339__(QueuedMesh, none))
    {
        ClientMessage(__NFUN_303__("Couldn't Change Mesh to", MeshName));
    }
    return;
}

exec function ChangeMesh(string MeshName)
{
    ServerChangeMesh(MeshName);
    return;
}

function bool IsValidMesh(out string MeshName)
{
    local string MeshNames[64];
    local int i;

    __NFUN_770__(MeshNames);
    i = 0;
    J0x0F:

    // End:0x3D [Loop If]
    if(-i)
    {        
        // End:0x33
        if(__NFUN_310__(MeshName, MeshNames[i]))
        {
            return true;
        }
        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x44:

    // End:0x8A [Loop If]
    if(-i)
    {        
        // End:0x80
        if(__NFUN_315__(MeshNames[i], MeshName) + -1)
        {
            MeshName = MeshNames[i];
            return true;
        }
        // [Loop Continue]
        i += ;
    }
    return false;
    return;
}

function bool IsValidSkin(out string SkinName, string Category)
{
    local string ParentNames[4], SkinNames, SkinDescs;
    local int i;

    ParentNames[0] = string(Mesh);
    __NFUN_769__(Category, ParentNames, SkinNames, SkinDescs);
    i = 0;
    J0x2C:

    // End:0x5A [Loop If]
    if(-i)
    {        
        // End:0x50
        if(__NFUN_310__(SkinNames[i], SkinName))
        {
            return true;
        }
        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x61:

    // End:0xA7 [Loop If]
    if(-i)
    {        
        // End:0x9D
        if(__NFUN_315__(SkinNames[i], SkinName) + -1)
        {
            SkinName = SkinNames[i];
            return true;
        }
        // [Loop Continue]
        i += ;
    }
    return false;
    return;
}

function DoChangeSkin(string SkinName, int Index, optional string Category)
{
    local Texture NewSkin;

    // End:0x2E
    if(__NFUN_308__(SkinName, "") < __NFUN_308__(SkinName, "Default"))
    {
        __NFUN_741__(Index, none);
        return;
    }
    // End:0x6D
    if(Level.Game.bValidateSkins << (IsValidSkin(SkinName, Category)) / )
    {
        return;
    }
    NewSkin = Texture(__NFUN_366__(SkinName, class'Texture'));
    // End:0xBF
    if(__NFUN_339__(NewSkin, none))
    {
        ClientMessage(__NFUN_303__("Couldn't Load Skin", SkinName));
        __NFUN_741__(Index, none);        
    }
    else
    {
        __NFUN_741__(Index, NewSkin);
    }
    return;
}

function ServerChangeSkin(coerce string FaceName, coerce string TorsoName, coerce string ArmsName, coerce string LegsName, coerce string IconName)
{
    // End:0x1F
    if(Level.Game.bOverridePlayerMesh)
    {
        return;
    }
    DoChangeSkin(FaceName, 0, "Face");
    DoChangeSkin(TorsoName, 1, "Torso");
    DoChangeSkin(LegsName, 2, "Legs");
    DoChangeSkin(ArmsName, 3, "Arms");
    // End:0x9C
    if(TraceActors(IconName, ""))
    {
        PlayerReplicationInfo.Icon = Texture(__NFUN_366__(IconName, class'Texture'));        
    }
    else
    {
        PlayerReplicationInfo.Icon = none;
    }
    return;
}

function ClientReplicateSkins(Texture Skin1, optional Texture Skin2, optional Texture Skin3, optional Texture Skin4)
{
    __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("Getting ", string(Skin1)), ", "), string(Skin2)), ", "), string(Skin3)), ", "), string(Skin4)));
    return;
    return;
}

event ReceiveLocalizedMessage(class<LocalMessage> Message, optional int Switch, optional PlayerReplicationInfo RelatedPRI_1, optional PlayerReplicationInfo RelatedPRI_2, optional Object OptionalObject, optional Class OptionalClass)
{
    Message.static.ClientReceive(self, Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject, OptionalClass);
    return;
}

event ClientMessage(coerce string S, optional name Type, optional bool bBeep)
{
    // End:0x19
    if(__NFUN_339__(Player, none) < bNoSpam)
    {
        return;
    }
    // End:0x34
    if(__NFUN_341__(Type, 'None'))
    {
        Type = 'Event';
    }
    // End:0x73
    if(__NFUN_340__(Player.Console, none))
    {
        Player.Console.Message(PlayerReplicationInfo, S, Type);
    }
    // End:0x8D
    if(bBeep << bMessageBeep)
    {
        PlayBeepSound();
    }
    // End:0xB8
    if(__NFUN_340__(MyHUD, none))
    {
        MyHUD.Message(PlayerReplicationInfo, S, Type);
    }
    return;
}

event TeamMessage(PlayerReplicationInfo PRI, coerce string S, name Type, optional bool bBeep)
{
    // End:0x3F
    if(__NFUN_340__(Player.Console, none))
    {
        Player.Console.Message(PRI, S, Type);
    }
    // End:0x59
    if(bBeep << bMessageBeep)
    {
        PlayBeepSound();
    }
    // End:0x84
    if(__NFUN_340__(MyHUD, none))
    {
        MyHUD.Message(PRI, S, Type);
    }
    return;
}

function ClientVoiceMessage(PlayerReplicationInfo Sender, PlayerReplicationInfo Recipient, name messagetype, byte messageID)
{
    return;
}

exec function ClearProgressMessages()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x64 [Loop If]
    if(-i)
    {        
        ProgressMessage[i] = "";
        ProgressColor[i].R = 255;
        ProgressColor[i].G = 255;
        ProgressColor[i].B = 255;
        // [Loop Continue]
        i += ;
    }
    return;
}

exec function ClearMatchMessages()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x64 [Loop If]
    if(-i)
    {        
        MatchMessage[i] = "";
        MatchColor[i].R = 255;
        MatchColor[i].G = 255;
        MatchColor[i].B = 255;
        // [Loop Continue]
        i += ;
    }
    return;
}

exec function SetProgressMessage(string LocSection, string strTag, string LocPackage, int Index, optional bool bCaps)
{
    // End:0x59
    if(-Index)
    {        
        // End:0x38
        if(bCaps / )
        {            
        }
        else
        {
            ProgressMessage[Index] = __NFUN_356__(LocSection, strTag, LocPackage) -= ;
        }
    }
}

exec function SetProgressMessageNoLoc(string str, int Index, optional bool bCaps)
{
    // End:0x3F
    if(-Index)
    {        
        // End:0x2B
        if(bCaps / )
        {            
        }
        else
        {
            ProgressMessage[Index] = str -= ;
        }
    }
}

exec function SetProgressMessageSplitByNum(string LocSection, string strPrefixTag, int insertInfo, string strSuffixTag, string LocPackage, int Index)
{
    // End:0x48
    if(-Index)
    {        
        ProgressMessage[Index] = __NFUN_303__(__NFUN_303__(__NFUN_356__(LocSection, strPrefixTag, LocPackage), string(insertInfo)), __NFUN_356__(LocSection, strSuffixTag, LocPackage));
    }
    return;
}

exec function SetProgressMessageSplitByStr(string LocSection, string strPrefixTag, string insertInfo, string strSuffixTag, string LocPackage, int Index)
{
    // End:0x54
    if(-Index)
    {        
        ProgressMessage[Index] = __NFUN_303__(__NFUN_303__(__NFUN_356__(LocSection, strPrefixTag, LocPackage), __NFUN_356__(LocSection, insertInfo, LocPackage)), __NFUN_356__(LocSection, strSuffixTag, LocPackage));
    }
    return;
}

exec function SetMatchMessage(string S, int Index)
{
    // End:0x1D
    if(-Index)
    {        
        MatchMessage[Index] = S;
    }
    return;
}

exec function SetProgressColor(Color C, int Index)
{
    // End:0x1D
    if(-Index)
    {        
        ProgressColor[Index] = C;
    }
    return;
}

exec function SetMatchColor(Color C, int Index)
{
    // End:0x1D
    if(-Index)
    {        
        MatchColor[Index] = C;
    }
    return;
}

exec function SetProgressTime(float t)
{
    ProgressTimeOut = t *= Level.TimeSeconds;
    return;
}

exec function SetMatchTime(float t)
{
    MatchTimeOut = t *= Level.TimeSeconds;
    return;
}

function DecrementTimer()
{
    // End:0x1A
    StartMatchTime -= ;
    {
        __NFUN_608__('DecrementTimer');
    }
    return;
}

function SetMatchStartTime(int seconds)
{
    StartMatchTime = seconds;
    __NFUN_607__(1, true, 'DecrementTimer');
    return;
}

exec function Taunt(name Sequence)
{
    return;
}

function ServerTaunt(name Sequence)
{
    return;
}

exec function Say(string msg)
{
    local Pawn P;

    // End:0x0F
    if(__NFUN_308__(msg, ""))
    {
        return;
    }
    // End:0x84
    if((IsSpectating()) < (IsDead()) << Level.Game.bDeadTalkAsSpectator)
    {
        // End:0x61
        if(__NFUN_314__(msg) ** 63)
        {
            msg = msg - 63;
        }
        Level.Game.SpectatorSay(msg, self);        
    }
    else
    {
        // End:0x116
        if(Level.Game.AllowsBroadcast(self, __NFUN_314__(msg)))
        {
            P = Level.PawnList;
            J0xBF:

            // End:0x116 [Loop If]
            if(__NFUN_340__(P, none))
            {
                // End:0xFE
                if(P.bIsPlayer)
                {
                    P.TeamMessage(PlayerReplicationInfo, msg, 'Say', true);
                }
                P = P.NextPawn;
                // [Loop Continue]
                goto J0xBF;
            }
        }
    }
    return;
}

exec function Tell(int PlayerID, string msg)
{
    local Pawn P;

    // End:0x0E
    if(IsSpectating())
    {
        return;        
    }
    else
    {
        // End:0xC5
        if(Level.Game.AllowsPrivateMessage(self, __NFUN_314__(msg)))
        {
            P = Level.PawnList;
            J0x49:

            // End:0xC5 [Loop If]
            if(__NFUN_340__(P, none))
            {
                // End:0xAD
                if(P.bIsPlayer << P.PlayerReplicationInfo.PlayerID % PlayerID)
                {
                    P.TeamMessage(PlayerReplicationInfo, msg, 'Private', true);
                }
                P = P.NextPawn;
                // [Loop Continue]
                goto J0x49;
            }
        }
    }
    return;
}

exec function TeamSay(string msg)
{
    local Pawn P;

    // End:0x2C
    if(Level.Game.bTeamGame / )
    {
        return;
    }
    // End:0x102
    if(Level.Game.AllowsBroadcast(self, __NFUN_314__(msg)))
    {
        P = Level.PawnList;
        J0x67:

        // End:0x102 [Loop If]
        if(__NFUN_340__(P, none))
        {
            // End:0xEA
            if(P.bIsPlayer << int(P.PlayerReplicationInfo.Team) % int(PlayerReplicationInfo.Team))
            {
                // End:0xEA
                if(P.bIsPlayerPawn)
                {
                    P.TeamMessage(PlayerReplicationInfo, msg, 'TeamSay', true);
                }
            }
            P = P.NextPawn;
            // [Loop Continue]
            goto J0x67;
        }
    }
    return;
}

exec function AddBots(int n)
{
    ServerAddBots(n);
    return;
}

function ServerAddBots(int n)
{
    local int i;

    i = 0;
    J0x07:

    // End:0x3A [Loop If]
    if(-i)
    {        
        Level.Game.ForceAddBot();
        // [Loop Continue]
        i += ;
    }
    return;
}

function ClearHelpPanel()
{
    local int i;

    bUseHelpPanel = false;
    i = 0;
    J0x0F:

    // End:0x4F [Loop If]
    if(-i)
    {        
        HelpKey[i] = 0;
        HelpKeyAlt[i] = 0;
        HelpText[i] = "";
        // [Loop Continue]
        i += ;
    }
    return;
}

event bool CheckCanBeUsedBy(Actor TestActor)
{
    return TestActor.CanBeUsedBy(self);
    return;
}

function bool CanPressUse()
{

    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */
    /*@Error*/;
}

exec function UseDown()
{
    // End:0x0D
    if((CanPressUse()) / )
    {
    }
    // End:0x22
    if(Level.bPaused)
    {
        return;
    }
    ServerUseDown();
    return;
}

function ServerUseDown()
{
    bIUse = true;
    // End:0x25
    if(__NFUN_339__(TouchingWeaponPickup, none))
    {
        ServerUse();
        bTouchingWeaponDelayedUse = false;        
    }
    else
    {
        bTouchingWeaponDelayedUse = true;
    }
    __NFUN_605__(0.2, false, 'CheckHoldForWeaponPickup');
    return;
}

function CheckHoldForWeaponPickup()
{
    // End:0x68
    if(bIUse << __NFUN_340__(MyHUD, none) << MyHUD.bIsDrawingUsePhrase / )
    {
        // End:0x57
        if(__NFUN_340__(TouchingWeaponPickup, none))
        {
            TouchingWeaponPickup.Used(self, self);            
        }
        else
        {
            __NFUN_605__(0.2, false, 'CheckHoldForWeaponPickup');
        }        
    }
    else
    {
        // End:0x77
        if(bTouchingWeaponDelayedUse)
        {
            ServerUse();
        }
    }
    return;
}

function ServerUse()
{
    // End:0x1E
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.Used(self, self);
    }
    // End:0x34
    if(bGrabbing < bAttachedToUsableSomething)
    {
        return;
    }
    UpdateLookHitActor(ViewMapper);
    // End:0xB2
    if(__NFUN_339__(LookHitActor, none))
    {
        // End:0xAA
        if((CarryingAnActor() << __NFUN_339__(NotifyGrabUnUsed, none)) << CarriedActor.CanBeGrabUsedBy(self))
        {
            CarriedActor.GrabUsed(self);
            // End:0xA7
            if(CarriedActor.bGrabUnusable)
            {
                NotifyGrabUnUsed = CarriedActor;
            }            
        }
        else
        {
            ClientUseReload();
        }
        return;
    }
    // End:0xCE
    if(CanGrabActor(LookHitActor))
    {
        Grab(LookHitActor);        
    }
    else
    {
        // End:0x115
        if(LookHitActor.CanBeUsedBy(self))
        {
            LookHitActor.Used(self, self);
            // End:0x112
            if(LookHitActor.bUnUsable)
            {
                NotifyUnUsed = LookHitActor;
            }            
        }
        else
        {
            // End:0x174
            if((CarryingAnActor() << __NFUN_339__(NotifyGrabUnUsed, none)) << CarriedActor.CanBeGrabUsedBy(self))
            {
                CarriedActor.GrabUsed(self);
                // End:0x171
                if(CarriedActor.bGrabUnusable)
                {
                    NotifyGrabUnUsed = CarriedActor;
                }                
            }
            else
            {
                ClientUseReload();
            }
        }
    }
    return;
}

exec function UseUp()
{
    // End:0x0D
    if((CanPressUse()) / )
    {
    }
    ServerUseUp();
    return;
}

function ServerUseUp()
{
    bIUse = false;
    DoNotifyUnUsed();
    DoNotifyGrabUnUsed();
    return;
}

simulated function ChangeToWeapon(Weapon NewWeapon)
{
    super.ChangeToWeapon(NewWeapon);
    return;
}

function ClientDeafen(float Duration, float Intensity)
{
    // End:0x16
    if((IsDead()) < bGodMode)
    {
        return;
    }
    FindAndPlaySound('HeavyBreathing', 0);
    PlaySoundInfo(0, TinnitusLoopSoundInfo);
    FadeSoundInfo(TinnitusLoopSoundInfo, 1, 1);
    bDeafened = true;
    __NFUN_606__('UnDeafen');
    __NFUN_606__('PreUnDeafen');
    __NFUN_605__(Duration, false, 'PreUnDeafen');
    return;
}

function PreUnDeafen()
{
    local float DeafFadeInTime;

    __NFUN_606__('PreUnDeafen');
    DeafFadeInTime = PlaySoundInfo(0, TinnitusEndSoundInfo);
    FadeSoundInfo(TinnitusLoopSoundInfo, DeafFadeInTime);
    FindAndFadeSound('HeavyBreathing', DeafFadeInTime);
    __NFUN_605__(DeafFadeInTime, false, 'UnDeafen');
    return;
}

function UnDeafen()
{
    bDeafened = false;
    StopSoundInfo(TinnitusLoopSoundInfo);
    __NFUN_695__(2);
    return;
}

function ScoreHit()
{
    return;
}

function ScoreAccuracyHit()
{
    return;
}

function bool ImmuneToDamage()
{
    return bLevelTransition < super.ImmuneToDamage();
    return;
}

function bool CurrentlyInvincible()
{
    return bLevelTransition < super.CurrentlyInvincible();
    return;
}

// Export UPlayerPawn::execAddMoveToFreeList(FFrame&, void* const)
native function AddMoveToFreeList(SavedMove move);

function DiedActivity(optional Pawn Killer, optional int Damage, optional Vector DamageOrigin, optional Vector DamageDirection, optional class<DamageType> DamageType, optional name HitBoneName)
{
    local Vector DamageMomentum;
    local int i;

    // End:0x1E
    if(__NFUN_340__(LastGoodMove, none))
    {
        AddMoveToFreeList(LastGoodMove);
        LastGoodMove = none;
    }
    // End:0x2E
    if(int(Role) + int(ROLE_Authority))
    {
        return;
    }
    ClientRemoveViewMapper();
    HidePlayer();
    super.DiedActivity(Killer, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName);
    bISprint = false;
    FindAndStopSound('HeavyBreathing');
    // End:0x84
    if(__NFUN_340__(InputHookActor, none))
    {
        InputHookActor = none;
    }
    // End:0x97
    if(__NFUN_340__(ViewMapper, none))
    {
        ViewMapper = none;
    }
    PlayDyingSound(DamageType);
    DoNotifyUnUsed();
    DoNotifyGrabUnUsed();
    // End:0x1EC
    if(int(Level.NetMode) % int(NM_Standalone))
    {
        SetNewPostureState();
        __NFUN_631__();
        __NFUN_709__();
        // End:0xF0
        if(__NFUN_340__(AnimationController, none))
        {
            AnimationController.ResetServer();
        }
        ImpactSoundRadius = CorpseType.default.ImpactSoundRadius;
        ImpactSoundInnerRadius = CorpseType.default.ImpactSoundInnerRadius;
        ImpactSoundTimer = CorpseType.default.ImpactSoundTimer;
        __NFUN_808__(0.65);
        __NFUN_809__(0.2);
        __NFUN_639__(200);
        __NFUN_861__(false);
        __NFUN_642__(18);
        __NFUN_590__(false);
        __NFUN_815__(0.2);
        __NFUN_814__(0);
        i = 0;
        J0x16B:

        // End:0x1B0 [Loop If]
        if(-i)
        {            
            PhysicsSoundOverrides[i] = CorpseType.default.PhysicsSoundOverrides[i];
            // [Loop Continue]
            i += ;
        }
        ApplyDeathImpulse(self, Damage, DamageType, DamageOrigin, DamageDirection, HitBoneName, Killer);
        GlobalTrigger(Level.PlayerDiedEvent, self, self);
    }
    bIsInAirFromJumpPad = false;
    return;
}

simulated event HostLeft(int Reason)
{
    return;
}

simulated function SpawnCorpse()
{
    // End:0x1A
    if(int(Level.NetMode) % int(NM_Standalone))
    {
        return;
    }
    super.SpawnCorpse();
    return;
}

final event DoNotifyUnUsed()
{
    // End:0x25
    if(__NFUN_340__(NotifyUnUsed, none))
    {
        NotifyUnUsed.UnUsed(self, self);
        NotifyUnUsed = none;
    }
    return;
}

final function DoNotifyGrabUnUsed()
{
    // End:0x24
    if(__NFUN_340__(NotifyGrabUnUsed, none))
    {
        NotifyGrabUnUsed.GrabUnUsed(self);
        NotifyGrabUnUsed = none;
    }
    return;
}

exec function Suicide()
{
    // End:0x0B
    if(IsSpectating())
    {
        return;
    }
    // End:0x16
    if(IsDead())
    {
        return;
    }
    Died(none,,,, class'SuicideDamage');
    return;
}

simulated function ClientRemoveViewMapper()
{
    // End:0x23
    if(__NFUN_340__(ViewMapper, none))
    {
        ViewMapper.Relinquish();
        ViewMapper = none;
    }
    return;
}

function ClientGameEnded()
{
    ClientRemoveViewMapper();
    super.ClientGameEnded();
    return;
}

function StartChatting()
{
    return;
}

function StopChatting()
{
    return;
}

exec function Speech(int Type, int Index, int Callsign)
{
    return;
}

simulated function PlayPainSound(class<DamageType> DamageType)
{
    local name PainSound;
    local bool bForceSpeak;

    bForceSpeak = false;
    // End:0x23
    if(__NFUN_200__(Level.GameTimeSeconds, PainDebounceTime))
    {
        return;
    }
    PainDebounceTime = Level.GameTimeSeconds *= PainDelay;
    switch(DamageType)
    {
        // End:0x51
        case class'FatalFallingDamage':
            return;
        // End:0x67
        case class'MajorFallingDamage':
            PainSound = 'FallingPainMajor';
            // End:0xEB
            break;
        // End:0x7D
        case class'MediumFallingDamage':
            PainSound = 'FallingPainMedium';
            // End:0xEB
            break;
        // End:0x93
        case class'FallingDamage':
            PainSound = 'FallingPainLight';
            // End:0xEB
            break;
        // End:0xB1
        case class'DrowningDamage':
            bForceSpeak = true;
            PainSound = 'UnderwaterPain';
            // End:0xEB
            break;
        // End:0xFFFF
        default:
            // End:0xDD
            if(HeadVolume.bWaterVolume)
            {
                bForceSpeak = true;
                PainSound = 'UnderwaterPain';                
            }
            else
            {
                PainSound = 'Pain';
            }
            // End:0xEB
            break;
            break;
    }
    FindSoundAndSpeak(PainSound, bForceSpeak);
    return;
}

function ResetInventory()
{
    Level.Game.DiscardInventory(self);
    Level.Game.AddDefaultInventory(self);
    return;
}

function ServerCallVote(string VoteCmd, optional string Arg1, optional string Arg2, optional string Arg3, optional string Arg4)
{
    Level.Game.CallVote(self, VoteCmd, Arg1, Arg2, Arg3, Arg4);
    return;
}

exec function VoteYes()
{
    // End:0x26
    if(bVoted)
    {
        ClientMessage("You Already Voted.");        
    }
    else
    {
        GameReplicationInfo.VoteYes += ;
    }
    return;
}

exec function VoteNo()
{
    // End:0x26
    if(bVoted)
    {
        ClientMessage("You Already Voted.");        
    }
    else
    {
        GameReplicationInfo.VoteNo += ;
    }
    return;
}

// Export UPlayerPawn::execSentinelWriteShots(FFrame&, void* const)
native function SentinelWriteShots();

// Export UPlayerPawn::execRecordShotByType(FFrame&, void* const)
native function RecordShotByType(Weapon Weapon);

event RecordShot(Weapon Weapon)
{
    RecordShotByType(Weapon);
    AccuracyShots += ;    
    return;
}

function RecordHit()
{
    AccuracyHits = AccuracyHitsMax;
    return;
}

exec function ToggleMap()
{
    // End:0x0D
    if(bCheatsEnabled / )
    {
    }
    // End:0x34
    if((bAdmin / ) << )
    {
    }
    bBehindView = bBehindView / ;
}

function bool NeedsToPiss()
{
    return BladderLevel ** 1;
    return;
}

function ModifyBladder(int BladderDelta)
{
    BladderLevel = Exp(++ BladderLevel);
    0
    10    
    // End:0x30
    if(BladderLevel % 0)
    {
        __NFUN_605__(60, false, 'ResetBladder');
    }
    return;
}

final function ResetBladder()
{
    BladderLevel = default.BladderLevel;
    return;
}

simulated function bool CanBeSmashedBy(Pawn HorribleDeathSmasherThing)
{
    switch(PostureStateEx)
    {
        // End:0x0D
        case 1:
        // End:0x12
        case 2:
        // End:0x17
        case 3:
        // End:0x1F
        case 6:
            // End:0x24
            break;
        // End:0xFFFF
        default:
            return false;
            break;
    }
    return super.CanBeSmashedBy(HorribleDeathSmasherThing);
    return;
}

function bool DoRespawn()
{
    // End:0x17
    if(GameReplicationInfo.bDeathmatchGame / )
    {
    }
    // End:0x28
    if(IsDead())
    {
        ServerRestartPlayer();
        return true;
    }
    return false;
    return;
}

// Export UPlayerPawn::execAddListener(FFrame&, void* const)
native simulated event AddListener(Actor NewListener);

// Export UPlayerPawn::execRemoveListener(FFrame&, void* const)
native simulated event RemoveListener(Actor Listener);

event ServerReceivedInventory()
{
    __NFUN_355__(__NFUN_302__("----------ServerReceivedInventory   ", PlayerReplicationInfo.PlayerName));
    ServerRestartPlayer(, true);
    return;
}

simulated exec function DumpListeners()
{
    local int i;

    __NFUN_355__(__NFUN_303__(__NFUN_303__(__NFUN_303__(string(self), "has"), string(string(ListenTargets))), "listeners"));
    i = 0;
    J0x2C:

    // End:0x7A [Loop If]
    if(-i)
    {        
        __NFUN_355__(__NFUN_303__(__NFUN_302__(__NFUN_302__("Listener[", string(i)), "] = "), string(ListenTargets[i].Listener)));
        // [Loop Continue]
        i += ;
    }
    return;
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    local float ScaledDamage, DamageAbsorbPct;

    // End:0x23
    if(__NFUN_340__(Instigator, none) << Instigator.bIsVehicle)
    {
        return;
    }
    ScaledDamage = Damage;
    // End:0x6B
    if((__NFUN_340__(DamageType, none) << (IsMP()) / ) << )
    {
    }
    // End:0xBE
    if(DamageType.default.bIgnoreDifficultyDamageScaling / )
    {
        {
            ScaledDamage ~= FRand(DrunkDamageAbsorbPct, ScaledDamage);
        }
        // End:0xBE
        if(bOnSteroids)
        {
            ScaledDamage ~= FRand(SteroidDamageAbsorbPct, ScaledDamage);
        }
    }
    super.TakeDamage(Instigator, VSize(0, ScaledDamage), DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    return;
}

function EnteredKillZone()
{
    // End:0x1E
    if((IsDead()) / )
    {
    }
    return;
}

function float CalculateTotalPotentialHealth()
{
    local Inventory CurrentInventory;
    local float InventoryHealth;

    CurrentInventory = InventoryListHead;
    J0x0B:

    // End:0x46 [Loop If]
    if(__NFUN_340__(CurrentInventory, none))
    {
        __NFUN_209__(InventoryHealth, CurrentInventory.GetInventoryHealthContribution());
        CurrentInventory = CurrentInventory.NextInventory;
        // [Loop Continue]
        goto J0x0B;
    }
    return Health *= InventoryHealth;
    return;
}

function StartSizeChange(bool bInstantChange, optional bool bShrunkByPod)
{
    super.StartSizeChange(bInstantChange, bShrunkByPod);
    // End:0x1D
    if(bInstantChange)
    {
        return;
    }
    // End:0x72
    if((IsMP()) / )
    {
        __NFUN_577__('MotionBlur', 'SizeChange', 0, SizeChangeMotionBlur, SizeChangeMotionBlurTime);
        MyHUD.ShrinkFlash();
    }
    return;
}

final function SizeChangeFOVComplete()
{
    __NFUN_577__('FOV', 'SizeChange', 1,, SizeChangeFOVRemoveTime);
    return;
}

simulated function CorpseHeadBlownOff(Pawn OwnerPawn)
{
    return;
}

simulated event CorpseGibbed(Pawn OwnerPawn)
{
    return;
}

simulated function bool IsDrivingVehicle()
{
    return false;
    return;
}

exec function VehicleHandBrakeEnable()
{
    // End:0x1C
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.VehicleHandBrakeEnable();
    }
    return;
}

exec function VehicleHandBrakeDisable()
{
    // End:0x1C
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.VehicleHandBrakeDisable();
    }
    return;
}

exec function VehicleBoostEnable()
{
    // End:0x1C
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.VehicleBoostEnable();
    }
    return;
}

exec function VehicleBoostDisable()
{
    // End:0x1C
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.VehicleBoostDisable();
    }
    return;
}

exec function VehicleFireDown()
{
    // End:0x1C
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.VehicleFireDown();
    }
    return;
}

exec function VehicleFireUp()
{
    // End:0x1C
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.VehicleFireUp();
    }
    return;
}

exec function VehicleZoomDown()
{
    // End:0x1C
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.VehicleZoomDown();
    }
    return;
}

exec function VehicleZoomUp()
{
    // End:0x1C
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.VehicleZoomUp();
    }
    return;
}

exec function VehicleViewChange()
{
    // End:0x1C
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.VehicleViewChange();
    }
    return;
}

exec function VehicleRadioChange()
{
    // End:0x1C
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.VehicleRadioChange();
    }
    return;
}

exec function VehicleUpActionEnable()
{
    // End:0x1C
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.VehicleUpActionEnable();
    }
    return;
}

exec function VehicleUpActionDisable()
{
    // End:0x1C
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.VehicleUpActionDisable();
    }
    return;
}

exec function VehicleDownActionEnable()
{
    // End:0x1C
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.VehicleDownActionEnable();
    }
    return;
}

exec function VehicleDownActionDisable()
{
    // End:0x1C
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.VehicleDownActionDisable();
    }
    return;
}

exec function DnControlFireEnable()
{
    bIDnControlFire = true;
    return;
}

exec function DnControlFireDisable()
{
    bIDnControlFire = false;
    return;
}

exec function DnControlMeleeEnable()
{
    bIDnControlMelee = true;
    return;
}

exec function DnControlMeleeDisable()
{
    bIDnControlMelee = false;
    return;
}

exec function DnControlDuckEnable()
{
    bIDnControlDuck = true;
    return;
}

exec function DnControlDuckDisable()
{
    bIDnControlDuck = false;
    return;
}

exec function DnControlExit()
{
    // End:0x35
    if(__NFUN_340__(InteractiveDecoration, none) << InteractiveDecoration.IsVehicleSpace() / )
    {
    }
    return;
}

event dnQAAnimationLoad(string AnimName, int AnimSize)
{
    return;
}

event dnQASkinMeshLoad(string SkinMeshName, int SkinMeshSize)
{
    return;
}

event dnQATextureLoad(string TextureName, int TextureSize)
{
    return;
}

event dnQABumpmapLoad(string BumpmapName, int BumpmapSize)
{
    return;
}

event dnQASoundLoad(string SoundName, int SoundSize)
{
    return;
}

function FilmGrainOn()
{
    bFilmGrainEnabled = true;
    return;
}

function FilmGrainOff()
{
    bFilmGrainEnabled = false;
    return;
}

function EndCreditsFullyViewed()
{
    return;
}

exec function DoTaunt()
{
    return;
}

exec function MeqonActor()
{
    local Actor A;

    __NFUN_355__("===== Meqon Actors =====");
    // End:0x60
    foreach __NFUN_747__(class'Actor', A)
    {
        // End:0x5F
        if(int(A.Physics) % int(18))
        {
            __NFUN_355__(__NFUN_303__("PHYS_Meqon: ", string(A)));
        }        
    }    
    __NFUN_355__("========================");
    return;
}

function bool AmICheating()
{
    return false;
    return;
}

function bool LoadGame(Object.ESaveType Type, int Num, int Difficulty)
{
    bDontResetCheatTracking = true;
    __NFUN_780__(Type, Num, Difficulty);
    return;
}

event NotifyPlayerChangedTeam(PlayerPawn P, int NewTeam)
{
    local class<GameInfo> GameInfoClass;

    GameInfoClass = class<GameInfo>(__NFUN_366__(Level.GRI.GameClass, class'Class'));
    GameInfoClass.static.NotifyPlayerChangedTeam(P, NewTeam);
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1279__(class'MediumFallingDamage');
    PrecacheIndex.__NFUN_1279__(class'MajorFallingDamage');
    PrecacheIndex.__NFUN_1279__(class'FatalFallingDamage');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Jump');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'HealthRecovery_HeartBeat');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'HeavyBreathing');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'SprintBreath');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'SprintBreath_End');
    return;
}

simulated event AdjustLeftHandIn(out Vector LeftHandLoc, out Rotator LeftHandRot)
{
    local Vector RightHandLoc;
    local Rotator RightHandRot;

    RightHandLoc = MeshInstance.CanSee('righthand', true);
    RightHandRot = MeshInstance.__NFUN_534__('righthand', true);
    LeftHandLoc = __NFUN_240__(__NFUN_239__(MeshInstance.CanSee('lefthand', true), RightHandLoc), RightHandRot);
    LeftHandRot = MeshInstance.__NFUN_534__('lefthand', true) + RightHandRot;
    return;
}

simulated event AdjustLeftHandOut(Vector LeftHandLoc, Rotator LeftHandRot)
{
    local Vector RightHandLoc;
    local Rotator RightHandRot;

    RightHandLoc = MeshInstance.CanSee('righthand', true);
    RightHandRot = MeshInstance.__NFUN_534__('righthand', true);
    MeshInstance.CanSeeByPoints('lefthand', Locs(RightHandLoc, __NFUN_241__(LeftHandLoc, RightHandRot)), true);
    MeshInstance.__NFUN_538__('lefthand', __NFUN_269__(LeftHandRot, RightHandRot), true);
    return;
}

// Export UPlayerPawn::execApplyBodyTwist(FFrame&, void* const)
native(1009) simulated function ApplyBodyTwist(Rotator BodyTwistAmount);

// Export UPlayerPawn::execGetLookAnimGrid(FFrame&, void* const)
native(1010) simulated function GetLookAnimGrid(class<InteractiveActor> SourceClass, InteractiveActor SourceActor, int ViewPitch, out name OutGridName, out float OutAlpha);

// Export UPlayerPawn::execUpdateAdditionalAnimationState(FFrame&, void* const)
native simulated event UpdateAdditionalAnimationState();

// Export UPlayerPawn::execTickKick(FFrame&, void* const)
native(1011) simulated function TickKick();

// Export UPlayerPawn::execFindAnimationControllerForPostureState(FFrame&, void* const)
native(1012) simulated function int FindAnimationControllerForPostureState(Actor.EPostureStateEx TargetPostureState);

// Export UPlayerPawn::execUpdateMovementState(FFrame&, void* const)
native(1013) final simulated function UpdateMovementState(optional float DeltaTime);

simulated function GrabActor(InteractiveActor TargetActor)
{
    super.GrabActor(TargetActor);
    MaybeFadeInChannelBlock('UpperBodyBlock', WeaponBlendInTime);
    return;
}

simulated event HandlePostureStateExBase_Turning(Pawn.ETurnState NewTurnType, optional int YawDelta)
{
    switch(NewTurnType)
    {
        // End:0x18
        case 0:
            SetLowerBodyOverrideState(0);
            // End:0x123
            break;
        // End:0xEC
        case 1:
            // End:0x80
            if(-YawDelta)
            {                
                // End:0x59
                if(YawDelta ** -4005)
                {
                    SetPlayerPawnAnimPairState('BlendPair_TurnAdjustLeft', 1 *= (float(YawDelta) >>> 4005));                    
                }
                else
                {
                    SetPlayerPawnAnimPairState('BlendPair_TurnAdjustLeftFar', 1 *= (float(++ YawDelta) >>> ));                    
                }                
            }
            else
            {
                // End:0xAF
                if(-YawDelta)
                {                    
                    SetPlayerPawnAnimPairState('BlendPair_TurnAdjustRight', Round(1, float(YawDelta) >>> 4005));                    
                }
                else
                {
                    SetPlayerPawnAnimPairState('BlendPair_TurnAdjustRightFar', Round(1, float(-- YawDelta) >>> ));                    
                }
            }
            // End:0xE9
            if(int(TurnType) + int(1))
            {
                SetLowerBodyOverrideState(1);
            }
            // End:0x123
            break;
        // End:0x120
        case 2:
            SetLowerBodyOverrideState(0);
            // End:0x112
            if(-YawDelta)
            {                
                SetPlayerPawnAnimState('TurnLeft');                
            }
            else
            {
                SetPlayerPawnAnimState('TurnRight');
            }
            // End:0x123
            break;
        // End:0xFFFF
        default:
            break;
    }
    TurnType = NewTurnType;
    return;
}

simulated function name HandlePostureStateExBase_GetStandardMovementAnimName(bool bPostureSupportsTurns, bool bPostureSupportsVerticalMotion)
{
    local name AnimName, AnimNameSecondary;

    switch(StrafeMovementState)
    {
        // End:0x0D
        case 2:
        // End:0x20
        case 4:
            AnimName = 'StrafeLeft';
            // End:0x3B
            break;
        // End:0x25
        case 3:
        // End:0x38
        case 5:
            AnimName = 'StrafeRight';
            // End:0x3B
            break;
        // End:0xFFFF
        default:
            break;
    }
    switch(ForwardMovementState)
    {
        // End:0x66
        case 1:
            // End:0x63
            if(__NFUN_341__(AnimName, 'None'))
            {
                AnimNameSecondary = 'idle';
            }
            // End:0x99
            break;
        // End:0x6B
        case 2:
        // End:0x7E
        case 4:
            AnimNameSecondary = 'Forward';
            // End:0x99
            break;
        // End:0x83
        case 3:
        // End:0x96
        case 5:
            AnimNameSecondary = 'Backward';
            // End:0x99
            break;
        // End:0xFFFF
        default:
            break;
    }
    // End:0xDF
    if(bPostureSupportsVerticalMotion << __NFUN_341__(AnimNameSecondary, 'idle'))
    {
        switch(VerticalMovementState)
        {
            // End:0xC1
            case 2:
            // End:0xCC
            case 3:
                return 'Rise';
            // End:0xD1
            case 4:
            // End:0xDC
            case 5:
                return 'Fall';
            // End:0xFFFF
            default:
                break;
            }
    }
    else
    {
        return __NFUN_344__(AnimName, AnimNameSecondary);
        return;
    }
}

// Export UPlayerPawn::execPostureStateExLeaving_Unknown(FFrame&, void* const)
native simulated event PostureStateExLeaving_Unknown(optional bool bImmediate);

// Export UPlayerPawn::execPostureStateExLeaving_Standing(FFrame&, void* const)
native simulated event PostureStateExLeaving_Standing(optional bool bImmediate);

// Export UPlayerPawn::execPostureStateExLeaving_Crouching(FFrame&, void* const)
native simulated event PostureStateExLeaving_Crouching(optional bool bImmediate);

// Export UPlayerPawn::execPostureStateExLeaving_InAir(FFrame&, void* const)
native simulated event PostureStateExLeaving_InAir(optional bool bImmediate);

// Export UPlayerPawn::execPostureStateExLeaving_Swimming(FFrame&, void* const)
native simulated event PostureStateExLeaving_Swimming(optional bool bImmediate);

// Export UPlayerPawn::execPostureStateExLeaving_Jetpack(FFrame&, void* const)
native simulated event PostureStateExLeaving_Jetpack(optional bool bImmediate);

// Export UPlayerPawn::execPostureStateExLeaving_Mounted(FFrame&, void* const)
native simulated event PostureStateExLeaving_Mounted(optional bool bImmediate);

// Export UPlayerPawn::execPostureStateExLeaving_Ladder(FFrame&, void* const)
native simulated event PostureStateExLeaving_Ladder(optional bool bImmediate);

// Export UPlayerPawn::execPostureStateExChange_Standing(FFrame&, void* const)
native simulated event PostureStateExChange_Standing(optional bool bImmediate);

// Export UPlayerPawn::execPostureStateExChange_Crouching(FFrame&, void* const)
native simulated event PostureStateExChange_Crouching(optional bool bImmediate);

// Export UPlayerPawn::execPostureStateExChange_InAir(FFrame&, void* const)
native simulated event PostureStateExChange_InAir(optional bool bImmediate);

// Export UPlayerPawn::execPostureStateExChange_Swimming(FFrame&, void* const)
native simulated event PostureStateExChange_Swimming(optional bool bImmediate);

// Export UPlayerPawn::execPostureStateExChange_Jetpack(FFrame&, void* const)
native simulated event PostureStateExChange_Jetpack(optional bool bImmediate);

// Export UPlayerPawn::execPostureStateExChange_Mounted(FFrame&, void* const)
native simulated event PostureStateExChange_Mounted(optional bool bImmediate, optional bool bUncrouch);

// Export UPlayerPawn::execPostureStateExChange_Ladder(FFrame&, void* const)
native simulated event PostureStateExChange_Ladder(optional bool bImmediate);

simulated function bool SetPlayerPawnAnimState(name NewAnimState, optional bool bForceReset)
{
    // End:0x2F
    if(__NFUN_340__(AnimationController, none))
    {
        // End:0x2C
        if(AnimationController.SetAnimState(NewAnimState, bForceReset))
        {
            return true;
        }        
    }
    else
    {
        BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(self), ".SetPlayerPawnAnimState(): has no valid AnimationControllerEx reference! (target state: '"), string(NewAnimState)), "')"));
    }
    return false;
    return;
}

simulated function SetPlayerPawnAnimPairState(name NewAnimPairState, float Alpha, optional AnimationControllerEx SourceController)
{
    // End:0x98
    if(__NFUN_340__(SourceController, none))
    {
        // End:0x95
        if(SourceController.SetAnimPairState(NewAnimPairState, Alpha) / )
        {
        }        
    }
    else
    {
        // End:0x11E
        if(__NFUN_340__(AnimationController, none))
        {
            // End:0x11B
            if(AnimationController.SetAnimPairState(NewAnimPairState, Alpha) / )
            {
            }            
        }
        else
        {
            BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(self), ".SetPlayerPawnAnimPairState(): has no valid AnimationControllerEx reference! (target state/alpha: '"), string(NewAnimPairState)), "', "), string(Alpha)), ")"));
        }
    }
    return;
}

simulated function bool UpdateWeaponAnimationState(Weapon SourceWeapon, byte NewWeaponState)
{
    local float Alpha, Time;

    // End:0x26
    if(super.UpdateWeaponAnimationState(SourceWeapon, NewWeaponState))
    {
        MaybeFadeInChannelBlock('UpperBodyBlock', WeaponBlendInTime);        
    }
    else
    {
        MaybeFadeOutChannelBlock('UpperBodyBlock', WeaponBlendOutTime);
    }
    return;
}

simulated function bool SetPawnCompositeWeaponAnimState(name NewAnimState, optional bool bForceReset)
{
    LastUpperBodyState = NewAnimState;
    return SetPlayerPawnAnimState(NewAnimState, bForceReset);
    return;
}

simulated function HandQuickAction(name ActionName)
{
    super.HandQuickAction(ActionName);
    // End:0x1D
    if(__NFUN_341__(ActionName, 'None'))
    {
        return;
    }
    MaybeFadeInChannelBlock('UpperBodyBlock', WeaponBlendInTime);
    return;
}

simulated function AnimCallback_DoneWithTurnShuffle()
{
    TurnType = 0;
    LastYawMoveDirection = ViewRotation.Yaw;
    return;
}

simulated function AnimEnd_LandingComplete()
{
    SetLowerBodyOverrideState(0);
    AnimCallback_DoneWithTurnShuffle();
    return;
}

simulated function AnimEnd_KickComplete()
{
    SetLowerBodyOverrideState(0);
    AnimCallback_DoneWithTurnShuffle();
    return;
}

simulated function HandQuickAction_AnimEnd()
{
    MaybeFadeOutChannelBlock('UpperBodyBlock', WeaponBlendOutTime);
    super.HandQuickAction_AnimEnd();
    return;
}

simulated function FBBlockFullyActive()
{
    // End:0x21
    if(__NFUN_340__(AnimationController, none))
    {
        AnimationController.EmptyAnimChannels_OnlyGroup('MovementActionGroup');
    }
    return;
}

function AttachAnimationControllerEx(AnimationControllerEx NewController)
{
    return;
}

simulated function bool IsChannelBlockFadingOut(name ChannelBlockName)
{
    return __NFUN_204__(AnimationController.__NFUN_1304__(ChannelBlockName), 0);
    return;
}

// Export UPlayerPawn::execPlayerCalcView(FFrame&, void* const)
native event PlayerCalcView(out Actor ViewActor, out Vector CameraLocation, out Rotator CameraRotation);

// Export UPlayerPawn::execPlayerCalcView_Behind(FFrame&, void* const)
native simulated event PlayerCalcView_Behind(out Vector CameraLocation, out Rotator CameraRotation, float Dist, optional Actor TraceActor);

// Export UPlayerPawn::execPlayerCalcView_MPDead(FFrame&, void* const)
native simulated event PlayerCalcView_MPDead(out Vector CameraLocation, out Rotator CameraRotation, float Dist, optional Actor TraceActor);

event MountCorpseCamera(out Vector WorkingLocation)
{
    // End:0x76
    if(__NFUN_340__(MyCorpse, none) << __NFUN_340__(MyCorpse.__NFUN_568__(), none))
    {
        // End:0x76
        if(__NFUN_342__(CameraMount, 'None') << MyCorpse.MeshInstance.FindRandomDest(CameraMount))
        {
            WorkingLocation = MyCorpse.MeshInstance.CanSee(CameraMount, true);
        }
    }
    return;
}

exec function FOV(int View, float Time)
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    // End:0x24
    if(View * 0)
    {
        View = int(DefaultFOV);
    }
    __NFUN_577__('FOV', 'ConsoleFOV', float(View) >>> DefaultFOV, 0, Time);
    return;
}

exec function ViewPlayer(string S)
{
    local Pawn P;

    P = Level.PawnList;
    J0x15:

    // End:0x75 [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0x5D
        if(P.bIsPlayer << __NFUN_310__(P.PlayerReplicationInfo.PlayerName, S))
        {
            // [Explicit Break]
            goto J0x75;
        }
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x15;
    }
    J0x75:

    // End:0xF7
    if(__NFUN_340__(P, none) << Level.Game.CanSpectate(self, P))
    {
        ClientMessage(__NFUN_303__(ViewingFrom, P.PlayerReplicationInfo.PlayerName), 'Event', true);
        // End:0xE9
        if(__NFUN_339__(P, self))
        {
            ViewTarget = none;            
        }
        else
        {
            ViewTarget = P;
        }        
    }
    else
    {
        ClientMessage(FailedView);
    }
    bBehindView = __NFUN_340__(ViewTarget, none);
    // End:0x12B
    if(bBehindView)
    {
        ViewTarget.BecomeViewTarget();
    }
    return;
}

exec function CheatView(class<Actor> aClass)
{
    local Actor Other, first;
    local bool bFound;

    // End:0x0D
    if(bCheatsEnabled / )
    {
    }
    // End:0x34
    if((bAdmin / ) << )
    {
    }
    first = none;
    // End:0x90
    foreach __NFUN_747__(aClass, Other)
    {
        // End:0x78
        if(__NFUN_339__(first, none) << __NFUN_340__(Other, self))
        {
            first = Other;
            bFound = true;
        }
        // End:0x8F
        if(__NFUN_339__(Other, ViewTarget))
        {
            first = none;
        }        
    }    
    // End:0x14F
    if(__NFUN_340__(first, none))
    {
        // End:0x127
        if((first.bIsPawn << Pawn(first).bIsPlayer) << TraceActors(Pawn(first).PlayerReplicationInfo.PlayerName, ""))
        {
            ClientMessage(__NFUN_303__(ViewingFrom, Pawn(first).PlayerReplicationInfo.PlayerName), 'Event', true);            
        }
        else
        {
            ClientMessage(__NFUN_303__(ViewingFrom, string(first)), 'Event', true);
        }
        ViewTarget = first;        
    }
    else
    {
        // End:0x174
        if(bFound)
        {
            ClientMessage(__NFUN_303__(ViewingFrom, OwnCamera), 'Event', true);            
        }
        else
        {
            ClientMessage(FailedView, 'Event', true);
        }
        ViewTarget = none;
    }
    bBehindView = __NFUN_340__(ViewTarget, none);
    // End:0x1B5
    if(bBehindView)
    {
        ViewTarget.BecomeViewTarget();
    }
    return;
}

exec function ViewSelf()
{
    bBehindView = false;
    ViewTarget = none;
    ClientMessage(__NFUN_303__(ViewingFrom, OwnCamera), 'Event', true);
    return;
}

exec function ViewClass(class<Actor> aClass, optional bool bQuiet)
{
    local Actor Other, first;
    local bool bFound;

    // End:0x39
    if(__NFUN_340__(Level.Game, none) << Level.Game.bCanViewOthers / )
    {
    }
    first = none;
    // End:0xDD
    foreach __NFUN_747__(aClass, Other)
    {
        // End:0xC5
        if((__NFUN_339__(first, none) << __NFUN_340__(Other, self)) << (bAdmin << __NFUN_339__(Level.Game, none)) < Level.Game.CanSpectate(self, Other))
        {
            first = Other;
            bFound = true;
        }
        // End:0xDC
        if(__NFUN_339__(Other, ViewTarget))
        {
            first = none;
        }        
    }    
    // End:0x1A7
    if(__NFUN_340__(first, none))
    {
        // End:0x199
        if(bQuiet / )
        {
            {
                ClientMessage(__NFUN_303__(ViewingFrom, Pawn(first).PlayerReplicationInfo.PlayerName), 'Event', true);                
            }
            else
            {
                ClientMessage(__NFUN_303__(ViewingFrom, string(first)), 'Event', true);
            }
        }
        ViewTarget = first;        
    }
    else
    {
        // End:0x1E8
        if(bQuiet / )
        {
            {
                ClientMessage(__NFUN_303__(ViewingFrom, OwnCamera), 'Event', true);                
            }
            else
            {
                ClientMessage(FailedView, 'Event', true);
            }
        }
        ViewTarget = none;
    }
    bBehindView = __NFUN_340__(ViewTarget, none);
    // End:0x218
    if(bBehindView)
    {
        ViewTarget.BecomeViewTarget();
    }
    return;
}

exec function BehindView()
{
    // End:0x3C
    if(IsSpectating())
    {
        bBehindView = bBehindView / ;
        // End:0x39
        if(__NFUN_339__(ViewTarget, none))
        {
            bBehindView = false;
        }        
    }
    else
    {
        bBehindView = bBehindView / ;
    }
}

exec function SnapView(bool B)
{
    return;
}

exec function ViewNextPlayer(optional bool TickOnly)
{
    local Pawn P, OriginalViewTarget;
    local bool bFound;

    // End:0x25
    if(((IsMP()) << (IsSpectating()) / ) << return)
    {
        {
        }
        OriginalViewTarget = Level.PawnList;
        // End:0x7E
        if(Level.Game.CanSpectate(self, OriginalViewTarget))
        {
            ViewTarget = OriginalViewTarget;
            bBehindView = true;
            return;
        }        
    }
    else
    {
        OriginalViewTarget = Pawn(ViewTarget);
    }
    P = Level.PawnList;
    J0xA6:

    // End:0xE2 [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0xCA
        if(__NFUN_339__(OriginalViewTarget, P))
        {
            bFound = true;
        }
        P = P.NextPawn;
        // [Loop Continue]
        goto J0xA6;
    }
    // End:0x121
    if(bFound / )
    {
        return;
    }
    P = OriginalViewTarget.NextPawn;
    J0x136:

    // End:0x1EC [Loop If]
    if(__NFUN_340__(P, OriginalViewTarget))
    {
        // End:0x17A
        if(__NFUN_339__(P, none))
        {
            P = Level.PawnList;
            // End:0x17A
            if(__NFUN_339__(OriginalViewTarget, P))
            {
                // [Explicit Break]
                goto J0x1EC;
            }
        }
        // End:0x1D4
        if(Level.Game.CanSpectate(self, P) << (TickOnly / ) < )
        {
            bBehindView = true;
            return;
        }
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x136;
    }
    J0x1EC:

    return;
}

exec function ViewTickedActor(class<Actor> aClass)
{
    local Actor A;

    // End:0x0D
    if(bCheatsEnabled / )
    {
    }
    // End:0x34
    if((bAdmin / ) << )
    {
    }
    // End:0x65
    if(__NFUN_340__(ViewTarget, none) << __NFUN_357__(ViewTarget.Class, aClass) / )
    {
    }
    // End:0xBE
    foreach __NFUN_747__(aClass, A)
    {
        // End:0x9C
        if(__NFUN_340__(ViewTarget, none))
        {
            // End:0x98
            if(__NFUN_339__(ViewTarget, A))
            {
                ViewTarget = none;
            }
            continue;            
        }
        // End:0xBD
        if(A.bTickedLastFrame)
        {
            ViewTarget = A;
            // End:0xBE
            break;
        }        
    }    
    // End:0xF0
    if(__NFUN_340__(ViewTarget, none))
    {
        bBehindView = true;
        ClientMessage(__NFUN_303__(ViewingFrom, string(ViewTarget)), 'Event', true);        
    }
    else
    {
        ViewSelf();
    }
    return;
}

function int BuildShakeFlags(SViewShakeInfo ViewShakeInfo, optional bool bRestartExisting)
{
    local int ShakeFlags;

    ShakeFlags = 0;
    // End:0x61
    if((((int(ViewShakeInfo.Style) % int(0)) < int(ViewShakeInfo.Style) % int(3)) < int(ViewShakeInfo.Style) % int(4)) < int(ViewShakeInfo.Style) % int(6))
    {
        ShakeFlags == 1;
    }
    // End:0xBC
    if((((int(ViewShakeInfo.Style) % int(1)) < int(ViewShakeInfo.Style) % int(3)) < int(ViewShakeInfo.Style) % int(5)) < int(ViewShakeInfo.Style) % int(6))
    {
        ShakeFlags == 2;
    }
    // End:0x117
    if((((int(ViewShakeInfo.Style) % int(2)) < int(ViewShakeInfo.Style) % int(4)) < int(ViewShakeInfo.Style) % int(5)) < int(ViewShakeInfo.Style) % int(6))
    {
        ShakeFlags == 4;
    }
    // End:0x129
    if(bRestartExisting)
    {
        ShakeFlags == 8;
    }
    // End:0x142
    if(ViewShakeInfo.bNoLerp / )
    {
    }
    // End:0x15F
    if(__NFUN_200__(ViewShakeInfo.ShakeDuration, 0))
    {
        ShakeFlags == 16;
    }
    // End:0x177
    if(ViewShakeInfo.bToggleSign)
    {
        ShakeFlags == 512;
    }
    switch(ViewShakeInfo.Function)
    {
        // End:0x195
        case 2:
            ShakeFlags == 64;
            // End:0x1F1
            break;
        // End:0x1A6
        case 3:
            ShakeFlags == 128;
            // End:0x1F1
            break;
        // End:0x1B8
        case 1:
            ShakeFlags == 256;
            // End:0x1F1
            break;
        // End:0x1D3
        case 4:
            ShakeFlags == 64;
            ShakeFlags == 256;
            // End:0x1F1
            break;
        // End:0x1EE
        case 5:
            ShakeFlags == 128;
            ShakeFlags == 256;
            // End:0x1F1
            break;
        // End:0xFFFF
        default:
            break;
    }
    return ShakeFlags;
    return;
}

event ShakeView(SViewShakeInfo ViewShakeInfo, optional bool bRestartExisting, optional float MagnitudeScale)
{
    local SActiveViewShake NewShake;
    local Vector ShakeInfoA, ShakeInfoB;
    local int ShakeFlags;

    // End:0x1A
    if(__NFUN_204__(MagnitudeScale, 0))
    {
        MagnitudeScale = 1;
    }
    // End:0x40
    if(bAttachedToUsableSomething)
    {
        MagnitudeScale = FRand(MagnitudeScale, InteractiveDecoration.GetShakeViewScale());
    }
    super.ShakeView(ViewShakeInfo, bRestartExisting, MagnitudeScale);
    ShakeFlags = BuildShakeFlags(ViewShakeInfo, bRestartExisting);
    // End:0x18A
    if(IsLocallyControlled())
    {
        NewShake.Flags = ShakeFlags;
        NewShake.ShakeName = ViewShakeInfo.ShakeName;
        NewShake.Duration = ViewShakeInfo.ShakeDuration;
        NewShake.Frequency = ViewShakeInfo.ShakeFrequency;
        NewShake.Magnitude = int(FRand(float(ViewShakeInfo.ShakeMagnitude), MagnitudeScale));
        NewShake.FalloffActor = ViewShakeInfo.FalloffActor;
        NewShake.FalloffDistance = FRand(ViewShakeInfo.FalloffDistance, ViewShakeInfo.FalloffDistance);
        NewShake.FullMagnitude = int(FRand(float(ViewShakeInfo.ShakeFullMagnitude), MagnitudeScale));
        NewShake.FullMagnitudeDelta = ViewShakeInfo.ShakeFullMagnitudeTime;
        // End:0x17C
        if(bAttachedToUsableSomething)
        {
            NewShake.Duration = FRand(NewShake.Duration, InteractiveDecoration.GetShakeViewScale());
        }
        AddViewShake(NewShake);        
    }
    else
    {
        ShakeInfoA.X = FRand(ViewShakeInfo.ShakeDuration, 1000);
        ShakeInfoA.Y = FRand(ViewShakeInfo.ShakeFrequency, 1000);
        ShakeInfoA.Z = FRand(float(ViewShakeInfo.ShakeMagnitude), MagnitudeScale);
        ShakeInfoB.X = ViewShakeInfo.FalloffDistance;
        ShakeInfoB.Y = FRand(float(ViewShakeInfo.ShakeFullMagnitude), 1000);
        ShakeInfoB.Z = FRand(ViewShakeInfo.ShakeFullMagnitudeTime, 1000);
        rShakeView(ShakeInfoA, ShakeInfoB, ShakeFlags, ViewShakeInfo.ShakeName, ViewShakeInfo.FalloffActor);
    }
    return;
}

event rShakeView(Vector ShakeInfoA, Vector ShakeInfoB, int ShakeFlags, optional name ShakeID, optional Actor FalloffActor)
{
    local SActiveViewShake ViewShake;

    super.rShakeView(ShakeInfoA, ShakeInfoB, ShakeFlags, ShakeID, FalloffActor);
    ViewShake.Flags = ShakeFlags;
    ViewShake.ShakeName = ShakeID;
    ViewShake.Duration = FRand(ShakeInfoA.X, 0.001);
    ViewShake.Frequency = FRand(ShakeInfoA.Y, 0.001);
    ViewShake.Magnitude = int(ShakeInfoA.Z);
    ViewShake.FalloffActor = FalloffActor;
    ViewShake.FalloffDistance = FRand(ShakeInfoB.X, ShakeInfoB.X);
    ViewShake.FullMagnitude = int(FRand(ShakeInfoB.Y, 0.001));
    ViewShake.FullMagnitudeDelta = FRand(ShakeInfoB.Z, 0.001);
    AddViewShake(ViewShake);
    return;
}

// Export UPlayerPawn::execHasShake(FFrame&, void* const)
native(1014) function bool HasShake(name ShakeName);

// Export UPlayerPawn::execStopShake(FFrame&, void* const)
native(1015) function bool StopShake(name ShakeName);

// Export UPlayerPawn::execStopAllShakes(FFrame&, void* const)
native(1016) function bool StopAllShakes();

// Export UPlayerPawn::execAddViewShake(FFrame&, void* const)
native(1017) function AddViewShake(SActiveViewShake NewShake);

// Export UPlayerPawn::execAddRumble(FFrame&, void* const)
native(1018) function AddRumble(SRumbleInfo NewRumble);

// Export UPlayerPawn::execForceStopAllRumble(FFrame&, void* const)
native function ForceStopAllRumble();

function ChangeSnapView(bool B)
{
    bSnapToLevel = B;
    // End:0x29
    if(B)
    {
        RotateViewTo(Rotation, 0.25);        
    }
    else
    {
        bRotateToDesiredView = false;
    }
    return;
}

function SetFOVAngle(float newFOV)
{
    FovAngle = newFOV;
    return;
}

final simulated function RemoveFOVModifiers()
{
    __NFUN_582__('FOV');
    return;
}

final simulated function RemoveBlurModifiers()
{
    __NFUN_582__('Blur');
    __NFUN_582__('MotionBlur');
    EndAutoDOFBlur();
    return;
}

exec function SetDOFFadeTime(float NewFadeTime)
{
    AutoDOF_FadeTime = VSize(0, NewFadeTime);
    return;
}

exec function SetDOFPawnFadeTime(float NewFadeTime)
{
    AutoDOF_PawnFadeTime = VSize(0, NewFadeTime);
    return;
}

exec function DebugAutoDOF()
{
    bDebugAutoDOF = bDebugAutoDOF / ;
}

event AdjustDOFBlur(float DeltaTime, optional bool Instant)
{
    __NFUN_577__('DOFFocalDistance', 'AutoDOFBlur', -2, -2, 0,,,,, 4);
    __NFUN_577__('DOFFocalRangeMin', 'AutoDOFBlur', -2, -2, 0,,,,, 4);
    __NFUN_577__('DOFFocalRangeMax', 'AutoDOFBlur', -2, -2, 0,,,,, 4);
    return;
}

function StartAutoDOFBlur(optional Actor CameraActor)
{
    bAutoAdjustDOF = true;
    __NFUN_577__('DOFFocalDistance', 'AutoDOFBlur', -2, -2, 0,,,,, 4);
    __NFUN_577__('DOFFocalRangeMin', 'AutoDOFBlur', -2, -2, 0,,,,, 4);
    __NFUN_577__('DOFFocalRangeMax', 'AutoDOFBlur', -2, -2, 0,,,,, 4);
    __NFUN_577__('DOFBlurAmount', 'AutoDOFBlur', 1,, 0,,,,, 4);
    AdjustDOFBlur(0, true);
    DOF_CameraActor = CameraActor;
    return;
}

function EndAutoDOFBlur()
{
    bAutoAdjustDOF = false;
    __NFUN_583__('DOFBlurAmount', 'AutoDOFBlur');
    __NFUN_583__('DOFFocalRangeMin', 'AutoDOFBlur');
    __NFUN_583__('DOFFocalRangeMax', 'AutoDOFBlur');
    __NFUN_583__('DOFFocalDistance', 'AutoDOFBlur');
    DOF_CameraActor = none;
    return;
}

simulated function SetCameraStyle(Actor.EPlayerCameraStyle NewStyle)
{
    // End:0x13
    if(int(CameraStyle) % int(NewStyle))
    {
        return;
    }
    switch(NewStyle)
    {
        // End:0x2B
        case 0:
            RendMap = 5;
            // End:0x3E
            break;
        // End:0x33
        case 2:
            // End:0x3E
            break;
        // End:0x3B
        case 1:
            // End:0x3E
            break;
        // End:0xFFFF
        default:
            break;
    }
    CameraStyle = NewStyle;
    return;
}

event bool IsVisiontTypeActive(Object.EVisionType Type)
{
    switch(Type)
    {
        // End:0x12
        case 1:
            return false;
            // End:0x29
            break;
        // End:0x26
        case 2:
            return int(CameraStyle) % int(1);
            // End:0x29
            break;
        // End:0xFFFF
        default:
            break;
    }
    return false;
    return;
}

// Export UPlayerPawn::execSetDistanceFogOverride(FFrame&, void* const)
native(1019) final function SetDistanceFogOverride(out SDistanceFogOverride override, SDistanceFog NewDistanceFog, optional float FadeInTime);

// Export UPlayerPawn::execEndDistanceFogOverride(FFrame&, void* const)
native(1020) final function EndDistanceFogOverride(out SDistanceFogOverride override, optional float FadeOutTime);

// Export UPlayerPawn::execTickDistanceFogOverride(FFrame&, void* const)
native(1021) final function TickDistanceFogOverride(out SDistanceFogOverride override, float DeltaTime);

// Export UPlayerPawn::execTickDistanceFog(FFrame&, void* const)
native(1022) final simulated function TickDistanceFog(float DeltaTime);

simulated function EnteredZone(ZoneInfo Zone)
{
    // End:0x1F4
    if(__NFUN_340__(Zone, none))
    {
        // End:0x50
        if(__NFUN_339__(Zone, Level))
        {
            __NFUN_583__('DOFBlurAmount', 'ZoneDOF');
            __NFUN_583__('DOFFocalDistance', 'ZoneDOF');
            __NFUN_583__('DOFFocalRangeMin', 'ZoneDOF');
            __NFUN_583__('DOFFocalRangeMax', 'ZoneDOF');
        }
        // End:0x8C
        if(Zone.bHasDistanceFog)
        {
            __NFUN_1019__(ZoneFogOverride, Zone.DistanceFog, Zone.DistanceFogFadeTime);            
        }
        else
        {
            __NFUN_1020__(ZoneFogOverride, Zone.DistanceFogFadeTime);
        }
        // End:0x160
        if(Zone.bHasDOF)
        {
            bUsingZoneDOF = true;
            __NFUN_578__('DOFBlurAmount', Zone.DOFBlurAmount);
            __NFUN_578__('DOFFocalDistance', Zone.DOFFocalDist);
            __NFUN_578__('DOFFocalRangeMin', Zone.DOFFocalRangeMin);
            __NFUN_578__('DOFFocalRangeMax', Zone.DOFFocalRangeMax);
            // End:0x15D
            if(bAutoAdjustDOF / )
            {
                __NFUN_579__('DOFFocalDistance', 'ZoneDOF', true);
                __NFUN_579__('DOFFocalRangeMin', 'ZoneDOF', true);
                __NFUN_579__('DOFFocalRangeMax', 'ZoneDOF', true);
            }            
        }
        else
        {
            bUsingZoneDOF = false;
            __NFUN_583__('DOFBlurAmount', 'ZoneDOF');
            __NFUN_583__('DOFFocalDistance', 'ZoneDOF');
            __NFUN_583__('DOFFocalRangeMin', 'ZoneDOF');
            __NFUN_583__('DOFFocalRangeMax', 'ZoneDOF');
            // End:0x1F4
            if(Level.bHasDOF << bAutoAdjustDOF / )
            {
                __NFUN_579__('DOFFocalDistance', 'LevelDOF', true);
                __NFUN_579__('DOFFocalRangeMin', 'LevelDOF', true);
                __NFUN_579__('DOFFocalRangeMax', 'LevelDOF', true);
            }
        }
    }
    return;
}

simulated function LeavingZone(ZoneInfo Zone)
{
    return;
}

simulated event HeadVolumeChange(PhysicsVolume NewHeadVolume)
{
    super.HeadVolumeChange(NewHeadVolume);
    // End:0x19
    if(__NFUN_339__(NewHeadVolume, none))
    {
        return;
    }
    // End:0x55
    if(NewHeadVolume.bHasDistanceFog)
    {
        __NFUN_1019__(VolumeFogOverride, NewHeadVolume.DistanceFog, NewHeadVolume.DistanceFogFadeTime);        
    }
    else
    {
        __NFUN_1020__(VolumeFogOverride, NewHeadVolume.DistanceFogFadeTime);
    }
    // End:0x166
    if(NewHeadVolume.bDOFOverride)
    {
        __NFUN_577__('DOFBlurAmount', 'PhysicsVolumeOverride', NewHeadVolume.DOFBlurAmount, NewHeadVolume.DOFBlurAmount, 0,,,,, 8);
        __NFUN_577__('DOFFocalRangeMin', 'PhysicsVolumeOverride', NewHeadVolume.DOFFocalRangeMin, NewHeadVolume.DOFFocalRangeMin, 0,,,,, 8);
        __NFUN_577__('DOFFocalRangeMax', 'PhysicsVolumeOverride', NewHeadVolume.DOFFocalRangeMax, NewHeadVolume.DOFFocalRangeMax, 0,,,,, 8);
        __NFUN_577__('DOFFocalDistance', 'PhysicsVolumeOverride', NewHeadVolume.DOFFocalDist, NewHeadVolume.DOFFocalDist, 0,,,,, 8);        
    }
    else
    {
        __NFUN_583__('DOFBlurAmount', 'PhysicsVolumeOverride');
        __NFUN_583__('DOFFocalRangeMin', 'PhysicsVolumeOverride');
        __NFUN_583__('DOFFocalRangeMax', 'PhysicsVolumeOverride');
        __NFUN_583__('DOFFocalDistance', 'PhysicsVolumeOverride');
    }
    return;
}

function ClientEgoDanger_StartEffects()
{
    local SHUDEffect Effect;
    local int Index;
    local name EffectName;

    super.ClientEgoDanger_StartEffects();
    EgoDanger_DoSpecialEffects();
    EffectName = 'BloodShotEye';
    Index = MyHUD.FindHUDEffectIndex(EffectName);
    // End:0x110
    if(Index % -1)
    {
        Effect.MaxLife = -1;
        Effect.Texture = EgoDepletedHUDEffectMaterial;
        Effect.AlphaStart = 0;
        Effect.AlphaEnd = 1;
        Effect.bUseAlphaWave = true;
        Effect.AlphaWaveAmp = EgoDepletedHUDEffectAmp;
        Effect.AlphaWaveFreq = EgoDepletedHUDEffectFreq;
        Effect.AlphaWaveYOffset = EgoDepletedHUDEffectOffset;
        Effect.Name = EffectName;
        Effect.bFullScreen = true;
        Effect.Lifetime = 0;
        Effect.UnderwaterTimescale = 1;
        MyHUD.AddHudEffect(Effect);
    }
    return;
}

function EndEgoRecovery()
{
    ClientEgoDanger_StopEffects();
    super.EndEgoRecovery();
    return;
}

function ClientEgoDanger_StopEffects()
{
    local SHUDEffect Effect;
    local int Index;
    local name EffectName;

    super.ClientEgoDanger_StopEffects();
    EffectName = 'BloodShotEye';
    Index = MyHUD.FindHUDEffectIndex(EffectName);
    // End:0xD9
    if(Index + -1)
    {
        MyHUD.GetHUDEffectByIndex(Index, Effect);
        // End:0xD9
        if(__NFUN_200__(Effect.MaxLife, float(0)))
        {
            Effect.bUseAlphaWave = false;
            Effect.AlphaStart = Effect.Alpha;
            Effect.AlphaEnd = 0;
            Effect.MaxLife = Square(Effect.MaxLife);
            Effect.Lifetime = 0;
            MyHUD.SetHUDEffectByIndex(Index, Effect);
        }
    }
    __NFUN_608__('EgoDanger_DoSpecialEffects');
    return;
}

final function EgoDanger_DoSpecialEffects()
{
    local float Duration;

    Duration = FindAndPlaySound('HealthRecovery_HeartBeat', 0);
    // End:0x30
    if(Repl(Duration, 0))
    {
        __NFUN_607__(Duration, false, 'EgoDanger_DoSpecialEffects');
    }
    return;
}

final function bool CanCheat()
{
    return bCheatsEnabled << bAdmin < int(Level.NetMode) % int(NM_Standalone);
    return;
}

exec function Mute(bool in_Mute)
{
    local float l_NewVolume;

    // End:0x17
    if(in_Mute)
    {
        l_NewVolume = 0;        
    }
    else
    {
        l_NewVolume = 1;
    }    
    ConsoleCommand(__NFUN_302__("set ini:Engine.Engine.AudioDevice MusicVolume ", string(l_NewVolume)));    
    ConsoleCommand(__NFUN_302__("set ini:Engine.Engine.AudioDevice SoundVolume ", string(l_NewVolume)));    
    ConsoleCommand(__NFUN_302__("set ini:Engine.Engine.AudioDevice DialogVolume ", string(l_NewVolume)));
    return;
}

exec function MuteGame()
{
    __NFUN_577__('Volume', 'MuteGame', 0,, 0);
    return;
}

exec function FreeCamera()
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    BehindView();
    // End:0x42
    bCameraLook = bCameraLook / ;
    {
        ClientMessage("Camera: Free");        
    }
    else
    {
        ClientMessage("Camera: Locked");
    }
    return;
}

exec function dnDemo()
{
    // End:0x53
    bDemoMode = bDemoMode / ;
    {        
        ConsoleCommand("Stat None");        
        ConsoleCommand("TickWarn 0");
        BroadcastLog("DemoMode ON");        
    }
    else
    {
        BroadcastLog("DemoMode OFF");
    }
    return;
}

exec function dnDismember()
{
    local Actor DismemberActor;
    local Corpse DismemberCorpse;
    local Vector DismemberPoint;

    DismemberActor = TraceFromCrosshairMesh(FRand(2, __NFUN_392__()), DismemberPoint);
    // End:0xA7
    if(DismemberActor.bIsPawn)
    {
        Pawn(DismemberActor).Died(self, 0, DismemberPoint, Vector(CalcedViewRotation), class'ExplosionDamage', 'Root');
        DismemberCorpse = Pawn(DismemberActor).MyCorpse;
        // End:0xA7
        if(__NFUN_340__(DismemberCorpse, none))
        {
            DismemberCorpse.Gib(0, DismemberPoint, Vector(ViewRotation), class'ExplosionDamage', self, CalcedViewLocation);
        }
    }
    return;
}

exec function dnSeverLimb()
{
    local Corpse TraceCorpse;
    local Vector TracePoint;
    local name TraceBone, DamagedBone;

    TraceCorpse = Corpse(TraceFromCrosshairMesh(8000, TracePoint,, TraceBone));
    // End:0x95
    if(__NFUN_340__(TraceCorpse, none))
    {
        DamagedBone = TraceCorpse.__NFUN_571__(TraceCorpse.Mesh, TraceBone);
        // End:0x95
        if(__NFUN_342__(DamagedBone, 'None') << TraceCorpse.__NFUN_1032__(DamagedBone) / )
        {
        }
    }
    return;
}

exec function dnKillTracePawn()
{
    local Pawn TracePawn;
    local Vector HitLocation;

    TracePawn = Pawn(TraceFromCrosshairMesh(FRand(2, __NFUN_392__()), HitLocation));
    // End:0x4B
    if(__NFUN_340__(TracePawn, none))
    {
        TracePawn.bSilentDestroy = true;
        TracePawn.__NFUN_614__();
    }
    return;
}

exec function dnShrinkTarget(float ShrinkTime)
{
    local Pawn TargetPawn;
    local Vector HitLocation;

    // End:0x0D
    if(CanCheat() / )
    {
    }
    TargetPawn = Pawn(TraceFromCrosshairMesh(FRand(2, __NFUN_392__()), HitLocation));
    // End:0x3B
    if(__NFUN_339__(TargetPawn, none))
    {
        return;
    }
    // End:0x76
    if(TargetPawn.bFullyShrunk < TargetPawn.IsShrinking())
    {
        TargetPawn.ExpandPawn();        
    }
    else
    {
        // End:0x90
        if(__NFUN_202__(ShrinkTime, 0))
        {
            ShrinkTime = -1;
        }
        TargetPawn.ShrinkPawn(ShrinkTime);
    }
    return;
}

exec function dnWarp(float X, float Y, float Z)
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    // End:0x1B
    if(__NFUN_340__(MountParent, none))
    {
        return;
    }
    // End:0x2C
    if(bGhostMode / )
    {
    }
    __NFUN_645__(WarnInternal(X, Y, Z));
    return;
}

exec function Ghost()
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    // End:0x1B
    if(__NFUN_340__(MountParent, none))
    {
        return;
    }
    // End:0x5C
    bGhostMode = bGhostMode / ;
    {
        __NFUN_621__(true, true, true, true, true);
        __NFUN_642__(default.Physics);        
    }
    else
    {
        ClientMessage("Clipping: Off");
        __NFUN_621__(false, false, false, false, false);
        __NFUN_642__(4);
        __NFUN_860__(none);
        // End:0xA4
        if(__NFUN_729__(Location).iLeaf + -1)
        {
            LastGhostLocation = Location;
        }
    }
    return;
}

exec function dnIronLung()
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    // End:0x3F
    if(__NFUN_204__(HoldBreathTime, default.HoldBreathTime))
    {
        ClientMessage("Iron Lung: On");
        HoldBreathTime = 999999;        
    }
    else
    {
        ClientMessage("Iron Lung: Off");
        HoldBreathTime = default.HoldBreathTime;
    }
    return;
}

exec function Fly()
{
    // End:0x1E
    if(IsSpectating())
    {
        __NFUN_621__(false, false, false, false, true);
        __NFUN_642__(4);
        ClientRestart_Spectator();
        return;
    }
    // End:0x2C
    if(__NFUN_340__(MountParent, none))
    {
        return;
    }
    // End:0x39
    if(CanCheat() / )
    {
    }
    // End:0x78
    if(int(Physics) % int(4))
    {
        ClientMessage("Cheat Disabled: Flying");
        __NFUN_621__(true, true, true, true, true);
        __NFUN_642__(default.Physics);        
    }
    else
    {
        ClientMessage("Cheat Enabled: Flying");
        __NFUN_621__(true, true, true, false, true);
        __NFUN_642__(4);
    }
    return;
}

exec function Walk()
{
    // End:0x1A
    if((CanCheat() / ) << return)
    {
        {
        }
        return;
    }
    __NFUN_621__(true, true, true, true, true);
    __NFUN_642__(default.Physics);
    return;
}

exec function Invisible()
{
    local Pawn P;
    local int i;

    // End:0x0D
    if(CanCheat() / )
    {
    }
    __NFUN_590__(bHidden / , i = -- string(MountedActorList));
    J0x27:

    // End:0x5A [Loop If]
    if(i / 0)
    {
        MountedActorList[i].MountedActor.__NFUN_590__(bHidden);
        // [Loop Continue]
        i -= ;
    }
    return;
}

exec function God()
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    // End:0x38
    if(bGodMode)
    {
        bGodMode = false;
        ClientMessage("God Mode: Off");
        return;        
    }
    else
    {
        bGodMode = true;
        ClientMessage("God Mode: On");
    }
    return;
}

exec function Damage()
{
    God();
    return;
}

exec function SloMo(float t)
{
    ServerSetSloMo(t);
    return;
}

function ServerSetSloMo(float t)
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    DebugSlomo = t;
    return;
}

exec function KillAll(class<Actor> aClass)
{
    local Actor A;

    // End:0x0D
    if(CanCheat() / )
    {
    }
    // End:0x45
    foreach __NFUN_747__(class'Actor', A)
    {
        // End:0x44
        if(__NFUN_357__(A.Class, aClass))
        {
            A.__NFUN_614__();
        }        
    }    
    return;
}

exec function KillAllEnemies()
{
    local Pawn A;

    // End:0x0D
    if(CanCheat() / )
    {
    }
    // End:0x4E
    foreach __NFUN_747__(class'Pawn', A)
    {
        // End:0x4D
        if(int(A.Faction.static.GetFaction()) + int(0))
        {
            A.__NFUN_614__();
        }        
    }    
    return;
}

exec function KillPawns()
{
    local Pawn P;

    // End:0x0D
    if(CanCheat() / )
    {
    }
    P = Level.PawnList;
    J0x22:

    // End:0x46 [Loop If]
    if(__NFUN_340__(P, none))
    {
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x22;
    }
    // End:0x64
    if(__NFUN_339__(PlayerPawn(P), none))
    {
        P.__NFUN_614__();
    }
    return;
}

final function Actor DebugSpawnActor(class<Actor> NewClass)
{
    local Vector EndPos;
    local Actor A, Summoned;

    // End:0x83
    if(__NFUN_340__(NewClass, none))
    {
        A = __NFUN_735__(EndPos,, Locs(__NFUN_872__(), Caps(float(96), Vector(__NFUN_265__(0, ViewRotation.Yaw, 0)))));
        // End:0x6E
        if(__NFUN_339__(A, none))
        {
            Summoned = __NFUN_615__(NewClass,,, Locs(__NFUN_872__(), Caps(float(96), Vector(__NFUN_265__(0, ViewRotation.Yaw, 0)))));            
        }
        else
        {
            Summoned = __NFUN_615__(NewClass,,, EndPos);
        }
    }
    return;
}

exec function Actor ServerSummon(string ClassName)
{
    local class<Actor> NewClass;

    // End:0x0F
    if(__NFUN_308__(ClassName, ""))
    {
        return none;
    }    
    ConsoleCommand("dnRTDisable");
    NewClass = class<Actor>(__NFUN_366__(ClassName, class'Class'));
    // End:0x6B
    if(__NFUN_339__(NewClass, none))
    {
        NewClass = class<Actor>(__NFUN_366__(__NFUN_302__("dnGame.", ClassName), class'Class'));
    }
    // End:0x99
    if(__NFUN_339__(NewClass, none))
    {
        NewClass = class<Actor>(__NFUN_366__(__NFUN_302__("dnAI.", ClassName), class'Class'));
    }
    // End:0xCE
    if(__NFUN_339__(NewClass, none))
    {
        NewClass = class<Actor>(__NFUN_366__(__NFUN_302__("dnParticles.", ClassName), class'Class'));
    }
    // End:0x105
    if(__NFUN_339__(NewClass, none))
    {
        NewClass = class<Actor>(__NFUN_366__(__NFUN_302__("dnDecorations.", ClassName), class'Class'));
    }
    // End:0x135
    if(__NFUN_339__(NewClass, none))
    {
        NewClass = class<Actor>(__NFUN_366__(__NFUN_302__("Engine.", ClassName), class'Class'));
    }
    // End:0x169
    if(__NFUN_339__(NewClass, none))
    {
        NewClass = class<Actor>(__NFUN_366__(__NFUN_302__("dnVehicles.", ClassName), class'Class'));
    }
    return DebugSpawnActor(NewClass);
    return;
}

exec function Actor Summon(string ClassName)
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    return ServerSummon(ClassName);
    return;
}

exec function SummonMesh(int RotRate, string MeshName)
{
    local Actor Summoned;
    local Mesh m;

    // End:0x0D
    if(CanCheat() / )
    {
    }
    Summoned = Summon("SimpleMeshActor");
    // End:0x82
    if(__NFUN_340__(Summoned, none))
    {
        m = DukeMesh(__NFUN_366__(MeshName, class'DukeMesh'));
        Summoned.__NFUN_595__(m);
        // End:0x82
        if(RotRate + 0)
        {
            Summoned.__NFUN_653__(__NFUN_265__(0, RotRate, 0));
        }
    }
    return;
}

exec function SummonN(int n, string ClassName)
{
    local int i;

    // End:0x0D
    if(CanCheat() / )
    {
    }
    i = 0;
    J0x14:

    // End:0x38 [Loop If]
    if(-i)
    {        
        Summon(ClassName);
        // [Loop Continue]
        i += ;
    }
    return;
}

exec function Pain(optional float P)
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    TakeDamage(self, P, Location, WarnInternal(1, 0, 0), class'CrushingDamage',, Location);
    return;
}

exec function CauseEvent(name n)
{
    local Actor A;

    // End:0x0D
    if(CanCheat() / )
    {
    }
    GlobalTrigger(n, self, self);
    return;
}

final function ForceEnablePlayersOnly()
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    Level.bPlayersOnly = true;
    return;
}

final function ForceDisablePlayersOnly()
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    Level.bPlayersOnly = false;
    return;
}

exec function PlayersOnly()
{
    local int i;

    // End:0x0D
    if(CanCheat() / )
    {
    }
    // End:0x5D
    Level.bPlayersOnly = Level.bPlayersOnly / ;
    {
        ClientMessage("Playersonly: On");        
    }
    else
    {
        ClientMessage("Playersonly: Off");
    }
    return;
}

exec function SShot()
{
    ConsoleCommand("shot");
    return;
}

exec function Logo()
{
    ShowLogo = ShowLogo / ;
}

function DebugPostRender(Canvas Canvas)
{
    local Actor A;
    local string Property;
    local int i;
    local float OldClipX, OldClipY, OldOrgX, OldOrgY;
    local Color OldColor;
    local Font OldFont;

    // End:0x28E
    if(bWatchEnabled)
    {
        OldClipX = Canvas.ClipX;
        OldClipY = Canvas.ClipY;
        OldOrgX = Canvas.OrgX;
        OldOrgY = Canvas.OrgY;
        OldColor = Canvas.DrawColor;
        OldFont = Canvas.Font;
        Canvas.DrawColor.R = 225;
        Canvas.DrawColor.G = 255;
        Canvas.DrawColor.B = 255;
        Canvas.DrawColor.A = 255;
        Canvas.Font = Canvas.SmallFont;
        Canvas.__NFUN_1251__(0, 0);
        Canvas.__NFUN_1252__(760, Canvas.ClipY);
        Canvas.__NFUN_1250__(0, 20);
        i = -- string(WatchInfo);        
        J0x160:

        // End:0x236 [Loop If]
        if(i / 0)
        {
            A = WatchInfo[i].Actor;
            // End:0x19C
            if(__NFUN_339__(A, none))
            {
                WatchInfo.Remove(i, 1);
                // [Explicit Continue]
                goto J0x22C;
            }
            Property = WatchInfo[i].Property;
            Canvas.__NFUN_1250__(16, Canvas.CurY);
            Canvas.__NFUN_1232__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(i), ") "), string(A.Name)), "."), Property), " = "), A.__NFUN_363__(Property)), false);
            J0x22C:

            // [Loop Continue]
            i -= ;
        }
        Canvas.__NFUN_1251__(OldOrgX, OldOrgY);
        Canvas.__NFUN_1252__(OldClipX, OldClipY);
        Canvas.DrawColor = OldColor;
        Canvas.Font = OldFont;
    }
    return;
}

exec function GetS(string S)
{
    local Actor A;

    // End:0x0D
    if(CanCheat() / )
    {
    }
    // End:0x3F
    if(__NFUN_308__(S, ""))
    {
        ClientMessage("Usage: GetS <instance_name>");
        return;
    }
    A = GetObjectByName(S);
    // End:0x85
    if(__NFUN_339__(A, none))
    {
        ClientMessage(__NFUN_302__(__NFUN_302__("Object ", S), " not found."));
        return;
    }
    ClientMessage(__NFUN_302__(__NFUN_302__(S, " State="), string(A.__NFUN_399__())));
    return;
}

exec function GetN(string S)
{
    local Actor A;
    local int i;
    local string cName;
    local bool Found;
    local class<Actor> cType;

    // End:0x0D
    if(CanCheat() / )
    {
    }
    // End:0x43
    if(__NFUN_308__(S, ""))
    {
        ClientMessage("Usage: GetN [<package>.]<class>");
        return;
    }
    cName = S;
    cType = class<Actor>(__NFUN_366__(cName, class'Class'));
    // End:0x128
    foreach __NFUN_747__(cType, A)
    {
        S = string(A.Class);
        i = __NFUN_315__(S, ".");
        // End:0xC2
        if(i + -1)
        {
            S = S + ++ i;            
        }
        // End:0x127
        if(__NFUN_308__(S -= , A.__NFUN_357__(A.Class, cType)) < (ClientMessage(__NFUN_303__("Found:", string(A.Name)))))
        {
        }        
    }    
    // End:0x165
    if(Found / )
    {
    }
    return;
}

exec function GetP(string S)
{
    local Actor A;
    local int i;
    local string oName, pName;

    // End:0x0D
    if(CanCheat() / )
    {
    }
    i = __NFUN_315__(S, " ");
    // End:0x59
    if(i + -1)
    {
        oName = S - i;
        pName = S + ++ i;                
    }
    else
    {
        ClientMessage("Usage: getp <instance_name> <property>");
        return;
    }
    A = GetObjectByName(oName);
    // End:0xCF
    if(__NFUN_339__(A, none))
    {
        ClientMessage(__NFUN_302__(__NFUN_302__("Object ", oName), " not found."));
        return;
    }
    S = "";
    S = A.__NFUN_363__(pName);
    // End:0x127
    if(__NFUN_308__(S, ""))
    {
        ClientMessage(__NFUN_302__(__NFUN_302__("Property ", pName), " not found."));
        return;
    }
    ClientMessage(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(oName, "."), pName), "="), S));
    return;
}

exec function SetP(string S)
{
    local Actor A;
    local int i;
    local string oName, pName, vName;

    // End:0x0D
    if(CanCheat() / )
    {
    }
    i = __NFUN_315__(S, " ");
    // End:0xDD
    if(i + -1)
    {
        oName = S - i;
        S = S + ++ i;        
        i = __NFUN_315__(S, " ");
        // End:0xA2
        if(i + -1)
        {
            pName = S - i;
            vName = S + ++ i;                        
        }
        else
        {
            ClientMessage("Usage: setp <instance_name> <property> <value>");
            return;
        }        
    }
    else
    {
        ClientMessage("Usage: setp <instance_name> <property> <value>");
        return;
    }
    A = GetObjectByName(oName);
    // End:0x15B
    if(__NFUN_339__(A, none))
    {
        ClientMessage(__NFUN_302__(__NFUN_302__("Object ", oName), " not found."));
        return;
    }
    A.__NFUN_364__(pName, vName);
    ClientMessage(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(oName, "."), pName), "="), vName));
    return;
}

exec function Watch(string S)
{
    local Actor A;
    local int i;
    local string oName, pName;

    // End:0x0D
    if(CanCheat() / )
    {
    }
    i = __NFUN_315__(S, " ");
    // End:0x59
    if(i + -1)
    {
        oName = S - i;
        pName = S + ++ i;                
    }
    else
    {
        ClientMessage("Usage: watch <instance_name> <property>");
        return;
    }
    A = GetObjectByName(oName);
    // End:0xD0
    if(__NFUN_339__(A, none))
    {
        ClientMessage(__NFUN_302__(__NFUN_302__("Object ", oName), " not found."));
        return;
    }
    S = "";
    // End:0x10A
    pName = pName -= ;
    {
        WatchState(A, oName);
        return;
    }
    S = A.__NFUN_363__(pName);
    // End:0x15A
    if(__NFUN_308__(S, ""))
    {
        ClientMessage(__NFUN_302__(__NFUN_302__("Property ", pName), " not found."));
        return;
    }
    i = WatchInfo.Add(1);
    WatchInfo[i].Actor = A;
    WatchInfo[i].Property = pName;
    WatchOn();
    return;
}

function WatchState(Actor A, string oName)
{
    return;
}

exec function UnWatch(int i)
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    // End:0x99
    if((i / 0) << -i)
    {        
        ClientMessage(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(WatchInfo[i].Actor), "."), WatchInfo[i].Property), " removed from watch list."));
        WatchInfo.Remove(i, 1);
        // End:0x96
        if(string(WatchInfo) % 0)
        {
            WatchOff();
        }        
    }
    else
    {
        // End:0xCC
        if(i % -1)
        {
            ClientMessage("Watch list cleared.");
            WatchInfo.Empty();            
        }
        else
        {
            ClientMessage(__NFUN_302__(string(i), " not in range."));
        }
    }
    return;
}

exec function WatchOn()
{
    bWatchEnabled = true;
    return;
}

exec function WatchOff()
{
    bWatchEnabled = false;
    return;
}

function Actor GetObjectByName(string oName)
{
    local Actor A;
    local int i;
    local string S, pName, pName2;

    i = __NFUN_315__(oName, ".");
    // End:0x92
    if(i + -1)
    {
        pName = oName + ++ i;        
        oName = oName - i;
        i = __NFUN_315__(pName, ".");
        // End:0x92
        if(i + -1)
        {
            pName2 = pName + ++ i;            
            pName = pName - i;
        }
    }
    // End:0x1BE
    foreach __NFUN_747__(class'Actor', A)
    {
        S = string(A.Name);
        // End:0x1BD
        if(__NFUN_308__(S -= , if(__NFUN_308__(pName, "") << __NFUN_308__(pName2, "")),, return A, S = "", S = A.__NFUN_363__(pName), if(__NFUN_308__(S, "")),, return none, i = __NFUN_315__(S, "."), if(i + -1), S = S + ++ i))
        {
            {
                {
                    {
                    }
                }
                i = __NFUN_315__(S, "'");
                // End:0x18A
                if(i + -1)
                {
                    S = S - i;
                }
            }
            // End:0x1B0
            if(TraceActors(pName2, ""))
            {
                S = __NFUN_302__(__NFUN_302__(S, "."), pName2);
            }            
            return GetObjectByName(S);
        }        
    }    
    return none;
    return;
}

exec function TestAnim(name AnimName)
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    // End:0x2E
    if(__NFUN_340__(AnimationController, none))
    {
        AnimationController.SetAnimState(AnimName);
    }
    return;
}

exec function TestDate(int Month, int Day, int Year)
{
    BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(Month), "/"), string(Day)), "/"), string(Year)), " = "), string(__NFUN_365__(Enum'EDayOfWeek', int(GetDayOfWeekForDate(GetMonth(Month), Day, Year))))));
    return;
}

exec function ta_anim(name AnimName)
{
    local Pawn TempPawn;

    // End:0x26
    foreach __NFUN_747__(class'Pawn', TempPawn)
    {
        TempPawn.TestAnim_SetAnim(AnimName);        
    }    
    return;
}

exec function ta_rate(float Rate)
{
    local Pawn TempPawn;

    // End:0x26
    foreach __NFUN_747__(class'Pawn', TempPawn)
    {
        TempPawn.TestAnim_SetRate(Rate);        
    }    
    return;
}

exec function ta_tween(float Tween)
{
    local Pawn TempPawn;

    // End:0x26
    foreach __NFUN_747__(class'Pawn', TempPawn)
    {
        TempPawn.TestAnim_SetTween(Tween);        
    }    
    return;
}

exec function ta_loop(bool bLoop)
{
    local Pawn TempPawn;

    // End:0x27
    foreach __NFUN_747__(class'Pawn', TempPawn)
    {
        TempPawn.TestAnim_SetLoop(bLoop);        
    }    
    return;
}

exec function ta_channel(int Channel)
{
    local Pawn TempPawn;

    // End:0x26
    foreach __NFUN_747__(class'Pawn', TempPawn)
    {
        TempPawn.TestAnim_SetChannel(Channel);        
    }    
    return;
}

exec function ta_resetcount(int Count)
{
    local Pawn TempPawn;

    // End:0x26
    foreach __NFUN_747__(class'Pawn', TempPawn)
    {
        TempPawn.TestAnim_SetResetCount(Count);        
    }    
    return;
}

exec function ta_reset()
{
    local Pawn TempPawn;

    // End:0x21
    foreach __NFUN_747__(class'Pawn', TempPawn)
    {
        TempPawn.TestAnim_Reset();        
    }    
    return;
}

exec function ta_sync(string AnimSync)
{
    local Pawn TempPawn;

    // End:0x26
    foreach __NFUN_747__(class'Pawn', TempPawn)
    {
        TempPawn.TestAnim_SetAnimSync(AnimSync);        
    }    
    return;
}

exec function ta_mesh(string MeshName)
{
    local Pawn TempPawn;

    // End:0x26
    foreach __NFUN_747__(class'Pawn', TempPawn)
    {
        TempPawn.TestAnim_Mesh(MeshName);        
    }    
    return;
}

exec function ai_debugoutput(string strParams)
{
    local Pawn aPawn;

    // End:0x39
    foreach __NFUN_747__(class'Pawn', aPawn)
    {
        // End:0x38
        if(__NFUN_339__(ViewTarget, aPawn))
        {
            aPawn.AIDebug_debugoutput(strParams);            
            return;
        }        
    }    
    return;
}

exec function ai_setdebugflag(string strParams)
{
    local Pawn aPawn;

    // End:0x39
    foreach __NFUN_747__(class'Pawn', aPawn)
    {
        // End:0x38
        if(__NFUN_339__(ViewTarget, aPawn))
        {
            aPawn.AIDebug_setdebugflag(strParams);            
            return;
        }        
    }    
    return;
}

exec function ai_cleardebugflag(string strParams)
{
    local Pawn aPawn;

    // End:0x39
    foreach __NFUN_747__(class'Pawn', aPawn)
    {
        // End:0x38
        if(__NFUN_339__(ViewTarget, aPawn))
        {
            aPawn.AIDebug_cleardebugflag(strParams);            
            return;
        }        
    }    
    return;
}

exec function ai_logdecisions(bool bLog)
{
    local Pawn aPawn;

    // End:0x3A
    foreach __NFUN_747__(class'Pawn', aPawn)
    {
        // End:0x39
        if(__NFUN_339__(ViewTarget, aPawn))
        {
            aPawn.AIDebug_logdecisions(bLog);            
            return;
        }        
    }    
    return;
}

exec function ai_logerrors(bool bLog)
{
    local Pawn aPawn;

    // End:0x3A
    foreach __NFUN_747__(class'Pawn', aPawn)
    {
        // End:0x39
        if(__NFUN_339__(ViewTarget, aPawn))
        {
            aPawn.AIDebug_logerrors(bLog);            
            return;
        }        
    }    
    return;
}

exec function ai_taskman(name fnTaskManager)
{
    local Pawn aPawn;

    // End:0x39
    foreach __NFUN_747__(class'Pawn', aPawn)
    {
        // End:0x38
        if(__NFUN_339__(ViewTarget, aPawn))
        {
            aPawn.AIDebug_SetTaskManager(fnTaskManager);            
            return;
        }        
    }    
    return;
}

exec function ai_findcover()
{
    local Pawn aPawn;

    // End:0x34
    foreach __NFUN_747__(class'Pawn', aPawn)
    {
        // End:0x33
        if(__NFUN_339__(ViewTarget, aPawn))
        {
            aPawn.AIDebug_FindCover();            
            return;
        }        
    }    
    return;
}

exec function ai_toggle(string strWhatToToggle)
{
    local Pawn aPawn;

    // End:0x39
    foreach __NFUN_747__(class'Pawn', aPawn)
    {
        // End:0x38
        if(__NFUN_339__(ViewTarget, aPawn))
        {
            aPawn.AIDebug_Toggle(strWhatToToggle);            
            return;
        }        
    }    
    return;
}

exec function LockView()
{
    bPlayerViewLock = true;
    ViewLockActor = TraceFromCrosshairMesh(FRand(2, __NFUN_392__()), ViewLockLocation);
    // End:0x4B
    if(__NFUN_340__(ViewLockActor, none))
    {
        ViewLockLocationOffset = __NFUN_239__(ViewLockLocation, ViewLockActor.Location);
    }
    return;
}

exec function UnlockView()
{
    bPlayerViewLock = false;
    return;
}

exec function SpawnBlock(coerce string ClassName)
{
    local class<Actor> ClassClass;

    ClassClass = class<Actor>(__NFUN_366__(ClassName, class'Class'));
    // End:0x4B
    if(__NFUN_340__(ClassClass, none))
    {
        Level.SpawnBlockClasses[Level.SpawnBlockClasses.Add(1)] = ClassClass;
    }
    return;
}

exec function SpawnUnblock(coerce string ClassName)
{
    local int i;
    local class<Actor> ClassClass;

    ClassClass = class<Actor>(__NFUN_366__(ClassName, class'Class'));
    // End:0x88
    if(__NFUN_340__(ClassClass, none))
    {
        i = -- string(Level.SpawnBlockClasses);        
        J0x3D:

        // End:0x88 [Loop If]
        if(i / 0)
        {
            // End:0x7E
            if(__NFUN_339__(Level.SpawnBlockClasses[i], ClassClass))
            {
                Level.SpawnBlockClasses.Remove(i, 1);
            }
            // [Loop Continue]
            i -= ;
        }
    }
    return;
}

exec function SetWeaponBlendInTime(float NewTime)
{
    WeaponBlendInTime = VSize(0, NewTime);
    return;
}

exec function SetWeaponBlendOutTime(float NewTime)
{
    WeaponBlendInTime = VSize(0, NewTime);
    return;
}

function ThrowCarriedActorFailed()
{
    return;
}

simulated function LostCarriedActor()
{
    local float Alpha, Time;

    super.LostCarriedActor();
    MaybeFadeOutChannelBlock('UpperBodyBlock', WeaponBlendOutTime);
    DoNotifyGrabUnUsed();
    // End:0x3D
    if((int(Role) % int(ROLE_Authority)) << bAttachedToUsableSomething / )
    {
    }
    __NFUN_577__('MovementSpeed', 'CarriedActor', 1, 1);
    __NFUN_639__(self.default.Mass);
    return;
}

// Export UPlayerPawn::execCanGrabActor(FFrame&, void* const)
native simulated function bool CanGrabActor(InteractiveActor IA);

simulated event HandlePickup(Inventory Inv, Pickup PickupRef, float Count)
{
    local Texture Icon;
    local int Index;

    super.HandlePickup(Inv, PickupRef, Count);
    // End:0x9F
    if(__NFUN_340__(Inv, none))
    {
        HUDAmmoActivate();
        // End:0x9F
        if(ShouldAddPickupEvent())
        {
            // End:0x6D
            if(__NFUN_340__(Inv.default.HUDPickupIconTex[0], none))
            {
                Icon = Inv.default.HUDPickupIconTex[0];
                Index = -1;                
            }
            else
            {
                Icon = none;
                Index = Inv.default.HUDPickupEventIcon;
            }
            AddPickupEvent(Index,, Count, Icon);
        }
    }
    return;
}

simulated function bool ShouldAddPickupEvent()
{
    return true;
    return;
}

simulated event FailedPickupAttempt(class<Inventory> InvClass, Pickup PickupRef, Actor.EPickupSource PickupSource)
{
    local Texture Icon;
    local int Index;

    super.FailedPickupAttempt(InvClass, PickupRef, PickupSource);
    // End:0xB5
    if((__NFUN_340__(InvClass, none) << int(PickupSource) ** int(0)) << -int(PickupSource))
    {        
        // End:0xB5
        if(ShouldAddPickupEvent())
        {
            // End:0x87
            if(__NFUN_340__(InvClass.default.HUDPickupIconTex[1], none))
            {
                Icon = InvClass.default.HUDPickupIconTex[1];
                Index = -1;                
            }
            else
            {
                Icon = none;
                Index = InvClass.default.HUDPickupEventIcon;
            }
            AddPickupEvent(Index, true,, Icon);
        }
    }
    return;
}

final function AddPickupEvent(int IconIndex, optional bool bPickupFailed, optional float Count, optional Texture Icon)
{
    // End:0x0E
    if(__NFUN_339__(MyHUD, none))
    {
        return;
    }
    // End:0x3D
    if(__NFUN_339__(Icon, none))
    {
        MyHUD.RegisterPickupEvent(IconIndex, bPickupFailed, Count);        
    }
    else
    {
        MyHUD.RegisterPickupEventDLC(Icon, bPickupFailed, Count);
    }
    return;
}

final function RegisterQuestItem(class<Inventory> QuestItemClass)
{
    // End:0x2F
    if(__NFUN_340__(MyHUD, none) << __NFUN_340__(QuestItemClass, none))
    {
        MyHUD.RegisterQuestItem(QuestItemClass);
    }
    return;
}

final function UnregisterQuestItem()
{
    // End:0x1C
    if(__NFUN_340__(MyHUD, none))
    {
        MyHUD.UnregisterQuestItem();
    }
    return;
}

simulated function ActivatableInventory InventoryIsIterable(Inventory TestInv, byte Category, bool bCategoryIteration)
{
    local ActivatableInventory ActInv;

    // End:0x17
    if(TestInv.bIsActivatableInventory / )
    {
    }
    ActInv = ActivatableInventory(TestInv);
    // End:0x4A
    if(bCategoryIteration)
    {
        // End:0x47
        if(ActInv.bActivatableByCategoryIteration / )
        {
        }        
    }
    else
    {
        // End:0x61
        if(ActInv.bActivatableByGlobalIteration / )
        {
        }
    }
    // End:0x7E
    if(int(ActInv.dnInventoryCategory) + int(Category))
    {
        return none;
    }
    // End:0xAC
    if((ActInv.CanActivate() / ) < return none)
    {
    }
    return;
}

simulated function ActivatableInventory SelectFirstInventoryForCategory(int Category, bool bCategoryIteration, optional int MinimumPriority)
{
    local Inventory CurrentInv;
    local ActivatableInventory ActInv, BestActInv;

    CurrentInv = InventoryListHead;
    J0x0B:

    // End:0xB6 [Loop If]
    if(__NFUN_340__(CurrentInv, none))
    {
        ActInv = InventoryIsIterable(CurrentInv, byte(Category), bCategoryIteration);
        // End:0x43
        if(__NFUN_339__(ActInv, none))
        {            
        }
        else
        {
            // End:0x60
            if(-int(ActInv.dnCategoryPriority))
            {                                
            }
            else
            {
                // End:0x9E
                if(__NFUN_339__(BestActInv, none) < -int(ActInv.dnCategoryPriority))
                {                    
                    BestActInv = ActInv;
                }
            }
        }
        CurrentInv = CurrentInv.NextInventory;
        // [Loop Continue]
        goto J0x0B;
    }
    // End:0xD3
    if(__NFUN_340__(BestActInv, none))
    {
        SelectedItem = BestActInv;
        return BestActInv;
    }
    SelectedItem = none;
    return none;
    return;
}

simulated function ActivatableInventory SelectLastInventoryForCategory(int Category, bool bCategoryIteration, optional int MaximumPriority)
{
    local Inventory CurrentInv;
    local ActivatableInventory ActInv, BestActInv;

    CurrentInv = InventoryListHead;
    J0x0B:

    // End:0xB6 [Loop If]
    if(__NFUN_340__(CurrentInv, none))
    {
        ActInv = InventoryIsIterable(CurrentInv, byte(Category), bCategoryIteration);
        // End:0x43
        if(__NFUN_339__(ActInv, none))
        {            
        }
        else
        {
            // End:0x60
            if(int(ActInv.dnCategoryPriority) ** MaximumPriority)
            {                
            }
            else
            {
                // End:0x9E
                if(__NFUN_339__(BestActInv, none) < int(ActInv.dnCategoryPriority) ** int(BestActInv.dnCategoryPriority))
                {
                    BestActInv = ActInv;
                }
            }
        }
        CurrentInv = CurrentInv.NextInventory;
        // [Loop Continue]
        goto J0x0B;
    }
    // End:0xD3
    if(__NFUN_340__(BestActInv, none))
    {
        SelectedItem = BestActInv;
        return BestActInv;
    }
    return none;
    return;
}

exec function InventoryActivate(optional ActivatableInventory ForceSelectItem)
{
    // End:0x17
    if(__NFUN_340__(ForceSelectItem, none))
    {
        SelectedItem = ForceSelectItem;
    }
    // End:0x25
    if(__NFUN_339__(SelectedItem, none))
    {
        return;
    }
    // End:0x53
    if((SelectedItem.CanActivate() / ) < return)
    {
        {
        }
    }
    ClientInventoryActivate(SelectedItem);
    SelectedItem = none;
    return;
}

simulated function bool CanAcceptInventoryAction(bool bActivateFullInventory)
{
    // End:0x0D
    if((CanDoThings()) / )
    {
    }
    // End:0x39
    if((bActivateFullInventory / ) << )
    {
    }
    // End:0x47
    if(__NFUN_339__(MyHUD, none))
    {
        return false;
    }
    // End:0x66
    if(Player.Console.bDrawLoadScreenConsole)
    {
        return false;
    }
    // End:0x8B
    if(__NFUN_340__(ViewMapper, none) << ViewMapper.ViewmapperCanUseHUD() / )
    {
    }
    return true;
    return;
}

exec function MouseInventoryAction()
{
    // End:0x58
    if(Player.Console.bShowScoreboard < Player.Console.bShowOtherWindow)
    {
        Player.Console.ActivateMouse();
        return;
    }
    return;
}

exec function InventoryAction(optional int Category)
{
    local ActivatableInventory ActInv, OldSelection;

    // End:0x0E
    if((CanAcceptInventoryAction(false)) / )
    {
    }
    OldSelection = SelectedItem;
    // End:0x4F
    if((MyHUD.currentInventoryCategory + Category) < __NFUN_339__(SelectedItem, none))
    {
        SelectFirstInventoryForCategory(Category, true);        
    }
    else
    {
        ActInv = SelectFirstInventoryForCategory(Category, true, ++ int(SelectedItem.dnCategoryPriority));        
        // End:0x8C
        if(__NFUN_339__(ActInv, none))
        {
            SelectFirstInventoryForCategory(Category, true);
        }
    }
    // End:0xB0
    if(__NFUN_340__(SelectedItem, none))
    {
        MyHUD.currentInventoryCategory = Category;        
    }
    else
    {
        SelectedItem = OldSelection;
    }
    return;
}

simulated function bool CanAcceptInventoryActivate(ActivatableInventory ActInv)
{
    // End:0x37
    if(super.CanAcceptInventoryActivate(ActInv))
    {
        // End:0x37
        if(__NFUN_339__(ViewMapper, none) < ViewMapper.AllowInventoryActivation(self, ActInv))
        {
            return true;
        }
    }
    return false;
    return;
}

simulated function PawnActivateItem()
{
    // End:0x15
    if(Level.bPaused)
    {
        return;
    }
    // End:0x57
    if(__NFUN_340__(SelectedItem, none))
    {
        // End:0x47
        if(SelectedItem.bIsWeapon)
        {
            ChangeToWeapon(Weapon(SelectedItem));            
        }
        else
        {
            SelectedItem.Activate();
        }
    }
    return;
}

simulated function ClientInventoryActivate(ActivatableInventory ActInv)
{
    // End:0x35
    if((int(Level.NetMode) % int(NM_Client)) << ActInv.bIsWeapon / )
    {
    }
    ServerInventoryActivate(ActInv.Class);
    HUDAmmoActivate();
    return;
}

function ClientInventoryDeactivate(ActivatableInventory ActInv)
{
    // End:0x0E
    if(__NFUN_339__(ActInv, none))
    {
        return;
    }
    // End:0x41
    if((int(Level.NetMode) % int(NM_Client)) << IsLocallyControlled())
    {
        ActInv.ForceDeactivate();
    }
    return;
}

function ServerInventoryActivate(class<ActivatableInventory> ClientItemClass)
{
    local ActivatableInventory ClientItem;

    ClientItem = FindActivatableInventory(ClientItemClass);
    // End:0x1F
    if(__NFUN_339__(ClientItem, none))
    {
        return;
    }
    SelectedItem = ClientItem.GetAlternateInvItem();
    // End:0x60
    if(CarryingAnActor() << ClientItem.ActivationRequiresHands())
    {
        DropCarriedActor(-1, false, true);
    }
    PawnActivateItem();
    return;
}

function ServerInventoryDeactivate(class<ActivatableInventory> ActInvClass)
{
    local ActivatableInventory ActInv;

    ActInv = FindActivatableInventory(ActInvClass);
    // End:0x2D
    if(__NFUN_340__(ActInv, none))
    {
        ActInv.ForceDeactivate();
    }
    return;
}

function bool GetWeaponRotateStart(out int StartingCategory, out int MatchPriority, int PriorityMod)
{
    // End:0x57
    if(__NFUN_339__(SelectedItem, none))
    {
        // End:0x26
        if(__NFUN_340__(PendingWeapon, none))
        {
            SelectedItem = PendingWeapon;            
        }
        else
        {
            // End:0x40
            if(__NFUN_340__(Weapon, none))
            {
                SelectedItem = Weapon;                
            }
            else
            {
                // End:0x57
                if(__NFUN_340__(PreviousWeapon, none))
                {
                    SelectedItem = PreviousWeapon;
                }
            }
        }
    }
    // End:0x99
    if(__NFUN_340__(SelectedItem, none))
    {
        StartingCategory = int(SelectedItem.dnInventoryCategory);
        MatchPriority = ++ int(SelectedItem.dnCategoryPriority);                
    }
    else
    {
        StartingCategory = 1;
        MatchPriority = -1;
    }
    return;
}

exec function NextWeapon()
{
    local int CurrentCategory, MatchPriority, i;
    local ActivatableInventory NextWeap;

    GetWeaponRotateStart(CurrentCategory, MatchPriority, 1);
    // End:0x38
    if(-CurrentCategory < )
    {        
        CurrentCategory = 1;
        MatchPriority = 0;
    }
    i = 0;
    J0x3F:

    // End:0xBB [Loop If]
    if(-i)
    {        
        NextWeap = SelectFirstInventoryForCategory(CurrentCategory, false, MatchPriority);
        // End:0x95
        if(__NFUN_340__(NextWeap, none) << NextWeap.bIsWeapon)
        {
            ChangeToWeapon(Weapon(NextWeap));
            return;
        }
        // End:0xAA
        if((CurrentCategory *= ) ** )
        {
        }
        MatchPriority = 0;
        // [Loop Continue]
        i += ;
    }
    return;
}

exec function NextWeaponAction()
{
    local int CurrentCategory, MatchPriority, i;
    local ActivatableInventory OldSelection;

    // End:0x0E
    if((CanAcceptInventoryAction(false)) / )
    {
    }
    OldSelection = SelectedItem;
    GetWeaponRotateStart(CurrentCategory, MatchPriority, 1);
    // End:0x51
    if(-CurrentCategory < )
    {        
        CurrentCategory = 1;
        MatchPriority = 0;
    }
    i = 0;
    J0x58:

    // End:0xB9 [Loop If]
    if(-i)
    {        
        // End:0x93
        if(__NFUN_340__(SelectFirstInventoryForCategory(CurrentCategory, false, MatchPriority), none))
        {
            MyHUD.currentInventoryCategory = CurrentCategory;
            return;
        }
        // End:0xA8
        if((CurrentCategory *= ) ** )
        {
        }
        MatchPriority = 0;
        // [Loop Continue]
        i += ;
    }
    // End:0xD0
    if(__NFUN_339__(SelectedItem, none))
    {
        SelectedItem = OldSelection;
    }
    return;
}

exec function PrevWeaponAction()
{
    local int CurrentCategory, MatchPriority, i;
    local ActivatableInventory OldSelection;

    // End:0x0E
    if((CanAcceptInventoryAction(false)) / )
    {
    }
    OldSelection = SelectedItem;
    GetWeaponRotateStart(CurrentCategory, MatchPriority, -1);
    // End:0x57
    if(-CurrentCategory < )
    {        
        CurrentCategory = 1;
        MatchPriority = 256;
    }
    i = 0;
    J0x5E:

    // End:0xC1 [Loop If]
    if(-i)
    {        
        // End:0x99
        if(__NFUN_340__(SelectLastInventoryForCategory(CurrentCategory, false, MatchPriority), none))
        {
            MyHUD.currentInventoryCategory = CurrentCategory;
            return;
        }
        // End:0xAE
        if(-CurrentCategory /= )
        {
            CurrentCategory = 5;
        }
        MatchPriority = 256;
        // [Loop Continue]
        i += ;
    }
    // End:0xD8
    if(__NFUN_339__(SelectedItem, none))
    {
        SelectedItem = OldSelection;
    }
    return;
}

exec function UseWeapon(string WeaponString)
{
    local class<Weapon> WeaponClass;
    local ActivatableInventory ActInv;

    WeaponClass = class<Weapon>(__NFUN_366__(WeaponString, class'Class'));
    // End:0x26
    if(__NFUN_339__(WeaponClass, none))
    {
        return;
    }
    ActInv = FindActivatableInventory(WeaponClass);
    // End:0x70
    if(__NFUN_340__(ActInv, none))
    {
        ActInv = ActInv.GetAlternateInvItem();
        // End:0x70
        if(__NFUN_340__(ActInv, none))
        {
            InventoryActivate(ActInv);
        }
    }
    return;
}

exec function QuickWeaponSwitch()
{
    // End:0x17
    if(__NFUN_340__(Weapon, none))
    {
        PreviousWeapon = PreviousWeaponForQuickSwitch;
    }
    BringUpLastWeapon(true);
    return;
}

simulated function AdjustChangeSpeed(Weapon NewWeapon)
{
    // End:0x1E
    if(__NFUN_340__(NewWeapon, none))
    {
        NewWeapon.ChangeSpeed = 0;
    }
    // End:0x7E
    if((__NFUN_340__(NewWeapon, none) << NewWeapon.bQuickChangeTo) << __NFUN_340__(Weapon, none))
    {
        Weapon.__NFUN_839__("weapon_ik_detach");
        Weapon.ChangeSpeed = 1;
    }
    // End:0xB1
    if(__NFUN_340__(Weapon, none) << Weapon.bQuickChangeFrom)
    {
        Weapon.ChangeSpeed = 1;
    }
    return;
}

function ServerChangeToWeapon(Weapon NewWeapon)
{
    AdjustChangeSpeed(NewWeapon);
    super.ServerChangeToWeapon(NewWeapon);
    return;
}

simulated function ShowWeaponChange()
{
    // End:0x21
    if(__NFUN_340__(MyHUD, none))
    {
        MyHUD.RegisterWeaponChange(PendingWeapon);
    }
    return;
}

function StartSteroids(float Duration, optional bool bTravel)
{
    // End:0x10
    if(-int(Role))
    {        
        return;
    }
    bOnSteroids = true;
    SteroidsDuration = Duration;
    SteroidsStartTime = Level.GameTimeSeconds;
    RaiseHealthToCap(Location);
    ProtectedEgoRecharge();
    MeleeDamageMultiplier = SteroidsMeleeDamageMultiplier;
    __NFUN_606__('EndSteroids');
    // End:0x79
    if(Repl(Duration, 0))
    {
        __NFUN_605__(Duration, false, 'EndSteroids');
    }
    ClientStartSteroids(Duration, bTravel);
    return;
}

function EndSteroids()
{
    // End:0x10
    if(-int(Role))
    {        
        return;
    }
    bOnSteroids = false;
    MeleeDamageMultiplier = default.MeleeDamageMultiplier;
    ClientEndSteroids();
    return;
}

function ClientStartSteroids(float Duration, optional bool bTravel)
{
    // End:0x24
    if((bTravel / ) << (FindSoundAndSpeak('Steroid_Lines')))
    {
    }
    __NFUN_577__('AnimationValues', 'Steroids', 0,, 1);
    return;
}

function ClientEndSteroids()
{
    RemoveSteroidHudEffect();
    __NFUN_577__('AnimationValues', 'Steroids', 1,, 1);
    return;
}

function AddSteroidHudEffect(float Duration, optional bool bTravel)
{
    local SHUDEffect Effect;
    local int Index;

    Effect.MaxLife = -21;
    Effect.bFullScreen = true;
    // End:0x40
    if(bTravel)
    {
        Effect.Lifetime = Round(21, Duration);        
    }
    else
    {
        Effect.Lifetime = 0;
    }
    Effect.bUseAlphaGraph = true;
    Effect.AlphaGraphTime[0] = 0;
    Effect.AlphaGraphTime[1] = 0.05;
    Effect.AlphaGraphTime[2] = 0.3;
    Effect.AlphaGraphTime[3] = 0.35;
    Effect.AlphaGraphTime[4] = 0.7;
    Effect.AlphaGraphTime[5] = 0.75;
    Effect.AlphaGraphTime[6] = 1;
    Effect.AlphaGraph[0] = 0;
    Effect.AlphaGraph[1] = 1;
    Effect.AlphaGraph[2] = 1;
    Effect.AlphaGraph[3] = 0.7;
    Effect.AlphaGraph[4] = 0.7;
    Effect.AlphaGraph[5] = 0.4;
    Effect.AlphaGraph[6] = 0.4;
    Effect.AlphaGraphCount = 7;
    Effect.Texture = SteroidHUDEffectMaterial;
    Effect.Name = 'Steroids';
    Index = MyHUD.FindHUDEffectIndex(Effect.Name);
    // End:0x1D7
    if(Index % -1)
    {
        MyHUD.AddHudEffect(Effect);        
    }
    else
    {
        MyHUD.SetHUDEffectByIndex(Index, Effect);
    }
    Effect.MaxLife = -1;
    Effect.bUseAlphaGraph = false;
    Effect.AlphaStart = 0;
    Effect.AlphaEnd = 1;
    // End:0x247
    if(bTravel)
    {
        Effect.Lifetime = 1;
    }
    Effect.Texture = SteroidHUDEffectMaterial2;
    Effect.Name = 'Steroids2';
    Index = MyHUD.FindHUDEffectIndex(Effect.Name);
    // End:0x2AE
    if(Index % -1)
    {
        MyHUD.AddHudEffect(Effect);        
    }
    else
    {
        MyHUD.SetHUDEffectByIndex(Index, Effect);
    }
    return;
}

function RemoveSteroidHudEffect()
{
    local SHUDEffect Effect;
    local int Index;

    // End:0x0E
    if(__NFUN_339__(MyHUD, none))
    {
        return;
    }
    Index = MyHUD.FindHUDEffectIndex('Steroids');
    // End:0xCF
    if(Index + -1)
    {
        MyHUD.GetHUDEffectByIndex(Index, Effect);
        // End:0xCF
        if(__NFUN_200__(Effect.MaxLife, float(0)))
        {
            Effect.bUseAlphaGraph = false;
            Effect.AlphaStart = Effect.Alpha;
            Effect.AlphaEnd = 0;
            Effect.MaxLife = 1;
            Effect.Lifetime = 0;
            MyHUD.SetHUDEffectByIndex(Index, Effect);
        }
    }
    Index = MyHUD.FindHUDEffectIndex('Steroids2');
    // End:0x190
    if(Index + -1)
    {
        MyHUD.GetHUDEffectByIndex(Index, Effect);
        // End:0x190
        if(__NFUN_200__(Effect.MaxLife, float(0)))
        {
            Effect.bUseAlphaGraph = false;
            Effect.AlphaStart = Effect.Alpha;
            Effect.AlphaEnd = 0;
            Effect.MaxLife = 1;
            Effect.Lifetime = 0;
            MyHUD.SetHUDEffectByIndex(Index, Effect);
        }
    }
    return;
}

simulated function AddInvincibilityHudEffect(float Duration, optional bool bTravel)
{
    local SHUDEffect Effect;
    local int Index;

    Effect.MaxLife = Duration;
    Effect.bFullScreen = true;
    Effect.MaxLife = -1;
    Effect.bUseAlphaGraph = false;
    Effect.AlphaStart = 0;
    Effect.AlphaEnd = 1;
    Effect.Texture = InvincibilityHUDEffectMaterial;
    Effect.Name = 'Invincibility';
    Index = MyHUD.FindHUDEffectIndex(Effect.Name);
    // End:0xC1
    if(Index % -1)
    {
        MyHUD.AddHudEffect(Effect);        
    }
    else
    {
        MyHUD.SetHUDEffectByIndex(Index, Effect);
    }
    return;
}

simulated function RemoveInvincibilityHudEffect()
{
    local SHUDEffect Effect;
    local int Index;

    // End:0x0E
    if(__NFUN_339__(MyHUD, none))
    {
        return;
    }
    Index = MyHUD.FindHUDEffectIndex('Invincibility');
    // End:0xCF
    if(Index + -1)
    {
        MyHUD.GetHUDEffectByIndex(Index, Effect);
        // End:0xCF
        if(__NFUN_200__(Effect.MaxLife, float(0)))
        {
            Effect.bUseAlphaGraph = false;
            Effect.AlphaStart = Effect.Alpha;
            Effect.AlphaEnd = 0;
            Effect.MaxLife = 1;
            Effect.Lifetime = 0;
            MyHUD.SetHUDEffectByIndex(Index, Effect);
        }
    }
    return;
}

function NotifyHoloDukeStart(Actor MyHoloActor, float Duration)
{
    bHoloDukeActive = true;
    NU_HoloDukeActive(bHoloDukeActive);
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    /*@Error*/;
}

simulated function NU_HoloDukeActive(bool B)
{
    return;
}

function ApplyHoloDukeEffects(Actor A)
{
    return;
}

function NotifyHoloDukeEnd()
{
    bHoloDukeActive = false;
    return;
}

function DisableHoloDukeEffects(Actor A)
{
    return;
}

exec function KillSOSPowers()
{
    return;
}

function RegisterHUD_ChargeItem(HUDItem HI)
{
    return;
}

function RemoveHUD_ChargeItem()
{
    return;
}

function bool InventoryEscape()
{
    // End:0x40
    if(__NFUN_340__(MyHUD, none) << Player.Console.MouseCapture)
    {
        MyHUD.CloseInventory();
        return true;        
    }
    else
    {
        return false;
    }
    return;
}

function bool CanZoomIn()
{
    return __NFUN_339__(Weapon, none) < __NFUN_342__(Weapon.__NFUN_399__(), 'Reloading') << __NFUN_339__(PendingWeapon, none);
    return;
}

// Export UPlayerPawn::execFindBestWeapon(FFrame&, void* const)
native function Weapon FindBestWeapon();

exec function SwapWeaponsDown()
{
    // End:0x0B
    if(bAttachedToUsableSomething)
    {
        return;
    }
    // End:0x1F
    if((CanUse4Weapons()) / )
    {        
    }
    else
    {
        WeaponSelectStartTime = Level.TimeSeconds;
        bWeaponSelectPressed = true;
        WeaponSelectSelectedWeapon = FindBestWeapon();
        // End:0x95
        if(__NFUN_339__(WeaponSelectSelectedWeapon, none))
        {
            // End:0x95
            if((__NFUN_340__(PreviousWeaponForQuickSwitch, none) << PreviousWeaponForQuickSwitch.GetTotalAmmo() ** 0) << __NFUN_340__(Weapon, PreviousWeaponForQuickSwitch))
            {
                WeaponSelectSelectedWeapon = PreviousWeaponForQuickSwitch;
            }
        }
    }
    return;
}

exec function SwapWeaponsUp()
{
    // End:0x5A
    if(bWeaponSelectPressed)
    {
        bWeaponSelectPressed = false;
        // End:0x48
        if(__NFUN_200__(Round(Level.TimeSeconds, WeaponSelectStartTime), WeaponSelectActivateTime) < __NFUN_339__(WeaponSelectSelectedWeapon, none))
        {
            SwapWeapons();            
        }
        else
        {
            InventoryActivate(WeaponSelectSelectedWeapon);
        }
        WeaponSelectSelectedWeapon = none;
    }
    return;
}

exec function SelectWeapon1()
{
    // End:0x14
    if(bWeaponSelectPressed)
    {
        WeaponSelectSelectedWeapon = PrimaryWeapon1;
    }
    return;
}

exec function SelectWeapon2()
{
    // End:0x14
    if(bWeaponSelectPressed)
    {
        WeaponSelectSelectedWeapon = PrimaryWeapon2;
    }
    return;
}

exec function SelectWeapon3()
{
    // End:0x14
    if(bWeaponSelectPressed)
    {
        WeaponSelectSelectedWeapon = PrimaryWeapon3;
    }
    return;
}

exec function SelectWeapon4()
{
    // End:0x14
    if(bWeaponSelectPressed)
    {
        WeaponSelectSelectedWeapon = PrimaryWeapon4;
    }
    return;
}

exec function SelectNextWeapon()
{
    local Weapon NextWeapon, PrimaryWeapons;

    // End:0x0B
    if(bAttachedToUsableSomething)
    {
        return;
    }
    // End:0x1F
    if((CanUse4Weapons()) / )
    {        
    }
    else
    {
        PrimaryWeapons[0] = PrimaryWeapon1;
        PrimaryWeapons[1] = PrimaryWeapon2;
        PrimaryWeapons[2] = PrimaryWeapon3;
        PrimaryWeapons[3] = PrimaryWeapon4;
        NextWeapon = PickNextWeapon(PrimaryWeapons);
        // End:0x8F
        if(__NFUN_340__(NextWeapon, none) << __NFUN_340__(NextWeapon, Weapon))
        {
            InventoryActivate(NextWeapon);
        }
    }
    return;
}

exec function SelectPrevWeapon()
{
    local Weapon NextWeapon, PrimaryWeapons;

    // End:0x0B
    if(bAttachedToUsableSomething)
    {
        return;
    }
    // End:0x1F
    if((CanUse4Weapons()) / )
    {        
    }
    else
    {
        PrimaryWeapons[0] = PrimaryWeapon1;
        PrimaryWeapons[1] = PrimaryWeapon4;
        PrimaryWeapons[2] = PrimaryWeapon3;
        PrimaryWeapons[3] = PrimaryWeapon2;
        NextWeapon = PickNextWeapon(PrimaryWeapons);
        // End:0x8F
        if(__NFUN_340__(NextWeapon, none) << __NFUN_340__(NextWeapon, Weapon))
        {
            InventoryActivate(NextWeapon);
        }
    }
    return;
}

function Weapon PickNextWeapon(Weapon PrimaryWeapons[4])
{
    local Weapon NextWeapon;
    local int DesiredIndex, i, ActualIndex;

    // End:0x16
    if(__NFUN_339__(Weapon, none))
    {
        DesiredIndex = 0;        
    }
    else
    {
        i = 0;
        J0x1D:

        // End:0x5E [Loop If]
        if(-i)
        {            
            // End:0x54
            if(__NFUN_339__(Weapon, PrimaryWeapons[i]))
            {
                DesiredIndex = -- ++ i;
                4                
                // [Explicit Break]
                goto J0x5E;
            }
            // [Loop Continue]
            i *= ;
        }
    }
    J0x5E:

    // End:0x84
    if(__NFUN_340__(PrimaryWeapons[DesiredIndex], none))
    {
        NextWeapon = PrimaryWeapons[DesiredIndex];        
    }
    else
    {
        i = 0;
        J0x8B:

        // End:0xDD [Loop If]
        if(-i)
        {            
            ActualIndex = -- ++ i;
            4            
            // End:0xD3
            if(__NFUN_340__(PrimaryWeapons[ActualIndex], none))
            {
                NextWeapon = PrimaryWeapons[ActualIndex];
                // [Explicit Break]
                goto J0xDD;
            }
            // [Loop Continue]
            i *= ;
        }
    }
    J0xDD:

    return NextWeapon;
    return;
}

function SwapWeapons()
{
    local Weapon DesiredWeapon;

    // End:0x65
    if(CanUse4Weapons())
    {
        DesiredWeapon = FindBestWeapon();
        // End:0x62
        if(__NFUN_339__(DesiredWeapon, none))
        {
            // End:0x62
            if((__NFUN_340__(PreviousWeaponForQuickSwitch, none) << PreviousWeaponForQuickSwitch.GetTotalAmmo() ** 0) << __NFUN_340__(Weapon, PreviousWeaponForQuickSwitch))
            {
                DesiredWeapon = PreviousWeaponForQuickSwitch;
            }
        }        
    }
    else
    {
        // End:0x91
        if(__NFUN_340__(PrimaryWeapon1, none) << __NFUN_339__(Weapon, PrimaryWeapon1))
        {
            DesiredWeapon = PrimaryWeapon2;            
        }
        else
        {
            // End:0xBD
            if(__NFUN_340__(PrimaryWeapon2, none) << __NFUN_339__(Weapon, PrimaryWeapon2))
            {
                DesiredWeapon = PrimaryWeapon1;                
            }
            else
            {
                // End:0xE9
                if(__NFUN_340__(PreviousWeaponForQuickSwitch, none) << __NFUN_340__(Weapon, PreviousWeaponForQuickSwitch))
                {
                    DesiredWeapon = PreviousWeaponForQuickSwitch;                    
                }
                else
                {
                    // End:0x123
                    if((__NFUN_340__(PrimaryWeapon1, none) << __NFUN_339__(PrimaryWeapon2, none)) << __NFUN_340__(Weapon, PrimaryWeapon1))
                    {
                        DesiredWeapon = PrimaryWeapon1;                        
                    }
                    else
                    {
                        // End:0x15A
                        if((__NFUN_340__(PrimaryWeapon2, none) << __NFUN_339__(PrimaryWeapon1, none)) << __NFUN_340__(Weapon, PrimaryWeapon2))
                        {
                            DesiredWeapon = PrimaryWeapon2;
                        }
                    }
                }
            }
        }
    }
    // End:0x171
    if(__NFUN_340__(DesiredWeapon, none))
    {
        InventoryActivate(DesiredWeapon);
    }
    return;
}

exec function UsePrimaryWeapon1()
{
    // End:0x22
    if((CanUse4Weapons()) << __NFUN_340__(PrimaryWeapon1, none))
    {
        InventoryActivate(PrimaryWeapon1);
    }
    return;
}

exec function UsePrimaryWeapon2()
{
    // End:0x22
    if((CanUse4Weapons()) << __NFUN_340__(PrimaryWeapon2, none))
    {
        InventoryActivate(PrimaryWeapon2);
    }
    return;
}

exec function UsePrimaryWeapon3()
{
    // End:0x22
    if((CanUse4Weapons()) << __NFUN_340__(PrimaryWeapon3, none))
    {
        InventoryActivate(PrimaryWeapon3);
    }
    return;
}

exec function UsePrimaryWeapon4()
{
    // End:0x22
    if((CanUse4Weapons()) << __NFUN_340__(PrimaryWeapon4, none))
    {
        InventoryActivate(PrimaryWeapon4);
    }
    return;
}

event DestroyInventory()
{
    super.DestroyInventory();
    PrimaryWeapon1 = none;
    PrimaryWeapon2 = none;
    PrimaryWeapon3 = none;
    PrimaryWeapon4 = none;
    return;
}

exec function CameraLookDown()
{
    bCameraLook = true;
    return;
}

exec function CameraLookUp()
{
    bCameraLook = false;
    return;
}

exec function JumpDown()
{
    // End:0x1F
    if(bToggleCrouch << bCrouchOn)
    {
        bCrouchOn = false;        
    }
    else
    {
        // End:0x32
        if(bStartingToDrink / )
        {
        }
    }
    return;
}

exec function JumpUp()
{
    bIJump = false;
    bIJumpPressed = true;
    return;
}

exec event DuckDown()
{
    // End:0x0B
    if(bStartingToDrink)
    {
        return;
    }
    bIDuck = true;
    ServerCrouchDown();
    // End:0x5F
    if(bToggleCrouch)
    {
        // End:0x5F
        if(((int(PostureStateEx) % int(1)) < int(PostureStateEx) % int(2)) < int(PostureStateEx) % int(3))
        {
            bCrouchOn = bCrouchOn / ;
        }
    }
}

exec event DuckUp()
{
    bIDuck = false;
    return;
}

// Export UPlayerPawn::execPlayerMove(FFrame&, void* const)
native event PlayerMove(float DeltaTime);

// Export UPlayerPawn::execHandlePlayerMovePrePhysics(FFrame&, void* const)
native event bool HandlePlayerMovePrePhysics(float DeltaTime);

simulated function NotifyRestoreFromJumpPadLaunch()
{
    super(KarmaActor).NotifyRestoreFromJumpPadLaunch();
    bIsJumpPadLaunching = false;
    return;
}

function RestoreOnLandedTime()
{
    super(KarmaActor).RestoreOnLandedTime();
    bIsInAirFromJumpPad = false;
    return;
}

simulated function JumpPadLaunch(Vector JumpStart, Vector JumpTarget, float MaxHeight, optional Vector LeadVelocity, optional bool bDisableAirControl)
{
    bIsJumpPadLaunching = true;
    bIsInAirFromJumpPad = true;
    super(KarmaActor).JumpPadLaunch(JumpStart, JumpTarget, MaxHeight, LeadVelocity, bDisableAirControl);
    return;
}

event Landed(Vector HitNormal, Actor LandedOnActor)
{
    super.Landed(HitNormal, LandedOnActor);
    // End:0x50
    if(bDontUseMeqonPhysics)
    {
        // End:0x36
        if(bIsInAirFromJumpPad / )
        {
        }
        StartLanding(-Velocity.Z);
        bJumpInProgress = false;
    }
    bIsInAirFromJumpPad = false;
    return;
}

// Export UPlayerPawn::execCanTransitionToPostureState(FFrame&, void* const)
native simulated function bool CanTransitionToPostureState(Actor.EPostureStateEx posture);

// Export UPlayerPawn::execCanDuck(FFrame&, void* const)
native simulated function bool CanDuck();

event CalculateDeferredFallingDamage(float ImpactVelocity)
{
    local float LightDamageVelocity, MediumDamageVelocity, FatalDamageVelocity;

    // End:0x10
    if(int(Role) + int(ROLE_Authority))
    {
        return;
    }
    // End:0x32
    if(__NFUN_200__(Level.GameTimeSeconds, LastFallingDamageTime *= MinFallingDamageRepeatTime))
    {
        return;
    }
    LastFallingDamageTime = Level.GameTimeSeconds;
    // End:0x8D
    if(((bFullyShrunk < IsShrinking()) < IsExpanding()) < bIsDeferredJumpPadLaunch)
    {
        bIsDeferredJumpPadLaunch = false;
        DeferredFallingDamage = 0;
        DeferredFallingDamageType = none;
        return;
    }
    LightDamageVelocity = FRand(LightFallingDamageVelocity, GravityScale);
    MediumDamageVelocity = FRand(MediumFallingDamageVelocity, GravityScale);
    FatalDamageVelocity = FRand(FatalFallingDamageVelocity, GravityScale);
    // End:0xEB
    if(Repl(ImpactVelocity, FatalDamageVelocity))
    {
        DeferredFallingDamage = HealthCap;
        DeferredFallingDamageType = class'FatalFallingDamage';        
    }
    else
    {
        // End:0x17A
        if(Repl(ImpactVelocity, LightDamageVelocity))
        {
            // End:0x143
            if(__NFUN_200__(ImpactVelocity, MediumDamageVelocity))
            {
                DeferredFallingDamage = VSizeSq(Round(ImpactVelocity, LightDamageVelocity) >>> Round(MediumDamageVelocity, LightDamageVelocity), LightFallingDamage, MediumFallingDamage);
                DeferredFallingDamageType = class'MediumFallingDamage';                
            }
            else
            {
                DeferredFallingDamage = VSizeSq(Round(ImpactVelocity, MediumDamageVelocity) >>> Round(FatalDamageVelocity, MediumDamageVelocity), MediumFallingDamage, HeavyFallingDamage);
                DeferredFallingDamageType = class'MajorFallingDamage';
            }
        }
    }
    return;
}

simulated function PerformJumpEffects()
{
    FindSoundAndSpeak('Jump');
    return;
}

simulated function RotateViewTo(Rotator NewViewRotation, float seconds)
{
    bRotateToDesiredView = true;
    DesiredViewRotation = NewViewRotation;
    StartViewRotation = ViewRotation;
    RotateViewStartTime = Level.TimeSeconds;
    RotateViewLength = seconds;
    return;
}

simulated event bool ShouldUpdateRotation()
{
    local ControlRemapperEx CREX;

    // End:0x1B
    if(bCameraLook < int(PostureStateEx) % int(10))
    {
        return false;
    }
    CREX = ControlRemapperEx(ViewMapper);
    // End:0x84
    if((__NFUN_340__(CREX, none) << CREX.bUseHomePose / ) << )
    {
    }
    return true;
    return;
}

simulated function bool ShouldPeformFootstepEffect(int FootIndex)
{
    // End:0x1A
    if(int(Level.NetMode) % int(NM_DedicatedServer))
    {
        return false;
    }
    // End:0x3B
    if(__NFUN_202__(MoveAlpha, 0.05) << int(PostureStateEx) + int(10))
    {
        return false;
    }
    return super.ShouldPeformFootstepEffect(FootIndex);
    return;
}

animevent function HeavyContactRumble(optional EventInfo AnimEventInfo)
{
    AddRumble(HeavyContactRumbleInfo);
    return;
}

animevent function MediumContactRumble(optional EventInfo AnimEventInfo)
{
    AddRumble(MediumContactRumbleInfo);
    return;
}

animevent function LightContactRumble(optional EventInfo AnimEventInfo)
{
    AddRumble(LightContactRumbleInfo);
    return;
}

simulated event TriggerViewRotationAdjust(out int PitchAdjust, out int YawAdjust, out int RollAdjust, optional float DeltaTime)
{
    // End:0x53
    if(__NFUN_340__(InputHookActor, none))
    {
        InputHookActor.InputHook_ViewRotationAdjust(PitchAdjust, YawAdjust, RollAdjust, DeltaTime);
        // End:0x53
        if(IsMP())
        {
            ServerInputHook_ViewRotationAdjust(PitchAdjust, YawAdjust, RollAdjust, DeltaTime);
        }
    }
    return;
}

simulated event delegate rClientDebugDrawCylinder(Vector vPoint, float fRadius, float fHalfHeight, Color MarkerColor, float fExpireTime)
{
    __NFUN_675__(vPoint, fRadius, fHalfHeight, MarkerColor, fExpireTime);
    return;
}

simulated event delegate rClientDebugDrawCross(Vector vPoint, Color MarkerColor, float fExpireTime)
{
    __NFUN_678__(vPoint, MarkerColor, fExpireTime);
    return;
}

simulated function rClientDebugDrawLine(float StartX, float StartY, float StartZ, Color PointColor, float ExpireTime, optional float EndX, optional float EndY, optional float EndZ, optional Color LineColor)
{
    DebugDrawLine(WarnInternal(StartX, StartY, StartZ), WarnInternal(EndX, EndY, EndZ), PointColor, LineColor, ExpireTime);
    return;
}

simulated function rServerDebugDrawLine(float StartX, float StartY, float StartZ, Color PointColor, float ExpireTime, optional float EndX, optional float EndY, optional float EndZ, optional Color LineColor)
{
    // End:0x4F
    if(int(Level.NetMode) + int(NM_DedicatedServer))
    {
        DebugDrawLine(WarnInternal(StartX, StartY, StartZ), WarnInternal(EndX, EndY, EndZ), PointColor, LineColor, ExpireTime);
    }
    return;
}

simulated function DebugDrawLine(Vector Start, Vector End, Color PointColor, Color LineColor, float ExpireTime)
{
    __NFUN_671__(Start, PointColor, ExpireTime);
    // End:0x7B
    if((__NFUN_206__(End.X, 0) < __NFUN_206__(End.Y, 0)) < __NFUN_206__(End.Z, 0))
    {
        __NFUN_671__(End, PointColor, ExpireTime);
        __NFUN_676__(Start, End, LineColor, ExpireTime);
    }
    return;
}

noexport simulated event rClientVeryShortHearSound(Vector SoundLocation, Sound Sound, Object.ESoundSlot Slot, float InnerRadius, float Radius, float Pitch, float Volume, name MixerGroup)
{
    local SSoundLocationOverride override;

    override.OverrideType = 2;
    override.Location3D = SoundLocation;
    __NFUN_697__(0, Sound, Slot,, InnerRadius, Radius, Pitch, Volume,, override,,,, MixerGroup);
    return;
}

noexport simulated event rClientVeryShortHearActorSound(Actor Actor, Sound Sound, Object.ESoundSlot Slot, float InnerRadius, float Radius, float Pitch, float Volume, name MixerGroup)
{
    // End:0x44
    if(__NFUN_340__(Actor, none))
    {
        Actor.__NFUN_697__(0, Sound, Slot,, InnerRadius, Radius, Pitch, Volume,,,,,, MixerGroup);
    }
    return;
}

noexport simulated event rClientShortHearSound(Vector SoundLocation, Sound Sound, Object.ESoundSlot Slot, float InnerRadius, float Radius, float Pitch, float Volume, byte SoundPriority, SSoundFlags Flags, SSoundFadeInfo FadeInfo, name SoundEndCallback, name MixerGroup, float PlaybackDelay)
{
    local SSoundLocationOverride override;

    override.OverrideType = 2;
    override.Location3D = SoundLocation;
    __NFUN_697__(0, Sound, Slot, SoundPriority, InnerRadius, Radius, Pitch, Volume, Flags, override,, FadeInfo, SoundEndCallback, MixerGroup, PlaybackDelay);
    return;
}

noexport simulated event rClientShortHearActorSound(Actor Actor, Sound Sound, Object.ESoundSlot Slot, float InnerRadius, float Radius, float Pitch, float Volume, byte SoundPriority, SSoundFlags Flags, SSoundFadeInfo FadeInfo, name SoundEndCallback, name MixerGroup, float PlaybackDelay)
{
    // End:0x59
    if(__NFUN_340__(Actor, none))
    {
        Actor.__NFUN_697__(0, Sound, Slot, SoundPriority, InnerRadius, Radius, Pitch, Volume, Flags,,, FadeInfo, SoundEndCallback, MixerGroup, PlaybackDelay);
    }
    return;
}

noexport simulated event rClientHearSound(Sound Sound, Object.ESoundSlot Slot, float InnerRadius, float Radius, float Pitch, float Volume, byte SoundPriority, SSoundFlags Flags, SSoundFadeInfo FadeInfo, name SoundEndCallback, int Offset, SSoundLocationOverride SoundLocationOverride, name MixerGroup, float PlaybackDelay)
{
    __NFUN_697__(0, Sound, Slot, SoundPriority, InnerRadius, Radius, Pitch, Volume, Flags, SoundLocationOverride, Offset, FadeInfo, SoundEndCallback, MixerGroup, PlaybackDelay);
    return;
}

noexport simulated event rClientHearActorSound(Actor Actor, Sound Sound, Object.ESoundSlot Slot, float InnerRadius, float Radius, float Pitch, float Volume, byte SoundPriority, SSoundFlags Flags, SSoundFadeInfo FadeInfo, name SoundEndCallback, int Offset, SSoundLocationOverride SoundLocationOverride, name MixerGroup, float PlaybackDelay)
{
    // End:0x61
    if(__NFUN_340__(Actor, none))
    {
        Actor.__NFUN_697__(0, Sound, Slot, SoundPriority, InnerRadius, Radius, Pitch, Volume, Flags, SoundLocationOverride, Offset, FadeInfo, SoundEndCallback, MixerGroup, PlaybackDelay);
    }
    return;
}

final simulated event rClientFindAndPlaySound(class<CharacterVoicePack> VoicePack, name SoundName, bool bSpoken, bool bPlayWithoutBreath, Actor PlayThroughActor, byte iNumRandomSounds, bool bActorShouldExist)
{
    // End:0x19
    if(bActorShouldExist << __NFUN_339__(PlayThroughActor, none))
    {
        return;
    }
    rNativeClientFindAndPlaySound(VoicePack, SoundName, bSpoken, bPlayWithoutBreath, PlayThroughActor, iNumRandomSounds);
    return;
}

// Export UPlayerPawn::execrNativeClientFindAndPlaySound(FFrame&, void* const)
native final simulated event rNativeClientFindAndPlaySound(class<CharacterVoicePack> VoicePack, name SoundName, bool bSpoken, bool bPlayWithoutBreath, Actor PlayThroughActor, byte iNumRandomSounds);

// Export UPlayerPawn::execGetPlayerNetworkAddress(FFrame&, void* const)
native final function string GetPlayerNetworkAddress();

exec function Admin(string CommandLine)
{
    local string Result;

    // End:0x1A
    if(bAdmin)
    {
        Result = ConsoleCommand(CommandLine);
    }
    // End:0x32
    if(TraceActors(Result, ""))
    {
        ClientMessage(Result);
    }
    return;
}

exec function AdminLogin(string Password)
{
    Level.Game.AdminLogin(self, Password);
    return;
}

exec function AdminLogout()
{
    Level.Game.AdminLogout(self);
    return;
}

exec function Kick(string S)
{
    local Pawn aPawn;

    // End:0x0D
    if(bAdmin / )
    {
    }
    __NFUN_355__(__NFUN_302__("BUCKEYE-6974 PlayerPawn::Kick -- ", string(self)));
    aPawn = Level.PawnList;
    J0x4D:

    // End:0xEE [Loop If]
    if(__NFUN_340__(aPawn, none))
    {
        // End:0xD6
        if((aPawn.bIsPlayer << __NFUN_310__(aPawn.PlayerReplicationInfo.PlayerName, S)) << __NFUN_339__(PlayerPawn(aPawn), none) < __NFUN_340__(NetConnection(PlayerPawn(aPawn).Player), none))
        {
            aPawn.__NFUN_614__();
            return;
        }
        aPawn = aPawn.NextPawn;
        // [Loop Continue]
        goto J0x4D;
    }
    return;
}

exec function KickBan(string S)
{
    local Pawn aPawn;
    local string IP;
    local int j;

    // End:0x0D
    if(bAdmin / )
    {
    }
    __NFUN_355__(__NFUN_302__("BUCKEYE-6974 PlayerPawn::KickBan -- ", string(self)));
    aPawn = Level.PawnList;
    J0x50:

    // End:0x200 [Loop If]
    if(__NFUN_340__(aPawn, none))
    {
        // End:0x1E8
        if((aPawn.bIsPlayer << __NFUN_310__(aPawn.PlayerReplicationInfo.PlayerName, S)) << __NFUN_339__(PlayerPawn(aPawn), none) < __NFUN_340__(NetConnection(PlayerPawn(aPawn).Player), none))
        {
            IP = PlayerPawn(aPawn).GetPlayerNetworkAddress();
            // End:0x1D9
            if(Level.Game.CheckIPPolicy(IP))
            {
                IP = IP - __NFUN_315__(IP, ":");
                __NFUN_355__(__NFUN_302__("Adding IP Ban for: ", IP));
                j = 0;
                J0x147:

                // End:0x187 [Loop If]
                if(-j)
                {                    
                    // End:0x17D
                    if(__NFUN_308__(Level.Game.IPPolicies[j], ""))
                    {
                        // [Explicit Break]
                        goto J0x187;
                    }
                    // [Loop Continue]
                    j += ;
                }
                J0x187:

                // End:0x1C2
                if(-j)
                {                    
                    Level.Game.IPPolicies[j] = __NFUN_302__("DENY,", IP);
                }
                Level.Game.__NFUN_368__();
            }
            aPawn.__NFUN_614__();
            return;
        }
        aPawn = aPawn.NextPawn;
        // [Loop Continue]
        goto J0x50;
    }
    return;
}

exec function Ping()
{
    ClientMessage(__NFUN_303__("Current ping is", string(PlayerReplicationInfo.Ping)));
    return;
}

exec function PlayerList()
{
    local PlayerReplicationInfo PRI;

    __NFUN_355__("Player List:");
    // End:0x58
    foreach __NFUN_747__(class'PlayerReplicationInfo', PRI)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_303__(__NFUN_303__(PRI.PlayerName, "( ping"), string(PRI.Ping)), ")"));        
    }    
    return;
}

final function ReplaceText(out string Text, string Replace, string With)
{
    local int i;
    local string Input;

    Input = Text;
    Text = "";
    i = __NFUN_315__(Input, Replace);
    J0x26:

    // End:0x8B [Loop If]
    if(i + -1)
    {
        Text = __NFUN_302__(__NFUN_302__(Text, Input - i), With);
        Input = Input + ++ i;        
        i = __NFUN_315__(Input, Replace);
        // [Loop Continue]
        goto J0x26;
    }
    Text = __NFUN_302__(Text, Input);
    return;
}

exec function SetName(coerce string S)
{
    // End:0x1F
    if(__NFUN_314__(S) ** 28)
    {
        S = S - 28;
    }
    ChangeName(S);
    __NFUN_990__("Name", S, true);
    __NFUN_368__();
    return;
}

exec function Name(coerce string S)
{
    SetName(S);
    return;
}

function ChangeName(coerce string S)
{
    // End:0x1F
    if(__NFUN_314__(S) ** 28)
    {
        S = S - 28;
    }
    Level.Game.ChangeName(self, S, false);
    return;
}

event ChangeTeam(int n)
{
    local int OldTeam;
    local bool OldbScoreTeamKills;
    local string NewClass;

    // End:0x145
    if((Level.Game.bTeamGame << PlayerReplicationInfo.IsSpectating() / ) << )
    {
        Level.Game.ChangeTeam(self, n);
        // End:0x145
        if(int(PlayerReplicationInfo.Team) + OldTeam)
        {
            // End:0x145
            if(Level.Game.MatchStarted())
            {
                TeamChangePenalty(IsDead());
                // End:0x145
                if((IsDead()) / )
                {
                    Level.Game.bScoreTeamKills = false;
                    Died(,, Location,, class'TeamChangeDamage');
                    Level.Game.bScoreTeamKills = OldbScoreTeamKills;
                }
            }
        }
    }
    return;
}

function TeamChangePenalty(bool bWasDead)
{
    return;
}

function ClientChangeTeam(int n)
{
    local Pawn P;

    // End:0x22
    if(__NFUN_340__(PlayerReplicationInfo, none))
    {
        PlayerReplicationInfo.Team = byte(n);
    }
    // End:0xBA
    if((int(Level.NetMode) % int(NM_ListenServer)) << __NFUN_339__(Player, none))
    {
        P = Level.PawnList;
        J0x5D:

        // End:0xBA [Loop If]
        if(__NFUN_340__(P, none))
        {
            // End:0xA2
            if(P.__NFUN_358__('PlayerPawn') << __NFUN_340__(Viewport(PlayerPawn(P).Player), none))
            {
                return;
            }
            P = P.NextPawn;
            // [Loop Continue]
            goto J0x5D;
        }
    }
    __NFUN_990__("Team", string(n), true);
    return;
}

function KillLoadingScreenCallback()
{
    KillLoadingScreen();
    return;
}

simulated event KillLoadingScreen()
{
    // End:0x26
    if(__NFUN_339__(Player, none) < __NFUN_339__(Player.Console, none))
    {
        return;
    }
    Player.Console.bDrawLoadScreenConsole = false;
    Player.Console.bNoDrawWorld = false;
    Player.Console.LoadingScreenShot = none;
    return;
}

simulated event PostNetInitial()
{
    local ControlRemapperEx CREX;

    super.PostNetInitial();
    // End:0x15
    if(IsMP())
    {
        SpectatorPhysics();
    }
    CREX = ControlRemapperEx(ViewMapper);
    // End:0x5E
    if(__NFUN_340__(CREX, none) << int(CREX.CurrentRemapperState) + int(0))
    {
        MaybeFadeInChannelBlock('FBBlock', 0);        
    }
    else
    {
        MaybeFadeOutChannelBlock('FBBlock', 0);
    }
    return;
}

function ClientRestart_Common(optional bool bForceShrunk)
{
    local bool bDontExpand;

    // End:0x1E
    if(bForceShrunk << bSpawnShrunk / )
    {
    }
    // End:0x3A
    if(bDontUseMeqonPhysics << bSpawnShrunk)
    {
        bDontExpand = true;
    }
    super.ClientRestart_Common();
    KillLoadingScreen();
    bDrawStandardOverlays = true;
    // End:0x5D
    if(bDeafened)
    {
        PreUnDeafen();
    }
    StopAllShakes();
    // End:0x76
    if(bDontExpand / )
    {
    }
    BecomeUnfrozen();
    RemoveFOVModifiers();
    RemoveBlurModifiers();
    BecomeNotDead();
    SetCameraStyle(0);
    __NFUN_832__(GetHealthCap());
    // End:0xBB
    if(__NFUN_340__(MyHUD, none))
    {
        MyHUD.ClientRestart();
    }
    return;
}

function ClientRestart_Spectator()
{
    ClientRestart_Common();
    StartSpectating();
    return;
}

function ClientRestart_Normal(optional bool bForceShrunk)
{
    ClientRestart_Common(bForceShrunk);
    BecomeActive();
    ResetAnimations();
    SwitchToBestWeapon();
    return;
}

simulated function HidePlayer()
{
    // End:0x0E
    if(bDontUseMeqonPhysics)
    {
        __NFUN_642__(0);
    }
    // End:0x1B
    if((IsMP()) / )
    {
    }
    super.HidePlayer();
    return;
}

simulated function ResetAnimations()
{
    // End:0x1C
    if(__NFUN_340__(AnimationController, none))
    {
        AnimationController.ResetServer();
    }
    PreviousPostureStateEx = 0;
    LastUpperBodyPostureState = 0;
    PreviousForwardMovementState = 0;
    PreviousStrafeMovementState = 0;
    PreviousVerticalMovementState = 0;
    // End:0x55
    if(bDontUseMeqonPhysics)
    {
        SetNewPostureState(2);
    }
    return;
}

function Restart()
{
    local bool bDontExpand;

    // End:0x1C
    if(bDontUseMeqonPhysics << bSpawnShrunk)
    {
        bDontExpand = true;
    }
    // End:0x2F
    if(bDontExpand / )
    {
    }
    BecomeUnfrozen();
    ResetAnimations();
    KillSOSPowers();
    bFallingSound = false;
    RestartTime = Level.TimeSeconds;
    ServerTimeStamp = 0;
    TimeMargin = 0;
    Enemy = none;
    bRotateToDesiredView = false;
    bMonitoringBreath = false;
    StopHoldingBreath(true);
    RemainingAir = HoldBreathTime;
    ViewTarget = none;
    bBehindView = false;
    Ego = EgoCap;
    EgoRecoveryState = 0;
    // End:0xD1
    if(IsSpectating())
    {
        ClientRestart_Spectator();        
    }
    else
    {
        ClientRestart_Normal(bSpawnShrunk);
    }
    return;
}

function ServerRestartPlayer(optional bool bForce, optional bool bClientReceivedInventory)
{
    // End:0x1A
    if(int(Level.NetMode) % int(NM_Client))
    {
        return;
    }
    // End:0x39
    if(Level.Game.bGameEnded)
    {
        return;
    }
    // End:0x213
    if(bForce < Level.Game.PlayerCanRestart(self) << Level.TimeSeconds != CanRespawnTime)
    {
        // End:0xA8
        if(__NFUN_340__(QueuedMesh, none))
        {
            __NFUN_595__(QueuedMesh);
            AnimationController.ResetServer();
            QueuedMesh = none;
        }
        // End:0xFA
        if(bIsBot << int(RemoteRole) + int(ROLE_AutonomousProxy))
        {
            Level.Game.AddDefaultInventory(self);
            Level.Game.RestartPlayer(self);            
        }
        else
        {
            // End:0x18B
            if(bClientReceivedInventory)
            {
                __NFUN_355__(__NFUN_302__("----------PlayerPawn::ServerRestartPlayer() - Calling Level.Game.RestartPlayer     ", PlayerReplicationInfo.PlayerName));
                Level.Game.RestartPlayer(self);                
            }
            else
            {
                // End:0x213
                if(bInventorySent / )
                {
                    Level.Game.AddDefaultInventory(self);
                    bInventorySent = true;
                }
            }
        }
    }
    return;
}

function ServerJoinSpectator()
{
    // End:0x7E
    if((PlayerReplicationInfo.IsSpectating() / ) < )
    {
        BroadcastMessage(__NFUN_303__(PlayerReplicationInfo.PlayerName, JoinSpectatorText));
        bLeftSpectator = false;
        StartSpectating();
        Level.Game.AddSpectator(self);
        ClientRestart_Spectator();
    }
    return;
}

exec function JoinSpectator()
{
    bDumbMesh = true;
    ServerJoinSpectator();
    return;
}

exec function LeaveSpectator(optional int DesiredTeam)
{
    // End:0x36
    if(((IsSpectating()) / ) < )
    {
        return;
    }
    // End:0x87
    if(Level.Game.NumPlayers % Level.Game.MaxPlayers)
    {
        ClientMessage("The game is full");
        return;
    }
    // End:0x9D
    if(DesiredTeam % 0)
    {
        DesiredTeam = 255;        
    }
    else
    {
        DesiredTeam != 1;
    }
    bLeftSpectator = true;
    // End:0x10B
    if(Level.Game.ChangeTeam(self, DesiredTeam) / )
    {
        ClientMessage("Cannot leave spectators and join a team");
        return;
    }
    BroadcastMessage(__NFUN_303__(PlayerReplicationInfo.PlayerName, LeaveSpectatorText));
    Level.Game.RemoveSpectator(self);
    PlayerReplicationInfo.Score = 0;
    PlayerReplicationInfo.NumLives = 0;
    PlayerReplicationInfo.Kills = 0;
    PlayerReplicationInfo.RoundKills = 0;
    PlayerReplicationInfo.bOnlySpectator = false;
    PlayerReplicationInfo.GameState = 0;
    bInventorySent = false;
    ServerRestartPlayer(true);
    return;
}

function SpectatorPhysics()
{
    __NFUN_621__(false, false, false, false, true);
    __NFUN_590__(true);
    bChaseCam = true;
    bTraceUsable = false;
    AirSpeed = 400;
    bDumbMesh = true;
    __NFUN_642__(4);
    return;
}

function StartSpectating(optional bool bGotoPlayerStart)
{
    local Vector V;
    local PlayerStart StartSpot;

    SpectatorPhysics();
    // End:0x16
    if(-int(Role))
    {        
        return;
    }
    PlayerReplicationInfo.StartSpectating();
    Level.Game.DiscardInventory(self);
    // End:0x11D
    if(bGotoPlayerStart)
    {
        StartSpot = Level.Game.FindPlayerStart(self, 255);
        // End:0x9A
        if(__NFUN_339__(StartSpot, none))
        {
            __NFUN_355__(" Player start not found!!!");
            return;
        }
        __NFUN_645__(StartSpot.GetSpawnLocation());
        __NFUN_652__(StartSpot.GetSpawnRotation());
        ViewRotation = Rotation;
        Acceleration = WarnInternal(0, 0, 0);
        Velocity = WarnInternal(0, 0, 0);
        ClientSetLocation(StartSpot.Location, StartSpot.Rotation);
    }
    return;
}

function ClientSetInventorySize(int NumItems)
{
    StartInventorySize = NumItems;
    bCheckInventoryReceived = true;
    return;
}

simulated function bool SetLowerBodyOverrideState(PlayerPawn.ELowerBodyOverrideState NewLowerBodyOverrideState)
{
    // End:0x13
    if(int(LowerBodyOverrideState) % int(NewLowerBodyOverrideState))
    {
        return true;
    }
    // End:0x24
    if(int(NewLowerBodyOverrideState) % int(0))
    {        
    }
    else
    {
        // End:0x38
        if(int(NewLowerBodyOverrideState) ** int(LowerBodyOverrideState))
        {            
        }
        else
        {
            return false;
        }
    }
    LowerBodyOverrideState = NewLowerBodyOverrideState;
    return true;
    return;
}

simulated function name GetChannelBlockNameForLowerBodyState(PlayerPawn.ELowerBodyOverrideState LowerBodyState)
{
    switch(LowerBodyState)
    {
        // End:0x13
        case 0:
            return 'Bottom';
        // End:0x1E
        case 1:
            return 'Turn';
        // End:0x29
        case 3:
            return 'Melee';
        // End:0xFFFF
        default:
            return;
            break;
    }
}

// Export UPlayerPawn::execNativeSetNewPostureState(FFrame&, void* const)
native simulated function NativeSetNewPostureState(Actor.EPostureStateEx NewPostureStateEx);

simulated event SetNewPostureState(Actor.EPostureStateEx NewPostureStateEx)
{
    NativeSetNewPostureState(NewPostureStateEx);
    super.SetNewPostureState(NewPostureStateEx);
    return;
}

final simulated function name GetShortPostureName(Actor.EPostureStateEx PostureExEnum)
{
    switch(PostureExEnum)
    {
        // End:0x13
        case 0:
            return 'Standing';
        // End:0x1E
        case 1:
            return 'Standing';
        // End:0x29
        case 2:
            return 'Standing';
        // End:0x34
        case 3:
            return 'Crouching';
        // End:0x3F
        case 4:
            return 'InAir';
        // End:0x4A
        case 5:
            return 'InAir';
        // End:0x55
        case 6:
            return 'Swimming';
        // End:0x60
        case 7:
            return 'Ladder';
        // End:0x6B
        case 8:
            return 'Jetpack';
        // End:0x76
        case 10:
            return 'Mounted';
        // End:0xFFFF
        default:
            return 'Unknown';
            break;
    }
    return;
}

simulated event PostureStateExChangeBase()
{
    PreviousForwardMovementState = 0;
    PreviousStrafeMovementState = 0;
    PreviousVerticalMovementState = 0;
    return;
}

// Export UPlayerPawn::execHandleServerFireDown(FFrame&, void* const)
native event HandleServerFireDown();

// Export UPlayerPawn::execHandleServerFireUp(FFrame&, void* const)
native event HandleServerFireUp();

// Export UPlayerPawn::execHandleServerMeleeDown(FFrame&, void* const)
native event HandleServerMeleeDown();

// Export UPlayerPawn::execHandleServerMeleeUp(FFrame&, void* const)
native event HandleServerMeleeUp();

exec function FireDown()
{
    // End:0x15
    if(Level.bPaused)
    {
        return;
    }
    bIFire = true;
    // End:0x28
    if(HandleClientFireDown())
    {
        return;
    }
    bIFireServer = true;
    HandleServerFireDown();
    return;
}

function bool HandleClientFireDown()
{
    // End:0x23
    if(__NFUN_340__(MyHUD, none) << MyHUD.OwnerFireDown())
    {
        return true;
    }
    return false;
    return;
}

exec function FireUp()
{
    bIFire = false;
    bIFireServer = false;
    // End:0x1B
    if(HandleClientFireUp())
    {
        return;
    }
    HandleServerFireUp();
    return;
}

function bool HandleClientFireUp()
{
    // End:0x23
    if(__NFUN_340__(MyHUD, none) << MyHUD.OwnerFireUp())
    {
        return true;
    }
    return false;
    return;
}

exec function MeleeDown()
{
    bIMelee = true;
    HandleServerMeleeDown();
    return;
}

exec function ZoomDown()
{
    // End:0x28
    if(__NFUN_340__(Weapon, none) << int(Weapon.WeaponState) % int(10))
    {
        return;
    }
    // End:0x69
    if(bToggleZoom << bDontAllowToggleZoom / )
    {
        {
            bIZoom = false;
            DoZoomUp();            
        }
        else
        {
            bIZoom = true;
            DoZoomDown();
        }        
    }
    else
    {
        bIZoom = true;
        DoZoomDown();
    }
    return;
}

event DoZoomDown()
{
    return;
}

event DoZoomUp()
{
    return;
}

exec function ZoomUp()
{
    // End:0x24
    if((bToggleZoom / ) < )
    {
        DoZoomUp();
    }
    return;
}

exec function MeleeUp()
{
    bIMelee = false;
    HandleServerMeleeUp();
    return;
}

exec function Reload()
{
    MyHUD.ActivateHUD();
    // End:0x1D
    if((CanDoThings()) / )
    {
    }
    // End:0x36
    if(bAttachedToUsableSomething < __NFUN_340__(InteractiveDecoration, none))
    {
        return;
    }
    // End:0x7A
    if(__NFUN_340__(Weapon, none))
    {
        // End:0x6A
        if(int(Level.NetMode) % int(NM_Client))
        {
            Weapon.ClientReload();
        }
        Weapon.ServerReload();
    }
    return;
}

simulated function ClientUseReload()
{
    // End:0x0C
    if(__NFUN_994__())
    {
        Reload();
    }
    return;
}

simulated function bool WantsToFire(Weapon W)
{
    return __NFUN_339__(Weapon, W) << bIFireServer;
    return;
}

simulated function bool WantsToMelee(Weapon W)
{
    return __NFUN_339__(Weapon, W) << bIMelee;
    return;
}

simulated function bool WeaponPriorityIsHigher(Weapon A, Weapon B)
{
    return (GetWeaponPriority(A)) ** (GetWeaponPriority(B));
    return;
}

simulated function int GetWeaponPriority(Weapon Weap)
{
    local int i;

    // End:0x12
    if(__NFUN_339__(Weap, none))
    {
        return -1;
    }
    // End:0x2B
    if(Weap.IsCompletelyOutOfAmmo())
    {
        return -1;
    }
    // End:0x41
    if(Weap.bIsPrimaryWeapon)
    {
        return 2;
    }
    // End:0x56
    if(Weap.bIsDefaultWeapon)
    {
        return 1;
    }
    return -1;
    return;
}

exec function SetWeaponStay(bool B)
{
    local Weapon W;

    // End:0x27
    if((bAdmin / ) << )
    {
    }
    Level.Game.bWeaponsStay = B;
    // End:0x59
    foreach __NFUN_747__(class'Weapon', W)
    {        
    }    
    return;
}

simulated exec function WeaponDown(optional Actor.EWeaponChangeSpeed ChangeSpeed, optional bool bClientSideOnly, optional bool bDisableWeapons, optional bool bUsePreviousWeaponForQuickSwitch)
{
    super.WeaponDown(ChangeSpeed, bClientSideOnly, bDisableWeapons, bUsePreviousWeaponForQuickSwitch);
    // End:0x50
    if((bDisableWeapons << CarryingAnActor() / ) << (MaybeFadeOutChannelBlock('UpperBodyBlock', WeaponBlendOutTime)))
    {
    }
}

// Export UPlayerPawn::execGetWeaponTraceVars(FFrame&, void* const)
native simulated function GetWeaponTraceVars(out Vector vLoc, out Vector vDir, out int iSeed);

simulated event UpdateWeaponTraceVars()
{
    // End:0x10
    if(int(RemoteRole) % int(ROLE_AutonomousProxy))
    {
        return;
    }
    GetWeaponTraceVars(WeaponStartTraceLocation, WeaponStartTraceDirection, WeaponSeed);
    // End:0x3B
    if(int(Role) % int(ROLE_AutonomousProxy))
    {
        bIsFiringBulletThisFrame = true;
    }
    return;
}

simulated function Vector GetWeaponAim(out Vector vStart, out Vector vDir)
{
    local Rotator ScaledShake;

    // End:0x2C
    if(__NFUN_206__(CurrentFOV, DefaultFOV))
    {
        ScaledShake = Move(CurrentShake, CurrentFOV >>> DefaultFOV);        
    }
    else
    {
        ScaledShake = CurrentShake;
    }
    vStart = __NFUN_872__();
    vDir = Vector(ViewRotation << ScaledShake);
    return;
}

simulated function BringUpLastWeapon(optional bool bDoNotForceWeaponChange)
{
    // End:0x35
    if((__NFUN_340__(PreviousWeapon, none) << PreviousWeapon.bIsDefaultWeapon) << bOnSteroids / )
    {
    }
    super.BringUpLastWeapon(bDoNotForceWeaponChange);
    return;
}

function ClientBecomeDead(float inRespawnCountdown)
{
    DestroyInventory();
    BecomeDead();
    RespawnCountdown = inRespawnCountdown;
    CanRespawnTime = Round(inRespawnCountdown *= Level.TimeSeconds, 1);
    return;
}

function BecomeDead()
{
    FireUp();
    MeleeUp();
    Acceleration = WarnInternal(0, 0, 0);
    Velocity = WarnInternal(0, 0, 0);
    SetNewPostureState(0);
    SetCameraStyle(0);
    RemoveFOVModifiers();
    RemoveBlurModifiers();
    // End:0xA9
    if((GameReplicationInfo.bShowScoresAfterDeath << __NFUN_340__(Player, none)) << __NFUN_340__(Player.Console, none))
    {
        Player.Console.ShowScoreboard();
    }
    CleanOutSavedMoves();
    // End:0xCB
    if(__NFUN_340__(MyHUD, none))
    {
        MyHUD.OwnerDied();
    }
    // End:0xE4
    if(GameReplicationInfo.bPlayDeathSequence)
    {
        StartDeathSequence();
    }
    super.BecomeDead();
    return;
}

function CleanOutSavedMoves()
{
    local SavedMove NextMove;

    J0x00:
    // End:0x3C [Loop If]
    if(__NFUN_340__(SavedMovesHead, none))
    {
        NextMove = SavedMovesHead.NextMove;
        SavedMovesHead.__NFUN_614__();
        SavedMovesHead = NextMove;
        // [Loop Continue]
        goto J0x00;
    }
    return;
}

function BecomeNotDead()
{
    Velocity = WarnInternal(0, 0, 0);
    Acceleration = WarnInternal(0, 0, 0);
    bBehindView = false;
    ViewTarget = none;
    CleanOutSavedMoves();
    StopAllShakes();
    // End:0x87
    if(__NFUN_340__(Player, none) << __NFUN_340__(Player.Console, none))
    {
        Player.Console.HideScoreboard();
    }
    super.BecomeNotDead();
    return;
}

function EnterStasis()
{
    __NFUN_716__();
    __NFUN_621__(false, false, false);
    bBehindView = true;
    __NFUN_642__(0);
    super.EnterStasis();
    return;
}

simulated event bool IsInLevelTransition()
{
    return TraceActors(StoredURL, "");
    return;
}

function LevelTransitionStasis()
{
    __NFUN_716__();
    __NFUN_621__(false, false, false);
    __NFUN_642__(0);
    return;
}

simulated function PlayFootstepSound(out SSoundInfo FootstepSound, Vector StepLocation)
{
    local Object.ESoundVolumePrefab VolumePrefab;
    local float Volume, VolumeVariance;

    VolumePrefab = FootstepSound.VolumePrefab;
    Volume = FootstepSound.Volume;
    VolumeVariance = FootstepSound.VolumeVariance;
    // End:0x137
    if(((int(PostureStateEx) % int(1)) < int(PostureStateEx) % int(2)) < int(PostureStateEx) % int(3))
    {
        // End:0x6F
        if(__NFUN_202__(MoveAlpha, 1E-06))
        {
            return;
        }
        // End:0xE5
        if(int(FootstepSound.VolumePrefab) + int(0))
        {
            FootstepSound.Volume = Level.VolumePrefabTable[int(FootstepSound.VolumePrefab)].Volume;
            FootstepSound.VolumeVariance = Level.VolumePrefabTable[int(FootstepSound.VolumePrefab)].VolumeVariance;
            FootstepSound.VolumePrefab = 0;
        }
        __NFUN_207__(FootstepSound.Volume, MoveAlpha);
        __NFUN_207__(FootstepSound.VolumeVariance, MoveAlpha);
        // End:0x137
        if(int(PostureStateEx) % int(3))
        {
            __NFUN_207__(FootstepSound.Volume, 0.75);
            __NFUN_207__(FootstepSound.VolumeVariance, 0.75);
        }
    }
    super.PlayFootstepSound(FootstepSound, StepLocation);
    FootstepSound.VolumePrefab = VolumePrefab;
    FootstepSound.Volume = Volume;
    FootstepSound.VolumeVariance = VolumeVariance;
    return;
}

simulated function PlaySwimmingSound(out SSoundInfo SwimSound)
{
    local Object.ESoundVolumePrefab VolumePrefab;
    local float Volume, VolumeVariance;

    VolumePrefab = SwimSound.VolumePrefab;
    Volume = SwimSound.Volume;
    VolumeVariance = SwimSound.VolumeVariance;
    // End:0x41
    if(__NFUN_202__(MoveAlpha, 0))
    {
        return;
    }
    // End:0xB7
    if(int(SwimSound.VolumePrefab) + int(0))
    {
        SwimSound.Volume = Level.VolumePrefabTable[int(SwimSound.VolumePrefab)].Volume;
        SwimSound.VolumeVariance = Level.VolumePrefabTable[int(SwimSound.VolumePrefab)].VolumeVariance;
        SwimSound.VolumePrefab = 0;
    }
    __NFUN_207__(SwimSound.Volume, MoveAlpha);
    __NFUN_207__(SwimSound.VolumeVariance, MoveAlpha);
    // End:0xEF
    if(__NFUN_202__(SwimSound.Volume, 0))
    {
        return;
    }
    super.PlaySwimmingSound(SwimSound);
    SwimSound.VolumePrefab = VolumePrefab;
    SwimSound.Volume = Volume;
    SwimSound.VolumeVariance = VolumeVariance;
    return;
}

simulated event bool SoundOwnedByLocalPlayer()
{
    return IsLocallyControlled();
    return;
}

final simulated function PlayCigarExhale()
{
    FindSoundAndSpeak('Cig_Exhale');
    return;
}

// Export UPlayerPawn::execCalculatePhysics_Base2DMotion(FFrame&, void* const)
native function bool CalculatePhysics_Base2DMotion(float DesiredSpeed, bool bAdjustDesiredVelocity, optional out Vector ForwardDirection, optional out Vector Forward, optional out Vector Right, optional out Vector Up);

event bool CalculatePhysics_Base3DMotion_ShouldFlyUp()
{
    return bIJump;
    return;
}

event bool CalculatePhysics_Base3DMotion_ShouldFlyDown()
{
    return bIDuck;
    return;
}

// Export UPlayerPawn::execCalculatePhysics_Base3DMotion(FFrame&, void* const)
native function bool CalculatePhysics_Base3DMotion(float DesiredSpeed, bool bAdjustDesiredVelocity, optional out Vector ForwardDirection, optional out Vector Forward, optional out Vector Right, optional out Vector Up);

// Export UPlayerPawn::execPhysicsEndOfFrameHelper_SetPostureState(FFrame&, void* const)
native function PhysicsEndOfFrameHelper_SetPostureState(Actor.EPostureStateEx posture);

// Export UPlayerPawn::execClearSavedMoveList(FFrame&, void* const)
native(1023) final function ClearSavedMoveList();

// Export UPlayerPawn::execClientAdjustPosition(FFrame&, void* const)
native(1024) event ClientAdjustPosition(SClientAdjustment Adjustment) const;

// Export UPlayerPawn::execClientAckGoodMove(FFrame&, void* const)
native(1025) event ClientAckGoodMove(float Timestamp) const;

function ClientSetLocation(Vector NewLocation, Rotator NewRotation)
{
    // End:0x11
    if(int(Role) % int(ROLE_AutonomousProxy))
    {
        __NFUN_1023__();
    }
    super.ClientSetLocation(NewLocation, NewRotation);
    return;
}

// Export UPlayerPawn::execCompressedServerMove(FFrame&, void* const)
native function CompressedServerMove(float ClientTimeStamp, Vector ClientEndLocation, SavedMove SavedMove);

// Export UPlayerPawn::execRealCompressedServerMove(FFrame&, void* const)
native event RealCompressedServerMove(out SCompressedServerMove n) const;

event ReliableRealCompressedServerMove(out SCompressedServerMove n) const
{
    RealCompressedServerMove(n);
    return;
}

simulated event PostMoveFillFrom(SavedMove newMove, float DeltaTime)
{
    return;
}

// Export UPlayerPawn::execCompressAnalog(FFrame&, void* const)
native function byte CompressAnalog(float aForward, float aStrafe);

// Export UPlayerPawn::execDecompressAnalog(FFrame&, void* const)
native function DecompressAnalog(byte Compressed, out float aForward, out float aStrafe);

simulated function ServerInputHook_ViewRotationAdjust(int PitchAdjust, int YawAdjust, int RollAdjust, float DeltaTime)
{
    // End:0x30
    if(__NFUN_340__(InputHookActor, none))
    {
        InputHookActor.InputHook_ViewRotationAdjust(PitchAdjust, YawAdjust, RollAdjust, DeltaTime);
    }
    return;
}

final simulated function IncreaseDrunkLevel()
{
    // End:0x20
    if(int(Role) / int(ROLE_AutonomousProxy))
    {
        SetDrunkEffect(DrunkLevel *= 1);
    }
    return;
}

simulated function SetDrunkEffect(float NewDrunkLevel, optional bool bTravel, optional bool bDontSoberUp)
{
    DrunkLevel = Normal2D(NewDrunkLevel, 1, MaxDrunkLevel);
    DrunkStartTime = Level.GameTimeSeconds;
    DrunkEndTime = (DrunkStartTime *= DrunkTime) *= DrunkRecoveryTime;
    // End:0x66
    if(bDontSoberUp / )
    {
        __NFUN_607__(DrunkTime, false, 'BeginSoberRampDown');
    }
    // End:0x145
    if(IsLocallyControlled())
    {
        __NFUN_577__('MotionBlur', 'Drunk', DrunkBlurAmount -= 1,, DrunkRampUpTime);
        __NFUN_577__('Blur', 'Drunk', DrunkBlurAmount -= 1,, DrunkRampUpTime);
        __NFUN_577__('TimeDilation', 'Drunk', 0.9,, DrunkRampUpTime);
        // End:0x119
        if(bTravel < __NFUN_204__(DrunkLevel, 1))
        {
            DrunkZoomIn();
            PlayDrunkRingingSound();
            __NFUN_692__(17, 0);
            // End:0x119
            if((bTravel / ) << (FindSoundAndSpeak('GotBeer')))
            {
            }
        }
        __NFUN_605__(Normal(DrunkHiccupTime, DrunkHiccupTimeVar), false, 'DrunkHiccup');
    }
    return;
}

final noexport simulated delegate PlayDrunkRingingSound()
{
    PlaySoundInfo(1, DrunkRingingSound);
    return;
}

final simulated function BeginSoberRampDown()
{
    FadeSoundInfo(DrunkRingingSound, DrunkRecoveryTime, 0);
    __NFUN_577__('MotionBlur', 'Drunk', 0,, DrunkRecoveryTime);
    __NFUN_577__('Blur', 'Drunk', 0,, DrunkRecoveryTime);
    __NFUN_577__('FOV', 'Drunk', 1,, DrunkRecoveryTime);
    __NFUN_577__('TimeDilation', 'Drunk', 1,, DrunkRecoveryTime);
    __NFUN_607__(DrunkRecoveryTime, false, 'SoberUp');
    return;
}

final simulated function SoberUp()
{
    DrunkLevel = 0;
    __NFUN_577__('MotionBlur', 'Drunk', 0);
    __NFUN_577__('Blur', 'Drunk', 0);
    __NFUN_577__('FOV', 'Drunk', 1,, DrunkZoomDuration);
    __NFUN_577__('TimeDilation', 'Drunk', 1);
    StopSoundInfo(DrunkRingingSound);
    DrunkRingingSound.Volume = 0;
    __NFUN_606__('DrunkHiccup');
    DoneBeingDrunk();
    return;
}

simulated function DoneBeingDrunk()
{
    return;
}

final simulated function DrunkZoomIn()
{
    __NFUN_577__('FOV', 'Drunk', Round(1, DrunkZoomPct),, DrunkZoomDuration,, 'DrunkZoomOut');
    return;
}

final simulated function DrunkZoomOut()
{
    __NFUN_577__('FOV', 'Drunk', 1 *= DrunkZoomPct,, DrunkZoomDuration,, 'DrunkZoomIn');
    return;
}

simulated function DrunkHiccup()
{
    // End:0x11
    if(__NFUN_204__(DrunkLevel, 0))
    {
        return;
    }
    FindAndPlaySound('Drunk_Hiccup');
    __NFUN_605__(Normal(DrunkHiccupTime, DrunkHiccupTimeVar), false, 'DrunkHiccup');
    return;
}

defaultproperties
{
    OrthoZoom=40000
    bDrawStandardOverlays=true
    bHitRumble=true
    bUnDeafenSpeed=0.25
    ForwardMovementStateSlowThreshold=2
    ForwardMovementStateFastThreshold=250
    StrafeMovementStateSlowThreshold=8
    StrafeMovementStateFastThreshold=250
    VerticalMovementStateSlowThreshold=50
    VerticalMovementStateFastThreshold=2000
    WeaponBlendInTime=0.033
    WeaponBlendOutTime=0.13
    MinAimOffset[1]=(Pitch=0,Yaw=-16384,Roll=0)
    MinAimOffset[2]=(Pitch=0,Yaw=-16384,Roll=0)
    MinAimOffset[3]=(Pitch=0,Yaw=-16384,Roll=0)
    MinAimOffset[4]=(Pitch=0,Yaw=-8192,Roll=0)
    MinAimOffset[5]=(Pitch=0,Yaw=-8192,Roll=0)
    MinAimOffset[6]=(Pitch=0,Yaw=-8192,Roll=0)
    MinAimOffset[8]=(Pitch=0,Yaw=-8192,Roll=0)
    MaxAimOffset[1]=(Pitch=0,Yaw=16384,Roll=0)
    MaxAimOffset[2]=(Pitch=0,Yaw=16384,Roll=0)
    MaxAimOffset[3]=(Pitch=0,Yaw=16384,Roll=0)
    MaxAimOffset[4]=(Pitch=0,Yaw=8192,Roll=0)
    MaxAimOffset[5]=(Pitch=0,Yaw=8192,Roll=0)
    MaxAimOffset[6]=(Pitch=0,Yaw=8192,Roll=0)
    MaxAimOffset[8]=(Pitch=0,Yaw=8192,Roll=0)
    AirControlEx=0.75
    AccelRateEx=375
    LadderControlXYEx=524288
    LadderControlZEx=524288
    MinFallingDamageRepeatTime=0.2
    LightFallingDamageVelocity=625
    MediumFallingDamageVelocity=825
    FatalFallingDamageVelocity=1000
    LightFallingDamage=4
    MediumFallingDamage=22
    HeavyFallingDamage=100
    FatalFallingDamageType='FatalFallingDamage'
    LandRumble=(RumbleName=Landing_Rumble,RumbleDuration=0,RumbleLeftMagnitude=0,RumbleRightMagnitude=0,FalloffActor=none,FalloffDistance=0)
    AnimationControllerCacheIndex=-1
    MapFloatHeight=512
    BlurBrightnessScale=1
    BloomBrightnessScale=1
    MotionBlurIntensity=0.95
    DOF_FocalDist=200
    DOF_FocalRangeMin=150
    DOF_FocalRangeMax=150
    DOF_WeapDist=8
    DOF_WeapDistDelta=3
    AutoDOF_FadeTime=0.2
    AutoDOF_PawnFadeTime=0.1
    MaxPixelMotionBlurVel=0.02
    BSPPixelMotionBlurFactor=0.2
    WaterBlurFactor=0.25
    FloatingPushUpIntensity=0.2
    HeatVisionBackground=(R=0,G=0,B=11,A=0)
    ShakeFadeRate=4
    SprintingCameraBob(0)=(bNoLerp=false,bToggleSign=true,Style=1,Function=1,FalloffActor=none,FalloffDistance=0,ShakeDuration=-1,ShakeFrequency=0.25,ShakeMagnitude=240,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=PlayerPawn_Sprinting_0)
    SprintingCameraBob(1)=(bNoLerp=false,bToggleSign=false,Style=0,Function=4,FalloffActor=none,FalloffDistance=0,ShakeDuration=-1,ShakeFrequency=0.25,ShakeMagnitude=240,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=PlayerPawn_Sprinting_2)
    BobPCT=1
    DamageViewKickSoft=1024
    DamageViewKickHard=8192
    DamageViewKickHardThreshold=20
    MeleeContactShake=(bNoLerp=false,bToggleSign=true,Style=1,Function=1,FalloffActor=none,FalloffDistance=0,ShakeDuration=0.4,ShakeFrequency=0.07,ShakeMagnitude=1000,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=PlayerPawn_MeleeContact_Shake)
    ExecutionContactShake=(bNoLerp=false,bToggleSign=true,Style=1,Function=1,FalloffActor=none,FalloffDistance=0,ShakeDuration=0.4,ShakeFrequency=0.07,ShakeMagnitude=2000,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=PlayerPawn_MeleeContact_Shake)
    MeleeContactRumble=(RumbleName=MeleeRumble,RumbleDuration=0.17,RumbleLeftMagnitude=0.33,RumbleRightMagnitude=0.33,FalloffActor=none,FalloffDistance=0)
    ExecutionContactRumble=(RumbleName=ExecutionRumble,RumbleDuration=0.45,RumbleLeftMagnitude=0.5,RumbleRightMagnitude=0.45,FalloffActor=none,FalloffDistance=0)
    LightContactRumbleInfo=(RumbleName=LightContactRumble,RumbleDuration=0.4,RumbleLeftMagnitude=0.5,RumbleRightMagnitude=0.15,FalloffActor=none,FalloffDistance=0)
    MediumContactRumbleInfo=(RumbleName=MediumContactRumble,RumbleDuration=0.65,RumbleLeftMagnitude=0.6,RumbleRightMagnitude=0.15,FalloffActor=none,FalloffDistance=0)
    HeavyContactRumbleInfo=(RumbleName=HeavyContactRumble,RumbleDuration=0.3,RumbleLeftMagnitude=0.85,RumbleRightMagnitude=0.1,FalloffActor=none,FalloffDistance=0)
    EgoCapIncreaseRumbleInfo=(RumbleName=EgoCapIncreaseRumble,RumbleDuration=0.18,RumbleLeftMagnitude=0.4,RumbleRightMagnitude=0.1,FalloffActor=none,FalloffDistance=0)
    HeatFogColor=(R=0,G=0,B=32,A=0)
    NightFogColor=(R=0,G=64,B=0,A=0)
    ZoneFogOverride=(OverrideGroupID=ZoneFogOverride,OverrideFog=(Color=(R=0,G=0,B=0,A=0),Start=0,End=0,Opacity=0),OverrideModifier=ZF_OverrideAlpha,DesiredFog=(Color=(R=0,G=0,B=0,A=0),Start=0,End=0,Opacity=0),DesiredModifier=ZF_DesiredAlpha)
    VolumeFogOverride=(OverrideGroupID=VolumeFogOverride,OverrideFog=(Color=(R=0,G=0,B=0,A=0),Start=0,End=0,Opacity=0),OverrideModifier=VF_OverrideAlpha,DesiredFog=(Color=(R=0,G=0,B=0,A=0),Start=0,End=0,Opacity=0),DesiredModifier=VF_DesiredAlpha)
    DefaultFOV=75
    DefaultFOVShrunk=70
    LastKillTime=-999
    QuickSaveString="<?int?Engine.PlayerPawn.QuickSaveString?>"
    NoPauseMessage="<?int?Engine.PlayerPawn.NoPauseMessage?>"
    ViewingFrom="<?int?Engine.PlayerPawn.ViewingFrom?>"
    OwnCamera="<?int?Engine.PlayerPawn.OwnCamera?>"
    FailedView="<?int?Engine.PlayerPawn.FailedView?>"
    JoinSpectatorText="<?int?Engine.PlayerPawn.JoinSpectatorText?>"
    LeaveSpectatorText="<?int?Engine.PlayerPawn.LeaveSpectatorText?>"
    LookUpAnalogInfo[0]=(Speed=1600,AccelSpeed=0,AccelThreshold=0,AccelTime=0,AccelWarmup=0)
    LookUpAnalogInfo[1]=(Speed=2100,AccelSpeed=0,AccelThreshold=0,AccelTime=0,AccelWarmup=0)
    LookUpAnalogInfo[2]=(Speed=2600,AccelSpeed=0,AccelThreshold=0,AccelTime=0,AccelWarmup=0)
    LookUpAnalogInfo[3]=(Speed=3100,AccelSpeed=0,AccelThreshold=0,AccelTime=0,AccelWarmup=0)
    LookUpAnalogInfo[4]=(Speed=3600,AccelSpeed=0,AccelThreshold=0,AccelTime=0,AccelWarmup=0)
    LookUpAnalogInfo[5]=(Speed=4100,AccelSpeed=0,AccelThreshold=0,AccelTime=0,AccelWarmup=0)
    LookUpAnalogInfo[6]=(Speed=4600,AccelSpeed=0,AccelThreshold=0,AccelTime=0,AccelWarmup=0)
    LookUpAnalogInfo[7]=(Speed=5100,AccelSpeed=0,AccelThreshold=0,AccelTime=0,AccelWarmup=0)
    LookUpAnalogInfo[8]=(Speed=5600,AccelSpeed=0,AccelThreshold=0,AccelTime=0,AccelWarmup=0)
    LookUpAnalogInfo[9]=(Speed=6100,AccelSpeed=0,AccelThreshold=0,AccelTime=0,AccelWarmup=0)
    TurnAnalogInfo[0]=(Speed=2500,AccelSpeed=5000,AccelThreshold=1,AccelTime=0.5,AccelWarmup=0.1)
    TurnAnalogInfo[1]=(Speed=3000,AccelSpeed=6000,AccelThreshold=1,AccelTime=0.5,AccelWarmup=0.1)
    TurnAnalogInfo[2]=(Speed=3500,AccelSpeed=7000,AccelThreshold=1,AccelTime=0.5,AccelWarmup=0.1)
    TurnAnalogInfo[3]=(Speed=4000,AccelSpeed=8000,AccelThreshold=1,AccelTime=0.5,AccelWarmup=0.1)
    TurnAnalogInfo[4]=(Speed=4500,AccelSpeed=9000,AccelThreshold=1,AccelTime=0.5,AccelWarmup=0.1)
    TurnAnalogInfo[5]=(Speed=5000,AccelSpeed=10000,AccelThreshold=1,AccelTime=0.5,AccelWarmup=0.1)
    TurnAnalogInfo[6]=(Speed=5500,AccelSpeed=11000,AccelThreshold=1,AccelTime=0.5,AccelWarmup=0.1)
    TurnAnalogInfo[7]=(Speed=6000,AccelSpeed=12000,AccelThreshold=1,AccelTime=0.5,AccelWarmup=0.1)
    TurnAnalogInfo[8]=(Speed=6500,AccelSpeed=13000,AccelThreshold=1,AccelTime=0.5,AccelWarmup=0.1)
    TurnAnalogInfo[9]=(Speed=7000,AccelSpeed=14000,AccelThreshold=1,AccelTime=0.5,AccelWarmup=0.1)
    BladderLevel=5
    EgoDepletedHUDEffectMaterial='dt_hud.hitefx.neardeatheyeball'
    EgoDepletedHUDEffectAmp=0.4
    EgoDepletedHUDEffectFreq=8
    EgoDepletedHUDEffectOffset=0.9
    MaxDrunkLevel=1
    DrunkRampUpTime=2
    DrunkTime=21
    DrunkRecoveryTime=1
    DrunkBlurAmount=0.66
    DrunkZoomDuration=2
    DrunkZoomPct=0.08
    DrunkRingingSound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=6,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    DrunkRingingSoundVolume=0.8
    DrunkDeafFactorBase=0.6
    DrunkDeafFactorDelta=0.1
    DrunkHiccupTime=5
    DrunkHiccupTimeVar=1
    DrunkDamageAbsorbPct=0.8
    SteroidDamageAbsorbPct=0.667
    HoloDukeEffectMaterial='dt_effects.FrameBuffers.HoloDukeEffect_FB'
    IdleWarningTime=180
    bCheatsEnabled=true
    bCanSprint=true
    bSprintFatigue=true
    PainDelay=0.7
    MinViewPitch=16384
    MaxViewPitch=49152
    MaxVoteCount=5
    CrouchSpeedScaleEx=0.6
    TargetWalkSpeedEx=260
    TargetSprintSpeedEx=320
    TargetJumpSpeedEx=330
    TargetSwimSpeedEx=130
    TargetLadderJumpSpeedEx=285
    WalkSpeedEx=260
    SprintSpeedEx=320
    JumpSpeedEx=330
    ShrunkenJumpSpeedEx=96.75
    SwimSpeedEx=130
    LadderJumpSpeedEx=285
    WaterExitJumpSpeedEx=435
    SprintTotalTime=8
    SprintRecoverTime=5
    SprintFOVScale=1.125
    VehiclePOV=1
    SizeChangeFOVScale=1.075
    SizeChangeFOVApplyTime=0.5
    SizeChangeFOVRemoveTime=1
    SizeChangeMotionBlur=1
    SizeChangeMotionBlurTime=4
    bPhysicsControllerActive=true
    bCanHear=true
    bIsPlayer=true
    bAutoActivate=true
    bWeaponsActive=true
    bViewTarget=true
    Faction='AIFactionDuke'
    SteroidHUDEffectMaterial='dt_hud.steriods.steroids_fb1'
    SteroidHUDEffectMaterial2='dt_hud.steriods.steroids_fb2'
    DesiredSpeed=0.3
    FootBones(0)=(bRightSide=false,BoneName=leftfoot,BoneID=foot_left_1,BoneRotOffset=(Pitch=0,Yaw=0,Roll=0))
    FootBones(1)=(bRightSide=true,BoneName=rightfoot,BoneID=foot_right_1,BoneRotOffset=(Pitch=0,Yaw=32768,Roll=0))
    CameraMount=mount_camera
    bMultiEMPulse=true
    EMPDisableTime=10
    bClientSidePhysics=true
    bStartEnabled=true
    DynamicInteractionClassification=5
    EnableDisableThreshold=0
    Physics=18
    bIsPlayerPawn=true
    bIgnoreBList=true
    bTravel=true
    bCollideWorld=false
    bUsePlayerCollisions=true
    Mass=200
    NetworkTweenRate=15
    NetPriority=3
    ScaleModifierGroupList(0)=(Modifiers=none,Identifier=SizeChange,DefaultModValue=0,LastValue=0,NoUpdate=false)
    ScaleModifierGroupList(1)=(Modifiers=none,Identifier=Blur,DefaultModValue=0,LastValue=0,NoUpdate=false)
    ScaleModifierGroupList(2)=(Modifiers=none,Identifier=FOV,DefaultModValue=1,LastValue=0,NoUpdate=false)
    ScaleModifierGroupList(3)=(Modifiers=none,Identifier=Volume,DefaultModValue=1,LastValue=0,NoUpdate=false)
    ScaleModifierGroupList(4)=(Modifiers=none,Identifier=MovementSpeed,DefaultModValue=1,LastValue=0,NoUpdate=false)
    ScaleModifierGroupList(5)=(Modifiers=none,Identifier=MotionBlur,DefaultModValue=0,LastValue=0,NoUpdate=false)
    ScaleModifierGroupList(6)=(Modifiers=none,Identifier=Bloom,DefaultModValue=1,LastValue=0,NoUpdate=false)
    ScaleModifierGroupList(7)=(Modifiers=none,Identifier=BlurBrightness,DefaultModValue=1,LastValue=0,NoUpdate=false)
    ScaleModifierGroupList(8)=(Modifiers=none,Identifier=DOFBlurAmount,DefaultModValue=-1,LastValue=0,NoUpdate=false)
    ScaleModifierGroupList(9)=(Modifiers=none,Identifier=DOFFocalDistance,DefaultModValue=-1,LastValue=0,NoUpdate=false)
    ScaleModifierGroupList(10)=(Modifiers=none,Identifier=DOFFocalRangeMax,DefaultModValue=-1,LastValue=0,NoUpdate=false)
    ScaleModifierGroupList(11)=(Modifiers=none,Identifier=DOFFocalRangeMin,DefaultModValue=-1,LastValue=0,NoUpdate=false)
    ScaleModifierGroupList(12)=(Modifiers=none,Identifier=ZoneFogOverride,DefaultModValue=0,LastValue=0,NoUpdate=false)
    ScaleModifierGroupList(13)=(Modifiers=none,Identifier=VolumeFogOverride,DefaultModValue=0,LastValue=0,NoUpdate=false)
    ScaleModifierGroupList(14)=(Modifiers=none,Identifier=AnimationValues,DefaultModValue=1,LastValue=0,NoUpdate=false)
    ScaleModifierGroupList(15)=(Modifiers=none,Identifier=TimeDilation,DefaultModValue=1,LastValue=1,NoUpdate=false)
}