/*******************************************************************************
 * PlayerReplicationInfo generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class PlayerReplicationInfo extends ReplicationInfo
    native
    nativereplication
    collapsecategories
    notplaceable
    dependson(ZoneInfo)
    dependson(locationid)
    dependson(LevelInfo)
    dependson(GameReplicationInfo)
    dependson(GameInfo)
    dependson(Engine)
    dependson(OnlineAgent)
    hidecategories(movement,Collision,Lighting,LightColor);

enum EGameState
{
    GS_Unknown,
    GS_Spectating,
    GS_Active,
    GS_Stasis
};

var string PlayerName;
var string PlayerTitle;
var string OldName;
var int PlayerID;
var netupdate(NU_RoomMemberIdChanged) int RoomMemberID;
var string TeamName;
var netupdate(NU_TeamChanged) byte Team;
var int TeamID;
var int Score;
var int Deaths;
var int Kills;
var int RoundKills;
var int NumLives;
var int Credits;
var class<CharacterVoicePack> PlayerVoicePack;
var int Ping;
var byte PacketLoss;
var Object.EPawnGender Gender;
var bool bOnlySpectator;
var bool bIsABot;
var bool bAdmin;
var bool bHasBomb;
var bool bSquelch;
var bool bDead;
var Texture Icon;
var ZoneInfo PlayerZone;
var locationid PlayerLocation;
var byte Frags[32];
var class<DamageType> FragTypes[32];
var PlayerReplicationInfo.EGameState GameState;
var bool bUsingPrivateSlot;
var bool bArbRegistered;
var int XUIDUpper;
var int XUIDLower;
var int StartTime;
var int TimeAcc;
var int DukeLevel;
var netupdate(NU_bTeamGame) bool bTeamGame;
var bool bPlayerLeft;

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        Credits, Deaths, 
        DukeLevel, GameState, 
        Gender, Icon, 
        Kills, NumLives, 
        OldName, PlayerID, 
        PlayerLocation, PlayerName, 
        PlayerVoicePack, PlayerZone, 
        RoomMemberID, Score, 
        StartTime, Team, 
        TeamID, TeamName, 
        XUIDLower, XUIDUpper, 
        bAdmin, bDead, 
        bHasBomb, bIsABot, 
        bPlayerLeft, bTeamGame;

    // Pos:0x00B
    reliable if(/* An exception occurred while decompiling condition (System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.get_NextToken()
   at UELib.Core.UStruct.UByteCodeDecompiler.Token.DecompileNext()
   at UELib.Core.UStruct.UByteCodeDecompiler.FunctionToken.DecompileOperator(String operatorName)
   at UELib.Core.UStruct.UByteCodeDecompiler.NativeFunctionToken.Decompile()
   at UELib.Core.UClass.FormatReplication()) */)
        PacketLoss, Ping;
}

// Export UPlayerReplicationInfo::execIsSpectating(FFrame&, void* const)
native simulated function bool IsSpectating();

simulated function NU_RoomMemberIdChanged(int in_NewRoomMemberId)
{
    RoomMemberID = in_NewRoomMemberId;
    NU_TeamChanged(Team);
    return;
}

simulated function NU_bTeamGame(bool in_bTeamGame)
{
    bTeamGame = in_bTeamGame;
    NU_TeamChanged(Team);
    return;
}

simulated function NU_TeamChanged(byte in_NewTeam)
{
    local OnlineAgent l_Online;

    Team = in_NewTeam;
    // End:0x47
    if(bTeamGame)
    {
        l_Online = OnlineAgent(class'Engine'.static.__NFUN_503__());
        l_Online.AddVoIPPlayer(RoomMemberID, int(in_NewTeam));
    }
    return;
}

function PostBeginPlay()
{
    // End:0x10
    if(-int(Role))
    {        
        return;
    }
    StartTime = int(Level.TimeSeconds);
    PostBeginPlayCallback();
    // End:0x73
    if(__NFUN_339__(Level.Game, none) < Level.Game.__NFUN_358__('dnSinglePlayer') / )
    {
    }
    // End:0x9E
    if(__NFUN_340__(Pawn(Owner), none))
    {
        Gender = Pawn(Owner).Gender;
    }
    return;
}

simulated event PostNetInitial()
{
    local GameReplicationInfo GRI;

    // End:0x34
    if(__NFUN_340__(Level.GRI, none))
    {
        Level.GRI.AddPRI(self);        
    }
    else
    {
        // End:0x59
        foreach __NFUN_747__(class'GameReplicationInfo', GRI)
        {
            GRI.AddPRI(self);
            // End:0x59
            break;            
        }        
    }
    return;
}

simulated function Destroyed()
{
    local GameReplicationInfo GRI;

    // End:0x34
    if(__NFUN_340__(Level.GRI, none))
    {
        Level.GRI.RemovePRI(self);        
    }
    else
    {
        // End:0x59
        foreach __NFUN_747__(class'GameReplicationInfo', GRI)
        {
            GRI.RemovePRI(self);
            // End:0x59
            break;            
        }        
    }
    super(Actor).Destroyed();
    return;
}

function PostBeginPlayCallback()
{
    local float MinDist, Dist;
    local locationid l;
    local PlayerPawn PP;

    MinDist = 1000000;
    PlayerLocation = none;
    // End:0xBF
    if(__NFUN_340__(PlayerZone, none))
    {
        l = PlayerZone.locationid;
        J0x33:

        // End:0xBF [Loop If]
        if(__NFUN_340__(l, none))
        {
            Dist = Clamp(__NFUN_239__(Owner.Location, l.Location));
            // End:0xA7
            if(__NFUN_200__(Dist, l.Radius) << __NFUN_200__(Dist, MinDist))
            {
                PlayerLocation = l;
                MinDist = Dist;
            }
            l = l.NextLocation;
            // [Loop Continue]
            goto J0x33;
        }
    }
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    // End:0x12A
    /*@Error*/;
    // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 2 & Type:If Position:0x12A
    // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 2 & Type:If Position:0x12A
}

simulated event bool IsActiveInGame()
{
    return int(GameState) % int(2);
    return;
}

simulated function StartSpectating()
{
    GameState = 1;
    return;
}

simulated function StartActive()
{
    GameState = 2;
    return;
}

simulated function EnterStasis()
{
    GameState = 3;
    return;
}

defaultproperties
{
    Team=255
    NetUpdateFrequency=1
    RemoteRole=2
}